<?php
namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use Illuminate\Support\Facades\Hash;
use Spatie\Permission\Models\Role;

class UserController extends Controller
{
    public function index() {
        return User::with('roles')->paginate(25); // pagination
    }

    public function store(Request $r) {
        $r->validate([
            'name'=>'required',
            'email'=>'required|email|unique:users',
            'password'=>'nullable|string|min:6',
        ]);
        $user = User::create([
            'name' => $r->name,
            'email' => $r->email,
            'password' => isset($r->password) ? Hash::make($r->password) : Hash::make('12345678'),
            'nik'=>$r->nik, 'nuptk'=>$r->nuptk, 'terdaftar'=>$r->terdaftar,
            'jabatan'=>$r->jabatan, 'pegawai'=>$r->pegawai, 'status'=>$r->status ?? 'aktif'
        ]);
        if($r->role_id){
            $role = Role::find($r->role_id);
            if($role) $user->assignRole($role);
        }
        return response()->json($user->load('roles'));
    }

    public function show(User $user){ return response()->json($user->load('roles')); }

    public function update(Request $r, User $user){
        $r->validate([ 'email'=>"required|email|unique:users,email,{$user->id}" ]);
        $user->update($r->only(['name','email','nik','nuptk','terdaftar','jabatan','pegawai','status']));
        if($r->role_id){
            $role = Role::find($r->role_id);
            $user->syncRoles($role);
        }
        return response()->json($user->load('roles'));
    }

    public function destroy(User $user){
        $user->tokens()->delete();
        $user->delete();
        return response()->json(['message'=>'User dihapus']);
    }

    public function resetPassword(User $user){
        $user->update(['password'=>Hash::make('12345678')]);
        return response()->json(['message'=>'Password direset']);
    }
}
