<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\SchoolClass;

class SchoolClassController extends Controller
{
    public function index(Request $request)
    {
        $query = SchoolClass::query()->orderBy('id');
        if ($request->filled('id_school')) {
            $query->where('id_school', (int)$request->input('id_school'));
        }
        if ($request->filled('id_grade')) {
            $query->where('id_grade', (int)$request->input('id_grade'));
        }
        return response()->json($query->get());
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'id_school' => 'required|exists:schools,id',
            'id_grade' => 'required|exists:grades,id',
            'name' => 'required|string|max:255',
        ]);
        $kelas = SchoolClass::create($validated);
        return response()->json($kelas, 201);
    }

    public function show(SchoolClass $schoolClass)
    {
        return response()->json($schoolClass);
    }

    public function update(Request $request, SchoolClass $schoolClass)
    {
        $validated = $request->validate([
            'id_school' => 'required|exists:schools,id',
            'id_grade' => 'required|exists:grades,id',
            'name' => 'required|string|max:255',
        ]);
        $schoolClass->update($validated);
        return response()->json($schoolClass);
    }

    public function destroy(SchoolClass $schoolClass)
    {
        $schoolClass->delete();
        return response()->json(['message' => 'Deleted']);
    }
}