<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Spatie\Permission\Models\Role;

class RoleController extends Controller
{
    // Menampilkan semua roles
    public function index()
    {
        return response()->json(Role::all());
    }

    // Menambahkan role baru
    public function store(Request $request)
    {
        $request->validate(['name' => 'required|string|unique:roles,name']);
        $role = Role::create([
            'name' => $request->name,
            'guard_name' => config('auth.defaults.guard') ?? 'web',
        ]);
        return response()->json($role, 201);
    }

    // Menghapus role
    public function destroy($id)
    {
        $role = Role::findOrFail($id);
        $role->delete();
        return response()->json(['message' => 'Role deleted']);
    }
}
