<?php
// app/Http/Controllers/Api/PermissionController.php
namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Spatie\Permission\Models\Permission;

class PermissionController extends Controller
{
    public function index()
    {
        $permissions = Permission::all();
        return response()->json($permissions);
    }

    public function store(Request $request)
    {
        $request->validate(['name'=>'required|string|unique:permissions,name']);
        $permission = Permission::create([
            'name' => $request->name,
            'guard_name' => config('auth.defaults.guard') ?? 'web',
        ]);
        return response()->json($permission, 201);
    }

    public function destroy($id)
    {
        $permission = Permission::findOrFail($id);
        $permission->delete();
        return response()->json(['message'=>'Permission dihapus']);
    }
}
