<?php
namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Models\ExamParticipant;

class DashboardController extends Controller
{
    public function stats()
    {
        $roles = ['pegawai','guru','murid'];
        $thresholdMinutes = 15; // konsisten dengan tampilan Users.jsx

        $data = [];
        foreach ($roles as $role) {
            $total = User::role($role)->count();
            $online = User::role($role)
                ->whereNotNull('last_activity')
                ->where('last_activity', '>=', now()->subMinutes($thresholdMinutes))
                ->count();

            $data[$role] = [
                'online' => $online,
                'total' => $total,
            ];
        }

        // Tambahkan statistik Peserta Ujian (online/total)
        $participantsTotal = ExamParticipant::count();
        $participantsOnline = ExamParticipant::whereNotNull('last_activity')
            ->where('last_activity', '>=', now()->subMinutes($thresholdMinutes))
            ->count();
        $data['peserta'] = [
            'online' => $participantsOnline,
            'total' => $participantsTotal,
        ];

        return response()->json($data);
    }
}