# Redis Setup dan Caching Soal Ujian

## Konfigurasi Redis

### 1. Environment Variables
Update file `.env` dengan konfigurasi berikut:

```env
# Queue menggunakan Redis
QUEUE_CONNECTION=redis

# Cache menggunakan Redis
CACHE_STORE=redis

# Konfigurasi Redis
REDIS_CLIENT=phpredis
REDIS_HOST=127.0.0.1
REDIS_PASSWORD=null
REDIS_PORT=6379
```

### 2. Instalasi Redis Server
Pastikan Redis server sudah terinstall dan berjalan:

```bash
# macOS dengan Homebrew
brew install redis
brew services start redis

# Ubuntu/Debian
sudo apt update
sudo apt install redis-server
sudo systemctl start redis-server

# Cek status Redis
redis-cli ping
# Response: PONG
```

## Implementasi Caching Soal Ujian

### Fitur Caching
- **Kapan Cache Aktif**: Hanya saat ujian sedang berlangsung (antara `scheduled_at` dan `scheduled_at + duration_minutes`)
- **Cache Key**: `exam_questions_{exam_id}_subject_{subject_id}`
- **TTL**: Sampai ujian selesai + 5 menit buffer
- **Data yang Di-cache**: Soal ujian berdasarkan ID ujian dan subject

### Logika Caching
1. **Deteksi Ujian Aktif**: Cek apakah waktu sekarang berada dalam rentang ujian
2. **Cache Conditional**: 
   - Jika ujian aktif → gunakan Redis cache
   - Jika ujian tidak aktif → ambil langsung dari database
3. **Auto Expiry**: Cache otomatis expired setelah ujian selesai

### Endpoint yang Menggunakan Cache
- `GET /api/exam-sessions/{session}/detail` - Detail sesi ujian dengan soal-soal

## Queue Workers

### Menjalankan Queue Workers
```bash
# Worker untuk autosave (background)
php artisan queue:work redis --queue=autosave --daemon

# Worker untuk finalize (background)  
php artisan queue:work redis --queue=finalize --daemon

# Worker untuk default queue
php artisan queue:work redis --daemon
```

### Setup Cron untuk Queue Workers
Tambahkan ke crontab untuk memastikan workers selalu berjalan:

```bash
# Edit crontab
crontab -e

# Tambahkan baris berikut
* * * * * cd /path/to/project && flock -n /tmp/queue-autosave.lock php artisan queue:work redis --queue=autosave --stop-when-empty
* * * * * cd /path/to/project && flock -n /tmp/queue-finalize.lock php artisan queue:work redis --queue=finalize --stop-when-empty
```

## Monitoring dan Testing

### Cek Status Redis
```bash
# Koneksi ke Redis CLI
redis-cli

# Cek semua keys
KEYS *

# Cek cache soal ujian
KEYS exam_questions_*

# Cek queue jobs
LLEN queues:redis:autosave
LLEN queues:redis:finalize
```

### Testing Cache
1. Mulai ujian sebagai peserta
2. Akses endpoint `/api/exam-sessions/{session}/detail`
3. Cek Redis untuk memastikan cache tersimpan:
   ```bash
   redis-cli
   KEYS exam_questions_*
   TTL exam_questions_{exam_id}_subject_{subject_id}
   ```

### Performance Benefits
- **Reduced DB Load**: Soal ujian di-cache selama ujian berlangsung
- **Faster Response**: Akses soal lebih cepat dari Redis vs database query
- **Automatic Cleanup**: Cache otomatis expired setelah ujian selesai
- **Conditional Caching**: Hanya cache saat diperlukan (ujian aktif)

## Troubleshooting

### Redis Connection Error
```bash
# Cek status Redis
sudo systemctl status redis-server

# Restart Redis
sudo systemctl restart redis-server

# Cek log Redis
sudo tail -f /var/log/redis/redis-server.log
```

### Queue Jobs Stuck
```bash
# Clear failed jobs
php artisan queue:flush

# Restart queue workers
php artisan queue:restart

# Monitor queue
php artisan queue:monitor redis:autosave,redis:finalize
```

### Cache Issues
```bash
# Clear all cache
php artisan cache:clear

# Clear specific cache pattern
redis-cli --eval "return redis.call('del', unpack(redis.call('keys', ARGV[1])))" , exam_questions_*
```