export const canAccess = (user, permission) => {
  if (!user) return false;
  const perms = user.permissions || [];
  const roles = Array.isArray(user.roles)
    ? user.roles.map(r => (typeof r === 'string' ? r.toLowerCase() : String(r?.name || '').toLowerCase()))
    : [];

  // Grant full access for admin-like roles
  if (roles.includes('superadmin') || roles.includes('admin')) return true;

  return perms.includes(permission);
};
