import { useAuth } from "../context/AuthContext.jsx";

export function usePermission() {
  const { user } = useAuth();

  function can(permission) {
    if (!user || !user.permissions) return false;
    return user.permissions.includes(permission);
  }

  return { can, user };
}
