import React from 'react';

export default function PermissionCheckbox({ permission, checked, onToggle, disabled }) {
  return (
    <div
      onClick={() => !disabled && onToggle(permission.id)}
      style={{
        padding: '12px 20px',
        border: `2px solid ${checked ? '#28a745' : '#ccc'}`,
        borderRadius: '12px',
        cursor: disabled ? 'not-allowed' : 'pointer',
        opacity: disabled ? 0.5 : 1,
        minWidth: '140px',
        textAlign: 'center',
        backgroundColor: checked ? '#e6f4ea' : '#fff',
        transition: 'all 0.2s ease',
        userSelect: 'none'
      }}
    >
      {permission.name}
    </div>
  );
}
