import React from 'react';
import { isIOSBrowser, isStandaloneDisplayMode } from '../utils/fullscreenHelper';

export default function IOSA2HSBanner({ onDismiss }) {
  const isIOS = isIOSBrowser();
  const isStandalone = isStandaloneDisplayMode();
  if (!isIOS || isStandalone) return null;

  const styles = {
    wrap: {
      background: '#fff', border: '1px solid #e9ecef', borderRadius: 12,
      boxShadow: '0 8px 24px rgba(0,0,0,0.12)', padding: 16, marginBottom: 16
    },
    title: { fontWeight: 700, color: '#0d6efd', marginBottom: 6 },
    text: { color: '#495057', fontSize: 14 },
    steps: { color: '#343a40', fontSize: 14, marginTop: 8 },
    note: {
      background: 'rgba(13,110,253,0.08)', border: '1px solid #cfe2ff', color: '#084298',
      padding: '10px 12px', borderRadius: 8, marginTop: 10
    },
    actions: { display: 'flex', gap: 8, marginTop: 12, alignItems: 'center' }
  };

  return (
    <div style={styles.wrap} role="alert" aria-live="polite">
      <div style={styles.title}>Tambahkan ke Layar Utama untuk Mode Penuh</div>
      <div style={styles.text}>
        Anda menggunakan iPhone/iPad. Agar ujian benar‑benar fullscreen, tambahkan aplikasi ini ke Home Screen.
      </div>
      <div style={styles.steps}>
        • Safari: ketuk ikon Share → “Add to Home Screen” → Buka dari ikon.<br/>
        • Chrome iOS: ketuk menu ⋮ → “Add to Home Screen” → Buka dari ikon.
      </div>
      <div style={styles.note}>
        Setelah ditambahkan, buka aplikasi dari ikon Home Screen. Ujian akan berjalan tanpa bar atas/bawah.
      </div>
      <div style={styles.actions}>
        <button className="btn btn-primary btn-sm" onClick={() => { window.location.reload(); }}>
          Saya sudah menambahkan, muat ulang
        </button>
        {onDismiss && (
          <button className="btn btn-outline-secondary btn-sm" onClick={onDismiss}>
            Tutup sementara
          </button>
        )}
      </div>
    </div>
  );
}