import React from 'react';

export default class ErrorBoundary extends React.Component {
  constructor(props) {
    super(props);
    this.state = { hasError: false, error: null };
  }

  static getDerivedStateFromError(error) {
    return { hasError: true, error };
  }

  componentDidCatch(error, info) {
    // Optional: log to monitoring service
    // console.error('ErrorBoundary caught:', error, info);
  }

  handleRetry = () => {
    this.setState({ hasError: false, error: null });
    try {
      // Attempt soft reload by re-rendering children
      // As a fallback, do a full reload
      if (typeof window !== 'undefined') window.location.reload();
    } catch (_) {}
  };

  render() {
    if (this.state.hasError) {
      return (
        <div className="min-vh-100 d-flex align-items-center justify-content-center" style={{ background: '#f8fafc' }}>
          <div className="card shadow border-0" style={{ maxWidth: 520, width: '100%' }}>
            <div className="card-body p-4">
              <h5 className="fw-bold mb-2">Terjadi Kesalahan</h5>
              <p className="text-muted mb-3">Halaman tidak dapat dimuat dengan benar. Silakan coba lagi.</p>
              <button className="btn btn-primary" onClick={this.handleRetry}>Muat Ulang</button>
            </div>
          </div>
        </div>
      );
    }
    return this.props.children;
  }
}