import React from 'react';

export default function CardCheckbox({ role, checked, onChange, disabled, loading }) {
  return (
    <div
      onClick={() => !disabled && onChange(role.id)}
      style={{
        padding: '15px 25px',
        border: `2px solid ${checked ? '#007bff' : '#ccc'}`,
        borderRadius: '12px',
        cursor: disabled ? 'not-allowed' : 'pointer',
        opacity: disabled ? 0.5 : 1,
        minWidth: '140px',
        textAlign: 'center',
        backgroundColor: checked ? '#e7f1ff' : '#fff',
        position: 'relative'
      }}
    >
      {loading && <span style={{position:'absolute', top:5, right:5}}>⏳</span>}
      {role.name}
    </div>
  );
}
