/* 0.29.1 */
import type { Expression, MathJsonFunction, MathJsonIdentifier, MathJsonNumber, MathJsonString, MathJsonSymbol } from './types';
export declare const MISSING: Expression;
export declare function isNumberExpression(expr: Expression | null): expr is number | string | MathJsonNumber;
export declare function isNumberObject(expr: Expression | null): expr is MathJsonNumber;
export declare function isSymbolObject(expr: Expression | null): expr is MathJsonSymbol;
export declare function isStringObject(expr: Expression | null): expr is MathJsonString;
export declare function isFunctionObject(expr: Expression | null): expr is MathJsonFunction;
/**  If expr is a string literal, return it.
 *
 * A string literal is a JSON string that begins and ends with
 * **U+0027 APOSTROPHE** : **`'`** or an object literal with a `str` key.
 */
export declare function stringValue(expr: Expression | null | undefined): string | null;
export declare function stripText(expr: Expression | null | undefined): Expression | null;
/**
 * The operator of a function is an identifier
 *
 * Return an empty string if the expression is not a function.
 *
 * Examples:
 * * `["Negate", 5]`  -> `"Negate"`
 */
export declare function operator(expr: Expression | null | undefined): MathJsonIdentifier;
/**
 * Return the arguments of a function, or an empty array if not a function
 * or no arguments.
 */
export declare function operands(expr: Expression | null | undefined): ReadonlyArray<Expression>;
/** Return the nth operand of a function expression */
export declare function operand(expr: Expression | null, n: 1 | 2 | 3): Expression | null;
export declare function nops(expr: Expression | null | undefined): number;
export declare function unhold(expr: Expression | null): Expression | null;
export declare function symbol(expr: Expression | null | undefined): string | null;
export declare function dictionaryFromExpression(expr: Expression | null): null | Record<string, Expression>;
export declare function dictionaryFromEntries(dict: Record<string, Expression>): Expression;
/**
 *  CAUTION: `machineValue()` will return a truncated value if the number
 *  has a precision outside of the machine range.
 */
export declare function machineValue(expr: Expression | null | undefined): number | null;
/**
 * Return a rational (numer over denom) representation of the expression,
 * if possible, `null` otherwise.
 *
 * The expression can be:
 * - Some symbols: "Infinity", "Half"...
 * - ["Power", d, -1]
 * - ["Power", n, 1]
 * - ["Divide", n, d]
 *
 * The denominator is always > 0.
 */
export declare function rationalValue(expr: Expression | undefined | null): [number, number] | null;
export declare function subs(expr: Expression, s: {
    [symbol: string]: Expression;
}): Expression;
/**
 * Apply a function to the arguments of a function and return an array of T
 */
export declare function mapArgs<T>(expr: Expression, fn: (x: Expression) => T): T[];
/**
 * Assuming that op is an associative operator, fold lhs or rhs
 * if either are the same operator.
 */
export declare function foldAssociativeOperator(op: string, lhs: Expression, rhs: Expression): Expression;
/** Return the elements of a sequence, or null if the expression is not a sequence. The sequence can be optionally enclosed by a`["Delimiter"]` expression  */
export declare function getSequence(expr: Expression | null | undefined): ReadonlyArray<Expression> | null;
/** `Nothing` or the empty sequence (`["Sequence"]`) */
export declare function isEmptySequence(expr: Expression | null | undefined): expr is null | undefined;
export declare function missingIfEmpty(expr: Expression | null | undefined): Expression;
/** The number of leaves (atomic expressions) in the expression */
export declare function countLeaves(expr: Expression | null): number;
