/* 0.29.1 */
import { Complex } from 'complex-esm';
import { BoxedExpression, ComputeEngine, DataTypeMap, TensorDataType } from '../global-types';
/** @category Tensors */
export declare function makeTensorField<DT extends keyof DataTypeMap>(ce: ComputeEngine, dtype: DT): TensorField<DataTypeMap[DT]>;
/** @category Tensors */
export interface TensorField<T extends number | Complex | BoxedExpression | boolean | string = number> {
    readonly one: T;
    readonly zero: T;
    readonly nan: T;
    cast(x: T, dtype: 'float64'): undefined | number;
    cast(x: T, dtype: 'float32'): undefined | number;
    cast(x: T, dtype: 'int32'): undefined | number;
    cast(x: T, dtype: 'uint8'): undefined | number;
    cast(x: T, dtype: 'complex128'): undefined | Complex;
    cast(x: T, dtype: 'complex64'): undefined | Complex;
    cast(x: T, dtype: 'bool'): undefined | boolean;
    cast(x: T, dtype: 'string'): undefined | string;
    cast(x: T, dtype: 'expression'): undefined | BoxedExpression;
    cast(x: T[], dtype: 'float64'): undefined | number[];
    cast(x: T[], dtype: 'float32'): undefined | number[];
    cast(x: T[], dtype: 'int32'): undefined | number[];
    cast(x: T[], dtype: 'uint8'): undefined | number[];
    cast(x: T[], dtype: 'complex128'): undefined | Complex[];
    cast(x: T[], dtype: 'complex64'): undefined | Complex[];
    cast(x: T[], dtype: 'bool'): undefined | boolean[];
    cast(x: T[], dtype: 'string'): undefined | string[];
    cast(x: T[], dtype: 'expression'): undefined | BoxedExpression[];
    cast(x: T | T[], dtype: TensorDataType): undefined | Complex | number | boolean | string | BoxedExpression | Complex[] | number[] | boolean[] | string[] | BoxedExpression[];
    expression(x: T): BoxedExpression;
    isZero(x: T): boolean;
    isOne(x: T): boolean;
    equals(lhs: T, rhs: T): boolean;
    add(lhs: T, rhs: T): T;
    addn(...xs: T[]): T;
    neg(x: T): T;
    sub(lhs: T, rhs: T): T;
    mul(lhs: T, rhs: T): T;
    muln(...xs: T[]): T;
    div(lhs: T, rhs: T): T;
    pow(rhs: T, n: number): T;
    conjugate(x: T): T;
}
/** @category Tensors */
export declare class TensorFieldNumber implements TensorField<number> {
    private ce;
    one: number;
    zero: number;
    nan: number;
    constructor(ce: ComputeEngine);
    cast(x: number, dtype: 'float64'): undefined | number;
    cast(x: number, dtype: 'float32'): undefined | number;
    cast(x: number, dtype: 'int32'): undefined | number;
    cast(x: number, dtype: 'uint8'): undefined | number;
    cast(x: number, dtype: 'complex128'): undefined | Complex;
    cast(x: number, dtype: 'complex64'): undefined | Complex;
    cast(x: number, dtype: 'bool'): undefined | boolean;
    cast(x: number, dtype: 'string'): undefined | string;
    cast(x: number, dtype: 'expression'): undefined | BoxedExpression;
    cast(x: number[], dtype: 'float64'): undefined | number[];
    cast(x: number[], dtype: 'float32'): undefined | number[];
    cast(x: number[], dtype: 'int32'): undefined | number[];
    cast(x: number[], dtype: 'uint8'): undefined | number[];
    cast(x: number[], dtype: 'complex128'): undefined | Complex[];
    cast(x: number[], dtype: 'complex64'): undefined | Complex[];
    cast(x: number[], dtype: 'bool'): undefined | boolean[];
    cast(x: number[], dtype: 'string'): undefined | string[];
    cast(x: number[], dtype: 'expression'): undefined | BoxedExpression[];
    expression(x: number): BoxedExpression;
    isZero(x: number): boolean;
    isOne(x: number): boolean;
    equals(lhs: number, rhs: number): boolean;
    add(lhs: number, rhs: number): number;
    addn(...xs: number[]): number;
    neg(x: number): number;
    sub(lhs: number, rhs: number): number;
    mul(lhs: number, rhs: number): number;
    muln(...xs: number[]): number;
    div(lhs: number, rhs: number): number;
    pow(lhs: number, rhs: number): number;
    conjugate(x: number): number;
}
/** @category Tensors */
export declare class TensorFieldExpression implements TensorField<BoxedExpression> {
    one: BoxedExpression;
    zero: BoxedExpression;
    nan: BoxedExpression;
    private ce;
    constructor(ce: ComputeEngine);
    cast(x: BoxedExpression, dtype: 'float64'): undefined | number;
    cast(x: BoxedExpression, dtype: 'float32'): undefined | number;
    cast(x: BoxedExpression, dtype: 'int32'): undefined | number;
    cast(x: BoxedExpression, dtype: 'uint8'): undefined | number;
    cast(x: BoxedExpression, dtype: 'complex128'): undefined | Complex;
    cast(x: BoxedExpression, dtype: 'complex64'): undefined | Complex;
    cast(x: BoxedExpression, dtype: 'bool'): undefined | boolean;
    cast(x: BoxedExpression, dtype: 'string'): undefined | string;
    cast(x: BoxedExpression, dtype: 'expression'): undefined | BoxedExpression;
    cast(x: BoxedExpression[], dtype: 'float64'): undefined | number[];
    cast(x: BoxedExpression[], dtype: 'float32'): undefined | number[];
    cast(x: BoxedExpression[], dtype: 'int32'): undefined | number[];
    cast(x: BoxedExpression[], dtype: 'uint8'): undefined | number[];
    cast(x: BoxedExpression[], dtype: 'complex128'): undefined | Complex[];
    cast(x: BoxedExpression[], dtype: 'complex64'): undefined | Complex[];
    cast(x: BoxedExpression[], dtype: 'bool'): undefined | boolean[];
    cast(x: BoxedExpression[], dtype: 'string'): undefined | string[];
    cast(x: BoxedExpression[], dtype: 'expression'): undefined | BoxedExpression[];
    expression(x: BoxedExpression): BoxedExpression;
    isZero(x: BoxedExpression): boolean;
    isOne(x: BoxedExpression): boolean;
    equals(lhs: BoxedExpression, rhs: BoxedExpression): boolean;
    add(lhs: BoxedExpression, rhs: BoxedExpression): BoxedExpression;
    addn(...xs: BoxedExpression[]): BoxedExpression;
    neg(x: BoxedExpression): BoxedExpression;
    sub(lhs: BoxedExpression, rhs: BoxedExpression): BoxedExpression;
    mul(lhs: BoxedExpression, rhs: BoxedExpression): BoxedExpression;
    muln(...xs: BoxedExpression[]): BoxedExpression;
    div(lhs: BoxedExpression, rhs: BoxedExpression): BoxedExpression;
    pow(lhs: BoxedExpression, rhs: number): BoxedExpression;
    conjugate(x: BoxedExpression): BoxedExpression;
}
/** @category Tensors */
export declare class TensorFieldComplex implements TensorField<Complex> {
    one: Complex;
    zero: Complex;
    nan: Complex;
    private ce;
    constructor(ce: ComputeEngine);
    cast(x: Complex, dtype: 'float64'): undefined | number;
    cast(x: Complex, dtype: 'float32'): undefined | number;
    cast(x: Complex, dtype: 'int32'): undefined | number;
    cast(x: Complex, dtype: 'uint8'): undefined | number;
    cast(x: Complex, dtype: 'complex128'): undefined | Complex;
    cast(x: Complex, dtype: 'complex64'): undefined | Complex;
    cast(x: Complex, dtype: 'bool'): undefined | boolean;
    cast(x: Complex, dtype: 'string'): undefined | string;
    cast(x: Complex, dtype: 'expression'): undefined | BoxedExpression;
    cast(x: Complex[], dtype: 'float64'): undefined | number[];
    cast(x: Complex[], dtype: 'float32'): undefined | number[];
    cast(x: Complex[], dtype: 'int32'): undefined | number[];
    cast(x: Complex[], dtype: 'uint8'): undefined | number[];
    cast(x: Complex[], dtype: 'complex128'): undefined | Complex[];
    cast(x: Complex[], dtype: 'complex64'): undefined | Complex[];
    cast(x: Complex[], dtype: 'bool'): undefined | boolean[];
    cast(x: Complex[], dtype: 'string'): undefined | string[];
    cast(x: Complex[], dtype: 'expression'): undefined | BoxedExpression[];
    expression(z: Complex): BoxedExpression;
    isZero(z: Complex): boolean;
    isOne(z: Complex): boolean;
    equals(lhs: Complex, rhs: Complex): boolean;
    add(lhs: Complex, rhs: Complex): Complex;
    addn(...xs: Complex[]): Complex;
    neg(z: Complex): Complex;
    sub(lhs: Complex, rhs: Complex): Complex;
    mul(lhs: Complex, rhs: Complex): Complex;
    muln(...xs: Complex[]): Complex;
    div(lhs: Complex, rhs: Complex): Complex;
    pow(lhs: Complex, rhs: number): Complex;
    conjugate(z: Complex): Complex;
}
/**
 * @category Tensors
 * @internal
 */
export declare function getSupertype(t1: TensorDataType | undefined, t2: TensorDataType): TensorDataType;
/**
 * @category Tensors
 * @internal
 */
export declare function getExpressionDatatype(expr: BoxedExpression): TensorDataType;
