/* 0.29.1 */
import type { BoxedExpression } from '../global-types';
/**
 *
 * @param fn The function to differentiate, a `["Function"]` expression or
 * an identifier for a function name.
 *
 * @param degrees
 * @returns a function expression representing the derivative of `fn` with
 * respect to the variables in `degrees`.
 */
export declare function derivative(fn: BoxedExpression, order: number): BoxedExpression | undefined;
/**
 * Calculate the partial derivative of an expression with respect to a
 * variable, `v`.
 *
 * All expressions that do not explicitly depend on `v` are taken to have zero
 * partial derivative.
 *
 */
export declare function differentiate(expr: BoxedExpression, v: string): BoxedExpression | undefined;
