/* 0.29.1 */
import { Rational, SmallInteger } from './types';
export declare function isRational(x: any | null): x is Rational;
export declare function isMachineRational(x: any | null): x is [SmallInteger, SmallInteger];
export declare function isBigRational(x: any | null): x is [bigint, bigint];
export declare function isZero(x: Rational): boolean;
export declare function isPositive(x: Rational): boolean;
export declare function isOne(x: Rational): boolean;
export declare function isNegativeOne(x: Rational): boolean;
export declare function isInteger(x: Rational): boolean;
export declare function machineNumerator(x: Rational): number;
export declare function machineDenominator(x: Rational): number;
export declare function rationalAsFloat(x: Rational): number;
export declare function isNeg(x: Rational): boolean;
export declare function div(lhs: Rational, rhs: Rational): Rational;
/**
 * Add a literal numeric value to a rational.
 * If the rational is a bigint, this is a hint to do the calculation in bigint
 * (no need to check `bignumPreferred()`).
 * @param lhs
 * @param rhs
 * @returns
 */
export declare function add(lhs: Rational, rhs: Rational): Rational;
export declare function mul(lhs: Rational, rhs: Rational): Rational;
export declare function neg(x: [SmallInteger, SmallInteger]): [SmallInteger, SmallInteger];
export declare function neg(x: [bigint, bigint]): [bigint, bigint];
export declare function neg(x: Rational): Rational;
export declare function inverse(x: [SmallInteger, SmallInteger]): [SmallInteger, SmallInteger];
export declare function inverse(x: [bigint, bigint]): [bigint, bigint];
export declare function inverse(x: Rational): Rational;
export declare function asMachineRational(r: Rational): [SmallInteger, SmallInteger];
export declare function pow(r: Rational, exp: SmallInteger): Rational;
export declare function sqrt(r: Rational): Rational | undefined;
export declare function rationalGcd(lhs: Rational, rhs: Rational): Rational;
export declare function reducedRational(r: [SmallInteger, SmallInteger]): [SmallInteger, SmallInteger];
export declare function reducedRational(r: [bigint, bigint]): [bigint, bigint];
export declare function reducedRational(r: Rational): Rational;
/** Return a rational approximation of x */
export declare function rationalize(x: number): [n: number, d: number] | number;
/** Return [factor, root] such that factor * sqrt(root) = sqrt(n)
 * when factor and root are rationals
 */
export declare function reduceRationalSquareRoot(n: Rational): [factor: Rational, root: number | bigint];
