/* 0.29.1 */
export declare const DEFAULT_PRECISION = 21;
export declare const MACHINE_PRECISION_BITS = 53;
export declare const MACHINE_PRECISION: number;
export declare const DEFAULT_TOLERANCE = 1e-10;
export declare const SMALL_INTEGER = 1000000;
/** The largest number of digits of a bigint */
export declare const MAX_BIGINT_DIGITS = 1024;
export declare const MAX_ITERATION = 1000000;
export declare const MAX_SYMBOLIC_TERMS = 200;
/**
 * Returns the smallest floating-point number greater than x.
 * Denormalized values may not be supported.
 */
export declare function nextUp(x: number): number;
export declare function nextDown(x: number): number;
/** Return `[factor, root]` such that
 * pow(n, 1/exponent) = factor * pow(root, 1/exponent)
 *
 * canonicalInteger(75, 2) -> [5, 3] = 5^2 * 3
 *
 */
export declare function canonicalInteger(n: number, exponent: number): readonly [factor: number, root: number];
export declare function gcd(a: number, b: number): number;
export declare function lcm(a: number, b: number): number;
export declare function factorial(n: number): number;
export declare function factorial2(n: number): number;
export declare function chop(n: number, tolerance?: number): 0 | number;
/**
 * An 8th-order centered difference approximation can be used to get a highly
 * accurate approximation of the first derivative of a function.
 * The formula for the 8th-order centered difference approximation for the
 * first derivative is given by:
 *
 * $$ f'(x) \approx \frac{1}{280h} \left[ -f(x-4h) + \frac{4}{3}f(x-3h) - \frac{1}{5}f(x-2h) + \frac{8}{5}f(x-h) - \frac{8}{5}f(x+h) + \frac{1}{5}f(x+2h) - \frac{4}{3}f(x+3h) + f(x+4h) \right]$$
 *
 * Note: Mathematica uses an 8th order approximation for the first derivative
 *
 * f: the function
 * x: the point at which to approximate the derivative
 * h: the step size
 *
 * See https://en.wikipedia.org/wiki/Finite_difference_coefficient
 */
export declare function centeredDiff8thOrder(f: (number: any) => number, x: number, h?: number): number;
/**
 *
 * @param f
 * @param x
 * @param dir Direction of approach: > 0 for right, < 0 for left, 0 for both
 * @returns
 */
export declare function limit(f: (x: number) => number, x: number, dir?: number): number;
