/* 0.29.1 */
import { Decimal } from 'decimal.js';
import { BigNumFactory, NumericValue, NumericValueData } from './types';
import { ExactNumericValue } from './exact-numeric-value';
import { Expression } from '../../math-json/types';
import { SmallInteger } from '../numerics/types';
import { NumericType } from '../../common/type/types';
export declare class BigNumericValue extends NumericValue {
    __brand: 'BigNumericValue';
    decimal: Decimal;
    im: number;
    bignum: BigNumFactory;
    constructor(value: number | Decimal | NumericValueData, bignum: BigNumFactory);
    get type(): NumericType;
    get isExact(): boolean;
    get asExact(): ExactNumericValue | undefined;
    toJSON(): Expression;
    toString(): string;
    clone(value: number | Decimal | NumericValueData): BigNumericValue;
    private _makeExact;
    get re(): number;
    get bignumRe(): Decimal;
    get numerator(): BigNumericValue;
    get denominator(): ExactNumericValue;
    get isNaN(): boolean;
    get isPositiveInfinity(): boolean;
    get isNegativeInfinity(): boolean;
    get isComplexInfinity(): boolean;
    get isZero(): boolean;
    isZeroWithTolerance(tolerance: number | Decimal): boolean;
    get isOne(): boolean;
    get isNegativeOne(): boolean;
    sgn(): -1 | 0 | 1 | undefined;
    N(): NumericValue;
    neg(): BigNumericValue;
    inv(): BigNumericValue;
    add(other: number | NumericValue): NumericValue;
    sub(other: NumericValue): NumericValue;
    mul(other: number | Decimal | NumericValue): NumericValue;
    div(other: SmallInteger | NumericValue): NumericValue;
    pow(exponent: number | NumericValue | {
        re: number;
        im: number;
    }): NumericValue;
    root(exp: number): NumericValue;
    sqrt(): NumericValue;
    gcd(other: NumericValue): NumericValue;
    abs(): NumericValue;
    ln(base?: number): NumericValue;
    exp(): NumericValue;
    floor(): NumericValue;
    ceil(): NumericValue;
    round(): NumericValue;
    eq(other: number | NumericValue): boolean;
    lt(other: number | NumericValue): boolean | undefined;
    lte(other: number | NumericValue): boolean | undefined;
    gt(other: number | NumericValue): boolean | undefined;
    gte(other: number | NumericValue): boolean | undefined;
}
