/* 0.29.1 */
import type { BoxedExpression } from '../global-types';
export type IndexingSet = {
    index: string | undefined;
    lower: number;
    upper: number;
    isFinite: boolean;
};
/**
 * IndexingSet is an expression describing an index variable
 * and a range of values for that variable.
 *
 * Note that when this function is called the indexing set is assumed to be canonical: 'Hold' has been handled, the indexing set is a tuple, and the bounds are canonical.
 *
 * This can take several valid forms:
 * - a symbol, e.g. `n`, the upper and lower bounds are assumed ot be infinity
 * - a tuple, e.g. `["Pair", "n", 1]` or `["Tuple", "n", 1, 10]` with one
 *   or two bounds
 *
 * The result is a normalized version that includes the index, the lower and
 * upper bounds of the range, and a flag indicating whether the range is finite.
 * @param indexingSet
 * @returns
 */
export declare function normalizeIndexingSet(indexingSet: BoxedExpression): IndexingSet;
export declare function normalizeIndexingSets(ops: ReadonlyArray<BoxedExpression>): IndexingSet[];
export declare function indexingSetCartesianProduct(indexingSets: IndexingSet[]): number[][];
/**
 * Calculates the cartesian product of two arrays.
 * ```ts
 * // Example usage
 * const array1 = [1, 2, 3];
 * const array2 = ['a', 'b', 'c'];
 * const result = cartesianProduct(array1, array2);
 * console.log(result);
 * // Output: [[1, 'a'], [1, 'b'], [1, 'c'], [2, 'a'], [2, 'b'], [2, 'c'], [3, 'a'], [3, 'b'], [3, 'c']]
 * ```
 * @param array1 - The first array.
 * @param array2 - The second array.
 * @returns The cartesian product as a 2D array.
 */
export declare function cartesianProduct(array1: number[], array2: number[]): number[][];
export declare function canonicalIndexingSet(expr: BoxedExpression): BoxedExpression | undefined;
export declare function canonicalBigop(operator: string, body: BoxedExpression, indexingSets: BoxedExpression[]): BoxedExpression | null;
/**
 * Process an expression of the form
 * - ['Operator', body, ['Tuple', index1, lower, upper]]
 * - ['Operator', body, ['Tuple', index1, lower, upper], ['Tuple', index2, lower, upper], ...]
 * - ['Operator', body]
 * - ['Operator', collection]
 *
 * `fn()` is the processing done on each element
 * Apply the function `fn` to the body of a big operator, according to the
 * indexing sets.
 */
export declare function reduceBigOp<T>(body: BoxedExpression, indexes: ReadonlyArray<BoxedExpression>, fn: (acc: T, x: BoxedExpression) => T | null, initial: T): Generator<T | undefined>;
