/* 0.29.1 */
import type { BoxedExpression, ComputeEngine, IdentifierDefinitions } from '../global-types';
export declare const DEFAULT_LINSPACE_COUNT = 50;
export declare const COLLECTIONS_LIBRARY: IdentifierDefinitions;
/**
 * Normalize the arguments of range:
 * - [from, to] -> [from, to, 1] if to > from, or [from, to, -1] if to < from
 * - [x] -> [1, x]
 * - arguments rounded to integers
 *
 */
export declare function range(expr: BoxedExpression): [lower: number, upper: number, step: number];
/** Return the last value in the range
 * - could be less that lower if step is negative
 * - could be less than upper if step is positive, for
 * example `rangeLast([1, 6, 2])` = 5
 */
export declare function rangeLast(r: [lower: number, upper: number, step: number]): number;
/**
 * This function is used to reduce a collection of expressions to a single value. It
 * iterates over the collection, applying the given function to each element and the
 * accumulator. If the function returns `null`, the iteration is stopped and `undefined`
 * is returned. Otherwise, the result of the function is used as the new accumulator.
 * If the iteration completes, the final accumulator is returned.
 */
export declare function reduceCollection<T>(collection: BoxedExpression, fn: (acc: T, next: BoxedExpression) => T | null, initial: T): Generator<T | undefined>;
export declare function fromRange(start: number, end: number): number[];
export declare function canonicalDictionary(engine: ComputeEngine, dict: BoxedExpression): BoxedExpression;
