/* 0.29.1 */
/**
 * ## Reference
 * TeX source code:
 * {@link  http://tug.org/texlive/devsrc/Build/source/texk/web2c/tex.web | Tex.web}
 *
 */
export type Token = string;
/**
 * Create Tokens from a stream of LaTeX
 *
 * @param s - A string of LaTeX. It can include comments (with the `%`
 * marker) and multiple lines.
 */
export declare function tokenize(s: string, args?: string[]): Token[];
export declare function countTokens(s: string): number;
export declare function joinLatex(segments: Iterable<string>): string;
export declare function supsub(c: '_' | '^', body: string, x: string): string;
export declare function tokensToString(tokens: Token | Token[] | [Token[] | Token][]): string;
