/* 0.29.1 */
import { Expression } from '../../math-json/types';
import { NumberSerializationFormat } from './types';
/**
 * @param expr - A number, can be represented as a string
 *  (particularly useful for arbitrary precision numbers) or a number (-12.45)
 * @return A textual representation of the number, formatted according to the
 * `options`
 */
export declare function serializeNumber(expr: Expression | null, options: NumberSerializationFormat): string;
/**
 * `value` is a base-10 number, possibly a floating point number with an
 * exponent, i.e. "0.31415e1"
 */
/**
 * Return a C99 hex-float formated representation of the floating-point `value`.
 *
 * Does not handle integer and non-finite values.
 */
export declare function serializeHexFloat(value: number): string;
/**
 * Given a correctly formatted float hex, return the corresponding number.
 *
 * - "0xc.3p0" -> 12.1875
 * - "0x3.0Cp2" -> 12.1875
 * - "0x1.91eb851eb851fp+1" -> 3.14
 * - "0x3.23d70a3d70a3ep0" -> 3.14
 *
 */
export declare function deserializeHexFloat(value: string): number;
