/* 0.29.1 */
import { Expression, MathJsonIdentifier } from '../../math-json';
import { Parser } from './types';
/** For error handling, if we have a identifier prefix, assume
 * the identifier is invalid (it would have been captured by
 * `matchIdentifier()` otherwise) and return an error expression */
export declare function parseInvalidIdentifier(parser: Parser): Expression | null;
/**
 * Match an identifier.
 *
 * It can be:
 * - a sequence of emojis: `👍🏻👍🏻👍🏻`
 * - a single-letter: `a`
 * - some LaTeX commands: `\alpha`
 * - a multi-letter id with a prefix: `\operatorname{speed}`
 * - an id with multiple prefixes:
 *  `\mathbin{\mathsf{T}}`
 * - an id with modifiers:
 *    - `\mathrm{\alpha_{12}}` or
 *    - `\mathit{speed\unicode{"2012}of\unicode{"2012}sound}`
 */
export declare function parseIdentifier(parser: Parser): MathJsonIdentifier | null;
