/* 0.29.1 */
import { BoxedExpression, CollectionHandlers } from './global-types';
/** If a collection has fewer than this many elements, eagerly evaluate it.
 *
 * For example, evaluate the Union of two sets with 10 elements each will
 * result in a set with 20 elements.
 *
 * If the sum of the sizes of the two sets is greater than `MAX_SIZE_EAGER_COLLECTION`, the result is a Union expression
 *
 */
export declare const MAX_SIZE_EAGER_COLLECTION = 100;
export declare function isFiniteCollection(col: BoxedExpression): boolean;
export declare function isIndexableCollection(col: BoxedExpression): boolean;
export declare function isFiniteIndexableCollection(col: BoxedExpression): boolean;
/**
 *
 * Iterate over all the elements of a collection. If not a collection,
 * return the expression.
 *
 * The `col` argument is either a collection literal, or a symbol
 * whose value is a collection literal.
 *
 * Even infinite collections are iterable. Use `isFiniteCollection()`
 * to check if the collection is finite.
 *
 * The collection can have one of the following forms:
 * - `["Range"]`, `["Interval"]`, `["Linspace"]` expressions
 * - `["List"]` and `["Set"]` expressions
 * - `["Tuple"]`, `["Pair"]`, `["Pair"]`, `["Triple"]` expressions
 * - `["Sequence"]` expressions
 * ... and more
 *
 * In general, `each` is easier to use than `iterator`, but they do the same
 * thing.
 *
 * @param col - A potential collection
 *
 * @returns
 */
export declare function each(col: BoxedExpression): Generator<BoxedExpression>;
/**
 *
 * The `col` argument is either a collection literal, or a symbol
 * whose value is a collection literal.
 *
 * @returns
 */
export declare function length(col: BoxedExpression): number | undefined;
/**
 * From an expression, create an iterator that can be used
 * to enumerate values.
 *
 * `expr` should be a collection expression, or a string, or a symbol whose
 * value is a collection expression or a string.
 *
 * - ["Range", 5]
 * - ["List", 1, 2, 3]
 * - "'hello world'"
 *
 */
export declare function iterator(expr: BoxedExpression): Iterator<BoxedExpression> | undefined;
export declare function repeat(value: BoxedExpression, count?: number): Iterator<BoxedExpression>;
/**
 *
 * @param expr
 * @param index 1-based index
 * @returns
 */
export declare function at(expr: BoxedExpression, index: number): BoxedExpression | undefined;
export declare function defaultCollectionHandlers(def: undefined | Partial<CollectionHandlers>): Partial<CollectionHandlers> | undefined;
export declare function zip(items: ReadonlyArray<BoxedExpression>): Iterator<BoxedExpression[]>;
