/* 0.29.1 */
import type { BoxedExpression } from '../global-types';
/**
 * Structural equality of boxed expressions.
 */
export declare function same(a: BoxedExpression, b: BoxedExpression): boolean;
/**
 * Mathematical equality of two boxed expressions.
 *
 * In general, it is impossible to always prove equality
 * ([Richardson's theorem](https://en.wikipedia.org/wiki/Richardson%27s_theorem)) but this works often...
 */
export declare function eq(a: BoxedExpression, inputB: number | BoxedExpression): boolean | undefined;
export declare function cmp(a: BoxedExpression, b: number | BoxedExpression): '<' | '=' | '>' | '>=' | '<=' | undefined;
