/* 0.29.1 */
import type { Expression } from '../../math-json/types';
import { NumericValue } from '../numeric-value/types';
import { _BoxedExpression } from './abstract-boxed-expression';
import { AbstractTensor } from '../tensor/tensors';
import { BoxedType } from '../../common/type/boxed-type';
import type { ComputeEngine, TensorDataType, Metadata, BoxedBaseDefinition, BoxedFunctionDefinition, BoxedSubstitution, EvaluateOptions, TensorData, BoxedExpression, SimplifyOptions, PatternMatchOptions } from '../global-types';
/**
 * A boxed tensor represents an expression that can be represented by a tensor.
 * This could be a vector, matrix or multi-dimensional array.
 *
 * The object can be created either from a tensor or from an expression that
 * can be represented as a tensor.
 *
 * The structural counterpart (expression if input is tensor, or tensor
 * if input is expression) is created lazily.
 *
 */
export declare class BoxedTensor extends _BoxedExpression {
    readonly options?: {
        metadata?: Metadata;
        canonical?: boolean;
    };
    private _tensor;
    private readonly _operator?;
    private readonly _ops?;
    private _expression;
    constructor(ce: ComputeEngine, input: {
        op?: string;
        ops: ReadonlyArray<BoxedExpression>;
    } | AbstractTensor<'expression'>, options?: {
        metadata?: Metadata;
        canonical?: boolean;
    });
    get structural(): BoxedExpression;
    /** Create the tensor on demand */
    get tensor(): AbstractTensor<'expression'>;
    get baseDefinition(): BoxedBaseDefinition | undefined;
    get functionDefinition(): BoxedFunctionDefinition | undefined;
    bind(): void;
    reset(): void;
    get hash(): number;
    get canonical(): BoxedExpression;
    get isCanonical(): boolean;
    set isCanonical(val: boolean);
    get isPure(): boolean;
    get isValid(): boolean;
    get complexity(): number;
    get operator(): string;
    get nops(): number;
    get ops(): ReadonlyArray<BoxedExpression>;
    get op1(): BoxedExpression;
    get op2(): BoxedExpression;
    get op3(): BoxedExpression;
    neg(): BoxedExpression;
    inv(): BoxedExpression;
    abs(): BoxedExpression;
    add(rhs: number | BoxedExpression): BoxedExpression;
    sub(rhs: BoxedExpression): BoxedExpression;
    mul(rhs: NumericValue | number | BoxedExpression): BoxedExpression;
    div(rhs: number | BoxedExpression): BoxedExpression;
    pow(exp: number | BoxedExpression): BoxedExpression;
    root(exp: number | BoxedExpression): BoxedExpression;
    sqrt(): BoxedExpression;
    get shape(): number[];
    get rank(): number;
    get type(): BoxedType;
    get json(): Expression;
    /** Mathematical equality */
    isEqual(rhs: number | BoxedExpression): boolean | undefined;
    get isCollection(): boolean;
    contains(rhs: BoxedExpression): boolean;
    get size(): number;
    each(start?: number, count?: number): Iterator<BoxedExpression, undefined>;
    at(_index: number): BoxedExpression | undefined;
    indexOf(_expr: BoxedExpression): number;
    match(pattern: BoxedExpression, options?: PatternMatchOptions): BoxedSubstitution | null;
    evaluate(options?: Partial<EvaluateOptions>): BoxedExpression;
    simplify(options?: Partial<SimplifyOptions>): BoxedExpression;
    N(): BoxedExpression;
}
export declare function isBoxedTensor(val: unknown): val is BoxedTensor;
export declare function expressionTensorInfo(operator: string, rows: ReadonlyArray<BoxedExpression>): {
    shape: number[];
    dtype: TensorDataType | undefined;
} | undefined;
export declare function expressionAsTensor<T extends TensorDataType = 'expression'>(operator: string, rows: ReadonlyArray<BoxedExpression>): TensorData<T> | undefined;
