/* 0.29.1 */
import type { BoxedExpression } from '../global-types';
import type { Rational } from '../numerics/types';
export declare function asRadical(expr: BoxedExpression): Rational | null;
export declare function canonicalPower(a: BoxedExpression, b: BoxedExpression): BoxedExpression;
export declare function canonicalRoot(a: BoxedExpression, b: BoxedExpression | number): BoxedExpression;
/**
 * The power function.
 *
 * It follows the same conventions as SymPy, which do not always
 * conform to IEEE 754 floating point arithmetic.
 *
 * See https://docs.sympy.org/latest/modules/core.html#sympy.core.power.Pow
 *
 */
export declare function pow(x: BoxedExpression, exp: number | BoxedExpression, { numericApproximation }: {
    numericApproximation: boolean;
}): BoxedExpression;
export declare function root(a: BoxedExpression, b: BoxedExpression, { numericApproximation }: {
    numericApproximation: boolean;
}): BoxedExpression;
