/* 0.29.1 */
import type { BoxedExpression, ComputeEngine } from '../global-types';
/**
 * Canonical form of 'Divide' (and 'Rational')
 * - remove denominator of 1
 * - simplify the signs
 * - factor out negate (make the numerator and denominator positive)
 * - if numerator and denominator are integer literals, return a rational number
 *   or Rational expression
 * - evaluate number literals
 */
export declare function canonicalDivide(op1: BoxedExpression, op2: BoxedExpression): BoxedExpression;
export declare function div(num: BoxedExpression, denom: number | BoxedExpression): BoxedExpression;
/**
 * The canonical form of `Multiply`:
 * - removes `1` anb `-1`
 * - simplifies the signs:
 *    - i.e. `-y \times -x` -> `x \times y`
 *    - `2 \times -x` -> `-2 \times x`
 * - arguments are sorted
 * - complex numbers promoted (['Multiply', 2, 'ImaginaryUnit'] -> 2i)
 * - Numeric values are promoted (['Multiply', 2, 'Sqrt', 3] -> 2√3)
 *
 * The input ops may not be canonical, the result is canonical.
 */
export declare function canonicalMultiply(ce: ComputeEngine, ops: ReadonlyArray<BoxedExpression>): BoxedExpression;
export declare function mul(...xs: ReadonlyArray<BoxedExpression>): BoxedExpression;
export declare function mulN(...xs: ReadonlyArray<BoxedExpression>): BoxedExpression;
