/* 0.29.1 */
import type { Type, FunctionSignature, TypeString } from './types';
/** Convert two or more types into a more specific type that is a subtype of
 *  all the input types. The resulting type is usually more constrained and
 *  only encompasses values that belong to both input types.
 *
 * Examples:
 * narrow('integer', 'rational') => 'integer'
 * narrow('number', 'complex') => 'complex'
 * narrow('number', 'collection') => 'nothing'
 * narrow('number', 'value') => 'value'
 * narrow('number', 'expression') => 'expression'
 * narrow('number', 'string') => 'nothing'
 *
 *
 */
export declare function narrow(...types: Readonly<Type>[]): Type;
/**
 * Convert two or more types into a broader, more general type that can
 * accommodate all the input types. The resulting type is usually a supertype
 * that encompasses the possible values of the input types
 *
 * Examples:
 * widen('integer', 'rational') => 'rational'
 * widen('number', 'complex') => 'complex'
 * widen('number', 'collection') => 'collection'
 * widen('number', 'value') => 'value'
 * widen('number', 'expression') => 'expression'
 * widen('number', 'string') => 'any'
 */
export declare function widen(...types: Readonly<Type>[]): Readonly<Type>;
export declare function isSignatureType(type: Readonly<Type> | TypeString): type is FunctionSignature;
export declare function functionSignature(type: Readonly<Type>): Type | undefined;
export declare function functionResult(type: Readonly<Type> | undefined): Type | undefined;
export declare function collectionElementType(type: Readonly<Type>): Type | undefined;
export declare function isValidType(t: any): t is Readonly<Type>;
