/** Compute Engine 0.29.1 */
    (function(global,factory){typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports) : typeof define === 'function' && define.amd ? define(['exports'],factory):(global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.ComputeEngine = {}));})(this, (function (exports) { 'use strict';
var ComputeEngine = (() => {
  var __defProp = Object.defineProperty;
  var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
  var __getOwnPropNames = Object.getOwnPropertyNames;
  var __hasOwnProp = Object.prototype.hasOwnProperty;
  var __export = (target, all) => {
    for (var name in all)
      __defProp(target, name, { get: all[name], enumerable: true });
  };
  var __copyProps = (to, from, except, desc) => {
    if (from && typeof from === "object" || typeof from === "function") {
      for (let key of __getOwnPropNames(from))
        if (!__hasOwnProp.call(to, key) && key !== except)
          __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
    }
    return to;
  };
  var __toCommonJS = (mod2) => __copyProps(__defProp({}, "__esModule", { value: true }), mod2);

  // src/compute-engine.ts
  var compute_engine_exports = {};
  __export(compute_engine_exports, {
    AbstractTensor: () => AbstractTensor,
    BoxedType: () => BoxedType,
    ComputeEngine: () => ComputeEngine,
    DEFAULT_LATEX_DICTIONARY: () => DEFAULT_LATEX_DICTIONARY,
    NumericValue: () => NumericValue,
    TensorFieldComplex: () => TensorFieldComplex,
    TensorFieldExpression: () => TensorFieldExpression,
    TensorFieldNumber: () => TensorFieldNumber,
    getExpressionDatatype: () => getExpressionDatatype,
    getLatexDictionary: () => getLatexDictionary,
    getSupertype: () => getSupertype,
    indexLatexDictionary: () => indexLatexDictionary,
    isIndexedEnvironmentEntry: () => isIndexedEnvironmentEntry,
    isIndexedExpressionEntry: () => isIndexedExpressionEntry,
    isIndexedFunctionEntry: () => isIndexedFunctionEntry,
    isIndexedInfixdEntry: () => isIndexedInfixdEntry,
    isIndexedMatchfixEntry: () => isIndexedMatchfixEntry,
    isIndexedPostfixEntry: () => isIndexedPostfixEntry,
    isIndexedPrefixedEntry: () => isIndexedPrefixedEntry,
    isIndexedSymbolEntry: () => isIndexedSymbolEntry,
    makeTensor: () => makeTensor,
    makeTensorField: () => makeTensorField,
    version: () => version
  });

  // node_modules/complex-esm/dist/src/complex.js
  var cosh = Math.cosh || function(x) {
    return Math.abs(x) < 1e-9 ? 1 - x : (Math.exp(x) + Math.exp(-x)) * 0.5;
  };
  var sinh = Math.sinh || function(x) {
    return Math.abs(x) < 1e-9 ? x : (Math.exp(x) - Math.exp(-x)) * 0.5;
  };
  var cosm1 = function(x) {
    var b = Math.PI / 4;
    if (-b > x || x > b) {
      return Math.cos(x) - 1;
    }
    var xx = x * x;
    return xx * (xx * (xx * (xx * (xx * (xx * (xx * (xx / 20922789888e3 - 1 / 87178291200) + 1 / 479001600) - 1 / 3628800) + 1 / 40320) - 1 / 720) + 1 / 24) - 1 / 2);
  };
  var hypot = function(x, y) {
    var a = Math.abs(x);
    var b = Math.abs(y);
    if (a < 3e3 && b < 3e3) {
      return Math.sqrt(a * a + b * b);
    }
    if (a < b) {
      a = b;
      b = x / y;
    } else {
      b = y / x;
    }
    return a * Math.sqrt(1 + b * b);
  };
  var parser_exit = function() {
    throw SyntaxError("Invalid Param");
  };
  function logHypot(a, b) {
    var _a = Math.abs(a);
    var _b = Math.abs(b);
    if (a === 0) {
      return Math.log(_b);
    }
    if (b === 0) {
      return Math.log(_a);
    }
    if (_a < 3e3 && _b < 3e3) {
      return Math.log(a * a + b * b) * 0.5;
    }
    a = a / 2;
    b = b / 2;
    return 0.5 * Math.log(a * a + b * b) + Math.LN2;
  }
  var parse = function(a, b) {
    var z = { "re": 0, "im": 0 };
    if (a === void 0 || a === null) {
      z["re"] = z["im"] = 0;
    } else if (b !== void 0) {
      z["re"] = a;
      z["im"] = b;
    } else
      switch (typeof a) {
        case "object":
          if ("im" in a && "re" in a) {
            z["re"] = a["re"];
            z["im"] = a["im"];
          } else if ("abs" in a && "arg" in a) {
            if (!Number.isFinite(a["abs"]) && Number.isFinite(a["arg"])) {
              return Complex["INFINITY"];
            }
            z["re"] = a["abs"] * Math.cos(a["arg"]);
            z["im"] = a["abs"] * Math.sin(a["arg"]);
          } else if ("r" in a && "phi" in a) {
            if (!Number.isFinite(a["r"]) && Number.isFinite(a["phi"])) {
              return Complex["INFINITY"];
            }
            z["re"] = a["r"] * Math.cos(a["phi"]);
            z["im"] = a["r"] * Math.sin(a["phi"]);
          } else if (a.length === 2) {
            z["re"] = a[0];
            z["im"] = a[1];
          } else {
            parser_exit();
          }
          break;
        case "string":
          z["im"] = /* void */
          z["re"] = 0;
          var tokens = a.match(/\d+\.?\d*e[+-]?\d+|\d+\.?\d*|\.\d+|./g);
          var plus = 1;
          var minus = 0;
          if (tokens === null) {
            parser_exit();
          }
          for (var i = 0; i < tokens.length; i++) {
            var c = tokens[i];
            if (c === " " || c === "	" || c === "\n") {
            } else if (c === "+") {
              plus++;
            } else if (c === "-") {
              minus++;
            } else if (c === "i" || c === "I") {
              if (plus + minus === 0) {
                parser_exit();
              }
              if (tokens[i + 1] !== " " && !isNaN(Number(tokens[i + 1]))) {
                z["im"] += parseFloat((minus % 2 ? "-" : "") + tokens[i + 1]);
                i++;
              } else {
                z["im"] += parseFloat((minus % 2 ? "-" : "") + "1");
              }
              plus = minus = 0;
            } else {
              if (plus + minus === 0 || isNaN(Number(c))) {
                parser_exit();
              }
              if (tokens[i + 1] === "i" || tokens[i + 1] === "I") {
                z["im"] += parseFloat((minus % 2 ? "-" : "") + c);
                i++;
              } else {
                z["re"] += parseFloat((minus % 2 ? "-" : "") + c);
              }
              plus = minus = 0;
            }
          }
          if (plus + minus > 0) {
            parser_exit();
          }
          break;
        case "number":
          z["im"] = 0;
          z["re"] = a;
          break;
        default:
          parser_exit();
      }
    if (isNaN(z["re"]) || isNaN(z["im"])) {
    }
    return z;
  };
  var Complex = class _Complex {
    constructor(a, b) {
      this.re = 0;
      this.im = 0;
      var z = parse(a, b);
      this["re"] = z["re"];
      this["im"] = z["im"];
    }
    /**
     * Calculates the sign of a complex number, which is a normalized complex
     *
     * @returns {Complex}
     */
    sign() {
      var abs2 = this["abs"]();
      return new _Complex(this["re"] / abs2, this["im"] / abs2);
    }
    /**
     * Adds two complex numbers
     *
     * @returns {Complex}
     */
    add(a, b) {
      var z = new _Complex(a, b);
      if (this["isInfinite"]() && z["isInfinite"]()) {
        return _Complex["NAN"];
      }
      if (this["isInfinite"]() || z["isInfinite"]()) {
        return _Complex["INFINITY"];
      }
      return new _Complex(this["re"] + z["re"], this["im"] + z["im"]);
    }
    /**
     * Subtracts two complex numbers
     *
     * @returns {Complex}
     */
    sub(a, b) {
      var z = new _Complex(a, b);
      if (this["isInfinite"]() && z["isInfinite"]()) {
        return _Complex["NAN"];
      }
      if (this["isInfinite"]() || z["isInfinite"]()) {
        return _Complex["INFINITY"];
      }
      return new _Complex(this["re"] - z["re"], this["im"] - z["im"]);
    }
    /**
     * Multiplies two complex numbers
     *
     * @returns {Complex}
     */
    mul(a, b) {
      var z = new _Complex(a, b);
      if (this["isInfinite"]() && z["isZero"]() || this["isZero"]() && z["isInfinite"]()) {
        return _Complex["NAN"];
      }
      if (this["isInfinite"]() || z["isInfinite"]()) {
        return _Complex["INFINITY"];
      }
      if (z["im"] === 0 && this["im"] === 0) {
        return new _Complex(this["re"] * z["re"], 0);
      }
      return new _Complex(this["re"] * z["re"] - this["im"] * z["im"], this["re"] * z["im"] + this["im"] * z["re"]);
    }
    /**
     * Divides two complex numbers
     *
     * @returns {Complex}
     */
    div(a, b) {
      var z = new _Complex(a, b);
      if (this["isZero"]() && z["isZero"]() || this["isInfinite"]() && z["isInfinite"]()) {
        return _Complex["NAN"];
      }
      if (this["isInfinite"]() || z["isZero"]()) {
        return _Complex["INFINITY"];
      }
      if (this["isZero"]() || z["isInfinite"]()) {
        return _Complex["ZERO"];
      }
      a = this["re"];
      b = this["im"];
      var c = z["re"];
      var d = z["im"];
      var t, x;
      if (0 === d) {
        return new _Complex(a / c, b / c);
      }
      if (Math.abs(c) < Math.abs(d)) {
        x = c / d;
        t = c * x + d;
        return new _Complex((a * x + b) / t, (b * x - a) / t);
      } else {
        x = d / c;
        t = d * x + c;
        return new _Complex((a + b * x) / t, (b - a * x) / t);
      }
    }
    /**
     * Calculate the power of two complex numbers
     *
     * @returns {Complex}
     */
    pow(a, b) {
      var z = new _Complex(a, b);
      a = this["re"];
      b = this["im"];
      if (z["isZero"]()) {
        return _Complex["ONE"];
      }
      if (z["im"] === 0) {
        if (b === 0 && a > 0) {
          return new _Complex(Math.pow(a, z["re"]), 0);
        } else if (a === 0) {
          switch ((z["re"] % 4 + 4) % 4) {
            case 0:
              return new _Complex(Math.pow(b, z["re"]), 0);
            case 1:
              return new _Complex(0, Math.pow(b, z["re"]));
            case 2:
              return new _Complex(-Math.pow(b, z["re"]), 0);
            case 3:
              return new _Complex(0, -Math.pow(b, z["re"]));
          }
        }
      }
      if (a === 0 && b === 0 && z["re"] > 0 && z["im"] >= 0) {
        return _Complex["ZERO"];
      }
      var arg = Math.atan2(b, a);
      var loh = logHypot(a, b);
      a = Math.exp(z["re"] * loh - z["im"] * arg);
      b = z["im"] * loh + z["re"] * arg;
      return new _Complex(a * Math.cos(b), a * Math.sin(b));
    }
    /**
     * Calculate the complex square root
     *
     * @returns {Complex}
     */
    sqrt() {
      var a = this["re"];
      var b = this["im"];
      var r = this["abs"]();
      var re, im;
      if (a >= 0) {
        if (b === 0) {
          return new _Complex(Math.sqrt(a), 0);
        }
        re = 0.5 * Math.sqrt(2 * (r + a));
      } else {
        re = Math.abs(b) / Math.sqrt(2 * (r - a));
      }
      if (a <= 0) {
        im = 0.5 * Math.sqrt(2 * (r - a));
      } else {
        im = Math.abs(b) / Math.sqrt(2 * (r + a));
      }
      return new _Complex(re, b < 0 ? -im : im);
    }
    /**
     * Calculate the complex exponent
     *
     * @returns {Complex}
     */
    exp() {
      var tmp = Math.exp(this["re"]);
      if (this["im"] === 0) {
      }
      return new _Complex(tmp * Math.cos(this["im"]), tmp * Math.sin(this["im"]));
    }
    /**
     * Calculate the complex exponent and subtracts one.
     *
     * This may be more accurate than `Complex(x).exp().sub(1)` if
     * `x` is small.
     *
     * @returns {Complex}
     */
    expm1() {
      var a = this["re"];
      var b = this["im"];
      return new _Complex(Math.expm1(a) * Math.cos(b) + cosm1(b), Math.exp(a) * Math.sin(b));
    }
    /**
     * Calculate the natural log
     *
     * @returns {Complex}
     */
    log() {
      var a = this["re"];
      var b = this["im"];
      if (b === 0 && a > 0) {
      }
      return new _Complex(logHypot(a, b), Math.atan2(b, a));
    }
    /**
     * Calculate the magnitude of the complex number
     *
     * @returns {number}
     */
    abs() {
      return hypot(this["re"], this["im"]);
    }
    /**
     * Calculate the angle of the complex number
     *
     * @returns {number}
     */
    arg() {
      return Math.atan2(this["im"], this["re"]);
    }
    /**
     * Calculate the sine of the complex number
     *
     * @returns {Complex}
     */
    sin() {
      var a = this["re"];
      var b = this["im"];
      return new _Complex(Math.sin(a) * cosh(b), Math.cos(a) * sinh(b));
    }
    /**
     * Calculate the cosine
     *
     * @returns {Complex}
     */
    cos() {
      var a = this["re"];
      var b = this["im"];
      return new _Complex(Math.cos(a) * cosh(b), -Math.sin(a) * sinh(b));
    }
    /**
     * Calculate the tangent
     *
     * @returns {Complex}
     */
    tan() {
      var a = 2 * this["re"];
      var b = 2 * this["im"];
      var d = Math.cos(a) + cosh(b);
      return new _Complex(Math.sin(a) / d, sinh(b) / d);
    }
    /**
     * Calculate the cotangent
     *
     * @returns {Complex}
     */
    cot() {
      var a = 2 * this["re"];
      var b = 2 * this["im"];
      var d = Math.cos(a) - cosh(b);
      return new _Complex(-Math.sin(a) / d, sinh(b) / d);
    }
    /**
     * Calculate the secant
     *
     * @returns {Complex}
     */
    sec() {
      var a = this["re"];
      var b = this["im"];
      var d = 0.5 * cosh(2 * b) + 0.5 * Math.cos(2 * a);
      return new _Complex(Math.cos(a) * cosh(b) / d, Math.sin(a) * sinh(b) / d);
    }
    /**
     * Calculate the cosecans
     *
     * @returns {Complex}
     */
    csc() {
      var a = this["re"];
      var b = this["im"];
      var d = 0.5 * cosh(2 * b) - 0.5 * Math.cos(2 * a);
      return new _Complex(Math.sin(a) * cosh(b) / d, -Math.cos(a) * sinh(b) / d);
    }
    /**
     * Calculate the complex arcus sinus
     *
     * @returns {Complex}
     */
    asin() {
      var a = this["re"];
      var b = this["im"];
      var t1 = new _Complex(b * b - a * a + 1, -2 * a * b)["sqrt"]();
      var t2 = new _Complex(t1["re"] - b, t1["im"] + a)["log"]();
      return new _Complex(t2["im"], -t2["re"]);
    }
    /**
     * Calculate the complex arcus cosinus
     *
     * @returns {Complex}
     */
    acos() {
      var a = this["re"];
      var b = this["im"];
      var t1 = new _Complex(b * b - a * a + 1, -2 * a * b)["sqrt"]();
      var t2 = new _Complex(t1["re"] - b, t1["im"] + a)["log"]();
      return new _Complex(Math.PI / 2 - t2["im"], t2["re"]);
    }
    /**
     * Calculate the complex arcus tangent
     *
     * @returns {Complex}
     */
    atan() {
      var a = this["re"];
      var b = this["im"];
      if (a === 0) {
        if (b === 1) {
          return new _Complex(0, Infinity);
        }
        if (b === -1) {
          return new _Complex(0, -Infinity);
        }
      }
      var d = a * a + (1 - b) * (1 - b);
      var t1 = new _Complex((1 - b * b - a * a) / d, -2 * a / d).log();
      return new _Complex(-0.5 * t1["im"], 0.5 * t1["re"]);
    }
    /**
     * Calculate the complex arcus cotangent
     *
     * @returns {Complex}
     */
    acot() {
      var a = this["re"];
      var b = this["im"];
      if (b === 0) {
        return new _Complex(Math.atan2(1, a), 0);
      }
      var d = a * a + b * b;
      return d !== 0 ? new _Complex(a / d, -b / d).atan() : new _Complex(a !== 0 ? a / 0 : 0, b !== 0 ? -b / 0 : 0).atan();
    }
    /**
     * Calculate the complex arcus secant
     *
     * @returns {Complex}
     */
    asec() {
      var a = this["re"];
      var b = this["im"];
      if (a === 0 && b === 0) {
        return new _Complex(0, Infinity);
      }
      var d = a * a + b * b;
      return d !== 0 ? new _Complex(a / d, -b / d).acos() : new _Complex(a !== 0 ? a / 0 : 0, b !== 0 ? -b / 0 : 0).acos();
    }
    /**
     * Calculate the complex arcus cosecans
     *
     * @returns {Complex}
     */
    acsc() {
      var a = this["re"];
      var b = this["im"];
      if (a === 0 && b === 0) {
        return new _Complex(Math.PI / 2, Infinity);
      }
      var d = a * a + b * b;
      return d !== 0 ? new _Complex(a / d, -b / d).asin() : new _Complex(a !== 0 ? a / 0 : 0, b !== 0 ? -b / 0 : 0).asin();
    }
    /**
     * Calculate the complex sinh
     *
     * @returns {Complex}
     */
    sinh() {
      var a = this["re"];
      var b = this["im"];
      return new _Complex(sinh(a) * Math.cos(b), cosh(a) * Math.sin(b));
    }
    /**
     * Calculate the complex cosh
     *
     * @returns {Complex}
     */
    cosh() {
      var a = this["re"];
      var b = this["im"];
      return new _Complex(cosh(a) * Math.cos(b), sinh(a) * Math.sin(b));
    }
    /**
     * Calculate the complex tanh
     *
     * @returns {Complex}
     */
    tanh() {
      var a = 2 * this["re"];
      var b = 2 * this["im"];
      var d = cosh(a) + Math.cos(b);
      return new _Complex(sinh(a) / d, Math.sin(b) / d);
    }
    /**
     * Calculate the complex coth
     *
     * @returns {Complex}
     */
    coth() {
      var a = 2 * this["re"];
      var b = 2 * this["im"];
      var d = cosh(a) - Math.cos(b);
      return new _Complex(sinh(a) / d, -Math.sin(b) / d);
    }
    /**
     * Calculate the complex coth
     *
     * @returns {Complex}
     */
    csch() {
      var a = this["re"];
      var b = this["im"];
      var d = Math.cos(2 * b) - cosh(2 * a);
      return new _Complex(-2 * sinh(a) * Math.cos(b) / d, 2 * cosh(a) * Math.sin(b) / d);
    }
    /**
     * Calculate the complex sech
     *
     * @returns {Complex}
     */
    sech() {
      var a = this["re"];
      var b = this["im"];
      var d = Math.cos(2 * b) + cosh(2 * a);
      return new _Complex(2 * cosh(a) * Math.cos(b) / d, -2 * sinh(a) * Math.sin(b) / d);
    }
    /**
     * Calculate the complex asinh
     *
     * @returns {Complex}
     */
    asinh() {
      var tmp = this["im"];
      this["im"] = -this["re"];
      this["re"] = tmp;
      var res = this["asin"]();
      this["re"] = -this["im"];
      this["im"] = tmp;
      tmp = res["re"];
      res["re"] = -res["im"];
      res["im"] = tmp;
      return res;
    }
    /**
     * Calculate the complex acosh
     *
     * @returns {Complex}
     */
    acosh() {
      var res = this["acos"]();
      if (res["im"] <= 0) {
        var tmp = res["re"];
        res["re"] = -res["im"];
        res["im"] = tmp;
      } else {
        var tmp = res["im"];
        res["im"] = -res["re"];
        res["re"] = tmp;
      }
      return res;
    }
    /**
     * Calculate the complex atanh
     *
     * @returns {Complex}
     */
    atanh() {
      var a = this["re"];
      var b = this["im"];
      var noIM = a > 1 && b === 0;
      var oneMinus = 1 - a;
      var onePlus = 1 + a;
      var d = oneMinus * oneMinus + b * b;
      var x = d !== 0 ? new _Complex((onePlus * oneMinus - b * b) / d, (b * oneMinus + onePlus * b) / d) : new _Complex(a !== -1 ? a / 0 : 0, b !== 0 ? b / 0 : 0);
      var temp = x["re"];
      x["re"] = logHypot(x["re"], x["im"]) / 2;
      x["im"] = Math.atan2(x["im"], temp) / 2;
      if (noIM) {
        x["im"] = -x["im"];
      }
      return x;
    }
    /**
     * Calculate the complex acoth
     *
     * @returns {Complex}
     */
    acoth() {
      var a = this["re"];
      var b = this["im"];
      if (a === 0 && b === 0) {
        return new _Complex(0, Math.PI / 2);
      }
      var d = a * a + b * b;
      return d !== 0 ? new _Complex(a / d, -b / d).atanh() : new _Complex(a !== 0 ? a / 0 : 0, b !== 0 ? -b / 0 : 0).atanh();
    }
    /**
     * Calculate the complex acsch
     *
     * @returns {Complex}
     */
    acsch() {
      var a = this["re"];
      var b = this["im"];
      if (b === 0) {
        return new _Complex(a !== 0 ? Math.log(a + Math.sqrt(a * a + 1)) : Infinity, 0);
      }
      var d = a * a + b * b;
      return d !== 0 ? new _Complex(a / d, -b / d).asinh() : new _Complex(a !== 0 ? a / 0 : 0, b !== 0 ? -b / 0 : 0).asinh();
    }
    /**
     * Calculate the complex asech
     *
     * @returns {Complex}
     */
    asech() {
      var a = this["re"];
      var b = this["im"];
      if (this["isZero"]()) {
        return _Complex["INFINITY"];
      }
      var d = a * a + b * b;
      return d !== 0 ? new _Complex(a / d, -b / d).acosh() : new _Complex(a !== 0 ? a / 0 : 0, b !== 0 ? -b / 0 : 0).acosh();
    }
    /**
     * Calculate the complex inverse 1/z
     *
     * @returns {Complex}
     */
    inverse() {
      if (this["isZero"]()) {
        return _Complex["INFINITY"];
      }
      if (this["isInfinite"]()) {
        return _Complex["ZERO"];
      }
      var a = this["re"];
      var b = this["im"];
      var d = a * a + b * b;
      return new _Complex(a / d, -b / d);
    }
    /**
     * Returns the complex conjugate
     *
     * @returns {Complex}
     */
    conjugate() {
      return new _Complex(this["re"], -this["im"]);
    }
    /**
     * Gets the negated complex number
     *
     * @returns {Complex}
     */
    neg() {
      return new _Complex(-this["re"], -this["im"]);
    }
    /**
     * Ceils the actual complex number
     *
     * @returns {Complex}
     */
    ceil(places) {
      places = Math.pow(10, places || 0);
      return new _Complex(Math.ceil(this["re"] * places) / places, Math.ceil(this["im"] * places) / places);
    }
    /**
     * Floors the actual complex number
     *
     * @returns {Complex}
     */
    floor(places) {
      places = Math.pow(10, places || 0);
      return new _Complex(Math.floor(this["re"] * places) / places, Math.floor(this["im"] * places) / places);
    }
    /**
     * Ceils the actual complex number
     *
     * @returns {Complex}
     */
    round(places) {
      places = Math.pow(10, places || 0);
      return new _Complex(Math.round(this["re"] * places) / places, Math.round(this["im"] * places) / places);
    }
    /**
     * Compares two complex numbers
     *
     * **Note:** new Complex(Infinity).equals(Infinity) === false
     *
     * @returns {boolean}
     */
    equals(a, b) {
      var z = new _Complex(a, b);
      return Math.abs(z["re"] - this["re"]) <= _Complex["EPSILON"] && Math.abs(z["im"] - this["im"]) <= _Complex["EPSILON"];
    }
    /**
     * Clones the actual object
     *
     * @returns {Complex}
     */
    clone() {
      return new _Complex(this["re"], this["im"]);
    }
    /**
     * Gets a string of the actual complex number
     *
     * @returns {string}
     */
    toString() {
      var a = this["re"];
      var b = this["im"];
      var ret = "";
      if (this["isNaN"]()) {
        return "NaN";
      }
      if (this["isInfinite"]()) {
        return "Infinity";
      }
      if (Math.abs(a) < _Complex["EPSILON"]) {
        a = 0;
      }
      if (Math.abs(b) < _Complex["EPSILON"]) {
        b = 0;
      }
      if (b === 0) {
        return ret + a;
      }
      if (a !== 0) {
        ret += a;
        ret += " ";
        if (b < 0) {
          b = -b;
          ret += "-";
        } else {
          ret += "+";
        }
        ret += " ";
      } else if (b < 0) {
        b = -b;
        ret += "-";
      }
      if (1 !== b) {
        ret += b;
      }
      return ret + "i";
    }
    /**
     * Returns the actual number as a vector
     *
     * @returns {Array}
     */
    toVector() {
      return [this["re"], this["im"]];
    }
    /**
     * Returns the actual real value of the current object
     *
     * @returns {number|null}
     */
    valueOf() {
      if (this["im"] === 0) {
        return this["re"];
      }
      return null;
    }
    /**
     * Determines whether a complex number is not on the Riemann sphere.
     *
     * @returns {boolean}
     */
    isNaN() {
      return isNaN(this["re"]) || isNaN(this["im"]);
    }
    /**
     * Determines whether or not a complex number is at the zero pole of the
     * Riemann sphere.
     *
     * @returns {boolean}
     */
    isZero() {
      return this["im"] === 0 && this["re"] === 0;
    }
    /**
     * Determines whether a complex number is not at the infinity pole of the
     * Riemann sphere.
     *
     * @returns {boolean}
     */
    isFinite() {
      return isFinite(this["re"]) && isFinite(this["im"]);
    }
    /**
     * Determines whether or not a complex number is at the infinity pole of the
     * Riemann sphere.
     *
     * @returns {boolean}
     */
    isInfinite() {
      return !(this["isNaN"]() || this["isFinite"]());
    }
  };
  Complex["ZERO"] = new Complex(0, 0);
  Complex["ONE"] = new Complex(1, 0);
  Complex["I"] = new Complex(0, 1);
  Complex["PI"] = new Complex(Math.PI, 0);
  Complex["E"] = new Complex(Math.E, 0);
  Complex["INFINITY"] = new Complex(Infinity, Infinity);
  Complex["NAN"] = new Complex(NaN, NaN);
  Complex["EPSILON"] = 1e-15;

  // node_modules/decimal.js/decimal.mjs
  var EXP_LIMIT = 9e15;
  var MAX_DIGITS = 1e9;
  var NUMERALS = "0123456789abcdef";
  var LN10 = "2.3025850929940456840179914546843642076011014886287729760333279009675726096773524802359972050895982983419677840422862486334095254650828067566662873690987816894829072083255546808437998948262331985283935053089653777326288461633662222876982198867465436674744042432743651550489343149393914796194044002221051017141748003688084012647080685567743216228355220114804663715659121373450747856947683463616792101806445070648000277502684916746550586856935673420670581136429224554405758925724208241314695689016758940256776311356919292033376587141660230105703089634572075440370847469940168269282808481184289314848524948644871927809676271275775397027668605952496716674183485704422507197965004714951050492214776567636938662976979522110718264549734772662425709429322582798502585509785265383207606726317164309505995087807523710333101197857547331541421808427543863591778117054309827482385045648019095610299291824318237525357709750539565187697510374970888692180205189339507238539205144634197265287286965110862571492198849978748873771345686209167058";
  var PI = "3.1415926535897932384626433832795028841971693993751058209749445923078164062862089986280348253421170679821480865132823066470938446095505822317253594081284811174502841027019385211055596446229489549303819644288109756659334461284756482337867831652712019091456485669234603486104543266482133936072602491412737245870066063155881748815209209628292540917153643678925903600113305305488204665213841469519415116094330572703657595919530921861173819326117931051185480744623799627495673518857527248912279381830119491298336733624406566430860213949463952247371907021798609437027705392171762931767523846748184676694051320005681271452635608277857713427577896091736371787214684409012249534301465495853710507922796892589235420199561121290219608640344181598136297747713099605187072113499999983729780499510597317328160963185950244594553469083026425223082533446850352619311881710100031378387528865875332083814206171776691473035982534904287554687311595628638823537875937519577818577805321712268066130019278766111959092164201989380952572010654858632789";
  var DEFAULTS = {
    // These values must be integers within the stated ranges (inclusive).
    // Most of these values can be changed at run-time using the `Decimal.config` method.
    // The maximum number of significant digits of the result of a calculation or base conversion.
    // E.g. `Decimal.config({ precision: 20 });`
    precision: 20,
    // 1 to MAX_DIGITS
    // The rounding mode used when rounding to `precision`.
    //
    // ROUND_UP         0 Away from zero.
    // ROUND_DOWN       1 Towards zero.
    // ROUND_CEIL       2 Towards +Infinity.
    // ROUND_FLOOR      3 Towards -Infinity.
    // ROUND_HALF_UP    4 Towards nearest neighbour. If equidistant, up.
    // ROUND_HALF_DOWN  5 Towards nearest neighbour. If equidistant, down.
    // ROUND_HALF_EVEN  6 Towards nearest neighbour. If equidistant, towards even neighbour.
    // ROUND_HALF_CEIL  7 Towards nearest neighbour. If equidistant, towards +Infinity.
    // ROUND_HALF_FLOOR 8 Towards nearest neighbour. If equidistant, towards -Infinity.
    //
    // E.g.
    // `Decimal.rounding = 4;`
    // `Decimal.rounding = Decimal.ROUND_HALF_UP;`
    rounding: 4,
    // 0 to 8
    // The modulo mode used when calculating the modulus: a mod n.
    // The quotient (q = a / n) is calculated according to the corresponding rounding mode.
    // The remainder (r) is calculated as: r = a - n * q.
    //
    // UP         0 The remainder is positive if the dividend is negative, else is negative.
    // DOWN       1 The remainder has the same sign as the dividend (JavaScript %).
    // FLOOR      3 The remainder has the same sign as the divisor (Python %).
    // HALF_EVEN  6 The IEEE 754 remainder function.
    // EUCLID     9 Euclidian division. q = sign(n) * floor(a / abs(n)). Always positive.
    //
    // Truncated division (1), floored division (3), the IEEE 754 remainder (6), and Euclidian
    // division (9) are commonly used for the modulus operation. The other rounding modes can also
    // be used, but they may not give useful results.
    modulo: 1,
    // 0 to 9
    // The exponent value at and beneath which `toString` returns exponential notation.
    // JavaScript numbers: -7
    toExpNeg: -7,
    // 0 to -EXP_LIMIT
    // The exponent value at and above which `toString` returns exponential notation.
    // JavaScript numbers: 21
    toExpPos: 21,
    // 0 to EXP_LIMIT
    // The minimum exponent value, beneath which underflow to zero occurs.
    // JavaScript numbers: -324  (5e-324)
    minE: -EXP_LIMIT,
    // -1 to -EXP_LIMIT
    // The maximum exponent value, above which overflow to Infinity occurs.
    // JavaScript numbers: 308  (1.7976931348623157e+308)
    maxE: EXP_LIMIT,
    // 1 to EXP_LIMIT
    // Whether to use cryptographically-secure random number generation, if available.
    crypto: false
    // true/false
  };
  var inexact;
  var quadrant;
  var external = true;
  var decimalError = "[DecimalError] ";
  var invalidArgument = decimalError + "Invalid argument: ";
  var precisionLimitExceeded = decimalError + "Precision limit exceeded";
  var cryptoUnavailable = decimalError + "crypto unavailable";
  var tag = "[object Decimal]";
  var mathfloor = Math.floor;
  var mathpow = Math.pow;
  var isBinary = /^0b([01]+(\.[01]*)?|\.[01]+)(p[+-]?\d+)?$/i;
  var isHex = /^0x([0-9a-f]+(\.[0-9a-f]*)?|\.[0-9a-f]+)(p[+-]?\d+)?$/i;
  var isOctal = /^0o([0-7]+(\.[0-7]*)?|\.[0-7]+)(p[+-]?\d+)?$/i;
  var isDecimal = /^(\d+(\.\d*)?|\.\d+)(e[+-]?\d+)?$/i;
  var BASE = 1e7;
  var LOG_BASE = 7;
  var MAX_SAFE_INTEGER = 9007199254740991;
  var LN10_PRECISION = LN10.length - 1;
  var PI_PRECISION = PI.length - 1;
  var P = { toStringTag: tag };
  P.absoluteValue = P.abs = function() {
    var x = new this.constructor(this);
    if (x.s < 0) x.s = 1;
    return finalise(x);
  };
  P.ceil = function() {
    return finalise(new this.constructor(this), this.e + 1, 2);
  };
  P.clampedTo = P.clamp = function(min2, max2) {
    var k, x = this, Ctor = x.constructor;
    min2 = new Ctor(min2);
    max2 = new Ctor(max2);
    if (!min2.s || !max2.s) return new Ctor(NaN);
    if (min2.gt(max2)) throw Error(invalidArgument + max2);
    k = x.cmp(min2);
    return k < 0 ? min2 : x.cmp(max2) > 0 ? max2 : new Ctor(x);
  };
  P.comparedTo = P.cmp = function(y) {
    var i, j, xdL, ydL, x = this, xd = x.d, yd = (y = new x.constructor(y)).d, xs = x.s, ys = y.s;
    if (!xd || !yd) {
      return !xs || !ys ? NaN : xs !== ys ? xs : xd === yd ? 0 : !xd ^ xs < 0 ? 1 : -1;
    }
    if (!xd[0] || !yd[0]) return xd[0] ? xs : yd[0] ? -ys : 0;
    if (xs !== ys) return xs;
    if (x.e !== y.e) return x.e > y.e ^ xs < 0 ? 1 : -1;
    xdL = xd.length;
    ydL = yd.length;
    for (i = 0, j = xdL < ydL ? xdL : ydL; i < j; ++i) {
      if (xd[i] !== yd[i]) return xd[i] > yd[i] ^ xs < 0 ? 1 : -1;
    }
    return xdL === ydL ? 0 : xdL > ydL ^ xs < 0 ? 1 : -1;
  };
  P.cosine = P.cos = function() {
    var pr, rm, x = this, Ctor = x.constructor;
    if (!x.d) return new Ctor(NaN);
    if (!x.d[0]) return new Ctor(1);
    pr = Ctor.precision;
    rm = Ctor.rounding;
    Ctor.precision = pr + Math.max(x.e, x.sd()) + LOG_BASE;
    Ctor.rounding = 1;
    x = cosine(Ctor, toLessThanHalfPi(Ctor, x));
    Ctor.precision = pr;
    Ctor.rounding = rm;
    return finalise(quadrant == 2 || quadrant == 3 ? x.neg() : x, pr, rm, true);
  };
  P.cubeRoot = P.cbrt = function() {
    var e, m, n, r, rep, s, sd, t, t3, t3plusx, x = this, Ctor = x.constructor;
    if (!x.isFinite() || x.isZero()) return new Ctor(x);
    external = false;
    s = x.s * mathpow(x.s * x, 1 / 3);
    if (!s || Math.abs(s) == 1 / 0) {
      n = digitsToString(x.d);
      e = x.e;
      if (s = (e - n.length + 1) % 3) n += s == 1 || s == -2 ? "0" : "00";
      s = mathpow(n, 1 / 3);
      e = mathfloor((e + 1) / 3) - (e % 3 == (e < 0 ? -1 : 2));
      if (s == 1 / 0) {
        n = "5e" + e;
      } else {
        n = s.toExponential();
        n = n.slice(0, n.indexOf("e") + 1) + e;
      }
      r = new Ctor(n);
      r.s = x.s;
    } else {
      r = new Ctor(s.toString());
    }
    sd = (e = Ctor.precision) + 3;
    for (; ; ) {
      t = r;
      t3 = t.times(t).times(t);
      t3plusx = t3.plus(x);
      r = divide(t3plusx.plus(x).times(t), t3plusx.plus(t3), sd + 2, 1);
      if (digitsToString(t.d).slice(0, sd) === (n = digitsToString(r.d)).slice(0, sd)) {
        n = n.slice(sd - 3, sd + 1);
        if (n == "9999" || !rep && n == "4999") {
          if (!rep) {
            finalise(t, e + 1, 0);
            if (t.times(t).times(t).eq(x)) {
              r = t;
              break;
            }
          }
          sd += 4;
          rep = 1;
        } else {
          if (!+n || !+n.slice(1) && n.charAt(0) == "5") {
            finalise(r, e + 1, 1);
            m = !r.times(r).times(r).eq(x);
          }
          break;
        }
      }
    }
    external = true;
    return finalise(r, e, Ctor.rounding, m);
  };
  P.decimalPlaces = P.dp = function() {
    var w, d = this.d, n = NaN;
    if (d) {
      w = d.length - 1;
      n = (w - mathfloor(this.e / LOG_BASE)) * LOG_BASE;
      w = d[w];
      if (w) for (; w % 10 == 0; w /= 10) n--;
      if (n < 0) n = 0;
    }
    return n;
  };
  P.dividedBy = P.div = function(y) {
    return divide(this, new this.constructor(y));
  };
  P.dividedToIntegerBy = P.divToInt = function(y) {
    var x = this, Ctor = x.constructor;
    return finalise(divide(x, new Ctor(y), 0, 1, 1), Ctor.precision, Ctor.rounding);
  };
  P.equals = P.eq = function(y) {
    return this.cmp(y) === 0;
  };
  P.floor = function() {
    return finalise(new this.constructor(this), this.e + 1, 3);
  };
  P.greaterThan = P.gt = function(y) {
    return this.cmp(y) > 0;
  };
  P.greaterThanOrEqualTo = P.gte = function(y) {
    var k = this.cmp(y);
    return k == 1 || k === 0;
  };
  P.hyperbolicCosine = P.cosh = function() {
    var k, n, pr, rm, len, x = this, Ctor = x.constructor, one = new Ctor(1);
    if (!x.isFinite()) return new Ctor(x.s ? 1 / 0 : NaN);
    if (x.isZero()) return one;
    pr = Ctor.precision;
    rm = Ctor.rounding;
    Ctor.precision = pr + Math.max(x.e, x.sd()) + 4;
    Ctor.rounding = 1;
    len = x.d.length;
    if (len < 32) {
      k = Math.ceil(len / 3);
      n = (1 / tinyPow(4, k)).toString();
    } else {
      k = 16;
      n = "2.3283064365386962890625e-10";
    }
    x = taylorSeries(Ctor, 1, x.times(n), new Ctor(1), true);
    var cosh2_x, i = k, d8 = new Ctor(8);
    for (; i--; ) {
      cosh2_x = x.times(x);
      x = one.minus(cosh2_x.times(d8.minus(cosh2_x.times(d8))));
    }
    return finalise(x, Ctor.precision = pr, Ctor.rounding = rm, true);
  };
  P.hyperbolicSine = P.sinh = function() {
    var k, pr, rm, len, x = this, Ctor = x.constructor;
    if (!x.isFinite() || x.isZero()) return new Ctor(x);
    pr = Ctor.precision;
    rm = Ctor.rounding;
    Ctor.precision = pr + Math.max(x.e, x.sd()) + 4;
    Ctor.rounding = 1;
    len = x.d.length;
    if (len < 3) {
      x = taylorSeries(Ctor, 2, x, x, true);
    } else {
      k = 1.4 * Math.sqrt(len);
      k = k > 16 ? 16 : k | 0;
      x = x.times(1 / tinyPow(5, k));
      x = taylorSeries(Ctor, 2, x, x, true);
      var sinh2_x, d5 = new Ctor(5), d16 = new Ctor(16), d20 = new Ctor(20);
      for (; k--; ) {
        sinh2_x = x.times(x);
        x = x.times(d5.plus(sinh2_x.times(d16.times(sinh2_x).plus(d20))));
      }
    }
    Ctor.precision = pr;
    Ctor.rounding = rm;
    return finalise(x, pr, rm, true);
  };
  P.hyperbolicTangent = P.tanh = function() {
    var pr, rm, x = this, Ctor = x.constructor;
    if (!x.isFinite()) return new Ctor(x.s);
    if (x.isZero()) return new Ctor(x);
    pr = Ctor.precision;
    rm = Ctor.rounding;
    Ctor.precision = pr + 7;
    Ctor.rounding = 1;
    return divide(x.sinh(), x.cosh(), Ctor.precision = pr, Ctor.rounding = rm);
  };
  P.inverseCosine = P.acos = function() {
    var x = this, Ctor = x.constructor, k = x.abs().cmp(1), pr = Ctor.precision, rm = Ctor.rounding;
    if (k !== -1) {
      return k === 0 ? x.isNeg() ? getPi(Ctor, pr, rm) : new Ctor(0) : new Ctor(NaN);
    }
    if (x.isZero()) return getPi(Ctor, pr + 4, rm).times(0.5);
    Ctor.precision = pr + 6;
    Ctor.rounding = 1;
    x = new Ctor(1).minus(x).div(x.plus(1)).sqrt().atan();
    Ctor.precision = pr;
    Ctor.rounding = rm;
    return x.times(2);
  };
  P.inverseHyperbolicCosine = P.acosh = function() {
    var pr, rm, x = this, Ctor = x.constructor;
    if (x.lte(1)) return new Ctor(x.eq(1) ? 0 : NaN);
    if (!x.isFinite()) return new Ctor(x);
    pr = Ctor.precision;
    rm = Ctor.rounding;
    Ctor.precision = pr + Math.max(Math.abs(x.e), x.sd()) + 4;
    Ctor.rounding = 1;
    external = false;
    x = x.times(x).minus(1).sqrt().plus(x);
    external = true;
    Ctor.precision = pr;
    Ctor.rounding = rm;
    return x.ln();
  };
  P.inverseHyperbolicSine = P.asinh = function() {
    var pr, rm, x = this, Ctor = x.constructor;
    if (!x.isFinite() || x.isZero()) return new Ctor(x);
    pr = Ctor.precision;
    rm = Ctor.rounding;
    Ctor.precision = pr + 2 * Math.max(Math.abs(x.e), x.sd()) + 6;
    Ctor.rounding = 1;
    external = false;
    x = x.times(x).plus(1).sqrt().plus(x);
    external = true;
    Ctor.precision = pr;
    Ctor.rounding = rm;
    return x.ln();
  };
  P.inverseHyperbolicTangent = P.atanh = function() {
    var pr, rm, wpr, xsd, x = this, Ctor = x.constructor;
    if (!x.isFinite()) return new Ctor(NaN);
    if (x.e >= 0) return new Ctor(x.abs().eq(1) ? x.s / 0 : x.isZero() ? x : NaN);
    pr = Ctor.precision;
    rm = Ctor.rounding;
    xsd = x.sd();
    if (Math.max(xsd, pr) < 2 * -x.e - 1) return finalise(new Ctor(x), pr, rm, true);
    Ctor.precision = wpr = xsd - x.e;
    x = divide(x.plus(1), new Ctor(1).minus(x), wpr + pr, 1);
    Ctor.precision = pr + 4;
    Ctor.rounding = 1;
    x = x.ln();
    Ctor.precision = pr;
    Ctor.rounding = rm;
    return x.times(0.5);
  };
  P.inverseSine = P.asin = function() {
    var halfPi, k, pr, rm, x = this, Ctor = x.constructor;
    if (x.isZero()) return new Ctor(x);
    k = x.abs().cmp(1);
    pr = Ctor.precision;
    rm = Ctor.rounding;
    if (k !== -1) {
      if (k === 0) {
        halfPi = getPi(Ctor, pr + 4, rm).times(0.5);
        halfPi.s = x.s;
        return halfPi;
      }
      return new Ctor(NaN);
    }
    Ctor.precision = pr + 6;
    Ctor.rounding = 1;
    x = x.div(new Ctor(1).minus(x.times(x)).sqrt().plus(1)).atan();
    Ctor.precision = pr;
    Ctor.rounding = rm;
    return x.times(2);
  };
  P.inverseTangent = P.atan = function() {
    var i, j, k, n, px, t, r, wpr, x2, x = this, Ctor = x.constructor, pr = Ctor.precision, rm = Ctor.rounding;
    if (!x.isFinite()) {
      if (!x.s) return new Ctor(NaN);
      if (pr + 4 <= PI_PRECISION) {
        r = getPi(Ctor, pr + 4, rm).times(0.5);
        r.s = x.s;
        return r;
      }
    } else if (x.isZero()) {
      return new Ctor(x);
    } else if (x.abs().eq(1) && pr + 4 <= PI_PRECISION) {
      r = getPi(Ctor, pr + 4, rm).times(0.25);
      r.s = x.s;
      return r;
    }
    Ctor.precision = wpr = pr + 10;
    Ctor.rounding = 1;
    k = Math.min(28, wpr / LOG_BASE + 2 | 0);
    for (i = k; i; --i) x = x.div(x.times(x).plus(1).sqrt().plus(1));
    external = false;
    j = Math.ceil(wpr / LOG_BASE);
    n = 1;
    x2 = x.times(x);
    r = new Ctor(x);
    px = x;
    for (; i !== -1; ) {
      px = px.times(x2);
      t = r.minus(px.div(n += 2));
      px = px.times(x2);
      r = t.plus(px.div(n += 2));
      if (r.d[j] !== void 0) for (i = j; r.d[i] === t.d[i] && i--; ) ;
    }
    if (k) r = r.times(2 << k - 1);
    external = true;
    return finalise(r, Ctor.precision = pr, Ctor.rounding = rm, true);
  };
  P.isFinite = function() {
    return !!this.d;
  };
  P.isInteger = P.isInt = function() {
    return !!this.d && mathfloor(this.e / LOG_BASE) > this.d.length - 2;
  };
  P.isNaN = function() {
    return !this.s;
  };
  P.isNegative = P.isNeg = function() {
    return this.s < 0;
  };
  P.isPositive = P.isPos = function() {
    return this.s > 0;
  };
  P.isZero = function() {
    return !!this.d && this.d[0] === 0;
  };
  P.lessThan = P.lt = function(y) {
    return this.cmp(y) < 0;
  };
  P.lessThanOrEqualTo = P.lte = function(y) {
    return this.cmp(y) < 1;
  };
  P.logarithm = P.log = function(base) {
    var isBase10, d, denominator, k, inf, num, sd, r, arg = this, Ctor = arg.constructor, pr = Ctor.precision, rm = Ctor.rounding, guard = 5;
    if (base == null) {
      base = new Ctor(10);
      isBase10 = true;
    } else {
      base = new Ctor(base);
      d = base.d;
      if (base.s < 0 || !d || !d[0] || base.eq(1)) return new Ctor(NaN);
      isBase10 = base.eq(10);
    }
    d = arg.d;
    if (arg.s < 0 || !d || !d[0] || arg.eq(1)) {
      return new Ctor(d && !d[0] ? -1 / 0 : arg.s != 1 ? NaN : d ? 0 : 1 / 0);
    }
    if (isBase10) {
      if (d.length > 1) {
        inf = true;
      } else {
        for (k = d[0]; k % 10 === 0; ) k /= 10;
        inf = k !== 1;
      }
    }
    external = false;
    sd = pr + guard;
    num = naturalLogarithm(arg, sd);
    denominator = isBase10 ? getLn10(Ctor, sd + 10) : naturalLogarithm(base, sd);
    r = divide(num, denominator, sd, 1);
    if (checkRoundingDigits(r.d, k = pr, rm)) {
      do {
        sd += 10;
        num = naturalLogarithm(arg, sd);
        denominator = isBase10 ? getLn10(Ctor, sd + 10) : naturalLogarithm(base, sd);
        r = divide(num, denominator, sd, 1);
        if (!inf) {
          if (+digitsToString(r.d).slice(k + 1, k + 15) + 1 == 1e14) {
            r = finalise(r, pr + 1, 0);
          }
          break;
        }
      } while (checkRoundingDigits(r.d, k += 10, rm));
    }
    external = true;
    return finalise(r, pr, rm);
  };
  P.minus = P.sub = function(y) {
    var d, e, i, j, k, len, pr, rm, xd, xe, xLTy, yd, x = this, Ctor = x.constructor;
    y = new Ctor(y);
    if (!x.d || !y.d) {
      if (!x.s || !y.s) y = new Ctor(NaN);
      else if (x.d) y.s = -y.s;
      else y = new Ctor(y.d || x.s !== y.s ? x : NaN);
      return y;
    }
    if (x.s != y.s) {
      y.s = -y.s;
      return x.plus(y);
    }
    xd = x.d;
    yd = y.d;
    pr = Ctor.precision;
    rm = Ctor.rounding;
    if (!xd[0] || !yd[0]) {
      if (yd[0]) y.s = -y.s;
      else if (xd[0]) y = new Ctor(x);
      else return new Ctor(rm === 3 ? -0 : 0);
      return external ? finalise(y, pr, rm) : y;
    }
    e = mathfloor(y.e / LOG_BASE);
    xe = mathfloor(x.e / LOG_BASE);
    xd = xd.slice();
    k = xe - e;
    if (k) {
      xLTy = k < 0;
      if (xLTy) {
        d = xd;
        k = -k;
        len = yd.length;
      } else {
        d = yd;
        e = xe;
        len = xd.length;
      }
      i = Math.max(Math.ceil(pr / LOG_BASE), len) + 2;
      if (k > i) {
        k = i;
        d.length = 1;
      }
      d.reverse();
      for (i = k; i--; ) d.push(0);
      d.reverse();
    } else {
      i = xd.length;
      len = yd.length;
      xLTy = i < len;
      if (xLTy) len = i;
      for (i = 0; i < len; i++) {
        if (xd[i] != yd[i]) {
          xLTy = xd[i] < yd[i];
          break;
        }
      }
      k = 0;
    }
    if (xLTy) {
      d = xd;
      xd = yd;
      yd = d;
      y.s = -y.s;
    }
    len = xd.length;
    for (i = yd.length - len; i > 0; --i) xd[len++] = 0;
    for (i = yd.length; i > k; ) {
      if (xd[--i] < yd[i]) {
        for (j = i; j && xd[--j] === 0; ) xd[j] = BASE - 1;
        --xd[j];
        xd[i] += BASE;
      }
      xd[i] -= yd[i];
    }
    for (; xd[--len] === 0; ) xd.pop();
    for (; xd[0] === 0; xd.shift()) --e;
    if (!xd[0]) return new Ctor(rm === 3 ? -0 : 0);
    y.d = xd;
    y.e = getBase10Exponent(xd, e);
    return external ? finalise(y, pr, rm) : y;
  };
  P.modulo = P.mod = function(y) {
    var q, x = this, Ctor = x.constructor;
    y = new Ctor(y);
    if (!x.d || !y.s || y.d && !y.d[0]) return new Ctor(NaN);
    if (!y.d || x.d && !x.d[0]) {
      return finalise(new Ctor(x), Ctor.precision, Ctor.rounding);
    }
    external = false;
    if (Ctor.modulo == 9) {
      q = divide(x, y.abs(), 0, 3, 1);
      q.s *= y.s;
    } else {
      q = divide(x, y, 0, Ctor.modulo, 1);
    }
    q = q.times(y);
    external = true;
    return x.minus(q);
  };
  P.naturalExponential = P.exp = function() {
    return naturalExponential(this);
  };
  P.naturalLogarithm = P.ln = function() {
    return naturalLogarithm(this);
  };
  P.negated = P.neg = function() {
    var x = new this.constructor(this);
    x.s = -x.s;
    return finalise(x);
  };
  P.plus = P.add = function(y) {
    var carry, d, e, i, k, len, pr, rm, xd, yd, x = this, Ctor = x.constructor;
    y = new Ctor(y);
    if (!x.d || !y.d) {
      if (!x.s || !y.s) y = new Ctor(NaN);
      else if (!x.d) y = new Ctor(y.d || x.s === y.s ? x : NaN);
      return y;
    }
    if (x.s != y.s) {
      y.s = -y.s;
      return x.minus(y);
    }
    xd = x.d;
    yd = y.d;
    pr = Ctor.precision;
    rm = Ctor.rounding;
    if (!xd[0] || !yd[0]) {
      if (!yd[0]) y = new Ctor(x);
      return external ? finalise(y, pr, rm) : y;
    }
    k = mathfloor(x.e / LOG_BASE);
    e = mathfloor(y.e / LOG_BASE);
    xd = xd.slice();
    i = k - e;
    if (i) {
      if (i < 0) {
        d = xd;
        i = -i;
        len = yd.length;
      } else {
        d = yd;
        e = k;
        len = xd.length;
      }
      k = Math.ceil(pr / LOG_BASE);
      len = k > len ? k + 1 : len + 1;
      if (i > len) {
        i = len;
        d.length = 1;
      }
      d.reverse();
      for (; i--; ) d.push(0);
      d.reverse();
    }
    len = xd.length;
    i = yd.length;
    if (len - i < 0) {
      i = len;
      d = yd;
      yd = xd;
      xd = d;
    }
    for (carry = 0; i; ) {
      carry = (xd[--i] = xd[i] + yd[i] + carry) / BASE | 0;
      xd[i] %= BASE;
    }
    if (carry) {
      xd.unshift(carry);
      ++e;
    }
    for (len = xd.length; xd[--len] == 0; ) xd.pop();
    y.d = xd;
    y.e = getBase10Exponent(xd, e);
    return external ? finalise(y, pr, rm) : y;
  };
  P.precision = P.sd = function(z) {
    var k, x = this;
    if (z !== void 0 && z !== !!z && z !== 1 && z !== 0) throw Error(invalidArgument + z);
    if (x.d) {
      k = getPrecision(x.d);
      if (z && x.e + 1 > k) k = x.e + 1;
    } else {
      k = NaN;
    }
    return k;
  };
  P.round = function() {
    var x = this, Ctor = x.constructor;
    return finalise(new Ctor(x), x.e + 1, Ctor.rounding);
  };
  P.sine = P.sin = function() {
    var pr, rm, x = this, Ctor = x.constructor;
    if (!x.isFinite()) return new Ctor(NaN);
    if (x.isZero()) return new Ctor(x);
    pr = Ctor.precision;
    rm = Ctor.rounding;
    Ctor.precision = pr + Math.max(x.e, x.sd()) + LOG_BASE;
    Ctor.rounding = 1;
    x = sine(Ctor, toLessThanHalfPi(Ctor, x));
    Ctor.precision = pr;
    Ctor.rounding = rm;
    return finalise(quadrant > 2 ? x.neg() : x, pr, rm, true);
  };
  P.squareRoot = P.sqrt = function() {
    var m, n, sd, r, rep, t, x = this, d = x.d, e = x.e, s = x.s, Ctor = x.constructor;
    if (s !== 1 || !d || !d[0]) {
      return new Ctor(!s || s < 0 && (!d || d[0]) ? NaN : d ? x : 1 / 0);
    }
    external = false;
    s = Math.sqrt(+x);
    if (s == 0 || s == 1 / 0) {
      n = digitsToString(d);
      if ((n.length + e) % 2 == 0) n += "0";
      s = Math.sqrt(n);
      e = mathfloor((e + 1) / 2) - (e < 0 || e % 2);
      if (s == 1 / 0) {
        n = "5e" + e;
      } else {
        n = s.toExponential();
        n = n.slice(0, n.indexOf("e") + 1) + e;
      }
      r = new Ctor(n);
    } else {
      r = new Ctor(s.toString());
    }
    sd = (e = Ctor.precision) + 3;
    for (; ; ) {
      t = r;
      r = t.plus(divide(x, t, sd + 2, 1)).times(0.5);
      if (digitsToString(t.d).slice(0, sd) === (n = digitsToString(r.d)).slice(0, sd)) {
        n = n.slice(sd - 3, sd + 1);
        if (n == "9999" || !rep && n == "4999") {
          if (!rep) {
            finalise(t, e + 1, 0);
            if (t.times(t).eq(x)) {
              r = t;
              break;
            }
          }
          sd += 4;
          rep = 1;
        } else {
          if (!+n || !+n.slice(1) && n.charAt(0) == "5") {
            finalise(r, e + 1, 1);
            m = !r.times(r).eq(x);
          }
          break;
        }
      }
    }
    external = true;
    return finalise(r, e, Ctor.rounding, m);
  };
  P.tangent = P.tan = function() {
    var pr, rm, x = this, Ctor = x.constructor;
    if (!x.isFinite()) return new Ctor(NaN);
    if (x.isZero()) return new Ctor(x);
    pr = Ctor.precision;
    rm = Ctor.rounding;
    Ctor.precision = pr + 10;
    Ctor.rounding = 1;
    x = x.sin();
    x.s = 1;
    x = divide(x, new Ctor(1).minus(x.times(x)).sqrt(), pr + 10, 0);
    Ctor.precision = pr;
    Ctor.rounding = rm;
    return finalise(quadrant == 2 || quadrant == 4 ? x.neg() : x, pr, rm, true);
  };
  P.times = P.mul = function(y) {
    var carry, e, i, k, r, rL, t, xdL, ydL, x = this, Ctor = x.constructor, xd = x.d, yd = (y = new Ctor(y)).d;
    y.s *= x.s;
    if (!xd || !xd[0] || !yd || !yd[0]) {
      return new Ctor(!y.s || xd && !xd[0] && !yd || yd && !yd[0] && !xd ? NaN : !xd || !yd ? y.s / 0 : y.s * 0);
    }
    e = mathfloor(x.e / LOG_BASE) + mathfloor(y.e / LOG_BASE);
    xdL = xd.length;
    ydL = yd.length;
    if (xdL < ydL) {
      r = xd;
      xd = yd;
      yd = r;
      rL = xdL;
      xdL = ydL;
      ydL = rL;
    }
    r = [];
    rL = xdL + ydL;
    for (i = rL; i--; ) r.push(0);
    for (i = ydL; --i >= 0; ) {
      carry = 0;
      for (k = xdL + i; k > i; ) {
        t = r[k] + yd[i] * xd[k - i - 1] + carry;
        r[k--] = t % BASE | 0;
        carry = t / BASE | 0;
      }
      r[k] = (r[k] + carry) % BASE | 0;
    }
    for (; !r[--rL]; ) r.pop();
    if (carry) ++e;
    else r.shift();
    y.d = r;
    y.e = getBase10Exponent(r, e);
    return external ? finalise(y, Ctor.precision, Ctor.rounding) : y;
  };
  P.toBinary = function(sd, rm) {
    return toStringBinary(this, 2, sd, rm);
  };
  P.toDecimalPlaces = P.toDP = function(dp, rm) {
    var x = this, Ctor = x.constructor;
    x = new Ctor(x);
    if (dp === void 0) return x;
    checkInt32(dp, 0, MAX_DIGITS);
    if (rm === void 0) rm = Ctor.rounding;
    else checkInt32(rm, 0, 8);
    return finalise(x, dp + x.e + 1, rm);
  };
  P.toExponential = function(dp, rm) {
    var str, x = this, Ctor = x.constructor;
    if (dp === void 0) {
      str = finiteToString(x, true);
    } else {
      checkInt32(dp, 0, MAX_DIGITS);
      if (rm === void 0) rm = Ctor.rounding;
      else checkInt32(rm, 0, 8);
      x = finalise(new Ctor(x), dp + 1, rm);
      str = finiteToString(x, true, dp + 1);
    }
    return x.isNeg() && !x.isZero() ? "-" + str : str;
  };
  P.toFixed = function(dp, rm) {
    var str, y, x = this, Ctor = x.constructor;
    if (dp === void 0) {
      str = finiteToString(x);
    } else {
      checkInt32(dp, 0, MAX_DIGITS);
      if (rm === void 0) rm = Ctor.rounding;
      else checkInt32(rm, 0, 8);
      y = finalise(new Ctor(x), dp + x.e + 1, rm);
      str = finiteToString(y, false, dp + y.e + 1);
    }
    return x.isNeg() && !x.isZero() ? "-" + str : str;
  };
  P.toFraction = function(maxD) {
    var d, d0, d1, d2, e, k, n, n0, n1, pr, q, r, x = this, xd = x.d, Ctor = x.constructor;
    if (!xd) return new Ctor(x);
    n1 = d0 = new Ctor(1);
    d1 = n0 = new Ctor(0);
    d = new Ctor(d1);
    e = d.e = getPrecision(xd) - x.e - 1;
    k = e % LOG_BASE;
    d.d[0] = mathpow(10, k < 0 ? LOG_BASE + k : k);
    if (maxD == null) {
      maxD = e > 0 ? d : n1;
    } else {
      n = new Ctor(maxD);
      if (!n.isInt() || n.lt(n1)) throw Error(invalidArgument + n);
      maxD = n.gt(d) ? e > 0 ? d : n1 : n;
    }
    external = false;
    n = new Ctor(digitsToString(xd));
    pr = Ctor.precision;
    Ctor.precision = e = xd.length * LOG_BASE * 2;
    for (; ; ) {
      q = divide(n, d, 0, 1, 1);
      d2 = d0.plus(q.times(d1));
      if (d2.cmp(maxD) == 1) break;
      d0 = d1;
      d1 = d2;
      d2 = n1;
      n1 = n0.plus(q.times(d2));
      n0 = d2;
      d2 = d;
      d = n.minus(q.times(d2));
      n = d2;
    }
    d2 = divide(maxD.minus(d0), d1, 0, 1, 1);
    n0 = n0.plus(d2.times(n1));
    d0 = d0.plus(d2.times(d1));
    n0.s = n1.s = x.s;
    r = divide(n1, d1, e, 1).minus(x).abs().cmp(divide(n0, d0, e, 1).minus(x).abs()) < 1 ? [n1, d1] : [n0, d0];
    Ctor.precision = pr;
    external = true;
    return r;
  };
  P.toHexadecimal = P.toHex = function(sd, rm) {
    return toStringBinary(this, 16, sd, rm);
  };
  P.toNearest = function(y, rm) {
    var x = this, Ctor = x.constructor;
    x = new Ctor(x);
    if (y == null) {
      if (!x.d) return x;
      y = new Ctor(1);
      rm = Ctor.rounding;
    } else {
      y = new Ctor(y);
      if (rm === void 0) {
        rm = Ctor.rounding;
      } else {
        checkInt32(rm, 0, 8);
      }
      if (!x.d) return y.s ? x : y;
      if (!y.d) {
        if (y.s) y.s = x.s;
        return y;
      }
    }
    if (y.d[0]) {
      external = false;
      x = divide(x, y, 0, rm, 1).times(y);
      external = true;
      finalise(x);
    } else {
      y.s = x.s;
      x = y;
    }
    return x;
  };
  P.toNumber = function() {
    return +this;
  };
  P.toOctal = function(sd, rm) {
    return toStringBinary(this, 8, sd, rm);
  };
  P.toPower = P.pow = function(y) {
    var e, k, pr, r, rm, s, x = this, Ctor = x.constructor, yn = +(y = new Ctor(y));
    if (!x.d || !y.d || !x.d[0] || !y.d[0]) return new Ctor(mathpow(+x, yn));
    x = new Ctor(x);
    if (x.eq(1)) return x;
    pr = Ctor.precision;
    rm = Ctor.rounding;
    if (y.eq(1)) return finalise(x, pr, rm);
    e = mathfloor(y.e / LOG_BASE);
    if (e >= y.d.length - 1 && (k = yn < 0 ? -yn : yn) <= MAX_SAFE_INTEGER) {
      r = intPow(Ctor, x, k, pr);
      return y.s < 0 ? new Ctor(1).div(r) : finalise(r, pr, rm);
    }
    s = x.s;
    if (s < 0) {
      if (e < y.d.length - 1) return new Ctor(NaN);
      if ((y.d[e] & 1) == 0) s = 1;
      if (x.e == 0 && x.d[0] == 1 && x.d.length == 1) {
        x.s = s;
        return x;
      }
    }
    k = mathpow(+x, yn);
    e = k == 0 || !isFinite(k) ? mathfloor(yn * (Math.log("0." + digitsToString(x.d)) / Math.LN10 + x.e + 1)) : new Ctor(k + "").e;
    if (e > Ctor.maxE + 1 || e < Ctor.minE - 1) return new Ctor(e > 0 ? s / 0 : 0);
    external = false;
    Ctor.rounding = x.s = 1;
    k = Math.min(12, (e + "").length);
    r = naturalExponential(y.times(naturalLogarithm(x, pr + k)), pr);
    if (r.d) {
      r = finalise(r, pr + 5, 1);
      if (checkRoundingDigits(r.d, pr, rm)) {
        e = pr + 10;
        r = finalise(naturalExponential(y.times(naturalLogarithm(x, e + k)), e), e + 5, 1);
        if (+digitsToString(r.d).slice(pr + 1, pr + 15) + 1 == 1e14) {
          r = finalise(r, pr + 1, 0);
        }
      }
    }
    r.s = s;
    external = true;
    Ctor.rounding = rm;
    return finalise(r, pr, rm);
  };
  P.toPrecision = function(sd, rm) {
    var str, x = this, Ctor = x.constructor;
    if (sd === void 0) {
      str = finiteToString(x, x.e <= Ctor.toExpNeg || x.e >= Ctor.toExpPos);
    } else {
      checkInt32(sd, 1, MAX_DIGITS);
      if (rm === void 0) rm = Ctor.rounding;
      else checkInt32(rm, 0, 8);
      x = finalise(new Ctor(x), sd, rm);
      str = finiteToString(x, sd <= x.e || x.e <= Ctor.toExpNeg, sd);
    }
    return x.isNeg() && !x.isZero() ? "-" + str : str;
  };
  P.toSignificantDigits = P.toSD = function(sd, rm) {
    var x = this, Ctor = x.constructor;
    if (sd === void 0) {
      sd = Ctor.precision;
      rm = Ctor.rounding;
    } else {
      checkInt32(sd, 1, MAX_DIGITS);
      if (rm === void 0) rm = Ctor.rounding;
      else checkInt32(rm, 0, 8);
    }
    return finalise(new Ctor(x), sd, rm);
  };
  P.toString = function() {
    var x = this, Ctor = x.constructor, str = finiteToString(x, x.e <= Ctor.toExpNeg || x.e >= Ctor.toExpPos);
    return x.isNeg() && !x.isZero() ? "-" + str : str;
  };
  P.truncated = P.trunc = function() {
    return finalise(new this.constructor(this), this.e + 1, 1);
  };
  P.valueOf = P.toJSON = function() {
    var x = this, Ctor = x.constructor, str = finiteToString(x, x.e <= Ctor.toExpNeg || x.e >= Ctor.toExpPos);
    return x.isNeg() ? "-" + str : str;
  };
  function digitsToString(d) {
    var i, k, ws, indexOfLastWord = d.length - 1, str = "", w = d[0];
    if (indexOfLastWord > 0) {
      str += w;
      for (i = 1; i < indexOfLastWord; i++) {
        ws = d[i] + "";
        k = LOG_BASE - ws.length;
        if (k) str += getZeroString(k);
        str += ws;
      }
      w = d[i];
      ws = w + "";
      k = LOG_BASE - ws.length;
      if (k) str += getZeroString(k);
    } else if (w === 0) {
      return "0";
    }
    for (; w % 10 === 0; ) w /= 10;
    return str + w;
  }
  function checkInt32(i, min2, max2) {
    if (i !== ~~i || i < min2 || i > max2) {
      throw Error(invalidArgument + i);
    }
  }
  function checkRoundingDigits(d, i, rm, repeating) {
    var di, k, r, rd;
    for (k = d[0]; k >= 10; k /= 10) --i;
    if (--i < 0) {
      i += LOG_BASE;
      di = 0;
    } else {
      di = Math.ceil((i + 1) / LOG_BASE);
      i %= LOG_BASE;
    }
    k = mathpow(10, LOG_BASE - i);
    rd = d[di] % k | 0;
    if (repeating == null) {
      if (i < 3) {
        if (i == 0) rd = rd / 100 | 0;
        else if (i == 1) rd = rd / 10 | 0;
        r = rm < 4 && rd == 99999 || rm > 3 && rd == 49999 || rd == 5e4 || rd == 0;
      } else {
        r = (rm < 4 && rd + 1 == k || rm > 3 && rd + 1 == k / 2) && (d[di + 1] / k / 100 | 0) == mathpow(10, i - 2) - 1 || (rd == k / 2 || rd == 0) && (d[di + 1] / k / 100 | 0) == 0;
      }
    } else {
      if (i < 4) {
        if (i == 0) rd = rd / 1e3 | 0;
        else if (i == 1) rd = rd / 100 | 0;
        else if (i == 2) rd = rd / 10 | 0;
        r = (repeating || rm < 4) && rd == 9999 || !repeating && rm > 3 && rd == 4999;
      } else {
        r = ((repeating || rm < 4) && rd + 1 == k || !repeating && rm > 3 && rd + 1 == k / 2) && (d[di + 1] / k / 1e3 | 0) == mathpow(10, i - 3) - 1;
      }
    }
    return r;
  }
  function convertBase(str, baseIn, baseOut) {
    var j, arr = [0], arrL, i = 0, strL = str.length;
    for (; i < strL; ) {
      for (arrL = arr.length; arrL--; ) arr[arrL] *= baseIn;
      arr[0] += NUMERALS.indexOf(str.charAt(i++));
      for (j = 0; j < arr.length; j++) {
        if (arr[j] > baseOut - 1) {
          if (arr[j + 1] === void 0) arr[j + 1] = 0;
          arr[j + 1] += arr[j] / baseOut | 0;
          arr[j] %= baseOut;
        }
      }
    }
    return arr.reverse();
  }
  function cosine(Ctor, x) {
    var k, len, y;
    if (x.isZero()) return x;
    len = x.d.length;
    if (len < 32) {
      k = Math.ceil(len / 3);
      y = (1 / tinyPow(4, k)).toString();
    } else {
      k = 16;
      y = "2.3283064365386962890625e-10";
    }
    Ctor.precision += k;
    x = taylorSeries(Ctor, 1, x.times(y), new Ctor(1));
    for (var i = k; i--; ) {
      var cos2x = x.times(x);
      x = cos2x.times(cos2x).minus(cos2x).times(8).plus(1);
    }
    Ctor.precision -= k;
    return x;
  }
  var divide = /* @__PURE__ */ function() {
    function multiplyInteger(x, k, base) {
      var temp, carry = 0, i = x.length;
      for (x = x.slice(); i--; ) {
        temp = x[i] * k + carry;
        x[i] = temp % base | 0;
        carry = temp / base | 0;
      }
      if (carry) x.unshift(carry);
      return x;
    }
    function compare(a, b, aL, bL) {
      var i, r;
      if (aL != bL) {
        r = aL > bL ? 1 : -1;
      } else {
        for (i = r = 0; i < aL; i++) {
          if (a[i] != b[i]) {
            r = a[i] > b[i] ? 1 : -1;
            break;
          }
        }
      }
      return r;
    }
    function subtract(a, b, aL, base) {
      var i = 0;
      for (; aL--; ) {
        a[aL] -= i;
        i = a[aL] < b[aL] ? 1 : 0;
        a[aL] = i * base + a[aL] - b[aL];
      }
      for (; !a[0] && a.length > 1; ) a.shift();
    }
    return function(x, y, pr, rm, dp, base) {
      var cmp2, e, i, k, logBase, more, prod, prodL, q, qd, rem, remL, rem0, sd, t, xi, xL, yd0, yL, yz, Ctor = x.constructor, sign2 = x.s == y.s ? 1 : -1, xd = x.d, yd = y.d;
      if (!xd || !xd[0] || !yd || !yd[0]) {
        return new Ctor(
          // Return NaN if either NaN, or both Infinity or 0.
          !x.s || !y.s || (xd ? yd && xd[0] == yd[0] : !yd) ? NaN : (
            // Return ±0 if x is 0 or y is ±Infinity, or return ±Infinity as y is 0.
            xd && xd[0] == 0 || !yd ? sign2 * 0 : sign2 / 0
          )
        );
      }
      if (base) {
        logBase = 1;
        e = x.e - y.e;
      } else {
        base = BASE;
        logBase = LOG_BASE;
        e = mathfloor(x.e / logBase) - mathfloor(y.e / logBase);
      }
      yL = yd.length;
      xL = xd.length;
      q = new Ctor(sign2);
      qd = q.d = [];
      for (i = 0; yd[i] == (xd[i] || 0); i++) ;
      if (yd[i] > (xd[i] || 0)) e--;
      if (pr == null) {
        sd = pr = Ctor.precision;
        rm = Ctor.rounding;
      } else if (dp) {
        sd = pr + (x.e - y.e) + 1;
      } else {
        sd = pr;
      }
      if (sd < 0) {
        qd.push(1);
        more = true;
      } else {
        sd = sd / logBase + 2 | 0;
        i = 0;
        if (yL == 1) {
          k = 0;
          yd = yd[0];
          sd++;
          for (; (i < xL || k) && sd--; i++) {
            t = k * base + (xd[i] || 0);
            qd[i] = t / yd | 0;
            k = t % yd | 0;
          }
          more = k || i < xL;
        } else {
          k = base / (yd[0] + 1) | 0;
          if (k > 1) {
            yd = multiplyInteger(yd, k, base);
            xd = multiplyInteger(xd, k, base);
            yL = yd.length;
            xL = xd.length;
          }
          xi = yL;
          rem = xd.slice(0, yL);
          remL = rem.length;
          for (; remL < yL; ) rem[remL++] = 0;
          yz = yd.slice();
          yz.unshift(0);
          yd0 = yd[0];
          if (yd[1] >= base / 2) ++yd0;
          do {
            k = 0;
            cmp2 = compare(yd, rem, yL, remL);
            if (cmp2 < 0) {
              rem0 = rem[0];
              if (yL != remL) rem0 = rem0 * base + (rem[1] || 0);
              k = rem0 / yd0 | 0;
              if (k > 1) {
                if (k >= base) k = base - 1;
                prod = multiplyInteger(yd, k, base);
                prodL = prod.length;
                remL = rem.length;
                cmp2 = compare(prod, rem, prodL, remL);
                if (cmp2 == 1) {
                  k--;
                  subtract(prod, yL < prodL ? yz : yd, prodL, base);
                }
              } else {
                if (k == 0) cmp2 = k = 1;
                prod = yd.slice();
              }
              prodL = prod.length;
              if (prodL < remL) prod.unshift(0);
              subtract(rem, prod, remL, base);
              if (cmp2 == -1) {
                remL = rem.length;
                cmp2 = compare(yd, rem, yL, remL);
                if (cmp2 < 1) {
                  k++;
                  subtract(rem, yL < remL ? yz : yd, remL, base);
                }
              }
              remL = rem.length;
            } else if (cmp2 === 0) {
              k++;
              rem = [0];
            }
            qd[i++] = k;
            if (cmp2 && rem[0]) {
              rem[remL++] = xd[xi] || 0;
            } else {
              rem = [xd[xi]];
              remL = 1;
            }
          } while ((xi++ < xL || rem[0] !== void 0) && sd--);
          more = rem[0] !== void 0;
        }
        if (!qd[0]) qd.shift();
      }
      if (logBase == 1) {
        q.e = e;
        inexact = more;
      } else {
        for (i = 1, k = qd[0]; k >= 10; k /= 10) i++;
        q.e = i + e * logBase - 1;
        finalise(q, dp ? pr + q.e + 1 : pr, rm, more);
      }
      return q;
    };
  }();
  function finalise(x, sd, rm, isTruncated) {
    var digits, i, j, k, rd, roundUp, w, xd, xdi, Ctor = x.constructor;
    out: if (sd != null) {
      xd = x.d;
      if (!xd) return x;
      for (digits = 1, k = xd[0]; k >= 10; k /= 10) digits++;
      i = sd - digits;
      if (i < 0) {
        i += LOG_BASE;
        j = sd;
        w = xd[xdi = 0];
        rd = w / mathpow(10, digits - j - 1) % 10 | 0;
      } else {
        xdi = Math.ceil((i + 1) / LOG_BASE);
        k = xd.length;
        if (xdi >= k) {
          if (isTruncated) {
            for (; k++ <= xdi; ) xd.push(0);
            w = rd = 0;
            digits = 1;
            i %= LOG_BASE;
            j = i - LOG_BASE + 1;
          } else {
            break out;
          }
        } else {
          w = k = xd[xdi];
          for (digits = 1; k >= 10; k /= 10) digits++;
          i %= LOG_BASE;
          j = i - LOG_BASE + digits;
          rd = j < 0 ? 0 : w / mathpow(10, digits - j - 1) % 10 | 0;
        }
      }
      isTruncated = isTruncated || sd < 0 || xd[xdi + 1] !== void 0 || (j < 0 ? w : w % mathpow(10, digits - j - 1));
      roundUp = rm < 4 ? (rd || isTruncated) && (rm == 0 || rm == (x.s < 0 ? 3 : 2)) : rd > 5 || rd == 5 && (rm == 4 || isTruncated || rm == 6 && // Check whether the digit to the left of the rounding digit is odd.
      (i > 0 ? j > 0 ? w / mathpow(10, digits - j) : 0 : xd[xdi - 1]) % 10 & 1 || rm == (x.s < 0 ? 8 : 7));
      if (sd < 1 || !xd[0]) {
        xd.length = 0;
        if (roundUp) {
          sd -= x.e + 1;
          xd[0] = mathpow(10, (LOG_BASE - sd % LOG_BASE) % LOG_BASE);
          x.e = -sd || 0;
        } else {
          xd[0] = x.e = 0;
        }
        return x;
      }
      if (i == 0) {
        xd.length = xdi;
        k = 1;
        xdi--;
      } else {
        xd.length = xdi + 1;
        k = mathpow(10, LOG_BASE - i);
        xd[xdi] = j > 0 ? (w / mathpow(10, digits - j) % mathpow(10, j) | 0) * k : 0;
      }
      if (roundUp) {
        for (; ; ) {
          if (xdi == 0) {
            for (i = 1, j = xd[0]; j >= 10; j /= 10) i++;
            j = xd[0] += k;
            for (k = 1; j >= 10; j /= 10) k++;
            if (i != k) {
              x.e++;
              if (xd[0] == BASE) xd[0] = 1;
            }
            break;
          } else {
            xd[xdi] += k;
            if (xd[xdi] != BASE) break;
            xd[xdi--] = 0;
            k = 1;
          }
        }
      }
      for (i = xd.length; xd[--i] === 0; ) xd.pop();
    }
    if (external) {
      if (x.e > Ctor.maxE) {
        x.d = null;
        x.e = NaN;
      } else if (x.e < Ctor.minE) {
        x.e = 0;
        x.d = [0];
      }
    }
    return x;
  }
  function finiteToString(x, isExp, sd) {
    if (!x.isFinite()) return nonFiniteToString(x);
    var k, e = x.e, str = digitsToString(x.d), len = str.length;
    if (isExp) {
      if (sd && (k = sd - len) > 0) {
        str = str.charAt(0) + "." + str.slice(1) + getZeroString(k);
      } else if (len > 1) {
        str = str.charAt(0) + "." + str.slice(1);
      }
      str = str + (x.e < 0 ? "e" : "e+") + x.e;
    } else if (e < 0) {
      str = "0." + getZeroString(-e - 1) + str;
      if (sd && (k = sd - len) > 0) str += getZeroString(k);
    } else if (e >= len) {
      str += getZeroString(e + 1 - len);
      if (sd && (k = sd - e - 1) > 0) str = str + "." + getZeroString(k);
    } else {
      if ((k = e + 1) < len) str = str.slice(0, k) + "." + str.slice(k);
      if (sd && (k = sd - len) > 0) {
        if (e + 1 === len) str += ".";
        str += getZeroString(k);
      }
    }
    return str;
  }
  function getBase10Exponent(digits, e) {
    var w = digits[0];
    for (e *= LOG_BASE; w >= 10; w /= 10) e++;
    return e;
  }
  function getLn10(Ctor, sd, pr) {
    if (sd > LN10_PRECISION) {
      external = true;
      if (pr) Ctor.precision = pr;
      throw Error(precisionLimitExceeded);
    }
    return finalise(new Ctor(LN10), sd, 1, true);
  }
  function getPi(Ctor, sd, rm) {
    if (sd > PI_PRECISION) throw Error(precisionLimitExceeded);
    return finalise(new Ctor(PI), sd, rm, true);
  }
  function getPrecision(digits) {
    var w = digits.length - 1, len = w * LOG_BASE + 1;
    w = digits[w];
    if (w) {
      for (; w % 10 == 0; w /= 10) len--;
      for (w = digits[0]; w >= 10; w /= 10) len++;
    }
    return len;
  }
  function getZeroString(k) {
    var zs = "";
    for (; k--; ) zs += "0";
    return zs;
  }
  function intPow(Ctor, x, n, pr) {
    var isTruncated, r = new Ctor(1), k = Math.ceil(pr / LOG_BASE + 4);
    external = false;
    for (; ; ) {
      if (n % 2) {
        r = r.times(x);
        if (truncate(r.d, k)) isTruncated = true;
      }
      n = mathfloor(n / 2);
      if (n === 0) {
        n = r.d.length - 1;
        if (isTruncated && r.d[n] === 0) ++r.d[n];
        break;
      }
      x = x.times(x);
      truncate(x.d, k);
    }
    external = true;
    return r;
  }
  function isOdd(n) {
    return n.d[n.d.length - 1] & 1;
  }
  function maxOrMin(Ctor, args, n) {
    var k, y, x = new Ctor(args[0]), i = 0;
    for (; ++i < args.length; ) {
      y = new Ctor(args[i]);
      if (!y.s) {
        x = y;
        break;
      }
      k = x.cmp(y);
      if (k === n || k === 0 && x.s === n) {
        x = y;
      }
    }
    return x;
  }
  function naturalExponential(x, sd) {
    var denominator, guard, j, pow3, sum2, t, wpr, rep = 0, i = 0, k = 0, Ctor = x.constructor, rm = Ctor.rounding, pr = Ctor.precision;
    if (!x.d || !x.d[0] || x.e > 17) {
      return new Ctor(x.d ? !x.d[0] ? 1 : x.s < 0 ? 0 : 1 / 0 : x.s ? x.s < 0 ? 0 : x : 0 / 0);
    }
    if (sd == null) {
      external = false;
      wpr = pr;
    } else {
      wpr = sd;
    }
    t = new Ctor(0.03125);
    while (x.e > -2) {
      x = x.times(t);
      k += 5;
    }
    guard = Math.log(mathpow(2, k)) / Math.LN10 * 2 + 5 | 0;
    wpr += guard;
    denominator = pow3 = sum2 = new Ctor(1);
    Ctor.precision = wpr;
    for (; ; ) {
      pow3 = finalise(pow3.times(x), wpr, 1);
      denominator = denominator.times(++i);
      t = sum2.plus(divide(pow3, denominator, wpr, 1));
      if (digitsToString(t.d).slice(0, wpr) === digitsToString(sum2.d).slice(0, wpr)) {
        j = k;
        while (j--) sum2 = finalise(sum2.times(sum2), wpr, 1);
        if (sd == null) {
          if (rep < 3 && checkRoundingDigits(sum2.d, wpr - guard, rm, rep)) {
            Ctor.precision = wpr += 10;
            denominator = pow3 = t = new Ctor(1);
            i = 0;
            rep++;
          } else {
            return finalise(sum2, Ctor.precision = pr, rm, external = true);
          }
        } else {
          Ctor.precision = pr;
          return sum2;
        }
      }
      sum2 = t;
    }
  }
  function naturalLogarithm(y, sd) {
    var c, c0, denominator, e, numerator, rep, sum2, t, wpr, x1, x2, n = 1, guard = 10, x = y, xd = x.d, Ctor = x.constructor, rm = Ctor.rounding, pr = Ctor.precision;
    if (x.s < 0 || !xd || !xd[0] || !x.e && xd[0] == 1 && xd.length == 1) {
      return new Ctor(xd && !xd[0] ? -1 / 0 : x.s != 1 ? NaN : xd ? 0 : x);
    }
    if (sd == null) {
      external = false;
      wpr = pr;
    } else {
      wpr = sd;
    }
    Ctor.precision = wpr += guard;
    c = digitsToString(xd);
    c0 = c.charAt(0);
    if (Math.abs(e = x.e) < 15e14) {
      while (c0 < 7 && c0 != 1 || c0 == 1 && c.charAt(1) > 3) {
        x = x.times(y);
        c = digitsToString(x.d);
        c0 = c.charAt(0);
        n++;
      }
      e = x.e;
      if (c0 > 1) {
        x = new Ctor("0." + c);
        e++;
      } else {
        x = new Ctor(c0 + "." + c.slice(1));
      }
    } else {
      t = getLn10(Ctor, wpr + 2, pr).times(e + "");
      x = naturalLogarithm(new Ctor(c0 + "." + c.slice(1)), wpr - guard).plus(t);
      Ctor.precision = pr;
      return sd == null ? finalise(x, pr, rm, external = true) : x;
    }
    x1 = x;
    sum2 = numerator = x = divide(x.minus(1), x.plus(1), wpr, 1);
    x2 = finalise(x.times(x), wpr, 1);
    denominator = 3;
    for (; ; ) {
      numerator = finalise(numerator.times(x2), wpr, 1);
      t = sum2.plus(divide(numerator, new Ctor(denominator), wpr, 1));
      if (digitsToString(t.d).slice(0, wpr) === digitsToString(sum2.d).slice(0, wpr)) {
        sum2 = sum2.times(2);
        if (e !== 0) sum2 = sum2.plus(getLn10(Ctor, wpr + 2, pr).times(e + ""));
        sum2 = divide(sum2, new Ctor(n), wpr, 1);
        if (sd == null) {
          if (checkRoundingDigits(sum2.d, wpr - guard, rm, rep)) {
            Ctor.precision = wpr += guard;
            t = numerator = x = divide(x1.minus(1), x1.plus(1), wpr, 1);
            x2 = finalise(x.times(x), wpr, 1);
            denominator = rep = 1;
          } else {
            return finalise(sum2, Ctor.precision = pr, rm, external = true);
          }
        } else {
          Ctor.precision = pr;
          return sum2;
        }
      }
      sum2 = t;
      denominator += 2;
    }
  }
  function nonFiniteToString(x) {
    return String(x.s * x.s / 0);
  }
  function parseDecimal(x, str) {
    var e, i, len;
    if ((e = str.indexOf(".")) > -1) str = str.replace(".", "");
    if ((i = str.search(/e/i)) > 0) {
      if (e < 0) e = i;
      e += +str.slice(i + 1);
      str = str.substring(0, i);
    } else if (e < 0) {
      e = str.length;
    }
    for (i = 0; str.charCodeAt(i) === 48; i++) ;
    for (len = str.length; str.charCodeAt(len - 1) === 48; --len) ;
    str = str.slice(i, len);
    if (str) {
      len -= i;
      x.e = e = e - i - 1;
      x.d = [];
      i = (e + 1) % LOG_BASE;
      if (e < 0) i += LOG_BASE;
      if (i < len) {
        if (i) x.d.push(+str.slice(0, i));
        for (len -= LOG_BASE; i < len; ) x.d.push(+str.slice(i, i += LOG_BASE));
        str = str.slice(i);
        i = LOG_BASE - str.length;
      } else {
        i -= len;
      }
      for (; i--; ) str += "0";
      x.d.push(+str);
      if (external) {
        if (x.e > x.constructor.maxE) {
          x.d = null;
          x.e = NaN;
        } else if (x.e < x.constructor.minE) {
          x.e = 0;
          x.d = [0];
        }
      }
    } else {
      x.e = 0;
      x.d = [0];
    }
    return x;
  }
  function parseOther(x, str) {
    var base, Ctor, divisor, i, isFloat, len, p, xd, xe;
    if (str.indexOf("_") > -1) {
      str = str.replace(/(\d)_(?=\d)/g, "$1");
      if (isDecimal.test(str)) return parseDecimal(x, str);
    } else if (str === "Infinity" || str === "NaN") {
      if (!+str) x.s = NaN;
      x.e = NaN;
      x.d = null;
      return x;
    }
    if (isHex.test(str)) {
      base = 16;
      str = str.toLowerCase();
    } else if (isBinary.test(str)) {
      base = 2;
    } else if (isOctal.test(str)) {
      base = 8;
    } else {
      throw Error(invalidArgument + str);
    }
    i = str.search(/p/i);
    if (i > 0) {
      p = +str.slice(i + 1);
      str = str.substring(2, i);
    } else {
      str = str.slice(2);
    }
    i = str.indexOf(".");
    isFloat = i >= 0;
    Ctor = x.constructor;
    if (isFloat) {
      str = str.replace(".", "");
      len = str.length;
      i = len - i;
      divisor = intPow(Ctor, new Ctor(base), i, i * 2);
    }
    xd = convertBase(str, base, BASE);
    xe = xd.length - 1;
    for (i = xe; xd[i] === 0; --i) xd.pop();
    if (i < 0) return new Ctor(x.s * 0);
    x.e = getBase10Exponent(xd, xe);
    x.d = xd;
    external = false;
    if (isFloat) x = divide(x, divisor, len * 4);
    if (p) x = x.times(Math.abs(p) < 54 ? mathpow(2, p) : Decimal.pow(2, p));
    external = true;
    return x;
  }
  function sine(Ctor, x) {
    var k, len = x.d.length;
    if (len < 3) {
      return x.isZero() ? x : taylorSeries(Ctor, 2, x, x);
    }
    k = 1.4 * Math.sqrt(len);
    k = k > 16 ? 16 : k | 0;
    x = x.times(1 / tinyPow(5, k));
    x = taylorSeries(Ctor, 2, x, x);
    var sin2_x, d5 = new Ctor(5), d16 = new Ctor(16), d20 = new Ctor(20);
    for (; k--; ) {
      sin2_x = x.times(x);
      x = x.times(d5.plus(sin2_x.times(d16.times(sin2_x).minus(d20))));
    }
    return x;
  }
  function taylorSeries(Ctor, n, x, y, isHyperbolic) {
    var j, t, u, x2, i = 1, pr = Ctor.precision, k = Math.ceil(pr / LOG_BASE);
    external = false;
    x2 = x.times(x);
    u = new Ctor(y);
    for (; ; ) {
      t = divide(u.times(x2), new Ctor(n++ * n++), pr, 1);
      u = isHyperbolic ? y.plus(t) : y.minus(t);
      y = divide(t.times(x2), new Ctor(n++ * n++), pr, 1);
      t = u.plus(y);
      if (t.d[k] !== void 0) {
        for (j = k; t.d[j] === u.d[j] && j--; ) ;
        if (j == -1) break;
      }
      j = u;
      u = y;
      y = t;
      t = j;
      i++;
    }
    external = true;
    t.d.length = k + 1;
    return t;
  }
  function tinyPow(b, e) {
    var n = b;
    while (--e) n *= b;
    return n;
  }
  function toLessThanHalfPi(Ctor, x) {
    var t, isNeg = x.s < 0, pi = getPi(Ctor, Ctor.precision, 1), halfPi = pi.times(0.5);
    x = x.abs();
    if (x.lte(halfPi)) {
      quadrant = isNeg ? 4 : 1;
      return x;
    }
    t = x.divToInt(pi);
    if (t.isZero()) {
      quadrant = isNeg ? 3 : 2;
    } else {
      x = x.minus(t.times(pi));
      if (x.lte(halfPi)) {
        quadrant = isOdd(t) ? isNeg ? 2 : 3 : isNeg ? 4 : 1;
        return x;
      }
      quadrant = isOdd(t) ? isNeg ? 1 : 4 : isNeg ? 3 : 2;
    }
    return x.minus(pi).abs();
  }
  function toStringBinary(x, baseOut, sd, rm) {
    var base, e, i, k, len, roundUp, str, xd, y, Ctor = x.constructor, isExp = sd !== void 0;
    if (isExp) {
      checkInt32(sd, 1, MAX_DIGITS);
      if (rm === void 0) rm = Ctor.rounding;
      else checkInt32(rm, 0, 8);
    } else {
      sd = Ctor.precision;
      rm = Ctor.rounding;
    }
    if (!x.isFinite()) {
      str = nonFiniteToString(x);
    } else {
      str = finiteToString(x);
      i = str.indexOf(".");
      if (isExp) {
        base = 2;
        if (baseOut == 16) {
          sd = sd * 4 - 3;
        } else if (baseOut == 8) {
          sd = sd * 3 - 2;
        }
      } else {
        base = baseOut;
      }
      if (i >= 0) {
        str = str.replace(".", "");
        y = new Ctor(1);
        y.e = str.length - i;
        y.d = convertBase(finiteToString(y), 10, base);
        y.e = y.d.length;
      }
      xd = convertBase(str, 10, base);
      e = len = xd.length;
      for (; xd[--len] == 0; ) xd.pop();
      if (!xd[0]) {
        str = isExp ? "0p+0" : "0";
      } else {
        if (i < 0) {
          e--;
        } else {
          x = new Ctor(x);
          x.d = xd;
          x.e = e;
          x = divide(x, y, sd, rm, 0, base);
          xd = x.d;
          e = x.e;
          roundUp = inexact;
        }
        i = xd[sd];
        k = base / 2;
        roundUp = roundUp || xd[sd + 1] !== void 0;
        roundUp = rm < 4 ? (i !== void 0 || roundUp) && (rm === 0 || rm === (x.s < 0 ? 3 : 2)) : i > k || i === k && (rm === 4 || roundUp || rm === 6 && xd[sd - 1] & 1 || rm === (x.s < 0 ? 8 : 7));
        xd.length = sd;
        if (roundUp) {
          for (; ++xd[--sd] > base - 1; ) {
            xd[sd] = 0;
            if (!sd) {
              ++e;
              xd.unshift(1);
            }
          }
        }
        for (len = xd.length; !xd[len - 1]; --len) ;
        for (i = 0, str = ""; i < len; i++) str += NUMERALS.charAt(xd[i]);
        if (isExp) {
          if (len > 1) {
            if (baseOut == 16 || baseOut == 8) {
              i = baseOut == 16 ? 4 : 3;
              for (--len; len % i; len++) str += "0";
              xd = convertBase(str, base, baseOut);
              for (len = xd.length; !xd[len - 1]; --len) ;
              for (i = 1, str = "1."; i < len; i++) str += NUMERALS.charAt(xd[i]);
            } else {
              str = str.charAt(0) + "." + str.slice(1);
            }
          }
          str = str + (e < 0 ? "p" : "p+") + e;
        } else if (e < 0) {
          for (; ++e; ) str = "0" + str;
          str = "0." + str;
        } else {
          if (++e > len) for (e -= len; e--; ) str += "0";
          else if (e < len) str = str.slice(0, e) + "." + str.slice(e);
        }
      }
      str = (baseOut == 16 ? "0x" : baseOut == 2 ? "0b" : baseOut == 8 ? "0o" : "") + str;
    }
    return x.s < 0 ? "-" + str : str;
  }
  function truncate(arr, len) {
    if (arr.length > len) {
      arr.length = len;
      return true;
    }
  }
  function abs(x) {
    return new this(x).abs();
  }
  function acos(x) {
    return new this(x).acos();
  }
  function acosh(x) {
    return new this(x).acosh();
  }
  function add(x, y) {
    return new this(x).plus(y);
  }
  function asin(x) {
    return new this(x).asin();
  }
  function asinh(x) {
    return new this(x).asinh();
  }
  function atan(x) {
    return new this(x).atan();
  }
  function atanh(x) {
    return new this(x).atanh();
  }
  function atan2(y, x) {
    y = new this(y);
    x = new this(x);
    var r, pr = this.precision, rm = this.rounding, wpr = pr + 4;
    if (!y.s || !x.s) {
      r = new this(NaN);
    } else if (!y.d && !x.d) {
      r = getPi(this, wpr, 1).times(x.s > 0 ? 0.25 : 0.75);
      r.s = y.s;
    } else if (!x.d || y.isZero()) {
      r = x.s < 0 ? getPi(this, pr, rm) : new this(0);
      r.s = y.s;
    } else if (!y.d || x.isZero()) {
      r = getPi(this, wpr, 1).times(0.5);
      r.s = y.s;
    } else if (x.s < 0) {
      this.precision = wpr;
      this.rounding = 1;
      r = this.atan(divide(y, x, wpr, 1));
      x = getPi(this, wpr, 1);
      this.precision = pr;
      this.rounding = rm;
      r = y.s < 0 ? r.minus(x) : r.plus(x);
    } else {
      r = this.atan(divide(y, x, wpr, 1));
    }
    return r;
  }
  function cbrt(x) {
    return new this(x).cbrt();
  }
  function ceil(x) {
    return finalise(x = new this(x), x.e + 1, 2);
  }
  function clamp(x, min2, max2) {
    return new this(x).clamp(min2, max2);
  }
  function config(obj) {
    if (!obj || typeof obj !== "object") throw Error(decimalError + "Object expected");
    var i, p, v, useDefaults = obj.defaults === true, ps = [
      "precision",
      1,
      MAX_DIGITS,
      "rounding",
      0,
      8,
      "toExpNeg",
      -EXP_LIMIT,
      0,
      "toExpPos",
      0,
      EXP_LIMIT,
      "maxE",
      0,
      EXP_LIMIT,
      "minE",
      -EXP_LIMIT,
      0,
      "modulo",
      0,
      9
    ];
    for (i = 0; i < ps.length; i += 3) {
      if (p = ps[i], useDefaults) this[p] = DEFAULTS[p];
      if ((v = obj[p]) !== void 0) {
        if (mathfloor(v) === v && v >= ps[i + 1] && v <= ps[i + 2]) this[p] = v;
        else throw Error(invalidArgument + p + ": " + v);
      }
    }
    if (p = "crypto", useDefaults) this[p] = DEFAULTS[p];
    if ((v = obj[p]) !== void 0) {
      if (v === true || v === false || v === 0 || v === 1) {
        if (v) {
          if (typeof crypto != "undefined" && crypto && (crypto.getRandomValues || crypto.randomBytes)) {
            this[p] = true;
          } else {
            throw Error(cryptoUnavailable);
          }
        } else {
          this[p] = false;
        }
      } else {
        throw Error(invalidArgument + p + ": " + v);
      }
    }
    return this;
  }
  function cos(x) {
    return new this(x).cos();
  }
  function cosh2(x) {
    return new this(x).cosh();
  }
  function clone(obj) {
    var i, p, ps;
    function Decimal2(v) {
      var e, i2, t, x = this;
      if (!(x instanceof Decimal2)) return new Decimal2(v);
      x.constructor = Decimal2;
      if (isDecimalInstance(v)) {
        x.s = v.s;
        if (external) {
          if (!v.d || v.e > Decimal2.maxE) {
            x.e = NaN;
            x.d = null;
          } else if (v.e < Decimal2.minE) {
            x.e = 0;
            x.d = [0];
          } else {
            x.e = v.e;
            x.d = v.d.slice();
          }
        } else {
          x.e = v.e;
          x.d = v.d ? v.d.slice() : v.d;
        }
        return;
      }
      t = typeof v;
      if (t === "number") {
        if (v === 0) {
          x.s = 1 / v < 0 ? -1 : 1;
          x.e = 0;
          x.d = [0];
          return;
        }
        if (v < 0) {
          v = -v;
          x.s = -1;
        } else {
          x.s = 1;
        }
        if (v === ~~v && v < 1e7) {
          for (e = 0, i2 = v; i2 >= 10; i2 /= 10) e++;
          if (external) {
            if (e > Decimal2.maxE) {
              x.e = NaN;
              x.d = null;
            } else if (e < Decimal2.minE) {
              x.e = 0;
              x.d = [0];
            } else {
              x.e = e;
              x.d = [v];
            }
          } else {
            x.e = e;
            x.d = [v];
          }
          return;
        }
        if (v * 0 !== 0) {
          if (!v) x.s = NaN;
          x.e = NaN;
          x.d = null;
          return;
        }
        return parseDecimal(x, v.toString());
      }
      if (t === "string") {
        if ((i2 = v.charCodeAt(0)) === 45) {
          v = v.slice(1);
          x.s = -1;
        } else {
          if (i2 === 43) v = v.slice(1);
          x.s = 1;
        }
        return isDecimal.test(v) ? parseDecimal(x, v) : parseOther(x, v);
      }
      if (t === "bigint") {
        if (v < 0) {
          v = -v;
          x.s = -1;
        } else {
          x.s = 1;
        }
        return parseDecimal(x, v.toString());
      }
      throw Error(invalidArgument + v);
    }
    Decimal2.prototype = P;
    Decimal2.ROUND_UP = 0;
    Decimal2.ROUND_DOWN = 1;
    Decimal2.ROUND_CEIL = 2;
    Decimal2.ROUND_FLOOR = 3;
    Decimal2.ROUND_HALF_UP = 4;
    Decimal2.ROUND_HALF_DOWN = 5;
    Decimal2.ROUND_HALF_EVEN = 6;
    Decimal2.ROUND_HALF_CEIL = 7;
    Decimal2.ROUND_HALF_FLOOR = 8;
    Decimal2.EUCLID = 9;
    Decimal2.config = Decimal2.set = config;
    Decimal2.clone = clone;
    Decimal2.isDecimal = isDecimalInstance;
    Decimal2.abs = abs;
    Decimal2.acos = acos;
    Decimal2.acosh = acosh;
    Decimal2.add = add;
    Decimal2.asin = asin;
    Decimal2.asinh = asinh;
    Decimal2.atan = atan;
    Decimal2.atanh = atanh;
    Decimal2.atan2 = atan2;
    Decimal2.cbrt = cbrt;
    Decimal2.ceil = ceil;
    Decimal2.clamp = clamp;
    Decimal2.cos = cos;
    Decimal2.cosh = cosh2;
    Decimal2.div = div;
    Decimal2.exp = exp;
    Decimal2.floor = floor;
    Decimal2.hypot = hypot2;
    Decimal2.ln = ln;
    Decimal2.log = log;
    Decimal2.log10 = log10;
    Decimal2.log2 = log2;
    Decimal2.max = max;
    Decimal2.min = min;
    Decimal2.mod = mod;
    Decimal2.mul = mul;
    Decimal2.pow = pow;
    Decimal2.random = random;
    Decimal2.round = round;
    Decimal2.sign = sign;
    Decimal2.sin = sin;
    Decimal2.sinh = sinh2;
    Decimal2.sqrt = sqrt;
    Decimal2.sub = sub;
    Decimal2.sum = sum;
    Decimal2.tan = tan;
    Decimal2.tanh = tanh;
    Decimal2.trunc = trunc;
    if (obj === void 0) obj = {};
    if (obj) {
      if (obj.defaults !== true) {
        ps = ["precision", "rounding", "toExpNeg", "toExpPos", "maxE", "minE", "modulo", "crypto"];
        for (i = 0; i < ps.length; ) if (!obj.hasOwnProperty(p = ps[i++])) obj[p] = this[p];
      }
    }
    Decimal2.config(obj);
    return Decimal2;
  }
  function div(x, y) {
    return new this(x).div(y);
  }
  function exp(x) {
    return new this(x).exp();
  }
  function floor(x) {
    return finalise(x = new this(x), x.e + 1, 3);
  }
  function hypot2() {
    var i, n, t = new this(0);
    external = false;
    for (i = 0; i < arguments.length; ) {
      n = new this(arguments[i++]);
      if (!n.d) {
        if (n.s) {
          external = true;
          return new this(1 / 0);
        }
        t = n;
      } else if (t.d) {
        t = t.plus(n.times(n));
      }
    }
    external = true;
    return t.sqrt();
  }
  function isDecimalInstance(obj) {
    return obj instanceof Decimal || obj && obj.toStringTag === tag || false;
  }
  function ln(x) {
    return new this(x).ln();
  }
  function log(x, y) {
    return new this(x).log(y);
  }
  function log2(x) {
    return new this(x).log(2);
  }
  function log10(x) {
    return new this(x).log(10);
  }
  function max() {
    return maxOrMin(this, arguments, -1);
  }
  function min() {
    return maxOrMin(this, arguments, 1);
  }
  function mod(x, y) {
    return new this(x).mod(y);
  }
  function mul(x, y) {
    return new this(x).mul(y);
  }
  function pow(x, y) {
    return new this(x).pow(y);
  }
  function random(sd) {
    var d, e, k, n, i = 0, r = new this(1), rd = [];
    if (sd === void 0) sd = this.precision;
    else checkInt32(sd, 1, MAX_DIGITS);
    k = Math.ceil(sd / LOG_BASE);
    if (!this.crypto) {
      for (; i < k; ) rd[i++] = Math.random() * 1e7 | 0;
    } else if (crypto.getRandomValues) {
      d = crypto.getRandomValues(new Uint32Array(k));
      for (; i < k; ) {
        n = d[i];
        if (n >= 429e7) {
          d[i] = crypto.getRandomValues(new Uint32Array(1))[0];
        } else {
          rd[i++] = n % 1e7;
        }
      }
    } else if (crypto.randomBytes) {
      d = crypto.randomBytes(k *= 4);
      for (; i < k; ) {
        n = d[i] + (d[i + 1] << 8) + (d[i + 2] << 16) + ((d[i + 3] & 127) << 24);
        if (n >= 214e7) {
          crypto.randomBytes(4).copy(d, i);
        } else {
          rd.push(n % 1e7);
          i += 4;
        }
      }
      i = k / 4;
    } else {
      throw Error(cryptoUnavailable);
    }
    k = rd[--i];
    sd %= LOG_BASE;
    if (k && sd) {
      n = mathpow(10, LOG_BASE - sd);
      rd[i] = (k / n | 0) * n;
    }
    for (; rd[i] === 0; i--) rd.pop();
    if (i < 0) {
      e = 0;
      rd = [0];
    } else {
      e = -1;
      for (; rd[0] === 0; e -= LOG_BASE) rd.shift();
      for (k = 1, n = rd[0]; n >= 10; n /= 10) k++;
      if (k < LOG_BASE) e -= LOG_BASE - k;
    }
    r.e = e;
    r.d = rd;
    return r;
  }
  function round(x) {
    return finalise(x = new this(x), x.e + 1, this.rounding);
  }
  function sign(x) {
    x = new this(x);
    return x.d ? x.d[0] ? x.s : 0 * x.s : x.s || NaN;
  }
  function sin(x) {
    return new this(x).sin();
  }
  function sinh2(x) {
    return new this(x).sinh();
  }
  function sqrt(x) {
    return new this(x).sqrt();
  }
  function sub(x, y) {
    return new this(x).sub(y);
  }
  function sum() {
    var i = 0, args = arguments, x = new this(args[i]);
    external = false;
    for (; x.s && ++i < args.length; ) x = x.plus(args[i]);
    external = true;
    return finalise(x, this.precision, this.rounding);
  }
  function tan(x) {
    return new this(x).tan();
  }
  function tanh(x) {
    return new this(x).tanh();
  }
  function trunc(x) {
    return finalise(x = new this(x), x.e + 1, 1);
  }
  P[Symbol.for("nodejs.util.inspect.custom")] = P.toString;
  P[Symbol.toStringTag] = "Decimal";
  var Decimal = P.constructor = clone(DEFAULTS);
  LN10 = new Decimal(LN10);
  PI = new Decimal(PI);

  // src/common/type/primitive.ts
  var NUMERIC_TYPES = [
    "number",
    "finite_number",
    "complex",
    "finite_complex",
    "imaginary",
    "real",
    "finite_real",
    "rational",
    "finite_rational",
    "integer",
    "finite_integer",
    "non_finite_number"
  ];
  var COLLECTION_TYPES = [
    "collection",
    "list",
    "set",
    "tuple",
    "map"
  ];
  var SCALAR_TYPES = [
    "scalar",
    ...NUMERIC_TYPES,
    "boolean",
    "string"
  ];
  var VALUE_TYPES = [
    "value",
    ...COLLECTION_TYPES,
    ...SCALAR_TYPES
  ];
  var EXPRESSION_TYPES = [
    "expression",
    "symbol",
    "function",
    ...VALUE_TYPES
  ];
  var PRIMITIVE_TYPES = [
    "any",
    "unknown",
    "nothing",
    "never",
    "error",
    ...EXPRESSION_TYPES
  ];

  // src/common/type/serialize.ts
  var NEGATION_PRECEDENCE = 3;
  var UNION_PRECEDENCE = 1;
  var INTERSECTION_PRECEDENCE = 2;
  var LIST_PRECEDENCE = 4;
  var MAP_PRECEDENCE = 5;
  var SET_PRECEDENCE = 6;
  var COLLECTION_PRECEDENCE = 7;
  var TUPLE_PRECEDENCE = 8;
  var SIGNATURE_PRECEDENCE = 9;
  var VALUE_PRECEDENCE = 10;
  function typeToString(type2, precedence = 0) {
    if (typeof type2 === "string") return type2;
    let result = "";
    switch (type2.kind) {
      case "value":
        if (typeof type2.value === "string") result = `"${type2.value}"`;
        else if (typeof type2.value === "boolean")
          result = type2.value ? "true" : "false";
        else result = type2.value.toString();
        break;
      case "reference":
        result = type2.ref;
        break;
      case "negation":
        result = `!${typeToString(type2.type, NEGATION_PRECEDENCE)}`;
        break;
      case "union":
        result = type2.types.map((t) => typeToString(t, UNION_PRECEDENCE)).join(" | ");
        break;
      case "intersection":
        result = type2.types.map((t) => typeToString(t, INTERSECTION_PRECEDENCE)).join(" & ");
        break;
      case "list":
        if (type2.dimensions && isSubtype(type2.elements, "number")) {
          if (type2.dimensions === void 0) {
            if (type2.elements === "number") result = "tensor";
          } else if (type2.dimensions.length === 1) {
            if (type2.elements === "number") {
              if (type2.dimensions[0] < 0) result = "vector";
              else result = `vector<${type2.dimensions[0]}>`;
            } else {
              if (type2.dimensions[0] < 0)
                result = `vector<${typeToString(type2.elements)}>`;
              else
                result = `vector<${typeToString(type2.elements)}^${type2.dimensions[0]}>`;
            }
          } else if (type2.dimensions.length === 2) {
            const dims = type2.dimensions;
            if (type2.elements === "number") {
              if (dims[0] < 0 && dims[1] < 0) result = "matrix";
              else result = `matrix<${dims[0]}x${dims[1]}>`;
            } else {
              if (dims[0] < 0 && dims[1] < 0)
                result = `matrix<${typeToString(type2.elements)}>`;
              else
                result = `matrix<${typeToString(type2.elements)}^(${dims[0]}x${dims[1]})>`;
            }
          }
        }
        if (!result) {
          const dimensions = type2.dimensions ? type2.dimensions.length === 1 ? `^${type2.dimensions[0].toString()}` : `^(${type2.dimensions.join("x")})` : "";
          result = `list<${typeToString(type2.elements)}${dimensions}>`;
        }
        break;
      case "map":
        const elements = Object.entries(type2.elements).map(([key, value]) => `${key}: ${typeToString(value)}`).join(", ");
        result = `map<${elements}>`;
        break;
      case "set":
        result = `set<${typeToString(type2.elements)}>`;
        break;
      case "collection":
        result = `collection<${typeToString(type2.elements)}>`;
        break;
      case "tuple":
        if (type2.elements.length === 0) result = "tuple";
        else if (type2.elements.length === 1) {
          const [el] = type2.elements;
          result = `tuple<${namedElement(el)}>`;
        } else {
          result = "tuple<" + type2.elements.map((el) => namedElement(el)).join(", ") + ">";
        }
        break;
      case "signature":
        const args = type2.args ? type2.args.map((arg) => namedElement(arg)).join(", ") : "";
        const optArgs = type2.optArgs ? type2.optArgs.map((arg) => namedElement(arg) + "?").join(", ") : "";
        const restArg = type2.restArg ? `...${namedElement(type2.restArg)}` : "";
        const argsList = [args, optArgs, restArg].filter((s) => s).join(", ");
        result = `(${argsList}) -> ${typeToString(type2.result)}`;
        break;
      default:
        result = "error";
    }
    if (precedence > 0 && precedence > getPrecedence(type2.kind))
      return `(${result})`;
    return result;
  }
  function namedElement(el) {
    if (el.name) return `${el.name}: ${typeToString(el.type)}`;
    return typeToString(el.type);
  }
  function getPrecedence(kind) {
    switch (kind) {
      case "negation":
        return NEGATION_PRECEDENCE;
      case "union":
        return UNION_PRECEDENCE;
      case "intersection":
        return INTERSECTION_PRECEDENCE;
      case "list":
        return LIST_PRECEDENCE;
      case "map":
        return MAP_PRECEDENCE;
      case "set":
        return SET_PRECEDENCE;
      case "collection":
        return COLLECTION_PRECEDENCE;
      case "tuple":
        return TUPLE_PRECEDENCE;
      case "signature":
        return SIGNATURE_PRECEDENCE;
      case "value":
        return VALUE_PRECEDENCE;
      default:
        return 0;
    }
  }

  // src/common/type/utils.ts
  function narrow2(a, b) {
    if (a === b) return a;
    if (a === "nothing" || b === "nothing") return "nothing";
    if (a === "any") return b;
    if (b === "any") return a;
    if (a === "never") return b;
    if (b === "never") return a;
    if (a === "unknown") return b;
    if (b === "unknown") return a;
    if (isSubtype(a, b)) return a;
    if (isSubtype(b, a)) return b;
    return superType(a, b);
  }
  function widen2(a, b) {
    if (a === b) return a;
    if (a === "any" || b === "any") return "any";
    if (a === "never") return b;
    if (b === "never") return a;
    if (a === "unknown") return b;
    if (b === "unknown") return a;
    if (a === "nothing") return b;
    if (b === "nothing") return a;
    if (isSubtype(a, b)) return b;
    if (isSubtype(b, a)) return a;
    return superType(a, b);
  }
  function narrow(...types) {
    if (types.length === 0) return "nothing";
    if (types.length === 1) return types[0];
    return types.reduce(narrow2);
  }
  function widen(...types) {
    if (types.length === 0) return "nothing";
    if (types.length === 1) return types[0];
    return types.reduce(widen2);
  }
  function isSignatureType(type2) {
    type2 = typeof type2 === "string" ? parseType(type2) : type2;
    return typeof type2 !== "string" && type2.kind === "signature";
  }
  function functionResult(type2) {
    if (!type2) return void 0;
    if (type2 === "function") return "any";
    if (typeof type2 === "string") return void 0;
    if (type2.kind === "signature") return type2.result;
    return void 0;
  }
  function collectionElementType(type2) {
    if (type2 === "collection") return "any";
    if (typeof type2 === "string") return void 0;
    if (type2.kind === "collection") return type2.elements;
    if (type2.kind === "list") return type2.elements;
    if (type2.kind === "map")
      return parseType(
        `tuple<string, ${widen(...Object.values(type2.elements))}>`
      );
    if (type2.kind === "set") return type2.elements;
    if (type2.kind === "tuple") return widen(...type2.elements.map((x) => x.type));
    return void 0;
  }
  function isValidType(t) {
    if (typeof t === "string")
      return PRIMITIVE_TYPES.includes(t);
    if (typeof t !== "object") return false;
    if (!("kind" in t)) return false;
    return t.kind === "signature" || t.kind === "union" || t.kind === "intersection" || t.kind === "negation" || t.kind === "tuple" || t.kind === "list" || t.kind === "map" || t.kind === "set" || t.kind === "function" || t.kind === "collection" || t.kind === "reference";
  }
  function superType(a, b) {
    if (a === b) return a;
    if (a === "any" || b === "any") return "any";
    if (a === "never") return b;
    if (b === "never") return a;
    if (a === "unknown") return b;
    if (b === "unknown") return a;
    if (a === "nothing") return b;
    if (b === "nothing") return a;
    if (commonSupertype(a, b, "non_finite_number")) return "non_finite_number";
    if (commonSupertype(a, b, "finite_integer")) return "finite_integer";
    if (commonSupertype(a, b, "integer")) return "integer";
    if (commonSupertype(a, b, "finite_rational")) return "finite_rational";
    if (commonSupertype(a, b, "rational")) return "rational";
    if (commonSupertype(a, b, "finite_real")) return "finite_real";
    if (commonSupertype(a, b, "real")) return "real";
    if (commonSupertype(a, b, "imaginary")) return "imaginary";
    if (commonSupertype(a, b, "finite_complex")) return "finite_complex";
    if (commonSupertype(a, b, "complex")) return "complex";
    if (commonSupertype(a, b, "finite_number")) return "finite_number";
    if (commonSupertype(a, b, "number")) return "number";
    if (commonSupertype(a, b, "list")) return "list";
    if (commonSupertype(a, b, "map")) return "map";
    if (commonSupertype(a, b, "set")) return "set";
    if (commonSupertype(a, b, "tuple")) return "tuple";
    if (commonSupertype(a, b, "collection")) return "collection";
    if (commonSupertype(a, b, "scalar")) return "scalar";
    if (commonSupertype(a, b, "value")) return "value";
    if (commonSupertype(a, b, "function")) return "function";
    if (commonSupertype(a, b, "expression")) return "expression";
    return "any";
  }
  function commonSupertype(a, b, ancestor) {
    if (isSubtype(a, ancestor) && isSubtype(b, ancestor)) return true;
    return false;
  }

  // src/common/fuzzy-string-match.ts
  function levenshtein(source, target) {
    if (source === target) return 0;
    if (source.length === 0) return target.length;
    if (target.length === 0) return source.length;
    let prevRow = Array.from(
      { length: source.length + 1 },
      (_, j) => j
    );
    let currRow = new Array(source.length + 1);
    for (let i = 1; i <= target.length; i++) {
      currRow[0] = i;
      for (let j = 1; j <= source.length; j++) {
        const cost = source[j - 1] === target[i - 1] ? 0 : 1;
        currRow[j] = Math.min(
          prevRow[j] + 1,
          // deletion
          currRow[j - 1] + 1,
          // insertion
          prevRow[j - 1] + cost
          // substitution
        );
      }
      [prevRow, currRow] = [currRow, prevRow];
    }
    return prevRow[source.length];
  }
  function fuzzyStringMatch(invalidWord, validWords) {
    const threshold = 3;
    let bestMatch = null;
    let minDistance = Infinity;
    const invalidLength = invalidWord.length;
    for (const word of validWords) {
      if (Math.abs(invalidLength - word.length) > threshold) continue;
      const distance = levenshtein(invalidWord, word);
      if (distance === 0) return word;
      if (distance <= threshold && distance < minDistance) {
        minDistance = distance;
        bestMatch = word;
      }
    }
    return bestMatch;
  }

  // src/common/type/parse.ts
  var TypeParser = class {
    constructor(buffer, options) {
      this.buffer = buffer;
      this.pos = 0;
      this._valueParser = options?.value ?? (() => null);
      this._typeParser = options?.type ?? (() => null);
    }
    error(...messages) {
      throw new Error(
        `
Invalid type
|   ${this.buffer}
|   ${" ".repeat(this.pos)}^
|   
|   ${messages.join("\n|   ")}
`
      );
    }
    peek() {
      return this.buffer[this.pos];
    }
    consume() {
      return this.buffer[this.pos++];
    }
    match(s) {
      if (s.length === 1 && this.buffer[this.pos] === s) {
        this.pos++;
        return true;
      }
      const pos = this.pos;
      if (this.buffer.slice(pos, pos + s.length) === s) {
        this.pos += s.length;
        return true;
      }
      return false;
    }
    /** If a white space is allowed, call before `consume()` or `match()` */
    skipWhitespace() {
      while (this.pos < this.buffer.length && /\s/.test(this.buffer[this.pos]))
        this.pos++;
    }
    isEOF() {
      return this.pos >= this.buffer.length;
    }
    parseValue() {
      this.skipWhitespace();
      const value = this._valueParser(this);
      if (value === null) return null;
      return { kind: "value", value };
    }
    parseTypeReference() {
      this.skipWhitespace();
      const ref = this._typeParser(this);
      if (ref === null) return null;
      return { kind: "reference", ref };
    }
    parsePrimitiveType() {
      this.skipWhitespace();
      if (this.isEOF()) this.error("Unexpected end of input");
      for (const type2 of PRIMITIVE_TYPES) if (this.match(type2)) return type2;
      return null;
    }
    // Arguments are `name: type` or `type` separated by commas
    parseArguments() {
      const reqArgs = [];
      const optArgs = [];
      while (true) {
        const arg = this.parseNamedElement();
        if (arg === null) break;
        if (this.match("?")) optArgs.push(arg);
        else {
          if (optArgs.length > 0)
            this.error("Optional arguments must come after required arguments");
          reqArgs.push(arg);
        }
        this.skipWhitespace();
        if (!this.match(",")) break;
      }
      const restPos = this.pos;
      const restArg = this.parseRestArgument() ?? void 0;
      if (restArg && optArgs.length > 0) {
        this.pos = restPos;
        this.error("Optional arguments cannot be followed by a rest argument");
      }
      const duplicate = checkDuplicateNames([
        ...reqArgs,
        ...optArgs,
        ...restArg ? [restArg] : []
      ]);
      if (duplicate) this.error(`Duplicate argument name "${duplicate}"`);
      return [reqArgs, optArgs, restArg];
    }
    // Rest argument is `name: ...type` or `...type`
    parseRestArgument() {
      const pos = this.pos;
      const name = this.parseName();
      this.skipWhitespace();
      if (!this.match("...")) {
        this.pos = pos;
        return null;
      }
      let type2 = this.parsePrimitiveType() ?? this.parseGroup();
      if (!type2) {
        if (!name) {
          this.pos = pos;
          if (this.match("...") && this.parseName()) {
            const type3 = this.parsePrimitiveType() ?? this.parseGroup();
            this.pos = pos;
            this.error(
              "The rest argument indicator is placed before the type, not the name",
              `Use "${name}: ...${type3 ? typeToString(type3) : "number"}"`
            );
          }
        }
      }
      this.skipWhitespace();
      if (this.match(":"))
        this.error('Unexpected ":" after rest argument. Use "x: ...number"');
      type2 ?? (type2 = "any");
      return name ? { name, type: type2 } : { type: type2 };
    }
    parseFunctionSignature() {
      let args = [];
      let optArgs = [];
      let restArg = void 0;
      this.skipWhitespace();
      let pos = this.pos;
      if (this.match("()")) {
      } else if (this.match("(")) {
        [args, optArgs, restArg] = this.parseArguments();
        this.skipWhitespace();
        if (!this.match(")")) {
          if (restArg) {
            const el = this.parseNamedElement();
            if (el) {
              this.pos = pos;
              this.error("The rest argument must be the last argument");
            }
            this.error("The rest argument must have a valid type");
          }
          if (optArgs.length > 0) {
            const el = this.parseNamedElement();
            if (el)
              this.error(
                "Optional arguments cannot be followed by required arguments"
              );
            this.skipWhitespace();
            pos = this.pos;
            if (this.match("->")) {
              this.pos = pos;
              this.error('Expected ")" to close the argument list');
            }
            this.error("Expected an argument");
          }
          this.pos = pos;
          return null;
        }
      } else {
        restArg = this.parseRestArgument() ?? void 0;
        if (restArg?.name) {
          this.pos = pos;
          this.error("Named arguments must be enclosed in parentheses");
        }
        if (!restArg) {
          this.pos = pos;
          return null;
        }
      }
      this.skipWhitespace();
      if (!this.match("->")) {
        this.pos = pos;
        return null;
      }
      const returnType = this.parseType();
      if (returnType === null)
        this.error(
          "Expected a return type.",
          "Use `any` for any type, `nothing` for no return value, or `never` for a function that never returns"
        );
      if (args.length === 0) args = void 0;
      if (optArgs.length === 0) optArgs = void 0;
      return {
        kind: "signature",
        args,
        optArgs,
        restArg,
        result: returnType
      };
    }
    parsePositiveIntegerLiteral() {
      let value = 0;
      this.skipWhitespace();
      while (/[0-9]/.test(this.peek()))
        value = value * 10 + parseInt(this.consume());
      if (value === 0) return null;
      return value;
    }
    parseOptionalDimension() {
      let dim = this.parsePositiveIntegerLiteral();
      if (dim === null && this.match("?")) dim = -1;
      return dim;
    }
    parseDimensions() {
      const pos = this.pos;
      const hasParen = this.match("(");
      const dimensions = [];
      let dim = this.parseOptionalDimension();
      if (dim === null) {
        this.pos = pos;
        return void 0;
      }
      do {
        dimensions.push(dim);
        this.skipWhitespace();
        if (!this.match("x")) break;
        this.skipWhitespace();
        dim = this.parseOptionalDimension();
        if (dim === null)
          this.error(
            "Expected a positive integer literal or `?`.",
            "For example : `matrix<integer^2x3>` or `matrix<integer^?x?>`"
          );
      } while (true);
      this.skipWhitespace();
      if (hasParen && !this.match(")"))
        this.error('Expected ")".', "For example `matrix<integer^(2x3)>`");
      return dimensions;
    }
    parseList() {
      this.skipWhitespace();
      if (this.match("list<")) {
        let dimensions2 = this.parseDimensions();
        if (dimensions2 !== void 0) {
          this.skipWhitespace();
          if (!this.match(">"))
            this.error('Expected ">".', "For example `list<2x3>`");
          return { kind: "list", elements: "any", dimensions: dimensions2 };
        }
        const type3 = this.parseType();
        if (type3 && this.match("^")) {
          dimensions2 = this.parseDimensions();
          if (dimensions2 === void 0)
            this.error(
              "Expected dimensions after `^`.",
              "For example `list<number^2x3>`"
            );
        }
        this.skipWhitespace();
        if (!this.match(">"))
          this.error('Expected ">".', "For example `list<number>`");
        return { kind: "list", elements: type3 ?? "any", dimensions: dimensions2 };
      }
      if (this.match("list(")) {
        this.error(
          "Use `list<type>` instead of `list(type)`.",
          "For example `list<number>`"
        );
      }
      if (this.match("vector<")) {
        let type3 = this.parseType();
        let dimensions2 = void 0;
        if (type3 && this.match("^")) {
          const size = this.parsePositiveIntegerLiteral();
          if (size === null)
            this.error(
              "Expected a positive integer literal.",
              "For example `vector<3>`",
              "Use `vector` for a vector of unknown size"
            );
          dimensions2 = [size];
        } else if (!type3) {
          type3 = "number";
          dimensions2 = this.parseDimensions();
        }
        this.skipWhitespace();
        if (!this.match(">"))
          this.error('Expected ">"', "For example `vector<integer>`");
        return { kind: "list", elements: type3, dimensions: dimensions2 };
      }
      if (this.match("vector(")) {
        this.error(
          "Use `vector<...>` instead of `vector(...)`.",
          "For example `vector<3>` or `vector<integer^3>`"
        );
      }
      if (this.match("vector")) return { kind: "list", elements: "number" };
      if (this.match("matrix<")) {
        let type3 = this.parseType();
        let dimensions2 = void 0;
        if (type3 && this.match("^")) {
          dimensions2 = this.parseDimensions();
          if (dimensions2 === void 0)
            this.error(
              "Expected dimensions",
              "For example `matrix<number^2x3>`",
              "Use `matrix` for a matrix of unknown size"
            );
        } else if (!type3) {
          type3 = "number";
          dimensions2 = this.parseDimensions();
        }
        if (!this.match(">"))
          this.error('Expected ">".', "For example `matrix<integer>`");
        return { kind: "list", elements: type3, dimensions: dimensions2 };
      }
      if (this.match("matrix(")) {
        this.error(
          "Use `matrix<...>` instead of `matrix(...)`.",
          "For example `matrix<3x2>` or `matrix<integer^3x2>`"
        );
      }
      if (this.match("matrix"))
        return {
          kind: "list",
          elements: "number",
          dimensions: [-1, -1]
        };
      if (this.match("tensor<")) {
        const type3 = this.parseType() ?? "number";
        if (!this.match(">"))
          this.error('Expected ">".', "For example `tensor<number>`");
        return { kind: "list", elements: type3, dimensions: void 0 };
      }
      if (this.match("tensor"))
        return {
          kind: "list",
          elements: "number",
          dimensions: void 0
        };
      if (!this.match("list<")) return null;
      const type2 = this.parseType();
      if (type2 === null)
        this.error('Expected a type. Use "[any]" for a collection of any type');
      const dimensions = this.match("^") ? this.parseDimensions() : void 0;
      this.skipWhitespace();
      if (!this.match(">"))
        this.error('Expected ">".', "For example `list<number^2x3>`");
      return { kind: "list", elements: type2, dimensions };
    }
    parseName() {
      const pos = this.pos;
      this.skipWhitespace();
      if (this.isEOF()) return null;
      if (!/[a-zA-Z_]/.test(this.peek())) return null;
      let name = "";
      while (!this.isEOF() && /[a-zA-Z0-9_]/.test(this.peek()))
        name += this.consume();
      this.skipWhitespace();
      if (!this.match(":")) {
        if (this.match("?:")) {
          const type2 = this.parseType();
          if (type2)
            this.error(
              "Optional qualifier must come after the type",
              `Use "${name}: ${typeToString(type2)}?"`
            );
          this.error(
            "Optional qualifier must come after the type",
            `Use "${name}: number?"`
          );
        }
        this.pos = pos;
        return null;
      }
      return name;
    }
    parseKey() {
      this.skipWhitespace();
      if (this.isEOF()) return null;
      let key = "";
      if (this.match("`")) {
        while (this.peek() !== "`") {
          if (this.isEOF()) this.error("Expected closing backtick");
          if (this.match("\\`")) key += "`";
          else key += this.consume();
        }
        return key;
      }
      while (!this.isEOF() && !/[:\s]/.test(this.peek())) key += this.consume();
      return key;
    }
    /** Parse:
     * - "<identifier>: <type>"
     * - "<type>"
     */
    parseNamedElement() {
      const pos = this.pos;
      const name = this.parseName();
      if (name !== null) {
        const type3 = this.parseType();
        if (type3 === null) {
          this.skipWhitespace();
          if (this.match("...")) {
            this.pos = pos;
            return null;
          }
          this.pos = pos;
          this.error(`Expected a valid type after "${name}:"`);
        }
        this.skipWhitespace();
        if (this.match("->")) {
          this.pos = pos;
          this.error("Single named argument must be enclosed in parentheses");
        }
        return { name, type: type3 };
      }
      const type2 = this.parseType();
      if (type2 === null) {
        this.pos = pos;
        return null;
      }
      return { type: type2 };
    }
    parseTupleElements() {
      const elements = [];
      let pos = this.pos;
      let type2 = this.parseNamedElement();
      if (type2 === null) return [];
      while (true) {
        elements.push(type2);
        this.skipWhitespace();
        if (!this.match(",")) break;
        pos = this.pos;
        type2 = this.parseNamedElement();
        if (type2 === null) {
          this.pos = pos;
          this.error("Expected a type or unexpected comma");
        }
      }
      const duplicate = checkDuplicateNames(elements);
      if (duplicate) this.error(`Duplicate tuple named element "${duplicate}"`);
      return elements;
    }
    parseTuple() {
      this.skipWhitespace();
      if (!this.match("tuple<")) {
        if (this.match("tuple(")) {
          this.error(
            "Use `tuple<type>` instead of `tuple(type)`.",
            "For example `tuple<number, boolean>` or `tuple<x: integer, y: integer>`"
          );
        }
        return null;
      }
      const elements = this.parseTupleElements();
      this.skipWhitespace();
      if (!this.match(">"))
        this.error(
          'Expected ">".',
          "For example `tuple<number, boolean>` or `tuple<x: integer, y: integer>`"
        );
      return { kind: "tuple", elements };
    }
    /** Parse a non-optional group, i.e. "(" <type> ")" */
    parseGroup() {
      const pos = this.pos;
      this.skipWhitespace();
      if (!this.match("(")) return null;
      const type2 = this.parseType();
      if (type2 === null) {
        this.pos = pos;
        return null;
      }
      this.skipWhitespace();
      if (this.match(")")) {
        this.skipWhitespace();
        if (!this.match("->")) return type2;
      }
      this.pos = pos;
      return null;
    }
    parseSet() {
      this.skipWhitespace();
      if (!this.match("set<")) {
        if (this.match("set(")) {
          this.error(
            "Use `set<type>` instead of `set(type)`.",
            "For example `set<number>`"
          );
        }
        if (this.match("set")) return "set";
        return null;
      }
      const type2 = this.parseType();
      if (type2 === null)
        this.error("Expected a type.", "Use `set<number>` for a set of numbers");
      this.skipWhitespace();
      if (!this.match(">"))
        this.error("Expected `>`.", "For example `set<number>`");
      return { kind: "set", elements: type2 };
    }
    parseMapElements() {
      const entries = [];
      while (true) {
        const key = this.parseKey();
        if (key === null)
          this.error(
            "Expected a name for the key.",
            "For example `map<key: string>`.",
            "Use backticks for special characters.",
            "For example `map<`key with space`: string>`"
          );
        this.skipWhitespace();
        if (!this.match(":"))
          this.error(
            "Expected a type separated by a `:` after the key.",
            `For example \`map<${key}: string>\``,
            "Use backticks for special characters.",
            "For example `map<`key with space`: string>`"
          );
        const value = this.parseType();
        if (value === null)
          this.error(
            "Expected a type for the value. Use `any` for any type.",
            `For example \`map<${key}: any>.\``
          );
        entries.push([key, value]);
        this.skipWhitespace();
        if (!this.match(",")) break;
      }
      const keySet = new Set(entries.map(([key]) => key));
      if (keySet.size !== entries.length) {
        const duplicate = entries.find(
          ([key], index) => entries.slice(index + 1).some(([k]) => k === key)
        )?.[0];
        this.error(
          `Duplicate map key "${duplicate}"`,
          "Keys in a map must be unique."
        );
      }
      return entries;
    }
    parseMap() {
      this.skipWhitespace();
      if (this.match("map(")) {
        this.error(
          'Use `map<key: type>` instead of `map(key: type)".',
          "For example `map<key: string>`"
        );
      }
      if (this.match("map<")) {
        const entries = this.parseMapElements();
        this.skipWhitespace();
        if (!this.match(">"))
          this.error("Expected a closing `>`.", "For example `map<key: string>`");
        return { kind: "map", elements: Object.fromEntries(entries) };
      }
      if (this.match("map")) return "map";
      return null;
    }
    // A generic collection type, e.g. `collection<number>`
    parseCollection() {
      this.skipWhitespace();
      if (!this.match("collection<")) {
        if (this.match("collection(")) {
          this.error(
            "Use `collection<type>` instead of `collection(type)`.",
            "For example `collection<number>`"
          );
        }
        if (this.match("collection")) return "collection";
        return null;
      }
      const type2 = this.parseType();
      if (type2 === null)
        this.error(
          "Expected a type.",
          "Use `collection<number>` for a collection of numbers"
        );
      this.skipWhitespace();
      if (!this.match(">"))
        this.error('Expected ">".', "For example `collection<number>`");
      return { kind: "collection", elements: type2 };
    }
    parsePrimary() {
      let result = this.parseGroup() ?? this.parseNegationType() ?? this.parseList() ?? this.parseSet() ?? this.parseMap() ?? this.parseCollection() ?? this.parseTuple() ?? this.parsePrimitiveType() ?? this.parseValue() ?? this.parseTypeReference();
      if (result === null) {
        let keyword = "";
        while (!this.isEOF() && /[a-zA-Z_]/.test(this.peek()))
          keyword += this.consume();
        if (!keyword) return null;
        const suggest = fuzzyStringMatch(keyword, [
          ...PRIMITIVE_TYPES,
          "vector",
          "matrix"
        ]);
        if (suggest)
          this.error(
            `Unknown keyword "${keyword}"`,
            `Did you mean "${suggest}"?`
          );
        return null;
      }
      this.skipWhitespace();
      if (this.match("->")) {
        const returnType = this.parseType();
        if (returnType === null)
          this.error(
            "Expected return type",
            "Use `any` for any type, `nothing` for no return value or `never` for a function that never returns"
          );
        result = {
          kind: "signature",
          args: [{ type: result }],
          result: returnType
        };
      }
      return result;
    }
    parseNegationType() {
      if (!this.match("!")) return null;
      const type2 = this.parsePrimary();
      if (type2 === null) this.error("Expected type");
      return { kind: "negation", type: type2 };
    }
    // <intersection_type> ::= <primary_type> (" & " <primary_type>)*
    parseIntersectionType() {
      let type2 = this.parseFunctionSignature() ?? this.parsePrimary();
      if (type2 === null) return null;
      const types = [type2];
      this.skipWhitespace();
      while (this.match("&")) {
        this.skipWhitespace();
        type2 = this.parsePrimary();
        if (type2 === null) this.error("Expected type");
        types.push(type2);
      }
      if (types.length === 1) return types[0];
      return { kind: "intersection", types };
    }
    // <union_type> ::= <intersection_type> <union_type> " | "
    // | <intersection_type>
    parseUnionType() {
      let type2 = this.parseIntersectionType();
      if (type2 === null) return null;
      const types = [type2];
      this.skipWhitespace();
      while (this.match("|")) {
        type2 = this.parseIntersectionType();
        if (type2 === null) this.error("Expected type");
        types.push(type2);
      }
      if (types.length === 1) return types[0];
      return { kind: "union", types };
    }
    // <type> ::=  "(" <type> ")" | <union_type>
    parseType() {
      this.skipWhitespace();
      if (this.isEOF()) return null;
      if (this.peek() === "(") {
        const signature = this.parseFunctionSignature();
        if (signature) return signature;
      }
      return this.parseUnionType();
    }
    parse() {
      const pos = this.pos;
      if (this.parseName() !== null) {
        this.pos = pos;
        this.error("Named elements must be enclosed in parentheses");
      }
      const type2 = this.parseType();
      if (type2 === null) this.error("Syntax error. The type was not recognized.");
      this.skipWhitespace();
      if (!this.isEOF())
        this.error("Unexpected character. Could be some mismatched parentheses.");
      return type2;
    }
  };
  function valueParser(parser) {
    const pos = parser.pos;
    parser.skipWhitespace();
    if (/["]/.test(parser.peek())) {
      const quote = parser.consume();
      let value = "";
      while (parser.peek() !== quote) {
        if (parser.isEOF()) parser.error("Expected closing quote");
        if (parser.match("\\" + quote)) value += quote;
        else value += parser.consume();
      }
      parser.consume();
      return value;
    }
    if (parser.match("0x")) {
      let value = 0;
      while (/[0-9a-fA-F]/.test(parser.peek()))
        value = value * 16 + parseInt(parser.consume(), 16);
      return value;
    }
    if (parser.match("0b")) {
      let value = 0;
      while (/[01]/.test(parser.peek()))
        value = value * 2 + parseInt(parser.consume());
      return value;
    }
    if (/[-0-9\.]/.test(parser.peek())) {
      let value = 0;
      let sign2 = 1;
      if (parser.match("-")) sign2 = -1;
      if (!/[0-9]/.test(parser.peek())) {
        parser.pos = pos;
        return null;
      }
      while (/[0-9]/.test(parser.peek()))
        value = value * 10 + parseInt(parser.consume());
      if (parser.match(".")) {
        let fraction = 0;
        let scale = 1;
        while (/[0-9]/.test(parser.peek())) {
          fraction = fraction * 10 + parseInt(parser.consume());
          scale *= 10;
        }
        value += fraction / scale;
      }
      if (parser.match("e") || parser.match("E")) {
        let exponent = 0;
        let expSign = 1;
        if (parser.match("+")) expSign = 1;
        if (parser.match("-")) expSign = -1;
        while (/[0-9]/.test(parser.peek()))
          exponent = exponent * 10 + parseInt(parser.consume());
        value *= Math.pow(10, expSign * exponent);
      }
      return sign2 * value;
    }
    if (parser.match("true")) return true;
    if (parser.match("false")) return false;
    if (parser.match("nan")) return NaN;
    if (parser.match("infinity")) return Infinity;
    if (parser.match("-infinity")) return -Infinity;
    parser.pos = pos;
    return null;
  }
  function parseType(s) {
    if (s === void 0) return void 0;
    if (isValidType(s)) return s;
    if (typeof s !== "string") return void 0;
    if (PRIMITIVE_TYPES.includes(s)) return s;
    const parser = new TypeParser(s, { value: valueParser });
    return parser.parse();
  }
  function checkDuplicateNames(elements) {
    const names = /* @__PURE__ */ new Set();
    for (const { name } of elements) {
      if (name) {
        if (names.has(name)) return name;
        names.add(name);
      }
    }
    return "";
  }

  // src/common/type/subtype.ts
  var PRIMITIVE_SUBTYPES = {
    number: NUMERIC_TYPES,
    non_finite_number: [],
    //  PositiveInfinity, NegativeInfinity
    finite_number: [
      "finite_complex",
      "finite_real",
      "finite_integer",
      "finite_rational"
    ],
    complex: [
      "finite_complex",
      "imaginary",
      "finite_real",
      "finite_rational",
      "finite_integer",
      "non_finite_number"
    ],
    finite_complex: [
      "imaginary",
      "finite_real",
      "finite_rational",
      "finite_integer"
    ],
    imaginary: [],
    // Pure, finite, imaginary number
    real: [
      "rational",
      "integer",
      "finite_real",
      "finite_rational",
      "finite_integer",
      "non_finite_number"
    ],
    finite_real: ["finite_rational", "finite_integer"],
    rational: [
      "finite_rational",
      "finite_integer",
      "integer",
      "non_finite_number"
    ],
    finite_rational: ["finite_integer"],
    integer: ["finite_integer", "non_finite_number"],
    finite_integer: [],
    any: PRIMITIVE_TYPES,
    unknown: [],
    nothing: [],
    never: [],
    error: [],
    value: VALUE_TYPES,
    scalar: SCALAR_TYPES,
    collection: COLLECTION_TYPES,
    list: [],
    set: [],
    tuple: [],
    map: [],
    function: [],
    symbol: [],
    boolean: [],
    string: [],
    expression: EXPRESSION_TYPES
  };
  function isPrimitiveSubtype(lhs, rhs) {
    if (rhs === "any") return true;
    if (lhs === "never") return true;
    if (lhs === "unknown" || rhs === "unknown") return false;
    if (lhs === rhs) return true;
    return PRIMITIVE_SUBTYPES[rhs].includes(lhs);
  }
  function isSubtype(lhs, rhs) {
    if (typeof lhs === "string" && typeof rhs === "string" && lhs === rhs)
      return true;
    if (typeof lhs === "string") lhs = parseType(lhs);
    if (typeof rhs === "string") rhs = parseType(rhs);
    if (rhs === "any") return true;
    if (rhs === "never") return false;
    if (rhs === "error") return false;
    if (rhs === "nothing") return lhs === "nothing";
    if (lhs === "nothing") return false;
    if (rhs === "unknown") return true;
    if (lhs === "unknown") return false;
    if (typeof rhs === "string") {
      if (typeof lhs === "string")
        return isPrimitiveSubtype(lhs, rhs);
      if (lhs.kind === "value") {
        if (typeof lhs.value === "boolean") return rhs === "boolean";
        if (typeof lhs.value === "number") {
          if (Number.isInteger(lhs.value))
            return isPrimitiveSubtype("integer", rhs);
          return isPrimitiveSubtype("number", rhs);
        }
        if (typeof lhs.value === "boolean")
          return isPrimitiveSubtype("boolean", rhs);
        if (typeof lhs.value === "string")
          return isPrimitiveSubtype("string", rhs);
        return false;
      }
      if (rhs === "numeric") return isNumeric(lhs);
      if (rhs === "function") return isFunction(lhs);
      if (rhs === "expression") return isExpression(lhs);
      if (rhs === "scalar") return isScalar(lhs);
      if (rhs === "value") return isValue(lhs);
      if (rhs === "collection") return isCollection(lhs);
      if (rhs === "tuple") return lhs.kind === "tuple";
      if (rhs === "list") return lhs.kind === "list";
      if (rhs === "set") return lhs.kind === "set";
      if (rhs === "map") return lhs.kind === "map";
      if (lhs.kind === "union") return lhs.types.every((t) => isSubtype(t, rhs));
      return false;
    }
    if (rhs.kind === "union") {
      if (typeof lhs !== "string" && lhs.kind === "union") {
        return lhs.types.every(
          (lhsType) => rhs.types.some((rhsType) => isSubtype(lhsType, rhsType))
        );
      }
      return rhs.types.some((t) => isSubtype(lhs, t));
    }
    if (typeof lhs === "string") return false;
    if (lhs.kind === "reference" && rhs.kind === "reference") {
      return lhs.ref === rhs.ref;
    }
    if (lhs.kind === "union") return lhs.types.some((t) => isSubtype(t, rhs));
    if (lhs.kind === "intersection" && rhs.kind === "intersection") {
      return rhs.types.every(
        (rhsType) => lhs.types.some((lhsType) => isSubtype(lhsType, rhsType))
      );
    }
    if (lhs.kind === "intersection") {
      return lhs.types.every((lhsType) => isSubtype(lhsType, rhs));
    }
    if (rhs.kind === "intersection") {
      return rhs.types.every((rhsType) => isSubtype(lhs, rhsType));
    }
    if (lhs.kind === "signature" && rhs.kind === "signature") {
      if (!isSubtype(lhs.result, rhs.result)) return false;
      if (rhs.args) {
        if (!lhs.args) return false;
        if (lhs.args.length !== rhs.args.length) return false;
        for (let i = 0; i < lhs.args.length; i++) {
          if (!isSubtype(rhs.args[i].type, lhs.args[i].type)) return false;
        }
      } else if (lhs.args) {
        return false;
      }
      if (rhs.optArgs) {
        if (!lhs.optArgs) return false;
        if (lhs.optArgs.length !== rhs.optArgs.length) return false;
        for (let i = 0; i < lhs.optArgs.length; i++) {
          if (!isSubtype(rhs.optArgs[i].type, lhs.optArgs[i].type)) return false;
        }
      } else if (lhs.optArgs) {
        return false;
      }
      if (rhs.restArg) {
        if (!lhs.restArg) return false;
        if (!isSubtype(rhs.restArg.type, lhs.restArg.type)) return false;
      } else if (lhs.restArg) {
        return false;
      }
      return true;
    }
    if (lhs.kind === "map" && rhs.kind === "map") {
      const lhsEntries = Object.entries(lhs.elements);
      const rhsEntries = Object.entries(rhs.elements);
      for (let i = 0; i < rhsEntries.length; i++) {
        const [key, value] = rhsEntries[i];
        const lhsIndex = lhsEntries.findIndex((entry) => entry[0] === key);
        if (lhsIndex === -1) return false;
        const rhsType = value;
        const lhsType = lhsEntries[lhsIndex][1];
        if (!isSubtype(lhsType, rhsType)) return false;
      }
      return true;
    }
    if (rhs.kind === "collection") {
      if (lhs.kind === "collection" || lhs.kind === "list" || lhs.kind === "set") {
        if (!isSubtype(lhs.elements, rhs.elements)) return false;
        return true;
      }
      if (lhs.kind === "tuple") {
        return lhs.elements.every(
          (element) => isSubtype(element.type, rhs.elements)
        );
      }
      return false;
    }
    if (lhs.kind === "tuple" && rhs.kind === "tuple") {
      if (lhs.elements.length !== rhs.elements.length) return false;
      for (let i = 0; i < lhs.elements.length; i++) {
        const a = lhs.elements[i];
        const b = rhs.elements[i];
        if (!isSubtype(a.type, b.type) || a.name !== b.name) return false;
      }
      return true;
    }
    if (rhs.kind === "list" && lhs.kind === "list") {
      43;
      if (!isSubtype(lhs.elements, rhs.elements)) return false;
      if (rhs.dimensions) {
        if (!lhs.dimensions) return false;
        if (lhs.dimensions.length !== rhs.dimensions.length) return false;
        for (let i = 0; i < lhs.dimensions.length; i++) {
          if (rhs.dimensions[i] !== -1 && lhs.dimensions[i] !== rhs.dimensions[i])
            return false;
        }
      }
      return true;
    }
    if (rhs.kind === "set" && lhs.kind === "set") {
      if (!isSubtype(lhs.elements, rhs.elements)) return false;
      return true;
    }
    if (lhs.kind === "negation" && rhs.kind === "negation") {
      return isSubtype(lhs.type, rhs.type);
    }
    if (rhs.kind === "negation") {
      return !isSubtype(lhs, rhs.type);
    }
    if (rhs.kind === "value" && lhs.kind === "value")
      return rhs.value === lhs.value;
    if (lhs.kind === "value") {
      if (typeof lhs.value === "boolean") return isSubtype("boolean", rhs);
      if (typeof lhs.value === "number") {
        if (Number.isInteger(lhs.value)) return isSubtype("integer", rhs);
        return isSubtype("real", rhs);
      }
      if (typeof lhs.value === "string") return isSubtype("string", rhs);
    }
    return false;
  }
  function isNumeric(type2) {
    if (typeof type2 === "string")
      return NUMERIC_TYPES.includes(type2);
    if (type2.kind === "value") return typeof type2.value === "number";
    return false;
  }
  function isScalar(type2) {
    if (isNumeric(type2)) return true;
    if (typeof type2 === "string")
      return SCALAR_TYPES.includes(type2);
    if (type2.kind === "value")
      return ["string", "boolean", "number"].includes(typeof type2.value);
    return false;
  }
  function isCollection(type2) {
    if (typeof type2 === "string")
      return COLLECTION_TYPES.includes(type2);
    return ["collection", "list", "set", "tuple", "map"].includes(type2.kind);
  }
  function isValue(type2) {
    return isScalar(type2) || isCollection(type2);
  }
  function isFunction(type2) {
    return type2 === "function" || typeof type2 !== "string" && type2.kind === "signature";
  }
  function isExpression(type2) {
    if (typeof type2 === "string" && ["expression", "symbol", "function"].includes(type2))
      return true;
    if (isValue(type2) || isFunction(type2)) return true;
    return false;
  }

  // src/common/type/boxed-type.ts
  var _BoxedType = class _BoxedType {
    constructor(type2) {
      if (typeof type2 === "string") this.type = parseType(type2);
      else this.type = type2;
    }
    matches(other) {
      if (other instanceof _BoxedType) return isSubtype(this.type, other.type);
      return isSubtype(this.type, other);
    }
    is(other) {
      return isSubtype(this.type, other) && isSubtype(other, this.type);
    }
    get isUnknown() {
      return this.type === "unknown";
    }
    toString() {
      return typeToString(this.type);
    }
    toJSON() {
      return typeToString(this.type);
    }
    [Symbol.toPrimitive](hint) {
      if (hint === "string") return this.toString();
      return null;
    }
    valueOf() {
      return typeToString(this.type);
    }
  };
  _BoxedType.unknown = new _BoxedType("unknown");
  var BoxedType = _BoxedType;

  // src/common/grapheme-splitter.ts
  function stringToCodepoints(string) {
    const result = [];
    for (let i = 0; i < string.length; i++) {
      let code = string.charCodeAt(i);
      if (code >= 55296 && code <= 56319) {
        const nextCode = string.charCodeAt(i + 1);
        if (nextCode >= 56320 && nextCode <= 57343) {
          const lead = code - 55296;
          const trail = nextCode - 56320;
          code = 2 ** 16 + lead * 2 ** 10 + trail;
          i++;
        }
      }
      result.push(code);
    }
    return result;
  }
  var ZWJ = 8205;
  var REGIONAL_INDICATOR = [127462, 127487];
  function isEmojiCombinator(code) {
    if (code === ZWJ) return true;
    if (code === 65038 || code === 65039) return true;
    if (code >= 127995 && code <= 127995 + 5) return true;
    if (code >= 129456 && code <= 129456 + 4) return true;
    if (code >= 917536 && code <= 917536 + 96) return true;
    return false;
  }
  function isRegionalIndicator(code) {
    return code >= REGIONAL_INDICATOR[0] && code <= REGIONAL_INDICATOR[1];
  }
  function splitGraphemes(string) {
    if (/^[\u0020-\u00FF]*$/.test(string)) return string;
    const result = [];
    const codePoints = stringToCodepoints(string);
    let index = 0;
    while (index < codePoints.length) {
      const code = codePoints[index++];
      const next = codePoints[index];
      if (next === ZWJ) {
        const baseIndex = index - 1;
        index += 2;
        while (codePoints[index] === ZWJ) {
          index += 2;
        }
        result.push(
          String.fromCodePoint(
            ...codePoints.slice(baseIndex, 2 * index - baseIndex + 1)
          )
        );
      } else if (isEmojiCombinator(next)) {
        const baseIndex = index - 1;
        while (isEmojiCombinator(codePoints[index])) {
          index += codePoints[index] === ZWJ ? 2 : 1;
        }
        result.push(
          String.fromCodePoint(
            ...codePoints.slice(baseIndex, 2 * index - baseIndex - 1)
          )
        );
      } else if (isRegionalIndicator(code)) {
        index += 1;
        result.push(String.fromCodePoint(...codePoints.slice(index - 2, 2)));
      } else {
        result.push(String.fromCodePoint(code));
      }
    }
    return result;
  }

  // src/compute-engine/latex-syntax/tokenizer.ts
  var Tokenizer = class {
    constructor(s) {
      this.obeyspaces = false;
      s = s.replace(/[\u200E\u200F\u2066-\u2069\u202A-\u202E]/g, "");
      s = s.replace(/\u2212/g, "-");
      this.s = splitGraphemes(s);
      this.pos = 0;
    }
    /**
     * @return True if we reached the end of the stream
     */
    end() {
      return this.pos >= this.s.length;
    }
    /**
     * Return the next char and advance
     */
    get() {
      return this.pos < this.s.length ? this.s[this.pos++] : "";
    }
    /**
     * Return the next char, but do not advance
     */
    peek() {
      return this.s[this.pos];
    }
    /**
     * Return the next substring matching regEx and advance.
     */
    match(regEx) {
      let execResult;
      if (typeof this.s === "string") {
        execResult = regEx.exec(this.s.slice(this.pos));
      } else {
        execResult = regEx.exec(this.s.slice(this.pos).join(""));
      }
      if (execResult?.[0]) {
        this.pos += execResult[0].length;
        return execResult[0];
      }
      return null;
    }
    /**
     * Return the next token, or null.
     */
    next() {
      if (this.end()) return null;
      if (!this.obeyspaces && this.match(/^[ \f\n\r\t\v\xA0\u2028\u2029]+/)) {
        return "<space>";
      } else if (this.obeyspaces && this.match(/^[ \f\n\r\t\v\xA0\u2028\u2029]/)) {
        return "<space>";
      }
      const next = this.get();
      if (next === "\\") {
        if (!this.end()) {
          let command = this.match(/^[a-zA-Z]+/);
          if (command) {
            this.match(/^[ \f\n\r\t\v\xA0\u2028\u2029]*/);
          } else {
            command = this.get();
            if (command === " ") {
              return "<space>";
            }
          }
          return "\\" + command;
        }
      } else if (next === "{") {
        return "<{>";
      } else if (next === "}") {
        return "<}>";
      } else if (next === "^") {
        if (this.peek() === "^") {
          this.get();
          const hex = this.match(
            /^(\^(\^(\^(\^[0-9a-f])?[0-9a-f])?[0-9a-f])?[0-9a-f])?[0-9a-f][0-9a-f]/
          );
          if (hex) {
            return String.fromCodePoint(
              parseInt(hex.slice(hex.lastIndexOf("^") + 1), 16)
            );
          }
        }
        return next;
      } else if (next === "#") {
        if (!this.end()) {
          let isParam = false;
          if (/[0-9?]/.test(this.peek())) {
            isParam = true;
            if (this.pos + 1 < this.s.length) {
              const after = this.s[this.pos + 1];
              isParam = /[^0-9A-Za-z]/.test(after);
            }
          }
          if (isParam) {
            return "#" + this.get();
          }
          return "#";
        }
      } else if (next === "$") {
        if (this.peek() === "$") {
          this.get();
          return "<$$>";
        }
        return "<$>";
      }
      return next;
    }
  };
  function expand(lex2, args) {
    let token = lex2.next();
    if (!token) return [];
    let result = [];
    if (token === "\\relax") {
    } else if (token === "\\noexpand") {
      token = lex2.next();
      if (token) {
        result.push(token);
      }
    } else if (token === "\\obeyspaces") {
      lex2.obeyspaces = true;
    } else if (token === "\\space" || token === "~") {
      result.push("<space>");
    } else if (token === "\\bgroup") {
      result.push("<{>");
    } else if (token === "\\egroup") {
      result.push("<}>");
    } else if (token === "\\string") {
      token = lex2.next();
      if (token) {
        if (token[0] === "\\") {
          Array.from(token).forEach(
            (x) => result.push(x === "\\" ? "\\backslash" : x)
          );
        } else if (token === "<{>") {
          result.push("\\{");
        } else if (token === "<space>") {
          result.push("~");
        } else if (token === "<}>") {
          result.push("\\}");
        }
      }
    } else if (token === "\\csname") {
      while (lex2.peek() === "<space>") {
        lex2.next();
      }
      let command = "";
      let done = false;
      let tokens = [];
      do {
        if (tokens.length === 0) {
          if (/^#[0-9?]$/.test(lex2.peek())) {
            const param = lex2.get().slice(1);
            tokens = tokenize(
              args?.[param] ?? args?.["?"] ?? "\\placeholder{}",
              args
            );
            token = tokens[0];
          } else {
            token = lex2.next();
            tokens = token ? [token] : [];
          }
        }
        done = tokens.length === 0;
        if (!done && token === "\\endcsname") {
          done = true;
          tokens.shift();
        }
        if (!done) {
          done = token === "<$>" || token === "<$$>" || token === "<{>" || token === "<}>" || !!token && token.length > 1 && token[0] === "\\";
        }
        if (!done) {
          command += tokens.shift();
        }
      } while (!done);
      if (command) {
        result.push("\\" + command);
      }
      result = result.concat(tokens);
    } else if (token === "\\endcsname") {
    } else if (token.length > 1 && token[0] === "#") {
      const param = token.slice(1);
      result = result.concat(
        tokenize(args?.[param] ?? args?.["?"] ?? "\\placeholder{}", args)
      );
    } else {
      result.push(token);
    }
    return result;
  }
  function tokenize(s, args = []) {
    const lines = s.toString().split(/\r?\n/);
    let stream = "";
    let sep = "";
    for (const line of lines) {
      stream += sep;
      sep = " ";
      const m = line.match(/((?:\\%)|[^%])*/);
      if (m !== null) stream += m[0];
    }
    const tokenizer = new Tokenizer(stream);
    const result = [];
    do
      result.push(...expand(tokenizer, args));
    while (!tokenizer.end());
    return result;
  }
  function countTokens(s) {
    return tokenize(s).length;
  }
  function joinLatex(segments) {
    let sep = "";
    let result = "";
    for (const segment of segments) {
      if (segment === void 0 || segment === null) continue;
      if (typeof segment === "string") {
        if (/[a-zA-Z]/.test(segment[0])) result += sep;
        if (/\\[a-zA-Z]+\*?$/.test(segment)) sep = " ";
        else sep = "";
      }
      result += segment.toString();
    }
    return result;
  }
  function supsub(c, body, x) {
    if (body.includes(c)) body = `{${body}}`;
    if (/^[0-9]$/.test(x)) return `${body}${c}${x}`;
    return `${body}${c}{${x}}`;
  }
  function tokensToString(tokens) {
    let flat = [];
    if (Array.isArray(tokens)) {
      for (const item of tokens) {
        if (Array.isArray(item)) {
          flat = [...flat, ...item];
        } else {
          flat.push(item);
        }
      }
    } else {
      flat = [tokens];
    }
    const result = joinLatex(
      flat.map((token) => {
        return {
          "<space>": " ",
          "<$$>": "$$",
          "<$>": "$",
          "<{>": "{",
          "<}>": "}"
        }[token] ?? token;
      })
    );
    return result;
  }

  // src/compute-engine/latex-syntax/types.ts
  var COMPARISON_PRECEDENCE = 245;
  var ASSIGNMENT_PRECEDENCE = 260;
  var ARROW_PRECEDENCE = 270;
  var ADDITION_PRECEDENCE = 275;
  var MULTIPLICATION_PRECEDENCE = 390;
  var DIVISION_PRECEDENCE = 600;
  var INVISIBLE_OP_PRECEDENCE = 650;
  var EXPONENTIATION_PRECEDENCE = 700;
  var POSTFIX_PRECEDENCE = 810;
  function isExpressionEntry(entry) {
    return !("kind" in entry) || entry.kind === "expression";
  }
  function isSymbolEntry(entry) {
    return "kind" in entry && entry.kind === "symbol";
  }
  function isMatchfixEntry(entry) {
    return "kind" in entry && entry.kind === "matchfix";
  }
  function isInfixEntry(entry) {
    return "kind" in entry && entry.kind === "infix";
  }
  function isPrefixEntry(entry) {
    return "kind" in entry && entry.kind === "prefix";
  }
  function isPostfixEntry(entry) {
    return "kind" in entry && entry.kind === "postfix";
  }
  function isEnvironmentEntry(entry) {
    return "kind" in entry && entry.kind === "environment";
  }

  // src/compute-engine/latex-syntax/dictionary/definitions-relational-operators.ts
  var DEFINITIONS_INEQUALITIES = [
    {
      latexTrigger: ["\\not", "<"],
      kind: "infix",
      associativity: "any",
      precedence: 246,
      parse: "NotLess"
    },
    {
      name: "NotLess",
      latexTrigger: ["\\nless"],
      kind: "infix",
      associativity: "any",
      precedence: 246
    },
    {
      latexTrigger: ["<"],
      kind: "infix",
      associativity: "any",
      precedence: 245,
      parse: "Less"
    },
    {
      name: "Less",
      latexTrigger: ["\\lt"],
      kind: "infix",
      associativity: "any",
      precedence: 245
    },
    {
      latexTrigger: ["<", "="],
      kind: "infix",
      associativity: "any",
      precedence: 241,
      parse: "LessEqual"
    },
    {
      name: "LessEqual",
      latexTrigger: ["\\le"],
      kind: "infix",
      associativity: "any",
      precedence: 241
    },
    {
      latexTrigger: ["\\leq"],
      kind: "infix",
      associativity: "any",
      precedence: 241,
      parse: "LessEqual"
    },
    {
      latexTrigger: ["\\leqslant"],
      kind: "infix",
      associativity: "any",
      precedence: COMPARISON_PRECEDENCE + 5,
      // Note different precedence than `<=` as per MathML
      parse: "LessEqual"
    },
    {
      name: "LessNotEqual",
      latexTrigger: ["\\lneqq"],
      kind: "infix",
      associativity: "any",
      precedence: COMPARISON_PRECEDENCE
    },
    {
      name: "NotLessNotEqual",
      latexTrigger: ["\\nleqq"],
      kind: "infix",
      associativity: "any",
      precedence: COMPARISON_PRECEDENCE
    },
    {
      name: "LessOverEqual",
      latexTrigger: ["\\leqq"],
      kind: "infix",
      associativity: "any",
      precedence: COMPARISON_PRECEDENCE + 5
    },
    {
      name: "GreaterOverEqual",
      latexTrigger: ["\\geqq"],
      kind: "infix",
      associativity: "any",
      precedence: COMPARISON_PRECEDENCE + 5,
      parse: "GreaterEqual"
    },
    {
      name: "Equal",
      latexTrigger: ["="],
      kind: "infix",
      associativity: "right",
      precedence: COMPARISON_PRECEDENCE
    },
    {
      latexTrigger: ["*", "="],
      kind: "infix",
      associativity: "right",
      precedence: COMPARISON_PRECEDENCE,
      parse: "StarEqual"
    },
    {
      name: "StarEqual",
      latexTrigger: ["\\star", "="],
      kind: "infix",
      associativity: "right",
      precedence: COMPARISON_PRECEDENCE
    },
    {
      name: "PlusEqual",
      latexTrigger: ["+", "="],
      kind: "infix",
      associativity: "right",
      precedence: COMPARISON_PRECEDENCE
    },
    {
      name: "MinusEqual",
      latexTrigger: ["-", "="],
      kind: "infix",
      associativity: "right",
      precedence: COMPARISON_PRECEDENCE
    },
    {
      name: "SlashEqual",
      latexTrigger: ["/", "="],
      kind: "infix",
      associativity: "right",
      precedence: COMPARISON_PRECEDENCE
    },
    {
      name: "EqualEqual",
      latexTrigger: ["=", "="],
      kind: "infix",
      associativity: "right",
      precedence: COMPARISON_PRECEDENCE
    },
    {
      name: "EqualEqualEqual",
      latexTrigger: ["=", "=", "="],
      kind: "infix",
      associativity: "right",
      precedence: COMPARISON_PRECEDENCE + 5
    },
    {
      name: "TildeFullEqual",
      // MathML: approximately equal to
      latexTrigger: ["\\cong"],
      kind: "infix",
      associativity: "right",
      precedence: COMPARISON_PRECEDENCE
    },
    {
      name: "NotTildeFullEqual",
      // MathML: approximately but not actually equal to
      latexTrigger: ["\\ncong"],
      kind: "infix",
      associativity: "right",
      precedence: COMPARISON_PRECEDENCE
    },
    {
      name: "Approx",
      // Note: Mathematica TildeTilde
      latexTrigger: ["\\approx"],
      kind: "infix",
      associativity: "right",
      precedence: 247
    },
    {
      name: "NotApprox",
      // Note: Mathematica TildeTilde
      latexTrigger: ["\\not", "\\approx"],
      kind: "infix",
      associativity: "right",
      precedence: 247
    },
    {
      name: "ApproxEqual",
      // Note: Mathematica TildeEqual, MathML: `asymptotically equal to`
      latexTrigger: ["\\approxeq"],
      kind: "infix",
      associativity: "right",
      precedence: COMPARISON_PRECEDENCE
    },
    {
      name: "NotApproxEqual",
      // Note: Mathematica NotTildeEqual
      latexTrigger: ["\\not", "\\approxeq"],
      kind: "infix",
      // Note: no LaTeX symbol for char U+2249
      associativity: "right",
      precedence: 250
    },
    {
      name: "NotEqual",
      latexTrigger: ["\\ne"],
      kind: "infix",
      associativity: "right",
      precedence: 255
    },
    {
      name: "Unequal",
      latexTrigger: ["!", "="],
      kind: "infix",
      associativity: "right",
      precedence: COMPARISON_PRECEDENCE
      // Note different precedence than \\ne per MathML
    },
    {
      name: "GreaterEqual",
      latexTrigger: ["\\ge"],
      kind: "infix",
      associativity: "right",
      precedence: 242
      // Note: different precedence than `>=` as per MathML
    },
    {
      latexTrigger: ["\\geq"],
      kind: "infix",
      associativity: "right",
      precedence: 242,
      // Note: different precedence than `>=` as per MathML
      parse: "GreaterEqual"
    },
    {
      latexTrigger: [">", "="],
      kind: "infix",
      associativity: "right",
      precedence: 243,
      parse: "GreaterEqual"
    },
    {
      latexTrigger: ["\\geqslant"],
      kind: "infix",
      associativity: "right",
      precedence: COMPARISON_PRECEDENCE + 5,
      // Note: different precedence than `>=` as per MathML
      parse: "GreaterEqual"
    },
    {
      name: "GreaterNotEqual",
      latexTrigger: ["\\gneqq"],
      kind: "infix",
      associativity: "right",
      precedence: COMPARISON_PRECEDENCE
    },
    {
      name: "NotGreaterNotEqual",
      latexTrigger: ["\\ngeqq"],
      kind: "infix",
      associativity: "right",
      precedence: COMPARISON_PRECEDENCE
    },
    {
      latexTrigger: [">"],
      kind: "infix",
      associativity: "right",
      precedence: 245,
      parse: "Greater"
    },
    {
      name: "Greater",
      latexTrigger: ["\\gt"],
      kind: "infix",
      associativity: "right",
      precedence: 245
    },
    {
      name: "NotGreater",
      latexTrigger: ["\\ngtr"],
      kind: "infix",
      associativity: "right",
      precedence: 244
    },
    {
      latexTrigger: ["\\not", ">"],
      kind: "infix",
      associativity: "right",
      precedence: 244,
      parse: "NotGreater"
    },
    {
      name: "RingEqual",
      latexTrigger: ["\\circeq"],
      kind: "infix",
      associativity: "right",
      precedence: COMPARISON_PRECEDENCE
    },
    {
      name: "TriangleEqual",
      // MathML: delta equal to
      latexTrigger: ["\\triangleq"],
      kind: "infix",
      associativity: "right",
      precedence: COMPARISON_PRECEDENCE
    },
    {
      name: "DotEqual",
      // MathML: approaches the limit
      latexTrigger: ["\\doteq"],
      kind: "infix",
      associativity: "right",
      precedence: COMPARISON_PRECEDENCE + 5
    },
    {
      name: "DotEqualDot",
      // MathML: Geometrically equal
      latexTrigger: ["\\doteqdot"],
      kind: "infix",
      associativity: "right",
      precedence: COMPARISON_PRECEDENCE + 5
    },
    {
      name: "FallingDotEqual",
      // MathML: approximately equal to or the image of
      latexTrigger: ["\\fallingdotseq"],
      kind: "infix",
      associativity: "right",
      precedence: COMPARISON_PRECEDENCE + 5
    },
    {
      name: "RisingDotEqual",
      // MathML: image of or approximately equal to
      latexTrigger: ["\\fallingdotseq"],
      kind: "infix",
      associativity: "right",
      precedence: COMPARISON_PRECEDENCE + 5
    },
    {
      name: "QuestionEqual",
      latexTrigger: ["\\questeq"],
      kind: "infix",
      associativity: "right",
      precedence: COMPARISON_PRECEDENCE
    },
    {
      name: "MuchLess",
      latexTrigger: ["\\ll"],
      kind: "infix",
      associativity: "right",
      precedence: COMPARISON_PRECEDENCE
    },
    {
      name: "MuchGreater",
      latexTrigger: ["\\gg"],
      kind: "infix",
      associativity: "right",
      precedence: COMPARISON_PRECEDENCE
    },
    {
      name: "Precedes",
      latexTrigger: ["\\prec"],
      kind: "infix",
      associativity: "right",
      precedence: COMPARISON_PRECEDENCE
    },
    {
      name: "Succeeds",
      latexTrigger: ["\\succ"],
      kind: "infix",
      associativity: "right",
      precedence: COMPARISON_PRECEDENCE
    },
    {
      name: "PrecedesEqual",
      latexTrigger: ["\\preccurlyeq"],
      kind: "infix",
      associativity: "right",
      precedence: COMPARISON_PRECEDENCE
    },
    {
      name: "SucceedsEqual",
      latexTrigger: ["\\curlyeqprec"],
      kind: "infix",
      associativity: "right",
      precedence: COMPARISON_PRECEDENCE
    },
    {
      name: "NotPrecedes",
      latexTrigger: ["\\nprec"],
      kind: "infix",
      associativity: "right",
      precedence: COMPARISON_PRECEDENCE
    },
    {
      name: "NotSucceeds",
      latexTrigger: ["\\nsucc"],
      kind: "infix",
      associativity: "right",
      precedence: COMPARISON_PRECEDENCE
    },
    {
      name: "Between",
      latexTrigger: ["\\between"],
      kind: "infix",
      associativity: "right",
      precedence: COMPARISON_PRECEDENCE + 5
    }
  ];

  // src/compute-engine/numerics/richardson.ts
  function extrapolate(f, x0, options = {}) {
    const {
      contract = 0.125,
      step = 1,
      power = 2,
      atol = 1e-16,
      rtol = atol > 0 ? 0 : Math.sqrt(Number.EPSILON),
      maxeval = 1e6,
      // Number.MAX_SAFE_INTEGER
      breaktol = 2
    } = options;
    if (!isFinite(x0)) {
      return extrapolate((u) => f(1 / u), 1 / x0, {
        rtol,
        atol,
        maxeval,
        contract: Math.abs(contract) > 1 ? 1 / contract : contract,
        step: 1 / step,
        power
      });
    }
    let h = step;
    const invcontract = Math.pow(1 / contract, power);
    let f0 = f(x0 + h);
    const neville = [f0];
    let err = Infinity;
    let numeval = 1;
    while (numeval < maxeval) {
      numeval += 1;
      h *= contract;
      neville.push(f(x0 + h));
      let c = invcontract;
      let minerr = Infinity;
      for (let i = neville.length - 2; i >= 0; i--) {
        const old = neville[i];
        neville[i] = neville[i + 1] + (neville[i + 1] - neville[i]) / (c - 1);
        const err_ = Math.abs(neville[i] - old);
        minerr = Math.min(minerr, err_);
        if (err_ < err) {
          f0 = neville[i];
          err = err_;
        }
        c *= invcontract;
      }
      if (minerr > breaktol * err || !isFinite(minerr)) break;
      if (err <= Math.max(rtol * Math.abs(f0), atol)) break;
    }
    return [f0, err];
  }

  // src/compute-engine/numerics/bigint.ts
  function bigint(a) {
    if (typeof a === "bigint") return a;
    if (typeof a === "number") {
      if (!Number.isInteger(a)) return null;
      if (a >= Number.MAX_SAFE_INTEGER && a <= Number.MAX_SAFE_INTEGER)
        return BigInt(a);
      return bigint(a.toString());
    }
    if (a instanceof Decimal) {
      if (!a.isInteger()) return null;
      return bigint(a.toString());
    }
    let s = a.toLowerCase();
    const m = s.match(/([+-]?[0-9]*)(?:\.([0-9]+))?e([+-]?[0-9]+)$/);
    if (m) {
      const exp2 = parseInt(m[3]);
      const pad = exp2 - (m[2] ? m[2].length : 0);
      if (pad < 0) return null;
      s = (m[1] ?? "") + (m[2] ?? "") + "0".repeat(pad);
    }
    const i = s.indexOf(".");
    if (i >= 0) return null;
    if (!/^[+-]?[0-9]+$/.test(s)) return null;
    try {
      return BigInt(s);
    } catch (e) {
      console.error(e.message);
      return null;
    }
  }

  // src/compute-engine/numerics/primes.ts
  var LARGE_PRIME = 1125899906842597;
  var SMALL_PRIMES = /* @__PURE__ */ new Set([
    2,
    3,
    5,
    7,
    11,
    13,
    17,
    19,
    23,
    29,
    31,
    37,
    41,
    43,
    47,
    53,
    59,
    61,
    67,
    71,
    73,
    79,
    83,
    89,
    97,
    101,
    103,
    107,
    109,
    113,
    127,
    131,
    137,
    139,
    149,
    151,
    157,
    163,
    167,
    173,
    179,
    181,
    191,
    193,
    197,
    199,
    211,
    223,
    227,
    229,
    233,
    239,
    241,
    251,
    257,
    263,
    269,
    271,
    277,
    281,
    283,
    293,
    307,
    311,
    313,
    317,
    331,
    337,
    347,
    349,
    353,
    359,
    367,
    373,
    379,
    383,
    389,
    397,
    401,
    409,
    419,
    421,
    431,
    433,
    439,
    443,
    449,
    457,
    461,
    463,
    467,
    479,
    487,
    491,
    499,
    503,
    509,
    521,
    523,
    541,
    547,
    557,
    563,
    569,
    571,
    577,
    587,
    593,
    599,
    601,
    607,
    613,
    617,
    619,
    631,
    641,
    643,
    647,
    653,
    659,
    661,
    673,
    677,
    683,
    691,
    701,
    709,
    719,
    727,
    733,
    739,
    743,
    751,
    757,
    761,
    769,
    773,
    787,
    797,
    809,
    811,
    821,
    823,
    827,
    829,
    839,
    853,
    857,
    859,
    863,
    877,
    881,
    883,
    887,
    907,
    911,
    919,
    929,
    937,
    941,
    947,
    953,
    967,
    971,
    977,
    983,
    991,
    997,
    1009,
    1013,
    1019,
    1021,
    1031,
    1033,
    1039,
    1049,
    1051,
    1061,
    1063,
    1069,
    1087,
    1091,
    1093,
    1097,
    1103,
    1109,
    1117,
    1123,
    1129,
    1151,
    1153,
    1163,
    1171,
    1181,
    1187,
    1193,
    1201,
    1213,
    1217,
    1223,
    1229,
    1231,
    1237,
    1249,
    1259,
    1277,
    1279,
    1283,
    1289,
    1291,
    1297,
    1301,
    1303,
    1307,
    1319,
    1321,
    1327,
    1361,
    1367,
    1373,
    1381,
    1399,
    1409,
    1423,
    1427,
    1429,
    1433,
    1439,
    1447,
    1451,
    1453,
    1459,
    1471,
    1481,
    1483,
    1487,
    1489,
    1493,
    1499,
    1511,
    1523,
    1531,
    1543,
    1549,
    1553,
    1559,
    1567,
    1571,
    1579,
    1583,
    1597,
    1601,
    1607,
    1609,
    1613,
    1619,
    1621,
    1627,
    1637,
    1657,
    1663,
    1667,
    1669,
    1693,
    1697,
    1699,
    1709,
    1721,
    1723,
    1733,
    1741,
    1747,
    1753,
    1759,
    1777,
    1783,
    1787,
    1789,
    1801,
    1811,
    1823,
    1831,
    1847,
    1861,
    1867,
    1871,
    1873,
    1877,
    1879,
    1889,
    1901,
    1907,
    1913,
    1931,
    1933,
    1949,
    1951,
    1973,
    1979,
    1987,
    1993,
    1997,
    1999,
    2003,
    2011,
    2017,
    2027,
    2029,
    2039,
    2053,
    2063,
    2069,
    2081,
    2083,
    2087,
    2089,
    2099,
    2111,
    2113,
    2129,
    2131,
    2137,
    2141,
    2143,
    2153,
    2161,
    2179,
    2203,
    2207,
    2213,
    2221,
    2237,
    2239,
    2243,
    2251,
    2267,
    2269,
    2273,
    2281,
    2287,
    2293,
    2297,
    2309,
    2311,
    2333,
    2339,
    2341,
    2347,
    2351,
    2357,
    2371,
    2377,
    2381,
    2383,
    2389,
    2393,
    2399,
    2411,
    2417,
    2423,
    2437,
    2441,
    2447,
    2459,
    2467,
    2473,
    2477,
    2503,
    2521,
    2531,
    2539,
    2543,
    2549,
    2551,
    2557,
    2579,
    2591,
    2593,
    2609,
    2617,
    2621,
    2633,
    2647,
    2657,
    2659,
    2663,
    2671,
    2677,
    2683,
    2687,
    2689,
    2693,
    2699,
    2707,
    2711,
    2713,
    2719,
    2729,
    2731,
    2741,
    2749,
    2753,
    2767,
    2777,
    2789,
    2791,
    2797,
    2801,
    2803,
    2819,
    2833,
    2837,
    2843,
    2851,
    2857,
    2861,
    2879,
    2887,
    2897,
    2903,
    2909,
    2917,
    2927,
    2939,
    2953,
    2957,
    2963,
    2969,
    2971,
    2999,
    3001,
    3011,
    3019,
    3023,
    3037,
    3041,
    3049,
    3061,
    3067,
    3079,
    3083,
    3089,
    3109,
    3119,
    3121,
    3137,
    3163,
    3167,
    3169,
    3181,
    3187,
    3191,
    3203,
    3209,
    3217,
    3221,
    3229,
    3251,
    3253,
    3257,
    3259,
    3271,
    3299,
    3301,
    3307,
    3313,
    3319,
    3323,
    3329,
    3331,
    3343,
    3347,
    3359,
    3361,
    3371,
    3373,
    3389,
    3391,
    3407,
    3413,
    3433,
    3449,
    3457,
    3461,
    3463,
    3467,
    3469,
    3491,
    3499,
    3511,
    3517,
    3527,
    3529,
    3533,
    3539,
    3541,
    3547,
    3557,
    3559,
    3571,
    3581,
    3583,
    3593,
    3607,
    3613,
    3617,
    3623,
    3631,
    3637,
    3643,
    3659,
    3671,
    3673,
    3677,
    3691,
    3697,
    3701,
    3709,
    3719,
    3727,
    3733,
    3739,
    3761,
    3767,
    3769,
    3779,
    3793,
    3797,
    3803,
    3821,
    3823,
    3833,
    3847,
    3851,
    3853,
    3863,
    3877,
    3881,
    3889,
    3907,
    3911,
    3917,
    3919,
    3923,
    3929,
    3931,
    3943,
    3947,
    3967,
    3989,
    4001,
    4003,
    4007,
    4013,
    4019,
    4021,
    4027,
    4049,
    4051,
    4057,
    4073,
    4079,
    4091,
    4093,
    4099,
    4111,
    4127,
    4129,
    4133,
    4139,
    4153,
    4157,
    4159,
    4177,
    4201,
    4211,
    4217,
    4219,
    4229,
    4231,
    4241,
    4243,
    4253,
    4259,
    4261,
    4271,
    4273,
    4283,
    4289,
    4297,
    4327,
    4337,
    4339,
    4349,
    4357,
    4363,
    4373,
    4391,
    4397,
    4409,
    4421,
    4423,
    4441,
    4447,
    4451,
    4457,
    4463,
    4481,
    4483,
    4493,
    4507,
    4513,
    4517,
    4519,
    4523,
    4547,
    4549,
    4561,
    4567,
    4583,
    4591,
    4597,
    4603,
    4621,
    4637,
    4639,
    4643,
    4649,
    4651,
    4657,
    4663,
    4673,
    4679,
    4691,
    4703,
    4721,
    4723,
    4729,
    4733,
    4751,
    4759,
    4783,
    4787,
    4789,
    4793,
    4799,
    4801,
    4813,
    4817,
    4831,
    4861,
    4871,
    4877,
    4889,
    4903,
    4909,
    4919,
    4931,
    4933,
    4937,
    4943,
    4951,
    4957,
    4967,
    4969,
    4973,
    4987,
    4993,
    4999,
    5003,
    5009,
    5011,
    5021,
    5023,
    5039,
    5051,
    5059,
    5077,
    5081,
    5087,
    5099,
    5101,
    5107,
    5113,
    5119,
    5147,
    5153,
    5167,
    5171,
    5179,
    5189,
    5197,
    5209,
    5227,
    5231,
    5233,
    5237,
    5261,
    5273,
    5279,
    5281,
    5297,
    5303,
    5309,
    5323,
    5333,
    5347,
    5351,
    5381,
    5387,
    5393,
    5399,
    5407,
    5413,
    5417,
    5419,
    5431,
    5437,
    5441,
    5443,
    5449,
    5471,
    5477,
    5479,
    5483,
    5501,
    5503,
    5507,
    5519,
    5521,
    5527,
    5531,
    5557,
    5563,
    5569,
    5573,
    5581,
    5591,
    5623,
    5639,
    5641,
    5647,
    5651,
    5653,
    5657,
    5659,
    5669,
    5683,
    5689,
    5693,
    5701,
    5711,
    5717,
    5737,
    5741,
    5743,
    5749,
    5779,
    5783,
    5791,
    5801,
    5807,
    5813,
    5821,
    5827,
    5839,
    5843,
    5849,
    5851,
    5857,
    5861,
    5867,
    5869,
    5879,
    5881,
    5897,
    5903,
    5923,
    5927,
    5939,
    5953,
    5981,
    5987,
    6007,
    6011,
    6029,
    6037,
    6043,
    6047,
    6053,
    6067,
    6073,
    6079,
    6089,
    6091,
    6101,
    6113,
    6121,
    6131,
    6133,
    6143,
    6151,
    6163,
    6173,
    6197,
    6199,
    6203,
    6211,
    6217,
    6221,
    6229,
    6247,
    6257,
    6263,
    6269,
    6271,
    6277,
    6287,
    6299,
    6301,
    6311,
    6317,
    6323,
    6329,
    6337,
    6343,
    6353,
    6359,
    6361,
    6367,
    6373,
    6379,
    6389,
    6397,
    6421,
    6427,
    6449,
    6451,
    6469,
    6473,
    6481,
    6491,
    6521,
    6529,
    6547,
    6551,
    6553,
    6563,
    6569,
    6571,
    6577,
    6581,
    6599,
    6607,
    6619,
    6637,
    6653,
    6659,
    6661,
    6673,
    6679,
    6689,
    6691,
    6701,
    6703,
    6709,
    6719,
    6733,
    6737,
    6761,
    6763,
    6779,
    6781,
    6791,
    6793,
    6803,
    6823,
    6827,
    6829,
    6833,
    6841,
    6857,
    6863,
    6869,
    6871,
    6883,
    6899,
    6907,
    6911,
    6917,
    6947,
    6949,
    6959,
    6961,
    6967,
    6971,
    6977,
    6983,
    6991,
    6997,
    7001,
    7013,
    7019,
    7027,
    7039,
    7043,
    7057,
    7069,
    7079,
    7103,
    7109,
    7121,
    7127,
    7129,
    7151,
    7159,
    7177,
    7187,
    7193,
    7207,
    7211,
    7213,
    7219,
    7229,
    7237,
    7243,
    7247,
    7253,
    7283,
    7297,
    7307,
    7309,
    7321,
    7331,
    7333,
    7349,
    7351,
    7369,
    7393,
    7411,
    7417,
    7433,
    7451,
    7457,
    7459,
    7477,
    7481,
    7487,
    7489,
    7499,
    7507,
    7517,
    7523,
    7529,
    7537,
    7541,
    7547,
    7549,
    7559,
    7561,
    7573,
    7577,
    7583,
    7589,
    7591,
    7603,
    7607,
    7621,
    7639,
    7643,
    7649,
    7669,
    7673,
    7681,
    7687,
    7691,
    7699,
    7703,
    7717,
    7723,
    7727,
    7741,
    7753,
    7757,
    7759,
    7789,
    7793,
    7817,
    7823,
    7829,
    7841,
    7853,
    7867,
    7873,
    7877,
    7879,
    7883,
    7901,
    7907,
    7919
  ]);
  var LARGEST_SMALL_PRIME = 7919;
  function primeFactors(n) {
    console.assert(
      Number.isInteger(n) && n >= 0 && n < Number.MAX_SAFE_INTEGER,
      n
    );
    if (n <= 3) return { [n]: 1 };
    const result = {};
    let count = 0;
    while (n % 2 === 0) {
      count += 1;
      n /= 2;
    }
    if (count > 0) result[2] = count;
    count = 0;
    while (n % 3 === 0) {
      count += 1;
      n /= 3;
    }
    if (count > 0) result[3] = count;
    let done = false;
    while (!done) {
      if (n === 1) return result;
      const sr = Math.sqrt(n);
      done = true;
      for (let i = 6; i <= sr + 6; i += 6) {
        if (n % (i - 1) === 0) {
          result[i - 1] = (result[i - 1] ?? 0) + 1;
          n /= i - 1;
          done = false;
          break;
        }
        if (n % (i + 1) === 0) {
          result[i + 1] = (result[i + 1] ?? 0) + 1;
          n /= i + 1;
          done = false;
          break;
        }
      }
    }
    if (result[n] !== void 0) result[n] += 1;
    else result[n] = 1;
    return result;
  }
  function isPrime(n) {
    if (!Number.isInteger(n) || !Number.isFinite(n) || Number.isNaN(n) || n <= 1) {
      return false;
    }
    if (n <= LARGEST_SMALL_PRIME) return SMALL_PRIMES.has(n);
    for (const smallPrime of SMALL_PRIMES) {
      if (n % smallPrime === 0) return false;
    }
    if (n < LARGE_PRIME) n === leastFactor(n);
    return probablyPrime(n, 30) ? void 0 : false;
  }
  function leastFactor(n) {
    if (n === 1) return 1;
    if (n % 2 === 0) return 2;
    if (n % 3 === 0) return 3;
    if (n % 5 === 0) return 5;
    const m = Math.floor(Math.sqrt(n));
    let i = 7;
    while (i <= m) {
      if (n % i === 0) return i;
      if (n % (i + 4) === 0) return i + 4;
      if (n % (i + 6) === 0) return i + 6;
      if (n % (i + 10) === 0) return i + 10;
      if (n % (i + 12) === 0) return i + 12;
      if (n % (i + 16) === 0) return i + 16;
      if (n % (i + 22) === 0) return i + 22;
      if (n % (i + 24) === 0) return i + 24;
      i += 30;
    }
    return n;
  }
  function isPrimeBigint(n) {
    if (n <= 1) return false;
    if (n <= LARGEST_SMALL_PRIME) return isPrime(Number(n));
    for (const smallPrime of SMALL_PRIMES) {
      if (n % BigInt(smallPrime) === BigInt(0)) return false;
    }
    if (n < LARGE_PRIME) n = leastBigFactor(n);
    return probablyPrimeBigint(n, 30) ? void 0 : false;
  }
  function leastBigFactor(n) {
    if (n === BigInt(1)) return BigInt(1);
    if (n % BigInt(2) === BigInt(0)) return BigInt(2);
    if (n % BigInt(3) === BigInt(0)) return BigInt(3);
    if (n % BigInt(5) === BigInt(0)) return BigInt(5);
    const m = BigInt(Math.floor(Math.sqrt(Number(n))));
    let i = BigInt(7);
    while (i <= m) {
      if (n % i === BigInt(0)) return i;
      if (n % (i + BigInt(4)) === BigInt(0)) return i + BigInt(4);
      if (n % (i + BigInt(6)) === BigInt(0)) return i + BigInt(6);
      if (n % (i + BigInt(10)) === BigInt(0)) return i + BigInt(10);
      if (n % (i + BigInt(12)) === BigInt(0)) return i + BigInt(12);
      if (n % (i + BigInt(16)) === BigInt(0)) return i + BigInt(16);
      if (n % (i + BigInt(22)) === BigInt(0)) return i + BigInt(22);
      if (n % (i + BigInt(24)) === BigInt(0)) return i + BigInt(24);
      i += BigInt(30);
    }
    return n;
  }
  function probablyPrime(n, k) {
    let s = 0;
    let d = n - 1;
    while (d % 2 === 0) {
      d /= 2;
      ++s;
    }
    WitnessLoop: do {
      let x = Math.pow(2 + Math.floor(Math.random() * (n - 3)), d) % n;
      if (x === 1 || x === n - 1) continue;
      for (let i = s - 1; i--; ) {
        x = x * x % n;
        if (x === 1) return false;
        if (x === n - 1) continue WitnessLoop;
      }
      return false;
    } while (--k);
    return true;
  }
  function probablyPrimeBigint(n, k) {
    let s = 0;
    let d = n - BigInt(1);
    while (d % BigInt(2) === BigInt(0)) {
      d = d / BigInt(2);
      ++s;
    }
    WitnessLoop: do {
      let x = BigInt(2 + Math.floor(Math.random() * (Number(n) - 3))) ** d % n;
      if (x === BigInt(1) || x === n - BigInt(1)) continue;
      for (let i = s - 1; i--; ) {
        x = x * x % n;
        if (x === BigInt(1)) return false;
        if (x === n - BigInt(1)) continue WitnessLoop;
      }
      return false;
    } while (--k);
    return true;
  }
  var PRIME_WHEEL_INC = [
    BigInt(4),
    BigInt(2),
    BigInt(4),
    BigInt(2),
    BigInt(4),
    BigInt(6),
    BigInt(2),
    BigInt(6)
  ];

  // src/compute-engine/numerics/numeric.ts
  var DEFAULT_PRECISION = 21;
  var MACHINE_PRECISION_BITS = 53;
  var MACHINE_PRECISION = Math.floor(
    Math.log10(Math.pow(2, MACHINE_PRECISION_BITS))
  );
  var DEFAULT_TOLERANCE = 1e-10;
  var SMALL_INTEGER = 1e6;
  var MAX_BIGINT_DIGITS = 1024;
  var MAX_ITERATION = 1e6;
  function canonicalInteger(n, exponent) {
    if (n >= Number.MAX_SAFE_INTEGER) return [1, n];
    if (n === 0) return [0, 0];
    if (n === 1) return [1, 1];
    console.assert(Number.isInteger(n) && n > 0 && n < Number.MAX_SAFE_INTEGER);
    if (exponent === 2) {
      const result = [
        [0, 0],
        [1, 1],
        [1, 2],
        [1, 3],
        [2, 1],
        [1, 5],
        [1, 6],
        [1, 7],
        [1, 8],
        [3, 1],
        [1, 10],
        [1, 11],
        [2, 3],
        [1, 13],
        [1, 14],
        [1, 15],
        [4, 1],
        [1, 17],
        [3, 2],
        [1, 19],
        [1, 20]
      ][n];
      if (result) return result;
    }
    const factors = primeFactors(n);
    let f = 1;
    let r = 1;
    for (const k of Object.keys(factors)) {
      const v = parseInt(k);
      f = f * Math.pow(v, Math.floor(factors[k] / exponent));
      r = r * Math.pow(v, factors[k] % exponent);
    }
    return [f, r];
  }
  function gcd(a, b) {
    if (a === 0) return b;
    if (b === 0) return a;
    if (a === b) return a;
    if (!Number.isInteger(a) || !Number.isInteger(b)) return NaN;
    while (b !== 0) [a, b] = [b, a % b];
    return a < 0 ? -a : a;
  }
  function lcm(a, b) {
    return a * b / gcd(a, b);
  }
  function factorial(n) {
    if (!Number.isInteger(n) || n < 0) return NaN;
    if (n >= 170) return Infinity;
    let val = 1;
    for (let i = 2; i <= n; i++) val = val * i;
    return val;
  }
  function factorial2(n) {
    if (!Number.isInteger(n) || n < 0) return NaN;
    if (n < 0) return NaN;
    if (n <= 1) return 1;
    let result = n;
    while (n > 2) {
      n -= 2;
      result *= n;
    }
    return result;
  }
  function chop(n, tolerance = DEFAULT_TOLERANCE) {
    if (typeof n === "number" && Math.abs(n) <= tolerance) return 0;
    return n;
  }
  function centeredDiff8thOrder(f, x, h = 0.1) {
    return (f(x - 4 * h) / 280 - 4 * f(x - 3 * h) / 105 + f(x - 2 * h) / 5 - 4 * f(x - h) / 5 + 4 * f(x + h) / 5 - f(x + 2 * h) / 5 + 4 * f(x + 3 * h) / 105 - f(x + 4 * h) / 280) / h;
  }
  function limit(f, x, dir = 1) {
    if (dir === 0) {
      const left = limit(f, x, -1);
      const right = limit(f, x, 1);
      if (left === void 0 || right === void 0) return NaN;
      if (Math.abs(left - right) > 1e-5) return NaN;
      return (left + right) / 2;
    }
    const [val, _err] = extrapolate(f, x, { step: dir > 0 ? 1 : -1 });
    return val;
  }

  // src/compute-engine/boxed-expression/utils.ts
  function isBoxedExpression(x) {
    return typeof x === "object" && x !== null && "engine" in x;
  }
  function bignumPreferred(ce) {
    return ce.precision > MACHINE_PRECISION;
  }
  function isLatexString(s) {
    if (typeof s === "string") return s.startsWith("$") && s.endsWith("$");
    return false;
  }
  function asLatexString(s) {
    if (typeof s === "number") return s.toString();
    if (typeof s === "string") {
      const str = s.trim();
      if (str.startsWith("$$") && str.endsWith("$$")) return str.slice(2, -2);
      if (str.startsWith("$") && str.endsWith("$")) return str.slice(1, -1);
    }
    if (Array.isArray(s)) {
      return asLatexString(joinLatex(s));
    }
    return null;
  }
  function hashCode(s) {
    let hash = 0;
    for (let i = 0; i < s.length; i++)
      hash = Math.imul(31, hash) + s.charCodeAt(i) | 0;
    return Math.abs(hash);
  }
  function normalizedUnknownsForSolve(syms) {
    if (syms === null || syms === void 0) return [];
    if (typeof syms === "string") return [syms];
    if (isBoxedExpression(syms)) return normalizedUnknownsForSolve(syms.symbol);
    if (typeof syms[Symbol.iterator] === "function")
      return Array.from(syms).map(
        (s) => typeof s === "string" ? s : s.symbol
      );
    return [];
  }
  function isRelationalOperator(name) {
    if (typeof name !== "string") return false;
    return DEFINITIONS_INEQUALITIES.some((x) => x.name === name);
  }
  function isInequalityOperator(operator2) {
    return ["Less", "LessEqual", "Greater", "GreaterEqual"].includes(operator2);
  }
  function isEquationOperator(operator2) {
    return ["Equal", "NotEqual"].includes(operator2);
  }
  function isInequality(expr) {
    const h = expr.operator;
    if (typeof h !== "string") return false;
    return isInequalityOperator(h);
  }
  function isEquation(expr) {
    const h = expr.operator;
    if (typeof h !== "string") return false;
    return isEquationOperator(h);
  }
  function getImaginaryFactor(expr) {
    if (typeof expr === "number") return void 0;
    const ce = expr.engine;
    if (expr.symbol === "ImaginaryUnit") return ce.One;
    if (expr.re === 0) return ce.number(expr.im);
    if (expr.operator === "Negate") return getImaginaryFactor(expr.op1)?.neg();
    if (expr.operator === "Complex") {
      if (expr.op1.is(0) && !isNaN(expr.op2.re)) return ce.number(expr.op2.re);
      return void 0;
    }
    if (expr.operator === "Multiply" && expr.nops === 2) {
      const [op1, op2] = expr.ops;
      if (op1.symbol === "ImaginaryUnit") return op2;
      if (op2.symbol === "ImaginaryUnit") return op1;
      if (op2.isNumberLiteral && op2.re === 0 && op2.im !== 0)
        return op1.mul(op2.im);
      if (op1.isNumberLiteral && op1.re === 0 && op1.im !== 0)
        return op2.mul(op1.im);
    }
    if (expr.operator === "Divide") {
      const denom = expr.op2;
      if (denom.is(0)) return void 0;
      return getImaginaryFactor(expr.op1)?.div(denom);
    }
    return void 0;
  }
  function normalizeFlags(flags) {
    if (!flags) return void 0;
    const result = { ...flags };
    if (result.odd) result.even = false;
    if (result.even) result.odd = false;
    return result;
  }
  function isSymbolDefinition(def) {
    if (def === void 0 || def === null || typeof def !== "object")
      return false;
    if (isBoxedExpression(def)) return false;
    if ("value" in def || "constant" in def || "inferred" in def || "type" in def) {
      if ("type" in def && typeof def.type !== "string") {
        throw new Error(
          "The `type` field of a symbol definition should be of type `string`"
        );
      }
      if ("signature" in def) {
        throw new Error(
          "Symbol definition cannot have a `signature` field. Use a `type` field instead."
        );
      }
      if ("sgn" in def) {
        throw new Error(
          "Symbol definition cannot have a `sgn` field. Use a `flags.sgn` field instead."
        );
      }
      return true;
    }
    return false;
  }
  function isFunctionDefinition(def) {
    if (def === void 0 || def === null || typeof def !== "object")
      return false;
    if (isBoxedExpression(def)) return false;
    if ("signature" in def || "complexity" in def) {
      if ("constant" in def) {
        throw new Error(
          "Function definition cannot have a `constant` field and symbol definition cannot have a `signature` field."
        );
      }
    }
    if (!("evaluate" in def) && !("signature" in def) && !("sgn" in def) && !("complexity" in def) && !("canonical" in def))
      return false;
    if ("type" in def && typeof def.type !== "function") {
      throw new Error(
        "The `type` field of a function definition should be a function"
      );
    }
    if ("sgn" in def && typeof def.sgn !== "function") {
      throw new Error(
        "The `sgn` field of a function definition should be a function"
      );
    }
    return true;
  }
  function semiCanonical(ce, xs) {
    if (!xs.every((x) => isBoxedExpression(x))) return xs.map((x) => ce.box(x));
    return xs.every((x) => x.isCanonical) ? xs : xs.map(
      (x) => x.canonical
    );
  }
  function canonical(ce, xs) {
    return xs.every((x) => isBoxedExpression(x) && x.isCanonical) ? xs : xs.map((x) => ce.box(x));
  }
  function domainToType(expr) {
    if (expr.symbol === "Numbers") return "number";
    if (expr.symbol === "ComplexNumbers") return "complex";
    if (expr.symbol === "ImaginaryNumbers") return "imaginary";
    if (expr.symbol === "RealNumbers") return "real";
    if (expr.symbol === "RationalNumbers") return "rational";
    if (expr.symbol === "Integers") return "integer";
    return "unknown";
  }
  function angleToRadians(x) {
    if (!x) return x;
    const ce = x.engine;
    const angularUnit = ce.angularUnit;
    if (angularUnit === "rad") return x;
    if (angularUnit === "deg") x = x.mul(ce.Pi).div(180);
    if (angularUnit === "grad") x = x.mul(ce.Pi).div(200);
    if (angularUnit === "turn") x = x.mul(ce.Pi).mul(2);
    return x;
  }
  function canonicalAngle(x) {
    if (!x) return x;
    const theta = angleToRadians(x);
    if (!theta) return void 0;
    if (theta.N().im !== 0) return theta;
    const ce = theta.engine;
    const [k, t] = getPiTerm(theta);
    if (k.isZero) return ce.number(t);
    const k2 = ce._numericValue(k.bignumRe ? k.bignumRe.mod(2) : k.re % 2);
    return ce.number(t.add(ce.Pi.mul(k2).N().numericValue));
  }
  function getPiTerm(expr) {
    const ce = expr.engine;
    if (expr.symbol === "Pi") return [ce._numericValue(1), ce._numericValue(0)];
    if (expr.operator === "Negate") {
      const [k, t] = getPiTerm(expr.ops[0]);
      return [k.neg(), t.neg()];
    }
    if (expr.operator === "Add" && expr.nops === 2) {
      const [k1, t1] = getPiTerm(expr.op1);
      const [k2, t2] = getPiTerm(expr.op2);
      return [k1.add(k2), t1.add(t2)];
    }
    if (expr.operator === "Multiply" && expr.nops === 2) {
      if (expr.op1.isNumberLiteral) {
        const [k, t] = getPiTerm(expr.op2);
        const n = expr.op1.numericValue;
        return [k.mul(n), t.mul(n)];
      }
      if (expr.op2.isNumberLiteral) {
        const [k, t] = getPiTerm(expr.op1);
        const n = expr.op2.numericValue;
        return [k.mul(n), t.mul(n)];
      }
    }
    if (expr.operator === "Divide") {
      if (expr.op2.isNumberLiteral) {
        const [k1, t1] = getPiTerm(expr.op1);
        const d = expr.op2.numericValue;
        return [k1.div(d), t1.div(d)];
      }
    }
    return [ce._numericValue(0), ce._numericValue(expr.N().numericValue ?? 0)];
  }

  // src/common/interruptible.ts
  var CancellationError = class extends Error {
    constructor({
      message,
      value,
      cause
    } = {}) {
      super(message ?? "Operation canceled");
      if (value) this.value = value;
      this.cause = cause;
      this.name = "CancellationError";
    }
  };
  async function runAsync(gen, timeLimitMs, signal) {
    const startTime = performance.now();
    while (true) {
      const chunkStart = performance.now();
      const chunkDurationMs = 16;
      while (performance.now() - chunkStart < chunkDurationMs) {
        const { done, value } = gen.next();
        if (done) return value;
        if (signal?.aborted)
          throw new CancellationError({ value, cause: signal.reason });
        if (performance.now() - startTime >= timeLimitMs)
          throw new CancellationError({
            value,
            cause: "timeout",
            message: `Timeout exceeded (${timeLimitMs}ms)`
          });
      }
      await new Promise((resolve2) => setTimeout(resolve2, 0));
    }
  }
  function run(gen, timeLimitMs) {
    const startTime = Date.now();
    while (true) {
      const { done, value } = gen.next();
      if (done) return value;
      const elapsedTime = Date.now() - startTime;
      if (elapsedTime >= timeLimitMs) {
        throw new CancellationError({
          value,
          cause: "timeout",
          message: `Timeout exceeded (${timeLimitMs}ms)`
        });
      }
    }
  }

  // src/compute-engine/collection-utils.ts
  var MAX_SIZE_EAGER_COLLECTION = 100;
  function isFiniteCollection(col) {
    const l = length(col);
    if (l === void 0) return false;
    return Number.isFinite(l);
  }
  function isIndexableCollection(col) {
    col = resolve(col);
    if (col.string !== null) return true;
    return col.functionDefinition?.collection?.at !== void 0;
  }
  function isFiniteIndexableCollection(col) {
    col = resolve(col);
    if (col.string !== null) return true;
    const def = col.functionDefinition;
    if (!def) return false;
    return def.collection?.at !== void 0 && Number.isFinite(def.collection?.size?.(col) ?? Infinity);
  }
  function* each(col) {
    const iter = iterator(col);
    if (!iter) {
      yield col;
      return;
    }
    const limit2 = col.engine.iterationLimit;
    let i = 0;
    while (true) {
      const { done, value } = iter.next();
      if (done) return;
      if (i++ > limit2)
        throw new CancellationError({ cause: "iteration-limit-exceeded" });
      yield value;
    }
  }
  function length(col) {
    col = resolve(col);
    const s = col.string;
    if (s !== null) return s.length;
    return col.functionDefinition?.collection?.size?.(col);
  }
  function iterator(expr) {
    expr = resolve(expr);
    const def = expr.functionDefinition;
    if (def?.collection?.iterator) return def.collection.iterator(expr);
    const s = expr.string;
    if (s !== null) {
      if (s.length === 0)
        return { next: () => ({ done: true, value: void 0 }) };
      let i = 0;
      return {
        next: () => ({
          value: expr.engine.string(s.charAt(i++)),
          done: i > s.length
        })
      };
    }
    return void 0;
  }
  function repeat(value, count) {
    if (typeof count === "number") {
      if (count < 0) count = 0;
      return {
        next() {
          if (count === 0) return { done: true, value: void 0 };
          count--;
          return { done: false, value };
        }
      };
    }
    return {
      next() {
        return { done: false, value };
      }
    };
  }
  function defaultCollectionHandlers(def) {
    if (!def) return void 0;
    const result = {};
    if (!def.contains || !def.size)
      throw new Error(
        'A collection must have at least a "contains" and "size" handler'
      );
    if (def.contains) result.contains = def.contains;
    if (def.size) result.size = def.size;
    if (def.at) result.at = def.at;
    if (def.iterator) result.iterator = def.iterator;
    if (def.keys) result.keys = def.keys;
    if (def.indexOf) result.indexOf = def.indexOf;
    if (def.subsetOf) result.subsetOf = def.subsetOf;
    let iterator2 = result.iterator;
    if (result.at && !iterator2) {
      iterator2 = (expr, start = 1, count = -1) => {
        const at2 = def.at;
        let i = start;
        return {
          next() {
            if (count >= 0 && i >= start + count)
              return { done: true, value: void 0 };
            const result2 = at2(expr, i);
            if (result2 === void 0) return { done: true, value: void 0 };
            i++;
            return { done: false, value: result2 };
          }
        };
      };
      result.iterator = iterator2;
    }
    if (!result.indexOf) {
      result.indexOf = (expr, target) => {
        let i = 1;
        const iter = iterator2(expr);
        let result2 = iter.next();
        while (!result2.done) {
          if (target.isSame(result2.value)) return i;
          i++;
          result2 = iter.next();
        }
        return void 0;
      };
    }
    return {
      contains: def.contains,
      size: def.size,
      at: def.at,
      iterator: iterator2,
      keys: def.keys,
      indexOf: def.indexOf,
      subsetOf: def.subsetOf
    };
  }
  function resolve(expr) {
    if (expr.symbolDefinition) {
      if (expr.symbolDefinition.holdUntil === "never")
        return expr.symbolDefinition.value ?? expr;
    }
    return expr;
  }
  function zip(items) {
    items = items.map((x) => resolve(x));
    const iterators = items.map((x) => iterator(x) ?? repeat(x));
    return {
      next() {
        const values = iterators.map((x) => x.next());
        if (values.some((x) => x.done)) return { done: true, value: void 0 };
        return { done: false, value: values.map((x) => x.value) };
      }
    };
  }

  // src/compute-engine/boxed-expression/flatten.ts
  function flatten(ops, operator2) {
    const xs = ops.every((x) => x.isCanonical) ? ops : ops.map((x) => x.canonical);
    if (operator2) {
      const shouldFlatten = (x) => x.symbol === "Nothing" || x.operator === operator2 || x.operator === "Sequence";
      if (xs.every((x) => !shouldFlatten(x))) return xs;
      const ys2 = [];
      for (const x of xs) {
        if (x.symbol === "Nothing") continue;
        if (x.ops && (x.operator === operator2 || x.operator === "Sequence"))
          ys2.push(...flatten(x.ops, operator2));
        else ys2.push(x);
      }
      return ys2;
    }
    if (xs.every((x) => !(x.symbol === "Nothing" || x.operator === "Sequence")))
      return xs;
    const ys = [];
    for (const x of xs) {
      if (x.symbol === "Nothing") continue;
      if (x.ops && x.operator === "Sequence")
        ys.push(...flatten(x.ops, operator2));
      else ys.push(x);
    }
    return ys;
  }
  function flattenOps(ops, operator2) {
    if (!operator2) return ops;
    if (ops.every((x) => !x.ops || x.operator !== operator2)) return ops;
    const result = [];
    for (const arg of ops) {
      if (!arg.ops || arg.operator !== operator2) result.push(arg);
      else {
        result.push(...flattenOps(arg.ops, operator2));
      }
    }
    console.assert(result.length !== ops.length);
    if (result.length === ops.length) return ops;
    return result;
  }
  function flattenSequence(xs) {
    if (xs.every((x) => x.operator !== "Sequence" && x.operator !== "Delimiter"))
      return xs;
    const ys = [];
    for (const x of xs) {
      if (!x.isValid) ys.push(x);
      else if (x.operator === "Delimiter") {
        if (x.op1.operator === "Sequence") {
          const seq = x.op1.ops ?? [];
          if (seq.length === 0) ys.push(x.engine.box(["Tuple"]));
          else ys.push(...flattenSequence(seq));
        } else ys.push(x.op1);
      } else if (x.operator === "Sequence") {
        if (x.ops) ys.push(...x.ops);
      } else ys.push(x);
    }
    return ys;
  }

  // src/compute-engine/boxed-expression/validate.ts
  function checkArity(ce, ops, count) {
    ops = flatten(ops);
    if (!ce.strict) return ops;
    if (ops.length === count) return ops;
    const xs = [...ops.slice(0, count)];
    let i = Math.min(count, ops.length);
    while (i < count) {
      xs.push(ce.error("missing"));
      i += 1;
    }
    while (i < ops.length) {
      xs.push(ce.error("unexpected-argument", ops[i].toString()));
      i += 1;
    }
    return xs;
  }
  function checkNumericArgs(ce, ops, options) {
    let count = typeof options === "number" ? options : options?.count;
    const flattenHead = typeof options === "number" ? void 0 : options?.flatten;
    ops = flatten(ops, flattenHead);
    if (!ce.strict) {
      let inferredType = "real";
      for (const x of ops)
        if (isSubtype("complex", x.type.type)) {
          inferredType = "number";
          break;
        }
      for (const x of ops)
        if (!isFiniteIndexableCollection(x)) x.infer(inferredType);
      return ops;
    }
    let isValid = true;
    count ?? (count = ops.length);
    const xs = [];
    for (let i = 0; i <= Math.max(count - 1, ops.length - 1); i++) {
      const op = ops[i];
      if (i > count - 1) {
        isValid = false;
        xs.push(ce.error("unexpected-argument", op.toString()));
      } else if (op === void 0) {
        isValid = false;
        xs.push(ce.error("missing"));
      } else if (!op.isValid) {
        isValid = false;
        xs.push(op);
      } else if (op.isNumber) {
        xs.push(op);
      } else if (op.symbol && !ce.lookupSymbol(op.symbol) && !ce.lookupFunction(op.symbol)) {
        xs.push(op);
      } else if (op.type.isUnknown) {
        xs.push(op);
      } else if (isFiniteIndexableCollection(op)) {
        for (const x of each(op)) {
          if (!x.isNumber) {
            isValid = false;
            break;
          }
        }
        if (!isValid) xs.push(ce.typeError("number", op.type, op));
        else xs.push(op);
      } else if (op.symbolDefinition?.inferredType && isSubtype("number", op.type.type)) {
        xs.push(op);
      } else if (op.functionDefinition?.inferredSignature && isSubtype("number", op.type.type)) {
        xs.push(op);
      } else if (op.operator === "Hold" || op.symbolDefinition?.value?.operator === "Hold") {
        xs.push(op);
      } else {
        isValid = false;
        xs.push(ce.typeError("number", op.type, op));
      }
    }
    if (isValid) {
      let inferredType = "real";
      for (const x of xs)
        if (isSubtype("complex", x.type.type)) {
          inferredType = "number";
          break;
        }
      for (const x of xs)
        if (isFiniteIndexableCollection(x))
          for (const y of each(x)) y.infer(inferredType);
        else x.infer(inferredType);
    }
    return xs;
  }
  function checkType(ce, arg, type2) {
    if (arg === void 0 || arg === null) return ce.error("missing");
    if (type2 === void 0)
      return ce.error("unexpected-argument", arg.toString());
    arg = arg.canonical;
    if (!arg.isValid) return arg;
    if (arg.type.matches(type2)) return arg;
    return ce.typeError(type2, arg.type, arg);
  }
  function checkTypes(ce, args, types) {
    if (args.length === types.length && args.every((x, i) => x.type.matches(types[i])))
      return args;
    const xs = [];
    for (let i = 0; i <= types.length - 1; i++)
      xs.push(checkType(ce, args[i], types[i]));
    for (let i = types.length; i <= args.length - 1; i++)
      xs.push(ce.error("unexpected-argument", args[i].toString()));
    return xs;
  }
  function validateArguments(ce, ops, signature, lazy, threadable) {
    if (!ce.strict) return null;
    if (typeof signature === "string") return null;
    if (signature.kind !== "signature") return null;
    const result = [];
    let isValid = true;
    const params = signature.args?.map((x) => x.type) ?? [];
    const optParams = signature.optArgs?.map((x) => x.type) ?? [];
    const restParam = signature.restArg?.type;
    let i = 0;
    for (const param of params) {
      const op = ops[i++];
      if (!op) {
        result.push(ce.error("missing"));
        isValid = false;
        continue;
      }
      if (lazy) {
        result.push(op);
        continue;
      }
      if (!op.isValid) {
        result.push(op);
        isValid = false;
        continue;
      }
      if (op.type.isUnknown) {
        result.push(op);
        continue;
      }
      if (threadable && isFiniteIndexableCollection(op)) {
        result.push(op);
        continue;
      }
      if (op.symbolDefinition?.inferredType && op.type.matches(param)) {
        result.push(op);
        continue;
      }
      if (op.functionDefinition?.inferredSignature && op.type.matches(param)) {
        result.push(op);
        continue;
      }
      if (!op.type.matches(param)) {
        result.push(ce.typeError(param, op.type, op));
        isValid = false;
        continue;
      }
      result.push(op);
    }
    for (const param of optParams) {
      const op = ops[i];
      if (!op) {
        break;
      }
      if (lazy) {
        result.push(op);
        i += 1;
        continue;
      }
      if (!op.isValid) {
        result.push(op);
        isValid = false;
        i += 1;
        continue;
      }
      if (op.type.isUnknown) {
        result.push(op);
        i += 1;
        continue;
      }
      if (threadable && isFiniteIndexableCollection(op)) {
        result.push(op);
        i += 1;
        continue;
      }
      if (op.symbolDefinition?.inferredType && op.type.matches(param)) {
        result.push(op);
        i += 1;
        continue;
      }
      if (!op.type.matches(param)) {
        result.push(ce.typeError(param, op.type, op));
        isValid = false;
        i += 1;
        continue;
      }
      result.push(op);
      i += 1;
    }
    if (restParam) {
      for (const op of ops.slice(i)) {
        i += 1;
        if (lazy) {
          result.push(op);
          continue;
        }
        if (!op.isValid) {
          result.push(op);
          isValid = false;
          continue;
        }
        if (op.type.isUnknown) {
          result.push(op);
          continue;
        }
        if (threadable && isFiniteIndexableCollection(op)) {
          result.push(op);
          continue;
        }
        if (op.symbolDefinition?.inferredType && op.type.matches(restParam)) {
          result.push(op);
          continue;
        }
        if (!op.type.matches(restParam)) {
          result.push(ce.typeError(restParam, op.type, op));
          isValid = false;
          continue;
        }
        result.push(op);
      }
    }
    if (i < ops.length) {
      for (const op of ops.slice(i)) {
        result.push(ce.error("unexpected-argument", op.toString()));
        isValid = false;
      }
    }
    if (!isValid) return result;
    i = 0;
    for (const param of params) {
      if (!lazy) {
        if (!threadable || !isFiniteIndexableCollection(ops[i]))
          ops[i].infer(param);
      }
      i += 1;
    }
    for (const param of optParams) {
      if (!ops[i]) break;
      if (!threadable || !isFiniteIndexableCollection(ops[i]))
        ops[i]?.infer(param);
      i += 1;
    }
    if (restParam) {
      for (const op of ops.slice(i)) {
        if (!lazy) {
          if (!threadable || !isFiniteIndexableCollection(op))
            op.infer(restParam);
        }
        i += 1;
      }
    }
    return null;
  }

  // src/compute-engine/numerics/numeric-bigint.ts
  function gcd2(a, b) {
    while (b !== BigInt(0)) [a, b] = [b, a % b];
    return a < 0 ? -a : a;
  }
  function lcm2(a, b) {
    return a * b / gcd2(a, b);
  }
  function* factorial3(n) {
    if (n < 0) return BigInt(0);
    if (n < 10)
      return BigInt([1, 1, 2, 6, 24, 120, 720, 5040, 40320, 362880][Number(n)]);
    if (n % BigInt(2) === BigInt(1)) return n * (yield* factorial3(n - BigInt(1)));
    let loop = n;
    let sum2 = n;
    let val = n;
    let counter = 0;
    while (loop > 2) {
      loop -= BigInt(2);
      sum2 += loop;
      val *= sum2;
      counter += 1;
      if (counter % 5e4 === 0 || counter > 1e4 && counter % 500 === 0)
        yield val;
    }
    return val;
  }

  // src/compute-engine/numerics/rationals.ts
  function isRational(x) {
    return x !== null && Array.isArray(x);
  }
  function isMachineRational(x) {
    return x !== null && Array.isArray(x) && typeof x[0] === "number";
  }
  function isBigRational(x) {
    return x !== null && Array.isArray(x) && typeof x[0] === "bigint";
  }
  function isZero(x) {
    return x[0] == 0;
  }
  function isPositive(x) {
    return x[0] > 0;
  }
  function isOne(x) {
    return x[0] == x[1];
  }
  function isNegativeOne(x) {
    return x[0] === -x[1];
  }
  function isInteger(x) {
    return x[1] == 1;
  }
  function machineNumerator(x) {
    return Number(x[0]);
  }
  function machineDenominator(x) {
    return Number(x[1]);
  }
  function rationalAsFloat(x) {
    return Number(x[0]) / Number(x[1]);
  }
  function add2(lhs, rhs) {
    if (typeof lhs[0] === "number" && !Number.isFinite(lhs[0])) return lhs;
    const rhsNum = rhs;
    if (rhsNum === null) return lhs;
    if (isBigRational(rhsNum)) {
      lhs = [BigInt(lhs[0]), BigInt(lhs[1])];
      return [rhsNum[1] * lhs[0] + rhsNum[0] * lhs[1], rhsNum[1] * lhs[1]];
    }
    if (!Number.isFinite(rhsNum[0])) return rhsNum;
    if (isBigRational(lhs)) {
      const bigRhs = [BigInt(rhsNum[0]), BigInt(rhsNum[1])];
      return [bigRhs[1] * lhs[0] + bigRhs[0] * lhs[1], bigRhs[1] * lhs[1]];
    }
    return [rhsNum[1] * lhs[0] + rhsNum[0] * lhs[1], rhsNum[1] * lhs[1]];
  }
  function mul2(lhs, rhs) {
    if (isMachineRational(lhs) && isMachineRational(rhs))
      return [lhs[0] * rhs[0], lhs[1] * rhs[1]];
    if (isMachineRational(lhs))
      return [
        BigInt(lhs[0]) * rhs[0],
        BigInt(lhs[1]) * rhs[1]
      ];
    if (isMachineRational(rhs))
      return [
        BigInt(rhs[0]) * lhs[0],
        BigInt(rhs[1]) * lhs[1]
      ];
    return [lhs[0] * rhs[0], lhs[1] * rhs[1]];
  }
  function neg(x) {
    return [-x[0], x[1]];
  }
  function inverse(x) {
    return x[0] < 0 ? [-x[1], -x[0]] : [x[1], x[0]];
  }
  function asMachineRational(r) {
    return [Number(r[0]), Number(r[1])];
  }
  function rationalGcd(lhs, rhs) {
    if (isMachineRational(lhs) && isMachineRational(rhs)) {
      if (lhs[1] === 1 && rhs[1] === 1) return [gcd(lhs[0], rhs[0]), 1];
      return [gcd(lhs[0], rhs[0]), lcm(lhs[1], rhs[1])];
    }
    if (lhs[1] === 1 && rhs[1] === 1)
      return [gcd2(BigInt(lhs[0]), BigInt(rhs[0])), BigInt(1)];
    return [
      gcd2(BigInt(lhs[0]), BigInt(rhs[0])),
      lcm2(BigInt(lhs[1]), BigInt(rhs[1]))
    ];
  }
  function reducedRational(r) {
    if (isMachineRational(r)) {
      if (r[0] === 1 || r[1] === 1) return r;
      if (r[1] < 0) r = [-r[0], -r[1]];
      if (!Number.isFinite(r[1])) return [0, 1];
      const g2 = gcd(r[0], r[1]);
      return g2 <= 1 ? r : [r[0] / g2, r[1] / g2];
    }
    if (r[1] < 0) r = [-r[0], -r[1]];
    const g = gcd2(r[0], r[1]);
    const [n, d] = g <= 1 ? r : [r[0] / g, r[1] / g];
    if (n <= Number.MAX_SAFE_INTEGER && n >= Number.MIN_SAFE_INTEGER && d <= Number.MAX_SAFE_INTEGER)
      return [Number(n), Number(d)];
    return [n, d];
  }
  function rationalize(x) {
    if (!Number.isFinite(x)) return x;
    const fractional = x % 1;
    if (fractional === 0) return x;
    const eps = 1e-15;
    let a = Math.floor(x);
    let h1 = 1;
    let k1 = 0;
    let h = a;
    let k = 1;
    while (x - a > eps * k * k) {
      x = 1 / (x - a);
      a = Math.floor(x);
      const h2 = h1;
      h1 = h;
      const k2 = k1;
      k1 = k;
      h = h2 + a * h1;
      k = k2 + a * k1;
    }
    return [h, k];
  }

  // src/compute-engine/numeric-value/types.ts
  var NumericValue = class {
    /**  bignum version of .re, if available */
    get bignumRe() {
      return void 0;
    }
    get bignumIm() {
      return void 0;
    }
    isZeroWithTolerance(_tolerance) {
      return this.isZero;
    }
    //
    // JavaScript Object methods
    //
    /** Object.valueOf(): returns a primitive value */
    valueOf() {
      if (this.im === 0) {
        return this.bignumRe ? this.bignumRe.toFixed() : this.re;
      }
      return this.N().toString();
    }
    /** Object.toPrimitive() */
    [Symbol.toPrimitive](hint) {
      return hint === "string" ? this.toString() : this.valueOf();
    }
    /** Object.toJSON */
    toJSON() {
      if (this.im === 0) {
        const r = this.re;
        if (Number.isFinite(r)) return r;
      }
      return this.N().toString();
    }
    print() {
      const log3 = console["log"];
      log3?.(this.toString());
    }
  };

  // src/common/json5.ts
  var JSON5 = class {
    static parse(input) {
      const parser = new JSON5Parser(input);
      const value = parser.parseValue();
      parser.skipWhitespace();
      if (!parser.isAtEnd()) {
        throw parser.error(
          `Unexpected token '${parser.currentChar()}' after parsing complete value`
        );
      }
      return value;
    }
  };
  var JSON5Parser = class {
    constructor(input) {
      this.index = 0;
      this.text = input;
    }
    parseValue() {
      this.skipWhitespace();
      if (this.isAtEnd()) {
        throw this.error("Unexpected end of input");
      }
      const ch = this.currentChar();
      if (ch === "{") return this.parseObject();
      if (ch === "[") return this.parseArray();
      if (ch === '"' || ch === "'") return this.parseString();
      if (ch === "-" || ch === "+" || ch >= "0" && ch <= "9" || ch === ".")
        return this.parseNumber();
      return this.parseIdentifier();
    }
    parseObject() {
      const obj = {};
      this.expectChar("{");
      this.skipWhitespace();
      if (this.currentChar() === "}") {
        this.index++;
        return obj;
      }
      while (true) {
        this.skipWhitespace();
        let key;
        const ch = this.currentChar();
        if (ch === '"' || ch === "'") {
          key = this.parseString();
        } else {
          key = this.parseIdentifier();
        }
        this.skipWhitespace();
        this.expectChar(":");
        this.skipWhitespace();
        const value = this.parseValue();
        obj[key] = value;
        this.skipWhitespace();
        if (this.currentChar() === ",") {
          this.index++;
          this.skipWhitespace();
          if (this.currentChar() === "}") {
            this.index++;
            break;
          }
        } else if (this.currentChar() === "}") {
          this.index++;
          break;
        } else {
          throw this.error(
            `Expected ',' or '}' in object but found '${this.currentChar()}'`
          );
        }
      }
      return obj;
    }
    parseArray() {
      const arr = [];
      this.expectChar("[");
      this.skipWhitespace();
      if (this.currentChar() === "]") {
        this.index++;
        return arr;
      }
      while (true) {
        this.skipWhitespace();
        arr.push(this.parseValue());
        this.skipWhitespace();
        if (this.currentChar() === ",") {
          this.index++;
          this.skipWhitespace();
          if (this.currentChar() === "]") {
            this.index++;
            break;
          }
        } else if (this.currentChar() === "]") {
          this.index++;
          break;
        } else {
          throw this.error(
            `Expected ',' or ']' in array but found '${this.currentChar()}'`
          );
        }
      }
      return arr;
    }
    parseString() {
      const quote = this.currentChar();
      if (quote !== '"' && quote !== "'") {
        throw this.error(`String should start with a quote, got '${quote}'`);
      }
      this.index++;
      let result = "";
      while (!this.isAtEnd()) {
        const ch = this.currentChar();
        if (ch === quote) {
          this.index++;
          return result;
        }
        if (ch === "\\") {
          this.index++;
          if (this.isAtEnd()) {
            throw this.error("Unterminated escape sequence in string");
          }
          const esc = this.currentChar();
          switch (esc) {
            case "b":
              result += "\b";
              break;
            case "f":
              result += "\f";
              break;
            case "n":
              result += "\n";
              break;
            case "r":
              result += "\r";
              break;
            case "t":
              result += "	";
              break;
            case "v":
              result += "\v";
              break;
            case "\\":
              result += "\\";
              break;
            case "'":
              result += "'";
              break;
            case '"':
              result += '"';
              break;
            case "0":
              result += "\0";
              break;
            case "u": {
              this.index++;
              const hex = this.text.substr(this.index, 4);
              if (!/^[0-9a-fA-F]{4}$/.test(hex)) {
                throw this.error(`Invalid Unicode escape sequence: \\u${hex}`);
              }
              result += String.fromCharCode(parseInt(hex, 16));
              this.index += 3;
              break;
            }
            default:
              result += esc;
          }
          this.index++;
        } else {
          result += ch;
          this.index++;
        }
      }
      throw this.error("Unterminated string literal");
    }
    parseNumber() {
      const start = this.index;
      if (this.text.startsWith("-Infinity", this.index)) {
        this.index += "-Infinity".length;
        return -Infinity;
      }
      if (this.text.startsWith("+Infinity", this.index)) {
        this.index += "+Infinity".length;
        return Infinity;
      }
      if (this.text.startsWith("Infinity", this.index)) {
        this.index += "Infinity".length;
        return Infinity;
      }
      while (!this.isAtEnd() && /[0-9+\-_.eE]/.test(this.currentChar())) {
        this.index++;
      }
      const token = this.text.slice(start, this.index);
      const normalized = token.replace(/_/g, "");
      const num = Number(normalized);
      if (isNaN(num)) {
        throw this.error(`Invalid number: ${token}`);
      }
      return num;
    }
    parseIdentifier() {
      const start = this.index;
      const firstChar = this.currentChar();
      if (!/[a-zA-Z$_]/.test(firstChar)) {
        throw this.error(`Unexpected token '${firstChar}'`);
      }
      this.index++;
      while (!this.isAtEnd()) {
        const ch = this.currentChar();
        if (!/[a-zA-Z0-9$_]/.test(ch)) break;
        this.index++;
      }
      const token = this.text.slice(start, this.index);
      if (token === "true") return true;
      if (token === "false") return false;
      if (token === "null") return null;
      if (token === "Infinity") return Infinity;
      if (token === "NaN") return NaN;
      return token;
    }
    skipWhitespace() {
      while (!this.isAtEnd()) {
        const ch = this.currentChar();
        if (/\s/.test(ch)) {
          this.index++;
          continue;
        }
        if (ch === "/") {
          const next = this.peekChar(1);
          if (next === "/") {
            this.index += 2;
            while (!this.isAtEnd() && this.currentChar() !== "\n") {
              this.index++;
            }
            continue;
          } else if (next === "*") {
            this.index += 2;
            while (!this.isAtEnd() && !(this.currentChar() === "*" && this.peekChar(1) === "/")) {
              this.index++;
            }
            if (this.isAtEnd()) {
              throw this.error("Unterminated multi-line comment");
            }
            this.index += 2;
            continue;
          }
        }
        break;
      }
    }
    expectChar(expected) {
      if (this.currentChar() !== expected) {
        throw this.error(
          `Expected '${expected}' but found '${this.currentChar()}'`
        );
      }
      this.index++;
    }
    currentChar() {
      return this.text[this.index];
    }
    peekChar(offset) {
      return this.text[this.index + offset];
    }
    isAtEnd() {
      return this.index >= this.text.length;
    }
    error(message) {
      return new Error(`${message} at position ${this.index}`);
    }
  };

  // src/math-json/utils.ts
  var MISSING = ["Error", "'missing'"];
  function isNumberExpression(expr) {
    if (typeof expr === "number" || isNumberObject(expr)) return true;
    if (typeof expr === "string" && /^[+-]?[0-9\.]/.test(expr)) return true;
    return false;
  }
  function isNumberObject(expr) {
    return expr !== null && typeof expr === "object" && "num" in expr;
  }
  function isSymbolObject(expr) {
    return expr !== null && typeof expr === "object" && "sym" in expr;
  }
  function isStringObject(expr) {
    return expr !== null && typeof expr === "object" && "str" in expr;
  }
  function isFunctionObject(expr) {
    return expr !== null && typeof expr === "object" && "fn" in expr;
  }
  function stringValue(expr) {
    if (expr === null || expr === void 0) return null;
    if (typeof expr === "object" && "str" in expr) return expr.str;
    if (typeof expr !== "string") return null;
    if (expr.length < 2) return null;
    if (expr.at(0) !== "'" || expr.at(-1) !== "'") return null;
    return expr.substring(1, expr.length - 1);
  }
  function stripText(expr) {
    if (expr === null || expr === void 0 || stringValue(expr) !== null)
      return null;
    const h = operator(expr);
    if (!h) return expr;
    return [
      h,
      ...operands(expr).map((x) => stripText(x)).filter((x) => x !== null)
    ];
  }
  function operator(expr) {
    if (Array.isArray(expr)) return expr[0];
    if (expr === null || expr === void 0) return "";
    if (isFunctionObject(expr)) return expr.fn[0];
    return "";
  }
  function operands(expr) {
    if (Array.isArray(expr)) return expr.slice(1);
    if (expr !== void 0 && isFunctionObject(expr)) return expr.fn.slice(1);
    return [];
  }
  function operand(expr, n) {
    if (Array.isArray(expr)) return expr[n] ?? null;
    if (expr === null || !isFunctionObject(expr)) return null;
    return expr.fn[n] ?? null;
  }
  function nops(expr) {
    if (expr === null || expr === void 0) return 0;
    if (Array.isArray(expr)) return Math.max(0, expr.length - 1);
    if (isFunctionObject(expr)) return Math.max(0, expr.fn.length - 1);
    return 0;
  }
  function unhold(expr) {
    if (expr === null || expr === void 0) return null;
    if (operator(expr) === "Hold") return operand(expr, 1);
    return expr;
  }
  function symbol(expr) {
    if (typeof expr === "string") {
      if (/^[+-]?[0-9\.]/.test(expr)) return null;
      if (expr.length >= 2 && expr[0] === "'" && expr[expr.length - 1] === "'")
        return null;
      return expr;
    }
    if (expr === null || expr === void 0) return null;
    const s = isSymbolObject(expr) ? expr.sym : expr;
    if (typeof s !== "string") return null;
    return s;
  }
  function keyValuePair(expr) {
    const h = operator(expr);
    if (h === "KeyValuePair" || h === "Tuple" || h === "Pair") {
      const [k, v] = operands(expr);
      const key = stringValue(k);
      if (!key) return null;
      return [key, v ?? "Nothing"];
    }
    return null;
  }
  function dictionaryFromExpression(expr) {
    if (expr === null) return null;
    if (typeof expr === "object" && !("sym" in expr) && !("num" in expr) && !("str" in expr) && !("fn" in expr)) {
      return expr;
    }
    if (typeof expr === "string" && expr[0] === "{" && expr[expr.length - 1] === "}") {
      try {
        return JSON5.parse(expr);
      } catch {
        return null;
      }
    }
    const kv = keyValuePair(expr);
    if (kv) return { [kv[0]]: kv[1] };
    if (operator(expr) === "Dictionary") {
      const result = {};
      const ops = operands(expr);
      for (let i = 1; i < nops(expr); i++) {
        const kv2 = keyValuePair(ops[i]);
        if (kv2) result[kv2[0]] = kv2[1];
      }
      return result;
    }
    return null;
  }
  function dictionaryFromEntries(dict) {
    const keys = Object.keys(dict);
    if (keys.length === 0) return ["Dictionary"];
    if (keys.length === 1) return ["Pair", { str: keys[0] }, dict[keys[0]]];
    const entries = [];
    for (const key of keys) entries.push(["Pair", { str: key }, dict[key]]);
    return ["Dictionary", ...entries];
  }
  function machineValueOfString(s) {
    s = s.toLowerCase().replace(/[nd]$/, "").replace(/[\u0009-\u000d\u0020\u00a0]/g, "");
    if (s === "nan") return NaN;
    if (s === "infinity" || s === "+infinity") return Infinity;
    if (s === "-infinity") return -Infinity;
    if (/\([0-9]+\)/.test(s)) {
      const [_, body, repeat2, trail] = s.match(/(.+)\(([0-9]+)\)(.*)$/) ?? [];
      s = body + repeat2.repeat(Math.ceil(16 / repeat2.length)) + (trail ?? "");
    }
    return parseFloat(s);
  }
  function machineValue(expr) {
    if (typeof expr === "number") return expr;
    if (typeof expr === "string") return machineValueOfString(expr);
    if (expr !== void 0 && isNumberObject(expr)) return machineValue(expr.num);
    return null;
  }
  function rationalValue(expr) {
    if (expr === void 0 || expr === null) return null;
    if (symbol(expr) === "Half") return [1, 2];
    const h = operator(expr);
    if (!h) return null;
    let numer = null;
    let denom = null;
    if (h === "Negate") {
      const r = rationalValue(operands(expr)[0]);
      if (r) return [-r[0], r[1]];
    }
    if (h === "Rational" || h === "Divide") {
      const [n, d] = operands(expr);
      numer = machineValue(n) ?? NaN;
      denom = machineValue(d) ?? NaN;
    }
    if (h === "Power") {
      const [base, exp2] = operands(expr);
      const exponent = machineValue(exp2);
      if (exponent === 1) {
        numer = machineValue(base);
        denom = 1;
      } else if (exponent === -1) {
        numer = 1;
        denom = machineValue(base);
      }
    }
    if (h === "Multiply") {
      const [op1, op2] = operands(expr);
      if (operator(op2) === "Power") {
        const [op21, op22] = operands(op2);
        if (machineValue(op22) === -1) {
          numer = machineValue(op1);
          denom = machineValue(op21);
        }
      }
    }
    if (numer === null || denom === null) return null;
    if (Number.isInteger(numer) && Number.isInteger(denom)) return [numer, denom];
    return null;
  }
  function subs(expr, s) {
    const sym = symbol(expr);
    if (sym && s[sym]) return s[sym];
    const h = operator(expr);
    if (h)
      return [
        subs(h, s),
        ...operands(expr).map((x) => subs(x, s))
      ];
    return expr;
  }
  function mapArgs(expr, fn) {
    let args = null;
    if (Array.isArray(expr)) args = expr;
    if (isFunctionObject(expr)) args = expr.fn;
    if (args === null) return [];
    let i = 1;
    const result = [];
    while (i < args.length) {
      result.push(fn(args[i]));
      i += 1;
    }
    return result;
  }
  function foldAssociativeOperator(op, lhs, rhs) {
    const lhsName = operator(lhs);
    const rhsName = operator(rhs);
    if (lhsName === op && rhsName === op)
      return [op, ...operands(lhs), ...operands(rhs)];
    if (lhsName === op) return [op, ...operands(lhs), rhs];
    if (rhsName === op) return [op, lhs, ...operands(rhs)];
    return [op, lhs, rhs];
  }
  function getSequence(expr) {
    if (expr === null || expr === void 0) return null;
    let h = operator(expr);
    if (h === "Delimiter") {
      expr = operand(expr, 1);
      if (expr === null) return [];
      h = operator(expr);
      if (h !== "Sequence") return [expr];
    }
    if (h !== "Sequence") return null;
    return operands(expr);
  }
  function isEmptySequence(expr) {
    if (expr === null || expr === void 0) return true;
    if (expr === "Nothing") return true;
    return operator(expr) === "Sequence" && nops(expr) === 0;
  }
  function missingIfEmpty(expr) {
    return isEmptySequence(expr) ? MISSING : expr;
  }
  function countFunctionLeaves(xs) {
    if (xs[0] === "Square") {
      return countFunctionLeaves(xs.slice(1)) + 2;
    }
    return xs.reduce((acc, x) => acc + countLeaves(x), 0);
  }
  function countLeaves(expr) {
    if (expr === null) return 0;
    if (typeof expr === "number" || typeof expr === "string") return 1;
    if (isNumberExpression(expr) || isSymbolObject(expr) || isStringObject(expr))
      return 1;
    if (Array.isArray(expr)) return countFunctionLeaves(expr);
    if ("fn" in expr) return countFunctionLeaves(expr.fn);
    const dict = dictionaryFromExpression(expr);
    if (dict) {
      const keys = Object.keys(dict);
      return 1 + keys.length + keys.reduce((acc, x) => acc + countLeaves(dict[x]), 0);
    }
    return 0;
  }

  // src/compute-engine/numerics/strings.ts
  function fromRoman(roman) {
    if (roman === "N") return [0, ""];
    const romanMap = {
      I: 1,
      V: 5,
      X: 10,
      L: 50,
      C: 100,
      D: 500,
      M: 1e3
    };
    let total = 0;
    let prevValue = 0;
    roman = roman.toUpperCase();
    for (let i = roman.length - 1; i >= 0; i--) {
      const currentValue = romanMap[roman[i]];
      if (currentValue === void 0) return [total, roman.slice(i)];
      if (currentValue < prevValue) total -= currentValue;
      else total += currentValue;
      prevValue = currentValue;
    }
    return [total, ""];
  }
  function fromDigits(s, baseInput) {
    s = s.trim();
    if (s.length === 0) return [NaN, ""];
    if (s.startsWith("+")) return fromDigits(s.slice(1), baseInput);
    if (s.startsWith("-")) {
      const [v, r] = fromDigits(s.slice(1), baseInput);
      return [-v, r];
    }
    let base = 10;
    if (typeof baseInput === "string") baseInput = baseInput.toLowerCase();
    if (s.startsWith("0x")) {
      base = 16;
      s = s.slice(2);
    } else if (s.startsWith("0b")) {
      base = 2;
      s = s.slice(2);
    } else if (baseInput === "roman") {
      return fromRoman(s);
    } else if (baseInput === "base64" || baseInput === "base-64") {
      try {
        return [parseInt(btoa(s)), ""];
      } catch (e) {
        return [NaN, ""];
      }
    } else if (typeof baseInput === "number") {
      base = baseInput;
    } else if (typeof baseInput === "string") {
      base = parseInt(baseInput);
    }
    let value = 0;
    for (let i = 0; i < s.length; i++) {
      const k = {
        " ": -1,
        "\xA0": -1,
        // NBS
        "\u2000": -1,
        // EN QUAD
        "\u2001": -1,
        // EM QUAD
        "\u2002": -1,
        // EN SPACE
        "\u2003": -1,
        // EM SPACE
        "\u2004": -1,
        // THREE-PER-EM SPACE
        "\u2005": -1,
        // FOUR-PER-EM SPACE
        "\u2006": -1,
        // SIX-PER-EM SPACE
        "\u2007": -1,
        // FIGURE SPACE
        "\u2008": -1,
        // PUNCTUATION SPACE
        "\u2009": -1,
        // THIN SPACE
        "\u200A": -1,
        // HAIR SPACE
        "\u200B": -1,
        // ZWS
        "\u202F": -1,
        // NARROW NBS
        "\u205F": -1,
        // MEDIUM MATHEMATICAL SPACE
        "_": -1,
        ",": -1,
        "0": 0,
        "1": 1,
        "2": 2,
        "3": 3,
        "4": 4,
        "5": 5,
        "6": 6,
        "7": 7,
        "8": 8,
        "9": 9,
        "a": 10,
        "b": 11,
        "c": 12,
        "d": 13,
        "e": 14,
        "f": 15,
        "g": 16,
        "h": 17,
        "i": 18,
        "j": 19,
        "k": 20,
        "l": 21,
        "m": 22,
        "n": 23,
        "o": 24,
        "p": 25,
        "q": 26,
        "r": 27,
        "s": 28,
        "t": 29,
        "u": 30,
        "v": 31,
        "w": 32,
        "x": 33,
        "y": 34,
        "z": 35
      }[s[i]];
      if (k !== -1) {
        if (k === void 0) return [value, s.substring(i)];
        if (k >= base) return [value, s.substring(i)];
        value = value * base + k;
      }
    }
    return [value, ""];
  }
  function numberToString(num, fractionalDigits) {
    if (typeof fractionalDigits === "number" && typeof num === "number")
      return num.toFixed(fractionalDigits);
    const numStr = num.toString();
    if (typeof num === "number" && Number.isInteger(num) && numStr.includes("e")) {
      const fixedStr = BigInt(num).toString();
      const trailingZeros = fixedStr.match(/0+$/);
      const trailingZerosCount = trailingZeros ? trailingZeros[0].length : 0;
      if (trailingZerosCount <= 5) return fixedStr;
    } else if (typeof num === "bigint") {
      const trailingZeros = numStr.match(/0+$/);
      const trailingZerosCount = trailingZeros ? trailingZeros[0].length : 0;
      if (trailingZerosCount > 5)
        return `${numStr.slice(0, -trailingZerosCount)}e+${trailingZerosCount}`;
    }
    return numStr;
  }

  // src/compute-engine/numerics/expression.ts
  function bigintValue(expr) {
    if (typeof expr === "number")
      return Number.isInteger(expr) ? BigInt(expr) : null;
    if (expr === null || expr === void 0) return null;
    if (!isNumberExpression(expr)) return null;
    const num = isNumberObject(expr) ? expr.num : expr;
    if (typeof num === "number")
      return Number.isInteger(num) ? BigInt(num) : null;
    if (typeof num !== "string") return null;
    const s = num.toLowerCase().replace(/[nd]$/, "").replace(/[\u0009-\u000d\u0020\u00a0]/g, "");
    if (s === "nan") return null;
    if (s === "infinity" || s === "+infinity") return null;
    if (s === "-infinity") return null;
    return bigint(s);
  }
  function numberToExpression(num, fractionalDigits) {
    if (typeof num === "number") {
      if (isNaN(num)) return "NaN";
      if (!Number.isFinite(num))
        return num < 0 ? "NegativeInfinity" : "PositiveInfinity";
      if (typeof fractionalDigits === "number")
        return { num: num.toFixed(fractionalDigits) };
      return num;
    }
    if (num >= Number.MIN_SAFE_INTEGER && num <= Number.MAX_SAFE_INTEGER)
      return Number(num);
    const numStr = numberToString(num);
    if (Number(num).toString() === numStr) return Number(num);
    return { num: numStr };
  }

  // src/compute-engine/numeric-value/exact-numeric-value.ts
  var ExactNumericValue = class _ExactNumericValue extends NumericValue {
    /** The caller is responsible to make sure the input is valid, i.e.
     * - rational is a fraction of integers (but it may not be reduced)
     * - radical is an integer
     */
    constructor(value, factory, bignum) {
      super();
      // An integer > 0
      // For exact numeric values, the imaginary part is always 0
      this.im = 0;
      this.factory = factory;
      this.bignum = bignum;
      if (typeof value === "number") {
        console.assert(!Number.isFinite(value) || Number.isInteger(value));
        this.rational = [value, 1];
        this.radical = 1;
        return;
      }
      if (typeof value === "bigint") {
        this.rational = [value, BigInt(1)];
        this.radical = 1;
        return;
      }
      console.assert(typeof value !== "object" || !("im" in value));
      const decimal = 1;
      console.assert(typeof decimal !== "number" || Number.isInteger(decimal));
      if (decimal == 0) {
        this.rational = [0, 1];
        this.radical = 1;
        return;
      }
      let rational = value.rational ? [...value.rational] : [1, 1];
      if (decimal != 1) {
        if (typeof decimal === "bigint")
          rational = mul2(rational, [decimal, BigInt(1)]);
        else rational = mul2(rational, [decimal, 1]);
      }
      this.rational = rational;
      this.radical = value.radical ?? 1;
      console.assert(this.radical <= SMALL_INTEGER && this.radical >= 1);
      this.normalize();
    }
    get type() {
      if (this.isNaN) return "number";
      if (this.isPositiveInfinity || this.isNegativeInfinity)
        return "non_finite_number";
      if (this.radical !== 1) {
        console.assert(!isZero(this.rational));
        return "finite_real";
      }
      return isInteger(this.rational) ? "finite_integer" : "finite_rational";
    }
    get isExact() {
      return true;
    }
    get asExact() {
      return this;
    }
    toJSON() {
      if (this.isNaN) return "NaN";
      if (this.isPositiveInfinity) return "PositiveInfinity";
      if (this.isNegativeInfinity) return "NegativeInfinity";
      if (this.isZero) return 0;
      if (this.isOne) return 1;
      if (this.isNegativeOne) return -1;
      const rationalExpr = (r) => {
        if (isInteger(r)) return numberToExpression(r[0]);
        return [
          "Rational",
          numberToExpression(r[0]),
          numberToExpression(r[1])
        ];
      };
      if (this.radical === 1) return rationalExpr(this.rational);
      if (isOne(this.rational)) return ["Sqrt", this.radical];
      if (isNegativeOne(this.rational)) return ["Negate", ["Sqrt", this.radical]];
      if (this.rational[0] == 1)
        return [
          "Divide",
          ["Sqrt", this.radical],
          numberToExpression(this.rational[1])
        ];
      if (this.rational[0] == -1)
        return [
          "Negate",
          [
            "Divide",
            ["Sqrt", this.radical],
            numberToExpression(this.rational[1])
          ]
        ];
      return ["Multiply", rationalExpr(this.rational), ["Sqrt", this.radical]];
    }
    clone(value) {
      return new _ExactNumericValue(value, this.factory, this.bignum);
    }
    /** Object.toString() */
    toString() {
      if (this.isZero) return "0";
      if (this.isOne) return "1";
      if (this.isNegativeOne) return "-1";
      const rationalStr = (r) => {
        if (isInteger(r)) return numberToString(r[0]);
        return `${numberToString(r[0])}/${numberToString(r[1])}`;
      };
      if (this.radical === 1) return rationalStr(this.rational);
      const radicalStr = (r) => `sqrt(${numberToString(r)})`;
      if (isOne(this.rational)) return radicalStr(this.radical);
      if (isNegativeOne(this.rational)) return `-${radicalStr(this.radical)}`;
      if (this.rational[0] == 1)
        return `${radicalStr(this.radical)}/${numberToString(this.rational[1])}`;
      if (this.rational[0] == -1)
        return `-${radicalStr(this.radical)}/${numberToString(this.rational[1])}`;
      return `${rationalStr(this.rational)}${radicalStr(this.radical)}`;
    }
    get sign() {
      if (isZero(this.rational)) return 0;
      if (isPositive(this.rational)) return 1;
      return -1;
    }
    get re() {
      return rationalAsFloat(this.rational) * Math.sqrt(this.radical);
    }
    get bignumRe() {
      let result;
      const r = this.rational;
      if (isMachineRational(r)) result = this.bignum(r[0]).div(r[1]);
      else
        result = this.bignum(r[0].toString()).div(this.bignum(r[1].toString()));
      if (this.radical === 1) return result;
      return result.mul(this.bignum(this.radical).sqrt());
    }
    get numerator() {
      if (this.rational[1] == 1) return this;
      return this.clone({
        rational: isMachineRational(this.rational) ? [this.rational[0], 1] : [this.rational[0], BigInt(1)],
        radical: this.radical
      });
    }
    get denominator() {
      if (isMachineRational(this.rational)) return this.clone(this.rational[1]);
      return this.clone({ rational: [this.rational[1], BigInt(1)] });
    }
    normalize() {
      console.assert(
        Number.isInteger(this.radical) && this.radical > 0 && Number.isFinite(this.radical)
      );
      if (isNaN(this.radical)) {
        this.rational = [NaN, 1];
        this.radical = 1;
        return;
      }
      const [n, d] = this.rational;
      if (d == 0) {
        this.rational = [NaN, 1];
        this.radical = 1;
        return;
      }
      if (this.radical === 0 || n === 0) {
        this.rational = [0, 1];
        this.radical = 1;
        return;
      }
      if (this.radical >= 4) {
        const [factor2, root2] = canonicalInteger(this.radical, 2);
        if (typeof this.rational[0] === "number") this.rational[0] *= factor2;
        else this.rational = mul2(this.rational, [factor2, 1]);
        this.radical = root2;
      }
      this.rational = reducedRational(this.rational);
    }
    get isNaN() {
      return Number.isNaN(this.rational[0]);
    }
    get isPositiveInfinity() {
      return this.rational[0] == Infinity;
    }
    get isNegativeInfinity() {
      return this.rational[0] == -Infinity;
    }
    get isComplexInfinity() {
      return false;
    }
    get isZero() {
      return isZero(this.rational);
    }
    get isOne() {
      if (this.rational[0] !== this.rational[1]) return false;
      if (this.radical !== 1) return false;
      return true;
    }
    get isNegativeOne() {
      if (this.rational[0] !== -this.rational[1]) return false;
      if (this.radical !== 1) return false;
      return true;
    }
    sgn() {
      if (Number.isNaN(this.rational[0])) return void 0;
      if (isZero(this.rational)) return 0;
      return isPositive(this.rational) ? 1 : -1;
    }
    N() {
      if (this.isZero || this.isOne || this.isNegativeOne) return this;
      if (this.rational[1] == 1 && this.radical === 1) return this;
      return this.factory(this.bignumRe);
    }
    neg() {
      if (this.isZero) return this;
      return this.clone({
        rational: neg(this.rational),
        radical: this.radical
      });
    }
    inv() {
      if (this.isOne) return this;
      if (this.isNegativeOne) return this;
      return this.clone({
        rational: isMachineRational(this.rational) ? [this.rational[1], this.rational[0] * this.radical] : [this.rational[1], this.rational[0] * BigInt(this.radical)],
        radical: this.radical
      });
    }
    add(other) {
      if (typeof other === "number") {
        if (other === 0) return this;
        if (Number.isInteger(other) && this.radical === 1)
          return this.clone({
            rational: isMachineRational(this.rational) ? [this.rational[0] + other * this.rational[1], this.rational[1]] : [
              this.rational[0] + BigInt(other) * this.rational[1],
              this.rational[1]
            ]
          });
        return this.factory(this.bignumRe).add(other);
      }
      if (other.isZero) return this;
      if (this.isZero) return other;
      if (!(other instanceof _ExactNumericValue)) return other.add(this);
      if (this.radical === other.radical) {
        return this.clone({
          rational: add2(this.rational, other.rational),
          radical: this.radical
        });
      }
      return this.factory(this.bignumRe).add(other);
    }
    sub(other) {
      return this.add(other.neg());
    }
    mul(other) {
      if (other === 0) return this.clone(0);
      if (other === 1) return this;
      if (other === -1) return this.neg();
      if (typeof other === "number") {
        if (Number.isInteger(other))
          return this.clone({
            rational: isMachineRational(this.rational) ? [this.rational[0] * other, this.rational[1]] : [this.rational[0] * BigInt(other), this.rational[1]],
            radical: this.radical
          });
        return this.factory(this.bignumRe).mul(other);
      }
      if (other instanceof Decimal) return this.factory(other).mul(this);
      if (other.im !== 0) return other.mul(this);
      if (other.isZero) return other;
      if (other.isOne) return this;
      if (other.isNegativeOne) return this.neg();
      if (other.isNaN) return other;
      if (this.isZero) return this;
      if (this.isOne) return other;
      if (this.isNegativeOne) return other.neg();
      if (!(other instanceof _ExactNumericValue)) return other.mul(this);
      return this.clone({
        rational: mul2(this.rational, other.rational),
        radical: this.radical * other.radical
      });
    }
    div(other) {
      if (typeof other === "number") {
        if (other === 1) return this;
        if (other === -1) return this.neg();
        if (other === 0) return this.clone(NaN);
        return this.clone({
          rational: isMachineRational(this.rational) ? [this.rational[0], this.rational[1] * other] : [this.rational[0], this.rational[1] * BigInt(other)],
          radical: this.radical
        });
      }
      if (other.isOne) return this;
      if (other.isNegativeOne) return this.neg();
      if (this.isZero) {
        if (other.isZero) return this.clone(NaN);
        return other.isNaN ? other : this;
      }
      if (other.isNaN) return other;
      if (other.isZero) return this.clone(this.sign * Infinity);
      if (!(other instanceof _ExactNumericValue))
        return this.factory(this.bignumRe).div(other);
      if (other.im !== 0) return this.factory(this.bignumRe).div(other);
      let rational;
      if (isMachineRational(this.rational) && isMachineRational(other.rational)) {
        const [a, b] = this.rational;
        const [d, e] = other.rational;
        rational = [a * e, b * d * other.radical];
      } else {
        rational = mul2(this.rational, [
          BigInt(other.rational[1]),
          BigInt(other.rational[0]) * BigInt(other.radical)
        ]);
      }
      return this.clone({ rational, radical: this.radical * other.radical });
    }
    pow(exponent) {
      console.assert(!Array.isArray(exponent));
      if (this.isNaN) return this;
      if (typeof exponent === "number" && isNaN(exponent)) return this.clone(NaN);
      if (exponent instanceof NumericValue) {
        if (exponent.isNaN) return this.clone(NaN);
        if (exponent.isZero) return this.clone(1);
        if (exponent.isOne) return this;
        if (exponent.im) {
          exponent = { re: exponent.re, im: exponent.im };
        } else {
          if (exponent instanceof _ExactNumericValue) {
            if (exponent.radical === 1 && exponent.rational[0] == 1)
              return this.root(exponent.rational[0]);
          }
          exponent = exponent.re;
        }
      }
      if (exponent === 0.5) return this.sqrt();
      if (typeof exponent === "object" && ("re" in exponent || "im" in exponent))
        return this.factory(this.bignumRe).pow(exponent);
      if (this.isPositiveInfinity) {
        if (exponent === -1) return this.clone(0);
        if (exponent === Infinity) return this.clone(Infinity);
        if (exponent === -Infinity) return this.clone(0);
      } else if (this.isNegativeInfinity && exponent === Infinity)
        return this.clone(NaN);
      if ((exponent === Infinity || exponent === -Infinity) && (this.isOne || this.isNegativeOne))
        return this.clone(NaN);
      if (exponent === 1) return this;
      if (exponent === -1) return this.inv();
      if (exponent === 0) return this.clone(1);
      if (this.isZero) {
        if (exponent > 0) return this;
        if (exponent < 0) return this.factory({ im: Infinity });
      }
      if (exponent < 0) return this.pow(-exponent).inv();
      if (exponent % 1 === 0.5)
        return this.pow(Math.floor(exponent)).mul(this.sqrt());
      if (this.radical > SMALL_INTEGER || this.rational[0] > SMALL_INTEGER || this.rational[0] < -SMALL_INTEGER || this.rational[1] > SMALL_INTEGER)
        return this.factory(this.bignumRe).pow(exponent);
      if (this.sign < 0) {
        if (Number.isInteger(exponent)) {
          const sign2 = exponent % 2 === 0 ? 1 : -1;
          return this.clone({
            rational: isMachineRational(this.rational) ? [
              sign2 * (-this.rational[0]) ** exponent,
              this.rational[1] ** exponent
            ] : [
              BigInt(sign2) * (-this.rational[0]) ** BigInt(exponent),
              this.rational[1] ** BigInt(exponent)
            ],
            radical: this.radical ** exponent
          });
        }
        return this.factory({ im: (-this.re) ** exponent });
      } else {
        if (Number.isInteger(exponent)) {
          return this.clone({
            rational: isMachineRational(this.rational) ? [this.rational[0] ** exponent, this.rational[1] ** exponent] : [
              BigInt(this.rational[0]) ** BigInt(exponent),
              this.rational[1] ** BigInt(exponent)
            ],
            radical: this.radical ** exponent
          });
        }
      }
      return this.factory(this.bignumRe).pow(exponent);
    }
    root(exponent) {
      if (exponent === 0) return this.clone(NaN);
      if (this.isNaN) return this;
      if (this.isZero) return this;
      if (exponent === 1) return this;
      if (exponent === -1) return this.inv();
      if (exponent < 0) return this.root(-exponent).inv();
      if (exponent % 1 === 0.5) return this.root(Math.floor(exponent)).sqrt();
      if (this.radical === 1) {
        if (this.sign > 0) {
          const re = this.re;
          if (Number.isInteger(re)) {
            if (re > 0) {
              const root2 = Math.pow(re, 1 / exponent);
              if (Number.isInteger(root2)) return this.clone(root2);
            }
            return this.factory(this.bignumRe).root(exponent);
          }
        }
        return this.factory(this.bignumRe).root(exponent);
      }
      if (this.sign < 0)
        return this.factory({ im: Math.pow(-this.re, 1 / exponent) });
      if (this.radical > SMALL_INTEGER || this.rational[0] > SMALL_INTEGER || this.rational[0] < -SMALL_INTEGER || this.rational[1] > SMALL_INTEGER)
        return this.factory(this.bignumRe).root(exponent);
      if (this.rational[1] == 1) {
        const root2 = Math.pow(this.rational[0], 1 / exponent);
        if (Number.isInteger(root2)) return this.clone(root2);
      }
      return this.factory(this.bignumRe).root(exponent);
    }
    sqrt() {
      if (this.isZero || this.isOne) return this;
      if (this.radical === 1) {
        if (isMachineRational(this.rational)) {
          const [n, d] = this.rational;
          if (n * d > SMALL_INTEGER) return this.factory(this.bignumRe).sqrt();
          if (n > 0) return this.clone({ radical: n * d, rational: [1, d] });
          return this.factory({ im: Math.sqrt(-n * d) / d });
        } else {
          return this.factory(this.bignumRe).sqrt();
        }
      }
      if (this.sign > 0) {
        const re = Math.sqrt(this.re);
        if (Number.isInteger(re)) return this.clone(re);
      }
      return this.factory(this.bignumRe).sqrt();
    }
    gcd(other) {
      if (!(other instanceof _ExactNumericValue)) return other.gcd(this);
      if (this.isOne || other.im !== 0 || other.isOne) return this.clone(1);
      const rational = rationalGcd(this.rational, other.rational);
      const radical = gcd(this.radical, other.radical);
      return this.clone({ rational, radical });
    }
    abs() {
      return this.sign === -1 ? this.neg() : this;
    }
    ln(base) {
      if (this.isZero) return this.clone(NaN);
      if (this.isPositiveInfinity) return this.clone(Infinity);
      if (this.sign < 0) return this.clone(NaN);
      if (this.isOne) return this.clone(0);
      if (this.isNegativeOne) return this.factory({ im: Math.PI });
      return this.factory(this.bignumRe).ln(base);
    }
    exp() {
      if (this.isNaN) return this.clone(NaN);
      if (this.isZero) return this.clone(1);
      if (this.isNegativeInfinity) return this.clone(0);
      if (this.isPositiveInfinity) return this.clone(Infinity);
      return this.factory(this.bignumRe).exp();
    }
    floor() {
      if (this.isNaN) return this.clone(NaN);
      if (this.type === "integer") return this;
      return this.clone(Math.floor(this.re));
    }
    ceil() {
      if (this.isNaN) return this.clone(NaN);
      if (this.type === "integer") return this;
      return this.clone(Math.ceil(this.re));
    }
    round() {
      if (this.isNaN) return this.clone(NaN);
      if (this.type === "integer") return this;
      return this.clone(Math.round(this.re));
    }
    eq(other) {
      if (typeof other === "number")
        return this.radical === 1 && isInteger(this.rational) && this.rational[0] == other;
      if (other instanceof _ExactNumericValue) {
        return this.radical === other.radical && this.rational[0] == other.rational[0] && this.rational[1] == other.rational[1];
      }
      return other.im === 0 && other.re === this.re;
    }
    lt(other) {
      if (this.im !== 0) ;
      if (typeof other === "number") return this.re < other;
      return this.re < other.re;
    }
    lte(other) {
      if (this.im !== 0) ;
      if (typeof other === "number") return this.re <= other;
      return this.re <= other.re;
    }
    gt(other) {
      if (this.im !== 0) ;
      if (typeof other === "number") return this.re > other;
      return this.re > other.re;
    }
    gte(other) {
      if (this.im !== 0) ;
      if (typeof other === "number") return this.re >= other;
      return this.re >= other.re;
    }
    // When using add(), inexact values propagate, i.e. '1.2 + 1/4' -> '1.45'
    // This may not be desirable when adding many values, i.e. '1.2 - 1.2 + 1/4' -> '1/4'
    // Furthermore we may want to keep track of rational and square rational parts
    // i.e. '1.2 + 1/4 + √5 + √7' -> '3/4 + √5 + √7'
    // '1.2 + 1/4 + √5 + √5' -> '3/4 + 2√5'
    static sum(values, factory, bignumFactory) {
      if (values.length === 1) return values;
      if (values.some((x) => !x.isExact)) {
        if (values.length === 2) return [values[0].add(values[1])];
        let sum2 = factory(0);
        for (const value of values) sum2 = sum2.add(value);
        return [sum2];
      }
      let imSum = 0;
      let rationalSum = [0, 1];
      const radicals = [];
      for (const value of values) {
        if (value.isNaN)
          return [new _ExactNumericValue(NaN, factory, bignumFactory)];
        if (value.isZero) continue;
        imSum += value.im;
        if (value instanceof _ExactNumericValue) {
          const rational = value.rational;
          if (value.radical === 1) {
            rationalSum = add2(rationalSum, rational);
          } else {
            const index = radicals.findIndex((x) => x.radical === value.radical);
            if (index === -1) {
              radicals.push({ multiple: rational, radical: value.radical });
            } else {
              radicals[index].multiple = add2(radicals[index].multiple, rational);
            }
          }
        } else {
          console.assert(isSubtype(value.type, "integer"));
          rationalSum = add2(rationalSum, [value.re, 1]);
        }
      }
      if (isZero(rationalSum) && radicals.length === 0) {
        if (imSum === 0)
          return [new _ExactNumericValue(0, factory, bignumFactory)];
        return [factory({ im: imSum })];
      }
      const result = [];
      if (imSum !== 0) result.push(factory({ im: imSum }));
      if (radicals.length === 0)
        result.push(
          new _ExactNumericValue({ rational: rationalSum }, factory, bignumFactory)
        );
      else {
        radicals.push({ multiple: rationalSum, radical: 1 });
        result.push(
          ...radicals.map(
            (x) => new _ExactNumericValue(
              { rational: x.multiple, radical: x.radical },
              factory,
              bignumFactory
            )
          )
        );
      }
      return result;
    }
  };

  // src/compute-engine/boxed-expression/numerics.ts
  function asRational(expr) {
    const num = expr.numericValue;
    if (num === null) return void 0;
    if (typeof num === "number" && !Number.isFinite(num)) return void 0;
    if (num instanceof NumericValue && (num.isNaN || num.isPositiveInfinity || num.isNegativeInfinity))
      return void 0;
    if (typeof num === "number") {
      if (!Number.isInteger(num)) return void 0;
      return [num, 1];
    }
    const type2 = num.type;
    if (type2 !== "finite_integer" && type2 !== "finite_rational") return void 0;
    if (num.im !== 0) return void 0;
    if (num instanceof ExactNumericValue) {
      if (num.radical !== 1) return void 0;
      return num.rational;
    }
    const bignumRe = num.bignumRe;
    if (bignumRe !== void 0 && Number.isInteger(bignumRe))
      return [bigint(bignumRe), BigInt(1)];
    const re = num.re;
    if (Number.isInteger(re)) return [re, 1];
    return void 0;
  }
  function asBigint(expr) {
    if (expr === void 0 || expr === null) return null;
    const num = expr.numericValue;
    if (num === null) return null;
    if (typeof num === "number") {
      if (Number.isInteger(num)) return BigInt(num);
      return null;
    }
    if (num.im !== 0) return null;
    const n = num.bignumRe;
    if (n?.isInteger()) return bigint(n);
    if (!Number.isInteger(num.re)) return null;
    return BigInt(num.re);
  }
  function asBignum(expr) {
    if (expr === void 0 || expr === null) return null;
    const num = typeof expr === "number" ? expr : expr.numericValue;
    if (num === null) return null;
    if (typeof num === "number") return expr.engine.bignum(num);
    if (num.im !== 0) return null;
    const re = num.bignumRe ?? num.re;
    if (typeof re === "number" && isNaN(re)) return null;
    return expr.engine.bignum(re);
  }
  function asSmallInteger(expr) {
    if (expr === void 0 || expr === null) return null;
    if (typeof expr === "number") {
      if (Number.isInteger(expr) && expr >= -SMALL_INTEGER && expr <= SMALL_INTEGER)
        return expr;
      return null;
    }
    const num = expr.numericValue;
    if (num === null) return null;
    if (typeof num === "number") {
      if (Number.isInteger(num) && num >= -SMALL_INTEGER && num <= SMALL_INTEGER)
        return num;
      return null;
    }
    if (num.im !== 0) return null;
    const n = num.re;
    if (Number.isInteger(n) && n >= -SMALL_INTEGER && n <= SMALL_INTEGER)
      return Number(n);
    return null;
  }

  // src/compute-engine/boxed-expression/polynomials.ts
  function totalDegree(expr) {
    if (expr.symbol && !expr.isConstant) return 1;
    if (expr.operator === "Power" && expr.op2.isNumberLiteral) {
      if (totalDegree(expr.op1) === 0) return 0;
      const deg = asSmallInteger(expr.op2);
      if (deg !== null && deg > 0) return deg;
      return 0;
    }
    if (expr.operator === "Multiply") {
      let deg = 0;
      for (const arg of expr.ops) {
        const t = totalDegree(arg);
        deg = deg + t;
      }
      return deg;
    }
    if (expr.operator === "Add" || expr.operator === "Subtract") {
      let deg = 0;
      for (const arg of expr.ops) deg = Math.max(deg, totalDegree(arg));
      return deg;
    }
    if (expr.operator === "Negate") return totalDegree(expr.op1);
    if (expr.operator === "Divide") return totalDegree(expr.op1);
    return 0;
  }
  function maxDegree(expr) {
    if (expr.symbol && !expr.isConstant) return 1;
    if (expr.operator === "Power" && expr.op2.isNumberLiteral) {
      if (maxDegree(expr.op1) === 0) return 0;
      const deg = asSmallInteger(expr.op2);
      if (deg !== null && deg > 0) return deg;
      return 0;
    }
    if (expr.operator === "Multiply" || expr.operator === "Add" || expr.operator === "Subtract") {
      let deg = 0;
      for (const arg of expr.ops) deg = Math.max(deg, totalDegree(arg));
      return deg;
    }
    if (expr.operator === "Negate") return maxDegree(expr.op1);
    if (expr.operator === "Divide") return maxDegree(expr.op1);
    return 0;
  }
  function lex(expr) {
    if (expr.symbol && !expr.isConstant) return expr.symbol;
    if (!expr.ops) return "";
    return expr.ops.map((x) => lex(x)).join(" ").trim();
  }
  function revlex(expr) {
    return lex(expr).split(" ").reverse().join(" ").trim();
  }

  // src/compute-engine/boxed-expression/apply.ts
  function apply(expr, fn, bigFn, complexFn) {
    if ((expr?.numericValue ?? null) === null) return void 0;
    const ce = expr.engine;
    let result = void 0;
    if (expr.im !== 0) result = complexFn?.(ce.complex(expr.re, expr.im));
    else {
      const bigRe = expr.bignumRe;
      if (bigRe !== void 0 && bignumPreferred(ce) && bigFn)
        result = bigFn(bigRe);
      else {
        const re = expr.re;
        if (bignumPreferred(ce) && bigFn) result = bigFn(ce.bignum(re));
        else result = fn(re);
      }
    }
    if (result === void 0) return void 0;
    if (result instanceof Complex)
      return ce.number(ce._numericValue({ re: result.re, im: result.im }));
    return ce.number(result);
  }
  function apply2(expr1, expr2, fn, bigFn, complexFn) {
    if (expr1.numericValue === null || expr2.numericValue === null)
      return void 0;
    const ce = expr1.engine;
    let result = void 0;
    if (expr1.im !== 0 || expr2.im !== 0) {
      result = complexFn?.(
        ce.complex(expr1.re, expr1.im),
        ce.complex(expr2.re, expr2.im)
      );
    }
    if (result === void 0 && bigFn) {
      let bigRe1 = expr1.bignumRe;
      let bigRe2 = expr2.bignumRe;
      if (bigRe1 !== void 0 || bigRe2 !== void 0) {
        bigRe1 ?? (bigRe1 = ce.bignum(expr1.re));
        bigRe2 ?? (bigRe2 = ce.bignum(expr2.re));
        result = bigFn(bigRe1, bigRe2);
      }
    }
    if (result === void 0) {
      const re1 = expr1.re;
      const re2 = expr2.re;
      if (!isNaN(re1) && !isNaN(re2)) {
        if (bignumPreferred(ce) && bigFn)
          result = bigFn(
            ce.bignum(expr1.bignumRe ?? re1),
            ce.bignum(expr2.bignumRe ?? re2)
          );
        else result = fn(re1, re2);
      }
    }
    if (result === void 0) return void 0;
    if (result instanceof Complex)
      return ce.number(
        ce._numericValue({ re: ce.chop(result.re), im: ce.chop(result.im) })
      );
    return ce.number(ce.chop(result));
  }

  // src/compute-engine/boxed-expression/arithmetic-power.ts
  function isSqrt(expr) {
    return expr.operator === "Sqrt" || expr.operator === "Power" && expr.op2.im === 0 && expr.op2.re === 0.5 || expr.operator === "Root" && expr.op2.im === 0 && expr.op2.re === 2;
  }
  function asRadical(expr) {
    if (isSqrt(expr)) return asRational(expr.op1) ?? null;
    if (expr.operator === "Divide" && expr.op1.is(1) && isSqrt(expr.op2)) {
      const n = expr.op2.re;
      if (!Number.isInteger(n)) return null;
      return [1, n];
    }
    return null;
  }
  function canonicalPower(a, b) {
    const ce = a.engine;
    a = a.canonical;
    b = b.canonical;
    if (a.is(0)) {
      if (b.is(0)) return ce.NaN;
      if (b.isPositive) return ce.Zero;
      if (b.isNegative) return ce.ComplexInfinity;
    }
    if (a.is(1) || b.is(0)) return ce.One;
    if (b.is(1)) return a;
    if (b.is(0.5)) return canonicalRoot(a, 2);
    const r = asRational(b);
    if (r !== void 0 && r[0] === 1) return canonicalRoot(a, ce.number(r[1]));
    return ce._fn("Power", [a, b]);
  }
  function canonicalRoot(a, b) {
    a = a.canonical;
    const ce = a.engine;
    let exp2 = void 0;
    if (typeof b === "number") exp2 = b;
    else {
      b = b.canonical;
      if (b.isNumberLiteral && b.im === 0) exp2 = b.re;
    }
    if (exp2 === 1) return a;
    if (exp2 === 2) {
      if (a.isNumberLiteral && a.type.matches("rational")) {
        if (a.re < SMALL_INTEGER) {
          const v = a.sqrt();
          if (typeof v.numericValue === "number") return v;
          if (v.numericValue.isExact) return v;
        }
      }
      return ce._fn("Sqrt", [a]);
    }
    return ce._fn("Root", [a, typeof b === "number" ? ce.number(b) : b]);
  }
  function pow2(x, exp2, { numericApproximation }) {
    if (!x.isCanonical) return x.canonical.pow(exp2);
    if (numericApproximation) {
      if (x.isNumberLiteral) {
        if (typeof exp2 === "number") {
          return apply(
            x,
            (x2) => Math.pow(x2, exp2),
            (x2) => x2.pow(exp2),
            (x2) => x2.pow(exp2)
          ) ?? pow2(x, exp2, { numericApproximation: false });
        } else if (exp2.isNumberLiteral)
          return apply2(
            x,
            exp2,
            (x2, exp3) => Math.pow(x2, exp3),
            (x2, exp3) => x2.pow(exp3),
            (x2, exp3) => x2.pow(exp3)
          ) ?? pow2(x, exp2, { numericApproximation: false });
      }
    }
    const ce = x.engine;
    if (typeof exp2 !== "number") exp2 = exp2.canonical;
    const e = typeof exp2 === "number" ? exp2 : exp2.im === 0 ? exp2.re : void 0;
    if (e === 0) return ce.One;
    if (e === 1) return x;
    if (e === -1) {
      if (x.isInfinity && x.isNegative) return ce.Zero;
      if (x.is(-1)) return ce.NegativeOne;
      if (x.is(0)) return ce.ComplexInfinity;
      if (x.is(1)) return ce.One;
      if (x.isInfinity && x.isPositive) return ce.Zero;
      return x.inv();
    }
    if (e === Number.POSITIVE_INFINITY) {
      if (x.is(0)) return ce.Zero;
      if (x.is(1)) return ce.NaN;
      if (x.is(-1)) return ce.NaN;
      if (x.isInfinity) {
        if (x.isPositive) return ce.PositiveInfinity;
        if (x.isNegative) return ce.NaN;
      }
    }
    if (e === Number.NEGATIVE_INFINITY) {
      if (x.is(-1)) return ce.NaN;
      if (x.isInfinity) {
        if (x.isPositive) return ce.Zero;
        if (x.isNegative) return ce.NegativeInfinity;
      }
    }
    if (typeof exp2 !== "number") {
      if (exp2.isInfinity && !exp2.isPositive && !exp2.isNegative) {
        return ce.NaN;
      }
      if (x.isInfinity) {
        if (exp2.type.matches("imaginary")) return ce.NaN;
        if (exp2.type.matches("complex") && !isNaN(exp2.re)) {
          if (exp2.re > 0) return ce.ComplexInfinity;
          if (exp2.re < 0) return ce.Zero;
        }
      }
    }
    if (e === Number.POSITIVE_INFINITY) {
      if (x.isGreater(1)) return ce.PositiveInfinity;
      if (x.isPositive && x.isLess(1)) return ce.Zero;
    }
    if (e === Number.NEGATIVE_INFINITY) {
      if (x.isGreater(1)) return ce.Zero;
      if (x.isPositive && x.isLess(1)) return ce.PositiveInfinity;
    }
    if (typeof exp2 !== "number" && exp2.operator === "Negate")
      return pow2(x, exp2.op1, { numericApproximation }).inv();
    if (x.symbol === "ComplexInfinity") return ce.NaN;
    if (x.symbol === "ExponentialE") {
      let theta = getImaginaryFactor(exp2);
      if (theta !== void 0) {
        theta = canonicalAngle(theta);
        if (theta !== void 0) {
          return ce.function("Cos", [theta]).add(ce.function("Sin", [theta]).mul(ce.I)).simplify();
        }
      } else if (numericApproximation) {
        if (typeof exp2 === "number") {
          return ce.number(ce._numericValue(ce.E.N().numericValue).pow(exp2));
        } else if (exp2.isNumberLiteral) {
          return ce.number(
            ce._numericValue(ce.E.N().numericValue).pow(exp2.numericValue)
          );
        }
      }
    }
    if (x.operator === "Power") {
      const [base, power] = x.ops;
      return pow2(base, power.mul(exp2), { numericApproximation });
    }
    if (x.operator === "Divide") {
      const [num, denom] = x.ops;
      return pow2(num, exp2, { numericApproximation }).div(
        pow2(denom, exp2, { numericApproximation })
      );
    }
    if (x.operator === "Negate") {
      if (e !== void 0) {
        if (e % 2 === 0) return pow2(x.op1, exp2, { numericApproximation });
        return pow2(x.op1, exp2, { numericApproximation }).neg();
      }
    }
    if (x.operator === "Sqrt") {
      if (e === 2) return x.op1;
      if (e !== void 0 && e % 2 === 0) return x.op1.pow(e / 2);
      return pow2(x.op1, exp2, { numericApproximation }).sqrt();
    }
    if (x.operator === "Exp")
      return pow2(ce.E, x.op1.mul(exp2), { numericApproximation });
    if (x.operator === "Multiply") {
      const ops = x.ops.map((x2) => pow2(x2, exp2, { numericApproximation }));
      return ce._fn("Multiply", ops);
    }
    if (typeof exp2 !== "number" && exp2.isNumberLiteral) {
      const r = asRational(exp2);
      if (r !== void 0 && r[0] === 1)
        return root(x, ce.number(r[1]), { numericApproximation });
    }
    if (x.operator === "Root") {
      const [base, root2] = x.ops;
      return pow2(base, ce.box(exp2).div(root2), { numericApproximation });
    }
    if (x.isNumberLiteral && Number.isInteger(e)) {
      const n = x.numericValue;
      if (typeof n === "number") {
        return apply(
          x,
          (x2) => Math.pow(x2, e),
          (x2) => x2.pow(e),
          (x2) => x2.pow(e)
        ) ?? ce._fn("Power", [x, ce.box(exp2)]);
      } else {
        return ce.number(n.pow(e));
      }
    }
    return ce._fn("Power", [x, ce.box(exp2)]);
  }
  function root(a, b, { numericApproximation }) {
    if (numericApproximation) {
      if (a.isNumberLiteral && b.isNumberLiteral) {
        const isNegative = a.isNegative;
        const isEven = b.isEven;
        if (isNegative) a = a.neg();
        return apply2(
          a,
          b,
          (a2, b2) => {
            const result = Math.pow(a2, 1 / b2);
            if (isNegative && !isEven) return -result;
            return result;
          },
          (a2, b2) => {
            const result = a2.pow(b2.pow(-1));
            if (isNegative && !isEven) return result.neg();
            return result;
          },
          (a2, b2) => {
            const result = a2.pow(typeof b2 === "number" ? 1 / b2 : b2.inverse());
            if (isNegative && !isEven) return result.neg();
            return result;
          }
        ) ?? root(a, b, { numericApproximation: false });
      }
    }
    if (a.isNumberLiteral && b.isNumberLiteral && b.isInteger) {
      const e = typeof b === "number" ? b : b.im === 0 ? b.re : void 0;
      if (e !== void 0) {
        if (typeof a.numericValue === "number") {
          const v = a.engine._numericValue(a.numericValue)?.root(e);
          if (v?.isExact) return a.engine.number(v);
        } else {
          const v = a.numericValue.asExact?.root(e);
          if (v?.isExact) return a.engine.number(v);
        }
      }
    }
    return a.engine._fn("Root", [a, b]);
  }

  // src/compute-engine/boxed-expression/order.ts
  var DEFAULT_COMPLEXITY = 1e5;
  var TRIGONOMETRIC_OPERATORS = {
    Sin: true,
    Cos: true,
    Tan: true,
    Cot: true,
    Sec: true,
    Csc: true,
    Sinh: true,
    Cosh: true,
    Tanh: true,
    Coth: true,
    Sech: true,
    Csch: true,
    Arcsin: true,
    Arccos: true,
    Arctan: true,
    Arccot: true,
    Arcsec: true,
    Arccsc: true,
    Arcsinh: true,
    Arccosh: true,
    Arctanh: true,
    Arccoth: true,
    Arccsch: true,
    Arcsech: true
  };
  function isTrigonometricFunction(operator2) {
    if (!operator2 || typeof operator2 !== "string") return false;
    return operator2 in TRIGONOMETRIC_OPERATORS;
  }
  function addOrder(a, b) {
    const aTotalDeg = totalDegree(a);
    const bTotalDeg = totalDegree(b);
    if (aTotalDeg !== bTotalDeg) return bTotalDeg - aTotalDeg;
    const aMaxDeg = maxDegree(a);
    const bMaxDeg = maxDegree(b);
    if (aMaxDeg !== bMaxDeg) return bMaxDeg - aMaxDeg;
    const aLex = revlex(a);
    const bLex = revlex(b);
    if (aLex || bLex) {
      if (!aLex) return 1;
      if (!bLex) return -1;
      if (aLex < bLex) return -1;
      if (aLex > bLex) return 1;
    }
    return order(a, b);
  }
  var RANKS = [
    "integer",
    "rational",
    "radical",
    // Square root of a rational literal
    "real",
    "complex",
    "constant",
    "symbol",
    "multiply",
    "divide",
    "add",
    "trig",
    "fn",
    "power",
    "string",
    "other"
  ];
  function rank(expr) {
    if (typeof expr.numericValue === "number") {
      return Number.isInteger(expr.numericValue) ? "integer" : "real";
    }
    if (expr.numericValue) {
      const type2 = expr.numericValue.type;
      if (type2 === "integer" || type2 === "finite_integer") return "integer";
      if (type2 === "rational" || type2 === "finite_rational") return "rational";
      if (type2 === "real" || type2 === "finite_real") return "real";
      if (type2 === "complex" || type2 === "finite_complex") return "complex";
      if (type2 === "imaginary") return "complex";
      if (type2 === "finite_number") return "complex";
      if (type2 === "non_finite_number") return "constant";
      if (type2 === "number") return "real";
      return "other";
    }
    if (expr.symbol === "ImaginaryUnit") return "complex";
    if (asRadical(expr)) return "radical";
    if (expr.symbol && expr.isConstant) return "constant";
    if (expr.symbol) return "symbol";
    if (isTrigonometricFunction(expr.operator)) return "trig";
    if (expr.operator === "Add") return "add";
    if (expr.operator === "Power" || expr.operator === "Root") return "power";
    if (expr.operator === "Multiply" || expr.operator === "Negate")
      return "multiply";
    if (expr.operator === "Divide") return "divide";
    if (expr.operator === "Rational") return "rational";
    if (expr.operator === "Complex") return expr.im !== 0 ? "complex" : "real";
    if (expr.operator === "Sqrt") {
      if (expr.op1.isNumberLiteral && (expr.op1.isInteger || expr.op1.isRational))
        return "radical";
      return "power";
    }
    if (expr.ops) return "fn";
    if (expr.string) return "string";
    return "other";
  }
  function order(a, b) {
    if (a === b) return 0;
    const rankA = rank(a);
    const rankB = rank(b);
    if (rankA !== rankB) return RANKS.indexOf(rankA) - RANKS.indexOf(rankB);
    if (rankA === "complex") {
      const [reA, imA] = getComplex(a);
      const [reB, imB] = getComplex(b);
      if (imA !== imB) return imA - imB;
      return reA - reB;
    }
    if (rankA === "integer" || rankA === "rational" || rankA === "real") {
      let aN = a.numericValue;
      let bN = b.numericValue;
      if (aN === null && a.operator === "Rational") aN = a.op1.re / a.op2.re;
      if (bN === null && b.operator === "Rational") bN = b.op1.re / b.op2.re;
      const af = typeof aN === "number" ? aN : aN.re;
      const bf = typeof bN === "number" ? bN : bN.re;
      return af - bf;
    }
    if (rankA === "radical") return order(a.op1, b.op1);
    if (rankA === "constant" || rankA === "symbol") {
      if (a.symbol === b.symbol) return 0;
      return a.symbol > b.symbol ? 1 : -1;
    }
    if (rankA === "add") {
      const aOps = a.ops;
      const bOps = b.ops;
      if (aOps.length !== bOps.length) return bOps.length - aOps.length;
      for (let i = 0; i < aOps.length; i++) {
        const cmp2 = order(aOps[i], bOps[i]);
        if (cmp2 !== 0) return cmp2;
      }
      return 0;
    }
    if (rankA === "power") {
      const totalDegreeA = totalDegree(a);
      const totalDegreeB = totalDegree(b);
      if (totalDegreeA !== totalDegreeB) {
        return totalDegreeB - totalDegreeA;
      }
      const maxDegreeA = maxDegree(a);
      const maxDegreeB = maxDegree(b);
      if (maxDegreeA !== maxDegreeB) {
        return maxDegreeA - maxDegreeB;
      }
      return order(a.op1, b.op1);
    }
    if (rankA === "multiply") {
      const totalDegreeA = totalDegree(a);
      const totalDegreeB = totalDegree(b);
      if (totalDegreeA !== totalDegreeB) return totalDegreeB - totalDegreeA;
      const maxDegreeA = maxDegree(a);
      const maxDegreeB = maxDegree(b);
      if (maxDegreeA !== maxDegreeB) return maxDegreeA - maxDegreeB;
      const aOps = a.ops;
      const bOps = b.ops;
      if (aOps.length !== bOps.length) return bOps.length - aOps.length;
      for (let i = 0; i < aOps.length; i++) {
        const cmp2 = order(aOps[i], bOps[i]);
        if (cmp2 !== 0) return cmp2;
      }
      return 0;
    }
    if (rankA === "divide") {
      const totalDegreeA = totalDegree(a.op1);
      const totalDegreeB = totalDegree(b.op1);
      if (totalDegreeA !== totalDegreeB) return totalDegreeB - totalDegreeA;
      const maxDegreeA = maxDegree(a.op1);
      const maxDegreeB = maxDegree(b.op1);
      if (maxDegreeA !== maxDegreeB) return maxDegreeA - maxDegreeB;
      const numOrder = order(a.op1, b.op1);
      if (numOrder !== 0) return numOrder;
      return order(a.op2, b.op2);
    }
    if (rankA === "fn" || rankA === "trig") {
      if (a.operator == b.operator && a.nops === 1 && b.nops === 1) {
        return order(a.op1, b.op1);
      }
      const aComplexity = a.functionDefinition?.complexity ?? DEFAULT_COMPLEXITY;
      const bComplexity = b.functionDefinition?.complexity ?? DEFAULT_COMPLEXITY;
      if (aComplexity === bComplexity) {
        if (a.operator === b.operator) return getLeafCount(a) - getLeafCount(b);
        if (a.operator < b.operator) return 1;
        return -1;
      }
      return aComplexity - bComplexity;
    }
    if (rankA === "string") {
      if (a.string === b.string) return 0;
      if (b.string < a.string) return -1;
      return 1;
    }
    return (a.complexity ?? DEFAULT_COMPLEXITY) - (b.complexity ?? DEFAULT_COMPLEXITY);
  }
  function canonicalOrder(expr, { recursive = false }) {
    if (expr.isCanonical || !expr.ops) return expr;
    let ops = expr.ops;
    if (recursive) ops = ops.map((x) => canonicalOrder(x, { recursive }));
    ops = sortOperands(expr.operator, ops);
    return expr.engine._fn(expr.operator, ops, { canonical: false });
  }
  function sortOperands(operator2, xs) {
    if (xs.length === 0) return xs;
    const ce = xs[0].engine;
    if (operator2 === "Add") return [...xs].sort(addOrder);
    if (operator2 === "Multiply") return [...xs].sort(order);
    const def = ce.lookupFunction(operator2);
    if (!def) return xs;
    const isCommutative = def.commutative;
    if (!isCommutative) return xs;
    if (def.commutativeOrder) return [...xs].sort(def.commutativeOrder);
    return [...xs].sort(order);
  }
  function getLeafCount(expr) {
    if (!expr.ops) return 1;
    return 1 + [...expr.ops].reduce((acc, x) => acc + getLeafCount(x), 0);
  }
  function getComplex(a) {
    if (a.symbol === "ImaginaryUnit") return [0, 1];
    if (a.numericValue) {
      if (typeof a.numericValue === "number") return [a.numericValue, 0];
      const v = a.numericValue;
      return [v.re, v.im];
    }
    if (a.operator === "Complex") {
      const op1 = a.op1.numericValue;
      if (op1 === null) return [0, 0];
      const re = typeof op1 === "number" ? op1 : op1.re;
      const op2 = a.op2.numericValue;
      if (op2 === null) return [0, 0];
      const im = typeof op2 === "number" ? op2 : op2.re;
      return [re, im];
    }
    return [0, 0];
  }

  // src/compute-engine/numerics/numeric-complex.ts
  function gamma(c) {
    return c;
  }
  function gammaln(c) {
    return c;
  }

  // src/compute-engine/numerics/numeric-bignum.ts
  function gcd3(a, b) {
    console.assert(a.isInteger() && b.isInteger());
    while (!b.isZero()) [a, b] = [b, a.modulo(b)];
    return a.abs();
  }
  function lcm3(a, b) {
    return a.mul(b).div(gcd3(a, b));
  }
  function factorial22(ce, n) {
    if (!n.isInteger() || n.isNegative()) return ce._BIGNUM_NAN;
    if (n.lessThan(1)) return ce._BIGNUM_ONE;
    let result = n;
    while (n.greaterThan(2)) {
      n = n.minus(2);
      result = result.mul(n);
    }
    return result;
  }
  function isInMachineRange(d) {
    if (!d.isFinite()) return true;
    if (d.d.length > 3 || d.d.length === 3 && d.d[0] >= 90) return false;
    console.assert(d.precision() <= 16);
    return d.e < 308 && d.e > -306;
  }

  // src/compute-engine/numerics/special-functions.ts
  var gammaG = 7;
  var lanczos_7_c = [
    0.9999999999998099,
    676.5203681218851,
    -1259.1392167224028,
    771.3234287776531,
    -176.6150291621406,
    12.507343278686905,
    -0.13857109526572012,
    9984369578019572e-21,
    15056327351493116e-23
  ];
  function gammaln2(z) {
    if (z < 0) return NaN;
    const pi = Math.PI;
    const z3 = z * z * z;
    return z * Math.log(z) - z - 0.5 * Math.log(z) + 0.5 * Math.log(2 * pi) + 1 / (12 * z) - 1 / (360 * z3) + 1 / (1260 * z3 * z * z);
  }
  function gamma2(z) {
    if (z < 0.5) return Math.PI / (Math.sin(Math.PI * z) * gamma2(1 - z));
    if (z > 100) return Math.exp(gammaln2(z));
    z -= 1;
    let x = lanczos_7_c[0];
    for (let i = 1; i < gammaG + 2; i++) x += lanczos_7_c[i] / (z + i);
    const t = z + gammaG + 0.5;
    return Math.sqrt(2 * Math.PI) * Math.pow(t, z + 0.5) * Math.exp(-t) * x;
  }
  function erfInv(x) {
    const pi = Math.PI;
    const pi2 = pi * pi;
    const pi3 = pi2 * pi;
    const x2 = x * x;
    const x3 = x * x2;
    const x5 = x3 * x2;
    const x7 = x5 * x2;
    return Math.sqrt(pi) / 2 * (x + pi / 12 * x3 + 7 * pi2 / 480 * x5 + 127 * pi3 / 40320 * x7 + 4369 * pi2 * pi2 / 5806080 * x7 * x2 + 34807 * pi3 * pi2 / 182476800 * x7 * x2 * x2);
  }
  function erf(x) {
    const a1 = 0.254829592;
    const a2 = -0.284496736;
    const a3 = 1.421413741;
    const a4 = -1.453152027;
    const a5 = 1.061405429;
    const p = 0.3275911;
    const sign2 = x < 0 ? -1 : 1;
    x = Math.abs(x);
    const t = 1 / (1 + p * x);
    const y = ((((a5 * t + a4) * t + a3) * t + a2) * t + a1) * t;
    return sign2 * (1 - y * Math.exp(-x * x));
  }
  function bigGammaln(ce, z) {
    if (z.isNegative()) return ce._BIGNUM_NAN;
    const GAMMA_P_LN = ce.cache("gamma-p-ln", () => {
      return [
        "0.99999999999999709182",
        "57.156235665862923517",
        "-59.597960355475491248",
        "14.136097974741747174",
        "-0.49191381609762019978",
        "0.33994649984811888699e-4",
        "0.46523628927048575665e-4",
        "-0.98374475304879564677e-4",
        "0.15808870322491248884e-3",
        "-0.21026444172410488319e-3",
        "0.2174396181152126432e-3",
        "-0.16431810653676389022e-3",
        "0.84418223983852743293e-4",
        "-0.2619083840158140867e-4",
        "0.36899182659531622704e-5"
      ].map((x2) => ce.bignum(x2));
    });
    let x = GAMMA_P_LN[0];
    for (let i = GAMMA_P_LN.length - 1; i > 0; --i) {
      x = x.add(GAMMA_P_LN[i].div(z.add(i)));
    }
    const GAMMA_G_LN = ce.cache("gamma-g-ln", () => ce.bignum(607).div(128));
    const t = z.add(GAMMA_G_LN).add(ce._BIGNUM_HALF);
    return ce._BIGNUM_NEGATIVE_ONE.acos().mul(ce._BIGNUM_TWO).log().mul(ce._BIGNUM_HALF).add(
      t.log().mul(z.add(ce._BIGNUM_HALF)).minus(t).add(x.log()).minus(z.log())
    );
  }
  function bigGamma(ce, z) {
    if (z.lessThan(ce._BIGNUM_HALF)) {
      const pi = ce._BIGNUM_NEGATIVE_ONE.acos();
      return pi.div(
        pi.mul(z).sin().mul(bigGamma(ce, ce._BIGNUM_ONE.sub(z)))
      );
    }
    if (z.greaterThan(100)) return bigGammaln(ce, z).exp();
    z = z.sub(1);
    const LANCZOS_7_C = ce.cache("lanczos-7-c", () => {
      return [
        "0.99999999999980993227684700473478",
        "676.520368121885098567009190444019",
        "-1259.13921672240287047156078755283",
        "771.3234287776530788486528258894",
        "-176.61502916214059906584551354",
        "12.507343278686904814458936853",
        "-0.13857109526572011689554707",
        "9.984369578019570859563e-6",
        "1.50563273514931155834e-7"
      ].map((x2) => ce.bignum(x2));
    });
    let x = LANCZOS_7_C[0];
    for (let i = 1; i < gammaG + 2; i++) x = x.add(LANCZOS_7_C[i].div(z.add(i)));
    const t = z.add(gammaG).add(ce._BIGNUM_HALF);
    return ce._BIGNUM_NEGATIVE_ONE.acos().times(ce._BIGNUM_TWO).sqrt().mul(x.mul(t.neg().exp()).mul(t.pow(z.add(ce._BIGNUM_HALF))));
  }

  // src/compute-engine/boxed-expression/product.ts
  var Product = class _Product {
    constructor(ce, xs, options) {
      this.options = options;
      // Other terms of the product, `term` is the key
      this.terms = [];
      // If `false`, the running products are not calculated
      this._isCanonical = true;
      options = options ? { ...options } : {};
      if (!("canonical" in options)) options.canonical = true;
      this._isCanonical = options.canonical;
      this.engine = ce;
      this.coefficient = ce._numericValue(1);
      if (xs) for (const x of xs) this.mul(x);
    }
    static from(expr) {
      return new _Product(expr.engine, [expr]);
    }
    /**
     * Add a term to the product.
     *
     * If `this._isCanonical` a running product of exact terms is kept.
     * Otherwise, terms and their exponent are tallied.
     */
    mul(term, exp2) {
      console.assert(term.isCanonical || term.isStructural);
      if (this.coefficient.isNaN) return;
      if (term.isNaN) {
        this.coefficient = this.engine._numericValue(NaN);
        return;
      }
      if (term.operator === "Multiply") {
        for (const t of term.ops) this.mul(t, exp2);
        return;
      }
      if (term.operator === "Negate") {
        this.mul(term.op1, exp2);
        this.coefficient = this.coefficient.neg();
        return;
      }
      if (this._isCanonical) {
        if (term.symbol === "Nothing") return;
        exp2 ?? (exp2 = [1, 1]);
        const num = term.numericValue;
        if (num !== null) {
          if (term.is(1)) return;
          if (term.is(0)) {
            this.coefficient = this.engine._numericValue(isZero(exp2) ? NaN : 0);
            return;
          }
          if (term.is(-1)) {
            if (isOne(exp2)) this.coefficient = this.coefficient.neg();
            else {
              this.coefficient = this.coefficient.mul(
                this.engine._numericValue(-1).pow(this.engine._numericValue(exp2))
              );
            }
            return;
          }
          if (term.isInfinity) {
            if (isOne(exp2)) {
              this.coefficient = this.engine._numericValue(
                term.isNegative ? -Infinity : Infinity
              );
            } else this.terms.push({ term, exponent: exp2 });
            return;
          }
          if (isOne(exp2)) {
            this.coefficient = this.coefficient.mul(num);
          } else
            this.coefficient = this.coefficient.mul(
              this.engine._numericValue(num).pow(this.engine._numericValue(exp2))
            );
          return;
        }
        const radical = asRadical(term);
        if (radical !== null) {
          this.coefficient = this.coefficient.mul(
            this.engine._numericValue({
              radical: radical[0] * radical[1],
              rational: [1, Number(radical[1])]
            }).pow(this.engine._numericValue(exp2))
          );
          return;
        }
        if (!term.symbol) {
          let coef;
          [coef, term] = term.toNumericValue();
          if (exp2 && !isOne(exp2)) coef = coef.pow(this.engine._numericValue(exp2));
          this.coefficient = this.coefficient.mul(coef);
        }
      }
      if (term.is(1) && (!exp2 || isOne(exp2))) return;
      if (term.is(0) === false && exp2 && isZero(exp2)) return;
      if (term.is(0)) {
        if (exp2 && isZero(exp2)) this.coefficient = this.engine._numericValue(NaN);
        else this.coefficient = this.engine._numericValue(0);
        return;
      }
      const exponent = exp2 ?? [1, 1];
      if (term.operator === "Power") {
        const r = asRational(term.op2);
        if (r) {
          this.mul(term.op1, mul2(exponent, r));
          return;
        }
      }
      if (term.operator === "Sqrt") {
        this.mul(term.op1, mul2(exponent, [1, 2]));
        return;
      }
      if (term.operator === "Root") {
        const r = asRational(term.op2);
        if (r) {
          this.mul(term.op1, mul2(exponent, inverse(r)));
          return;
        }
      }
      if (term.operator === "Divide") {
        this.mul(term.op1, exponent);
        this.mul(term.op2, neg(exponent));
        return;
      }
      let found = false;
      for (const x of this.terms) {
        if (x.term.isSame(term)) {
          x.exponent = add2(x.exponent, exponent);
          found = true;
          break;
        }
      }
      if (!found) this.terms.push({ term, exponent });
    }
    /** Divide the product by a term of coefficient */
    div(term) {
      if (term instanceof NumericValue)
        this.coefficient = this.coefficient.div(term);
      else this.mul(term, [-1, 1]);
    }
    /** The terms of the product, grouped by degrees.
     *
     * If `mode` is `rational`, rationals are split into separate numerator and
     * denominator, so that a rational expression can be created later
     * If `mode` is `expression`, a boxed expression is returned, without
     * splitting rationals
     * If `mode` is `numeric`, the literals are combined into one expression
     *
     */
    groupedByDegrees(options) {
      options ?? (options = {});
      if (!("mode" in options)) options.mode = "expression";
      const mode2 = options.mode;
      if (mode2 === "numeric" && (this.coefficient.isNegativeInfinity || this.coefficient.isPositiveInfinity))
        return [];
      if (this.coefficient.isZero) return [];
      const ce = this.engine;
      if (this.terms.length === 0) {
        if (mode2 === "numeric") {
          const c = this.coefficient.N();
          return [{ exponent: [1, 1], terms: [ce.number(c)] }];
        } else {
          return [{ exponent: [1, 1], terms: [ce.number(this.coefficient)] }];
        }
      }
      const xs = [];
      if (!this.coefficient.isOne) {
        if (mode2 === "rational" && this.coefficient.type === "finite_rational") {
          const num = this.coefficient.numerator;
          if (!num.isOne) xs.push({ exponent: [1, 1], terms: [ce.number(num)] });
          const denom = this.coefficient.denominator;
          if (!denom.isOne)
            xs.push({ exponent: [-1, 1], terms: [ce.number(denom)] });
        } else if (mode2 === "numeric") {
          const c = this.coefficient.N();
          xs.push({ exponent: [1, 1], terms: [ce.number(c)] });
        } else {
          xs.push({ exponent: [1, 1], terms: [ce.number(this.coefficient)] });
        }
      }
      for (const t of this.terms) {
        const exponent = reducedRational(t.exponent);
        if (exponent[0] === 0) continue;
        let found = false;
        for (const x of xs) {
          if (exponent[0] === x.exponent[0] && exponent[1] === x.exponent[1]) {
            x.terms.push(t.term);
            found = true;
            break;
          }
        }
        if (!found) xs.push({ exponent, terms: [t.term] });
      }
      return xs;
    }
    asExpression(options = { numericApproximation: false }) {
      const ce = this.engine;
      const coef = this.coefficient;
      if (coef.isNaN) return ce.NaN;
      if (coef.isPositiveInfinity) return ce.PositiveInfinity;
      if (coef.isNegativeInfinity) return ce.NegativeInfinity;
      if (coef.isZero) return ce.Zero;
      const isNegativeOne2 = coef.isNegativeOne;
      if (isNegativeOne2) this.coefficient = ce._numericValue(1);
      const groupedTerms = this.groupedByDegrees({
        mode: options.numericApproximation ? "numeric" : "expression"
      });
      if (groupedTerms === null) return ce.NaN;
      if (isNegativeOne2) {
        const result = termsAsExpression(ce, groupedTerms).neg();
        this.coefficient = ce._numericValue(-1);
        return result;
      }
      return termsAsExpression(ce, groupedTerms);
    }
    /** The product, expressed as a numerator and denominator */
    asNumeratorDenominator() {
      const ce = this.engine;
      const coef = this.coefficient;
      if (coef.isZero) return [ce.Zero, ce.One];
      if (coef.isPositiveInfinity || coef.isNegativeInfinity) {
        if (this.terms.length === 0) {
          return [
            coef.isPositiveInfinity ? ce.PositiveInfinity : ce.NegativeInfinity,
            ce.One
          ];
        }
        return [ce.NaN, ce.NaN];
      }
      const isNegativeOne2 = coef.isNegativeOne;
      if (isNegativeOne2) this.coefficient = ce._numericValue(1);
      const xs = this.groupedByDegrees({ mode: "rational" });
      this.coefficient = coef;
      if (xs === null) return [ce.NaN, ce.NaN];
      const xsNumerator = xs.filter((x) => x.exponent[0] >= 0);
      const xsDenominator = xs.filter((x) => x.exponent[0] < 0).map((x) => ({
        exponent: neg(x.exponent),
        terms: x.terms
      }));
      const num = termsAsExpression(ce, xsNumerator);
      return [
        isNegativeOne2 ? num.neg() : num,
        termsAsExpression(ce, xsDenominator)
      ];
    }
    asRationalExpression() {
      const [numerator, denominator] = this.asNumeratorDenominator();
      return canonicalDivide(numerator, denominator);
    }
  };
  function commonTerms(lhs, rhs) {
    const ce = lhs.engine;
    const coef = lhs.coefficient.gcd(rhs.coefficient);
    if (coef.isOne) return [ce._numericValue(1), ce.One];
    const xs = [];
    for (const x of lhs.terms) {
      const y = rhs.terms.find((y2) => x.term.isSame(y2.term));
      if (!y) continue;
      const exponent = rationalGcd(x.exponent, y.exponent);
      if (isOne(exponent)) xs.push(x.term);
      else {
        const [n, d] = asMachineRational(exponent);
        if (d === 1) xs.push(x.term.pow(n));
        else if (n === 1) xs.push(x.term.root(d));
        else xs.push(x.term.pow(n).root(d));
      }
    }
    return [coef, xs.length === 0 ? ce.One : mul3(...xs)];
  }
  function termsAsExpression(ce, terms) {
    let result = terms.map(({ terms: terms2, exponent }) => {
      const t = flatten(terms2, "Multiply");
      const base = t.length <= 1 ? t[0] : ce._fn("Multiply", [...t].sort(order));
      return isOne(exponent) ? base : base.pow(ce.number(exponent));
    });
    result = flatten(result, "Multiply");
    if (result.length === 0) return ce.One;
    if (result.length === 1) return result[0];
    return ce._fn("Multiply", result.sort(order));
  }

  // src/math-json/identifiers.ts
  var recommendedScriptsRegex;
  function isRecommendedScripts(text) {
    if (!recommendedScriptsRegex) {
      const recommendedScripts = [
        "Zyyy",
        "Zinh",
        "Arab",
        "Armn",
        "Beng",
        "Bopo",
        "Cyrl",
        "Deva",
        "Ethi",
        "Geor",
        "Grek",
        "Gujr",
        "Guru",
        "Hang",
        "Hani",
        "Hebr",
        "Hira",
        "Kana",
        "Knda",
        "Khmr",
        "Laoo",
        "Latn",
        "Mlym",
        "Mymr",
        "Orya",
        "Sinh",
        "Taml",
        "Telu",
        "Thaa",
        "Thai",
        "Tibt"
      ];
      const regexPattern = `^[${recommendedScripts.map((x) => `\\p{Script=${x}}`).join("")}]*$`;
      recommendedScriptsRegex = new RegExp(regexPattern, "u");
    }
    return recommendedScriptsRegex.test(text);
  }
  function isValidIdentifier(s) {
    if (/^[a-zA-Z_][a-zA-Z0-9_]*$/.test(s)) return true;
    if (EMOJIS.test(s)) return true;
    if (!isRecommendedScripts(s)) return false;
    return /^[\p{XIDS}_]\p{XIDC}*$/u.test(s);
  }
  var VS16 = "\\u{FE0F}";
  var KEYCAP = "\\u{20E3}";
  var ZWJ2 = "\\u{200D}";
  var FLAG_SEQUENCE = "\\p{RI}\\p{RI}";
  var TAG_MOD = `(?:[\\u{E0020}-\\u{E007E}]+\\u{E007F})`;
  var EMOJI_MOD = `(?:\\p{EMod}|${VS16}${KEYCAP}?|${TAG_MOD})`;
  var EMOJI_NOT_IDENTIFIER = `(?:(?=\\P{XIDC})\\p{Emoji})`;
  var ZWJ_ELEMENT = `(?:${EMOJI_NOT_IDENTIFIER}${EMOJI_MOD}*|\\p{Emoji}${EMOJI_MOD}+|${FLAG_SEQUENCE})`;
  var POSSIBLE_EMOJI = `(?:${ZWJ_ELEMENT})(${ZWJ2}${ZWJ_ELEMENT})*`;
  var SOME_EMOJI = new RegExp(`(?:${POSSIBLE_EMOJI})+`, "u");
  var EMOJIS = new RegExp(`^(?:${POSSIBLE_EMOJI})+$`, "u");
  function validateIdentifier(s) {
    if (typeof s !== "string") return "not-a-string";
    if (s === "") return "empty-string";
    if (s.normalize() !== s) return "expected-nfc";
    if (/[\u200E\u200F\u2066-\u2069\u202A-\u202E]/.test(s))
      return "unexpected-bidi-marker";
    if (EMOJIS.test(s)) return "valid";
    if (/\p{XIDC}/u.test(s) && SOME_EMOJI.test(s))
      return "unexpected-mixed-emoji";
    if (!isRecommendedScripts(s)) return "unexpected-script";
    if (!isValidIdentifier(s)) {
      if (!isValidIdentifier(s[0])) return "invalid-first-char";
      return "invalid-char";
    }
    return "valid";
  }

  // src/compute-engine/latex-syntax/dictionary/definitions-algebra.ts
  var DEFINITIONS_ALGEBRA = [
    {
      name: "To",
      latexTrigger: ["\\to"],
      kind: "infix",
      precedence: 270
      // MathML rightwards arrow
    },
    {
      latexTrigger: ["\\rightarrow"],
      kind: "infix",
      precedence: 270,
      // MathML rightwards arrow
      parse: "To"
    }
  ];

  // src/compute-engine/latex-syntax/serializer-style.ts
  function getApplyFunctionStyle(_expr, _level) {
    return "normal";
  }
  function getGroupStyle(_expr, _level) {
    return "normal";
  }
  function getRootStyle(_expr, level) {
    return level > 2 ? "solidus" : "radical";
  }
  function getFractionStyle(expr, level) {
    if (level > 3) return "inline-solidus";
    if (operator(expr) === "Divide") {
      const [op1, op2] = operands(expr);
      const [n, d] = [countLeaves(op1), countLeaves(op2)];
      if (d <= 2 && n > 5) return "factor";
      if (n <= 2 && d > 5) return "reciprocal";
    }
    return "quotient";
  }
  function getLogicStyle(_expr, _level) {
    return "boolean";
  }
  function getPowerStyle(_expr, _level) {
    return "solidus";
  }
  function getNumericSetStyle(_expr, _level) {
    return "compact";
  }
  function latexTemplate(s, lhs, rhs) {
    if (s.indexOf("#1") < 0 && s.indexOf("#2") < 0) s = `#1 ${s} #2`;
    const parts = s.split(/(#\d+)/).filter((x) => x.trim() !== "").map((x) => x.trim());
    return joinLatex(
      parts.map((x) => {
        switch (x) {
          case "#1":
            return lhs;
          case "#2":
            return rhs;
          default:
            return x;
        }
      })
    );
  }

  // src/compute-engine/latex-syntax/dictionary/definitions-arithmetic.ts
  function numeratorDenominator(expr) {
    if (operator(expr) !== "Multiply") return [[], []];
    const numerator = [];
    const denominator = [];
    for (const arg of operands(expr)) {
      if (operator(arg) === "Power") {
        const op1 = operand(arg, 1);
        const op2 = operand(arg, 2);
        if (operator(op2) === "Negate") {
          const b = operand(op2, 1);
          if (op1 && b) denominator.push(["Power", op1, b]);
        } else {
          const exponentVal = machineValue(op2) ?? NaN;
          if (exponentVal === -1) {
            if (op1) denominator.push(op1);
          } else if (exponentVal < 0) {
            if (op1) denominator.push(["Power", op1, -exponentVal]);
          } else {
            numerator.push(arg);
          }
        }
      } else if (operator(arg) === "Rational" && nops(arg) === 2 || operator(arg) === "Divide") {
        const op1 = operand(arg, 1);
        const op2 = operand(arg, 2);
        if (machineValue(op1) !== 1) numerator.push(op1);
        if (machineValue(op2) !== 1) denominator.push(op2);
      } else {
        const r = rationalValue(arg);
        if (r !== null) {
          if (r[0] !== 1) numerator.push(r[0]);
          denominator.push(r[1]);
        } else numerator.push(arg);
      }
    }
    return [numerator, denominator];
  }
  function parseRoot(parser) {
    const degree = parser.parseOptionalGroup();
    const base = parser.parseGroup() ?? parser.parseToken();
    if (isEmptySequence(base)) {
      if (degree !== null) return ["Root", MISSING, missingIfEmpty(degree)];
      return ["Sqrt", MISSING];
    }
    if (degree !== null) return ["Root", base, degree];
    return ["Sqrt", base];
  }
  function serializeRoot(serializer, style, base, degree) {
    if (base === null || base === void 0) return "\\sqrt{}";
    degree = degree ?? 2;
    if (style === "solidus") {
      return serializer.wrapShort(base) + "^{1/" + serializer.serialize(degree) + "}";
    } else if (style === "quotient") {
      return serializer.wrapShort(base) + "^{\\frac{1}{" + serializer.serialize(degree) + "}}";
    }
    const degreeValue = machineValue(degree);
    if (degreeValue === 2) return "\\sqrt{" + serializer.serialize(base) + "}";
    return "\\sqrt[" + serializer.serialize(degree) + "]{" + serializer.serialize(base) + "}";
  }
  function serializeAdd(serializer, expr) {
    serializer.level -= 1;
    const name = operator(expr);
    let result = "";
    let arg = operand(expr, 1);
    if (name === "Negate") {
      result = "-" + serializer.wrap(arg, ADDITION_PRECEDENCE + 1);
    } else if (name === "Subtract") {
      result = serializer.wrap(arg, ADDITION_PRECEDENCE);
      const arg2 = operand(expr, 2);
      if (arg2 !== null) {
        const term = serializer.wrap(arg2, ADDITION_PRECEDENCE);
        if (term[0] === "-") result += "+" + term.slice(1);
        else if (term[0] === "+") result += "-" + term.slice(1);
        else result = result + "-" + term;
      }
    } else if (name === "Add") {
      if (serializer.options.prettify && nops(expr) === 2 && serializer.options.invisiblePlus !== "+") {
        const [op1, op2] = [operand(expr, 1), operand(expr, 2)];
        let [lhs, rhs] = [op1, op2];
        let lhsValue = machineValue(lhs);
        let rhsValue = rationalValue(rhs);
        if (lhsValue === null || rhsValue === null) {
          [lhs, rhs] = [op2, op1];
          lhsValue = machineValue(lhs);
          rhsValue = rationalValue(rhs);
        }
        if (lhsValue !== null && rhsValue !== null) {
          if (isFinite(lhsValue) && Number.isInteger(lhsValue) && lhsValue >= 0 && lhsValue <= 1e3 && isFinite(rhsValue[0]) && isFinite(rhsValue[1]) && rhsValue[0] > 0 && rhsValue[0] <= 100 && rhsValue[1] <= 100) {
            result = latexTemplate(
              serializer.options.invisiblePlus,
              serializer.serialize(lhs),
              serializer.serialize(rhs)
            );
            serializer.level += 1;
            return result;
          }
        }
      }
      if (serializer.options.prettify && nops(expr) === 2) {
        const [first, firstSign] = unsign(arg);
        const [second, secondSign] = unsign(operand(expr, 2));
        if (firstSign < 0 && secondSign > 0) {
          result = serializer.wrap(second, ADDITION_PRECEDENCE) + "-" + serializer.wrap(first, ADDITION_PRECEDENCE);
          serializer.level += 1;
          return result;
        }
      }
      result = serializer.serialize(arg);
      const last = nops(expr) + 1;
      const ops = operands(expr);
      for (let i = 2; i < last; i++) {
        arg = ops[i - 1];
        if (serializer.options.prettify) {
          const [newArg, sign2] = unsign(arg);
          const term = serializer.wrap(newArg, ADDITION_PRECEDENCE);
          if (sign2 > 0) {
            if (term.startsWith("+") || term.startsWith("-")) result += term;
            else result += "+" + term;
          } else {
            if (term.startsWith("+")) result += "-" + term.slice(1);
            else if (term.startsWith("-")) result += "+" + term.slice(1);
            else result += "-" + term;
          }
        } else {
          const term = serializer.wrap(arg, ADDITION_PRECEDENCE);
          if (term[0] === "-" || term[0] === "+") result += term;
          else result += "+" + term;
        }
      }
    }
    serializer.level += 1;
    return result;
  }
  function serializeMultiply(serializer, expr) {
    if (expr === null) return "";
    serializer.level -= 1;
    let result = "";
    if (serializer.options.prettify === true) {
      const [numer, denom] = numeratorDenominator(expr);
      if (denom.length > 0) {
        if (denom.length === 1 && denom[0] === 1) {
          if (numer.length === 0) result = "1";
          else if (numer.length === 1) result = serializer.serialize(numer[0]);
          else result = serializeMultiply(serializer, ["Multiply", ...numer]);
        } else {
          result = serializer.serialize([
            "Divide",
            numer.length === 1 ? numer[0] : ["Multiply", ...numer],
            denom.length === 1 ? denom[0] : ["Multiply", ...denom]
          ]);
        }
      }
    }
    if (result) {
      serializer.level += 1;
      return result;
    }
    let isNegative = false;
    let arg = null;
    const count = nops(expr) + 1;
    let xs = operands(expr);
    if (serializer.options.prettify === true) {
      if (xs.length === 2) {
        if (isNumberExpression(xs[1]) && !isNumberExpression(xs[0])) {
          xs = [xs[1], xs[0]];
        }
      }
    }
    let prevWasNumber = false;
    for (let i = 1; i < count; i++) {
      arg = xs[i - 1];
      if (arg === null) continue;
      let term;
      if (isNumberExpression(arg)) {
        term = serializer.serialize(arg);
        if (term === "-1" && !result) {
          result = "";
          isNegative = !isNegative;
        } else {
          if (term[0] === "-") {
            term = term.slice(1);
            isNegative = !isNegative;
          }
          if (!result) result = term;
          else result = latexTemplate(serializer.options.multiply, result, term);
        }
        prevWasNumber = true;
        continue;
      }
      if (operator(arg) === "Power") {
        const r = rationalValue(operand(arg, 2));
        if (r !== void 0 && r !== null) {
          const [n, d] = r;
          if (n === 1 && d !== null) {
            result += serializeRoot(
              serializer,
              serializer.rootStyle(arg, serializer.level),
              operand(arg, 1),
              d
            );
            prevWasNumber = false;
            continue;
          }
        }
      }
      if (operator(arg) === "Power" && !isNaN(machineValue(operand(arg, 1)) ?? NaN)) {
        term = serializer.serialize(arg);
        if (!result) result = term;
        else result = latexTemplate(serializer.options.multiply, result, term);
        prevWasNumber = true;
        continue;
      }
      if (operator(arg) === "Negate") {
        arg = operand(arg, 1);
        isNegative = !isNegative;
      }
      term = serializer.wrap(arg, MULTIPLICATION_PRECEDENCE);
      if (!result) {
        result = term;
      } else {
        const h = operator(arg);
        if (prevWasNumber && (h === "Divide" || h === "Rational")) {
          result = latexTemplate(serializer.options.multiply, result, term);
        } else if (!serializer.options.invisibleMultiply) {
          result = joinLatex([result, term]);
        } else {
          result = latexTemplate(
            serializer.options.invisibleMultiply,
            result,
            term
          );
        }
      }
      prevWasNumber = false;
    }
    serializer.level += 1;
    return isNegative ? "-" + result : result;
  }
  function parseFraction(parser) {
    let numer = parser.parseGroup();
    let denom = null;
    if (numer === null) {
      numer = parser.parseToken();
      denom = parser.parseToken();
    } else {
      denom = parser.parseGroup();
    }
    numer = missingIfEmpty(numer);
    denom = missingIfEmpty(denom);
    if (operator(numer) === "PartialDerivative" && (operator(denom) === "PartialDerivative" || operator(denom) === "Multiply" && operator(operand(denom, 1)) === "PartialDerivative")) {
      const degree = operand(numer, 3) ?? null;
      let fn = operand(numer, 1);
      if (fn === null || fn === void 0)
        fn = missingIfEmpty(parser.parseExpression());
      let vars = [];
      if (operator(denom) === "Multiply") {
        for (const arg of operands(denom)) {
          if (operator(arg) === "PartialDerivative") {
            const v = operand(arg, 2);
            if (v) vars.push(v);
          }
        }
      } else {
        const v = operand(denom, 2);
        if (v) vars.push(v);
      }
      if (vars.length > 1) {
        vars = ["List", ...vars];
      }
      return ["PartialDerivative", fn, ...vars, degree === null ? 1 : degree];
    }
    return ["Divide", numer, denom];
  }
  function serializeFraction(serializer, expr) {
    if (expr === null) return "";
    const numer = missingIfEmpty(operand(expr, 1));
    const denom = missingIfEmpty(operand(expr, 2));
    const style = serializer.options.prettify ? serializer.fractionStyle(expr, serializer.level) : "quotient";
    if (style === "inline-solidus" || style === "nice-solidus") {
      const numerStr = serializer.wrapShort(numer);
      const denomStr = serializer.wrapShort(denom);
      if (style === "inline-solidus") return `${numerStr}/${denomStr}`;
      return `{}^{${numerStr}}\\!\\!/\\!{}_{${denomStr}}`;
    } else if (style === "reciprocal") {
      if (machineValue(numer) === 1) return serializer.wrap(denom) + "^{-1}";
      return serializer.wrap(numer) + serializer.wrap(denom) + "^{-1}";
    } else if (style === "factor") {
      if (machineValue(denom) === 1) return serializer.wrap(numer);
      return "\\frac{1}{" + serializer.serialize(denom) + "}" + serializer.wrapString(
        serializer.serialize(numer),
        serializer.groupStyle(expr, 1)
      );
    }
    let cmd = "\\frac";
    if (style === "block-quotient") cmd = "\\dfrac";
    else if (style === "inline-quotient") cmd = "\\tfrac";
    const numerLatex = serializer.serialize(numer);
    const denomLatex = serializer.serialize(denom);
    return `${cmd}{${numerLatex}}{${denomLatex}}`;
  }
  function serializePower(serializer, expr) {
    if (!expr) return "";
    const name = operator(expr);
    const base = missingIfEmpty(operand(expr, 1));
    if (name === "Sqrt") {
      return serializeRoot(
        serializer,
        serializer.rootStyle(expr, serializer.level - 1),
        base,
        2
      );
    }
    const exp2 = missingIfEmpty(operand(expr, 2));
    if (name === "Root")
      return serializeRoot(
        serializer,
        serializer.rootStyle(expr, serializer.level - 1),
        base,
        exp2
      );
    if (serializer.options.prettify) {
      const val2 = machineValue(exp2) ?? 1;
      if (val2 === -1) {
        return serializer.serialize(["Divide", "1", base]);
      } else if (val2 < 0) {
        return serializer.serialize(["Divide", "1", ["Power", base, -val2]]);
      } else if (operator(exp2) === "Divide" || operator(exp2) === "Rational") {
        if (machineValue(operand(exp2, 1)) === 1) {
          const style = serializer.rootStyle(expr, serializer.level);
          return serializeRoot(serializer, style, base, operand(exp2, 2));
        }
        if (machineValue(operand(exp2, 2)) === 2) {
          return `${serializer.serialize(["Sqrt", base])}^{${serializer.serialize(
            operand(exp2, 1)
          )}}`;
        }
      } else if (operator(exp2) === "Power") {
        if (machineValue(operand(exp2, 2)) === -1) {
          const style = serializer.rootStyle(expr, serializer.level);
          return serializeRoot(serializer, style, base, operand(exp2, 1));
        }
      }
    }
    if (operator(base) === "Power") {
      const baseBody = operand(base, 1);
      const baseExponent = operand(base, 2);
      return `
      ${serializer.wrapShort(baseBody)}^{${supsub("^", serializer.wrapShort(baseExponent), serializer.serialize(exp2))}}`;
    }
    return supsub("^", serializer.wrapShort(base), serializer.serialize(exp2));
  }
  var DEFINITIONS_ARITHMETIC = [
    // Constants
    { name: "CatalanConstant", identifierTrigger: "G" },
    { name: "GoldenRatio", latexTrigger: "\\varphi" },
    { name: "EulerGamma", latexTrigger: "\\gamma" },
    {
      name: "Degrees",
      latexTrigger: ["\\degree"],
      kind: "postfix",
      precedence: 880,
      parse: (_parser, lhs) => ["Degrees", lhs],
      serialize: (serializer, expr) => {
        return joinLatex([serializer.serialize(operand(expr, 1)), "\\degree"]);
      }
    },
    {
      latexTrigger: ["\\degree"],
      kind: "postfix",
      precedence: 880,
      parse: (_parser, lhs) => ["Degrees", lhs]
    },
    {
      latexTrigger: ["^", "<{>", "\\circ", "<}>"],
      kind: "postfix",
      parse: (_parser, lhs) => ["Degrees", lhs]
    },
    {
      latexTrigger: ["^", "\\circ"],
      kind: "postfix",
      parse: (_parser, lhs) => ["Degrees", lhs]
    },
    {
      latexTrigger: ["\xB0"],
      kind: "postfix",
      precedence: 880,
      parse: (_parser, lhs) => ["Degrees", lhs]
    },
    {
      latexTrigger: ["\\ang"],
      parse: (parser) => {
        const arg = parser.parseGroup();
        return arg === null ? ["Degrees"] : ["Degrees", arg];
      }
    },
    {
      latexTrigger: ["\\infty"],
      parse: "PositiveInfinity"
    },
    {
      name: "PositiveInfinity",
      serialize: (serializer) => serializer.options.positiveInfinity
    },
    {
      name: "NegativeInfinity",
      serialize: (serializer) => serializer.options.negativeInfinity
    },
    {
      name: "ComplexInfinity",
      latexTrigger: ["\\tilde", "\\infty"],
      serialize: "\\tilde\\infty"
    },
    {
      latexTrigger: ["\\tilde", "<{>", "\\infty", "<}>"],
      parse: "ComplexInfinity"
    },
    { name: "Pi", kind: "symbol", latexTrigger: ["\\pi"] },
    { latexTrigger: ["\u03C0"], parse: "Pi" },
    {
      name: "ExponentialE",
      latexTrigger: ["\\exponentialE"],
      parse: "ExponentialE",
      serialize: "\\exponentialE"
    },
    {
      latexTrigger: "\\operatorname{e}",
      parse: "ExponentialE"
    },
    {
      latexTrigger: "\\mathrm{e}",
      parse: "ExponentialE"
    },
    {
      kind: "function",
      identifierTrigger: "exp",
      parse: "Exp"
    },
    {
      latexTrigger: "\\exp",
      parse: "Exp"
    },
    {
      name: "ImaginaryUnit",
      latexTrigger: ["\\imaginaryI"]
    },
    {
      latexTrigger: "\\operatorname{i}",
      parse: "ImaginaryUnit"
    },
    {
      latexTrigger: "\\mathrm{i}",
      parse: "ImaginaryUnit"
    },
    // Operations
    {
      /** Could be the determinant if the argument is a matrix */
      /** @todo: domain check */
      /** If a literal matrix, the `serialize` should be custom, the parens are
       * replaced with bars */
      name: "Abs",
      kind: "matchfix",
      openTrigger: "|",
      closeTrigger: "|",
      parse: (_parser, body) => isEmptySequence(body) ? null : ["Abs", body]
    },
    {
      kind: "matchfix",
      openTrigger: ["\\vert"],
      closeTrigger: ["\\vert"],
      parse: (_parser, body) => isEmptySequence(body) ? null : ["Abs", body]
    },
    {
      identifierTrigger: "abs",
      kind: "function",
      parse: "Abs"
    },
    {
      name: "Add",
      latexTrigger: ["+"],
      kind: "infix",
      associativity: "any",
      precedence: ADDITION_PRECEDENCE,
      parse: (parser, lhs, until) => {
        const rhs = parser.parseExpression({
          ...until,
          minPrec: ADDITION_PRECEDENCE
        });
        if (rhs === null) return null;
        return foldAssociativeOperator("Add", lhs, rhs);
      },
      serialize: serializeAdd
    },
    {
      kind: "prefix",
      latexTrigger: ["+"],
      precedence: ADDITION_PRECEDENCE,
      parse: (parser, until) => {
        return parser.parseExpression({ ...until, minPrec: 400 });
      }
    },
    {
      name: "Ceil",
      kind: "matchfix",
      openTrigger: "\\lceil",
      closeTrigger: "\\rceil",
      parse: (_parser, body) => isEmptySequence(body) ? null : ["Ceil", body]
    },
    {
      kind: "matchfix",
      openTrigger: ["\u2308"],
      // ⌈ U+2308 LEFT CEILING
      closeTrigger: ["\u2309"],
      // ⌉ U+2309 RIGHT CEILING
      parse: (_parser, body) => isEmptySequence(body) ? null : ["Ceil", body]
    },
    {
      identifierTrigger: "ceil",
      kind: "function",
      parse: "Ceil"
    },
    { name: "Chop", identifierTrigger: "chop", kind: "function", parse: "Chop" },
    {
      name: "Complex",
      precedence: ADDITION_PRECEDENCE - 1,
      // One less than precedence of `Add`: used for correct wrapping
      serialize: (serializer, expr) => {
        const rePart = serializer.serialize(operand(expr, 1));
        const im = machineValue(operand(expr, 2));
        if (im === 0) return rePart;
        const imPart = im === 1 ? "\\imaginaryI" : im === -1 ? "-\\imaginaryI" : joinLatex([
          serializer.serialize(operand(expr, 2)),
          "\\imaginaryI"
        ]);
        const re = machineValue(operand(expr, 1));
        if (re === 0) return imPart;
        if (im !== null && im < 0) return joinLatex([rePart, imPart]);
        return joinLatex([rePart, "+", imPart]);
      }
    },
    {
      name: "Divide",
      latexTrigger: "\\frac",
      precedence: DIVISION_PRECEDENCE,
      // For \frac specifically, not for \div, etc..
      // handles Leibnitz notation for partial derivatives
      parse: parseFraction,
      serialize: serializeFraction
    },
    {
      kind: "infix",
      latexTrigger: "\\over",
      associativity: "none",
      // In LaTeX, the \over command is not associative
      precedence: DIVISION_PRECEDENCE,
      parse: "Divide"
    },
    {
      // The \/ command is recognized by MathLive, but not by KaTeX, so we
      // try to avoid generating it.
      latexTrigger: ["\\/"],
      kind: "infix",
      associativity: "left",
      precedence: DIVISION_PRECEDENCE,
      // ??? MathML has 265, but it's wrong.
      // It has to be at least higher than multiply
      // e.g. `1/2+3*x` -> `1/2 + 3*x` , not `1/(2+3*x)`
      parse: "Divide"
    },
    {
      latexTrigger: ["/"],
      kind: "infix",
      associativity: "left",
      precedence: DIVISION_PRECEDENCE,
      parse: "Divide"
    },
    {
      latexTrigger: ["\\div"],
      kind: "infix",
      associativity: "left",
      precedence: DIVISION_PRECEDENCE,
      // ??? according to MathML
      parse: "Divide"
    },
    {
      name: "Exp",
      serialize: (serializer, expr) => {
        const op1 = operand(expr, 1);
        if (symbol(op1) || machineValue(op1) !== null)
          return joinLatex(["\\exponentialE^{", serializer.serialize(op1), "}"]);
        return joinLatex(["\\exp", serializer.wrap(missingIfEmpty(op1))]);
      }
    },
    {
      name: "Factorial",
      latexTrigger: ["!"],
      kind: "postfix",
      precedence: POSTFIX_PRECEDENCE
    },
    {
      name: "Factorial2",
      latexTrigger: ["!", "!"],
      kind: "postfix",
      precedence: POSTFIX_PRECEDENCE
    },
    {
      name: "Floor",
      kind: "matchfix",
      openTrigger: "\\lfloor",
      closeTrigger: "\\rfloor",
      parse: (_parser, body) => isEmptySequence(body) ? null : ["Floor", body]
    },
    {
      kind: "matchfix",
      openTrigger: ["\u230A"],
      // ⌊ U+230A LEFT FLOOR
      closeTrigger: ["\u230B"],
      // ⌋ U+230B RIGHT FLOOR
      parse: (_parser, body) => isEmptySequence(body) ? null : ["Floor", body]
    },
    {
      identifierTrigger: "floor",
      kind: "function",
      parse: "Floor"
    },
    {
      latexTrigger: ["\\Gamma"],
      parse: "Gamma"
    },
    {
      name: "GCD",
      latexTrigger: ["\\gcd"]
      // command from amsmath package
    },
    {
      identifierTrigger: "gcd",
      kind: "function",
      parse: "GCD"
    },
    {
      identifierTrigger: "GCD",
      kind: "function",
      parse: "GCD"
    },
    {
      name: "Half",
      serialize: "\\frac12"
    },
    {
      name: "Lg",
      latexTrigger: ["\\lg"],
      serialize: (serializer, expr) => "\\log_{10}" + serializer.wrapArguments(expr),
      parse: (parser) => {
        const args = parser.parseArguments("implicit");
        if (args === null) return "Lg";
        return ["Log", ...args, 10];
      }
    },
    {
      name: "Lb",
      latexTrigger: "\\lb",
      parse: (parser) => {
        const args = parser.parseArguments("implicit");
        if (args === null) return "Log";
        return ["Log", args[0], 2];
      }
    },
    {
      name: "Ln",
      latexTrigger: ["\\ln"],
      parse: (parser) => parseLog("Ln", parser),
      serialize: (serializer, expr) => "\\ln" + serializer.wrapArguments(expr)
    },
    {
      name: "Log",
      latexTrigger: ["\\log"],
      parse: (parser) => parseLog("Log", parser),
      serialize: (serializer, expr) => {
        const [body, base] = operands(expr);
        if (!base) return "\\log" + serializer.wrapArguments(expr);
        return joinLatex([
          "\\log_{",
          serializer.serialize(base),
          "}",
          serializer.wrap(body)
        ]);
      }
    },
    {
      name: "LCM",
      identifierTrigger: "lcm",
      kind: "function"
    },
    {
      identifierTrigger: "LCM",
      kind: "function",
      parse: "LCM"
    },
    { identifierTrigger: "max", kind: "function", parse: "Max" },
    { identifierTrigger: "min", kind: "function", parse: "Min" },
    { name: "Max", latexTrigger: "\\max", kind: "function" },
    { name: "Min", latexTrigger: "\\min", kind: "function" },
    { name: "Supremum", latexTrigger: "\\sup", kind: "function" },
    { name: "Infimum", latexTrigger: "\\inf", kind: "function" },
    {
      name: "Limit",
      latexTrigger: "\\lim",
      kind: "expression",
      parse: (parser) => {
        if (!parser.match("_")) return null;
        const base = parser.parseGroup();
        if (operator(base) !== "To") return null;
        const expr = parser.parseArguments("implicit");
        if (!expr) return null;
        return [
          "Limit",
          ["Function", expr[0], operand(base, 1)],
          operand(base, 2)
        ];
      },
      serialize: (serializer, expr) => {
        const fn = operand(expr, 1);
        const fnVar = operand(fn, 2);
        const to = operand(expr, 2);
        return joinLatex([
          "\\lim_{",
          serializer.serialize(fnVar),
          "\\to",
          serializer.serialize(to),
          "}",
          serializer.serialize(operand(fn, 1))
        ]);
      }
    },
    {
      name: "MinusPlus",
      latexTrigger: ["\\mp"],
      kind: "infix",
      associativity: "any",
      precedence: ARROW_PRECEDENCE
    },
    {
      name: "Multiply",
      latexTrigger: ["\\times"],
      kind: "infix",
      associativity: "any",
      precedence: MULTIPLICATION_PRECEDENCE,
      serialize: serializeMultiply
    },
    {
      latexTrigger: ["\\cdot"],
      kind: "infix",
      associativity: "any",
      precedence: MULTIPLICATION_PRECEDENCE,
      parse: (parser, lhs, terminator) => {
        const rhs = parser.parseExpression({
          ...terminator,
          minPrec: MULTIPLICATION_PRECEDENCE + 2
        });
        if (rhs === null) return ["Multiply", lhs, MISSING];
        return foldAssociativeOperator("Multiply", lhs, rhs);
      }
    },
    {
      latexTrigger: ["*"],
      kind: "infix",
      associativity: "any",
      precedence: MULTIPLICATION_PRECEDENCE,
      parse: (parser, lhs, terminator) => {
        const rhs = parser.parseExpression({
          ...terminator,
          minPrec: MULTIPLICATION_PRECEDENCE + 2
        });
        if (rhs === null) return ["Multiply", lhs, MISSING];
        return foldAssociativeOperator("Multiply", lhs, rhs);
      }
    },
    // Infix modulo, as in `26 \bmod 5`
    {
      name: "Mod",
      latexTrigger: "\\bmod",
      kind: "infix",
      precedence: DIVISION_PRECEDENCE,
      serialize: (serializer, expr) => {
        if (nops(expr) !== 2) return "";
        const lhs = serializer.serialize(operand(expr, 1));
        const rhs = serializer.serialize(operand(expr, 2));
        return joinLatex([lhs, "\\bmod", rhs]);
      }
    },
    // Synonym to \\bmod
    {
      latexTrigger: "\\mod",
      kind: "infix",
      precedence: DIVISION_PRECEDENCE,
      parse: "Mod"
    },
    {
      latexTrigger: "\\pmod",
      kind: "prefix",
      precedence: COMPARISON_PRECEDENCE,
      parse: (parser) => {
        const rhs = parser.parseGroup() ?? parser.parseToken();
        return ["Mod", missingIfEmpty(rhs)];
      }
    },
    {
      name: "Congruent",
      serialize: (serializer, expr) => {
        const lhs = serializer.serialize(operand(expr, 1));
        const rhs = serializer.serialize(operand(expr, 2));
        if (operand(expr, 3) === null) return joinLatex([lhs, "\\equiv", rhs]);
        const modulus = serializer.serialize(operand(expr, 3));
        return joinLatex([lhs, "\\equiv", rhs, "\\pmod{", modulus, "}"]);
      }
    },
    {
      name: "Negate",
      latexTrigger: ["-"],
      kind: "prefix",
      precedence: EXPONENTIATION_PRECEDENCE + 1,
      parse: (parser, terminator) => {
        parser.skipSpace();
        const rhs = parser.parseExpression({
          ...terminator,
          minPrec: EXPONENTIATION_PRECEDENCE + 3
        });
        if (rhs === null) return null;
        return ["Negate", rhs];
      }
    },
    // {
    //   /** If the argument is a vector */
    //   /** @todo: domain check */
    //   name: 'Norm',
    //   kind: 'matchfix',
    //   openDelimiter: '|',
    //   closeDelimiter: '|',
    // },
    // {
    //   /** If the argument is a set */
    //   /** @todo: domain check */
    //   name: 'Cardinality',
    //   kind: 'matchfix',
    //   openDelimiter: '|',
    //   closeDelimiter: '|',
    // },
    {
      //   /** If the argument is a vector */
      /** @todo: domain check */
      kind: "matchfix",
      openTrigger: "||",
      closeTrigger: "||",
      parse: (_parser, expr) => isEmptySequence(expr) ? null : ["Norm", expr]
    },
    {
      //   /** If the argument is a vector */
      /** @todo: domain check */
      name: "Norm",
      kind: "matchfix",
      openTrigger: ["\\left", "\\Vert"],
      closeTrigger: ["\\right", "\\Vert"],
      parse: (_parser, expr) => isEmptySequence(expr) ? null : ["Norm", expr]
    },
    {
      name: "PlusMinus",
      latexTrigger: ["\\pm"],
      kind: "infix",
      associativity: "any",
      precedence: ARROW_PRECEDENCE,
      serialize: (serializer, expr) => {
        const op1 = operand(expr, 1);
        if (op1 === null) return "\\pm";
        if (nops(expr) === 1)
          return joinLatex(["\\pm", serializer.serialize(op1)]);
        const op2 = operand(expr, 2);
        return joinLatex([
          serializer.serialize(op1),
          "\\pm",
          serializer.serialize(op2)
        ]);
      }
    },
    {
      latexTrigger: ["\\pm"],
      kind: "prefix",
      precedence: ARROW_PRECEDENCE,
      parse: (parser, terminator) => {
        const rhs = parser.parseExpression({ ...terminator, minPrec: 400 });
        return ["PlusMinus", 0, missingIfEmpty(rhs)];
      }
    },
    {
      latexTrigger: ["\\plusmn"],
      kind: "infix",
      associativity: "any",
      precedence: ARROW_PRECEDENCE,
      parse: (parser, lhs, terminator) => {
        const rhs = parser.parseExpression({ ...terminator, minPrec: 400 });
        return ["PlusMinus", lhs, missingIfEmpty(rhs)];
      }
    },
    {
      latexTrigger: ["\\plusmn"],
      kind: "prefix",
      precedence: ARROW_PRECEDENCE,
      parse: (parser, terminator) => {
        const rhs = parser.parseExpression({ ...terminator, minPrec: 400 });
        return ["PlusMinus", missingIfEmpty(rhs)];
      }
    },
    {
      name: "Power",
      latexTrigger: ["^"],
      kind: "infix",
      serialize: serializePower
      // Parsing is done as a special case in `parseSupsub`
    },
    {
      latexTrigger: "\\prod",
      precedence: MULTIPLICATION_PRECEDENCE,
      name: "Product",
      parse: parseBigOp("Product", MULTIPLICATION_PRECEDENCE),
      serialize: serializeBigOp("\\prod")
    },
    // {
    //   trigger: ['*', '*'],
    //   kind: 'infix',
    //   associativity: 'none',
    //   precedence: 720,
    // },
    {
      name: "Rational",
      precedence: DIVISION_PRECEDENCE,
      serialize: (serializer, expr) => {
        if (expr && nops(expr) === 1)
          return "\\operatorname{Rational}" + serializer.wrapArguments(expr);
        return serializeFraction(serializer, expr);
      }
    },
    {
      name: "Root",
      serialize: serializePower
    },
    {
      name: "Round",
      identifierTrigger: "round",
      kind: "function"
    },
    {
      name: "Square",
      precedence: 720,
      serialize: (serializer, expr) => serializer.wrapShort(operand(expr, 1)) + "^2"
    },
    {
      latexTrigger: ["\\sum"],
      precedence: ADDITION_PRECEDENCE,
      name: "Sum",
      parse: parseBigOp("Sum", MULTIPLICATION_PRECEDENCE),
      serialize: serializeBigOp("\\sum")
    },
    {
      name: "Sign",
      // As per ISO 80000-2, "signum" is 'sgn'
      identifierTrigger: "sgn",
      kind: "function"
    },
    {
      name: "Sqrt",
      latexTrigger: ["\\sqrt"],
      parse: parseRoot,
      serialize: serializePower
    },
    {
      name: "Subtract",
      latexTrigger: ["-"],
      kind: "infix",
      associativity: "left",
      precedence: ADDITION_PRECEDENCE + 2,
      parse: (parser, lhs, terminator) => {
        parser.index -= 1;
        const rhs = parser.parseExpression({
          ...terminator,
          minPrec: ADDITION_PRECEDENCE + 3
        });
        if (rhs === null) return null;
        return ["Add", lhs, rhs];
      },
      serialize: (serializer, expr) => {
        const lhs = serializer.wrap(operand(expr, 1), ADDITION_PRECEDENCE + 2);
        const rhs = serializer.wrap(operand(expr, 2), ADDITION_PRECEDENCE + 3);
        return joinLatex([lhs, "-", rhs]);
      }
    }
  ];
  function getIndexAssignment(expr, upper) {
    if (expr === null) return void 0;
    if (symbol(expr)) return { index: symbol(expr) ?? "Nothing", upper };
    if (operator(expr) === "GreaterEqual") {
      const index = symbol(operand(expr, 1)) ?? "Nothing";
      const lower = operand(expr, 2) ?? 1;
      return { index, lower, upper };
    }
    if (operator(expr) === "Equal") {
      const index = symbol(operand(expr, 1)) ?? "Nothing";
      const rhs = operand(expr, 2);
      if (operator(rhs) === "Range") {
        const lower2 = operand(rhs, 1) ?? 1;
        const upper2 = operand(rhs, 2) ?? void 0;
        return { index, lower: lower2, upper: upper2 };
      }
      const lower = rhs ?? 1;
      return { index, lower, upper };
    }
    return void 0;
  }
  function getIndexes(sub2, sup) {
    if (isEmptySequence(sub2)) sub2 = null;
    if (isEmptySequence(sup)) sup = null;
    const subs2 = sub2 === null ? [] : getSequence(sub2) ?? [sub2];
    const sups = sup === null ? [] : getSequence(sup) ?? [sup];
    return subs2.map((subExpr, i) => getIndexAssignment(subExpr, sups[i])).filter((x) => x !== void 0);
  }
  function parseBigOp(name, minPrec) {
    return (parser) => {
      parser.skipSpace();
      let sup = null;
      let sub2 = null;
      while (!(sub2 && sup) && (parser.peek === "_" || parser.peek === "^")) {
        if (parser.match("_")) sub2 = parser.parseGroup() ?? parser.parseToken();
        else if (parser.match("^"))
          sup = parser.parseGroup() ?? parser.parseToken();
        parser.skipSpace();
      }
      const indexes2 = getIndexes(sub2, sup);
      parser.pushSymbolTable();
      for (const indexinSet of indexes2)
        parser.addSymbol(indexinSet.index, "symbol");
      const fn = parser.parseExpression({ minPrec });
      parser.popSymbolTable();
      if (fn === null) return [name];
      const indexingSetArguments = [];
      for (const indexinSet of indexes2) {
        const lower = indexinSet.lower;
        const upper = indexinSet.upper;
        const index = indexinSet.index ?? "Nothing";
        if (upper !== null && upper !== void 0)
          indexingSetArguments.push(["Tuple", index, lower ?? 1, upper]);
        else if (lower !== null && lower !== void 0)
          indexingSetArguments.push(["Tuple", index, lower]);
        else indexingSetArguments.push(["Tuple", index]);
      }
      return [name, fn, ...indexingSetArguments];
    };
  }
  function serializeBigOp(command) {
    return (serializer, expr) => {
      if (!operand(expr, 1)) return command;
      let arg = operand(expr, 2);
      const h = operator(arg);
      if (h !== "Tuple" && h !== "Triple" && h !== "Pair" && h !== "Single")
        arg = null;
      let index = operand(arg, 1);
      if (index !== null && operator(index) === "Hold") index = operand(index, 1);
      const fn = operand(expr, 1);
      if (arg !== null && arg !== void 0) {
        if (operand(expr, 2) !== null)
          return joinLatex([command, serializer.serialize(fn)]);
        return joinLatex([
          command,
          "_{",
          serializer.serialize(operand(expr, 2)),
          "}",
          serializer.serialize(fn)
        ]);
      }
      const lower = operand(arg, 2);
      let sub2 = [];
      if (index && symbol(index) !== "Nothing" && lower)
        sub2 = [serializer.serialize(index), "=", serializer.serialize(lower)];
      else if (index && symbol(index) !== "Nothing")
        sub2 = [serializer.serialize(index)];
      else if (lower !== null) sub2 = [serializer.serialize(lower)];
      if (sub2.length > 0) sub2 = ["_{", ...sub2, "}"];
      let sup = [];
      if (operand(arg, 3) !== null)
        sup = ["^{", serializer.serialize(operand(arg, 3)), "}"];
      return joinLatex([command, ...sup, ...sub2, serializer.serialize(fn)]);
    };
  }
  function parseLog(command, parser) {
    let sub2 = null;
    if (parser.match("_")) sub2 = parser.parseGroup() ?? parser.parseToken();
    const args = parser.parseArguments("implicit");
    if (args === null && sub2 === null) return [command];
    if (args === null) return [command, sub2];
    if (sub2 === null) return [command, ...args];
    if (sub2 === 10) return ["Log", args[0]];
    if (sub2 === 2) return ["Lb", ...args];
    return ["Log", args[0], sub2];
  }
  function unsign(expr) {
    let sign2 = 1;
    let newExpr = expr;
    do {
      expr = newExpr;
      const fnName = operator(expr);
      if (fnName === "Negate") {
        sign2 *= -1;
        newExpr = operand(expr, 1);
      } else if (fnName === "Multiply") {
        const [first, firstSign] = unsign(operand(expr, 1));
        if (firstSign < 0) {
          sign2 *= -1;
          if (first === 1) newExpr = ["Multiply", ...operands(expr).slice(1)];
          else newExpr = ["Multiply", first, ...operands(expr).slice(1)];
        }
      } else if (fnName === "Divide" || fnName === "Rational") {
        const [numer, numerSign] = unsign(operand(expr, 1));
        if (numerSign < 0) {
          sign2 *= -1;
          newExpr = [fnName, numer, operand(expr, 2)];
        }
      } else {
        const val = machineValue(expr);
        if (val !== null && val < 0) {
          sign2 *= -1;
          newExpr = -val;
        }
      }
    } while (newExpr !== expr);
    return [expr, sign2];
  }

  // src/compute-engine/latex-syntax/dictionary/definitions-core.ts
  function parseSequence(parser, terminator, lhs, prec, sep) {
    if (terminator && terminator.minPrec >= prec) return null;
    const result = lhs ? [lhs] : ["Nothing"];
    let done = false;
    while (!done) {
      done = true;
      parser.skipSpace();
      while (parser.match(sep)) {
        result.push("Nothing");
        parser.skipSpace();
      }
      if (parser.atTerminator(terminator)) {
        result.push("Nothing");
      } else {
        const rhs = parser.parseExpression({ ...terminator, minPrec: prec });
        result.push(rhs ?? "Nothing");
        done = rhs === null;
      }
      if (!done) {
        parser.skipSpace();
        done = !parser.match(sep);
      }
    }
    return result;
  }
  function serializeOps(sep = "") {
    return (serializer, expr) => {
      if (!expr) return "";
      const xs = operands(expr);
      if (xs.length === 0) return "";
      if (xs.length === 1) return serializer.serialize(xs[0]);
      sep = {
        "&": "\\&",
        ":": "\\colon",
        "|": "\\mvert",
        "-": "-",
        "\xB7": "\\cdot",
        // U+00B7 MIDDLE DOT
        "\u2012": "-",
        // U+2012 FIGURE DASH
        "\u2013": "--",
        // U+2013 EN DASH
        "\u2014": "---",
        // U+2014 EM DASH
        "\u2015": "-",
        // U+2015 HORIZONTAL BAR
        "\u2022": "\\bullet",
        // U+2022 BULLET
        "\u2026": "\\ldots"
      }[sep] ?? sep;
      const ys = xs.reduce((acc, item) => {
        acc.push(serializer.serialize(item), sep);
        return acc;
      }, []);
      ys.pop();
      return joinLatex(ys);
    };
  }
  var DEFINITIONS_CORE = [
    //
    // Constants
    //
    {
      latexTrigger: ["\\placeholder"],
      kind: "symbol",
      parse: (parser) => {
        while (parser.match("<space>")) {
        }
        if (parser.match("["))
          while (!parser.match("]") && !parser.atBoundary) parser.nextToken();
        while (parser.match("<space>")) {
        }
        if (parser.match("<{>"))
          while (!parser.match("<}>") && !parser.atBoundary) parser.nextToken();
        return "Nothing";
      }
    },
    //
    // Functions
    //
    // Anonymous function, i.e. `(x) \mapsto x^2`
    {
      name: "Function",
      latexTrigger: ["\\mapsto"],
      kind: "infix",
      precedence: ARROW_PRECEDENCE,
      // MathML rightwards arrow
      parse: (parser, lhs) => {
        let params = [];
        if (operator(lhs) === "Delimiter") lhs = operand(lhs, 1) ?? "Nothing";
        if (operator(lhs) === "Sequence") {
          for (const x of operands(lhs)) {
            if (!symbol(x)) return null;
            params.push(symbol(x));
          }
        } else {
          if (!symbol(lhs)) return null;
          params = [symbol(lhs)];
        }
        let rhs = parser.parseExpression({ minPrec: ARROW_PRECEDENCE }) ?? "Nothing";
        if (operator(rhs) === "Delimiter") rhs = operand(rhs, 1) ?? "Nothing";
        if (operator(rhs) === "Sequence") rhs = ["Block", ...operands(rhs)];
        return ["Function", rhs, ...params];
      },
      serialize: (serializer, expr) => {
        const args = operands(expr);
        if (args.length < 1) return "()\\mapsto()";
        if (args.length === 1)
          return joinLatex([
            "()",
            "\\mapsto",
            serializer.serialize(operand(expr, 1))
          ]);
        if (args.length === 2) {
          return joinLatex([
            serializer.serialize(operand(expr, 2)),
            "\\mapsto",
            serializer.serialize(operand(expr, 1))
          ]);
        }
        return joinLatex([
          serializer.wrapString(
            operands(expr)?.slice(1).map((x) => serializer.serialize(x)).join(", "),
            "normal"
          ),
          "\\mapsto",
          serializer.serialize(operand(expr, 1))
        ]);
      }
    },
    {
      name: "Apply",
      kind: "function",
      identifierTrigger: "apply",
      serialize: (serializer, expr) => {
        const lhs = operand(expr, 1);
        const h = operator(lhs);
        if (h === "InverseFunction" || h === "Derivative") {
          const style2 = serializer.options.applyFunctionStyle(
            expr,
            serializer.level
          );
          const args = operands(expr).slice(1);
          return serializer.serializeFunction(
            lhs,
            serializer.dictionary.ids.get(h)
          ) + serializer.wrapString(
            args.map((x) => serializer.serialize(x)).join(", "),
            style2
          );
        }
        const rhs = operand(expr, 2);
        if (typeof lhs === "string" || !rhs) {
          const fn = operands(expr).slice(1);
          return serializer.serialize(fn);
        }
        if (nops(expr) === 2) {
          return joinLatex([
            serializer.wrap(lhs, 20),
            "\\lhd",
            serializer.wrap(rhs, 20)
          ]);
        }
        const style = serializer.options.applyFunctionStyle(
          expr,
          serializer.level
        );
        return joinLatex([
          "\\operatorname{apply}",
          serializer.wrapString(
            serializer.serialize(h) + ", " + serializer.serialize(["List", ...operands(expr)]),
            style
          )
        ]);
      }
    },
    {
      latexTrigger: "\\lhd",
      kind: "infix",
      precedence: 20,
      parse: "Apply"
    },
    {
      latexTrigger: "\\rhd",
      kind: "infix",
      precedence: 20,
      parse: (parser, lhs) => {
        const rhs = parser.parseExpression({ minPrec: 21 }) ?? "Nothing";
        return ["Apply", rhs, lhs];
      }
    },
    // The mathtools package includes several synonmyms for \colonequals. The
    // preferred one as of summer 2022 is `\coloneq` (see § 3.7.3 https://ctan.math.illinois.edu/macros/latex/contrib/mathtools/mathtools.pdf)
    {
      name: "Assign",
      latexTrigger: "\\coloneq",
      kind: "infix",
      associativity: "right",
      precedence: ASSIGNMENT_PRECEDENCE,
      serialize: (serializer, expr) => {
        const id = unhold(operand(expr, 1));
        if (operator(operand(expr, 2)) === "Function") {
          const op_2 = operand(expr, 2);
          const body = unhold(operand(op_2, 1));
          const args = operands(op_2).slice(1);
          return joinLatex([
            serializer.serialize(id),
            serializer.wrapString(
              args.map((x) => serializer.serialize(x)).join(", "),
              serializer.options.applyFunctionStyle(expr, serializer.level)
            ),
            "\\coloneq",
            serializer.serialize(body)
          ]);
        }
        return joinLatex([
          serializer.serialize(id),
          "\\coloneq",
          serializer.serialize(operand(expr, 2))
        ]);
      },
      parse: parseAssign
    },
    {
      latexTrigger: "\\coloneqq",
      kind: "infix",
      associativity: "right",
      precedence: ASSIGNMENT_PRECEDENCE,
      parse: parseAssign
    },
    // From the colonequals package:
    {
      latexTrigger: "\\colonequals",
      kind: "infix",
      associativity: "right",
      precedence: ASSIGNMENT_PRECEDENCE,
      parse: parseAssign
    },
    {
      latexTrigger: [":", "="],
      kind: "infix",
      associativity: "right",
      precedence: ASSIGNMENT_PRECEDENCE,
      parse: parseAssign
    },
    {
      name: "BaseForm",
      serialize: (serializer, expr) => {
        const radix = machineValue(operand(expr, 2)) ?? NaN;
        if (isFinite(radix) && radix >= 2 && radix <= 36) {
          const num = machineValue(operand(expr, 1)) ?? NaN;
          if (isFinite(num) && Number.isInteger(num)) {
            let digits = Number(num).toString(radix);
            let groupLength = 0;
            if (radix === 2) {
              groupLength = 4;
            } else if (radix === 10) {
              groupLength = 4;
            } else if (radix === 16) {
              groupLength = 2;
            } else if (radix > 16) {
              groupLength = 4;
            }
            if (groupLength > 0) {
              const oldDigits = digits;
              digits = "";
              for (let i = 0; i < oldDigits.length; i++) {
                if (i > 0 && i % groupLength === 0) digits = "\\, " + digits;
                digits = oldDigits[oldDigits.length - i - 1] + digits;
              }
            }
            return `(\\text{${digits}}_{${radix}}`;
          }
        }
        return "\\operatorname{BaseForm}(" + serializer.serialize(operand(expr, 1)) + ", " + serializer.serialize(operand(expr, 2)) + ")";
      }
    },
    {
      name: "Sequence",
      // Use a space as a separator, otherwise a sequence of numbers
      // could be interpreted as a single number.
      serialize: serializeOps(" ")
    },
    {
      name: "InvisibleOperator",
      serialize: serializeOps("")
    },
    {
      // The first argument is a function expression.
      // The second (optional) argument is a string specifying the
      // delimiters and separator.
      name: "Delimiter",
      serialize: (serializer, expr) => {
        const style = serializer.options.groupStyle(expr, serializer.level + 1);
        const arg1 = operand(expr, 1);
        let delims = {
          Set: "{,}",
          List: "[,]",
          Tuple: "(,)",
          Single: "(,)",
          Pair: "(,)",
          Triple: "(,)",
          Sequence: "(,)",
          String: '""'
        }[operator(arg1)];
        const items = delims ? arg1 : ["Sequence", arg1];
        delims ?? (delims = "(,)");
        if (nops(expr) > 1) {
          const op2 = stringValue(operand(expr, 2));
          if (typeof op2 === "string" && op2.length <= 3) delims = op2;
        }
        let [open, sep, close] = ["", "", ""];
        if (delims.length === 3) [open, sep, close] = delims;
        else if (delims.length === 2) [open, close] = delims;
        else if (delims.length === 1) sep = delims;
        const body = arg1 ? items ? serializeOps(sep)(serializer, items) : serializer.serialize(arg1) : "";
        return serializer.wrapString(body, style, open + close);
      }
    },
    {
      name: "Tuple",
      serialize: (serializer, expr) => joinLatex(["(", serializeOps(",")(serializer, expr), ")"])
    },
    {
      name: "Pair",
      serialize: (serializer, expr) => joinLatex(["(", serializeOps(",")(serializer, expr), ")"])
    },
    {
      name: "Triple",
      serialize: (serializer, expr) => joinLatex(["(", serializeOps(",")(serializer, expr), ")"])
    },
    {
      name: "Single",
      serialize: (serializer, expr) => joinLatex(["(", serializeOps(",")(serializer, expr), ")"])
    },
    {
      name: "Domain",
      serialize: (serializer, expr) => {
        if (operator(expr) === "Error") return serializer.serialize(expr);
        return `\\mathbf{${serializer.serialize(operand(expr, 1))}}`;
      }
    },
    {
      latexTrigger: ["\\mathtip"],
      parse: (parser) => {
        const op1 = parser.parseGroup();
        parser.parseGroup();
        return op1;
      }
    },
    {
      latexTrigger: ["\\texttip"],
      parse: (parser) => {
        const op1 = parser.parseGroup();
        parser.parseGroup();
        return op1;
      }
    },
    {
      latexTrigger: ["\\error"],
      parse: (parser) => ["Error", parser.parseGroup()]
    },
    {
      name: "Error",
      serialize: (serializer, expr) => {
        const op1 = operand(expr, 1);
        if (stringValue(op1) === "missing")
          return `\\error{${serializer.options.missingSymbol ?? "\\placeholder{}"}}`;
        const where = errorContextAsLatex(serializer, expr) || "\\blacksquare";
        const code = operator(op1) === "ErrorCode" ? stringValue(operand(op1, 1)) : stringValue(op1);
        if (code === "incompatible-type") {
          if (symbol(operand(op1, 3)) === "Undefined") {
            return `\\mathtip{\\error{${where}}}{\\notin ${serializer.serialize(
              operand(op1, 2)
            )}}`;
          }
          return `\\mathtip{\\error{${where}}}{\\in ${serializer.serialize(
            operand(op1, 3)
          )}\\notin ${serializer.serialize(operand(op1, 2))}}`;
        }
        if (typeof code === "string") return `\\error{${where}}`;
        return `\\error{${where}}`;
      }
    },
    {
      name: "ErrorCode",
      serialize: (serializer, expr) => {
        const code = stringValue(operand(expr, 1));
        if (code === "missing")
          return serializer.options.missingSymbol ?? "\\placeholder{}";
        if (code === "unexpected-command" || code === "unexpected-operator" || code === "unexpected-token" || code === "invalid-identifier" || code === "unknown-environment" || code === "unexpected-base" || code === "incompatible-type") {
          return "";
        }
        return `\\texttip{\\error{\\blacksquare}}{\\mathtt{${code}}}`;
      }
    },
    {
      name: "FromLatex",
      serialize: (_serializer, expr) => {
        return `\\texttt{${sanitizeLatex(stringValue(operand(expr, 1)))}}`;
      }
    },
    {
      name: "Latex",
      serialize: (serializer, expr) => {
        if (expr === null) return "";
        return joinLatex(
          mapArgs(expr, (x) => stringValue(x) ?? serializer.serialize(x))
        );
      }
    },
    {
      name: "LatexString",
      serialize: (serializer, expr) => {
        if (expr === null) return "";
        return joinLatex(mapArgs(expr, (x) => serializer.serialize(x)));
      }
    },
    { name: "LatexTokens", serialize: serializeLatexTokens },
    {
      name: "At",
      kind: "postfix",
      precedence: 810,
      latexTrigger: ["["],
      parse: parseAt("]"),
      serialize: (serializer, expr) => joinLatex(["\\lbrack", serializeOps(", ")(serializer, expr), "\\rbrack"])
    },
    {
      kind: "postfix",
      precedence: 810,
      latexTrigger: ["\\lbrack"],
      parse: parseAt("\\rbrack")
    },
    {
      kind: "postfix",
      precedence: 810,
      latexTrigger: ["\\left", "\\lbrack"],
      parse: parseAt("\\right", "\\rbrack")
    },
    {
      kind: "postfix",
      latexTrigger: ["_"],
      parse: (parser, lhs, until) => {
        const rhs = parser.parseGroup() ?? parser.parseToken();
        return ["Subscript", lhs, rhs];
      }
    },
    {
      name: "List",
      kind: "matchfix",
      openTrigger: "[",
      closeTrigger: "]",
      parse: parseBrackets,
      serialize: serializeList
    },
    {
      kind: "matchfix",
      openTrigger: "(",
      closeTrigger: ")",
      parse: parseParenDelimiter
    },
    {
      latexTrigger: [","],
      kind: "infix",
      precedence: 20,
      // Unlike the matchfix version of List,
      // when the comma operator is used, the lhs and rhs are flattened,
      // i.e. `1,2,3` -> `["Delimiter", ["List", 1, 2, 3],  ","]`,
      // and `1, (2, 3)` -> `["Delimiter",
      // ["Sequence", 1, ["Delimiter", ["List", 2, 3],  "()", ","]]],
      parse: (parser, lhs, terminator) => {
        const seq = parseSequence(parser, terminator, lhs, 20, ",");
        if (seq === null) return null;
        return ["Delimiter", ["Sequence", ...seq], { str: "," }];
      }
    },
    // Entry to handle the case of a single comma
    // with a missing lhs.
    {
      latexTrigger: [","],
      kind: "prefix",
      precedence: 20,
      parse: (parser, terminator) => {
        const seq = parseSequence(parser, terminator, null, 20, ",");
        if (seq === null) return null;
        return ["Delimiter", ["Sequence", ...seq], { str: "," }];
      }
    },
    {
      name: "Range",
      latexTrigger: [".", "."],
      kind: "infix",
      precedence: 800,
      parse: parseRange,
      serialize: (serializer, expr) => {
        const args = operands(expr);
        if (args.length === 0) return "";
        if (args.length === 1)
          return "1.." + serializer.serialize(operand(expr, 1));
        if (args.length === 2)
          return serializer.wrap(operand(expr, 1), 10) + ".." + serializer.wrap(operand(expr, 2), 10);
        if (args.length === 3) {
          const step = machineValue(operand(expr, 3));
          const start = machineValue(operand(expr, 1));
          if (step !== null && start !== null) {
            return serializer.wrap(operand(expr, 1), 10) + ".." + serializer.wrap(start + step, 10) + ".." + serializer.wrap(operand(expr, 2), 10);
          }
          return serializer.wrap(operand(expr, 1), 10) + "..(" + (serializer.wrap(operand(expr, 1), ADDITION_PRECEDENCE) + "+" + serializer.wrap(operand(expr, 3), ADDITION_PRECEDENCE)) + ").." + serializer.wrap(operand(expr, 2), 10);
        }
        return "";
      }
    },
    {
      latexTrigger: [";"],
      kind: "infix",
      precedence: 19,
      parse: (parser, lhs, terminator) => {
        const seq = parseSequence(parser, terminator, lhs, 19, ";");
        if (seq === null) return null;
        return ["Delimiter", ["Sequence", ...seq], "';'"];
      }
    },
    {
      name: "String",
      latexTrigger: ["\\text"],
      parse: (scanner) => parseTextRun(scanner),
      serialize: (serializer, expr) => {
        const args = operands(expr);
        if (args.length === 0) return "\\text{}";
        return joinLatex([
          "\\text{",
          args.map((x) => serializer.serialize(x)).join(""),
          "}"
        ]);
      }
    },
    {
      name: "Subscript",
      latexTrigger: ["_"],
      kind: "infix",
      serialize: (serializer, expr) => {
        if (nops(expr) === 2) {
          return serializer.serialize(operand(expr, 1)) + "_{" + serializer.serialize(operand(expr, 2)) + "}";
        }
        return "_{" + serializer.serialize(operand(expr, 1)) + "}";
      }
    },
    { name: "Superplus", latexTrigger: ["^", "+"], kind: "postfix" },
    { name: "Subplus", latexTrigger: ["_", "+"], kind: "postfix" },
    { name: "Superminus", latexTrigger: ["^", "-"], kind: "postfix" },
    { name: "Subminus", latexTrigger: ["_", "-"], kind: "postfix" },
    {
      latexTrigger: ["^", "*"],
      kind: "postfix",
      parse: (_parser, lhs) => ["Superstar", lhs]
    },
    // { name: 'Superstar', latexTrigger: ['^', '\\star'], kind: 'postfix' },
    {
      latexTrigger: ["_", "*"],
      kind: "postfix",
      parse: (_parser, lhs) => ["Substar", lhs]
    },
    { name: "Substar", latexTrigger: ["_", "\\star"], kind: "postfix" },
    { name: "Superdagger", latexTrigger: ["^", "\\dagger"], kind: "postfix" },
    {
      latexTrigger: ["^", "\\dag"],
      kind: "postfix",
      parse: (_parser, lhs) => ["Superdagger", lhs]
    },
    {
      name: "Prime",
      latexTrigger: ["^", "\\prime"],
      // Note: we don't need a precedence because the trigger is '^'
      // and '^' (and '_') are treated specially by the parser.
      kind: "postfix",
      parse: (parser, lhs) => parsePrime(parser, lhs, 1),
      serialize: (serializer, expr) => {
        const n2 = machineValue(operand(expr, 2)) ?? 1;
        const base = serializer.serialize(operand(expr, 1));
        if (n2 === 1) return base + "^\\prime";
        if (n2 === 2) return base + "^\\doubleprime";
        if (n2 === 3) return base + "^\\tripleprime";
        return base + "^{(" + serializer.serialize(operand(expr, 2)) + ")}";
      }
    },
    {
      latexTrigger: "^{\\prime\\prime}",
      kind: "postfix",
      parse: (parser, lhs) => parsePrime(parser, lhs, 2)
    },
    {
      latexTrigger: "^{\\prime\\prime\\prime}",
      kind: "postfix",
      parse: (parser, lhs) => parsePrime(parser, lhs, 3)
    },
    {
      latexTrigger: ["^", "\\doubleprime"],
      kind: "postfix",
      parse: (parser, lhs) => parsePrime(parser, lhs, 2)
    },
    {
      latexTrigger: ["^", "\\tripleprime"],
      kind: "postfix",
      parse: (parser, lhs) => parsePrime(parser, lhs, 3)
    },
    {
      latexTrigger: "'",
      kind: "postfix",
      precedence: 810,
      parse: (parser, lhs) => parsePrime(parser, lhs, 1)
    },
    {
      latexTrigger: "\\prime",
      kind: "postfix",
      precedence: 810,
      parse: (parser, lhs) => parsePrime(parser, lhs, 1)
    },
    {
      latexTrigger: "\\doubleprime",
      kind: "postfix",
      precedence: 810,
      parse: (parser, lhs) => parsePrime(parser, lhs, 2)
    },
    {
      latexTrigger: "\\tripleprime",
      kind: "postfix",
      precedence: 810,
      parse: (parser, lhs) => parsePrime(parser, lhs, 3)
    },
    // Lagrange Notation for n-th order derivatives,
    // i.e. f^{(n)} -> Derivative(f, n)
    {
      latexTrigger: ["^", "<{>", "("],
      kind: "postfix",
      parse: (parser, lhs, until) => {
        const sym = symbol(lhs);
        if (!sym || parser.getIdentifierType(sym) !== "function") return null;
        parser.addBoundary([")"]);
        const expr = parser.parseExpression(until);
        if (!parser.matchBoundary()) return null;
        if (!parser.match("<}>")) return null;
        return ["Derivative", lhs, expr];
      }
    },
    {
      name: "InverseFunction",
      latexTrigger: "^{-1",
      // Note: the closing brace is not included
      kind: "postfix",
      parse: (parser, lhs) => {
        const sym = symbol(lhs);
        if (!sym || parser.getIdentifierType(sym) !== "function") return null;
        let primeCount = 0;
        while (!parser.atEnd && !parser.match("<}>")) {
          if (parser.match("'")) primeCount++;
          else if (parser.match("\\prime")) primeCount++;
          else if (parser.match("\\doubleprime")) primeCount += 2;
          else if (parser.match("\\tripleprime")) primeCount += 3;
          else return null;
        }
        if (primeCount === 1) return ["Derivative", ["InverseFunction", lhs]];
        if (primeCount > 0)
          return ["Derivative", ["InverseFunction", lhs], primeCount];
        return ["InverseFunction", lhs];
      },
      serialize: (serializer, expr) => serializer.serialize(operand(expr, 1)) + "^{-1}"
    },
    // Lagrange notation
    {
      name: "Derivative",
      // @todo: Leibniz notation: {% latex " \\frac{d^n}{dx^n} f(x)" %}
      // @todo: Euler modified notation: This notation is used by Mathematica. The Euler notation uses `D` instead of
      // `\partial`: `\partial_{x} f`,  `\partial_{x,y} f`
      // @todo: Newton notation: `\dot{v}` -> first derivative relative to time t `\ddot{v}` -> second derivative relative to time t
      serialize: (serializer, expr) => {
        const degree = machineValue(operand(expr, 2)) ?? 1;
        const base = serializer.serialize(operand(expr, 1));
        if (degree === 1) return base + "^{\\prime}";
        if (degree === 2) return base + "^{\\doubleprime}";
        if (degree === 3) return base + "^{\\tripleprime}";
        return base + "^{(" + serializer.serialize(operand(expr, 2)) + ")}";
      }
    },
    {
      kind: "environment",
      name: "Which",
      identifierTrigger: "cases",
      parse: parseCasesEnvironment,
      serialize: (serialize, expr) => {
        const rows = [];
        const args = operands(expr);
        if (args.length > 0) {
          for (let i = 0; i <= args.length - 2; i += 2) {
            const row = [];
            row.push(serialize.serialize(args[i + 1]));
            row.push(serialize.serialize(args[i]));
            rows.push(row.join("&"));
          }
        }
        return joinLatex(["\\begin{cases}", rows.join("\\\\"), "\\end{cases}"]);
      }
    },
    {
      kind: "environment",
      identifierTrigger: "dcases",
      parse: parseCasesEnvironment
    },
    {
      kind: "environment",
      identifierTrigger: "rcases",
      parse: parseCasesEnvironment
    }
  ];
  function parseTextRun(parser, style) {
    if (!parser.match("<{>")) return "''";
    const runs = [];
    let text = "";
    let runinStyle = null;
    while (!parser.atEnd && !parser.match("<}>")) {
      if (parser.peek === "<{>") {
        runs.push(parseTextRun(parser));
      } else if (parser.match("\\textbf") && parser.match("<{>")) {
        runs.push(parseTextRun(parser, { "font-weight": "bold" }));
      } else if (parser.match("\\color")) {
        const color = parser.parseStringGroup();
        if (color !== null) {
          if (runinStyle !== null && text) {
            runs.push(["Style", text, dictionaryFromEntries(runinStyle)]);
          } else if (text) {
            runs.push(["String", text]);
          }
          text = "";
          runinStyle = { color };
        }
      } else if (parser.match("<space>")) {
        text += " ";
      } else if (parser.match("<$>")) {
        const index = parser.index;
        const expr = parser.parseExpression() ?? "Nothing";
        parser.skipSpace();
        if (parser.match("<$>")) {
          runs.push(expr);
        } else {
          text += "$";
          parser.index = index;
        }
      } else if (parser.match("<$$>")) {
        const index = parser.index;
        const expr = parser.parseExpression() ?? "Nothing";
        parser.skipSpace();
        if (parser.match("<$$>")) {
          runs.push(expr);
        } else {
          text += "$$";
          parser.index = index;
        }
      } else {
        const c = parser.matchChar() ?? parser.nextToken();
        text += {
          "\\enskip": "\u2002",
          //  en space
          "\\enspace": "\u2002",
          //  en space
          "\\quad": "\u2003",
          //  em space
          "\\qquad": "\u2003\u2003",
          //  2 em space
          "\\space": "\u2003",
          //  em space
          "\\ ": "\u2003",
          //  em space
          "\\;": "\u2004",
          //  three per em space
          "\\,": "\u2009",
          //  thin space
          "\\:": "\u205F",
          //  medium mathematical space
          "\\!": "",
          //  negative thin space
          "\\{": "{",
          "\\}": "}",
          "\\$": "$",
          "\\&": "&",
          "\\#": "#",
          "\\%": "%",
          "\\_": "_",
          "\\textbackslash": "\\",
          "\\textasciitilde": "~",
          "\\textasciicircum": "^",
          "\\textless": "<",
          "\\textgreater": ">",
          "\\textbar": "|",
          "\\textunderscore": "_",
          "\\textbraceleft": "{",
          "\\textbraceright": "}",
          "\\textasciigrave": "`",
          "\\textquotesingle": "'",
          "\\textquotedblleft": "\u201C",
          "\\textquotedblright": "\u201D",
          "\\textquotedbl": '"',
          "\\textquoteleft": "\u2018",
          "\\textquoteright": "\u2019",
          "\\textbullet": "\u2022",
          "\\textdagger": "\u2020",
          "\\textdaggerdbl": "\u2021",
          "\\textsection": "\xA7",
          "\\textparagraph": "\xB6",
          "\\textperiodcentered": "\xB7",
          "\\textellipsis": "\u2026",
          "\\textemdash": "\u2014",
          "\\textendash": "\u2013",
          "\\textregistered": "\xAE",
          "\\texttrademark": "\u2122",
          "\\textdegree": "\xB0"
        }[c] ?? c;
      }
    }
    if (runinStyle !== null && text) {
      runs.push(["Style", `'${text}'`, dictionaryFromEntries(runinStyle)]);
    } else if (text) {
      runs.push(`'${text}'`);
    }
    let body;
    if (runs.length === 1) body = runs[0];
    else {
      if (runs.every((x) => stringValue(x) !== null))
        body = "'" + runs.map((x) => stringValue(x)).join() + "'";
      else body = ["String", ...runs];
    }
    return style ? ["Style", body, dictionaryFromEntries(style)] : body;
  }
  function serializeLatexTokens(serializer, expr) {
    if (expr === null) return "";
    return joinLatex(
      mapArgs(expr, (x) => {
        const s = stringValue(x);
        if (s === null) return serializer.serialize(x);
        if (s === "<{>") return "{";
        if (s === "<}>") return "}";
        if (s === "<$>") return "$";
        if (s === "<$$>") return "$$";
        if (s === "<space>") return " ";
        return s;
      })
    );
  }
  function sanitizeLatex(s) {
    if (s === null) return "";
    return s.replace(
      /[{}\[\]\\:\-\$%]/g,
      (c) => ({
        "{": "\\lbrace ",
        "}": "\\rbrace ",
        "[": "\\lbrack ",
        "]": "\\rbrack ",
        ":": "\\colon ",
        "\\": "\\backslash "
      })[c] ?? "\\" + c
    );
  }
  function errorContextAsLatex(serializer, error) {
    const arg = operand(error, 2);
    if (!arg) return "";
    if (operator(arg) === "LatexString")
      return stringValue(operand(arg, 1)) ?? "";
    if (operator(arg) === "Hold") return serializer.serialize(operand(arg, 1));
    return serializer.serialize(arg);
  }
  function parsePrime(parser, lhs, order2) {
    const lhsh = operator(lhs);
    if (lhsh === "Derivative" || lhsh === "Prime") {
      const n = machineValue(operand(lhs, 2)) ?? 1;
      return [lhsh, missingIfEmpty(operand(lhs, 1)), n + order2];
    }
    const sym = symbol(lhs);
    if (sym && parser.getIdentifierType(sym) === "function" || operator(lhs)) {
      if (order2 === 1) return ["Derivative", lhs];
      return ["Derivative", lhs, order2];
    }
    if (order2 === 1) return ["Prime", missingIfEmpty(lhs)];
    return ["Prime", missingIfEmpty(lhs), order2];
  }
  function parseParenDelimiter(_parser, body) {
    if (isEmptySequence(body)) return ["Delimiter"];
    const h = operator(body);
    if (h === "Delimiter" && operand(body, 2) !== null) {
      const delims = stringValue(operand(body, 2));
      if (delims?.length === 1) {
        return [
          "Delimiter",
          operand(body, 1) ?? "Nothing",
          { str: `(${delims})` }
        ];
      }
    }
    if (h === "Matrix") {
      const delims = stringValue(operand(body, 2)) ?? "..";
      if (delims === "..") return ["Matrix", operand(body, 1)];
    }
    return ["Delimiter", body];
  }
  function parseBrackets(parser, body) {
    if (isEmptySequence(body)) return ["List"];
    const h = operator(body);
    if (h === "Range" || h === "Linspace") return body;
    if (h === "Sequence") return ["List", ...operands(body)];
    if (h === "Delimiter") {
      const delim = stringValue(operand(body, 2)) ?? "...";
      if (delim === ";" || delim === ".;.") {
        return [
          "List",
          ...(operands(operand(body, 1)) ?? []).map(
            (x) => parseBrackets(parser, x)
          )
        ];
      }
      if (delim === "," || delim === ".,.") {
        body = operand(body, 1);
        if (operator(body) === "Sequence") return ["List", ...operands(body)];
        return ["List", body ?? "Nothing"];
      }
    }
    return ["List", body];
  }
  function serializeList(serializer, expr) {
    if (nops(expr) > 1 && operands(expr).every((x) => {
      const op = operator(x);
      return isEquationOperator(op) || isInequalityOperator(op);
    })) {
      return joinLatex([
        "\\begin{cases}",
        serializeOps("\\\\")(serializer, expr),
        "\\end{cases}"
      ]);
    }
    return joinLatex([
      "\\bigl\\lbrack",
      serializeOps(", ")(serializer, expr),
      "\\bigr\\rbrack"
    ]);
  }
  function parseRange(parser, lhs) {
    if (lhs === null) return null;
    const second = parser.parseExpression({ minPrec: 270 });
    if (second === null) return null;
    if (parser.matchAll([".", "."])) {
      const end = parser.parseExpression({ minPrec: 270 });
      if (end === null) return null;
      const lhsValue = machineValue(lhs);
      const secondValue = machineValue(second);
      if (lhsValue !== null && secondValue !== null) {
        if (secondValue <= lhsValue) return null;
        if (secondValue - lhsValue === 1) return ["Range", lhs, end];
        return ["Range", lhs, end, secondValue - lhsValue];
      }
      return ["Range", lhs, end, ["Subtract", second, lhs]];
    }
    return ["Range", lhs, second];
  }
  var DELIMITERS_SHORTHAND = {
    "(": "(",
    ")": ")",
    "[": "\\lbrack",
    "]": "\\rbrack",
    "\u27E6": "\\llbrack",
    // U+27E6 MATHEMATICAL LEFT WHITE SQUARE BRACKET
    "\u27E7": "\\rrbrack",
    // U+27E7 MATHEMATICAL RIGHT WHITE SQUARE BRACKET
    "{": "\\lbrace",
    "}": "\\rbrace",
    "<": "\\langle",
    ">": "\\rangle",
    // '|': '\\vert',
    "\u2016": "\\Vert",
    // U+2016 DOUBLE VERTICAL LINE
    "\\": "\\backslash",
    "\u2308": "\\lceil",
    // ⌈ U+2308 LEFT CEILING
    "\u2309": "\\rceil",
    // U+2309 RIGHT CEILING
    "\u230A": "\\lfloor",
    // ⌊ U+230A LEFT FLOOR
    "\u230B": "\\rfloor",
    // ⌋ U+230B RIGHT FLOOR
    "\u231C": "\\ulcorner",
    // ⌜ U+231C TOP LEFT CORNER
    "\u231D": "\\urcorner",
    // ⌝ U+231D TOP RIGHT CORNER
    "\u231E": "\\llcorner",
    // ⌞ U+231E BOTTOM LEFT CORNER
    "\u231F": "\\lrcorner",
    // ⌟ U+231F BOTTOM RIGHT CORNER
    "\u23B0": "\\lmoustache",
    // U+23B0 UPPER LEFT OR LOWER RIGHT CURLY BRACKET SECTION
    "\u23B1": "\\rmoustache"
    // U+23B1 UPPER RIGHT OR LOWER LEFT CURLY BRACKET SECTION
    // '⎹': '', // U+23B9 DIVIDES
    // '⎾': '', // U+23BE RIGHT PARENTHESIS UPPER HOOK
    // '⎿': '', // U+23BF RIGHT PARENTHESIS LOWER HOOK
  };
  function parseAssign(parser, lhs) {
    if (operator(lhs) === "InvisibleOperator" && nops(lhs) === 2 && operator(operand(lhs, 2)) === "Delimiter") {
      const fn2 = symbol(operand(lhs, 1));
      if (!fn2) return null;
      const rhs2 = parser.parseExpression({ minPrec: 0 });
      if (rhs2 === null) return null;
      const delimBody = operand(operand(lhs, 2), 1);
      let args = [];
      if (operator(delimBody) === "Sequence") args = [...operands(delimBody)];
      else if (delimBody) args = [delimBody];
      return ["Assign", fn2, ["Function", rhs2, ...args ?? []]];
    }
    const fn = operator(lhs);
    if (fn) {
      const args = operands(lhs);
      const rhs2 = parser.parseExpression({ minPrec: 0 });
      if (rhs2 === null) return null;
      return ["Assign", fn, ["Function", rhs2, ...args]];
    }
    if (!symbol(lhs)) return null;
    const rhs = parser.parseExpression({ minPrec: 0 });
    if (rhs === null) return null;
    return ["Assign", lhs, rhs];
  }
  function parseCasesEnvironment(parser) {
    const rows = parser.parseTabular();
    if (!rows) return ["List"];
    if (rows.every((row) => {
      if (row.length !== 1) return false;
      const op = operator(row[0]);
      return isInequalityOperator(op) || isEquationOperator(op);
    })) {
      return ["List", ...rows.map((row) => row[0])];
    }
    const result = [];
    for (const row of rows) {
      if (row.length === 1) {
        result.push("True");
        result.push(row[0]);
      } else if (row.length === 2) {
        const s = stringValue(row[1]);
        result.push(s ? "True" : stripText(row[1]) ?? "True");
        result.push(row[0]);
      }
    }
    return ["Which", ...result];
  }
  function parseAt(...close) {
    return (parser, lhs) => {
      if (!symbol(lhs) && operator(lhs) !== "List") return null;
      let rhs = null;
      if (close.length === 0) rhs = parser.parseGroup();
      rhs ?? (rhs = parser.parseExpression({ minPrec: 0 }));
      if (rhs === null) return null;
      if (close.length > 0 && !parser.matchAll(close)) return null;
      if (stringValue(rhs) !== null) return null;
      if (operator(rhs) === "Delimiter") rhs = operand(rhs, 1) ?? "Nothing";
      if (operator(rhs) === "Sequence") return ["At", lhs, ...operands(rhs)];
      return ["At", lhs, rhs];
    };
  }

  // src/compute-engine/latex-syntax/dictionary/definitions-linear-algebra.ts
  var DEFINITIONS_LINEAR_ALGEBRA = [
    // The first argument is the matrix data.
    // The second, optional, argument are the delimiters.
    // The third, optional, argument is the column specification.
    {
      name: "Matrix",
      serialize: (serializer, expr) => {
        const rows = operands(operand(expr, 1));
        return serializeTabular(
          serializer,
          rows,
          stringValue(operand(expr, 2)),
          stringValue(operand(expr, 3))
        );
      }
    },
    // Vector is a specialized collection to represent a column vector.
    {
      name: "Vector",
      serialize: (serializer, expr) => {
        const columns = operands(expr);
        return serializeTabular(
          serializer,
          columns.map((column) => ["List", column]),
          stringValue(operand(expr, 2)),
          stringValue(operand(expr, 3))
        );
      }
    },
    {
      kind: "environment",
      identifierTrigger: "pmatrix",
      parse: (parser) => {
        const columns = parseColumnFormat(parser);
        const [operator2, cells] = parseCells(parser);
        if (columns)
          return [operator2, cells, { str: "()" }, { str: columns }];
        return [operator2, cells];
      }
    },
    {
      kind: "environment",
      identifierTrigger: "bmatrix",
      parse: (parser) => {
        const columns = parseColumnFormat(parser);
        const [operator2, cells] = parseCells(parser);
        if (columns)
          return [operator2, cells, { str: "[]" }, { str: columns }];
        return [operator2, cells, { str: "[]" }];
      }
    },
    {
      kind: "environment",
      identifierTrigger: "Bmatrix",
      parse: (parser) => {
        const columns = parseColumnFormat(parser);
        const [operator2, cells] = parseCells(parser);
        if (columns)
          return [operator2, cells, { str: "{}" }, { str: columns }];
        return [operator2, cells, { str: "{}" }];
      }
    },
    {
      kind: "environment",
      identifierTrigger: "vmatrix",
      parse: (parser) => {
        const columns = parseColumnFormat(parser);
        const [operator2, cells] = parseCells(parser);
        if (columns)
          return [operator2, cells, { str: "||" }, { str: columns }];
        return [operator2, cells, { str: "||" }];
      }
    },
    {
      kind: "environment",
      identifierTrigger: "Vmatrix",
      parse: (parser) => {
        const columns = parseColumnFormat(parser);
        const [operator2, cells] = parseCells(parser);
        if (columns)
          return [operator2, cells, { str: "\u2016\u2016" }, { str: columns }];
        return [operator2, cells, { str: "\u2016\u2016" }];
      }
    },
    {
      kind: "environment",
      identifierTrigger: "smallmatrix",
      parse: (parser) => {
        const columns = parseColumnFormat(parser);
        const [operator2, cells] = parseCells(parser);
        if (columns)
          return [operator2, cells, { str: "()" }, { str: columns }];
        return [operator2, cells];
      }
    },
    {
      kind: "environment",
      identifierTrigger: "array",
      parse: (parser) => {
        const columns = parseColumnFormat(parser, false);
        const [operator2, cells] = parseCells(parser);
        if (columns)
          return [operator2, cells, { str: ".." }, { str: columns }];
        return [operator2, cells, { str: ".." }];
      }
    },
    {
      kind: "environment",
      identifierTrigger: "matrix",
      parse: (parser) => {
        const columns = parseColumnFormat(parser);
        const [operator2, cells] = parseCells(parser);
        if (columns)
          return [operator2, cells, { str: ".." }, { str: columns }];
        return [operator2, cells, { str: ".." }];
      }
    },
    {
      kind: "environment",
      identifierTrigger: "matrix*",
      parse: (parser) => {
        const columns = parseColumnFormat(parser);
        const [operator2, cells] = parseCells(parser);
        if (columns)
          return [operator2, cells, { str: ".." }, { str: columns }];
        return [operator2, cells, { str: ".." }];
      }
    },
    {
      name: "ConjugateTranspose",
      kind: "postfix",
      latexTrigger: ["^", "\\star"]
    },
    {
      kind: "postfix",
      latexTrigger: ["^", "\\H"],
      parse: "ConjugateTranspose"
    },
    {
      kind: "postfix",
      latexTrigger: ["^", "\\dagger"],
      parse: (_parser, lhs) => {
        return ["ConjugateTranspose", lhs];
      }
    },
    {
      kind: "postfix",
      latexTrigger: ["^", "\\ast"],
      parse: (_parser, lhs) => {
        return ["ConjugateTranspose", lhs];
      }
    },
    {
      kind: "postfix",
      latexTrigger: ["^", "\\top"],
      parse: (parser, lhs) => {
        return ["Transpose", lhs];
      }
    },
    {
      kind: "postfix",
      latexTrigger: ["^", "\\intercal"],
      parse: (parser, lhs) => {
        return ["Transpose", lhs];
      }
    },
    {
      name: "Transpose",
      kind: "postfix",
      latexTrigger: ["^", "T"]
    },
    {
      name: "PseudoInverse",
      kind: "postfix",
      latexTrigger: ["^", "+"]
    },
    {
      name: "Trace",
      kind: "function",
      identifierTrigger: "tr"
    },
    {
      name: "Determinant",
      kind: "function",
      identifierTrigger: "det"
    }
  ];
  function parseCells(parser) {
    const tabular = parser.parseTabular();
    if (!tabular) return ["", null];
    return [
      "Matrix",
      [
        "List",
        ...tabular.map((row) => ["List", ...row])
      ]
    ];
  }
  function parseColumnFormat(parser, optional = true) {
    const colFormat = parser.parseStringGroup(optional)?.trim();
    if (!colFormat) return "";
    let result = "";
    for (const c of colFormat) {
      if (c === "c") result += "=";
      if (c === "l") result += "<";
      if (c === "r") result += ">";
      if (c === "|") result += "|";
      if (c === ":") result += ":";
    }
    return result;
  }
  function serializeTabular(serializer, rows, delims, colSpec) {
    delims ?? (delims = "()");
    let [open, close] = ["", ""];
    if (typeof delims === "string" && delims.length === 2) [open, close] = delims;
    let columns = "";
    if (colSpec) {
      for (const c of colSpec) {
        if (c === "<") columns += "l";
        else if (c === ">") columns += "r";
        else if (c === "=") columns += "c";
        else if (c === "|") columns += "|";
        else if (c === ":") columns += ":";
      }
    }
    const serializedRows = [];
    for (const row of rows ?? []) {
      const cells = [];
      for (const cell of operands(row)) cells.push(serializer.serialize(cell));
      serializedRows.push(cells.join(" & "));
    }
    const tabular = serializedRows.join("\\\\\n");
    const optColumns = columns.length > 0 ? `[${columns}]` : "";
    if (open === "(" && close === ")")
      return joinLatex([
        "\\begin{pmatrix}",
        optColumns,
        tabular,
        "\\end{pmatrix}"
      ]);
    if (open === "[" && close === "]")
      return joinLatex([
        "\\begin{bmatrix}",
        optColumns,
        tabular,
        "\\end{bmatrix}"
      ]);
    if (open === "{" && close === "}")
      return joinLatex([
        "\\begin{Bmatrix}",
        optColumns,
        tabular,
        "\\end{Bmatrix}"
      ]);
    if (open === "|" && close === "|")
      return joinLatex([
        "\\begin{vmatrix}",
        optColumns,
        tabular,
        "\\end{vmatrix}"
      ]);
    if (open === "\u2016" && close === "\u2016")
      return joinLatex([
        "\\begin{Vmatrix}",
        optColumns,
        tabular,
        "\\end{Vmatrix}"
      ]);
    if (open === "{" && close === ".")
      return joinLatex(["\\begin{dcases}", optColumns, tabular, "\\end{dcases}"]);
    if (open === "." && close === "}")
      return joinLatex(["\\begin{rcases}", optColumns, tabular, "\\end{rcases}"]);
    if (columns || open !== "." || close !== ".") {
      return joinLatex([
        "\\left",
        DELIMITERS_SHORTHAND[open] ?? open,
        "\\begin{array}",
        `{${columns}}`,
        tabular,
        "\\end{array}",
        "\\right",
        DELIMITERS_SHORTHAND[close] ?? close
      ]);
    }
    return joinLatex(["\\begin{matrix}", tabular, "\\end{matrix}"]);
  }

  // src/compute-engine/latex-syntax/dictionary/definitions-logic.ts
  var DEFINITIONS_LOGIC = [
    // Constants
    {
      name: "True",
      kind: "symbol",
      latexTrigger: ["\\top"]
      // ⊤ U+22A4
    },
    {
      kind: "symbol",
      latexTrigger: "\\mathrm{True}",
      parse: "True"
    },
    {
      kind: "symbol",
      latexTrigger: "\\operatorname{True}",
      parse: "True"
    },
    {
      kind: "symbol",
      latexTrigger: "\\mathsf{T}",
      parse: "True"
    },
    {
      name: "False",
      kind: "symbol",
      latexTrigger: ["\\bot"]
      // ⊥ U+22A5
    },
    {
      kind: "symbol",
      latexTrigger: "\\operatorname{False}",
      parse: "False"
    },
    {
      kind: "symbol",
      latexTrigger: "\\mathsf{F}",
      parse: "False"
    },
    // Operators
    {
      name: "And",
      kind: "infix",
      latexTrigger: ["\\land"],
      precedence: 317
      // serialize: '\\land',
    },
    { kind: "infix", latexTrigger: ["\\wedge"], parse: "And", precedence: 317 },
    { kind: "infix", latexTrigger: "\\&", parse: "And", precedence: 317 },
    {
      kind: "infix",
      latexTrigger: "\\operatorname{and}",
      parse: "And",
      precedence: 317
    },
    {
      name: "Or",
      kind: "infix",
      latexTrigger: ["\\lor"],
      precedence: 310
    },
    { kind: "infix", latexTrigger: ["\\vee"], parse: "Or", precedence: 310 },
    { kind: "infix", latexTrigger: "\\parallel", parse: "Or", precedence: 310 },
    {
      kind: "infix",
      latexTrigger: "\\operatorname{or}",
      parse: "Or",
      precedence: 310
    },
    {
      name: "Xor",
      kind: "infix",
      latexTrigger: ["\\veebar"],
      precedence: 315
    },
    // Possible alt: \oplus ⊕ U+2295
    {
      name: "Not",
      kind: "prefix",
      latexTrigger: ["\\lnot"],
      precedence: 880
    },
    {
      kind: "prefix",
      latexTrigger: ["\\neg"],
      parse: "Not",
      precedence: 880
    },
    {
      name: "Nand",
      kind: "infix",
      latexTrigger: ["\\barwedge"],
      precedence: 315
      // serialize: '\\mid',
    },
    {
      name: "Nor",
      kind: "infix",
      latexTrigger: ["\u22BD"],
      // bar vee
      precedence: 315
      // serialize: '\\downarrow',
    },
    // Functions
    {
      kind: "function",
      identifierTrigger: "and",
      parse: "And"
    },
    {
      kind: "function",
      identifierTrigger: "or",
      parse: "Or"
    },
    {
      kind: "function",
      identifierTrigger: "not",
      parse: "Not"
    },
    // Relations
    {
      name: "Implies",
      kind: "infix",
      precedence: 220,
      associativity: "right",
      latexTrigger: ["\\implies"],
      serialize: "\\implies"
    },
    {
      latexTrigger: ["\\Rightarrow"],
      kind: "infix",
      precedence: 220,
      associativity: "right",
      parse: "Implies"
    },
    {
      name: "Equivalent",
      // MathML: identical to, Mathematica: Congruent
      latexTrigger: ["\\iff"],
      kind: "infix",
      associativity: "right",
      precedence: 219
    },
    {
      latexTrigger: ["\\Leftrightarrow"],
      kind: "infix",
      associativity: "right",
      precedence: 219,
      parse: "Equivalent"
    },
    {
      latexTrigger: ["\\equiv"],
      kind: "infix",
      associativity: "right",
      precedence: 219,
      parse: (parser, lhs, terminator) => {
        const rhs = parser.parseExpression({ ...terminator, minPrec: 219 });
        const index = parser.index;
        const modulus = parser.parseExpression({ ...terminator, minPrec: 219 });
        if (modulus !== null && operator(modulus) === "Mod")
          return ["Congruent", lhs, rhs, missingIfEmpty(operand(modulus, 1))];
        parser.index = index;
        return ["Equivalent", lhs, missingIfEmpty(rhs)];
      }
    },
    {
      name: "Proves",
      kind: "infix",
      latexTrigger: ["\\vdash"],
      precedence: 220,
      associativity: "right",
      serialize: "\\vdash"
    },
    {
      name: "Entails",
      kind: "infix",
      latexTrigger: ["\\vDash"],
      precedence: 220,
      associativity: "right",
      serialize: "\\vDash"
    },
    {
      name: "Satisfies",
      kind: "infix",
      latexTrigger: ["\\models"],
      precedence: 220,
      associativity: "right",
      serialize: "\\models"
    },
    // Quantifiers: for all, exists
    {
      name: "ForAll",
      kind: "prefix",
      latexTrigger: ["\\forall"],
      precedence: 200,
      // Has to be lower than COMPARISON_PRECEDENCE
      serialize: "\\forall",
      parse: parseQuantifier("ForAll")
    },
    {
      name: "Exists",
      kind: "prefix",
      latexTrigger: ["\\exists"],
      precedence: 200,
      // Has to be lower than COMPARISON_PRECEDENCE,
      serialize: "\\exists",
      parse: parseQuantifier("Exists")
    },
    {
      name: "ExistsUnique",
      kind: "prefix",
      latexTrigger: ["\\exists", "!"],
      precedence: 200,
      // Has to be lower than COMPARISON_PRECEDENCE,
      serialize: "\\exists!",
      parse: parseQuantifier("ExistsUnique")
    },
    {
      name: "NotForAll",
      kind: "prefix",
      latexTrigger: ["\\lnot", "\\forall"],
      precedence: 200,
      // Has to be lower than COMPARISON_PRECEDENCE
      serialize: "\\lnot\\forall",
      parse: parseQuantifier("NotForAll")
    },
    {
      name: "NotExists",
      kind: "prefix",
      latexTrigger: ["\\lnot", "\\exists"],
      precedence: 200,
      // Has to be lower than COMPARISON_PRECEDENCE,
      serialize: "\\lnot\\exists",
      parse: parseQuantifier("NotExists")
    },
    {
      name: "KroneckerDelta",
      kind: "prefix",
      latexTrigger: ["\\delta", "_"],
      precedence: 200,
      serialize: (serializer, expr) => {
        const args = operands(expr);
        if (args.length === 0) return "\\delta";
        if (args.every((x) => symbol(x)))
          return `\\delta_{${args.map((arg) => serializer.serialize(arg)).join("")}}`;
        return `\\delta_{${args.map((arg) => serializer.serialize(arg)).join(", ")}}`;
      },
      parse: (parser) => {
        const group = parser.parseGroup();
        if (group === null) {
          const token = parser.parseToken();
          if (!token) return null;
          return ["KroneckerDelta", token];
        }
        const seq = getSequence(group);
        if (seq && seq.length <= 2) return ["KroneckerDelta", ...seq];
        if (operator(group) === "InvisibleOperator")
          return ["KroneckerDelta", ...operands(group)];
        if (group !== null) return ["KroneckerDelta", group];
        return null;
      }
    },
    // Iverson brackets. Also called the "indicator function"
    // Must have a single argument, a relational expression, i.e.
    // `[ a = b ]` or `[ x \leq 0 ]`
    // Otherwise, it gets rejected, it could be something else, like a list or
    // tuple.
    {
      name: "Boole",
      kind: "matchfix",
      openTrigger: "[",
      closeTrigger: "]",
      // serialize: (serializer: Serializer, expr: Expression) => {
      //   const args = ops(expr);
      //   return `[${serializer.serialize(arg)}]`;
      // },
      parse: (_parser, body) => {
        const h = operator(body);
        if (!h) return null;
        if (!DEFINITIONS_INEQUALITIES.some((x) => x.name === h)) return null;
        return ["Boole", body];
      }
    },
    {
      kind: "matchfix",
      openTrigger: "\\llbracket",
      closeTrigger: "\\rrbracket",
      parse: (_parser, body) => {
        const h = operator(body);
        if (!h) return null;
        if (!DEFINITIONS_INEQUALITIES.some((x) => x.name === h)) return null;
        return ["Boole", body];
      }
    }
  ];
  function parseQuantifier(kind) {
    return (parser, terminator) => {
      const index = parser.index;
      const id = parser.parseSymbol(terminator);
      if (id) {
        parser.skipSpace();
        if (parser.match(",") || parser.match("\\mid") || parser.match(".") || parser.match(":") || parser.match("\\colon")) {
          const body2 = parser.parseExpression(terminator);
          return [kind, id, missingIfEmpty(body2)];
        }
        const body = parser.parseEnclosure();
        if (body) return [kind, id, missingIfEmpty(body)];
      }
      parser.index = index;
      const condition = parser.parseExpression(terminator);
      if (condition === null) return null;
      parser.skipSpace();
      if (parser.matchAny([",", "\\mid", ":", "\\colon"])) {
        const body = parser.parseExpression(terminator);
        return [kind, condition, missingIfEmpty(body)];
      }
      if (parser.match("(")) {
        const body = parser.parseExpression(terminator);
        if (!parser.match(")")) return null;
        return [kind, condition, missingIfEmpty(body)];
      }
      return null;
    };
  }

  // src/compute-engine/latex-syntax/dictionary/definitions-other.ts
  function parseSingleArg(cmd) {
    return (parser) => {
      const arg = parser.parseGroup();
      return arg === null ? [cmd] : [cmd, arg];
    };
  }
  var DEFINITIONS_OTHERS = [
    {
      name: "Overscript",
      latexTrigger: ["\\overset"],
      kind: "infix",
      precedence: 700
      // @todo: not in MathML
    },
    {
      name: "Underscript",
      latexTrigger: ["\\underset"],
      kind: "infix",
      precedence: 700
      // @todo: not in MathML
    },
    {
      name: "Increment",
      latexTrigger: ["+", "+"],
      kind: "postfix",
      precedence: 880,
      parse: (_parser, lhs) => {
        if (symbol(lhs) === null) return null;
        return ["Decrement", lhs];
      }
    },
    {
      name: "Decrement",
      latexTrigger: ["-", "-"],
      kind: "postfix",
      precedence: 880,
      parse: (_parser, lhs) => {
        if (symbol(lhs) === null) return null;
        return ["Decrement", lhs];
      }
    },
    {
      name: "PreIncrement",
      latexTrigger: ["+", "+"],
      kind: "prefix",
      precedence: 880,
      parse: (parser, until) => {
        const rhs = parser.parseExpression(until);
        if (symbol(rhs) === null) return null;
        return ["PreIncrement", rhs];
      }
    },
    {
      name: "PreDecrement",
      latexTrigger: ["-", "-"],
      kind: "prefix",
      precedence: 880,
      parse: (parser, until) => {
        const rhs = parser.parseExpression(until);
        if (symbol(rhs) === null) return null;
        return ["PreDecrement", rhs];
      }
    },
    {
      name: "Ring",
      // Aka 'Composition', i.e. function composition
      latexTrigger: ["\\circ"],
      kind: "infix",
      precedence: 265
      // @todo: MathML is 950
      // @todo: check lhs and rhs are functions
    },
    {
      name: "StringJoin",
      // @todo From Mathematica...?
      latexTrigger: ["\\lt", "\\gt"],
      kind: "infix",
      precedence: 780
    },
    {
      name: "Starstar",
      latexTrigger: ["\\star", "\\star"],
      kind: "infix",
      precedence: 780
    },
    {
      // Partial derivative using a variation of the Euler notation: `∂_xf(x)`
      // (the Euler notation uses `D_1f(x)` where "1" is for the first variable
      // For the Leibniz notation see 'Divide' that handles `∂f/∂x`
      name: "PartialDerivative",
      // PartialDerivative(expr, {lists of vars}, degree)
      latexTrigger: ["\\partial"],
      kind: "prefix",
      parse: (parser) => {
        let done = false;
        let sup = "Nothing";
        let sub2 = "Nothing";
        while (!done) {
          parser.skipSpace();
          if (parser.match("_")) {
            sub2 = parser.parseGroup() ?? parser.parseToken();
          } else if (parser.match("^")) {
            sup = parser.parseGroup() ?? parser.parseToken();
          } else {
            done = true;
          }
        }
        const seq = getSequence(sub2);
        if (seq) sub2 = ["List", ...seq];
        if (sub2 === null || sup === null) return null;
        let rhs = parser.parseGroup() ?? "Nothing";
        if (!isEmptySequence(rhs)) {
          const args = parser.parseArguments() ?? ["Nothing"];
          rhs = [rhs, ...args];
        }
        return ["PartialDerivative", rhs, sub2, sup];
      },
      serialize: (serializer, expr) => {
        let result = "\\partial";
        const fn = operand(expr, 1);
        const vars = operand(expr, 2);
        const degree = operand(expr, 3);
        if (vars !== null && vars !== "Nothing") {
          if (operator(vars) === "List") {
            result += "_{" + serializer.serialize(["Sequence", ...operands(vars)]) + "}";
          } else {
            result += "_{" + serializer.serialize(vars) + "}";
          }
        }
        if (degree !== null && degree !== "Nothing")
          result += "^{" + serializer.serialize(degree) + "}";
        if (fn !== null && fn !== "Nothing") result += serializer.serialize(fn);
        return result;
      },
      precedence: 740
    },
    {
      name: "OverBar",
      latexTrigger: ["\\overline"],
      parse: parseSingleArg("OverBar")
    },
    {
      name: "UnderBar",
      latexTrigger: ["\\underline"],
      parse: parseSingleArg("UnderBar")
    },
    {
      name: "OverVector",
      latexTrigger: ["\\vec"],
      parse: parseSingleArg("OverVector")
    },
    {
      name: "OverTilde",
      latexTrigger: ["\\tilde"],
      parse: parseSingleArg("OverTilde")
    },
    {
      name: "OverHat",
      latexTrigger: ["\\hat"],
      parse: parseSingleArg("OverHat")
    },
    {
      name: "OverRightArrow",
      latexTrigger: ["\\overrightarrow"],
      parse: parseSingleArg("OverRightArrow")
    },
    {
      name: "OverLeftArrow",
      latexTrigger: ["\\overleftarrow"],
      parse: parseSingleArg("OverLeftArrow")
    },
    {
      name: "OverRightDoubleArrow",
      latexTrigger: ["\\Overrightarrow"],
      parse: parseSingleArg("OverRightDoubleArrow")
    },
    {
      name: "OverLeftHarpoon",
      latexTrigger: ["\\overleftharpoon"],
      parse: parseSingleArg("OverLeftHarpoon")
    },
    {
      name: "OverRightHarpoon",
      latexTrigger: ["\\overrightharpoon"],
      parse: parseSingleArg("OverRightHarpoon")
    },
    {
      name: "OverLeftRightArrow",
      latexTrigger: ["\\overleftrightarrow"],
      parse: parseSingleArg("OverLeftRightArrow")
    },
    {
      name: "OverBrace",
      latexTrigger: ["\\overbrace"],
      parse: parseSingleArg("OverBrace")
    },
    {
      name: "OverLineSegment",
      latexTrigger: ["\\overlinesegment"],
      parse: parseSingleArg("OverLineSegment")
    },
    {
      name: "OverGroup",
      latexTrigger: ["\\overgroup"],
      parse: parseSingleArg("OverGroup")
    },
    {
      latexTrigger: ["\\displaystyle"],
      parse: () => "Nothing"
      // @todo: parse as ['Style'...]
    },
    {
      latexTrigger: ["\\textstyle"],
      parse: () => "Nothing"
      // @todo: parse as ['Style'...]
    },
    {
      latexTrigger: ["\\scriptstyle"],
      parse: () => "Nothing"
      // @todo: parse as ['Style'...]
    },
    {
      latexTrigger: ["\\scriptscriptstyle"],
      parse: () => "Nothing"
      // @todo: parse as ['Style'...]
    },
    {
      latexTrigger: ["\\tiny"],
      parse: () => "Nothing"
      // @todo: parse as ['Style'...]
    },
    {
      latexTrigger: ["\\scriptsize"],
      parse: () => "Nothing"
      // @todo: parse as ['Style'...]
    },
    {
      latexTrigger: ["\\footnotesize"],
      parse: () => "Nothing"
      // @todo: parse as ['Style'...]
    },
    {
      latexTrigger: ["\\small"],
      parse: () => "Nothing"
      // @todo: parse as ['Style'...]
    },
    {
      latexTrigger: ["\\normalsize"],
      parse: () => "Nothing"
      // @todo: parse as ['Style'...]
    },
    {
      latexTrigger: ["\\large"],
      parse: () => "Nothing"
      // @todo: parse as ['Style'...]
    },
    {
      latexTrigger: ["\\Large"],
      parse: () => "Nothing"
      // @todo: parse as ['Style'...]
    },
    {
      latexTrigger: ["\\LARGE"],
      parse: () => "Nothing"
      // @todo: parse as ['Style'...]
    },
    {
      latexTrigger: ["\\huge"],
      parse: () => "Nothing"
      // @todo: parse as ['Style'...]
    },
    {
      latexTrigger: ["\\Huge"],
      parse: () => "Nothing"
      // @todo: parse as ['Style'...]
    },
    {
      name: "Style",
      serialize: (serializer, expr) => {
        let result = serializer.serialize(operand(expr, 1));
        const dict = dictionaryFromExpression(operand(expr, 2));
        if (dict === null) return result;
        if (stringValue(dict.display) === "block")
          result = joinLatex(["{\\displaystyle", result, "}"]);
        else if (stringValue(dict.display) === "inline")
          result = joinLatex(["{\\textstyle", result, "}"]);
        else if (stringValue(dict.display) === "script")
          result = joinLatex(["{\\scriptstyle", result, "}"]);
        else if (stringValue(dict.display) === "scriptscript")
          result = joinLatex(["{\\scriptscriptstyle", result, "}"]);
        const v = machineValue(dict.size);
        if (v !== null && v >= 1 && v <= 10) {
          result = joinLatex([
            "{",
            {
              1: "\\tiny",
              2: "\\scriptsize",
              3: "\\footnotesize",
              4: "\\small",
              5: "\\normalsize",
              6: "\\large",
              7: "\\Large",
              8: "\\LARGE",
              9: "\\huge",
              10: "\\Huge"
            }[v],
            result,
            "}"
          ]);
        }
        return result;
      }
    },
    {
      latexTrigger: ["\\!"],
      parse: () => ["HorizontalSpacing", -3]
    },
    {
      latexTrigger: ["\\ "],
      parse: () => ["HorizontalSpacing", 6]
    },
    {
      latexTrigger: ["\\:"],
      parse: () => ["HorizontalSpacing", 4]
    },
    {
      latexTrigger: ["\\enskip"],
      parse: () => ["HorizontalSpacing", 9]
    },
    {
      latexTrigger: ["\\quad"],
      parse: () => ["HorizontalSpacing", 18]
    },
    {
      latexTrigger: ["\\qquad"],
      parse: () => ["HorizontalSpacing", 36]
    },
    {
      latexTrigger: ["\\,"],
      parse: () => ["HorizontalSpacing", 3]
    },
    {
      latexTrigger: ["\\;"],
      parse: () => ["HorizontalSpacing", 5]
    },
    {
      latexTrigger: ["\\enspace"],
      parse: () => ["HorizontalSpacing", 9]
    },
    {
      name: "HorizontalSpacing",
      // The `HorizontalSpacing` function has two forms
      // `["HorizontalSpacing", number]` -> indicate a space of mu units
      // `["HorizontalSpacing", expr, 'op'|'bin'|rel]` -> indicate a spacing around and expression, i.e. `\mathbin{x}`, etc...
      serialize: (serializer, expr) => {
        if (operand(expr, 2) !== null) {
          return serializer.serialize(operand(expr, 1));
        }
        const v = machineValue(operand(expr, 1));
        if (v === null) return "";
        return {
          "-3": "\\!",
          6: "\\ ",
          3: "\\,",
          4: "\\:",
          5: "\\;",
          9: "\\enspace",
          18: "\\quad",
          36: "\\qquad"
        }[v] ?? "";
      }
    }
    // if (
    //   [
    //     '\\!',
    //     '\\:',
    //     '\\enskip',
    //     '\\quad',
    //     '\\,',
    //     '\\;',
    //     '\\enspace',
    //     '\\qquad',
    //     '\\selectfont',
    //   ].includes(token)
    // ) {
    //   return 'skip';
    // }
    // {
    //     name: '',
    //     trigger: '\\mathring',
    // },
    // {
    //     name: '',
    //     trigger: '\\check',
    // },
  ];

  // src/compute-engine/latex-syntax/dictionary/definitions-trigonometry.ts
  function parseTrig(op) {
    return (parser, until) => {
      const trigCommands = {
        "\\arcsin": "Arcsin",
        "\\arccos": "Arccos",
        "\\arctan": "Arctan",
        "\\arctg": "Arctan",
        "\\arcctg": "Arccot",
        "\\arcsec": "Arcsec",
        // Non-standard
        "\\arccsc": "Arccsc",
        // Non-standard
        "\\arsinh": "Arsinh",
        // Non-standard
        "\\arcosh": "Arccosh",
        // Non-standard
        "\\arccosh": "Arccosh",
        "\\artanh": "Arctanh",
        "\\arctanh": "Arctanh",
        "\\arsech": "Arcsech",
        "\\arcsech": "Arcsech",
        "\\arcsch": "Arccsch",
        "\\arccsch": "Arccsch",
        "\\ch": "Cosh",
        // Non-standard
        "\\cos": "Cos",
        "\\cosh": "Csch",
        "\\cosec": "Csc",
        // Non-standard
        "\\cot": "Cot",
        "\\cotg": "Cot",
        // Non-standard
        "\\ctg": "Cot",
        // Non-standard
        "\\csc": "Csc",
        "\\csch": "Csch",
        // Non-standard
        "\\coth": "Coth",
        "\\cth": "Coth",
        // Non-standard
        "\\sec": "Sec",
        "\\sech": "Sech",
        // Non-standard
        "\\sin": "Sin",
        "\\sinh": "Sinh",
        "\\sh": "Sinh",
        // Non-standard
        "\\tan": "Tan",
        "\\tg": "Tan",
        // Non-standard
        "\\tanh": "Tanh",
        "\\th": "Tanh"
        // Non-standard
      };
      const operator2 = trigCommands[op ?? ""] ?? op ?? "";
      if (parser.atTerminator(until)) return operator2;
      let fn = operator2;
      do {
        const pf = parser.parsePostfixOperator(fn, until);
        if (pf === null) break;
        fn = pf;
      } while (true);
      parser.skipSpace();
      let sup = null;
      if (parser.match("^")) sup = parser.parseGroup() ?? parser.parseToken();
      parser.skipSpace();
      const args = parser.parseArguments("implicit", {
        minPrec: MULTIPLICATION_PRECEDENCE,
        condition: (parser2) => trigCommands[parser2.peek] || (until?.condition?.(parser2) ?? false)
      });
      const appliedFn = args === null ? fn : typeof fn === "string" ? [fn, ...args] : ["Apply", fn, ...args];
      return sup === null ? appliedFn : ["Power", appliedFn, sup];
    };
  }
  var DEFINITIONS_TRIGONOMETRY = [
    {
      name: "Arcsin",
      latexTrigger: ["\\arcsin"],
      parse: parseTrig("Arcsin")
    },
    {
      name: "Arccos",
      latexTrigger: ["\\arccos"],
      parse: parseTrig("Arccos")
    },
    {
      name: "Arctan",
      latexTrigger: ["\\arctan"],
      parse: parseTrig("Arctan")
    },
    {
      // Variant, non-standard command
      latexTrigger: ["\\arctg"],
      parse: parseTrig("Arctan")
    },
    {
      // Variant, identifier
      identifierTrigger: "arctg",
      parse: parseTrig("Arctan")
    },
    {
      name: "Arccot",
      identifierTrigger: "arcctg",
      parse: parseTrig("Arccot")
    },
    {
      // Variant, non-standard command
      latexTrigger: ["\\arcctg"],
      parse: parseTrig("Arccot")
    },
    {
      name: "Arccoth",
      identifierTrigger: "arccoth",
      parse: parseTrig("Arccoth")
    },
    {
      // Accept variant with `ar-` prefix
      identifierTrigger: "arcoth",
      parse: parseTrig("Arccoth")
    },
    {
      // Accept as identifier
      identifierTrigger: "arccoth",
      parse: parseTrig("Arccoth")
    },
    {
      // Accept variant with LaTeX command, even though it's not in ams-math
      latexTrigger: ["\\arccoth"],
      parse: parseTrig("Arccoth")
    },
    {
      name: "Arcsec",
      identifierTrigger: "arcsec",
      parse: parseTrig("Arcsec")
    },
    {
      // Variant, non-standard command
      latexTrigger: ["\\arcsec"],
      parse: parseTrig("Arcsec")
    },
    {
      name: "Arccsc",
      identifierTrigger: "arccsc",
      parse: parseTrig("Arccsc")
    },
    {
      // Variant, non-standard command
      latexTrigger: ["\\arccsc"],
      parse: parseTrig("Arccsc")
    },
    {
      name: "Arcsinh",
      identifierTrigger: "arcsinh",
      parse: parseTrig("Arcsinh")
    },
    {
      // Variant with `ar-` prefix, non-standard command
      latexTrigger: ["\\arsinh"],
      parse: parseTrig("Arcsinh")
    },
    {
      // Variant with `arc-` prefix, non-standard command
      latexTrigger: ["\\arcsinh"],
      parse: parseTrig("Arcsinh")
    },
    {
      name: "Arccosh",
      identifierTrigger: "arccosh",
      parse: parseTrig("Arccosh")
    },
    {
      // Variant, non-standard command
      latexTrigger: "\\arccosh",
      parse: parseTrig("Arccosh")
    },
    {
      // Variant, non-standard command, with `ar-` prefix
      latexTrigger: "\\arcosh",
      parse: parseTrig("Arccosh")
    },
    {
      // Variant, with `ar-` prefix
      identifierTrigger: "arcosh",
      parse: parseTrig("Arccosh")
    },
    {
      name: "Arctanh",
      identifierTrigger: "arctanh",
      parse: parseTrig("Arctanh")
    },
    {
      // Variant with `ar-` prefix
      identifierTrigger: "artanh",
      parse: parseTrig("Arctanh")
    },
    {
      // Variant
      latexTrigger: "\\artanh",
      parse: parseTrig("Arctanh")
    },
    {
      // Variant
      latexTrigger: ["\\arctanh"],
      parse: parseTrig("Arctanh")
    },
    {
      // Variant, with `ar-` prefix
      identifierTrigger: "artanh",
      parse: parseTrig("Arctanh")
    },
    {
      name: "Arcsech",
      identifierTrigger: "arcsech",
      parse: parseTrig("Arcsech")
    },
    {
      // Variant with `arc-` prefix
      latexTrigger: ["\\arcsech"],
      parse: parseTrig("Arcsech")
    },
    {
      // Variant with `ar-` prefix
      latexTrigger: ["\\arsech"],
      parse: parseTrig("Arcsech")
    },
    {
      name: "Arccsch",
      identifierTrigger: "arccsch",
      parse: parseTrig("Arccsch")
    },
    {
      // Variant, non-standard command
      latexTrigger: ["\\arccsch"],
      parse: parseTrig("Arccsch")
    },
    {
      // Variant, non-standard command, with `ar-` prefix
      latexTrigger: ["\\arcsch"],
      parse: parseTrig("Arccsch")
    },
    {
      name: "Cosec",
      identifierTrigger: "cosec",
      parse: parseTrig("Cosec")
    },
    {
      // Variant with non-standard command
      latexTrigger: ["\\cosec"],
      parse: parseTrig("Cosec")
    },
    {
      name: "Cosh",
      latexTrigger: ["\\cosh"],
      parse: parseTrig("Cosh")
    },
    {
      // Rusian hyperbolic cosine
      latexTrigger: ["\\ch"],
      parse: parseTrig("Cosh")
    },
    {
      name: "Cot",
      latexTrigger: ["\\cot"],
      parse: parseTrig("Cot")
    },
    {
      // Variant, non-standard command
      latexTrigger: ["\\cotg"],
      parse: parseTrig("Cot")
    },
    {
      // Rusian cotangent
      latexTrigger: ["\\ctg"],
      parse: parseTrig("Cot")
    },
    {
      name: "Csc",
      latexTrigger: ["\\csc"],
      parse: parseTrig("Csc")
    },
    {
      name: "Csch",
      latexTrigger: ["\\csch"],
      parse: parseTrig("Csch")
    },
    {
      name: "Coth",
      latexTrigger: ["\\coth"],
      parse: parseTrig("Coth")
    },
    {
      // Variant, non-standard command
      latexTrigger: ["\\cth"],
      parse: parseTrig("Coth")
    },
    {
      // Variant
      identifierTrigger: "cth",
      parse: parseTrig("Coth")
    },
    {
      // Variant, non-standard command
      latexTrigger: ["\\coth"],
      parse: parseTrig("Coth")
    },
    {
      name: "Sec",
      latexTrigger: ["\\sec"],
      parse: parseTrig("Sec")
    },
    {
      name: "Sech",
      identifierTrigger: "sech",
      parse: parseTrig("Sech")
    },
    {
      // Variant, non-standard command
      latexTrigger: ["\\sech"],
      parse: parseTrig("Sech")
    },
    {
      name: "Sinh",
      latexTrigger: ["\\sinh"],
      parse: parseTrig("Sinh")
    },
    {
      // Russian variant
      latexTrigger: ["\\sh"],
      parse: parseTrig("Sinh")
    },
    {
      name: "Tan",
      latexTrigger: ["\\tan"],
      parse: parseTrig("Tan")
    },
    {
      // Variant, non-standard command
      latexTrigger: ["\\tg"],
      parse: parseTrig("Tan")
    },
    {
      name: "Tanh",
      latexTrigger: ["\\tanh"],
      parse: parseTrig("Tanh")
    },
    {
      // Variant, non-standard command
      latexTrigger: ["\\th"],
      parse: parseTrig("Tanh")
    },
    {
      name: "Cos",
      latexTrigger: ["\\cos"],
      parse: parseTrig("Cos")
    },
    {
      name: "Sin",
      latexTrigger: ["\\sin"],
      parse: parseTrig("Sin")
    }
  ];

  // src/compute-engine/latex-syntax/dictionary/definitions-sets.ts
  var DEFINITIONS_SETS = [
    //
    // Constants
    //
    { name: "AlgebraicNumbers", latexTrigger: "\\overline\\Q" },
    { latexTrigger: "\\bar\\Q", parse: "AlgebraicNumbers" },
    { name: "ComplexNumbers", latexTrigger: ["\\C"] },
    { latexTrigger: "\\mathbb{C}", parse: "ComplexNumbers" },
    { name: "ImaginaryNumbers", latexTrigger: ["\\imaginaryI", "\\R"] },
    { name: "EmptySet", latexTrigger: ["\\emptyset"] },
    { latexTrigger: ["\\varnothing"], parse: "EmptySet" },
    // Parsing only
    { name: "Integers", latexTrigger: ["\\Z"] },
    { latexTrigger: "\\mathbb{Z}", parse: "Integers" },
    { name: "RationalNumbers", latexTrigger: ["\\Q"] },
    { latexTrigger: "\\mathbb{Q}", parse: "RationalNumbers" },
    { name: "RealNumbers", latexTrigger: ["\\R"] },
    { latexTrigger: "\\mathbb{R}", parse: "RealNumbers" },
    { name: "TranscendentalNumbers", latexTrigger: "\\R-\\bar\\Q" },
    { latexTrigger: "\\R\\backslash\\bar\\Q", parse: "TranscendentalNumbers" },
    // Real numbers < 0
    { name: "NegativeNumbers", latexTrigger: "\\R_{<0}" },
    { latexTrigger: "\\R^-", parse: "NegativeNumbers" },
    { latexTrigger: "\\R^{-}", parse: "NegativeNumbers" },
    { latexTrigger: "\\R^-", parse: "NegativeNumbers" },
    { latexTrigger: "\\R_-", parse: "NegativeNumbers" },
    { latexTrigger: "\\R_{-}", parse: "NegativeNumbers" },
    { latexTrigger: "\\R^{\\lt}", parse: "NegativeNumbers" },
    { latexTrigger: "\\R^{<}", parse: "NegativeNumbers" },
    { latexTrigger: "\\R^{\\lt0}", parse: "NegativeNumbers" },
    { latexTrigger: "\\R^{<0}", parse: "NegativeNumbers" },
    // Real numbers <= 0
    { name: "NonPositiveNumbers", latexTrigger: "\\R_{\\le0}" },
    { latexTrigger: "\\R^{\\leq0}", parse: "NonPositiveNumbers" },
    { latexTrigger: "\\R^{-0}", parse: "NonPositiveNumbers" },
    { latexTrigger: "\\R^{\\leq}", parse: "NonPositiveNumbers" },
    { latexTrigger: "\\R^{0-}", parse: "NonPositiveNumbers" },
    // Real numbers > 0
    { name: "PositiveNumbers", latexTrigger: "\\R_{>0}" },
    { latexTrigger: "\\R^+", parse: "PositiveNumbers" },
    { latexTrigger: "\\R^{+}", parse: "PositiveNumbers" },
    { latexTrigger: "\\R_+", parse: "PositiveNumbers" },
    { latexTrigger: "\\R_{+}", parse: "PositiveNumbers" },
    { latexTrigger: "\\R^{\\gt}", parse: "PositiveNumbers" },
    { latexTrigger: "\\R^{\\gt 0}", parse: "PositiveNumbers" },
    { latexTrigger: "\\R^{>}", parse: "PositiveNumbers" },
    { latexTrigger: "\\R^{>0}", parse: "PositiveNumbers" },
    // Real numbers >= 0
    { name: "NonNegativeNumbers", latexTrigger: "\\R_{\\geq0}" },
    { latexTrigger: "\\R^{0+}", parse: "NonNegativeNumbers" },
    { latexTrigger: "\\R^{\\geq}", parse: "NonNegativeNumbers" },
    // Extended Real numbers = \R \cup \{-\infty, +\infty\}
    { name: "ExtendedRealNumbers", latexTrigger: "\\overline\\R" },
    { latexTrigger: "\\bar\\R", parse: "ExtendedRealNumbers" },
    // Integers < 0
    { name: "NegativeIntegers", latexTrigger: "\\Z_{<0}" },
    { latexTrigger: "\\Z_{\\lt0}", parse: "NegativeIntegers" },
    { latexTrigger: "\\Z^-", parse: "NegativeIntegers" },
    { latexTrigger: "\\Z^{-}", parse: "NegativeIntegers" },
    { latexTrigger: "\\Z_-", parse: "NegativeIntegers" },
    { latexTrigger: "\\Z_{-}", parse: "NegativeIntegers" },
    { latexTrigger: "\\Z^{\\lt}", parse: "NegativeIntegers" },
    // Integers <= 0
    { name: "NonPositiveIntegers", latexTrigger: "\\Z_{\\le0}" },
    { latexTrigger: "\\Z_{\\leq0}", parse: "NonPositiveIntegers" },
    { latexTrigger: "\\Z_{<0}", parse: "NonPositiveIntegers" },
    // Integers >  0
    { name: "PositiveIntegers", latexTrigger: "\\N^*" },
    { latexTrigger: "\\Z_{>0}", parse: "PositiveIntegers" },
    { latexTrigger: "\\Z_{\\gt0}", parse: "PositiveIntegers" },
    { latexTrigger: "\\Z^{+}", parse: "PositiveIntegers" },
    { latexTrigger: "\\Z_+", parse: "PositiveIntegers" },
    { latexTrigger: "\\Z_{+}", parse: "PositiveIntegers" },
    { latexTrigger: "\\Z^{\\gt}", parse: "PositiveIntegers" },
    { latexTrigger: "\\Z^{\\gt0}", parse: "PositiveIntegers" },
    { latexTrigger: "\\N^+", parse: "PositiveIntegers" },
    { latexTrigger: "\\N^{+}", parse: "PositiveIntegers" },
    { latexTrigger: "\\N^*", parse: "PositiveIntegers" },
    { latexTrigger: "\\N^{*}", parse: "PositiveIntegers" },
    { latexTrigger: "\\N^\\star", parse: "PositiveIntegers" },
    { latexTrigger: "\\N^{\\star}", parse: "PositiveIntegers" },
    { latexTrigger: "\\N_1", parse: "PositiveIntegers" },
    { latexTrigger: "\\N_{1}", parse: "PositiveIntegers" },
    // https://mathvault.ca/hub/higher-math/math-symbols/algebra-symbols/
    // Integers >=  0
    // Note that 0 is included in $\N$, following the convention from
    // [ISO/IEC 80000](https://en.wikipedia.org/wiki/ISO_80000-2)
    { name: "NonNegativeIntegers", latexTrigger: ["\\N"] },
    { latexTrigger: "\\Z^{+0}", parse: "NonNegativeIntegers" },
    { latexTrigger: "\\Z^{\\geq}", parse: "NonNegativeIntegers" },
    { latexTrigger: "\\Z^{\\geq0}", parse: "NonNegativeIntegers" },
    { latexTrigger: "\\Z^{0+}", parse: "NonNegativeIntegers" },
    { latexTrigger: "\\mathbb{N}", parse: "NonNegativeIntegers" },
    { latexTrigger: "\\N_0", parse: "NonNegativeIntegers" },
    { latexTrigger: "\\N_{0}", parse: "NonNegativeIntegers" },
    // Extended Integers = \Z \cup \{-\infty, +\infty\}
    { name: "ExtendedIntegers", latexTrigger: "\\overline\\Z" },
    { latexTrigger: "\\bar\\Z", parse: "ExtendedIntegers" },
    // Extended Rationals = \Q \cup \{-\infty, +\infty\}
    { name: "ExtendedRationalNumbers", latexTrigger: "\\overline\\Q" },
    { latexTrigger: "\\bar\\Q", parse: "ExtendedRationalNumbers" },
    // Extended Complex Numbers = \C \cup \{-\infty, +\infty\}
    { name: "ExtendedComplexNumbers", latexTrigger: "\\overline\\C" },
    { latexTrigger: "\\bar\\C", parse: "ExtendedComplexNumbers" },
    //
    // Set Expressions
    //
    // @todo: could also have a `CartesianPower` function with a number `rhs`
    // {
    //   name: 'CartesianProduct',
    //   latexTrigger: ['\\times'],
    //   kind: 'infix',
    //   associativity: 'right', // Caution: cartesian product is not associative
    //   precedence: 390, // Same as Multiply?
    //   parse: (parser, lhs, until) => {
    //     if (390 < until.minPrec) return null;
    //     // Since this is triggered on `\times` we have to be careful we only
    //     // accept arguments that are `Set`
    //     const ce = parser.computeEngine!;
    //     if (!ce || !ce.box(lhs).domain?.isCompatible('Sets')) return null;
    //     const index = parser.index;
    //     const rhs = parser.parseExpression({ ...until, minPrec: 390 });
    //     // If the rhs argument is not a set, bail
    //     if (rhs === null || ce.box(lhs).domain?.isCompatible('Sets') !== true) {
    //       parser.index = index;
    //       return null;
    //     }
    //     return ['CartesianProduct', lhs, rhs];
    //   },
    // },
    {
      latexTrigger: ["^", "\\complement"],
      kind: "postfix",
      parse: (_parser, lhs) => {
        return ["Complement", lhs];
      }
      // precedence: 240,
      // @todo: serialize for the multiple argument case
    },
    {
      name: "Complement",
      latexTrigger: ["^", "<{>", "\\complement", "<}>"],
      kind: "postfix"
      // precedence: 240,
      // @todo: serialize for the multiple argument case
    },
    {
      name: "Intersection",
      latexTrigger: ["\\cap"],
      kind: "infix",
      precedence: 350
    },
    {
      name: "Interval",
      // @todo: parse opening '[' or ']' or '('
      serialize: serializeSet
    },
    {
      name: "Multiple",
      // @todo: parse
      serialize: serializeSet
    },
    {
      name: "Union",
      latexTrigger: ["\\cup"],
      kind: "infix",
      precedence: 350
    },
    {
      name: "Set",
      kind: "matchfix",
      openTrigger: "{",
      closeTrigger: "}",
      // @todo: the set syntax can also include conditions...
      parse: (_parser, body) => {
        if (isEmptySequence(body)) return "EmptySet";
        if (operator(body) == "Delimiter" && stringValue(operand(body, 2)) === ",") {
          body = operand(body, 1);
        }
        if (operator(body) !== "Sequence") return ["Set", body];
        return ["Set", ...operands(body)];
      },
      serialize: (serializer, expr) => {
        return joinLatex([
          "\\lbrace",
          operands(expr).map((x) => serializer.serialize(x)).join(", "),
          "\\rbrace"
        ]);
      }
    },
    {
      name: "SetMinus",
      latexTrigger: ["\\setminus"],
      kind: "infix",
      precedence: 650
    },
    {
      name: "SymmetricDifference",
      latexTrigger: ["\\triangle"],
      // or \\ominus
      kind: "infix",
      // @todo: parser could check that lhs and rhs are sets
      precedence: COMPARISON_PRECEDENCE
    },
    // Predicates/Relations
    {
      latexTrigger: ["\\ni"],
      kind: "infix",
      associativity: "none",
      precedence: 160,
      // As per MathML, lower precedence
      parse: (parser, lhs, terminator) => {
        const rhs = parser.parseExpression(terminator);
        return rhs === null ? null : ["Element", rhs, lhs];
      }
    },
    {
      name: "Element",
      latexTrigger: ["\\in"],
      kind: "infix",
      precedence: 240
    },
    {
      name: "NotElement",
      latexTrigger: ["\\notin"],
      kind: "infix",
      precedence: 240
    },
    {
      name: "NotSubset",
      latexTrigger: ["\\nsubset"],
      kind: "infix",
      associativity: "none",
      precedence: 240
    },
    {
      name: "NotSuperset",
      latexTrigger: ["\\nsupset"],
      kind: "infix",
      associativity: "none",
      precedence: 240
    },
    {
      name: "NotSubsetNotEqual",
      latexTrigger: ["\\nsubseteq"],
      kind: "infix",
      associativity: "none",
      precedence: 240
    },
    {
      name: "NotSupersetNotEqual",
      latexTrigger: ["\\nsupseteq"],
      kind: "infix",
      associativity: "none",
      precedence: 240
    },
    {
      name: "SquareSubset",
      // MathML: square image of
      latexTrigger: ["\\sqsubset"],
      kind: "infix",
      associativity: "none",
      precedence: 265
    },
    {
      name: "SquareSubsetEqual",
      // MathML: square image of or equal to
      latexTrigger: ["\\sqsubseteq"],
      kind: "infix",
      associativity: "none",
      precedence: 265
    },
    {
      name: "SquareSuperset",
      // MathML: square original of
      latexTrigger: ["\\sqsupset"],
      kind: "infix",
      associativity: "none",
      precedence: 265
    },
    {
      name: "SquareSupersetEqual",
      // MathML: square original of or equal
      latexTrigger: ["\\sqsupseteq"],
      kind: "infix",
      associativity: "none",
      precedence: 265
    },
    {
      name: "Subset",
      latexTrigger: ["\\subset"],
      kind: "infix",
      associativity: "none",
      precedence: 240
    },
    {
      latexTrigger: ["\\subsetneq"],
      kind: "infix",
      associativity: "none",
      precedence: 240,
      parse: "Subset"
    },
    {
      latexTrigger: ["\\varsubsetneqq"],
      kind: "infix",
      associativity: "none",
      precedence: 240,
      parse: "Subset"
    },
    {
      name: "SubsetEqual",
      latexTrigger: ["\\subseteq"],
      kind: "infix",
      associativity: "none",
      precedence: 240
    },
    {
      name: "Superset",
      latexTrigger: ["\\supset"],
      kind: "infix",
      associativity: "none",
      precedence: 240
    },
    {
      latexTrigger: ["\\supsetneq"],
      kind: "infix",
      associativity: "none",
      precedence: 240,
      parse: "Superset"
    },
    {
      latexTrigger: ["\\varsupsetneq"],
      kind: "infix",
      associativity: "none",
      precedence: 240,
      parse: "Superset"
    },
    {
      name: "SupersetEqual",
      latexTrigger: ["\\supseteq"],
      kind: "infix",
      associativity: "none",
      precedence: 240
    }
  ];
  function serializeSet(serializer, expr) {
    if (expr === null) return "";
    const h = operator(expr);
    if (!h) return "";
    if (h === "Set") {
      if (nops(expr) === 0) return "\\emptyset";
      if (nops(expr) === 2 && operator(operand(expr, 2)) === "Condition") {
        return joinLatex([
          "\\left\\lbrace",
          serializer.serialize(operand(expr, 1)),
          "\\middle\\mid",
          serializer.serialize(operand(expr, 2)),
          "\\right\\rbrace"
        ]);
      }
      return joinLatex([
        "\\left\\lbrace",
        ...operands(expr).map((x) => serializer.serialize(x) + " ,"),
        "\\right\\rbrace"
      ]);
    }
    if (h === "Multiple") {
    }
    if (h === "Range") {
      return joinLatex([
        "\\mathopen\\lbrack",
        serializer.serialize(operand(expr, 1)),
        ", ",
        serializer.serialize(operand(expr, 2)),
        "\\mathclose\\rbrack"
      ]);
    }
    if (h === "Interval") {
      let op1 = operand(expr, 1);
      let op2 = operand(expr, 2);
      let openLeft = false;
      let openRight = false;
      if (operator(op1) === "Open") {
        op1 = operand(op1, 1);
        openLeft = true;
      }
      if (operator(op2) === "Open") {
        op2 = operand(op2, 1);
        openRight = true;
      }
      return joinLatex([
        `\\mathopen${openLeft ? "\\rbrack" : "\\lbrack"}`,
        serializer.serialize(op1),
        ", ",
        serializer.serialize(op2),
        `\\mathclose${openRight ? "\\lbrack" : "\\rbrack"}`
      ]);
    }
    const style = serializer.numericSetStyle(expr, serializer.level);
    if (style === "compact") {
    } else if (style === "interval") {
    } else if (style === "regular") {
    } else if (style === "set-builder") {
    }
    return "";
  }

  // src/compute-engine/latex-syntax/dictionary/definitions-calculus.ts
  function parseIntegral(command, n = 1) {
    return (parser) => {
      parser.skipSpace();
      parser.match("\\limits");
      parser.skipSpace();
      let sup = null;
      let sub2 = null;
      while (!(sub2 !== null && sup !== null) && (parser.peek === "_" || parser.peek === "^")) {
        if (parser.match("_")) sub2 = parser.parseGroup() ?? parser.parseToken();
        else if (parser.match("^")) {
          sup = parser.parseGroup() ?? parser.parseToken();
        }
        parser.skipSpace();
      }
      if (isEmptySequence(sub2)) sub2 = null;
      if (isEmptySequence(sup)) sup = null;
      let [fn, index] = parseIntegralBody(parser, n);
      if (fn && !index) {
        if (operator(fn) === "Add" || operator(fn) === "Subtract") {
          const newOp = [];
          const rest = [];
          for (const op of operands(fn)) {
            if (index) rest.push(op);
            else {
              let op2;
              [op2, index] = parseIntegralBodyExpression(op);
              newOp.push(op2 ?? op);
            }
          }
          if (index !== null && rest.length > 0) {
            return [
              "Add",
              makeIntegral(
                parser,
                command,
                ["Add", ...newOp],
                [{ index, sub: sub2, sup }]
              ),
              ...rest
            ];
          }
        } else if (operator(fn) === "Divide") {
          let altNumerator;
          [altNumerator, index] = parseIntegralBodyExpression(operand(fn, 1));
          if (altNumerator !== null && index !== null) {
            fn = ["Divide", altNumerator, operand(fn, 2)];
          }
        }
      }
      return makeIntegral(parser, command, fn, [{ index, sub: sub2, sup }]);
    };
  }
  function makeIntegral(parser, command, fn, ranges) {
    if (fn && ranges.length === 0) return [command, fn];
    fn ?? (fn = "Nothing");
    parser.pushSymbolTable();
    for (const r of ranges) if (r.index) parser.addSymbol(r.index, "symbol");
    parser.popSymbolTable();
    return [command, fn, ...ranges.map((r) => makeRange(r))];
  }
  function makeRange(range2) {
    const heldIndex = range2.index ? ["Hold", range2.index] : "Nothing";
    if (range2.sup !== null)
      return ["Tuple", heldIndex, range2.sub ?? "Nothing", range2.sup];
    if (range2.sub !== null) return ["Tuple", heldIndex, range2.sub];
    return heldIndex;
  }
  function parseIntegralBody(parser, n = 1) {
    const start = parser.index;
    let found = false;
    let fn = parser.parseExpression({
      minPrec: 266,
      condition: () => {
        const start2 = parser.index;
        while (parser.match("\\cdot") || parser.match("\\,")) {
        }
        if (parser.matchAll(["\\mathrm", "<{>", "d", "<}>"])) found = true;
        else if (parser.matchAll(["\\operatorname", "<{>", "d", "<}>"]))
          found = true;
        if (!found) parser.index = start2;
        return found;
      }
    });
    if (!found) {
      parser.index = start;
      fn = parser.parseExpression({
        minPrec: 266,
        condition: () => {
          while (parser.match("\\cdot") || parser.match("\\,")) {
          }
          if (parser.match("d") || parser.match("\\differentialD")) found = true;
          return found;
        }
      });
    }
    if (fn !== null && !found) return parseIntegralBodyExpression(fn);
    const indexes2 = parseIndexes(parser, n);
    return [fn, indexes2[0] ?? null];
  }
  function parseIndexes(parser, _n = 1) {
    parser.skipSpace();
    const result = [];
    const index = symbol(parser.parseSymbol());
    if (index === null) return [];
    result.push(index);
    return result;
  }
  function parseIntegralBodyExpression(expr) {
    const h = operator(expr);
    const op1 = operand(expr, 1);
    if (!op1) return [expr, null];
    if (h === "Sequence" && nops(expr) === 1) {
      return parseIntegralBodyExpression(op1);
    }
    if (h === "Multiply" || h === "InvisibleOperator") {
      const args = operands(expr);
      if (args && args.length > 1) {
        const sym = symbol(args[args.length - 2]);
        if (sym === "d" || sym === "d_upright") {
          if (args.length === 2) return [null, symbol(args[1])];
          if (args.length === 3) return [args[0], symbol(args[2])];
          return [
            ["Multiply", ...args.slice(0, -2)],
            symbol(args[args.length - 1])
          ];
        }
        const [fn2, index] = parseIntegralBodyExpression(args[args.length - 1]);
        if (fn2) return [["Multiply", ...args.slice(0, -1), fn2], index];
      }
    } else if (h === "Delimiter") {
      const [fn2, index] = parseIntegralBodyExpression(op1);
      if (index) {
        if (!fn2) return [null, index];
        return [
          ["Delimiter", ["Sequence", fn2], ...operands(expr).slice(1)],
          index
        ];
      }
    } else if (h === "Add") {
      const args = operands(expr);
      if (args.length > 0) {
        const [fn2, index] = parseIntegralBodyExpression(args[args.length - 1]);
        if (index) {
          if (fn2) return [["Add", ...args.slice(0, -1), fn2], index];
          if (args.length > 2) return [["Add", ...args.slice(0, -1)], index];
          if (args.length > 2) return [args[0], index];
        }
      }
    } else if (h === "Negate") {
      const [fn2, index] = parseIntegralBodyExpression(op1);
      if (index) return [fn2 ? ["Negate", fn2] : null, index];
    } else if (h === "Divide") {
      const [fn2, index] = parseIntegralBodyExpression(op1);
      if (index) return [["Divide", fn2 ?? 1, operand(expr, 2)], index];
    } else {
      const args = operands(expr);
      if (args.length === 1) {
        const [arg2, index] = parseIntegralBodyExpression(args[0]);
        if (index) return [[operator(expr), arg2], index];
      }
    }
    return [expr, null];
  }
  function serializeIntegral(command) {
    return (serializer, expr) => {
      if (!operand(expr, 1)) return command;
      let arg = operand(expr, 2);
      const h = operator(arg);
      let indexExpr = null;
      if (h === "Tuple" || h === "Triple" || h === "Pair" || h === "Single") {
        indexExpr = operand(arg, 1);
      } else if (h === "Hold") {
        indexExpr = operand(arg, 1);
      } else {
        indexExpr = operand(arg, 1) ?? "x";
        arg = null;
      }
      if (operator(indexExpr) === "Hold") indexExpr = operand(indexExpr, 1);
      const index = indexExpr !== null ? symbol(indexExpr) : null;
      let fn = operand(expr, 1);
      if (operator(fn) === "Lambda" && operand(fn, 1) !== null)
        fn = subs(operand(fn, 1), { _: index ?? "x", _1: index ?? "x" });
      if (!arg) {
        if (!index || index === "Nothing")
          return joinLatex([command, "\\!", serializer.serialize(fn)]);
        return joinLatex([
          command,
          "\\!",
          serializer.serialize(fn),
          "\\,\\operatorname{d}",
          serializer.serialize(index)
        ]);
      }
      const subSymbol = operand(arg, 2) ? symbol(operand(arg, 2)) : null;
      let sub2 = arg && subSymbol !== "Nothing" ? serializer.serialize(operand(arg, 2)) : "";
      if (sub2.length > 0) sub2 = `_{${sub2}}`;
      let sup = "";
      const supSymbol = operand(arg, 3) ? symbol(operand(arg, 3)) : null;
      if (operand(arg, 3) !== null && supSymbol !== "Nothing")
        sup = `^{${serializer.serialize(operand(arg, 3))}}`;
      return joinLatex([
        command,
        sup,
        sub2,
        "\\!",
        serializer.serialize(fn),
        ...index && symbol(index) !== "Nothing" ? ["\\,\\operatorname{d}", serializer.serialize(index)] : []
      ]);
    };
  }
  var DEFINITIONS_CALCULUS = [
    {
      kind: "expression",
      name: "Integrate",
      latexTrigger: ["\\int"],
      parse: parseIntegral("Integrate"),
      serialize: serializeIntegral("\\int")
    },
    {
      kind: "expression",
      latexTrigger: ["\\iint"],
      parse: parseIntegral("Integrate", 2)
    },
    {
      kind: "expression",
      latexTrigger: ["\\iiint"],
      parse: parseIntegral("Integrate", 3)
    },
    {
      kind: "expression",
      name: "CircularIntegrate",
      latexTrigger: ["\\oint"],
      parse: parseIntegral("CircularIntegrate"),
      serialize: serializeIntegral("\\oint")
    },
    {
      kind: "expression",
      latexTrigger: ["\\oiint"],
      parse: parseIntegral("CircularIntegrate", 2)
    },
    {
      kind: "expression",
      latexTrigger: ["\\oiiint"],
      parse: parseIntegral("CircularIntegrate", 3)
    }
  ];

  // src/compute-engine/latex-syntax/dictionary/definitions-symbols.ts
  var SYMBOLS = [
    // Greek
    ["alpha", "\\alpha", 945],
    ["beta", "\\beta", 946],
    ["gamma", "\\gamma", 947],
    ["delta", "\\delta", 948],
    ["epsilon", "\\epsilon", 949],
    ["epsilonSymbol", "\\varepsilon", 1013],
    // GREEK LUNATE EPSILON SYMBOL
    ["zeta", "\\zeta", 950],
    ["eta", "\\eta", 951],
    ["theta", "\\theta", 952],
    ["thetaSymbol", "\\vartheta", 977],
    // Unicode GREEK THETA SYMBOL
    ["iota", "\\iota", 953],
    ["kappa", "\\kappa", 954],
    ["kappaSymbol", "\\varkappa", 1008],
    // GREEK KAPPA SYMBOL
    ["lambda", "\\lambda", 955],
    ["mu", "\\mu", 956],
    ["nu", "\\nu", 957],
    ["xi", "\\xi", 958],
    ["omicron", "\\omicron", 959],
    ["pi", "\\pi", 960],
    ["piSymbol", "\\varpi", 982],
    // GREEK PI SYMBOL
    ["rho", "\\rho", 961],
    ["rhoSymbol", "\\varrho", 1009],
    // GREEK RHO SYMBOL
    ["sigma", "\\sigma", 963],
    ["finalSigma", "\\varsigma", 962],
    //GREEK SMALL LETTER FINAL SIGMA
    ["tau", "\\tau", 964],
    ["phi", "\\phi", 981],
    // Note GREEK PHI SYMBOL, but common usage in math
    ["phiLetter", "\\varphi", 966],
    ["upsilon", "\\upsilon", 965],
    ["chi", "\\chi", 967],
    ["psi", "\\psi", 968],
    ["omega", "\\omega", 969],
    ["Alpha", "\\Alpha", 913],
    ["Beta", "\\Beta", 914],
    ["Gamma", "\\Gamma", 915],
    ["Delta", "\\Delta", 916],
    ["Epsilon", "\\Epsilon", 917],
    ["Zeta", "\\Zeta", 918],
    ["Eta", "\\Eta", 919],
    ["Theta", "\\Theta", 920],
    ["Iota", "\\Iota", 921],
    ["Kappa", "\\Kappa", 922],
    ["Lambda", "\\Lambda", 923],
    ["Mu", "\\Mu", 924],
    ["Nu", "\\Nu", 925],
    ["Xi", "\\Xi", 926],
    ["Omicron", "\\Omicron", 927],
    // ['Pi', '\\Pi', 0x03a0],
    ["Rho", "\\Rho", 929],
    ["Sigma", "\\Sigma", 931],
    ["Tau", "\\Tau", 932],
    ["Phi", "\\Phi", 934],
    ["Upsilon", "\\Upsilon", 933],
    ["Chi", "\\Chi", 935],
    ["Psi", "\\Psi", 936],
    ["Omega", "\\Omega", 937],
    ["digamma", "\\digamma", 989],
    // Hebrew
    ["aleph", "\\aleph", 8501],
    // Unicode ALEF SYMBOL
    ["bet", "\\beth", 8502],
    ["gimel", "\\gimel", 8503],
    ["dalet", "\\daleth", 8504],
    // Letter-like
    ["ell", "\\ell", 8499],
    // Unicode SCRIPT SMALL L
    ["turnedCapitalF", "\\Finv", 8498],
    // Unicode TURNED CAPITAL F'
    ["turnedCapitalG", "\\Game", 8513],
    // TURNED SANS-SERIF CAPITAL G
    ["weierstrass", "\\wp", 8472],
    // Unicode SCRIPT CAPITAL P
    ["eth", "\\eth", 240],
    ["invertedOhm", "\\mho", 8487],
    // Unicode INVERTED OHM SIGN
    ["hBar", "\\hbar", 295],
    // Unicode LATIN SMALL LETTER H WITH STROKE
    ["hSlash", "\\hslash", 8463],
    // Unicode PLANCK CONSTANT OVER TWO PI
    // Symbols
    ["blackClubSuit", "\\clubsuit", 9827],
    ["whiteHeartSuit", "\\heartsuit", 9825],
    ["blackSpadeSuit", "\\spadesuit", 9824],
    ["whiteDiamondSuit", "\\diamondsuit", 9826],
    ["sharp", "\\sharp", 9839],
    ["flat", "\\flat", 9837],
    ["natural", "\\natural", 9838]
  ];
  var DEFINITIONS_SYMBOLS = [
    ...SYMBOLS.map(([symbol2, latex, _codepoint]) => {
      return {
        kind: "symbol",
        name: symbol2,
        latexTrigger: [latex],
        parse: symbol2
      };
    }),
    ...SYMBOLS.map(([symbol2, _latex, codepoint]) => {
      return {
        kind: "symbol",
        latexTrigger: [String.fromCodePoint(codepoint)],
        parse: symbol2
      };
    })
  ];

  // src/compute-engine/latex-syntax/dictionary/definitions-complex.ts
  var DEFINITIONS_COMPLEX = [
    {
      name: "Real",
      kind: "function",
      latexTrigger: ["\\Re"]
    },
    {
      name: "Imaginary",
      kind: "function",
      latexTrigger: ["\\Im"]
    },
    {
      name: "Argument",
      kind: "function",
      latexTrigger: ["\\arg"]
    },
    {
      name: "Conjugate",
      latexTrigger: ["^", "\\star"],
      kind: "postfix"
    }
  ];

  // src/compute-engine/latex-syntax/dictionary/definitions-statistics.ts
  var DEFINITIONS_STATISTICS = [
    {
      name: "Mean",
      kind: "function",
      identifierTrigger: "mean"
    },
    {
      name: "Median",
      kind: "function",
      identifierTrigger: "median"
    },
    {
      name: "StandarDeviation",
      kind: "function",
      identifierTrigger: "stddev"
    },
    {
      latexTrigger: ["\\bar"],
      kind: "expression",
      parse: (parser, _until) => {
        const expr = parser.parseGroup() ?? parser.parseToken();
        if (!expr || !symbol(expr)) return null;
        return ["Mean", expr];
      }
    }
  ];

  // src/compute-engine/latex-syntax/dictionary/definitions.ts
  function isIndexedSymbolEntry(entry) {
    return "kind" in entry && entry.kind === "symbol";
  }
  function isIndexedExpressionEntry(entry) {
    return "kind" in entry && entry.kind === "expression";
  }
  function isIndexedFunctionEntry(entry) {
    return "kind" in entry && entry.kind === "function";
  }
  function isIndexedMatchfixEntry(entry) {
    return "kind" in entry && entry.kind === "matchfix";
  }
  function isIndexedInfixdEntry(entry) {
    return "kind" in entry && entry.kind === "infix";
  }
  function isIndexedPrefixedEntry(entry) {
    return "kind" in entry && entry.kind === "prefix";
  }
  function isIndexedPostfixEntry(entry) {
    return "kind" in entry && entry.kind === "postfix";
  }
  function isIndexedEnvironmentEntry(entry) {
    return "kind" in entry && entry.kind === "environment";
  }
  var DEFAULT_DELIMITER = {
    "(": "(",
    ")": ")",
    "[": "\\lbrack",
    "]": "\\rbrack",
    "{": "\\lbrace",
    "}": "\\rbrace",
    "<": "\\langle",
    ">": "\\rangle",
    "|": "\\vert",
    "||": "\\Vert",
    "\\lceil": "\\lceil",
    "\\lfloor": "\\lfloor",
    "\\rceil": "\\rceil",
    "\\rfloor": "\\rfloor"
  };
  function addEntry(result, entry, onError) {
    const indexedEntry = makeIndexedEntry(entry, onError);
    if (indexedEntry === null) return;
    const kind = "kind" in entry ? entry.kind : "expression";
    const latexTrigger = indexedEntry.latexTrigger;
    if (typeof latexTrigger === "string")
      result.lookahead = Math.max(result.lookahead, countTokens(latexTrigger));
    const tokensTrigger = tokenize(latexTrigger ?? "");
    if (tokensTrigger.length === 2 && /[_^]/.test(tokensTrigger[0]) && tokensTrigger[1] !== "<{>" && kind !== "function" && kind !== "environment" && kind !== "matchfix") {
      let parse3 = entry.parse;
      if (!parse3 && entry.name) {
        if (kind === "postfix" || kind === "prefix")
          parse3 = (_parser, expr) => [entry.name, expr];
        else parse3 = entry.name;
      }
      addEntry(
        result,
        {
          ...entry,
          kind,
          name: void 0,
          serialize: void 0,
          parse: parse3,
          latexTrigger: [tokensTrigger[0], "<{>", tokensTrigger[1], "<}>"]
        },
        onError
      );
    }
    result.defs.push(indexedEntry);
    if (indexedEntry.name !== void 0) {
      if (result.ids.has(indexedEntry.name)) {
        onError({
          severity: "warning",
          message: [
            "invalid-dictionary-entry",
            indexedEntry.name,
            "Duplicate definition. The name (MathJSON identifier) must be unique, but triggers can be shared by multiple definitions."
          ]
        });
      }
      result.ids.set(indexedEntry.name, indexedEntry);
    }
  }
  function indexLatexDictionary(dic, onError) {
    const result = {
      lookahead: 1,
      ids: /* @__PURE__ */ new Map(),
      defs: []
    };
    for (const entry of dic)
      addEntry(result, entry, onError);
    return result;
  }
  function makeIndexedEntry(entry, onError) {
    if (!isValidEntry(entry, onError)) return null;
    const result = {
      kind: "kind" in entry ? entry.kind : "expression"
    };
    let tokensTrigger = null;
    if ("latexTrigger" in entry) {
      if (typeof entry.latexTrigger === "string")
        tokensTrigger = tokenize(entry.latexTrigger);
      else tokensTrigger = entry.latexTrigger;
    }
    let idTrigger = null;
    if ("identifierTrigger" in entry) {
      idTrigger = entry.identifierTrigger;
    }
    if (tokensTrigger !== null)
      result.latexTrigger = tokensToString(tokensTrigger);
    if (idTrigger !== null) result.identifierTrigger = idTrigger;
    if (entry.name) {
      result.name = entry.name;
      result.serialize = makeSerializeHandler(entry, tokensTrigger, idTrigger);
    }
    if (result.kind === "matchfix" && isMatchfixEntry(entry)) {
      result.openTrigger = entry.openTrigger;
      result.closeTrigger = entry.closeTrigger;
    }
    if (result.kind === "symbol" && isSymbolEntry(entry)) {
      result.precedence = entry.precedence ?? 1e4;
    }
    if (result.kind === "expression" && isExpressionEntry(entry)) {
      result.precedence = entry.precedence ?? 1e4;
    }
    if ((result.kind === "prefix" || result.kind === "postfix") && (isPrefixEntry(entry) || isPostfixEntry(entry))) {
      if (tokensTrigger && (tokensTrigger[0] === "^" || tokensTrigger[0] === "_")) {
        result.precedence = 720;
        console.assert(
          entry.precedence === void 0,
          "'precedence' is fixed and cannot be modified with ^ and _ triggers"
        );
      } else result.precedence = entry.precedence ?? 1e4;
    }
    if (result.kind === "infix" && isInfixEntry(entry)) {
      console.assert(
        !tokensTrigger || tokensTrigger[0] !== "^" && tokensTrigger[0] !== "_" || !entry.associativity || entry.associativity === "none"
      );
      result.associativity = entry.associativity ?? "none";
      result.precedence = entry.precedence ?? 1e4;
    }
    const parse3 = makeParseHandler(entry, tokensTrigger, idTrigger);
    if (parse3) result.parse = parse3;
    return result;
  }
  function makeSerializeHandler(entry, latexTrigger, idTrigger) {
    if (typeof entry.serialize === "function") return entry.serialize;
    const kind = entry["kind"] ?? "expression";
    if (kind === "environment") {
      const envName = entry["identifierTrigger"] ?? entry.name ?? "unknown";
      return (serializer, expr) => joinLatex([
        `\\begin{${envName}}`,
        serializer.serialize(operand(expr, 1)),
        `\\end{${envName}}`
      ]);
    }
    if (isMatchfixEntry(entry)) {
      const openDelim = typeof entry.openTrigger === "string" ? DEFAULT_DELIMITER[entry.openTrigger] : tokensToString(entry.openTrigger);
      const closeDelim = typeof entry.closeTrigger === "string" ? DEFAULT_DELIMITER[entry.closeTrigger] : tokensToString(entry.closeTrigger);
      return (serializer, expr) => joinLatex([
        openDelim,
        serializer.serialize(operand(expr, 1)),
        closeDelim
      ]);
    }
    let latex = entry.serialize;
    if (latex === void 0 && latexTrigger) latex = tokensToString(latexTrigger);
    if (latex) {
      if (kind === "postfix")
        return (serializer, expr) => joinLatex([serializer.serialize(operand(expr, 1)), latex]);
      if (kind === "prefix")
        return (serializer, expr) => joinLatex([latex, serializer.serialize(operand(expr, 1))]);
      if (kind === "infix") {
        return (serializer, expr) => {
          const n = nops(expr);
          if (n === 0) return "";
          const prec = entry["precedence"] ?? 1e4;
          return joinLatex(
            operands(expr).flatMap((val, i) => {
              const arg = serializer.wrap(val, prec + 1);
              return i < n - 1 ? [arg, latex] : [arg];
            })
          );
        };
      }
      return (serializer, expr) => operator(expr) ? joinLatex([latex, serializer.wrapArguments(expr)]) : latex;
    }
    const id = idTrigger ?? entry.name ?? "unknown";
    if (kind === "postfix")
      return (serializer, expr) => joinLatex([
        serializer.serialize(operand(expr, 1)),
        serializer.serializeSymbol(id)
      ]);
    if (kind === "prefix")
      return (serializer, expr) => joinLatex([
        serializer.serializeSymbol(id),
        serializer.serialize(operand(expr, 1))
      ]);
    if (kind === "infix")
      return (serializer, expr) => joinLatex([
        serializer.serialize(operand(expr, 1)),
        serializer.serializeSymbol(id),
        serializer.serialize(operand(expr, 2))
      ]);
    return (serializer, expr) => operator(expr) ? joinLatex([
      serializer.serializeSymbol(id),
      serializer.wrapArguments(expr)
    ]) : serializer.serializeSymbol(id);
  }
  function makeParseHandler(entry, latexTrigger, idTrigger) {
    if ("parse" in entry && typeof entry.parse === "function") return entry.parse;
    const kind = ("kind" in entry ? entry.kind : "expression") ?? "expression";
    if (kind === "environment") {
      const envName = entry.parse ?? entry.name ?? idTrigger;
      if (envName)
        return (parser, _until) => {
          const array = parser.parseTabular();
          if (array === null) return null;
          return [envName, ["List", array.map((row) => ["List", ...row])]];
        };
    }
    if (kind === "function") {
      const fnName = entry.parse ?? entry.name ?? idTrigger;
      if (fnName)
        return (parser, until) => {
          const args = parser.parseArguments("enclosure", until);
          return args === null ? fnName : [fnName, ...args];
        };
    }
    if (kind === "symbol") {
      const symName = entry.parse ?? entry.name ?? idTrigger;
      if (symName) return (_parser, _terminator) => symName;
    }
    if (kind === "prefix") {
      const h = entry.parse ?? entry.name ?? idTrigger;
      if (h) {
        const prec = entry["precedence"] ?? 1e4;
        return (parser, until) => {
          const rhs = parser.parseExpression({
            ...until ?? [],
            minPrec: prec
          });
          return rhs === null ? null : [h, rhs];
        };
      }
    }
    if (kind === "postfix") {
      const h = entry.parse ?? entry.name;
      if (h) return (_parser, lhs) => lhs === null ? null : [h, lhs];
    }
    if (kind === "infix") {
      if (/[_^]/.test(latexTrigger?.[0] ?? "")) {
        const h2 = entry.name ?? entry.parse;
        return (_parser, arg) => [
          h2,
          missingIfEmpty(operand(arg, 1)),
          missingIfEmpty(operand(arg, 2))
        ];
      }
      const h = entry.parse ?? entry.name ?? idTrigger;
      if (h) {
        const prec = entry["precedence"] ?? 1e4;
        const associativity = entry["associativity"] ?? "none";
        if (associativity === "none") {
          return (parser, lhs, until) => {
            if (lhs === null) return null;
            const rhs = missingIfEmpty(
              parser.parseExpression({ ...until, minPrec: prec })
            );
            return [h, lhs, rhs];
          };
        }
        if (associativity === "left") {
          return (parser, lhs, until) => {
            if (lhs === null) return null;
            const rhs = missingIfEmpty(
              parser.parseExpression({ ...until, minPrec: prec + 1 })
            );
            if (typeof h !== "string") return [h, lhs, rhs];
            return [h, lhs, rhs];
          };
        }
        if (associativity === "right") {
          return (parser, lhs, until) => {
            if (lhs === null) return null;
            const rhs = missingIfEmpty(
              parser.parseExpression({ ...until, minPrec: prec })
            );
            if (typeof h !== "string") return [h, lhs, rhs];
            return [h, lhs, rhs];
          };
        }
        return (parser, lhs, until) => {
          if (lhs === null) return null;
          const rhs = missingIfEmpty(
            parser.parseExpression({ ...until, minPrec: prec })
          );
          if (typeof h !== "string") return [h, lhs, rhs];
          return foldAssociativeOperator(h, lhs, rhs);
        };
      }
    }
    if (kind === "matchfix") {
      const h = entry.parse ?? entry.name;
      if (h)
        return (_parser, body) => {
          if (isEmptySequence(body)) return null;
          return [h, body];
        };
    }
    if (kind === "expression") {
      const parseResult = entry.parse ?? entry.name ?? idTrigger;
      if (parseResult) return () => parseResult;
    }
    if ("parse" in entry) {
      const parseResult = entry.parse;
      return () => parseResult;
    }
    return void 0;
  }
  function isValidEntry(entry, onError) {
    let subject = entry.name ?? entry["latexTrigger"] ?? entry["identifierTrigger"] ?? entry["openTrigger"];
    if (!subject) {
      try {
        subject = JSON.stringify(entry);
      } catch (e) {
        subject = "???";
      }
    }
    if (Array.isArray(subject)) subject = tokensToString(subject);
    if ("trigger" in entry) {
      onError({
        severity: "warning",
        message: [
          "invalid-dictionary-entry",
          subject,
          `The 'trigger' property is deprecated. Use 'latexTrigger' or 'identifierTrigger' instead`
        ]
      });
    }
    if ("kind" in entry && ![
      "expression",
      "symbol",
      "function",
      "infix",
      "postfix",
      "prefix",
      "matchfix",
      "environment"
    ].includes(entry.kind)) {
      onError({
        severity: "warning",
        message: [
          "invalid-dictionary-entry",
          subject,
          `The 'kind' property must be one of 'expression', 'symbol', 'function', 'infix', 'postfix', 'prefix', 'matchfix', 'environment'`
        ]
      });
    }
    if (entry.serialize !== void 0 && !entry.name) {
      onError({
        severity: "warning",
        message: [
          "invalid-dictionary-entry",
          subject,
          `A 'name' property must be provided if a 'serialize' handler is provided`
        ]
      });
      return false;
    }
    if ("identifierTrigger" in entry && (!("kind" in entry) || entry.kind !== "environment")) {
      if (typeof entry.identifierTrigger !== "string" || !isValidIdentifier(entry.identifierTrigger)) {
        onError({
          severity: "warning",
          message: [
            "invalid-dictionary-entry",
            subject,
            `The 'identifierTrigger' property must be a valid identifier`
          ]
        });
      }
    }
    if ("name" in entry) {
      if (typeof entry.name !== "string") {
        if (entry.name !== void 0)
          onError({
            severity: "warning",
            message: [
              "invalid-dictionary-entry",
              subject,
              `The 'name' property must be a string`
            ]
          });
      } else if (!isValidIdentifier(entry.name)) {
        onError({
          severity: "warning",
          message: [
            "invalid-dictionary-entry",
            entry.name,
            `The 'name' property must be a valid identifier`
          ]
        });
      }
    }
    if (isMatchfixEntry(entry)) {
      if ("latexTrigger" in entry || "identifierTrigger" in isPrefixEntry) {
        onError({
          severity: "warning",
          message: [
            "invalid-dictionary-entry",
            subject,
            `'matchfix' operators use a 'openTrigger' and 'closeTrigger' instead of a 'latexTrigger' or 'identifierTrigger'. `
          ]
        });
        return false;
      }
      if (!entry.openTrigger || !entry.closeTrigger) {
        onError({
          severity: "warning",
          message: [
            "invalid-dictionary-entry",
            subject,
            "Expected `openTrigger` and a `closeTrigger` for matchfix operator"
          ]
        });
        return false;
      }
      if (typeof entry.openTrigger !== typeof entry.closeTrigger) {
        onError({
          severity: "warning",
          message: [
            "invalid-dictionary-entry",
            subject,
            "Expected `openTrigger` and `closeTrigger` to both be strings or array of LatexToken"
          ]
        });
        return false;
      }
    }
    if (isInfixEntry(entry) || isPostfixEntry(entry) || isPrefixEntry(entry)) {
      if (Array.isArray(entry.latexTrigger) && (entry.latexTrigger[0] === "_" || entry.latexTrigger[0] === "^") || typeof entry.latexTrigger === "string" && (entry.latexTrigger.startsWith("^") || entry.latexTrigger.startsWith("_"))) {
        if (entry.precedence !== void 0 || entry["associativity"] !== void 0) {
          onError({
            severity: "warning",
            message: [
              "invalid-dictionary-entry",
              subject,
              `Unexpected "precedence" or "associativity" for superscript/subscript operator`
            ]
          });
          return false;
        }
      } else if (entry.precedence === void 0) {
        onError({
          severity: "warning",
          message: [
            "invalid-dictionary-entry",
            subject,
            `Expected a "precedence" for ${entry.kind} operator`
          ]
        });
        return false;
      }
    } else {
      if (entry["associativity"] !== void 0) {
        onError({
          severity: "warning",
          message: [
            "invalid-dictionary-entry",
            subject,
            'Unexpected "associativity" operator'
          ]
        });
        return false;
      }
    }
    if (!isMatchfixEntry(entry) && !isEnvironmentEntry(entry)) {
      if (!entry.latexTrigger && !entry.identifierTrigger && !entry.name) {
        onError({
          severity: "warning",
          message: [
            "invalid-dictionary-entry",
            subject,
            `Expected a 'name', a 'latexTrigger' or a 'identifierTrigger'`
          ]
        });
        return false;
      }
    }
    if (entry["parse"] === void 0 && entry.name === void 0) {
      onError({
        severity: "warning",
        message: [
          "invalid-dictionary-entry",
          subject,
          `Expected a 'parse' or 'name'`
        ]
      });
      return false;
    }
    return true;
  }
  var DEFAULT_LATEX_DICTIONARY = {
    "symbols": DEFINITIONS_SYMBOLS,
    "algebra": DEFINITIONS_ALGEBRA,
    "arithmetic": DEFINITIONS_ARITHMETIC,
    "calculus": DEFINITIONS_CALCULUS,
    "complex": DEFINITIONS_COMPLEX,
    "core": DEFINITIONS_CORE,
    "linear-algebra": DEFINITIONS_LINEAR_ALGEBRA,
    "logic": DEFINITIONS_LOGIC,
    "relop": DEFINITIONS_INEQUALITIES,
    "other": DEFINITIONS_OTHERS,
    "physics": [
      {
        name: "mu0",
        kind: "symbol",
        latexTrigger: "\\mu_0"
      }
    ],
    "sets": DEFINITIONS_SETS,
    "statistics": DEFINITIONS_STATISTICS,
    "trigonometry": DEFINITIONS_TRIGONOMETRY
  };
  function getLatexDictionary(category = "all") {
    if (category === "all") {
      const result = [];
      for (const domain of Object.keys(DEFAULT_LATEX_DICTIONARY))
        if (DEFAULT_LATEX_DICTIONARY[domain])
          result.push(...DEFAULT_LATEX_DICTIONARY[domain]);
      return result;
    }
    if (!DEFAULT_LATEX_DICTIONARY[category]) return [];
    return Object.freeze([
      ...DEFAULT_LATEX_DICTIONARY[category]
    ]);
  }

  // src/compute-engine/tensor/tensor-fields.ts
  function makeTensorField(ce, dtype) {
    switch (dtype) {
      case "float64":
      case "float32":
      case "int32":
      case "uint8":
        return new TensorFieldNumber(ce);
      case "complex128":
      case "complex64":
        return new TensorFieldComplex(ce);
      case "bool":
      case "string":
      case "expression":
        return new TensorFieldExpression(ce);
    }
    throw new Error(`Unknown dtype ${dtype}`);
  }
  var TensorFieldNumber = class {
    constructor(ce) {
      this.ce = ce;
      this.one = 1;
      this.zero = 0;
      this.nan = NaN;
    }
    cast(x, dtype) {
      const ce = this.ce;
      switch (dtype) {
        case "float64":
        case "float32":
        case "int32":
        case "uint8":
          return x;
        case "complex128":
        case "complex64":
          return Array.isArray(x) ? x.map((x2) => ce.complex(x2)) : this.ce.complex(x);
        case "bool":
          return Array.isArray(x) ? x.map((x2) => x2 === 0 ? false : true) : x === 0 ? false : true;
        case "string":
          return Array.isArray(x) ? x.map((x2) => Number(x2).toString()) : Number(x).toString();
        case "expression":
          return Array.isArray(x) ? x.map((x2) => ce.number(x2)) : ce.number(x);
      }
      throw new Error(`Cannot cast ${x} to ${dtype}`);
    }
    expression(x) {
      return this.ce.number(x);
    }
    isZero(x) {
      return x === 0;
    }
    isOne(x) {
      return x === 1;
    }
    equals(lhs, rhs) {
      return lhs === rhs;
    }
    add(lhs, rhs) {
      return lhs + rhs;
    }
    addn(...xs) {
      return xs.reduce((a, b) => a + b, 0);
    }
    neg(x) {
      return -x;
    }
    sub(lhs, rhs) {
      return lhs - rhs;
    }
    mul(lhs, rhs) {
      return lhs * rhs;
    }
    muln(...xs) {
      return xs.reduce((a, b) => a * b, 1);
    }
    div(lhs, rhs) {
      return lhs / rhs;
    }
    pow(lhs, rhs) {
      return lhs ** rhs;
    }
    conjugate(x) {
      return x;
    }
  };
  var TensorFieldExpression = class {
    constructor(ce) {
      this.one = ce.One;
      this.zero = ce.Zero;
      this.nan = ce.NaN;
      this.ce = ce;
    }
    cast(x, dtype) {
      if (Array.isArray(x)) return x.map((x2) => this.cast(x2, dtype));
      const v = x.value;
      switch (dtype) {
        case "float64":
        case "float32":
          return typeof v === "number" ? v : void 0;
        case "int32":
          return typeof v === "number" ? Math.round(v) : void 0;
        case "uint8":
          if (typeof v !== "number") return void 0;
          const i = Math.round(v);
          return i >= 0 && i <= 255 ? i : void 0;
        case "complex128":
        case "complex64":
          if (typeof v === "number") return this.ce.complex(v);
          if (!isNaN(x.im)) return this.ce.complex(x.re, x.im);
          return void 0;
        case "bool":
          return typeof v === "boolean" ? v : void 0;
        case "string":
          return typeof v === "string" ? v : void 0;
        case "expression":
          return x;
      }
      throw new Error(`Cannot cast ${x} to ${dtype}`);
    }
    expression(x) {
      return x;
    }
    isZero(x) {
      return x.is(0);
    }
    isOne(x) {
      return x.is(1);
    }
    equals(lhs, rhs) {
      return lhs.isSame(rhs) === true;
    }
    add(lhs, rhs) {
      return lhs.add(rhs);
    }
    addn(...xs) {
      return add3(...xs);
    }
    neg(x) {
      return x.neg();
    }
    sub(lhs, rhs) {
      return lhs.sub(rhs);
    }
    mul(lhs, rhs) {
      return lhs.mul(rhs);
    }
    muln(...xs) {
      return mul3(...xs);
    }
    div(lhs, rhs) {
      return lhs.div(rhs);
    }
    pow(lhs, rhs) {
      return lhs.pow(rhs);
    }
    conjugate(x) {
      return this.ce.function("Conjugate", [x]).evaluate();
    }
  };
  var TensorFieldComplex = class {
    constructor(ce) {
      this.ce = ce;
      this.one = ce.complex(1);
      this.zero = ce.complex(0);
      this.nan = ce.complex(NaN);
    }
    cast(x, dtype) {
      if (Array.isArray(x)) {
        return x.map((x2) => this.cast(x2, dtype));
      }
      switch (dtype) {
        case "float64":
          return x.im === 0 ? x.re : void 0;
        case "float32":
          return x.im === 0 ? x.re : void 0;
        case "int32":
          return x.im === 0 ? Math.round(x.re) : void 0;
        case "uint8":
          if (x.im !== 0) return void 0;
          const i = Math.round(x.re);
          return i >= 0 && i <= 255 ? i : void 0;
        case "complex128":
          return x;
        case "complex64":
          return x;
        case "bool":
          return x.im === 0 && x.re === 0 ? false : true;
        case "string":
          return x.toString();
        case "expression":
          return this.ce.number(x);
      }
      throw new Error(`Cannot cast ${x} to ${dtype}`);
    }
    expression(z) {
      return this.ce.number(z);
    }
    isZero(z) {
      return z.isZero();
    }
    isOne(z) {
      return z.re === 1 && z.im === 0;
    }
    equals(lhs, rhs) {
      return lhs.equals(rhs);
    }
    add(lhs, rhs) {
      return lhs.add(rhs);
    }
    addn(...xs) {
      return xs.reduce((a, b) => a.add(b), this.zero);
    }
    neg(z) {
      return z.neg();
    }
    sub(lhs, rhs) {
      return lhs.sub(rhs);
    }
    mul(lhs, rhs) {
      return lhs.mul(rhs);
    }
    muln(...xs) {
      return xs.reduce((a, b) => a.mul(b), this.one);
    }
    div(lhs, rhs) {
      return lhs.div(rhs);
    }
    pow(lhs, rhs) {
      return lhs.pow(rhs);
    }
    conjugate(z) {
      return z.conjugate();
    }
  };
  function getSupertype(t1, t2) {
    if (t1 === void 0) return t2;
    if (t1 === t2) return t1;
    if (t1 === "expression" || t2 === "expression") return "expression";
    if (t1 === "string" || t2 === "string") return "expression";
    if (t1 === "complex128" || t2 === "complex128") return "complex128";
    if (t1 === "complex64" || t2 === "complex64") return "complex64";
    if (t1 === "float64" || t2 === "float64") return "float64";
    if (t1 === "float32" || t2 === "float32") return "float32";
    if (t1 === "int32" || t2 === "int32") return "int32";
    if (t1 === "uint8" || t2 === "uint8") return "uint8";
    if (t1 === "bool" || t2 === "bool") return "bool";
    return "expression";
  }
  function getExpressionDatatype(expr) {
    if (isRelationalOperator(expr)) return "bool";
    if (!expr.isNumberLiteral) return "expression";
    switch (expr.type.type) {
      case "real":
      case "rational":
      case "finite_real":
      case "finite_rational":
      case "integer":
        return "float64";
      case "complex":
      case "finite_complex":
      case "imaginary":
        return "complex128";
      case "finite_integer": {
        const val = expr.re;
        if (val >= 0 && val <= 255) return "uint8";
        return "int32";
      }
      case "boolean":
        return "bool";
      case "string":
        return "string";
      default:
        return "expression";
    }
  }

  // src/compute-engine/tensor/tensors.ts
  var AbstractTensor = class _AbstractTensor {
    constructor(ce, tensorData) {
      this.ce = ce;
      this.shape = tensorData.shape;
      this.rank = this.shape.length;
      this._strides = getStrides(this.shape);
      this.field = makeTensorField(ce, tensorData.dtype);
    }
    static align(lhs, rhs) {
      if (lhs.dtype === rhs.dtype)
        return [lhs, rhs];
      const dtype = getSupertype(lhs.dtype, rhs.dtype);
      if (lhs.dtype === dtype)
        return [lhs, rhs.upcast(dtype)];
      return [lhs.upcast(dtype), rhs];
    }
    /**
     * Apply a function to the elements of two tensors, or to a tensor
     * and a scalar.
     *
     * The tensors are aligned and broadcasted if necessary.
     *
     * @param fn
     * @param lhs
     * @param rhs
     * @returns
     */
    static broadcast(fn, lhs, rhs) {
      if (!(rhs instanceof _AbstractTensor)) return lhs.map1(fn, rhs);
      const [lhs_, rhs_] = _AbstractTensor.align(lhs, rhs);
      const data = lhs_.data.map((v, i) => fn(v, rhs_.data[i]));
      return makeTensor(lhs_.ce, {
        dtype: lhs_.dtype,
        shape: lhs_.shape,
        rank: lhs_.rank,
        data
      });
    }
    // A Boxed Expression that represents the tensor
    get expression() {
      const shape = this.shape;
      const rank2 = this.rank;
      const data = this.data;
      const index = this._index.bind(this);
      const expression = this.field.expression.bind(this.field);
      const fill = (indices) => {
        if (indices.length === rank2 - 1) {
          const idx = index(indices);
          const result = this.ce._fn(
            "List",
            data.slice(idx, idx + shape[rank2 - 1]).map((x) => expression(x))
          );
          result.isCanonical = result.ops.every((x) => x.isCanonical);
          return result;
        } else {
          const list = [];
          for (let i = 0; i <= shape[indices.length] - 1; i++)
            list.push(fill([...indices, i + 1]));
          const result = this.ce._fn("List", list);
          result.isCanonical = result.ops.every((x) => x.isCanonical);
          return result;
        }
      };
      return fill([]);
    }
    /**
     * Like expression(), but return a nested JS array instead
     * of a BoxedExpression
     */
    get array() {
      const shape = this.shape;
      const rank2 = this.rank;
      const data = this.data;
      if (rank2 === 1) return data;
      if (rank2 === 2) {
        const [m, n] = shape;
        const array = new Array(m);
        for (let i = 0; i < m; i++) array[i] = data.slice(i * n, (i + 1) * n);
        return array;
      }
      const index = this._index.bind(this);
      const fill = (indices) => {
        if (indices.length === rank2 - 1) {
          const idx = index(indices);
          return data.slice(idx, idx + shape[rank2 - 1]);
        } else {
          const list = [];
          for (let i = 0; i < shape[indices.length]; i++)
            list.push(fill([...indices, i + 1]));
          return list;
        }
      };
      return fill([]);
    }
    /** Indices are 1-based, return a 0-based index in the data */
    _index(indices) {
      const strides = this._strides;
      return indices.reduce((acc, val, dim) => acc + (val - 1) * strides[dim], 0);
    }
    get isSquare() {
      const shape = this.shape;
      return shape.length === 2 && shape[0] === shape[1];
    }
    // A square matrix that is equal to its transpose. A^T = A
    get isSymmetric() {
      if (!this.isSquare) return false;
      const n = this.shape[0];
      const data = this.data;
      const eq2 = this.field.equals.bind(this.field);
      for (let i = 0; i < n; i++)
        for (let j = i + 1; j < n; j++)
          if (!eq2(data[i * n + j], data[j * n + i])) return false;
      return true;
    }
    // Aka antisymmetric matrix, skew-symmetric matrix, or antimetric matrix
    // A square matrix whose transpose is also its negative. A^T = -A
    get isSkewSymmetric() {
      if (!this.isSquare) return false;
      const n = this.shape[0];
      const data = this.data;
      const eq2 = this.field.equals.bind(this.field);
      const neg2 = this.field.neg.bind(this.field);
      for (let i = 0; i < n; i++)
        for (let j = i + 1; j < n; j++)
          if (!eq2(data[i * n + j], neg2(data[j * n + i]))) return false;
      return true;
    }
    // All entries below the diagonal are zero.
    get isUpperTriangular() {
      if (!this.isSquare) return false;
      const n = this.shape[0];
      const data = this.data;
      const isZero2 = this.field.isZero.bind(this.field);
      for (let i = 1; i < n; i++)
        for (let j = 0; j < i; j++) if (isZero2(data[i * n + j])) return false;
      return true;
    }
    // All entries above the diagonal are zero.
    get isLowerTriangular() {
      if (!this.isSquare) return false;
      const n = this.shape[0];
      const data = this.data;
      const isZero2 = this.field.isZero.bind(this.field);
      for (let i = 0; i < n - 1; i++)
        for (let j = i + 1; j < n; j++)
          if (!isZero2(data[i * n + j])) return false;
      return true;
    }
    get isTriangular() {
      if (!this.isSquare) return false;
      const n = this.shape[0];
      const data = this.data;
      const isZero2 = this.field.isZero.bind(this.field);
      for (let i = 0; i < n; i++)
        for (let j = 0; j < n; j++)
          if (i < j && !isZero2(data[i * n + j]) || i > j && !isZero2(data[i * n + j]))
            return false;
      return true;
    }
    get isDiagonal() {
      if (!this.isSquare) return false;
      const n = this.shape[0];
      const data = this.data;
      const isZero2 = this.field.isZero.bind(this.field);
      for (let i = 0; i < n; i++)
        for (let j = 0; j < n; j++)
          if (i === j && !isZero2(data[i * n + j]) || i !== j && !isZero2(data[i * n + j]))
            return false;
      return true;
    }
    get isIdentity() {
      if (!this.isSquare) return false;
      const [m, n] = this.shape;
      const data = this.data;
      const isOne2 = this.field.isOne.bind(this.field);
      const isZero2 = this.field.isZero.bind(this.field);
      for (let i = 0; i < n; i++)
        for (let j = 0; j < n; j++)
          if (i === j && !isOne2(data[i * n + j]) || i !== j && !isZero2(data[i * n + j]))
            return false;
      return true;
    }
    get isZero() {
      const isZero2 = this.field.isZero.bind(this.field);
      return this.data.every((e) => isZero2(e));
    }
    /**
     *  The number of indices should match the rank of the tensor.
     *
     * Note: the indices are 1-based
     * Note: the data is broadcast (wraps around) if the indices are out of bounds
     *
     * LaTeX notation `A\lbracki, j\rbrack` or `A_{i, j}`
     */
    at(...indices) {
      const l = this.data.length;
      return this.data[this._index(indices) % l];
    }
    diagonal(axis1, axis2) {
      axis1 ?? (axis1 = 1);
      axis2 ?? (axis2 = 2);
      if (axis1 === axis2) return void 0;
      if (axis1 <= 0 || axis1 > this.shape.length) return void 0;
      if (this.shape[axis1 - 1] !== this.shape[axis2 - 1]) return void 0;
      const diag = new Array(this.shape[axis1 - 1]);
      const data = this.data;
      const n = this.shape[axis1 - 1];
      for (let i = 0; i < n; i++) diag[i] = data[i * n + i];
      return diag;
    }
    // Trace is the sum of the diagonal entries of a square matrix.
    // `\operatorname{tr}(A) = \sum_{i=1}^n a_{ii}`
    trace(axis1, axis2) {
      if (this.rank !== 2) return void 0;
      const [m, n] = this.shape;
      if (m !== n) return void 0;
      const data = this.data;
      const trace = new Array(m);
      for (let i = 0; i < m; i++) trace[i] = data[i * m + i];
      return this.field.addn(...trace);
    }
    /**
     * Change the shape of the tensor
     *
     * The data is reused (and shared) between the two tensors.
     */
    reshape(...shape) {
      return makeTensor(this.ce, {
        dtype: this.dtype,
        shape,
        rank: shape.length,
        data: this.data
      });
    }
    flatten() {
      return this.data;
    }
    upcast(dtype) {
      const data = this.field.cast(this.data, dtype);
      if (data === void 0) throw Error(`Cannot cast tensor to ${dtype}`);
      return makeTensor(this.ce, {
        dtype,
        shape: this.shape,
        rank: this.rank,
        data
      });
    }
    transpose(axis1, axis2, fn) {
      if (this.rank !== 2) return void 0;
      axis1 ?? (axis1 = 1);
      axis2 ?? (axis2 = 2);
      if (axis1 === axis2) return this;
      if (axis1 <= 0 || axis1 > 2) return void 0;
      if (axis2 <= 0 || axis2 > 2) return void 0;
      const [m, n] = this.shape;
      let data = this.data;
      if (fn) data = data.map((x) => fn(x));
      let index = 0;
      const result = new Array(m * n);
      const stride = n;
      for (let i = 0; i < n; i++) {
        for (let j = 0; j < m; j++) result[index++] = data[j * stride + i];
      }
      return makeTensor(this.ce, {
        dtype: this.dtype,
        shape: [n, m],
        rank: 2,
        data: result
      });
    }
    // a^H or A^*, or A^\dagger : conjugate transpose, aka Hermitian transpose, aka adjoint
    // https://en.wikipedia.org/wiki/Conjugate_transpose
    // transpose, then apply the complex conjugate to each entry
    // (same as transpose if all entries are real)
    conjugateTranspose(axis1, axis2) {
      const conjugate = this.field.conjugate.bind(this.field);
      return this.transpose(axis1, axis2, conjugate);
    }
    determinant() {
      if (this.rank !== 2) return void 0;
      const [m, n] = this.shape;
      if (m !== n) return void 0;
      if (m === 1) return this.data[0];
      const add4 = this.field.add.bind(this.field);
      const mul4 = this.field.mul.bind(this.field);
      const neg2 = this.field.neg.bind(this.field);
      if (m === 2) {
        const [a, b, c, d] = this.data;
        return add4(mul4(a, d), neg2(mul4(b, c)));
      }
      const addn = this.field.addn.bind(this.field);
      const muln = this.field.muln.bind(this.field);
      if (m === 3) {
        const [a, b, c, d, e, f, g, h, i] = this.data;
        return addn([
          muln(a, e, i),
          muln(b, f, g),
          muln(c, d, h),
          neg2(muln(c, e, g)),
          neg2(muln(b, d, i)),
          neg2(muln(a, f, h))
        ]);
      }
      const rows = this.shape[0];
      let negated = false;
      const div3 = this.field.div.bind(this.field);
      const sub2 = this.field.sub.bind(this.field);
      const rowIndices = new Array(rows).fill(0).map((_, i) => i);
      const matrix = [...this.data];
      for (let k = 0; k < rows; k++) {
        let k_ = rowIndices[k - 1];
        if (this.at(k_, k) === 0) {
          let _k;
          for (_k = k + 1; _k < rows; _k++) {
            if (this.at(rowIndices[_k], k) !== 0) {
              k_ = rowIndices[_k];
              rowIndices[_k - 1] = rowIndices[k - 1];
              rowIndices[k - 1] = k_;
              negated = !negated;
              break;
            }
          }
          if (_k === rows) return this.at(k_, k);
        }
        const piv = this.at(k_, k);
        const piv_ = k === 0 ? 1 : this.at(rowIndices[k - 2], k - 2);
        for (let i = k + 1; i < rows; i++) {
          const i_ = rowIndices[i - 1];
          for (let j = k + 1; j < rows; j++) {
            matrix[i_][j] = div3(
              sub2(mul4(matrix[i_][j], piv), mul4(matrix[i_][k], matrix[k_][j])),
              piv_
            );
          }
        }
      }
      const det = matrix[rowIndices[rows - 1]][rows - 1];
      return negated ? this.field.neg(det) : det;
    }
    inverse() {
      if (this.rank !== 2) return void 0;
      const [m, n] = this.shape;
      if (m !== n) return void 0;
      if (m === 2) {
        const [a, b, c, d] = this.data;
        const det = this.determinant();
        if (det === void 0 || this.field.isZero(det)) return void 0;
        const div4 = this.field.div.bind(this.field);
        const neg2 = this.field.neg.bind(this.field);
        const inverseData2 = [
          div4(d, det),
          neg2(div4(b, det)),
          neg2(div4(c, det)),
          div4(a, det)
        ];
        return makeTensor(this.ce, {
          dtype: this.dtype,
          shape: [n, n],
          rank: 2,
          data: inverseData2
        });
      }
      const rows = this.shape[0];
      const div3 = this.field.div.bind(this.field);
      const sub2 = this.field.sub.bind(this.field);
      const mul4 = this.field.mul.bind(this.field);
      const matrix = this.array;
      const identity = new Array(rows).fill(0).map((_, i) => {
        const row = new Array(rows).fill(0);
        row[i] = 1;
        return row;
      });
      const augmented = matrix.map((row, i) => [...row, ...identity[i]]);
      const rowIndices = new Array(rows).fill(0).map((_, i) => i);
      for (let k = 0; k < rows; k++) {
        let k_ = rowIndices[k - 1];
        if (this.at(k_, k) === 0) {
          let _k;
          for (_k = k + 1; _k < rows; _k++) {
            if (this.at(rowIndices[_k], k) !== 0) {
              k_ = rowIndices[_k];
              rowIndices[_k - 1] = rowIndices[k - 1];
              rowIndices[k - 1] = k_;
              break;
            }
          }
          if (_k === rows) return void 0;
        }
        const piv = this.at(k_, k);
        const piv_ = k === 0 ? 1 : this.at(rowIndices[k - 2], k - 2);
        for (let i = k + 1; i < rows; i++) {
          const i_ = rowIndices[i - 1];
          for (let j = k + 1; j < rows * 2; j++) {
            augmented[i_][j] = sub2(
              augmented[i_][j],
              mul4(div3(mul4(augmented[i_][k], augmented[k_][j]), piv), piv_)
            );
          }
        }
      }
      for (let k = rows - 1; k >= 0; k--) {
        const piv = augmented[rowIndices[k], k];
        for (let i = 0; i < k; i++) {
          const i_ = rowIndices[i];
          for (let j = rows; j < rows * 2; j++) {
            augmented[i_][j] = sub2(
              augmented[i_][j],
              mul4(div3(mul4(augmented[i_][k], augmented[k][j]), piv), piv)
            );
          }
        }
        for (let j = rows; j < rows * 2; j++) {
          augmented[k][j] = div3(augmented[k][j], piv);
        }
      }
      const inverseData = augmented.map(
        (row) => row.slice(rows)
      );
      return makeTensor(this.ce, {
        dtype: this.dtype,
        shape: [n, n],
        rank: 2,
        data: inverseData
      });
    }
    // A^+ is the Moore-Penrose pseudoinverse of A. https://en.wikipedia.org/wiki/Moore%E2%80%93Penrose_inverse
    // Pseudoinverse can also be defined for scalars: the pseudoinverse of a scalar is its reciprocal if it is non-zero, and zero otherwise.
    pseudoInverse() {
      return void 0;
    }
    // The adjugate, classical adjoint, or adjunct of a square matrix is the transpose of its cofactor matrix. https://en.wikipedia.org/wiki/Adjugate_matrix
    adjugateMatrix() {
      return void 0;
    }
    // The determinant of the matrix obtained by deleting row i and column j from this matrix. https://en.wikipedia.org/wiki/Minor_(linear_algebra)
    minor(i, j) {
      return void 0;
    }
    map1(fn, scalar) {
      return makeTensor(this.ce, {
        dtype: this.dtype,
        shape: this.shape,
        rank: this.rank,
        data: this.data.map((v) => fn(v, scalar))
      });
    }
    map2(fn, rhs) {
      const rhsData = rhs.data;
      return makeTensor(this.ce, {
        dtype: this.dtype,
        shape: this.shape,
        rank: this.rank,
        data: this.data.map((v, i) => fn(v, rhsData[i]))
      });
    }
    add(rhs) {
      return _AbstractTensor.broadcast(this.field.add.bind(this.field), this, rhs);
    }
    subtract(rhs) {
      return _AbstractTensor.broadcast(this.field.sub.bind(this.field), this, rhs);
    }
    // Hadamard product: \odot or \circ
    multiply(rhs) {
      return _AbstractTensor.broadcast(this.field.mul.bind(this.field), this, rhs);
    }
    divide(rhs) {
      return _AbstractTensor.broadcast(this.field.div.bind(this.field), this, rhs);
    }
    power(rhs) {
      return _AbstractTensor.broadcast(this.field.pow.bind(this.field), this, rhs);
    }
    // // aka inner product
    // dot(rhs: AbstractTensor<DT>): undefined | AbstractTensor<DT> {
    //   return undefined;
    // }
    // // aka matmul, \otimes or invisibleoperator
    // // generalization of the outer product
    // tensorProduct(rhs: AbstractTensor<DT>): AbstractTensor<DT>;
    // // generalization of kroneckerProduct
    // outerProduct(rhs: AbstractTensor<DT>): AbstractTensor<DT>;
    // // for 2d
    // kroneckerProduct(rhs: AbstractTensor<DT>): AbstractTensor<DT>;
    // // https://en.wikipedia.org/wiki/Frobenius_inner_product
    // // \langle A, B \rangle_F, Frobenius norm: \lVert A \rVert_F =
    // // \sqrt{\sum_{i,j} |a_{ij}|^2}
    // frobeniusProduct(rhs: AbstractTensor<DT>): DataTypeMap[DT];
    // crossProduct(rhs: AbstractTensor<DT>): AbstractTensor<DT>;
    // innerProduct(rhs: AbstractTensor<DT>): AbstractTensor<DT>;
    equals(rhs) {
      if (this.rank !== rhs.rank) return false;
      if (!this.shape.every((x, i) => x === rhs.shape[i])) return false;
      const eq2 = this.field.equals.bind(this.field);
      const cast = this.field.cast.bind(this.field);
      const dtype = this.dtype;
      if (this.dtype !== rhs.dtype) {
        if (!this.data.every((x, i) => eq2(x, cast(rhs.data[i], dtype))))
          return false;
        return true;
      }
      return this.data.every((x, i) => eq2(x, rhs.data[i]));
    }
  };
  function getStrides(shape) {
    const strides = new Array(shape.length);
    for (let i = shape.length - 1, stride = 1; i >= 0; i--) {
      strides[i] = stride;
      stride *= shape[i];
    }
    return strides;
  }
  var NumberTensor = class extends AbstractTensor {
    constructor(ce, data) {
      super(ce, data);
      this.dtype = "float64";
      this.data = data.data;
    }
    get isZero() {
      return this.data.every((x) => x === 0);
    }
  };
  var ComplexTensor = class extends AbstractTensor {
    constructor(ce, data) {
      super(ce, data);
      this.dtype = "complex128";
      this.data = data.data;
    }
  };
  var BooleanTensor = class extends AbstractTensor {
    constructor(ce, data) {
      super(ce, data);
      this.dtype = "bool";
      this.data = data.data;
    }
  };
  var GenericTensor = class extends AbstractTensor {
    constructor(ce, data) {
      super(ce, data);
      this.dtype = "expression";
      this.data = data.data;
    }
  };
  function makeTensor(ce, data) {
    const dtype = data.dtype;
    if (dtype === "float64" || dtype === "float32" || dtype === "uint8" || dtype === "int32")
      return new NumberTensor(
        ce,
        data
      );
    if (dtype === "bool")
      return new BooleanTensor(
        ce,
        data
      );
    if (dtype === "complex64" || dtype === "complex128")
      return new ComplexTensor(
        ce,
        data
      );
    return new GenericTensor(
      ce,
      data
    );
  }

  // src/compute-engine/boxed-expression/expand.ts
  function expandProduct(lhs, rhs) {
    if (lhs.operator === "Negate" && rhs.operator === "Negate")
      return expandProduct(lhs.op1, rhs.op1);
    const ce = lhs.engine;
    if (lhs.operator === "Negate") return expandProduct(lhs.op1, rhs).neg();
    if (rhs.operator === "Negate") return expandProduct(lhs, rhs.op1).neg();
    if (lhs.operator === "Divide" && rhs.operator === "Divide") {
      const denom = lhs.op2.mul(rhs.op2);
      return expandProduct(lhs.op1, rhs.op1).div(denom);
    }
    if (lhs.operator === "Divide")
      return expandProduct(lhs.op1, rhs).div(lhs.op2);
    if (rhs.operator === "Divide")
      return expandProduct(lhs, rhs.op1).div(rhs.op2);
    if (lhs.operator === "Add")
      return add3(...lhs.ops.map((x) => expandProduct(x, rhs)));
    if (rhs.operator === "Add")
      return add3(...rhs.ops.map((x) => expandProduct(lhs, x)));
    return new Product(ce, [lhs, rhs]).asExpression();
  }
  function expandProducts(ce, ops) {
    if (ops.length === 0) return null;
    if (ops.length === 1) return ops[0];
    if (ops.length === 2) return expandProduct(ops[0], ops[1]);
    const rhs = expandProducts(ce, ops.slice(1));
    return rhs === null ? null : expandProduct(ops[0], rhs);
  }
  var binomials = [
    [1],
    [1, 1],
    [1, 2, 1],
    [1, 3, 3, 1],
    [1, 4, 6, 4, 1],
    [1, 5, 10, 10, 5, 1],
    [1, 6, 15, 20, 15, 6, 1],
    [1, 7, 21, 35, 35, 21, 7, 1],
    [1, 8, 28, 56, 70, 56, 28, 8, 1]
  ];
  function choose(n, k) {
    while (n >= binomials.length) {
      const s = binomials.length;
      const nextRow = [1];
      const prev = binomials[s - 1];
      for (let i = 1; i < s; i++) nextRow[i] = prev[i - 1] + prev[i];
      nextRow[s] = 1;
      binomials.push(nextRow);
    }
    return binomials[n][k];
  }
  function multinomialCoefficient(k) {
    let n = k.reduce((acc, v) => acc + v, 0);
    let prod = 1;
    for (let i = 0; i < k.length; i += 1) {
      prod *= choose(n, k[i]);
      n -= k[i];
    }
    return prod;
  }
  function* powers(n, exp2) {
    if (n === 1) {
      yield [exp2];
      return;
    }
    for (let i = 0; i <= exp2; i += 1)
      for (const p of powers(n - 1, exp2 - i)) yield [i, ...p];
  }
  function expandPower(base, exp2) {
    const ce = base.engine;
    if (exp2 < 0) {
      const expr = expandPower(base, -exp2);
      return expr ? expr.inv() : null;
    }
    if (exp2 === 0) return ce.One;
    if (exp2 === 1) return expand2(base);
    if (base.operator === "Negate") {
      if (Number.isInteger(exp2)) {
        const sign2 = exp2 % 2 === 0 ? 1 : -1;
        const result2 = expandPower(base.op1, exp2);
        if (result2 === null) return null;
        return sign2 > 0 ? result2 : result2.neg();
      }
    }
    console.assert(base.operator !== "Subtract");
    if (base.operator !== "Add") return null;
    const terms = base.ops;
    const it = powers(terms.length, exp2);
    const result = [];
    for (const val of it) {
      const product = [ce.number(multinomialCoefficient(val))];
      for (let i = 0; i < val.length; i += 1) {
        if (val[i] !== 0) {
          if (val[i] === 1) product.push(terms[i]);
          else product.push(terms[i].pow(val[i]));
        }
      }
      result.push(mul3(...product));
    }
    return add3(...result);
  }
  function expandFunction(ce, h, ops) {
    let result = null;
    if (h === "Divide") {
      const num = expand2(ops[0]);
      if (num === null) return null;
      if (num.operator === "Add")
        return add3(...num.ops.map((x) => x.div(ops[1])));
      return ce._fn("Divide", [num, ops[1]]);
    }
    if (h === "Multiply") return expandProducts(ce, ops);
    if (h === "Negate") return expand2(ops[0])?.neg() ?? null;
    if (h === "Add") return add3(...ops.map((x) => expand2(x) ?? x));
    if (h === "Power") {
      const exp2 = asSmallInteger(ops[1]);
      result = exp2 !== null ? expandPower(ops[0], exp2) : null;
    }
    return result;
  }
  function expand2(expr) {
    expr = expr?.canonical;
    if (!expr || typeof expr.operator !== "string") return null;
    if (isRelationalOperator(expr.operator)) {
      return expr.engine._fn(
        expr.operator,
        expr.ops.map((x) => expand2(x) ?? x)
      );
    }
    return expandFunction(expr.engine, expr.operator, expr.ops ?? []);
  }
  function expandAll(expr) {
    if (!expr.operator || !expr.ops) return null;
    const ce = expr.engine;
    const ops = expr.ops.map(
      (x) => x.ops ? expandFunction(ce, x.operator, x.ops) ?? x : x
    );
    const result = expr.engine.function(expr.operator, ops);
    return expand2(result) ?? result;
  }

  // src/compute-engine/boxed-expression/negate.ts
  function canonicalNegate(expr) {
    let sign2 = -1;
    while (expr.operator === "Negate") {
      expr = expr.op1;
      sign2 = -sign2;
    }
    if (sign2 === 1) return expr;
    if (expr.isNumberLiteral) return expr.neg();
    return expr.engine._fn("Negate", [expr]);
  }
  function negate(expr) {
    let sign2 = -1;
    while (expr.operator === "Negate") {
      expr = expr.op1;
      sign2 = -sign2;
    }
    if (sign2 === 1) return expr;
    if (expr.numericValue !== null) return expr.neg();
    const ce = expr.engine;
    if (expr.operator === "Subtract") return expr.op2.sub(expr.op1);
    if (expr.operator === "Add") return add3(...expr.ops.map((x) => negate(x)));
    if (expr.operator === "Multiply") return negateProduct(ce, expr.ops);
    if (expr.operator === "Divide") return negate(expr.op1).div(expr.op2);
    return ce._fn("Negate", [expr]);
  }
  function negateProduct(ce, args) {
    if (args.length === 0) return ce.NegativeOne;
    if (args.length === 1) return negate(args[0]);
    let result = [];
    let done = false;
    for (const arg of args) {
      if (!done && arg.operator === "Negate") {
        done = true;
        if (!arg.op1.is(1)) result.push(arg.op1);
      } else result.push(arg);
    }
    if (!done) {
      result = [];
      for (const arg of args) {
        if (done || arg.numericValue === null && !arg.isInteger)
          result.push(arg);
        else {
          done = true;
          if (!arg.is(-1)) result.push(arg.neg());
        }
      }
    }
    if (done) return ce._fn("Multiply", result.sort(order));
    if (!done) {
      result = [];
      for (const arg of args) {
        if (done || arg.numericValue === null || !arg.isNumber) result.push(arg);
        else {
          done = true;
          if (!arg.is(-1)) result.push(arg.neg());
        }
      }
    }
    if (done) return ce._fn("Multiply", result.sort(order));
    return ce._fn("Negate", [ce._fn("Multiply", [...args].sort(order))]);
  }

  // src/compute-engine/boxed-expression/arithmetic-mul-div.ts
  function canonicalDivide(op1, op2) {
    const ce = op1.engine;
    if (!op1.isValid || !op2.isValid) return ce._fn("Divide", [op1, op2]);
    if (op1.isNaN || op2.isNaN) return ce.NaN;
    if (op2.is(0)) return op1.is(0) ? ce.NaN : ce.ComplexInfinity;
    if (op1.is(0)) return ce.Zero;
    if (op2.is(0) === false) {
      if (op1.symbol !== null && op1.symbol === op2.symbol && op1.isConstant)
        return ce.One;
      if (op1.isSame(op2)) return ce.One;
    }
    if (op1.operator === "Negate" && op2.operator === "Negate") {
      op1 = op1.op1;
      op2 = op2.op1;
    }
    if (op1.operator === "Divide" && op2.operator === "Divide") {
      return canonicalDivide(
        canonicalMultiply(ce, [op1.op1, op2.op2]),
        canonicalMultiply(ce, [op1.op2, op2.op1])
      );
    }
    if (op1.operator === "Divide")
      return canonicalDivide(op1.op1, canonicalMultiply(ce, [op1.op2, op2]));
    if (op2.operator === "Divide")
      return canonicalDivide(canonicalMultiply(ce, [op1, op2.op2]), op2.op1);
    if (op2.is(1)) return op1;
    if (op2.is(-1)) return op1.neg();
    if (op1.is(1)) return op2.inv();
    if (op2.isInfinity) return op1.isInfinity ? ce.NaN : ce.Zero;
    if (op1.operator === "Sqrt" && op2.operator === "Sqrt") {
      const a = asSmallInteger(op1.op1);
      const b = asSmallInteger(op2.op1);
      if (a !== null && b !== null)
        return ce.number(ce._numericValue({ radical: a * b, rational: [1, b] }));
    } else if (op1.operator === "Sqrt") {
      const a = asSmallInteger(op1.op1);
      const b = asSmallInteger(op2);
      if (a !== null && b !== null)
        return ce.number(ce._numericValue({ radical: a, rational: [1, b] }));
    } else if (op2.operator === "Sqrt") {
      const a = asSmallInteger(op1);
      const b = asSmallInteger(op2.op1);
      if (a !== null && b !== null)
        return ce.number(ce._numericValue({ radical: b, rational: [a, b] }));
    }
    const v1 = op1.numericValue;
    const v2 = op2.numericValue;
    if (v1 !== null && v2 !== null) {
      if (typeof v1 !== "number" && v1.im !== 0 || typeof v2 !== "number" && v2.im !== 0) {
        return ce._fn("Divide", [op1, op2]);
      }
      if (typeof v1 === "number" && Number.isInteger(v1) && typeof v2 === "number" && Number.isInteger(v2))
        return ce.number([v1, v2]);
      if (typeof v1 === "number" && Number.isInteger(v1)) {
        if (v1 === 0) return ce.Zero;
        if (typeof v2 !== "number" && isSubtype(v2.type, "integer")) {
          const b = v2.bignumRe;
          if (b !== void 0) {
            if (b.isInteger()) return ce.number([bigint(v1), bigint(b)]);
          } else {
            const d = v2.re;
            if (Number.isInteger(d)) return ce.number([v1, d]);
          }
        }
      }
      return ce._fn("Divide", [op1, op2]);
    }
    const [c1, t1] = op1.toNumericValue();
    if (c1.isZero) return ce.Zero;
    const [c2, t2] = op2.toNumericValue();
    if (c2.isZero) return ce.NaN;
    const c = c1.div(c2);
    if (c.isOne) return t2.is(1) ? t1 : ce._fn("Divide", [t1, t2]);
    if (c.isNegativeOne)
      return t2.is(1) ? t1.neg() : ce._fn("Divide", [t1.neg(), t2]);
    if (c.isExact) {
      if (t1.is(1) && t2.is(1)) return ce.number(c);
      if (t2.is(1)) return canonicalMultiply(ce, [ce.number(c), t1]);
      return ce._fn("Divide", [
        canonicalMultiply(ce, [ce.number(c.numerator), t1]),
        canonicalMultiply(ce, [ce.number(c.denominator), t2])
      ]);
      return canonicalMultiply(ce, [ce.number(c), ce._fn("Divide", [t1, t2])]);
    }
    return ce._fn("Divide", [op1, op2]);
  }
  function div2(num, denom) {
    const ce = num.engine;
    num = num.canonical;
    if (typeof denom !== "number") denom = denom.canonical;
    if (num.isNaN) return ce.NaN;
    if (typeof denom === "number") {
      if (isNaN(denom)) return ce.NaN;
      if (num.is(0)) {
        if (denom === 0 || !isFinite(denom)) return ce.NaN;
        return num;
      }
      if (denom === 1) return num;
      if (denom === -1) return num.neg();
      if (denom === 0) return ce.NaN;
      if (num.isNumberLiteral) {
        const n = num.numericValue;
        if (typeof n === "number") {
          if (Number.isInteger(n) && Number.isInteger(denom))
            return ce.number(ce._numericValue({ rational: [n, denom] }));
        } else if (n.isExact && Number.isInteger(denom)) {
          return ce.number(n.asExact.div(denom));
        }
      }
    } else {
      if (denom.isNaN) return ce.NaN;
      if (num.is(0)) {
        if (denom.is(0) || denom.isFinite === false) return ce.NaN;
        return ce.Zero;
      }
      if (denom.is(1)) return num;
      if (denom.is(-1)) return num.neg();
      if (denom.is(0)) return ce.NaN;
      if (num.isNumberLiteral && denom.isNumberLiteral) {
        const numV = num.numericValue;
        const denomV = denom.numericValue;
        if (typeof numV === "number" && typeof denomV === "number" && Number.isInteger(numV) && Number.isInteger(denomV)) {
          return ce.number(ce._numericValue({ rational: [numV, denomV] }));
        } else if (typeof numV === "number" && Number.isInteger(numV) && typeof denomV !== "number") {
          if (denomV.isExact) {
            return ce.number(ce._numericValue(numV).div(denomV.asExact));
          }
        } else if (typeof denomV === "number" && Number.isInteger(denomV) && typeof numV !== "number") {
          if (numV.isExact) {
            return ce.number(numV.asExact.div(denomV));
          }
        } else if (typeof numV !== "number" && typeof denomV !== "number") {
          if (numV.isExact && denomV.isExact) {
            return ce.number(numV.asExact.div(denomV.asExact));
          }
        }
      }
    }
    const result = new Product(ce, [num]);
    result.div(typeof denom === "number" ? ce._numericValue(denom) : denom);
    return result.asRationalExpression();
  }
  function canonicalMultiply(ce, ops) {
    let sign2 = 1;
    let xs = [];
    for (const op of ops) {
      const [o, s] = unnegate(op);
      sign2 *= s;
      xs.push(o);
    }
    xs = xs.filter((x) => !x.is(1));
    const ys = [];
    for (let i = 0; i < xs.length; i++) {
      const x = xs[i];
      if (i + 1 >= xs.length) {
        ys.push(x);
        continue;
      }
      const next = xs[i + 1];
      if (x.isNumberLiteral) {
        if (next.operator === "Sqrt" && next.op1.isNumberLiteral && next.op1.type.matches("finite_integer")) {
          let radical = next.op1.numericValue;
          if (typeof radical !== "number") radical = radical.re;
          if (radical >= SMALL_INTEGER) {
            ys.push(x);
            continue;
          }
          if (x.type.matches("finite_rational")) {
            const rational = x.numericValue;
            const [num, den] = typeof rational === "number" ? [rational, 1] : [rational.numerator.re, rational.denominator.re];
            ys.push(
              ce.number(ce._numericValue({ rational: [num, den], radical }))
            );
            i++;
            continue;
          }
        } else if (next.isNumberLiteral && next.numericValue instanceof NumericValue) {
          const nextNv = next.numericValue;
          if (nextNv instanceof ExactNumericValue && isOne(nextNv.rational) && nextNv.radical !== 1) {
            const r = asRational(x);
            if (r) {
              ys.push(
                ce.number(
                  ce._numericValue({ rational: r, radical: nextNv.radical })
                )
              );
              i++;
              continue;
            }
          } else if (nextNv.im === 1) {
            const nv = x.numericValue;
            if (typeof nv === "number") {
              ys.push(ce.number(ce.complex(0, nv)));
              i++;
              continue;
            } else if (nv.im === 0) {
              if (Number.isInteger(nv.re)) {
                ys.push(ce.number(ce.complex(0, nv.re)));
                i++;
                continue;
              } else if (!nv.isExact) {
                ys.push(ce.number(ce.complex(0, nv.re)));
                i++;
                continue;
              }
            }
          }
        }
      }
      ys.push(x);
    }
    if (sign2 < 0) {
      if (ys.length === 0) return ce.number(-1);
      if (ys.length === 1) return ys[0].neg();
      return negateProduct(ce, ys);
    }
    if (ys.length === 0) return ce.number(1);
    if (ys.length === 1) return ys[0];
    return ce._fn("Multiply", [...ys].sort(order));
  }
  function unnegate(op) {
    let sign2 = 1;
    while (op.operator === "Negate") {
      sign2 = -sign2;
      op = op.op1;
    }
    if (op.isNumberLiteral && op.isNegative) {
      sign2 = -sign2;
      op = op.neg();
    }
    return [op, sign2];
  }
  function mul3(...xs) {
    console.assert(xs.length > 0);
    if (xs.length === 1) return xs[0];
    const ce = xs[0].engine;
    const exp2 = expandProducts(ce, xs);
    if (exp2) {
      if (exp2.operator !== "Multiply") return exp2;
      xs = exp2.ops;
    }
    return new Product(ce, xs).asRationalExpression();
  }
  function mulN(...xs) {
    console.assert(xs.length > 0);
    const ce = xs[0].engine;
    xs = xs.map((x) => x.N());
    const exp2 = expandProducts(ce, xs);
    if (exp2) {
      if (exp2.operator !== "Multiply") return exp2;
      xs = exp2.ops;
    }
    return new Product(ce, xs).asExpression({ numericApproximation: true });
  }

  // src/compute-engine/numeric-value/big-numeric-value.ts
  var BigNumericValue = class _BigNumericValue extends NumericValue {
    constructor(value, bignum) {
      super();
      this.bignum = bignum;
      if (typeof value === "number") {
        this.decimal = bignum(value);
        this.im = 0;
      } else if (value instanceof Decimal) {
        this.decimal = value;
        this.im = 0;
      } else {
        const decimal = bignum(value.re ?? 0);
        this.decimal = decimal;
        this.im = value.im ?? 0;
      }
      if (this.decimal.isNaN()) this.im = NaN;
      console.assert(this.decimal.isNaN() === isNaN(this.im));
    }
    get type() {
      if (this.isNaN) return "number";
      if (this.isComplexInfinity) return "complex";
      if (this.im !== 0) {
        if (this.decimal.isZero()) return "imaginary";
        return "finite_complex";
      }
      if (!this.decimal.isFinite()) return "non_finite_number";
      if (this.decimal.isInteger()) return "finite_integer";
      return "finite_real";
    }
    get isExact() {
      return this.im === 0 && this.decimal.isInteger();
    }
    get asExact() {
      if (!this.isExact) return void 0;
      return this._makeExact(bigint(this.decimal));
    }
    toJSON() {
      if (this.isNaN) return "NaN";
      if (this.isPositiveInfinity) return "PositiveInfinity";
      if (this.isNegativeInfinity) return "NegativeInfinity";
      if (this.isComplexInfinity) return "ComplexInfinity";
      if (this.im === 0) {
        if (isInMachineRange(this.decimal)) return this.decimal.toNumber();
        return { num: decimalToString(this.decimal) };
      }
      if (isInMachineRange(this.decimal))
        return [
          "Complex",
          numberToExpression(this.decimal.toNumber()),
          numberToExpression(this.im)
        ];
      return [
        "Complex",
        { num: decimalToString(this.decimal) },
        numberToExpression(this.im)
      ];
    }
    toString() {
      if (this.isZero) return "0";
      if (this.isOne) return "1";
      if (this.isNegativeOne) return "-1";
      if (this.im === 0) return decimalToString(this.decimal);
      if (this.decimal.isZero()) {
        if (this.im === 1) return "i";
        if (this.im === -1) return "-i";
        return `${numberToString(this.im)}i`;
      }
      if (this.isComplexInfinity) return "~oo";
      let im = "";
      if (this.im === 1) im = "+ i";
      else if (this.im === -1) im = "- i";
      else if (this.im > 0) im = `+ ${this.im}i`;
      else im = `- ${-this.im}i`;
      return `(${decimalToString(this.decimal)} ${im})`;
    }
    clone(value) {
      return new _BigNumericValue(value, this.bignum);
    }
    _makeExact(value) {
      return new ExactNumericValue(value, (x) => this.clone(x), this.bignum);
    }
    get re() {
      return this.decimal.toNumber();
    }
    get bignumRe() {
      return this.decimal;
    }
    get numerator() {
      return this;
    }
    get denominator() {
      return this._makeExact(1);
    }
    get isNaN() {
      return this.decimal.isNaN();
    }
    get isPositiveInfinity() {
      return this.im === 0 && !this.decimal.isFinite() && !this.decimal.isNaN() && this.decimal.isPositive();
    }
    get isNegativeInfinity() {
      return this.im === 0 && !this.decimal.isFinite() && !this.decimal.isNaN() && this.decimal.isNegative();
    }
    get isComplexInfinity() {
      return !Number.isFinite(this.im) && !Number.isNaN(this.im);
    }
    get isZero() {
      return this.im === 0 && this.decimal.isZero();
    }
    isZeroWithTolerance(tolerance) {
      if (this.im !== 0) return false;
      const tol = typeof tolerance === "number" ? this.bignum(tolerance) : tolerance;
      return this.decimal.abs().lte(tol);
    }
    get isOne() {
      return this.im === 0 && this.decimal.eq(1);
    }
    get isNegativeOne() {
      return this.im === 0 && this.decimal.eq(-1);
    }
    sgn() {
      if (this.im !== 0) return void 0;
      if (this.decimal.isZero()) return 0;
      if (this.decimal.isPositive()) return 1;
      if (this.decimal.isNegative()) return -1;
      return void 0;
    }
    N() {
      return this;
    }
    neg() {
      if (this.isZero) return this;
      return this.clone({ re: this.decimal.neg(), im: -this.im });
    }
    inv() {
      if (this.isOne) return this;
      if (this.isNegativeOne) return this;
      if (this.im === 0) return this.clone(this.decimal.pow(-1));
      const d = Math.hypot(this.re, this.im);
      const bigD = this.decimal.mul(this.decimal).add(this.im * this.im).sqrt();
      return this.clone({ re: this.decimal.div(bigD), im: -this.im / d });
    }
    add(other) {
      if (typeof other === "number") {
        if (other === 0) return this;
        return this.clone({ re: this.decimal.add(other), im: this.im });
      }
      if (other.isZero) return this;
      if (this.isZero) return this.clone(other);
      return this.clone({
        re: this.decimal.add(other.bignumRe ?? other.re),
        im: this.im + other.im
      });
    }
    sub(other) {
      return this.add(other.neg());
    }
    mul(other) {
      if (this.isZero) return this;
      if (other === 1) return this;
      if (other === -1) return this.neg();
      if (other === 0) return this.clone(0);
      if (this.isOne) {
        if (typeof other === "number" || other instanceof Decimal)
          return this.clone(other);
        return this.clone({ re: other.bignumRe ?? other.re, im: other.im });
      }
      if (typeof other === "number") {
        if (this.im === 0) return this.clone(this.decimal.mul(other));
        return this.clone({
          re: this.decimal.mul(other),
          im: this.im * other
        });
      }
      if (other instanceof Decimal) {
        if (this.im === 0) return this.clone(this.decimal.mul(other));
        return this.clone({
          re: this.decimal.mul(other),
          im: this.im * other.toNumber()
        });
      }
      if (this.isNegativeOne) {
        const n = other.neg();
        return this.clone({ re: n.bignumRe ?? n.re, im: n.im });
      }
      if (other.isOne) return this;
      if (other.isNegativeOne) return this.neg();
      if (other.isZero) return this.clone(0);
      if (this.im === 0 && other.im === 0)
        return this.clone(this.decimal.mul(other.bignumRe ?? other.re));
      return this.clone({
        re: this.decimal.mul(other.bignumRe ?? other.re).sub(this.im * other.im),
        im: this.re * other.im + this.im * other.re
      });
    }
    div(other) {
      if (typeof other === "number") {
        if (other === 1) return this;
        if (other === -1) return this.neg();
        if (other === 0) return this.clone(NaN);
        return this.clone({
          re: this.decimal.div(other),
          im: this.im / other
        });
      }
      if (other.isOne) return this;
      if (other.isNegativeOne) return this.neg();
      if (other.isZero) return this.clone(this.isZero ? NaN : Infinity);
      if (this.im === 0 && other.im === 0)
        return this.clone(this.decimal.div(other.bignumRe ?? other.re));
      const [a, b] = [this.re, this.im];
      const [c, d] = [other.re, other.im];
      const denominator = c * c + d * d;
      const bigC = other.bignumRe ?? this.bignum(other.re);
      const bigDenominator = bigC.mul(bigC).add(d * d);
      return this.clone({
        re: this.decimal.mul(bigC).add(b * d).div(bigDenominator),
        im: (b * c - a * d) / denominator
      });
    }
    pow(exponent) {
      console.assert(!Array.isArray(exponent));
      if (this.isNaN) return this;
      if (typeof exponent === "number" && isNaN(exponent)) return this.clone(NaN);
      if (exponent instanceof NumericValue) {
        if (exponent.isNaN) return this.clone(NaN);
        if (exponent.isZero) return this.clone(1);
        if (exponent.isOne) return this;
        if (exponent.im) {
          exponent = { re: exponent.re, im: exponent.im };
        } else exponent = exponent.re;
      }
      if (typeof exponent === "object" && ("re" in exponent || "im" in exponent)) {
        const [re, im] = [exponent?.re ?? 0, exponent?.im ?? 0];
        if (Number.isNaN(im) || Number.isNaN(re)) return this.clone(NaN);
        if (im === 0) {
          exponent = re;
        } else {
          if (this.im === Infinity) return this.clone(NaN);
          if (this.isNegativeInfinity) return this.clone(0);
          if (this.isPositiveInfinity) return this.clone({ im: Infinity });
          const zRe = this.pow(re);
          const zArg = this.decimal.ln().mul(im);
          const zIm = this.clone({
            re: zArg.cos(),
            im: chop2(zArg.sin().toNumber())
          });
          return zRe.mul(zIm);
        }
      }
      if (this.isPositiveInfinity) {
        if (exponent === -1) return this.clone(0);
        if (exponent === Infinity) return this.clone(Infinity);
        if (exponent === -Infinity) return this.clone(0);
      } else if (this.isNegativeInfinity && exponent === Infinity)
        return this.clone(NaN);
      if ((exponent === Infinity || exponent === -Infinity) && (this.isOne || this.isNegativeOne))
        return this.clone(NaN);
      if (exponent === 1) return this;
      if (exponent === -1) return this.inv();
      if (exponent === 0) return this.clone(1);
      if (this.isZero) {
        if (exponent > 0) return this;
        if (exponent < 0) return this.clone({ im: Infinity });
      }
      if (exponent < 0) return this.pow(-exponent).inv();
      if (this.im === 0) {
        return this.clone(this.decimal.pow(exponent));
      }
      const a = this.decimal;
      const b = this.im;
      const modulus = a.mul(a).add(b * b).sqrt();
      const argument = Decimal.atan2(b, a);
      const newModulus = modulus.pow(exponent);
      const newArgument = argument.mul(exponent);
      return this.clone({
        re: newModulus.mul(newArgument.cos()),
        im: chop2(newModulus.mul(newArgument.sin()).toNumber())
      });
    }
    root(exp2) {
      if (!Number.isInteger(exp2)) return this._makeExact(NaN);
      if (exp2 === 0) return this._makeExact(NaN);
      if (exp2 === 1) return this;
      if (this.isZero) return this;
      if (this.isOne) return this;
      if (this.isNegativeOne) return this;
      if (this.im === 0) {
        if (this.decimal.isNegative()) return this._makeExact(NaN);
        if (exp2 === 2) return this.clone(this.decimal.sqrt());
        if (exp2 === 3) return this.clone(this.decimal.cbrt());
        return this.clone(this.decimal.pow(1 / exp2));
      }
      const a = this.decimal;
      const b = this.im;
      const modulus = a.mul(a).add(b * b).sqrt();
      const argument = Decimal.atan2(b, a);
      const newModulus = modulus.pow(1 / exp2);
      const newArgument = argument.div(exp2);
      return this.clone({
        re: newModulus.mul(newArgument.cos()),
        im: chop2(newModulus.mul(newArgument.sin()).toNumber())
      });
    }
    sqrt() {
      if (this.isZero || this.isOne) return this;
      if (this.im !== 0) {
        const a = this.decimal;
        const b = this.im;
        const modulus = a.mul(a).add(b * b).sqrt();
        const realPart = a.add(modulus).div(2).sqrt();
        const imaginaryPart = chop2(
          Math.sign(b) * modulus.sub(a).div(2).sqrt().toNumber()
        );
        return this.clone({ re: realPart, im: imaginaryPart });
      }
      if (this.decimal.isPositive()) return this.clone(this.decimal.sqrt());
      return this.clone({ im: Math.sqrt(-this.re) });
    }
    gcd(other) {
      if (this.isZero) return other;
      if (other.isZero) return this;
      if (this.im !== 0 || other.im !== 0) return this._makeExact(NaN);
      if (!this.decimal.isInteger()) return this._makeExact(1);
      let b = this.bignum(other.bignumRe ?? other.re);
      if (!b.isInteger()) return this._makeExact(1);
      let a = this.decimal;
      while (!b.isZero()) {
        const t = b;
        b = a.mod(b);
        a = t;
      }
      return this.clone(a.abs());
    }
    abs() {
      if (this.im === 0)
        return this.decimal.isPositive() ? this : this.clone(this.decimal.neg());
      return this.clone(
        this.decimal.pow(2).add(this.im ** 2).sqrt()
      );
    }
    ln(base) {
      if (this.isZero) return this._makeExact(NaN);
      if (this.isNegativeInfinity) return this._makeExact(NaN);
      if (this.isPositiveInfinity) return this._makeExact(Infinity);
      if (this.im === 0) {
        if (this.decimal.isNegative()) return this._makeExact(NaN);
        if (this.isOne) return this._makeExact(0);
        if (this.isNegativeOne) return this.clone({ im: Math.PI });
        if (base === void 0) return this.clone(this.decimal.ln());
        return this.clone(this.decimal.log(base));
      }
      const a = this.decimal;
      const b = this.im;
      const modulus = a.mul(a).add(b * b).sqrt();
      const argument = Decimal.atan2(b, a).toNumber();
      if (base === void 0)
        return this.clone({ re: modulus.ln(), im: argument });
      return this.clone({ re: modulus.log(base), im: argument });
    }
    exp() {
      if (this.isNaN) return this._makeExact(NaN);
      if (this.isZero) return this._makeExact(1);
      if (this.isNegativeInfinity) return this._makeExact(0);
      if (this.isPositiveInfinity) return this._makeExact(Infinity);
      if (this.im !== 0) {
        const e = this.decimal.exp();
        return this.clone({
          re: e.mul(chop2(Math.cos(this.im))),
          im: chop2(e.mul(Math.sin(this.im)).toNumber())
        });
      }
      return this.clone(this.decimal.exp());
    }
    floor() {
      if (this.isNaN || this.im !== 0) return this._makeExact(NaN);
      if (this.decimal.isInteger()) return this;
      return this._makeExact(bigint(this.decimal.floor()));
    }
    ceil() {
      if (this.isNaN || this.im !== 0) return this._makeExact(NaN);
      if (this.decimal.isInteger()) return this;
      return this._makeExact(bigint(this.decimal.ceil()));
    }
    round() {
      if (this.isNaN || this.im !== 0) return this._makeExact(NaN);
      if (this.decimal.isInteger()) return this;
      return this._makeExact(bigint(this.decimal.round()));
    }
    eq(other) {
      if (this.isNaN) return false;
      if (typeof other === "number")
        return this.im === 0 && this.decimal.eq(other);
      if (other.isNaN) return false;
      if (!Number.isFinite(this.im)) return !Number.isFinite(other.im);
      return this.decimal.eq(other.bignumRe ?? other.re) && this.im - other.im === 0;
    }
    lt(other) {
      if (this.im !== 0) ;
      if (typeof other === "number") return this.decimal.lt(other);
      return this.decimal.lt(other.bignumRe ?? other.re);
    }
    lte(other) {
      if (this.im !== 0) ;
      if (typeof other === "number") return this.decimal.lte(other);
      return this.decimal.lte(other.bignumRe ?? other.re);
    }
    gt(other) {
      if (this.im !== 0) ;
      if (typeof other === "number") return this.decimal.gt(other);
      return this.decimal.gt(other.bignumRe ?? other.re);
    }
    gte(other) {
      if (this.im !== 0) ;
      if (typeof other === "number") return this.decimal.gte(other);
      return this.decimal.gte(other.bignumRe ?? other.re);
    }
  };
  function decimalToString(num) {
    const numStr = num.toString();
    if (num.isInteger() && numStr.includes("e")) {
      const fixedStr = num.toFixed();
      const trailingZeros = fixedStr.match(/0+$/);
      const trailingZerosCount = trailingZeros ? trailingZeros[0].length : 0;
      if (trailingZerosCount <= 5) {
        return fixedStr;
      }
    }
    return numStr;
  }
  function chop2(n) {
    return Math.abs(n) <= 1e-14 ? 0 : n;
  }

  // src/compute-engine/numeric-value/machine-numeric-value.ts
  var MachineNumericValue = class _MachineNumericValue extends NumericValue {
    constructor(value, bignum) {
      super();
      this.bignum = bignum;
      if (typeof value === "number") {
        this.decimal = value;
        this.im = 0;
      } else if (value instanceof Decimal) {
        this.decimal = value.toNumber();
        this.im = 0;
      } else {
        const decimal = value.re === void 0 ? 0 : value.re instanceof Decimal ? value.re.toNumber() : value.re;
        this.decimal = decimal;
        this.im = value.im ?? 0;
        if (!isFinite(this.im)) this.decimal = this.im;
      }
      console.assert(!isNaN(this.im));
    }
    _makeExact(value) {
      return new ExactNumericValue(value, (x) => this.clone(x), this.bignum);
    }
    get type() {
      if (this.isNaN) return "number";
      if (this.isComplexInfinity) return "complex";
      if (this.im !== 0) {
        if (this.decimal === 0) return "imaginary";
        return "finite_complex";
      }
      if (!Number.isFinite(this.decimal)) return "non_finite_number";
      if (Number.isInteger(this.decimal)) return "finite_integer";
      return "finite_real";
    }
    get isExact() {
      return this.im === 0 && Number.isInteger(this.decimal);
    }
    get asExact() {
      if (!this.isExact) return void 0;
      return this._makeExact(this.decimal);
    }
    toJSON() {
      if (this.isNaN) return "NaN";
      if (this.isPositiveInfinity) return "PositiveInfinity";
      if (this.isNegativeInfinity) return "NegativeInfinity";
      if (this.im === 0) return numberToExpression(this.decimal);
      return [
        "Complex",
        numberToExpression(this.decimal),
        numberToExpression(this.im)
      ];
    }
    toString() {
      if (this.isZero) return "0";
      if (this.isOne) return "1";
      if (this.isNegativeOne) return "-1";
      if (this.im === 0) return numberToString(this.decimal);
      if (this.decimal === 0) {
        if (this.im === 1) return "i";
        if (this.im === -1) return "-i";
        return `${numberToString(this.im)}i`;
      }
      if (this.isComplexInfinity) return "~oo";
      let im = "";
      if (this.im === 1) im = "+ i";
      else if (this.im === -1) im = "- i";
      else if (this.im > 0) im = `+ ${numberToString(this.im)}i`;
      else im = `- ${numberToString(-this.im)}i`;
      return `(${numberToString(this.decimal)} ${im})`;
    }
    clone(value) {
      return new _MachineNumericValue(value, this.bignum);
    }
    get re() {
      return this.decimal;
    }
    get bignumRe() {
      return void 0;
    }
    get numerator() {
      return this;
    }
    get denominator() {
      return this._makeExact(1);
    }
    get isNaN() {
      return Number.isNaN(this.decimal);
    }
    get isPositiveInfinity() {
      return !Number.isFinite(this.decimal) && this.decimal > 0 && this.im === 0;
    }
    get isNegativeInfinity() {
      return !Number.isFinite(this.decimal) && this.decimal < 0 && this.im === 0;
    }
    get isComplexInfinity() {
      return !Number.isFinite(this.im) && !Number.isNaN(this.im);
    }
    get isZero() {
      return this.im === 0 && this.decimal === 0;
    }
    isZeroWithTolerance(tolerance) {
      if (this.im !== 0) return false;
      const tol = tolerance instanceof Decimal ? tolerance.toNumber() : tolerance;
      return Math.abs(this.decimal) < tol;
    }
    get isOne() {
      return this.im === 0 && this.decimal === 1;
    }
    get isNegativeOne() {
      return this.im === 0 && this.decimal === -1;
    }
    sgn() {
      if (this.im !== 0 || !Number.isFinite(this.decimal)) return void 0;
      return Math.sign(this.decimal);
    }
    N() {
      return this;
    }
    neg() {
      if (this.isNaN) return this._makeExact(NaN);
      if (this.isZero) return this;
      return this.clone({ re: -this.decimal, im: -this.im });
    }
    inv() {
      if (this.isNaN) return this._makeExact(NaN);
      if (this.isOne) return this;
      if (this.isNegativeOne) return this;
      if (this.im === 0) return this.clone(1 / this.decimal);
      const d = Math.hypot(this.re, this.im);
      return this.clone({ re: this.decimal / d, im: -this.im / d });
    }
    add(other) {
      if (this.isNaN) return this._makeExact(NaN);
      if (typeof other === "number") {
        if (other === 0) return this;
        return this.clone({ re: this.decimal + other, im: this.im });
      }
      if (other.isZero) return this;
      if (this.isZero)
        return this.clone({ re: other.bignumRe ?? other.re, im: other.im });
      return this.clone({
        re: this.decimal + other.re,
        im: this.im + other.im
      });
    }
    sub(other) {
      return this.add(other.neg());
    }
    mul(other) {
      if (this.isNaN) return this._makeExact(NaN);
      if (this.isZero) return this;
      if (other instanceof Decimal) other = other.toNumber();
      if (other === 1) return this;
      if (other === -1) return this.neg();
      if (other === 0) return this.clone(0);
      if (this.isOne) {
        if (typeof other === "number" || other instanceof Decimal)
          return this.clone(other);
        return this.clone({ re: other.bignumRe ?? other.re, im: other.im });
      }
      if (typeof other === "number") {
        if (this.im === 0) return this.clone(this.decimal * other);
        return this.clone({
          re: this.decimal * other,
          im: this.im * other
        });
      }
      if (this.isNegativeOne) {
        const n = other.neg();
        return this.clone({ re: n.bignumRe ?? n.re, im: n.im });
      }
      if (other.isOne) return this;
      if (other.isNegativeOne) return this.neg();
      if (other.isZero) return this.clone(0);
      if (this.im === 0 && other.im === 0)
        return this.clone(this.decimal * other.re);
      return this.clone({
        re: this.decimal * other.re - this.im * other.im,
        im: this.re * other.im + this.im * other.re
      });
    }
    div(other) {
      if (this.isNaN) return this._makeExact(NaN);
      if (typeof other === "number") {
        if (other === 1) return this;
        if (other === -1) return this.neg();
        if (other === 0) return this.clone(NaN);
        return this.clone({
          re: this.decimal / other,
          im: this.im / other
        });
      }
      if (other.isOne) return this;
      if (other.isNegativeOne) return this.neg();
      if (other.isZero) return this.clone(this.isZero ? NaN : Infinity);
      if (this.im === 0 && other.im === 0)
        return this.clone(this.decimal / other.re);
      const [a, b] = [this.decimal, this.im];
      const [c, d] = [other.re, other.im];
      const denominator = c * c + d * d;
      return this.clone({
        re: (a * c + b * d) / denominator,
        im: (b * c - a * d) / denominator
      });
    }
    pow(exponent) {
      console.assert(!Array.isArray(exponent));
      if (this.isNaN) return this._makeExact(NaN);
      if (typeof exponent === "number" && isNaN(exponent)) return this.clone(NaN);
      if (exponent instanceof NumericValue) {
        if (exponent.isNaN) return this.clone(NaN);
        if (exponent.isZero) return this.clone(1);
        if (exponent.isOne) return this;
        if (exponent.im) {
          exponent = { re: exponent.re, im: exponent.im };
        } else exponent = exponent.re;
      }
      if (typeof exponent === "object" && ("re" in exponent || "im" in exponent)) {
        const [re, im] = [exponent?.re ?? 0, exponent?.im ?? 0];
        if (Number.isNaN(im) || Number.isNaN(re)) return this.clone(NaN);
        if (im === 0) {
          exponent = re;
        } else {
          if (this.im === Infinity) return this.clone(NaN);
          if (this.isNegativeInfinity) return this.clone(0);
          if (this.isPositiveInfinity) return this.clone({ im: Infinity });
          const zRe = this.pow(re).re;
          const zArg = Math.log(this.decimal) * im;
          return this.clone({
            re: chop3(zRe * Math.cos(zArg)),
            im: chop3(zRe * Math.sin(zArg))
          });
        }
      }
      if (this.isPositiveInfinity) {
        if (exponent === -1) return this.clone(0);
        if (exponent === Infinity) return this.clone(Infinity);
        if (exponent === -Infinity) return this.clone(0);
      } else if (this.isNegativeInfinity && exponent === Infinity)
        return this.clone(NaN);
      if ((exponent === Infinity || exponent === -Infinity) && (this.isOne || this.isNegativeOne))
        return this.clone(NaN);
      if (exponent === 1) return this;
      if (exponent === -1) return this.inv();
      if (exponent === 0) return this.clone(1);
      if (this.isZero) {
        if (exponent > 0) return this;
        if (exponent < 0) return this.clone({ im: Infinity });
      }
      if (exponent < 0) return this.clone(1 / this.decimal ** -exponent);
      if (this.im === 0) return this.clone(this.decimal ** exponent);
      const a = this.decimal;
      const b = this.im;
      const modulus = Math.sqrt(a * a + b * b);
      const argument = Math.atan2(b, a);
      const newModulus = modulus ** exponent;
      const newArgument = argument ** exponent;
      return this.clone({
        re: newModulus * Math.cos(newArgument),
        im: newModulus * Math.sin(newArgument)
      });
    }
    root(exponent) {
      if (this.isNaN) return this._makeExact(NaN);
      if (exponent === 0) return this.clone(NaN);
      if (this.isNaN) return this;
      if (this.isZero) return this;
      if (this.isOne) return this;
      if (this.isNegativeOne) return this;
      if (exponent === 1) return this;
      if (exponent === 2) return this.sqrt();
      if (exponent === 3) return this.clone(Math.cbrt(this.decimal));
      if (this.im === 0) {
        if (this.decimal < 0) {
          if (exponent % 2 === 0) return this.clone(NaN);
          return this.clone(-Math.pow(-this.decimal, 1 / exponent));
        }
        return this.clone(Math.pow(this.decimal, 1 / exponent));
      }
      const a = this.decimal;
      const b = this.im;
      const modulus = Math.hypot(a, b);
      const argument = Math.atan2(b, a);
      const newModulus = Math.pow(modulus, 1 / exponent);
      const newArgument = argument / exponent;
      return this.clone({
        re: newModulus * Math.cos(newArgument),
        im: newModulus * Math.sin(newArgument)
      });
    }
    sqrt() {
      if (this.isNaN) return this._makeExact(NaN);
      if (this.isZero || this.isOne) return this;
      if (this.im !== 0) {
        const a = this.decimal;
        const b = this.im;
        const modulus = Math.sqrt(a * a + b * b);
        const realPart = Math.sqrt((a + modulus) / 2);
        const imaginaryPart = Math.sign(b) * Math.sqrt((modulus - a) / 2);
        return this.clone({ re: realPart, im: imaginaryPart });
      }
      if (this.decimal > 0) return this.clone(Math.sqrt(this.decimal));
      return this.clone({ im: Math.sqrt(-this.decimal) });
    }
    gcd(other) {
      if (this.isNaN) return this._makeExact(NaN);
      if (this.isZero) return other;
      if (other.isZero) return this;
      if (this.im !== 0 || other.im !== 0) return this._makeExact(NaN);
      if (!Number.isInteger(this.decimal)) return this._makeExact(1);
      let b = other.re;
      if (!Number.isInteger(b)) return this._makeExact(1);
      let a = this.decimal;
      while (b !== 0) {
        const t = b;
        b = a % b;
        a = t;
      }
      return this.clone(Math.abs(a));
    }
    abs() {
      if (this.isNaN) return this._makeExact(NaN);
      if (this.im === 0)
        return this.decimal > 0 ? this : this.clone(-this.decimal);
      return this.clone(Math.sqrt(this.decimal ** 2 + this.im ** 2));
    }
    ln(base) {
      if (this.isNaN) return this._makeExact(NaN);
      if (this.isZero) return this._makeExact(NaN);
      if (this.isNegativeInfinity) return this._makeExact(NaN);
      if (this.isPositiveInfinity) return this._makeExact(Infinity);
      if (this.im === 0) {
        if (this.decimal < 0) return this._makeExact(NaN);
        if (this.isOne) return this._makeExact(0);
        if (this.isNegativeOne) return this.clone({ im: Math.PI });
        if (base === void 0) return this.clone(Math.log(this.decimal));
        return this.clone(Math.log(this.decimal) / Math.log(base));
      }
      const a = this.decimal;
      const b = this.im;
      const modulus = Math.hypot(a, b);
      const argument = Math.atan2(b, a);
      const decimal = base === void 0 ? Math.log(modulus) : Math.log(modulus) / Math.log(base);
      return this.clone({ re: decimal, im: argument });
    }
    exp() {
      if (this.isNaN) return this._makeExact(NaN);
      if (this.isZero) return this._makeExact(1);
      if (this.isNegativeInfinity) return this._makeExact(0);
      if (this.isPositiveInfinity) return this._makeExact(Infinity);
      if (this.im !== 0) {
        const e = Math.exp(this.decimal);
        return this.clone({
          re: e * Math.cos(this.im),
          im: e * Math.sin(this.im)
        });
      }
      return this.clone(Math.exp(this.decimal));
    }
    floor() {
      if (this.isNaN || this.im !== 0) return this._makeExact(NaN);
      if (Number.isInteger(this.decimal)) return this;
      return this._makeExact(Math.floor(this.decimal));
    }
    ceil() {
      if (this.isNaN || this.im !== 0) return this._makeExact(NaN);
      if (Number.isInteger(this.decimal)) return this;
      return this._makeExact(Math.ceil(this.decimal));
    }
    round() {
      if (this.isNaN || this.im !== 0) return this._makeExact(NaN);
      if (Number.isInteger(this.decimal)) return this;
      return this._makeExact(Math.round(this.decimal));
    }
    eq(other) {
      if (this.isNaN) return false;
      if (typeof other === "number")
        return this.im === 0 && this.decimal - other === 0;
      if (other.isNaN) return false;
      if (!Number.isFinite(this.im)) return !Number.isFinite(other.im);
      return this.decimal - other.re === 0 && this.im - other.im === 0;
    }
    lt(other) {
      if (this.im !== 0) ;
      if (typeof other === "number") return this.decimal < other;
      return this.decimal < other.re;
    }
    lte(other) {
      if (this.im !== 0) ;
      if (typeof other === "number") return this.decimal <= other;
      return this.decimal <= other.re;
    }
    gt(other) {
      if (this.im !== 0) ;
      if (typeof other === "number") return this.decimal > other;
      return this.decimal > other.re;
    }
    gte(other) {
      if (this.im !== 0) ;
      if (typeof other === "number") return this.decimal >= other;
      return this.decimal >= other.re;
    }
  };
  function chop3(n) {
    return Math.abs(n) <= 1e-14 ? 0 : n;
  }

  // src/compute-engine/boxed-expression/terms.ts
  var Terms = class {
    constructor(ce, terms) {
      this.terms = [];
      this.engine = ce;
      let posInfinityCount = 0;
      let negInfinityCount = 0;
      const numericValues = [];
      for (const term of terms) {
        if (term.type.is("complex") && term.isInfinity) {
          this.terms = [{ term: ce.ComplexInfinity, coef: [] }];
          return;
        }
        if (term.isNaN || term.symbol === "Undefined") {
          this.terms = [{ term: ce.NaN, coef: [] }];
          return;
        }
        const [coef, rest] = term.toNumericValue();
        if (coef.isPositiveInfinity) posInfinityCount += 1;
        else if (coef.isNegativeInfinity) negInfinityCount += 1;
        if (rest.is(1)) {
          if (!coef.isZero) numericValues.push(coef);
        } else this.add(coef, rest);
      }
      if (posInfinityCount > 0 && negInfinityCount > 0) {
        this.terms = [{ term: ce.NaN, coef: [] }];
        return;
      }
      if (posInfinityCount > 0) {
        this.terms = [{ term: ce.PositiveInfinity, coef: [] }];
        return;
      }
      if (negInfinityCount > 0) {
        this.terms = [{ term: ce.NegativeInfinity, coef: [] }];
        return;
      }
      if (numericValues.length === 1) {
        this.add(numericValues[0], ce.One);
      } else if (numericValues.length > 0) {
        nvSum(ce, numericValues).forEach((x) => this.add(x, ce.One));
      }
    }
    add(coef, term) {
      if (term.is(0) || coef.isZero) return;
      if (term.is(1)) {
        const ce = this.engine;
        this.terms.push({ coef: [], term: ce.number(coef) });
        return;
      }
      if (term.operator === "Add") {
        for (const x of term.ops) {
          const [c, t] = x.toNumericValue();
          this.add(coef.mul(c), t);
        }
        return;
      }
      if (term.operator === "Negate") {
        this.add(coef.neg(), term.op1);
        return;
      }
      const i = this.find(term);
      if (i >= 0) {
        this.terms[i].coef.push(coef);
        return;
      }
      console.assert(term.numericValue === null || term.is(1));
      this.terms.push({ coef: [coef], term });
    }
    find(term) {
      return this.terms.findIndex((x) => x.term.isSame(term));
    }
    N() {
      const ce = this.engine;
      const terms = this.terms;
      if (terms.length === 0) return ce.Zero;
      const rest = [];
      const numericValues = [];
      for (const { coef, term } of terms) {
        if (coef.length === 0) {
          if (term.isNumberLiteral) {
            if (typeof term.numericValue === "number")
              numericValues.push(ce._numericValue(term.numericValue));
            else numericValues.push(term.numericValue);
          } else rest.push(term);
        } else {
          const sum3 = coef.reduce((acc, x) => acc.add(x)).N();
          if (sum3.isZero) continue;
          if (sum3.eq(1)) rest.push(term.N());
          else if (sum3.eq(-1)) rest.push(term.N().neg());
          else rest.push(term.N().mul(ce.box(sum3)));
        }
      }
      const sum2 = nvSumN(ce, numericValues);
      if (!sum2.isZero) {
        if (rest.length === 0) return ce.box(sum2);
        rest.push(ce.box(sum2));
      }
      return canonicalAdd(ce, rest);
    }
    asExpression() {
      const ce = this.engine;
      const terms = this.terms;
      if (terms.length === 0) return ce.Zero;
      return canonicalAdd(
        ce,
        terms.map(({ coef, term }) => {
          if (coef.length === 0) return term;
          const coefs = nvSum(ce, coef);
          if (coefs.length === 0) return term;
          if (coefs.length > 1) {
            return canonicalMultiply(ce, [
              canonicalAdd(
                ce,
                coefs.map((x) => ce.box(x))
              ),
              term
            ]);
          }
          const sum2 = coefs[0];
          if (sum2.isNaN) return ce.NaN;
          if (sum2.isZero) return ce.Zero;
          if (sum2.eq(1)) return term;
          if (sum2.eq(-1)) return term.neg();
          if (term.is(1)) return ce.box(sum2);
          return term.mul(ce.box(sum2));
        })
      );
    }
  };
  function nvSum(ce, numericValues) {
    const bignum = (x) => ce.bignum(x);
    const makeExact = (x) => new ExactNumericValue(x, factory, bignum);
    const factory = ce.precision > MACHINE_PRECISION ? (x) => new BigNumericValue(x, bignum) : (x) => new MachineNumericValue(x, makeExact);
    return ExactNumericValue.sum(numericValues, factory, bignum);
  }
  function nvSumN(ce, numericValues) {
    const bignum = (x) => ce.bignum(x);
    const makeExact = (x) => new ExactNumericValue(x, factory, bignum);
    const factory = ce.precision > MACHINE_PRECISION ? (x) => new BigNumericValue(x, bignum) : (x) => new MachineNumericValue(x, makeExact);
    const result = ExactNumericValue.sum(numericValues, factory, bignum);
    if (result.length === 0) return makeExact(0);
    if (result.length === 1) return result[0].N();
    return result.reduce((acc, x) => acc.add(x).N());
  }

  // src/compute-engine/boxed-expression/arithmetic-add.ts
  function canonicalAdd(ce, ops) {
    ops = flatten(ops, "Add");
    ops = ops.filter((x) => x.numericValue === null || !x.is(0));
    if (ops.length === 0) return ce.Zero;
    if (ops.length === 1 && !isIndexableCollection(ops[0])) return ops[0];
    const xs = [];
    for (let i = 0; i < ops.length; i++) {
      const op = ops[i];
      if (op.isNumberLiteral) {
        const nv = op.numericValue;
        if (typeof nv === "number" || isSubtype(nv.type, "real") && !nv.isExact || isSubtype(nv.type, "integer")) {
          const next = ops[i + 1];
          if (next) {
            const fac = getImaginaryFactor(next)?.numericValue;
            if (fac !== void 0) {
              const im = typeof fac === "number" ? fac : fac?.re;
              if (im !== 0) {
                const re = typeof nv === "number" ? nv : nv.re;
                xs.push(ce.number(ce._numericValue({ re, im: im ?? 0 })));
                i++;
                continue;
              }
            }
          }
        }
      }
      xs.push(op);
    }
    if (xs.length === 1) return xs[0];
    return ce._fn("Add", [...xs].sort(addOrder));
  }
  function addType(args) {
    if (args.length === 0) return "finite_integer";
    if (args.length === 1) return args[0].type;
    return widen(...args.map((x) => x.type.type));
  }
  function add3(...xs) {
    console.assert(xs.length > 0);
    if (!xs.every((x) => x.isValid)) return xs[0].engine._fn("Add", xs);
    return new Terms(xs[0].engine, xs).asExpression();
  }
  function addN(...xs) {
    console.assert(xs.length > 0);
    if (!xs.every((x) => x.isValid)) return xs[0].engine._fn("Add", xs);
    xs = xs.map((x) => x.isNumberLiteral ? x.evaluate() : x.N());
    return new Terms(xs[0].engine, xs).N();
  }

  // src/compute-engine/boxed-expression/compare.ts
  function same(a, b) {
    if (a === b) return true;
    if (a.ops) {
      if (a.operator !== b.operator) return false;
      if (a.nops !== b.nops) return false;
      return a.ops.every((op, i) => same(op, b.ops[i]));
    }
    if (a.isNumberLiteral) {
      if (!b.isNumberLiteral) return false;
      const av = a.numericValue;
      const bv = b.numericValue;
      if (av === bv) return true;
      if (typeof av === "number") {
        if (typeof bv === "number") return av === bv;
        return bv.eq(av);
      }
      return av.eq(bv);
    }
    if (a.string || b.string) return a.string === b.string;
    if (a.symbol || b.symbol) return a.symbol === b.symbol;
    if (a.rank !== 0) {
      if (a.rank !== b.rank) return false;
      for (let i = 0; i < a.rank; i++)
        if (a.shape[i] !== b.shape[i]) return false;
      return a.tensor.equals(
        b.tensor
      );
    }
    return false;
  }
  function eq(a, inputB) {
    if (a.functionDefinition?.eq) {
      const cmp2 = a.functionDefinition.eq(a, a.engine.box(inputB));
      if (cmp2 !== void 0) return cmp2;
    }
    if (typeof inputB !== "number" && inputB.functionDefinition?.eq) {
      const cmp2 = inputB.functionDefinition.eq(inputB, a);
      if (cmp2 !== void 0) return cmp2;
    }
    a = a.N();
    let b = typeof inputB !== "number" ? inputB.N() : a.engine.box(inputB);
    if (a.ops || b.ops) {
      let cmp2 = a.functionDefinition?.eq?.(a, b);
      if (cmp2 !== void 0) return cmp2;
      cmp2 = b.functionDefinition?.eq?.(b, a);
      if (cmp2 !== void 0) return cmp2;
      if (a.isSame(b)) return true;
      if (a.unknowns.length === 0 && b.unknowns.length === 0) {
        if (a.isFinite && b.isFinite)
          return isZeroWithTolerance(a.sub(b).simplify().N());
        if (a.isNaN || b.isNaN) return false;
        if (a.isInfinity && b.isInfinity && a.sgn === b.sgn) return true;
        return false;
      }
      a = a.expand().simplify();
      b = b.expand().simplify();
      if (!sameUnknowns(a, b)) return void 0;
      return same(a, b);
    }
    if (a.symbol) {
      const cmp2 = a.symbolDefinition?.eq?.(b);
      if (cmp2 !== void 0) return cmp2;
    }
    if (b.symbol) {
      const cmp2 = b.symbolDefinition?.eq?.(a);
      if (cmp2 !== void 0) return cmp2;
    }
    if (a.symbol && b.symbol) return a.symbol === b.symbol;
    const ce = a.engine;
    if (a.isNumberLiteral && b.isNumberLiteral) {
      if (a.isFinite && b.isFinite) return isZeroWithTolerance(a.sub(b));
      if (a.isNaN || b.isNaN) return false;
      if (a.isInfinity && b.isInfinity && a.sgn === b.sgn) return true;
      return false;
    }
    if (ce.ask(ce.box(["Equal", a, b])).length > 0) return true;
    if (ce.ask(ce.box(["NotEqual", a, b])).length > 0) return false;
    if (a.unknowns.length > 0 || b.unknowns.length > 0) return void 0;
    return same(a, b);
  }
  function cmp(a, b) {
    if (a.isNumberLiteral) {
      if (typeof b !== "number" && typeof b.numericValue === "number")
        b = b.numericValue;
      if (typeof b === "number") {
        if (b === 0) {
          const s = a.sgn;
          if (s === void 0) return void 0;
          if (s === "zero") return "=";
          if (s === "positive" || s === "positive-infinity") return ">";
          if (s === "negative" || s === "negative-infinity") return "<";
          if (s === "non-negative") return ">=";
          if (s === "non-positive") return "<=";
          return void 0;
        }
        if (a.isNumberLiteral) {
          const av2 = a.numericValue;
          if (typeof av2 === "number") {
            if (Math.abs(av2 - b) <= a.engine.tolerance) return "=";
            return av2 < b ? "<" : ">";
          }
          if (av2.eq(b)) return "=";
          return av2.lt(b) ? "<" : ">";
        }
        return void 0;
      }
      if (!b.isNumberLiteral) return void 0;
      const av = a.numericValue;
      const bv = b.numericValue;
      if (typeof av === "number") {
        if (bv.eq(av)) return "=";
        if (bv.lt(av)) return ">";
        return "<";
      }
      return av.eq(bv) ? "=" : av.lt(bv) ? "<" : ">";
    }
    if (typeof b === "number") return void 0;
    if (a.ops || b.ops) {
      const cmp2 = a.functionDefinition?.eq?.(a, b);
      if (cmp2 !== void 0) return "=";
      const diff = a.sub(b).N();
      if (!diff.isNumberLiteral) return void 0;
      if (typeof diff.numericValue === "number") {
        if (diff.numericValue === 0) return "=";
        return diff.numericValue < 0 ? "<" : ">";
      }
      const tol = a.engine.tolerance;
      if (diff.numericValue.isZeroWithTolerance(tol)) return "=";
      return diff.numericValue.lt(0) ? "<" : ">";
    }
    if (a.symbol) {
      if (a.symbol === b.symbol) return "=";
      const cmp2 = a.symbolDefinition?.cmp?.(b);
      if (cmp2) return cmp2;
      const eq2 = a.symbolDefinition?.eq?.(b);
      if (eq2 === true) return "=";
      return void 0;
    }
    if (a.string) {
      if (!b.string) return void 0;
      if (a.string === b.string) return "=";
      return a.string < b.string ? "<" : ">";
    }
    if (a.tensor) {
      if (!b.tensor) return void 0;
      if (a.tensor.equals(b.tensor))
        return "=";
      return void 0;
    }
    return void 0;
  }
  function isZeroWithTolerance(expr) {
    if (!expr.isNumberLiteral) return false;
    const n = expr.numericValue;
    const ce = expr.engine;
    if (typeof n === "number") return ce.chop(n) === 0;
    return n.isZeroWithTolerance(ce.tolerance);
  }
  function sameUnknowns(a, b) {
    const ua = a.unknowns;
    const ub = b.unknowns;
    if (ua.length !== ub.length) return false;
    for (const u of ua) if (!ub.includes(u)) return false;
    return true;
  }

  // src/compute-engine/function-utils.ts
  function canonicalFunctionExpression(body, args = []) {
    const params = args.map((x, i2) => {
      if (!x.symbol || x.symbol === "Nothing") return `_${i2 + 1}`;
      return x.symbol;
    });
    let unknowns = body.unknowns;
    if (unknowns.includes("_")) {
      body = body.subs({ _: "_1" });
      unknowns = body.unknowns;
    }
    let count = params.length;
    for (const unknown of unknowns) {
      if (unknown.startsWith("_")) {
        const n = Number(unknown.slice(1));
        if (n <= params.length) body = body.subs({ [unknown]: params[n - 1] });
        if (n > count) count = n;
      }
    }
    for (let i2 = params.length; i2 < count; i2++) params.push(`_${i2 + 1}`);
    let i = count;
    while (i > 0) {
      if (params[i - 1] === `_${i}`) {
        if (!unknowns.includes(`_${i}`)) params.pop();
      } else break;
      i--;
    }
    return [body, ...params];
  }
  function makeLambda(expr) {
    const ce = expr.engine;
    if (expr.symbol) {
      const fnDef = ce.lookupFunction(expr.symbol);
      if (fnDef) {
        const fn2 = fnDef.evaluate;
        if (fn2) return (xs) => fn2(xs, { engine: ce }) ?? ce._fn(expr.symbol, xs);
        return (xs) => ce._fn(expr.symbol, xs);
      }
    }
    let canonicalFn;
    if (expr.operator === "Function") {
      canonicalFn = canonicalFunctionExpression(expr.op1, expr.ops.slice(1));
    } else canonicalFn = canonicalFunctionExpression(expr);
    const [body, ...params] = canonicalFn;
    ce.pushScope();
    for (const param of params)
      ce.declare(param, { inferred: true, type: "unknown" });
    const fn = body.canonical;
    fn.bind();
    ce.popScope();
    const fnScope = fn.scope;
    if (!fnScope) return () => fn.N() ?? fn.evaluate();
    if (params.length === 0) {
      return () => {
        const context = ce.swapScope(fnScope);
        ce.resetContext();
        const result = fn.N() ?? fn.evaluate();
        ce.swapScope(context);
        return result;
      };
    }
    return (args) => {
      if (args.length > params.length) return void 0;
      if (ce.strict && !args.every((x) => x.isValid)) return void 0;
      if (args.length < params.length) {
        const extras = params.slice(args.length).map((x, i2) => ce.symbol(`_${i2 + 1}`));
        const newBody = apply3(ce.function("Function", [body, ...params]), [
          ...args,
          ...extras
        ]).evaluate();
        return ce.function("Function", [newBody]);
      }
      args = args.map((x) => x.evaluate());
      const context = ce.swapScope(fnScope);
      ce.resetContext();
      let i = 0;
      for (const param of params) ce.assign(param, args[i++]);
      const result = fn.evaluate();
      ce.swapScope(context);
      return result.isValid ? result : void 0;
    };
  }
  function apply3(fn, args) {
    const result = makeLambda(fn)?.(args);
    if (result) return result;
    return fn.engine.function("Apply", [fn, ...args]);
  }
  function applicable(fn) {
    return makeLambda(fn) ?? ((xs) => fn.engine.function("Apply", [fn.N(), ...xs]).N());
  }
  function applicableN1(fn) {
    const ce = fn.engine;
    const lambda = makeLambda(fn);
    if (lambda) return (x) => lambda([ce.number(x)])?.value ?? NaN;
    return (x) => ce.function("Apply", [fn.evaluate(), ce.number(x)]).value;
  }
  function parseFunctionSignature(s) {
    const m = s.match(/(.+)\((.*)\)/);
    if (!m) return [s, void 0];
    const id = m[1];
    const args = m[2].split(",").map((x) => x.trim());
    return [id, args];
  }

  // src/compute-engine/numerics/interval.ts
  function interval(expr) {
    if (expr.operator === "Interval") {
      let op1 = expr.op1;
      let op2 = expr.op2;
      let openStart = false;
      let openEnd = false;
      if (op1.operator === "Open") {
        openStart = true;
        op1 = op1.op1;
      } else if (op1.operator === "Closed") {
        op1 = op1.op1;
      }
      if (op2.operator === "Open") {
        openEnd = true;
        op2 = op2.op1;
      } else if (op2.operator === "Closed") {
        op2 = op2.op1;
      }
      const start = op1.N();
      const end = op2.N();
      if (!start.isNumberLiteral || !end.isNumberLiteral) return void 0;
      return { start: start.re, openStart, end: end.re, openEnd };
    }
    if (expr.symbol === "EmptySet")
      return { start: 0, openStart: true, end: 0, openEnd: true };
    if (expr.symbol === "RealNumbers")
      return {
        start: -Infinity,
        openStart: false,
        end: Infinity,
        openEnd: false
      };
    if (expr.symbol === "NegativeNumbers")
      return { start: -Infinity, openStart: false, end: 0, openEnd: true };
    if (expr.symbol === "NonPositiveNumbers")
      return { start: -Infinity, openStart: false, end: 0, openEnd: false };
    if (expr.symbol === "PositiveNumbers")
      return { start: 0, openStart: true, end: Infinity, openEnd: false };
    if (expr.symbol === "NonNegativeNumbers")
      return { start: 0, openStart: false, end: Infinity, openEnd: false };
    return void 0;
  }

  // src/compute-engine/library/collections.ts
  var DEFAULT_LINSPACE_COUNT = 50;
  var COLLECTIONS_LIBRARY = {
    //
    // Data Structures
    //
    List: {
      complexity: 8200,
      signature: "(...any) -> list",
      type: (ops) => parseType(`list<${widen(...ops.map((op) => op.type.type))}>`),
      canonical: canonicalList,
      eq: defaultCollectionEq,
      collection: defaultCollectionHandlers2()
    },
    // Extensional set. Elements do not repeat. The order of the elements is not significant.
    // For intensional set, use `Filter` with a condition, e.g. `Filter(RealNumbers, _ > 0)` @todo
    Set: {
      complexity: 8200,
      signature: "(...any) -> set",
      type: (ops) => parseType(`set<${widen(...ops.map((op) => op.type.type))}>`),
      canonical: canonicalSet,
      eq: (a, b) => {
        if (a.operator !== b.operator) return false;
        if (a.nops !== b.nops) return false;
        const has = (x) => b.ops.some((y) => x.isSame(y));
        return a.ops.every(has);
      },
      collection: {
        ...defaultCollectionHandlers2(),
        // A set is not indexable
        at: void 0,
        indexOf: void 0
      }
    },
    Dictionary: {
      complexity: 8200,
      signature: "(...(string | tuple<string|symbol, expression>)) -> map",
      type: (ops) => parseType(
        `tuple<${Object.entries(keyValues(ops)).map(([k, v]) => k ? `${k}: ${v.type}` : v.type).join(", ")}>`
      ),
      canonical: (ops, { engine }) => {
        const entries = {};
        for (const op of ops) {
          const dict = canonicalDictionary(engine, op);
          if (dict.operator === "Dictionary") {
            for (const entry of dict.ops) {
              console.assert(entry.operator === "Tuple");
              const [k, v] = entry.ops;
              entries[k.string ?? k.symbol] = v;
            }
          }
        }
        return engine._fn(
          "Dictionary",
          Object.entries(entries).map(
            ([k, v]) => engine._fn("Tuple", [engine.string(k), v])
          )
        );
      },
      eq: (a, b) => {
        if (a.operator !== b.operator) return false;
        if (a.nops !== b.nops) return false;
        const akv = keyValues(a.ops);
        const bkv = keyValues(b.ops);
        return Object.entries(akv).every(([k, v]) => {
          const bv = bkv[k];
          return bv && v.isSame(bv);
        });
      },
      collection: {
        ...defaultCollectionHandlers2(),
        // A map is not indexable
        at: (_expr, _index) => void 0,
        indexOf: (_expr, _target) => void 0,
        elttype: (expr) => parseType("tuple<string, any>")
      }
    },
    Range: {
      complexity: 8200,
      signature: "(number, number?, step: number?) -> collection<integer>",
      eq: (a, b) => {
        if (a.operator !== b.operator) return false;
        const [al, au, as] = range(a);
        const [bl, bu, bs] = range(b);
        return al === bl && au === bu && as === bs;
      },
      collection: {
        size: (expr) => {
          const [lower, upper, step] = range(expr);
          if (step === 0) return 0;
          if (!isFinite(lower) || !isFinite(upper)) return Infinity;
          return 1 + Math.max(0, Math.floor((upper - lower) / step));
        },
        contains: (expr, target) => {
          if (!target.type.matches("integer")) return false;
          const t = target.re;
          const [lower, upper, step] = range(expr);
          if (step === 0) return false;
          if (step > 0) return t >= lower && t <= upper;
          return t <= lower && t >= upper;
        },
        iterator: (expr, start, count) => {
          const [lower, upper, step] = range(expr);
          let index = start ?? 1;
          const maxCount = step === 0 ? 0 : Math.floor((upper - lower) / step) + 1;
          count = Math.min(count ?? maxCount, maxCount);
          if (count <= 0)
            return { next: () => ({ value: void 0, done: true }) };
          return {
            next: () => {
              if (count > 0) {
                count--;
                return {
                  value: expr.engine.number(lower + step * (index++ - 1)),
                  done: false
                };
              } else {
                return { value: void 0, done: true };
              }
            }
          };
        },
        // Return the nth step of the range.
        // Questionable if this is useful.
        at: (expr, index) => {
          if (typeof index !== "number") return void 0;
          const [lower, upper, step] = range(expr);
          if (index < 1 || index > 1 + (upper - lower) / step) return void 0;
          return expr.engine.number(lower + step * (index - 1));
        },
        indexOf: void 0,
        subsetOf: (expr, target) => {
          if (target.operator === "Range") {
            const [al, au, as] = range(expr);
            const [bl, bu, bs] = range(target);
            return al >= bl && au <= bu && as % bs === 0;
          }
          if (!isFiniteCollection(target)) return false;
          const def = target.baseDefinition;
          if (!def?.collection?.iterator || !def?.collection?.at) return false;
          let i = 1;
          for (const x of each(target)) {
            if (!expr.contains(x)) return false;
            if (!expr.at(i)?.isSame(x)) return false;
            i++;
          }
          return true;
        },
        eltsgn: (expr) => {
          const [lower, upper, step] = range(expr);
          if (step === 0) return "zero";
          if (step > 0) return lower <= upper ? "positive" : "negative";
          return lower >= upper ? "positive" : "negative";
        },
        elttype: (_expr) => "finite_integer"
      }
    },
    Interval: {
      description: "A set of real numbers between two endpoints. The endpoints may or may not be included.",
      complexity: 8200,
      lazy: true,
      signature: "(expression, expression) -> set<real>",
      eq: (a, b) => {
        const intervalA = interval(a);
        const intervalB = interval(b);
        if (!intervalA || !intervalB) return false;
        return intervalA.start === intervalB.start && intervalA.end === intervalB.end && intervalA.openStart === intervalB.openStart && intervalA.openEnd === intervalB.openEnd;
      },
      collection: {
        size: (_expr) => Infinity,
        contains: (expr, target) => {
          const int = interval(expr);
          if (!int) return false;
          if (int.openStart && target.isLessEqual(int.start)) return false;
          if (int.openEnd && target.isGreaterEqual(int.end)) return false;
          return target.isGreaterEqual(int.start) && target.isLessEqual(int.end);
        },
        eltsgn: (expr) => {
          const i = interval(expr);
          if (!i) return "unsgined";
          if (i.start === i.end) return "unsigned";
          if (i.start >= 0 && !i.openStart) return "non-negative";
          if (i.end <= 0 && !i.openEnd) return "non-positive";
          if (i.start > 0 && i.end > 0) return "positive";
          if (i.start < 0 && i.end < 0) return "negative";
          return void 0;
        },
        elttype: (expr) => {
          const i = interval(expr);
          if (!i) return "never";
          if (isFinite(i.start) && isFinite(i.end)) return "finite_real";
          return "real";
        }
      }
    },
    Linspace: {
      complexity: 8200,
      signature: "(start: number, end: number?, count: number?) -> collection",
      // @todo: the canonical form should consider if this can be simplified to a range (if the elements are integers)
      // @todo: need eq handler
      collection: {
        size: (expr) => {
          let count = expr.op3.re;
          if (!isFinite(count)) count = DEFAULT_LINSPACE_COUNT;
          return Math.max(0, Math.floor(count));
        },
        at: (expr, index) => {
          if (typeof index !== "number") return void 0;
          const lower = expr.op1.re;
          const upper = expr.op2.re;
          let count = expr.op3.re;
          if (!isFinite(count)) count = DEFAULT_LINSPACE_COUNT;
          if (!isFinite(lower) || !isFinite(upper)) return void 0;
          if (index < 1 || index > count) return void 0;
          return expr.engine.number(
            lower + (upper - lower) * (index - 1) / count
          );
        },
        iterator: (expr, start, count) => {
          let lower = expr.op1.re;
          let upper = expr.op2.re;
          let totalCount;
          if (!isFinite(upper)) {
            upper = lower;
            lower = 1;
            totalCount = DEFAULT_LINSPACE_COUNT;
          } else
            totalCount = Math.max(
              0,
              !isFinite(expr.op3.re) ? DEFAULT_LINSPACE_COUNT : expr.op3.re
            );
          let index = start ?? 1;
          count = Math.min(count ?? totalCount, totalCount);
          if (count <= 0)
            return { next: () => ({ value: void 0, done: true }) };
          return {
            next: () => {
              if (count > 0) {
                count--;
                return {
                  value: expr.engine.number(
                    lower + (upper - lower) * (index++ - 1) / totalCount
                  ),
                  done: false
                };
              } else {
                return { value: void 0, done: true };
              }
            }
          };
        },
        contains: (expr, target) => {
          if (!target.type.matches("finite_real")) return false;
          const t = target.re;
          const lower = expr.op1.re;
          const upper = expr.op2.re;
          if (t < lower || t > upper) return false;
          let count = expr.op3.re;
          if (!isFinite(count)) count = DEFAULT_LINSPACE_COUNT;
          if (count === 0) return false;
          const step = (upper - lower) / count;
          return (t - lower) % step === 0;
        }
      }
    },
    Tuple: {
      description: "A fixed number of heterogeneous elements",
      complexity: 8200,
      signature: "(...any) -> tuple",
      type: (ops) => parseType(`tuple<${ops.map((op) => op.type).join(", ")}>`),
      canonical: (ops, { engine }) => engine.tuple(...ops),
      eq: defaultCollectionEq,
      collection: {
        size: (expr) => expr.nops,
        contains: (expr, target) => expr.ops.some((x) => x.isSame(target)),
        keys: (expr) => {
          return ["first", "second", "last"];
        },
        at: (expr, index) => {
          if (typeof index !== "number") return void 0;
          return expr.ops[index - 1];
        }
      }
    },
    KeyValuePair: {
      description: "A key/value pair",
      complexity: 8200,
      signature: "(key: string, value: any) -> tuple<string, unknown>",
      type: ([key, value]) => parseType(`tuple<string, ${value.type}>`),
      canonical: (args, { engine }) => {
        const [key, value] = checkTypes(engine, args, ["string", "any"]);
        if (!key.isValid || !value.isValid)
          return engine._fn("KeyValuePair", [key, value]);
        return engine.tuple(key, value);
      }
    },
    Single: {
      description: "A tuple with a single element",
      complexity: 8200,
      signature: "(value: any) -> tuple<any>",
      type: ([value]) => parseType(`tuple<${value.type}>`),
      canonical: (ops, { engine }) => engine.tuple(...checkArity(engine, ops, 1))
    },
    Pair: {
      description: "A tuple of two elements",
      complexity: 8200,
      signature: "(first: any, second: any) -> tuple<any, any>",
      type: ([first, second]) => parseType(`tuple<${first.type}, ${second.type}>`),
      canonical: (ops, { engine }) => engine.tuple(...checkArity(engine, ops, 2))
    },
    Triple: {
      description: "A tuple of three elements",
      complexity: 8200,
      signature: "(first: any, second: any, third: any) -> tuple<any, any, any>",
      type: ([first, second, third]) => parseType(`tuple<${first.type}, ${second.type}, ${third.type}>`),
      canonical: (ops, { engine }) => engine.tuple(...checkArity(engine, ops, 3))
    },
    // This is a string interpolation function, not a string literal
    String: {
      threadable: true,
      signature: "(...any) -> string",
      evaluate: (ops, { engine }) => {
        if (ops.length === 0) return engine.string("");
        return engine.string(ops.map((x) => x.string ?? x.toString()).join(""));
      }
    },
    //
    // Functions
    //
    Length: {
      complexity: 8200,
      signature: "any -> integer",
      evaluate: ([x], { engine }) => engine.number(length2(x)),
      sgn: ([xs]) => length2(xs) === 0 ? "zero" : "positive"
    },
    IsEmpty: {
      complexity: 8200,
      signature: "any -> boolean",
      evaluate: ([x], { engine: ce }) => length2(x) === 0 ? ce.True : ce.False
    },
    At: {
      description: [
        "Access an element of a collection or a character of a string.",
        "If the index is negative, it is counted from the end.",
        "If the collection has a rank greater than 1, the index is a tuple of indexes.",
        "If the index is a list, each element of the list is used as an index and the result if a list of the elements."
      ],
      complexity: 8200,
      signature: "(value: list|tuple|string, index: number | string) -> unknown",
      evaluate: (ops, { engine: ce }) => {
        let expr = ops[0];
        let index = 1;
        while (ops[index]) {
          const def = expr.baseDefinition;
          const at2 = def?.collection?.at;
          if (!at2) return void 0;
          const s = ops[index].string;
          if (s !== null) expr = at2(expr, s) ?? ce.Nothing;
          else {
            const i = ops[index].re;
            if (!Number.isInteger(i)) return void 0;
            expr = at2(expr, i) ?? ce.Nothing;
          }
          index += 1;
        }
        return expr;
      }
    },
    // Note: Take is similar to `take` in Haskell
    // @todo: do a lazy version of this (implemented as a collection handler)
    Take: {
      description: [
        "Take a range of elements from a collection or a string.",
        "If the index is negative, it is counted from the end."
      ],
      complexity: 8200,
      signature: "(value: collection|string, count: number) -> list|string",
      type: (ops) => {
        if (ops[0].type.matches("string")) return "string";
        return parseType(`list<${collectionElementType(ops[0].type.type)}>`);
      },
      evaluate: (ops, { engine: ce }) => {
        if (ops.length < 2) return void 0;
        const s = ops[0].string;
        if (s !== null) {
          const indexes2 = ops.slice(1).map((op) => indexRangeArg(op, s.length));
          return ce.string(sliceString(s, indexes2));
        }
        const l = length2(ops[0]);
        return slice(
          ops[0],
          ops.slice(1).map((op) => indexRangeArg(op, l))
        );
      }
    },
    // Similar to `drop` in Haskell
    // @todo: do a lazy version of this (implemented as a collection handler)
    Drop: {
      complexity: 8200,
      signature: "(value: collection|string, indexes: ...(number | string)) -> list",
      evaluate: (ops, { engine: ce }) => {
        if (ops.length < 2) return void 0;
        const s = ops[0].string;
        if (s !== null) {
          const xs2 = indexes(
            ops.slice(1).map((op) => indexRangeArg(op, s.length))
          );
          return ce.string(
            s.split("").filter((_c, i) => !xs2.includes(i + 1)).join("")
          );
        }
        const def = ops[0].baseDefinition;
        const l = length2(ops[0]);
        if (l === 0) return ce.Nothing;
        const at2 = def?.collection?.at;
        if (!at2) return void 0;
        const xs = indexes(ops.slice(1).map((op) => indexRangeArg(op, l)));
        const result = [];
        for (let i = 1; i <= l; i++)
          if (!xs.includes(i)) {
            const val = at2(ops[0], i);
            if (val) result.push(val);
          }
        return ce.function("List", result);
      }
    },
    First: {
      complexity: 8200,
      signature: "(value: collection|string) -> any",
      // @todo: resultType
      evaluate: ([xs], { engine: ce }) => at(xs, 1) ?? ce.Nothing
    },
    Second: {
      complexity: 8200,
      signature: "(value: collection|string) -> any",
      // @todo: resultType
      evaluate: ([xs], { engine: ce }) => at(xs, 2) ?? ce.Nothing
    },
    Last: {
      complexity: 8200,
      signature: "(value: collection|string) -> any",
      // @todo: resultType
      evaluate: ([xs], { engine: ce }) => at(xs, -1) ?? ce.Nothing
    },
    Rest: {
      // @todo: do a lazy version of this (implemented as a collection handler)
      complexity: 8200,
      signature: "(value: collection|string) -> list",
      // @todo: resultType
      evaluate: (ops) => slice(ops[0], [[2, -1, 1]])
    },
    Slice: {
      description: [
        "Return a range of elements from a collection or a string.",
        "If the index is negative, it is counted from the end."
      ],
      complexity: 8200,
      signature: "(value: collection|string, start: number, end: number) -> list|string",
      type: (ops) => {
        if (ops[0].type.matches("string")) return "string";
        return parseType(`list<${collectionElementType(ops[0].type.type)}>`);
      },
      evaluate: (ops, { engine: ce }) => {
        if (ops.length < 3) return void 0;
        const s = ops[0].string;
        if (s !== null) {
          const [start2, end2] = ops.slice(1).map((op) => indexRangeArg(op, s.length));
          return ce.string(sliceString(s, [start2, end2]));
        }
        const l = length2(ops[0]);
        const [start, end] = ops.slice(1).map((op) => indexRangeArg(op, l));
        return slice(ops[0], [start, end]);
      }
    },
    Most: {
      // @todo: do a lazy version of this (implemented as a collection handler)
      complexity: 8200,
      signature: "(value: collection|string) -> list",
      // @todo: resultType
      evaluate: (ops) => slice(ops[0], [[1, -2, 1]])
    },
    Reverse: {
      // @todo: do a lazy version of this (implemented as a collection handler)
      complexity: 8200,
      signature: "(value: collection|string) -> collection",
      type: (ops) => ops[0].type,
      evaluate: ([xs]) => slice(xs, [[-1, 2, 1]])
    },
    // Return the indexes of the elements so they are in sorted order.
    // Sort is equivalent to `["Take", ["Ordering", expr, f]]`.
    // Equivalent to Grade Up `⍋` and Grade Down `⍒` return the indexes.
    // Equivalent to Ordering in Mathematica.
    Ordering: {
      complexity: 8200,
      lazy: true,
      signature: "(value: collection, f: function?) -> list<integer>",
      evaluate: (_ops) => {
        return void 0;
      }
    },
    Sort: {
      complexity: 8200,
      lazy: true,
      signature: "(value: collection, f: function?) -> collection",
      type: (ops) => ops[0].type,
      evaluate: (_ops) => {
        return void 0;
      }
    },
    // Randomize the order of the elements
    Shuffle: {
      complexity: 8200,
      signature: "(value: collection) -> collection",
      type: (ops) => ops[0].type,
      evaluate: (_ops) => {
        return void 0;
      }
    },
    // { f(x) for x in xs }
    // { 2x | x ∈ [ 1 , 10 ] }
    Map: {
      // @todo: do a lazy version of this (implemented as a collection handler)
      complexity: 8200,
      lazy: true,
      signature: "(collection, function) -> collection",
      // @todo: resultType
      evaluate: (ops, { engine: ce }) => {
        const [collection, fn] = collectionFunction(ops);
        if (!fn) return void 0;
        const result = [];
        for (const op of collection) result.push(fn([op]) ?? ce.Nothing);
        const h = ops[0].operator;
        const newHead = {
          List: "List",
          Set: "Set",
          Range: "List",
          Linspace: "List",
          Single: "List",
          Pair: "List",
          Triple: "List",
          Tuple: "List",
          String: "String"
        }[h] ?? "List";
        return ce.function(newHead, result);
      }
    },
    // [x for x in xs if p(x)]
    // [x | x in xs, p(x)]
    Filter: {
      // @todo: do a lazy version of this (implemented as a collection handler)
      complexity: 8200,
      lazy: true,
      signature: "(collection, function) -> collection",
      type: (ops) => ops[0].type,
      evaluate: (ops, { engine: ce }) => {
        const fn = applicable(ops[1]);
        if (!fn) return void 0;
        const collection = ops[0];
        if (collection.string) {
          return ce.string(
            collection.string.split("").map((c) => fn([ce.string(c)])?.symbol === "True" ? c : "").join("")
          );
        }
        if (!isFiniteIndexableCollection(ops[0]) || !ops[1]) return void 0;
        const result = [];
        for (const op of each(collection))
          if (fn([op])?.symbol === "True") result.push(op);
        const h = collection.operator;
        const newHead = {
          List: "List",
          Set: "Set",
          Range: "List",
          Linspace: "List",
          Single: "List",
          Pair: "List",
          Triple: "List",
          Tuple: "List"
        }[h] ?? "List";
        return ce.function(newHead, result);
      }
    },
    // Equivalent to "foldl" in Haskell
    // For "foldr", apply Reverse() first
    Reduce: {
      complexity: 8200,
      // @todo: do a lazy version of this (implemented as a collection handler)
      lazy: true,
      signature: "(collection, function, initial:value) -> collection",
      // @todo: resultType
      evaluate: (_ops) => {
        return void 0;
      }
    },
    Tabulate: {
      // @todo: do a lazy version of this (implemented as a collection handler)
      complexity: 8200,
      lazy: true,
      signature: "(function, integer, integer?) -> collection",
      evaluate: (ops, { engine: ce }) => {
        const fn = applicable(ops[0]);
        if (!fn) return void 0;
        if (ops.length === 1) return ce._fn("List", []);
        const dims = ops.slice(1).map((op) => asSmallInteger(op));
        if (dims.some((d) => d === null || d <= 0)) return void 0;
        if (dims.length === 1) {
          return ce._fn(
            "List",
            Array.from(
              { length: dims[0] ?? 0 },
              (_, i) => fn([ce.number(i + 1)]) ?? ce.Nothing
            )
          );
        }
        const fillArray = (dims2, index, level = 0) => {
          if (level === dims2.length) {
            const idx = index.map((i) => ce.number(i));
            return fn(idx);
          }
          const arr = ["List"];
          for (let i = 1; i <= dims2[level]; i++) {
            index[level] = i;
            arr.push(fillArray(dims2, index, level + 1));
          }
          return arr;
        };
        return ce.box(fillArray(dims, Array(dims.length).fill(0)));
      }
    },
    /* Return a tuple of the unique elements, and their respective count
     * Ex: Tally([a, c, a, d, a, c]) = [[a, c, d], [3, 2, 1]]
     */
    Tally: {
      complexity: 8200,
      signature: "(collection) -> tuple<list, list<integer>>",
      type: (ops) => parseType(
        `tuple<list<${collectionElementType(ops[0].type.type)}>, list<integer>>`
      ),
      evaluate: (ops, { engine: ce }) => {
        if (!isFiniteCollection(ops[0])) return void 0;
        const [values, counts] = tally(ops[0]);
        return ce.tuple(ce.function("List", values), ce.function("List", counts));
      }
    },
    // Return the first element of Tally()
    // Equivalent to `Union` in Mathematica, `distinct` in Scala,
    // Unique or Nub ∪, ↑ in APL
    Unique: {
      complexity: 8200,
      signature: "(collection) -> list",
      type: (ops) => parseType(`list<${collectionElementType(ops[0].type.type)}>`),
      evaluate: (ops, { engine: ce }) => {
        if (!isFiniteCollection(ops[0])) return void 0;
        const [values, _counts] = tally(ops[0]);
        return ce.function("List", values);
      }
    },
    // Similar to Transpose, but acts on a sequence of collections
    // Equivalent to zip in Python
    // The length of the result is the length of the shortest argument
    // Ex: Zip([a, b, c], [1, 2]) = [[a, 1], [b, 2]]
    Zip: {
      // @todo: do a lazy version of this (implemented as a collection handler)
      complexity: 8200,
      signature: "(collection, ...collection) -> list",
      evaluate: (_ops) => {
        return void 0;
      }
    },
    RotateLeft: {
      // @todo: do a lazy version of this (implemented as a collection handler)
      complexity: 8200,
      signature: "(collection, integer?) -> collection",
      evaluate: (_ops) => {
        return void 0;
      }
    },
    RotateRight: {
      // @todo: do a lazy version of this (implemented as a collection handler)
      complexity: 8200,
      signature: "(collection, integer?) -> collection",
      evaluate: (_ops) => {
        return void 0;
      }
    },
    // Return a list of the elements of each collection.
    // If all collections are Set, return a Set
    // ["Join", ["List", 1, 2, 3], ["List", 4, 5, 6]] -> ["List", 1, 2, 3, 4, 5, 6]
    Join: {
      // @todo: do a lazy version of this (implemented as a collection handler)
      description: [
        "Join the elements of a sequence of collections or scalar values.",
        "If all collections are `Set`, return a `Set`.",
        "If all collections are `Map`, return a `Map`."
      ],
      complexity: 8200,
      signature: "(...any) -> collection",
      type: joinResultType,
      evaluate: (ops, { engine: ce }) => {
        const type2 = joinResultType(ops);
        if (isSubtype(type2, "map")) {
          let values = {};
          for (const op of ops) {
            values = joinMap(values, op);
            if (!values) return void 0;
          }
          return ce._fn(
            "Dictionary",
            Object.entries(values).map(
              ([key, value]) => ce._fn("Tuple", [ce.string(key), value])
            )
          );
        }
        if (isSubtype(type2, "set")) {
          let values = [];
          for (const op of ops) {
            values = joinSet(values, op);
            if (!values) return void 0;
          }
          return ce.function("Set", values);
        }
        if (isSubtype(type2, "list")) {
          let values = [];
          for (const op of ops) {
            values = joinList(values, op);
            if (!values) return void 0;
          }
          return ce.function("List", values);
        }
        return void 0;
      }
    },
    // Iterate(fn, init) -> [fn(1, init), fn(2, fn(1, init)), ...]
    // Iterate(fn) -> [fn(1), fn(2), ...]
    // Infinite series. Can use First(Iterate(fn), n) to get a finite series
    Iterate: {
      // @todo: do a lazy version of this (implemented as a collection handler)
      complexity: 8200,
      signature: "(function, initial: any?) -> list",
      evaluate: (_ops) => {
        return void 0;
      }
    },
    // Repeat(x) -> [x, x, ...]
    // This is an infinite series. Can use Take(Repeat(x), n) to get a finite series
    // x is evaluated once. Although could use Hold()?
    // So that First(Repeat(Hold(Random(5))), 10) would return 10 random numbers...
    Repeat: {
      // @todo: do a lazy version of this (implemented as a collection handler)
      complexity: 8200,
      signature: "(value: any) -> list",
      type: (ops) => parseType(`collection<${ops[0].type}>`),
      evaluate: (_ops) => {
        return void 0;
      }
    },
    // Cycle(list) -> [list[1], list[2], ...]
    // -> repeats infinitely
    Cycle: {
      // @todo: do a lazy version of this (implemented as a collection handler)
      complexity: 8200,
      signature: "(list) -> list",
      type: (ops) => parseType(`list<${ops[0].type}>`),
      evaluate: (_ops) => {
        return void 0;
      }
    },
    // Fill(f, [n, m])
    // Fill a nxm matrix with the result of f(i, j)
    // Fill( Random(5), [3, 3] )
    Fill: {
      // @todo: do a lazy version of this (implemented as a collection handler)
      complexity: 8200,
      signature: "(function, tuple) -> list",
      // @todo: resultType
      evaluate: (_ops) => {
        return void 0;
      }
    }
  };
  function range(expr) {
    if (expr.nops === 0) return [1, 0, 0];
    let op1 = Math.round(expr.op1.re);
    if (!isFinite(op1)) op1 = 1;
    if (expr.nops === 1) return [1, op1, 1];
    let op2 = Math.round(expr.op2.re);
    if (!isFinite(op2)) op2 = 1;
    if (expr.nops === 2) return [op1, op2, op2 > op1 ? 1 : -1];
    let op3 = Math.abs(Math.round(expr.op3.re));
    if (!isFinite(op3)) op3 = 1;
    return [op1, op2, op1 < op2 ? op3 : -op3];
  }
  function rangeLast(r) {
    const [lower, upper, step] = r;
    if (!Number.isFinite(upper)) return step > 0 ? Infinity : -Infinity;
    if (step > 0) return upper - (upper - lower) % step;
    return upper + (lower - upper) % step;
  }
  function indexRangeArg(op, l) {
    if (!op) return [0, 0, 0];
    let n = op.re;
    if (isFinite(n)) {
      n = Math.round(n);
      if (n < 0) {
        if (l === void 0) return [0, 0, 0];
        n = l + n + 1;
      }
      return [n, n, 1];
    }
    const h = op.operator;
    if (!h || typeof h !== "string" || !/^(Single|Pair|Triple|Tuple|)$/.test(h))
      return [0, 0, 0];
    let [lower, upper, step] = range(op);
    if ((lower < 0 || upper < 0) && l === void 0) return [0, 0, 0];
    if (lower < 0) lower = l + lower + 1;
    if (upper < 0) upper = l + upper + 1;
    step = Math.abs(Math.round(step));
    if (step === 0) return [0, 0, 0];
    if (lower > upper) step = -step;
    return [lower, upper, step];
  }
  function slice(expr, indexes2) {
    const ce = expr.engine;
    const def = expr.baseDefinition;
    const at2 = def?.collection?.at;
    if (!at2) return ce.Nothing;
    const list = [];
    for (const index of indexes2) {
      const [lower, upper, step] = index;
      if (step === 0) continue;
      if (step < 0) {
        for (let index2 = lower; index2 >= upper; index2 += step) {
          const result = at2(expr, index2);
          if (result) list.push(result);
        }
      } else {
        for (let index2 = lower; index2 <= upper; index2 += step) {
          const result = at2(expr, index2);
          if (result) list.push(result);
        }
      }
    }
    return ce.function("List", list);
  }
  function sliceString(s, indexes2) {
    let s2 = "";
    for (const index of indexes2) {
      const [lower, upper, step] = index;
      if (step === 1) s2 += s.slice(lower - 1, upper);
      else if (step < 0)
        for (let i = lower; i >= upper; i += step) s2 += s[i - 1];
      else for (let i = lower; i <= upper; i += step) s2 += s[i - 1];
    }
    return s2;
  }
  function indexes(ranges) {
    const result = [];
    for (const range2 of ranges) {
      const [lower, upper, step] = range2;
      if (step === 0) continue;
      if (step < 0) {
        for (let index = lower; index >= upper; index += step) result.push(index);
      } else {
        for (let index = lower; index <= upper; index += step) {
          result.push(index);
        }
      }
    }
    return result;
  }
  function canonicalList(ops, { engine: ce }) {
    const op1 = ops[0];
    if (ops.length === 1 && op1.operator === "Matrix") {
      const [body, delimiters, columns] = op1.ops;
      if (!delimiters || delimiters.string === "..") {
        if (!columns) return ce._fn("Matrix", [body, delimiters]);
        return ce._fn("Matrix", [body, ce.string("[]"), columns]);
      }
    }
    ops = ops.map((op) => {
      if (op.operator === "Delimiter") {
        if (op.op1.operator === "Sequence")
          return ce._fn("List", canonical(ce, op.op1.ops));
        return ce._fn("List", [op.op1?.canonical ?? ce.Nothing]);
      }
      return op.canonical;
    });
    return ce._fn("List", ops);
  }
  function canonicalSet(ops, { engine }) {
    const set = [];
    const has = (x) => set.some((y) => y.isSame(x));
    for (const op of ops) if (!has(op)) set.push(op);
    return engine._fn("Set", set);
  }
  function collectionFunction(ops) {
    if (ops.length !== 2) return [[], void 0];
    const fn = applicable(ops[1]);
    if (!fn) return [[], void 0];
    if (ops[0].string) {
      return [
        [ops[0]],
        (args) => {
          const s = args[0].string;
          if (s === null) return void 0;
          const ce = args[0].engine;
          return ce.string(
            s.split("").map((c) => fn([ce.string(c)])?.string ?? "").join("")
          );
        }
      ];
    }
    if (!isFiniteIndexableCollection(ops[0]) || !ops[1]) return [[], void 0];
    return [each(ops[0]), fn];
  }
  function tally(collection) {
    const values = [];
    const counts = [];
    const indexOf = (expr) => {
      for (let i = 0; i < values.length; i++)
        if (values[i].isSame(expr)) return i;
      return -1;
    };
    for (const op of each(collection)) {
      const index = indexOf(op);
      if (index >= 0) counts[index]++;
      else {
        values.push(op);
        counts.push(1);
      }
    }
    return [values, counts];
  }
  function* reduceCollection(collection, fn, initial) {
    let acc = initial;
    let counter = 0;
    for (const x of each(collection)) {
      const result = fn(acc, x);
      if (result === null) return void 0;
      counter += 1;
      if (counter % 1e3 === 0) yield acc;
      acc = result;
    }
    return acc;
  }
  function joinResultType(ops) {
    if (ops.some((op) => op.type.matches("map"))) return "map";
    if (ops.some((op) => op.type.matches("set"))) return "set";
    return "list";
  }
  function joinMap(values, value) {
    if (value.operator === "KeyValuePair") {
      const key = value.op1.string;
      if (!key) return void 0;
      values[key] = value.op2;
      return values;
    }
    if (value.operator === "Tuple") {
      const [key, val] = value.ops;
      if (!key.string) return void 0;
      values[key.string] = val;
      return values;
    }
    if (value.operator === "List" || value.operator === "Set" || value.operator === "Dictionary") {
      for (const val of value.ops) {
        const result = joinMap(values, val);
        if (!result) return void 0;
        values = result;
      }
      return values;
    }
    return void 0;
  }
  function joinSet(set, value) {
    if (value.operator === "Set" || value.operator === "List") {
      for (const val of value.ops) {
        set = joinSet(set, val);
        if (!set) return void 0;
      }
    }
    const has = (x) => set.some((y) => y.isSame(x));
    if (!has(value)) set.push(value);
    return set;
  }
  function joinList(values, value) {
    if (value.operator === "List" || value.operator === "Set") {
      for (const val of value.ops) {
        values = joinList(values, val);
        if (!values) return void 0;
      }
    }
    values.push(value);
    return values;
  }
  function collectionSubset(a, b, strict) {
    if (a.string && b.string) {
      if (strict && a.string === b.string) return false;
      return a.string?.includes(b.string ?? "") ?? false;
    }
    if (!a.isCollection || !b.isCollection) return false;
    for (const x of each(a)) if (!b.contains(x)) return false;
    if (strict) {
      const aSize = a.size;
      const bSize = b.size;
      if (aSize === bSize) return false;
      if (aSize === void 0 || bSize === void 0) return false;
    }
    return true;
  }
  function defaultCollectionHandlers2() {
    return {
      size: (expr) => expr.nops,
      contains: (expr, target) => expr.ops.some((x) => x.isSame(target)),
      iterator: (expr, start, count) => {
        let index = (start ?? 1) - 1;
        count = Math.min(count ?? expr.nops, expr.nops);
        return {
          next: () => {
            if (count <= 0) return { value: void 0, done: true };
            count--;
            return { value: expr.ops[index++], done: false };
          }
        };
      },
      at: (expr, index) => {
        if (typeof index !== "number") return void 0;
        if (index < 1 || index > expr.nops) return void 0;
        return expr.ops[index - 1];
      },
      keys: (_expr) => [],
      indexOf: (expr, target, from) => {
        from ?? (from = 1);
        if (from < 0) {
          if (from < -expr.nops) return void 0;
          from = expr.nops + from + 1;
          for (let i = from; i >= 1; i--)
            if (expr.ops[i - 1].isSame(target)) return i;
          return void 0;
        }
        for (let i = from; i <= expr.nops; i++)
          if (expr.ops[i - 1].isSame(target)) return i;
        return void 0;
      },
      subsetOf: collectionSubset,
      eltsgn: (_expr) => void 0,
      elttype: (expr) => {
        if (expr.nops === 0) return "unknown";
        if (expr.nops === 1) return expr.ops[0].type.type;
        return widen(...expr.ops.map((op) => op.type.type));
      }
    };
  }
  function keyValues(ops) {
    const values = {};
    let i = 1;
    for (const pair of ops) {
      if (pair.operator === "KeyValuePair" || pair.operator === "Tuple" || pair.operator === "Pair") {
        const [key, val] = pair.ops;
        if (key.symbol === "Nothing") continue;
        values[key?.string ?? key?.toString() ?? i.toString()] = val ?? pair.engine.Nothing;
      } else {
        values[i.toString()] = pair;
      }
      i += 1;
    }
    return values;
  }
  function length2(x) {
    if (x.operator === "List" || x.operator === "Set") return x.nops;
    const def = x.baseDefinition;
    if (def?.collection?.size) return def.collection.size(x);
    const s = x.string;
    if (s !== null) return s.length;
    return 0;
  }
  function at(x, i) {
    const def = x.baseDefinition;
    if (def?.collection?.at) return def.collection.at(x, i);
    return void 0;
  }
  function defaultCollectionEq(a, b) {
    if (a.operator !== b.operator) return false;
    if (a.nops !== b.nops) return false;
    return a.ops.every((x, i) => x.isSame(b.ops[i]));
  }
  function fromRange(start, end) {
    return Array.from({ length: end - start + 1 }, (_, index) => start + index);
  }
  function canonicalDictionary(engine, dict) {
    if (dict.string && dict.string[0] === "{" && dict.string[dict.string.length - 1] === "}") {
      let obj;
      try {
        obj = JSON5.parse(dict.string);
      } catch (e) {
        return engine._fn("Dictionary", []);
      }
      if (typeof obj !== "object") return engine._fn("Dictionary", []);
      return engine._fn(
        "Dictionary",
        Object.entries(obj).map(
          ([k, v]) => engine._fn("Tuple", [engine.string(k), engine.box(v)])
        )
      );
    }
    if (dict.operator === "Tuple" || dict.operator === "Pair" || dict.operator === "KeyValuePair") {
      const [key, value] = dict.ops;
      let k;
      if (key.string) k = key.string;
      else if (key.symbol) k = key.symbol;
      else return engine._fn("Dictionary", []);
      return engine._fn("Dictionary", [
        engine._fn("Tuple", [engine.string(k), value.canonical])
      ]);
    }
    if (dict.operator === "Dictionary") {
      const result = {};
      for (const pair of dict.ops) {
        if (pair.operator === "KeyValuePair" || pair.operator === "Pair" || pair.operator === "Tuple") {
          const [key, value] = pair.ops;
          let k;
          if (key.string) k = key.string;
          else if (key.symbol) k = key.symbol;
          else return engine._fn("Dictionary", []);
          result[k] = value.canonical;
        }
      }
      return engine._fn(
        "Dictionary",
        Object.entries(result).map(
          ([k, v]) => engine._fn("Tuple", [engine.string(k), v])
        )
      );
    }
    return engine._fn("Dictionary", []);
  }

  // src/compute-engine/library/utils.ts
  function normalizeIndexingSet(indexingSet) {
    console.assert(indexingSet?.operator === "Tuple");
    let lower = 1;
    let upper = lower + MAX_ITERATION;
    let index = void 0;
    let isFinite2 = true;
    index = indexingSet.op1.symbol;
    console.assert(index, "Indexing set must have an index");
    lower = Math.floor(indexingSet.op2.re);
    if (isNaN(lower)) lower = 1;
    if (!Number.isFinite(lower)) isFinite2 = false;
    if (indexingSet.op3.symbol === "Nothing" || indexingSet.op3.isInfinity) {
      isFinite2 = false;
    } else {
      if (!isNaN(indexingSet.op3.re))
        upper = Math.floor(indexingSet.op3.re ?? upper);
      if (!Number.isFinite(upper)) isFinite2 = false;
    }
    if (!isFinite2 && Number.isFinite(lower)) upper = lower + MAX_ITERATION;
    return { index, lower, upper, isFinite: isFinite2 };
  }
  function normalizeIndexingSets(ops) {
    return ops.map((op) => normalizeIndexingSet(op));
  }
  function indexingSetCartesianProduct(indexingSets) {
    console.assert(indexingSets.length > 0, "Indexing sets must not be empty");
    let { index, lower, upper, isFinite: isFinite2 } = indexingSets[0];
    if (!isFinite2) upper = lower + MAX_ITERATION;
    let result = fromRange(lower, upper).map((x) => [x]);
    if (indexingSets.length === 1) return result;
    for (let i = 1; i < indexingSets.length; i++) {
      let { index: index2, lower: lower2, upper: upper2, isFinite: isFinite3 } = indexingSets[i];
      if (!isFinite3) upper2 = lower2 + MAX_ITERATION;
      result = cartesianProduct(
        result.map((x) => x[0]),
        fromRange(lower2, upper2)
      );
    }
    return result;
  }
  function cartesianProduct(array1, array2) {
    return array1.flatMap((item1) => array2.map((item2) => [item1, item2]));
  }
  function canonicalIndexingSet(expr) {
    const ce = expr.engine;
    let index;
    let upper = null;
    let lower = null;
    if (expr.operator === "Tuple" || expr.operator === "Triple" || expr.operator === "Pair" || expr.operator === "Single") {
      index = expr.op1;
      lower = expr.ops[1]?.canonical ?? null;
      upper = expr.ops[2]?.canonical ?? null;
    } else index = expr;
    if (index.operator === "Hold") index = index.op1;
    if (!index.symbol) return void 0;
    if (index.symbol && index.symbol !== "Nothing")
      ce.declare(index.symbol, "integer");
    if (upper && lower) return ce.tuple(index, lower, upper);
    if (upper) return ce.tuple(index, ce.One, upper);
    if (lower) return ce.tuple(index, lower);
    return ce.tuple(index);
  }
  function canonicalBigop(operator2, body, indexingSets) {
    const ce = body.engine;
    ce.pushScope();
    body ?? (body = ce.error("missing"));
    const indexes2 = indexingSets.map((x) => canonicalIndexingSet(x)).filter((x) => x !== void 0);
    const result = ce._fn(operator2, [body.canonical, ...indexes2]);
    ce.popScope();
    return result;
  }
  function* reduceBigOp(body, indexes2, fn, initial) {
    if (body.isCollection)
      return yield* reduceCollection(body.evaluate(), fn, initial);
    if (indexes2.length === 0) return fn(initial, body) ?? void 0;
    const ce = body.engine;
    const savedScope = ce.swapScope(body.scope);
    const indexingSets = normalizeIndexingSets(indexes2);
    const cartesianArray = indexingSetCartesianProduct(indexingSets);
    let result = initial;
    let counter = 0;
    for (const element of cartesianArray) {
      indexingSets.forEach((x, i) => ce.assign(x.index, element[i]));
      result = fn(result, body) ?? void 0;
      counter += 1;
      if (counter % 1e3 === 0) yield result;
      if (result === void 0) break;
    }
    for (const indexingSet of indexingSets)
      ce.assign(indexingSet.index, void 0);
    ce.swapScope(savedScope);
    return result ?? void 0;
  }

  // src/compute-engine/library/arithmetic.ts
  function numberSgn(x) {
    if (x === void 0) return void 0;
    if (isNaN(x)) return "unsigned";
    if (x > 0) return "positive";
    if (x < 0) return "negative";
    return "zero";
  }
  function oppositeSgn(x) {
    if (x === "positive") return "negative";
    if (x === "non-negative") return "non-positive";
    if (x === "negative") return "positive";
    if (x === "non-positive") return "non-negative";
    return x;
  }
  function lnSign(x) {
    if (x.isGreater(1)) return "positive";
    if (x.isGreaterEqual(1)) return "non-negative";
    if (x.isLessEqual(1) && x.isGreaterEqual(0)) return "non-positive";
    if (x.isLess(1) && x.isGreaterEqual(0)) return "negative";
    if (x.is(1)) return "zero";
    if (x.isNegative || x.isReal === false) return "unsigned";
    return void 0;
  }
  var ARITHMETIC_LIBRARY = [
    {
      //
      // Functions
      //
      Abs: {
        wikidata: "Q3317982",
        // magnitude 'Q120812 (for reals)
        threadable: true,
        idempotent: true,
        complexity: 1200,
        signature: "number -> number",
        type: ([x]) => x.type,
        sgn: ([x]) => {
          if (x.is(0)) return "zero";
          return x.isNumberLiteral ? "positive" : "non-negative";
        },
        evaluate: ([x]) => evaluateAbs(x)
      },
      Add: {
        wikidata: "Q32043",
        associative: true,
        commutative: true,
        commutativeOrder: addOrder,
        threadable: true,
        idempotent: true,
        complexity: 1300,
        lazy: true,
        signature: "(number, ...number) -> number",
        type: addType,
        sgn: (ops) => {
          if (ops.some((x) => x.isNaN)) return "nan";
          if (ops.some((x) => x.isReal === false)) return "unsigned";
          if (ops.every((x) => x.is(0))) return "zero";
          if (ops.every((x) => x.isNonNegative))
            return ops.some((x) => x.isPositive) ? "positive" : "non-negative";
          if (ops.every((x) => x.isNonPositive))
            return ops.some((x) => x.isNegative) ? "negative" : "non-positive";
          if (ops.every((x) => x.isReal)) return "real";
          return void 0;
        },
        // @fastpath: canonicalization is done in the function
        // makeNumericFunction().
        evaluate: (ops, { numericApproximation }) => (
          // Do not evaluate in the case of numericApproximation
          // to avoid premature rounding errors.
          // For example: `\\frac{2}{3}+\\frac{12345678912345678}{987654321987654321}+\\frac{987654321987654321}{12345678912345678}`
          numericApproximation ? addN(...ops) : add3(...ops.map((x) => x.evaluate()))
        )
      },
      Ceil: {
        description: "Rounds a number up to the next largest integer",
        complexity: 1250,
        threadable: true,
        signature: "real -> integer",
        sgn: ([x]) => {
          if (x.isLessEqual(-1)) return "negative";
          if (x.isPositive) return "positive";
          if (x.isNonNegative) return "non-negative";
          if (x.isNonPositive && x.isGreater(-1)) return "zero";
          if (x.isNonPositive) return "non-positive";
          if (x.isReal == false && x.isNumberLiteral)
            return x.im > 0 || x.im <= -1 ? "unsigned" : numberSgn(x.re);
          return void 0;
        },
        evaluate: ([x]) => apply(
          x,
          Math.ceil,
          (x2) => x2.ceil(),
          (z) => z.ceil(0)
        )
      },
      Chop: {
        associative: true,
        threadable: true,
        idempotent: true,
        complexity: 1200,
        signature: "number -> number",
        type: ([x]) => x.type,
        evaluate: (ops) => {
          const op = ops[0];
          const ce = op.engine;
          return apply(
            op,
            (x) => ce.chop(x),
            (x) => ce.chop(x),
            (x) => ce.complex(ce.chop(x.re), ce.chop(x.im))
          );
        }
      },
      // Complex: {
      //   // This function is converted during boxing, so unlikely to encounter
      //   wikidata: 'Q11567',
      //   complexity: 500,
      // },
      Divide: {
        wikidata: "Q1226939",
        complexity: 2500,
        threadable: true,
        // - if numer product of numbers, or denom product of numbers,
        // i.e. √2x/2 -> 0.707x, 2/√2x -> 1.4142x
        signature: "(number, ...number) -> number",
        type: ([num, den]) => {
          if (den.is(1)) return num.type;
          if (den.isNaN || num.isNaN) return "number";
          if (den.isFinite === false || num.isFinite === false)
            return "non_finite_number";
          if (den.isInteger && num.isInteger) return "finite_rational";
          if (den.isReal && num.isReal) return "finite_real";
          return "finite_number";
        },
        sgn: (ops) => {
          const [n, d] = [ops[0], ops[1]];
          if (d.is(0)) return "unsigned";
          if (d.is(0) === false && n.is(0)) return "zero";
          if (d.isPositive) return n.sgn;
          if (d.isNegative) return oppositeSgn(n.sgn);
          if (n.is(0) || n.isFinite && d.isInfinity) return "zero";
          if (!n.is(0) && !d.is(0)) return "not-zero";
          return void 0;
        },
        canonical: (args, { engine }) => {
          const ce = engine;
          args = checkNumericArgs(ce, args);
          let result = args[0];
          if (result === void 0) return ce.error("missing");
          if (args.length < 2) return result;
          const rest = args.slice(1);
          for (const x of rest) result = canonicalDivide(result, x);
          return result;
        },
        evaluate: ([num, den]) => num.div(den)
      },
      Exp: {
        wikidata: "Q168698",
        threadable: true,
        complexity: 3500,
        signature: "number -> number",
        // Because it gets canonicalized to Power, the sgn handler is not called
        // sgn: ([x]) => {
        //   if (
        //     (x.isNumberLiteral && x.re === -Infinity) ||
        //     (x.isNegative && x.isInfinity)
        //   )
        //     return 'zero';
        //   if (x.isReal == false && x.isNumberLiteral) {
        //     let n = chop(1 - x.im! / Math.PI) + 1;
        //     return n % 1 !== 0
        //       ? 'unsigned'
        //       : n % 2 === 0
        //         ? 'positive'
        //         : 'negative';
        //   }
        //   if (x.isReal || (x.isInfinity && x.isPositive)) return 'positive';
        //   return undefined;
        // },
        // Exp(x) -> e^x
        canonical: (args, { engine }) => {
          args = checkNumericArgs(engine, args, 1);
          return engine.function("Power", [engine.E, ...args]);
        }
      },
      Factorial: {
        description: "Factorial function: the product of all positive integers less than or equal to n",
        wikidata: "Q120976",
        threadable: true,
        complexity: 9e3,
        signature: "integer -> integer",
        // Assumes that the inside of the factorial is an integer
        sgn: ([x]) => x.isNonNegative ? "positive" : x.isNegative || x.isReal === false ? "unsigned" : void 0,
        canonical: (args, { engine }) => {
          const x = args[0];
          if (x.isNumberLiteral && x.isNegative)
            return engine._fn("Factorial", [x.neg()]).neg();
          return engine._fn("Factorial", [x]);
        },
        evaluate: ([x]) => {
          const ce = x.engine;
          if (x.im !== 0 && x.im !== void 0)
            return ce.number(gamma(ce.complex(x.re, x.im).add(1)));
          if (!x.isFinite) return void 0;
          if (x.isNegative) return ce.number(gamma2(1 + x.re));
          try {
            return ce.number(
              run(
                factorial3(BigInt((x.bignumRe ?? x.re).toFixed())),
                ce._timeRemaining
              )
            );
          } catch (e) {
            return void 0;
          }
        },
        evaluateAsync: async ([x], { signal }) => {
          const ce = x.engine;
          if (x.im !== 0 && x.im !== void 0)
            return ce.number(gamma(ce.complex(x.re, x.im).add(1)));
          if (!x.isFinite) return void 0;
          if (x.isNegative) return ce.number(gamma2(1 + x.re));
          try {
            return ce.number(
              await runAsync(
                factorial3(BigInt((x.bignumRe ?? x.re).toFixed())),
                (ce._deadline ?? Infinity) - Date.now(),
                signal
              )
            );
          } catch (e) {
            return void 0;
          }
        }
      },
      Factorial2: {
        description: "Double Factorial Function",
        complexity: 9e3,
        threadable: true,
        signature: "integer -> integer",
        sgn: ([x]) => x.isNonNegative ? "positive" : x.isNegative || x.isReal === false ? "unsigned" : void 0,
        evaluate: (ops) => {
          const x = ops[0];
          const n = asSmallInteger(x);
          if (n === null) return void 0;
          const ce = x.engine;
          if (bignumPreferred(ce))
            return ce.number(factorial22(ce, ce.bignum(n)));
          return ce.number(factorial2(n));
        }
      },
      Floor: {
        wikidata: "Q56860783",
        complexity: 1250,
        threadable: true,
        signature: "number -> integer",
        sgn: ([x]) => {
          if (x.isNegative) return "negative";
          if (x.isGreaterEqual(1)) return "positive";
          if (x.isNonNegative && x.isLess(1)) return "zero";
          if (x.isNonNegative) return "non-negative";
          if (x.isReal == false && x.isNumberLiteral)
            return x.im < 0 || x.im >= 1 ? "unsigned" : numberSgn(x.re);
          return void 0;
        },
        evaluate: ([x]) => apply(
          x,
          Math.floor,
          (x2) => x2.floor(),
          (z) => z.floor(0)
        )
      },
      Gamma: {
        wikidata: "Q190573",
        complexity: 8e3,
        threadable: true,
        signature: "number -> number",
        sgn: ([x]) => x.isPositive ? "positive" : x.is(0) ? "zero" : void 0,
        evaluate: ([x], { numericApproximation, engine }) => numericApproximation ? apply(
          x,
          (x2) => gamma2(x2),
          (x2) => bigGamma(engine, x2),
          (x2) => gamma(x2)
        ) : void 0
      },
      GammaLn: {
        complexity: 8e3,
        threadable: true,
        signature: "number -> number",
        evaluate: (ops, { numericApproximation, engine }) => numericApproximation ? apply(
          ops[0],
          (x) => gammaln2(x),
          (x) => bigGammaln(engine, x),
          (x) => gammaln(x)
        ) : void 0
      },
      Ln: {
        description: "Natural Logarithm",
        wikidata: "Q204037",
        complexity: 4e3,
        threadable: true,
        signature: "(number, base: number?) -> number",
        sgn: ([x]) => lnSign(x),
        // @fastpath: this doesn't get called. See makeNumericFunction()
        evaluate: ([z], { numericApproximation, engine }) => {
          if (!numericApproximation) return z.ln();
          return apply(
            z,
            (x) => x === 0 ? -Infinity : x >= 0 ? Math.log(x) : engine.complex(x).log(),
            (x) => x.isZero() ? -Infinity : !x.isNeg() ? x.ln() : engine.complex(x.toNumber()).log(),
            (z2) => z2.isZero() ? NaN : z2.log()
          );
        }
      },
      Log: {
        description: "Log(z, b = 10) = Logarithm of base b",
        wikidata: "Q11197",
        complexity: 4100,
        threadable: true,
        signature: "(number, base: number?) -> number",
        sgn: ([x, base]) => {
          if (!base) return lnSign(x);
          if (base.is(1) || base.isReal == false) return "unsigned";
          if (base.isGreater(1)) return lnSign(x);
          if (base.isLess(1)) return oppositeSgn(lnSign(x));
          return void 0;
        },
        // @fastpath: this doesn't get called. See makeNumericFunction()
        // canonical: (ce, [x, base]) => {
        //   if (!x) return ce._fn('Log', [ce.error('missing'), base]);
        //   return x.ln(base ?? 10);
        // },
        evaluate: (ops, { numericApproximation, engine }) => {
          if (!numericApproximation) return ops[0]?.ln(ops[1] ?? 10) ?? void 0;
          const ce = engine;
          if (ops[1] === void 0)
            return apply(
              ops[0],
              (x) => x === 0 ? -Infinity : x >= 0 ? Math.log10(x) : ce.complex(x).log().div(Math.LN10),
              (x) => x.isZero() ? -Infinity : !x.isNeg() ? Decimal.log10(x) : ce.complex(x.toNumber()).log().div(Math.LN10),
              (z) => z.isZero() ? NaN : z.log().div(Math.LN10)
            );
          return apply2(
            ops[0],
            ops[1],
            (z, b) => Math.log(z) / Math.log(b),
            (z, b) => z.log(b),
            (z, b) => z.log().div(typeof b === "number" ? Math.log(b) : b.log())
          );
        }
      },
      Lb: {
        description: "Base-2 Logarithm",
        wikidata: "Q581168",
        complexity: 4100,
        threadable: true,
        signature: "(number, base: number?) -> number",
        sgn: ([x]) => lnSign(x),
        canonical: ([x], { engine }) => engine._fn("Log", [x, engine.number(2)])
      },
      Lg: {
        description: "Base-10 Logarithm",
        wikidata: "Q966582",
        complexity: 4100,
        threadable: true,
        signature: "number -> number",
        sgn: ([x]) => lnSign(x),
        canonical: ([x], { engine }) => engine._fn("Log", [x])
      },
      Mod: {
        description: "Modulo",
        wikidata: "Q1799665",
        complexity: 2500,
        threadable: true,
        signature: "(number, number) -> number",
        sgn: (ops) => {
          const n = ops[1];
          if (n === void 0 || n.isReal == false) return void 0;
          if (n.is(0)) return "unsigned";
          if (ops[0].isNumberLiteral && n.isNumberLiteral) {
            const v = apply2(
              ops[0],
              n,
              // In JavaScript, the % is remainder, not modulo
              // so adapt it to return a modulo
              (a, b) => (a % b + b) % b,
              (a, b) => a.modulo(b)
            );
            return v?.sgn ?? void 0;
          }
          return void 0;
        },
        evaluate: ([a, b]) => apply2(
          a,
          b,
          // In JavaScript, the % is remainder, not modulo
          // so adapt it to return a modulo
          (a2, b2) => (a2 % b2 + b2) % b2,
          (a2, b2) => a2.modulo(b2)
        )
      },
      Multiply: {
        wikidata: "Q40276",
        associative: true,
        commutative: true,
        idempotent: true,
        complexity: 2100,
        threadable: true,
        lazy: true,
        signature: "(number, ...number) -> number",
        type: (ops) => {
          if (ops.length === 0) return "finite_integer";
          if (ops.length === 1) return ops[0].type;
          if (ops.some((x) => x.isNaN)) return "number";
          if (ops.some((x) => x.isFinite === false)) return "non_finite_number";
          if (ops.every((x) => x.isInteger)) return "finite_integer";
          if (ops.every((x) => x.isReal)) return "finite_real";
          if (ops.every((x) => x.isRational)) return "finite_rational";
          return "finite_number";
        },
        // @fastpath: canonicalization is done in the function
        // makeNumericFunction().
        //
        sgn: (ops) => {
          if (ops.some((x) => x.sgn === void 0 || x.isReal === false))
            return void 0;
          if (ops.some((x) => x.is(0)))
            return ops.every((x) => x.isFinite) ? "zero" : ops.some((x) => x.isFinite === false) ? "unsigned" : void 0;
          if (ops.some((x) => x.isFinite === false || x.isFinite === void 0) && ops.some((x) => x.is(0) === void 0))
            return void 0;
          if (ops.every((x) => x.isPositive || x.isNegative)) {
            let sumNeg = 0;
            ops.forEach((x) => {
              if (x.isNegative) sumNeg++;
            });
            return sumNeg % 2 === 0 ? "positive" : "negative";
          }
          if (ops.every((x) => x.isNonPositive || x.isNonNegative)) {
            let sumNeg = 0;
            ops.forEach((x) => {
              if (x.isNonPositive) sumNeg++;
            });
            return sumNeg % 2 === 0 ? "non-positive" : "non-negative";
          }
          if (ops.every((x) => !x.is(0))) return "not-zero";
          if (ops.every((x) => x.isReal)) return "real";
          return void 0;
        },
        evaluate: (ops, { numericApproximation }) => (
          // Use evaluate i both cases: do not introduce premature rounding errors
          numericApproximation ? mulN(...ops) : mul3(...ops.map((x) => x.evaluate()))
        )
      },
      Negate: {
        description: "Additive Inverse",
        wikidata: "Q715358",
        complexity: 2e3,
        threadable: true,
        signature: "number -> number",
        type: ([x]) => x.type,
        sgn: ([x]) => oppositeSgn(x.sgn),
        canonical: (args, { engine }) => {
          args = checkNumericArgs(engine, args);
          if (args.length === 0) return engine.error("missing");
          return args[0].neg();
        },
        evaluate: ([x]) => x.neg()
      },
      PlusMinus: {
        description: "Plus or Minus",
        wikidata: "Q120812",
        complexity: 1200,
        signature: "(value, value) -> tuple",
        canonical: (args, { engine: ce }) => {
          args = checkNumericArgs(ce, args, 2);
          if (args.length === 0) return ce.error("missing");
          return ce._fn("PlusMinus", [args[0], args[1].abs()]);
        },
        type: ([x, y]) => parseType(`tuple<${x.type}, ${y.type}>`),
        evaluate: ([x, y], { engine }) => engine.tuple(x.add(y.neg()), x.add(y))
      },
      Power: {
        wikidata: "Q33456",
        threadable: true,
        complexity: 3500,
        signature: "(number, number) -> number",
        type: ([base, exp2]) => {
          if (base.isNaN || exp2.isNaN) return "number";
          if (!exp2.isFinite) return "non_finite_number";
          if (base.isInteger && exp2.isInteger) return "finite_integer";
          if (base.isRational && exp2.isInteger) return "finite_rational";
          if (base.isReal && exp2.isReal) return "finite_real";
          return "finite_number";
        },
        canonical: (args, { engine }) => {
          args = checkNumericArgs(engine, args, 2);
          if (args.length !== 2) return engine._fn("Power", args);
          const [base, exp2] = args;
          return canonicalPower(base, exp2);
        },
        sgn: ([a, b]) => {
          const aSgn = a.sgn;
          const bSgn = b.sgn;
          if (a.isReal === false || b.isReal === false || a.isNaN || b.isNaN || aSgn === void 0 || bSgn === void 0)
            return void 0;
          if (a.is(0))
            return b.isNonPositive ? "unsigned" : b.isPositive ? "zero" : void 0;
          if (a.is(0) && b.is(0)) return "unsigned";
          if (a.isNonNegative || b.numerator.isOdd && b.denominator.isOdd)
            return a.sgn;
          if (b.numerator.isEven && b.denominator.isOdd) {
            if (a.isReal) return !a.is(0) ? "positive" : "non-negative";
            if (a.type.is("imaginary")) return "negative";
            return !a.is(0) ? "not-zero" : void 0;
          }
          if (b.isRational === false || b.numerator.isOdd && b.denominator.isEven && a.isNonPositive)
            return "unsigned";
          return void 0;
        },
        // x^n
        // evaluate: (ops) => ops[0].pow(ops[1]),
        evaluate: ([x, n], { numericApproximation }) => pow2(x, n, { numericApproximation: numericApproximation ?? false })
        // Defined as RealNumbers for all power in RealNumbers when base > 0;
        // when x < 0, only defined if n is an integer
        // if x is a non-zero complex, defined as ComplexNumbers
        // Square root of a prime is irrational (AlgebraicNumbers)
        // https://proofwiki.org/wiki/Square_Root_of_Prime_is_Irrational
      },
      Rational: {
        complexity: 2400,
        signature: "(number, integer?) -> rational",
        sgn: ([n]) => n.sgn,
        canonical: (args, { engine }) => {
          const ce = engine;
          args = flatten(args);
          if (args.length === 0) return ce._fn("Rational", [ce.error("missing")]);
          if (args.length === 1)
            return ce._fn("Rational", [checkType(ce, args[0], "real")]);
          args = checkTypes(ce, args, ["integer", "integer"]);
          if (args.length !== 2 || !args[0].isValid || !args[1].isValid)
            return ce._fn("Rational", args);
          return args[0].div(args[1]);
        },
        evaluate: (ops, { numericApproximation, engine }) => {
          const ce = engine;
          if (ops.length === 1) {
            const f = ops[0].N();
            if (f.numericValue === null || f.im !== 0) return void 0;
            return ce.number(rationalize(f.re));
          }
          if (numericApproximation) {
            return apply2(
              ops[0],
              ops[1],
              (a, b) => a / b,
              (a, b) => a.div(b),
              (a, b) => a.div(b)
            );
          }
          const [n, d] = [asSmallInteger(ops[0]), asSmallInteger(ops[1])];
          if (n !== null && d !== null) return ce.number([n, d]);
          return void 0;
        }
      },
      Root: {
        complexity: 3200,
        threadable: true,
        signature: "(number, number) -> number",
        type: ([base, exp2]) => {
          if (base.isNaN || exp2.isNaN) return "number";
          if (base.isFinite === false || exp2.isFinite === false)
            return "non_finite_number";
          if (exp2.is(0)) return "finite_integer";
          if (exp2.is(1)) return base.type;
          if (base.isReal && exp2.isReal) {
            if (base.isPositive === true) return "finite_real";
            return "finite_number";
          }
          return "finite_number";
        },
        sgn: ([x, n]) => {
          if (x.isReal === false || n.isReal === false) return "unsigned";
          if (x.is(0)) return n.is(0) ? "unsigned" : "zero";
          if (x.isPositive === true) return "positive";
          if (n.isOdd === true) return "negative";
          if (n.isEven === true) return "unsigned";
          return void 0;
        },
        canonical: (args, { engine }) => {
          args = checkNumericArgs(engine, args, 2);
          const [base, exp2] = args;
          return canonicalRoot(base, exp2);
        },
        evaluate: ([x, n], { numericApproximation }) => root(x, n, { numericApproximation })
      },
      Round: {
        complexity: 1250,
        threadable: true,
        signature: "number -> integer",
        type: ([x]) => {
          if (x.isNaN) return "number";
          if (x.isFinite === false || x.isReal === false)
            return "non_finite_number";
          return "finite_integer";
        },
        sgn: ([x]) => {
          if (x.isNaN) return "unsigned";
          if (x.isNumberLiteral)
            return x.im >= 0.5 || x.im <= -0.5 ? "unsigned" : numberSgn(Math.round(x.re));
          if (x.isGreaterEqual(0.5)) return "positive";
          if (x.isLessEqual(-0.5)) return "negative";
          if (x.isLess(0.5) && x.isGreater(-0.5)) return "zero";
          if (x.isNonNegative) return "non-negative";
          if (x.isNonPositive) return "non-positive";
          if (x.isReal) return "real";
          return void 0;
        },
        evaluate: ([x]) => apply(
          x,
          Math.round,
          (x2) => x2.round(),
          (x2) => x2.round(0)
        )
      },
      Sign: {
        complexity: 1200,
        threadable: true,
        signature: "number -> integer",
        sgn: ([x]) => x.sgn,
        evaluate: ([x], { engine }) => {
          if (x.is(0)) return engine.Zero;
          if (x.isPositive) return engine.One;
          if (x.isNegative) return engine.NegativeOne;
          return void 0;
        }
      },
      // {% def "GammaSgn" %}
      // [&quot;**GammaSgn**&quot;, _z_]{.signature}
      // {% latex "\\operatorname{sgn}(\\gamma(z))" %}
      // The gamma function can be computed as \\( \operatorname{sgn}\Gamma(x) \cdot
      // \expoentialE^{\operatorname{LogGamma}(x)} \\)
      // `["Multiply", ["GammaSgn", "x"], ["Exp", ["LogGamma", "x"]]]`.
      // This function is called `gammasgn` in SciPy.
      // **Reference**
      // - NIST: https://dlmf.nist.gov/5.2#E1
      // {% enddef %}
      //     GammaSgn: {
      //   description: 'The sign of the gamma function: -1 or +1',
      //   complexity: 7900,
      //   signature: {
      //     domain: ['FunctionOf', 'Numbers', ['Range', -1, 1]],
      //     evaluate: (ce, ops) => {
      //     },
      //   },
      //   // @todo
      // },
      Sqrt: {
        description: "Square Root",
        wikidata: "Q134237",
        complexity: 3e3,
        threadable: true,
        signature: "number -> number",
        type: ([x]) => {
          if (x.isNaN) return "number";
          if (x.isFinite === false) return "non_finite_number";
          if (x.isReal) return "finite_real";
          return "finite_number";
        },
        // @fastpath: canonicalization is done in the function
        // makeNumericFunction().
        // canonical: (ops, { engine: ce }) => {
        //   ops = flatten(ops);
        //   if (ops.length !== 1) return ce._fn('Sqrt', ops);
        //   return ops[0].sqrt();
        // },
        sgn: ([x]) => {
          if (x.isPositive) return "positive";
          if (x.isNegative) return "unsigned";
          if (x.isNonNegative) return "non-negative";
          if (!x.is(0)) return "not-zero";
          return void 0;
        },
        evaluate: ([x], { numericApproximation, engine }) => {
          if (!numericApproximation) return x.sqrt();
          const [c, rest] = x.toNumericValue();
          if (rest.is(1)) return engine.number(c.sqrt().N());
          return engine.number(c.sqrt().N()).mul(rest);
        }
        // evalDomain: Square root of a prime is irrational
        // https://proofwiki.org/wiki/Square_Root_of_Prime_is_Irrational
      },
      Square: {
        wikidata: "Q3075175",
        complexity: 3100,
        threadable: true,
        signature: "number -> number",
        sgn: ([x]) => {
          if (x.is(0)) return "zero";
          if (x.isReal) return !x.is(0) ? "positive" : "non-negative";
          if (x.type.matches("complex")) return "negative";
          if (x.isReal === false || x.isNaN) return "unsigned";
          return void 0;
        },
        canonical: (args, { engine }) => {
          const ce = engine;
          args = flatten(args);
          if (args.length !== 1) return ce._fn("Square", args);
          return ce._fn("Power", [args[0], ce.number(2)]).canonical;
        }
      },
      Subtract: {
        wikidata: "Q40754",
        complexity: 1350,
        threadable: true,
        // We accept from 1 to n arguments (see https://github.com/cortex-js/compute-engine/issues/171)
        // left-associative: a - b - c -> (a - b) - c
        signature: "(number, ...number) -> number",
        canonical: (args, { engine }) => {
          args = checkNumericArgs(engine, args);
          if (args.length === 0) return engine.error("missing");
          const first = args[0];
          const rest = args.slice(1);
          return canonicalAdd(engine, [first, ...rest.map((x) => x.neg())]);
        }
      }
    },
    {
      //
      // Constants
      // Note: constants are put in a separate section because
      // some of the values (CatalanConstant) reference some function names
      // (Add...) that are defined above. This avoid circular references.
      //
      ImaginaryUnit: {
        type: "imaginary",
        constant: true,
        holdUntil: "never",
        wikidata: "Q193796",
        value: (engine) => engine.I
      },
      i: {
        type: "imaginary",
        constant: true,
        holdUntil: "never",
        value: (engine) => engine.I
      },
      ExponentialE: {
        type: "finite_real",
        wikidata: "Q82435",
        constant: true,
        holdUntil: "N",
        value: (engine) => engine.number(
          bignumPreferred(engine) ? engine._BIGNUM_ONE.exp() : Math.exp(1)
        )
      },
      e: {
        type: "finite_real",
        constant: true,
        holdUntil: "never",
        value: "ExponentialE"
      },
      ComplexInfinity: {
        type: "complex",
        constant: true,
        holdUntil: "never",
        value: (engine) => engine.ComplexInfinity
      },
      PositiveInfinity: {
        type: "non_finite_number",
        constant: true,
        holdUntil: "never",
        value: Infinity
      },
      NegativeInfinity: {
        type: "non_finite_number",
        constant: true,
        holdUntil: "never",
        value: -Infinity
      },
      NaN: {
        type: "number",
        constant: true,
        holdUntil: "never",
        value: (engine) => engine.NaN
      },
      MachineEpsilon: {
        /**
         * The difference between 1 and the next larger floating point number
         *
         *    2^{−52}
         *
         * See https://en.wikipedia.org/wiki/Machine_epsilon
         */
        type: "finite_real",
        holdUntil: "N",
        constant: true,
        value: { num: Number.EPSILON.toString() }
      },
      Half: {
        type: "finite_rational",
        constant: true,
        holdUntil: "never",
        value: ["Rational", 1, 2]
      },
      GoldenRatio: {
        type: "finite_real",
        // Golden ratio is an algebraic number
        wikidata: "Q41690",
        constant: true,
        holdUntil: "N",
        value: ["Divide", ["Add", 1, ["Sqrt", 5]], 2]
      },
      CatalanConstant: {
        type: "finite_real",
        wikidata: "Q855282",
        constant: true,
        holdUntil: "N",
        value: {
          // From http://www.fullbooks.com/Miscellaneous-Mathematical-Constants1.html
          num: `0.91596559417721901505460351493238411077414937428167
                  21342664981196217630197762547694793565129261151062
                  48574422619196199579035898803325859059431594737481
                  15840699533202877331946051903872747816408786590902
                  47064841521630002287276409423882599577415088163974
                  70252482011560707644883807873370489900864775113225
                  99713434074854075532307685653357680958352602193823
                  23950800720680355761048235733942319149829836189977
                  06903640418086217941101917532743149978233976105512
                  24779530324875371878665828082360570225594194818097
                  53509711315712615804242723636439850017382875977976
                  53068370092980873887495610893659771940968726844441
                  66804621624339864838916280448281506273022742073884
                  31172218272190472255870531908685735423498539498309
                  91911596738846450861515249962423704374517773723517
                  75440708538464401321748392999947572446199754961975
                  87064007474870701490937678873045869979860644874974
                  64387206238513712392736304998503539223928787979063
                  36440323547845358519277777872709060830319943013323
                  16712476158709792455479119092126201854803963934243
                  `
        }
      },
      EulerGamma: {
        // From http://www.fullbooks.com/Miscellaneous-Mathematical-Constants2.html
        type: "finite_real",
        wikidata: "Q273023",
        holdUntil: "N",
        constant: true,
        value: {
          num: `0.57721566490153286060651209008240243104215933593992359880576723488486772677766
          467093694706329174674951463144724980708248096050401448654283622417399764492353
          625350033374293733773767394279259525824709491600873520394816567085323315177661
          152862119950150798479374508570574002992135478614669402960432542151905877553526
          733139925401296742051375413954911168510280798423487758720503843109399736137255
          306088933126760017247953783675927135157722610273492913940798430103417771778088
          154957066107501016191663340152278935867965497252036212879226555953669628176388
          792726801324310104765059637039473949576389065729679296010090151251959509222435
          014093498712282479497471956469763185066761290638110518241974448678363808617494
          551698927923018773910729457815543160050021828440960537724342032854783670151773
          943987003023703395183286900015581939880427074115422278197165230110735658339673`
        }
      }
    },
    {
      PreIncrement: {
        signature: "number -> number"
      },
      PreDecrement: {
        signature: "number -> number"
      }
    },
    //
    // Property predicates
    //
    {
      IsPrime: {
        description: "`IsPrime(n)` returns `True` if `n` is a prime number",
        wikidata: "Q49008",
        complexity: 1200,
        threadable: true,
        signature: "(number) -> boolean",
        evaluate: ([n], { engine }) => {
          const result = isPrime2(n);
          if (result === void 0) return void 0;
          return engine.symbol(result ? "True" : "False");
        }
      },
      IsComposite: {
        description: "`IsComposite(n)` returns `True` if `n` is not a prime number",
        complexity: 1200,
        threadable: true,
        signature: "(number) -> boolean",
        canonical: (ops, { engine }) => engine.box(["Not", ["IsPrime", ...ops]])
      },
      IsOdd: {
        description: "`IsOdd(n)` returns `True` if `n` is an odd number",
        complexity: 1200,
        threadable: true,
        signature: "(number) -> boolean",
        evaluate: (ops, { engine }) => {
          let fail = false;
          const result = ops.every((op) => {
            if (op.im !== 0) return false;
            const b = asBigint(op);
            if (b !== null) return b % BigInt(2) !== BigInt(0);
            const n = op.re;
            if (Number.isInteger(n)) return n % 2 !== 0;
            fail = true;
            return false;
          });
          if (fail) return void 0;
          return engine.symbol(result ? "False" : "True");
        }
      },
      isEven: {
        description: "Odd Number",
        complexity: 1200,
        threadable: true,
        signature: "(number) -> boolean",
        canonical: (ops, { engine }) => engine.box(["Not", ["IsOdd", ...ops]])
      }
      // @todo: Divisor:
    },
    {
      GCD: {
        description: "Greatest Common Divisor",
        complexity: 1200,
        threadable: false,
        // The function take a variable number of arguments,
        // including collections
        signature: "(...any) -> integer",
        sgn: () => "positive",
        evaluate: (xs) => evaluateGcdLcm(xs, "GCD")
      },
      LCM: {
        description: "Least Common Multiple",
        complexity: 1200,
        threadable: false,
        // The function take a variable number of arguments,
        // including collections
        signature: "(...any) -> integer",
        sgn: () => "positive",
        evaluate: (xs) => evaluateGcdLcm(xs, "LCM")
      },
      Numerator: {
        description: "Numerator of an expression",
        complexity: 1200,
        threadable: true,
        lazy: true,
        signature: "(number) -> number | nothing",
        canonical: (ops, { engine }) => {
          if (ops.length === 0) return engine.Nothing;
          const op = ops[0];
          if (op.operator === "Rational" || op.operator === "Divide")
            return op.op1;
          return engine._fn("Numerator", canonical(engine, ops));
        },
        sgn: ([x]) => x.sgn,
        evaluate: (ops, { engine }) => {
          const ce = engine;
          if (ops.length === 0) return ce.Nothing;
          const op = ops[0];
          if (op.operator === "Rational" || op.operator === "Divide")
            return op.op1.evaluate();
          return op.numerator;
        }
      },
      Denominator: {
        description: "Denominator of an expression",
        complexity: 1200,
        threadable: true,
        lazy: true,
        signature: "(number) -> number | nothing",
        canonical: (ops, { engine }) => {
          if (ops.length === 0) return engine.Nothing;
          const op = ops[0];
          if (op.operator === "Rational" || op.operator === "Divide")
            return op.op2;
          const num = asRational(op);
          if (num !== void 0) return engine.number(num[1]);
          return engine._fn("Denominator", canonical(engine, ops));
        },
        sgn: () => "positive",
        evaluate: (ops, { engine }) => {
          const ce = engine;
          if (ops.length === 0) return ce.Nothing;
          const op = ops[0];
          if (op.operator === "Rational" || op.operator === "Divide")
            return op.op2.evaluate();
          return op.denominator;
        }
      },
      NumeratorDenominator: {
        description: "Sequence of Numerator and Denominator of an expression",
        complexity: 1200,
        threadable: true,
        lazy: true,
        signature: "(number) -> tuple<number, number> | nothing",
        canonical: (ops, { engine }) => {
          if (ops.length === 0) return engine.Nothing;
          const op = ops[0];
          if (op.operator === "Rational" || op.operator === "Divide")
            return engine.tuple(...op.ops);
          const num = asRational(op.evaluate());
          if (num !== void 0)
            return engine.tuple(engine.number(num[0]), engine.number(num[1]));
          return engine._fn(
            "NumeratorDenominator",
            ops.map((x) => x.evaluate())
          );
        },
        evaluate: (ops, { engine }) => {
          const ce = engine;
          if (ops.length === 0) return ce.Nothing;
          const op = ops[0];
          if (op.operator === "Rational" || op.operator === "Divide")
            return ce.tuple(...op.ops);
          return ce.tuple(...op.numeratorDenominator);
        }
      }
    },
    //
    // Arithmetic on collections: Min, Max, Sum, Product
    //
    {
      Max: {
        description: "Maximum of two or more numbers",
        complexity: 1200,
        threadable: false,
        // The function take a variable number of arguments,
        // including collections
        signature: "(...value) -> number | list",
        sgn: (ops) => {
          if (ops.some((x) => x.isReal == false || x.isNaN)) return "unsigned";
          if (ops.some((x) => x.isReal == false || x.isNaN !== false))
            return void 0;
          if (ops.some((x) => x.isPositive)) return "positive";
          if (ops.every((x) => x.isNonPositive))
            return ops.some((x) => x.is(0)) ? "zero" : "non-positive";
          if (ops.some((x) => x.isNonNegative)) return "non-negative";
          if (ops.every((x) => x.isNegative)) return "negative";
          if (ops.some((x) => !x.is(0))) return "not-zero";
          return void 0;
        },
        evaluate: (xs, { engine }) => evaluateMinMax(engine, xs, "Max")
      },
      Min: {
        description: "Minimum of two or more numbers",
        complexity: 1200,
        threadable: false,
        // The function take a variable number of arguments,
        // including collections
        signature: "(...value) -> number | list",
        sgn: (ops) => {
          if (ops.some((x) => x.isReal == false || x.isNaN)) return "unsigned";
          if (ops.some((x) => x.isReal == false || x.isNaN !== false))
            return void 0;
          if (ops.some((x) => x.isNegative)) return "negative";
          if (ops.every((x) => x.isNonNegative))
            return ops.some((x) => x.is(0)) ? "zero" : "non-negative";
          if (ops.some((x) => x.isNonPositive)) return "non-positive";
          if (ops.every((x) => x.isPositive)) return "positive";
          return void 0;
        },
        evaluate: (xs, { engine }) => evaluateMinMax(engine, xs, "Min")
      },
      Supremum: {
        description: "Like Max, but defined for open sets",
        complexity: 1200,
        threadable: false,
        // The function take a variable number of arguments,
        // including collections
        signature: "(...value) -> number | list",
        evaluate: (xs, { engine }) => evaluateMinMax(engine, xs, "Supremum")
      },
      Infimum: {
        description: "Like Min, but defined for open sets",
        complexity: 1200,
        threadable: false,
        // The function take a variable number of arguments,
        // including collections
        signature: "(...value) -> number | list",
        evaluate: (xs, { engine }) => evaluateMinMax(engine, xs, "Infimum")
      },
      Product: {
        description: "`Product(f, a, b)` computes the product of `f` from `a` to `b`",
        wikidata: "Q901718",
        complexity: 1e3,
        threadable: false,
        lazy: true,
        signature: "(collection|function, ...(tuple<symbol>|tuple<symbol, integer>|tuple<symbol, integer, integer>)) -> number",
        // The 'body' and 'range' need to be interpreted by canonicalMultiplication(). Don't canonicalize them yet.
        canonical: ([body, ...indexes2]) => canonicalBigop("Product", body, indexes2),
        evaluate: (ops, options) => {
          const fn = (acc, x) => {
            x = x.evaluate(options);
            if (!x.isNumberLiteral) return null;
            return acc.mul(x.numericValue);
          };
          const result = run(
            reduceBigOp(
              ops[0],
              ops.slice(1),
              fn,
              options.engine._numericValue(1)
            ),
            options.engine._timeRemaining
          );
          return options.engine.number(result ?? NaN);
        },
        evaluateAsync: async (ops, options) => {
          const fn = (acc, x) => {
            x = x.evaluate(options);
            if (!x.isNumberLiteral) return null;
            return acc.mul(x.numericValue);
          };
          const result = await runAsync(
            reduceBigOp(
              ops[0],
              ops.slice(1),
              fn,
              options.engine._numericValue(1)
            ),
            options.engine._timeRemaining,
            options.signal
          );
          return options.engine.number(result ?? NaN);
        }
      },
      Sum: {
        description: "`Sum(f, a, b)` computes the sum of `f` from `a` to `b`",
        wikidata: "Q218005",
        complexity: 1e3,
        threadable: false,
        lazy: true,
        signature: "(collection|function, ...(tuple<symbol>|tuple<symbol, integer>|tuple<symbol, integer, integer>)) -> number",
        canonical: ([body, ...indexes2]) => canonicalBigop("Sum", body, indexes2),
        evaluate: (xs, { engine }) => engine.number(
          run(
            reduceBigOp(
              xs[0],
              xs.slice(1),
              (acc, x) => {
                x = x.evaluate();
                if (!x.isNumberLiteral) return null;
                return acc.add(x.numericValue);
              },
              engine._numericValue(0)
            ),
            engine._timeRemaining
          )
        ),
        evaluateAsync: async (xs, { engine, signal }) => engine.number(
          await runAsync(
            reduceBigOp(
              xs[0],
              xs.slice(1),
              (acc, x) => {
                x = x.evaluate();
                if (!x.isNumberLiteral) return null;
                return acc.add(x.numericValue);
              },
              engine._numericValue(0)
            ),
            engine._timeRemaining,
            signal
          )
        )
      }
    },
    //
    // Formatting and string processing
    //
    {
      BaseForm: {
        description: "`BaseForm(expr, base=10)`",
        complexity: 9e3,
        signature: "(number, (string|integer)?) -> string | nothing",
        type: ([x]) => x === void 0 ? "nothing" : x.type,
        evaluate: ([x]) => x
      },
      FromDigits: {
        description: `\`FromDigits(s, base=10)\`       return an integer representation of the string \`s\` in base \`base\`.`,
        // @todo could accept `0xcafe`, `0b01010` or `(deadbeef)_16` as string formats
        // @todo could accept "roman"... as base
        // @todo could accept optional third parameter as the (padded) length of the output
        signature: "(string, (string|integer)?) -> integer",
        evaluate: (ops, { engine }) => {
          let op1 = ops[0]?.string;
          const ce = engine;
          if (!op1) return ce.typeError("string", ops[0]?.type, ops[0]);
          op1 = op1.trim();
          if (op1.startsWith("0x")) return ce.number(parseInt(op1.slice(2), 16));
          if (op1.startsWith("0b")) return ce.number(parseInt(op1.slice(2), 2));
          const op2 = ops[1] ?? ce.Nothing;
          if (op2.symbol === "Nothing")
            return ce.number(Number.parseInt(op1, 10));
          const base = op2.re;
          if (!op2.isInteger || !Number.isFinite(base) || base < 2 || base > 36)
            return ce.error(["unexpected-base", base.toString()], op2.toString());
          const [value, rest] = fromDigits(op1, op2.string ?? op2.symbol ?? 10);
          if (rest) return ce.error(["unexpected-digit", rest[0]], rest);
          return ce.number(value);
        }
      },
      IntegerString: {
        description: `\`IntegerString(n, base=10)\`       return a string representation of the integer \`n\` in base \`base\`.`,
        // @todo could accept `0xcafe`, `0b01010` or `(deadbeef)_16` as string formats
        // @todo could accept "roman"... as base
        // @todo could accept optional third parameter as the (padded) length of the output
        threadable: true,
        signature: "(integer, integer?) -> string",
        evaluate: (ops, { engine }) => {
          const ce = engine;
          const op1 = ops[0];
          if (!op1.isInteger) return ce.typeError("integer", op1.type, op1);
          const val = op1.re;
          if (!Number.isFinite(val))
            return ce.typeError("integer", op1.type, op1);
          const op2 = ops[1] ?? ce.Nothing;
          if (op2.symbol === "Nothing") {
            if (op1.bignumRe !== void 0)
              return ce.string(op1.bignumRe.abs().toString());
            return ce.string(Math.abs(val).toString());
          }
          const base = asSmallInteger(op2);
          if (base === null) return ce.typeError("integer", op2.type, op2);
          if (base < 2 || base > 36)
            return ce.error(
              ["out-of-range", "2", "36", base.toString()],
              op2.toString()
            );
          return ce.string(Math.abs(val).toString(base));
        }
      }
    }
  ];
  function evaluateAbs(arg) {
    const ce = arg.engine;
    const num = arg.numericValue;
    if (num !== null) {
      if (typeof num === "number") return ce.number(Math.abs(num));
      return ce.number(num.abs());
    }
    if (arg.isNonNegative) return arg;
    if (arg.isNegative) return arg.neg();
    return void 0;
  }
  function processMinMaxItem(item, mode2) {
    const ce = item.engine;
    const upper = mode2 === "Max" || mode2 === "Supremum";
    if (item.operator === "Interval") {
      const b = upper ? item.op2 : item.op1;
      if (!b.isNumber || b.numericValue === null) return [void 0, [item]];
      return [b, []];
    }
    if (item.operator === "Range") {
      const r = range(item);
      const last = rangeLast(r);
      return [ce.number(Math.max(r[0], last)), []];
    }
    if (item.operator === "Linspace") {
      if (item.nops === 1) item = upper ? item.op1 : ce.One;
      else if (upper) item = item.op2;
      else item = item.op1;
      return [item, []];
    }
    if (item.isCollection) {
      let result = void 0;
      const rest = [];
      for (const op of each(item)) {
        const [val, others] = processMinMaxItem(op, mode2);
        if (val) {
          if (!result) result = val;
          else {
            if (upper && val.isGreater(result) || !upper && val.isLess(result))
              result = val;
          }
        }
        rest.push(...others);
      }
      return [result, rest];
    }
    if (!item.isNumber || item.numericValue === null) return [void 0, [item]];
    return [item, []];
  }
  function evaluateMinMax(ce, ops, mode2) {
    const upper = mode2 === "Max" || mode2 === "Supremum";
    if (ops.length === 0)
      return upper ? ce.NegativeInfinity : ce.PositiveInfinity;
    let result = void 0;
    const rest = [];
    for (const op of ops) {
      const [val, others] = processMinMaxItem(op, mode2);
      if (val) {
        if (!result) result = val;
        else {
          if (upper && val.isGreater(result) || !upper && val.isLess(result))
            result = val;
        }
      }
      rest.push(...others);
    }
    if (rest.length > 0)
      return ce.box(result ? [mode2, result, ...rest] : [mode2, ...rest]);
    return result ?? (upper ? ce.NegativeInfinity : ce.PositiveInfinity);
  }
  function evaluateGcdLcm(ops, mode2) {
    const ce = ops[0].engine;
    const fn = mode2 === "LCM" ? lcm : gcd;
    const bigFn = mode2 === "LCM" ? lcm3 : gcd3;
    const rest = [];
    if (bignumPreferred(ce)) {
      let result2 = null;
      for (const op of ops) {
        if (result2 === null) {
          result2 = asBignum(op);
          if (result2 === null || !result2.isInteger()) rest.push(op);
        } else {
          const d = asBignum(op);
          if (d && d.isInteger()) result2 = bigFn(result2, d);
          else rest.push(op);
        }
      }
      if (rest.length === 0) return result2 === null ? ce.One : ce.number(result2);
      if (result2 === null) return ce._fn(mode2, rest);
      return ce._fn(mode2, [ce.number(result2), ...rest]);
    }
    let result = null;
    for (const op of ops) {
      if (result === null) {
        if (op.isInteger) rest.push(op);
      } else {
        if (!op.isInteger) rest.push(op);
        else result = fn(result, op.re);
      }
    }
    if (rest.length === 0) return result === null ? ce.One : ce.number(result);
    if (result === null) return ce._fn(mode2, rest);
    return ce._fn(mode2, [ce.number(result), ...rest]);
  }
  function isPrime2(expr) {
    if (!expr.isInteger) return void 0;
    if (expr.isNegative) return void 0;
    const value = expr.numericValue;
    if (value === null) return void 0;
    const n = asSmallInteger(expr);
    if (n !== null) return isPrime(n);
    const b = asBigint(expr);
    if (b !== null) return isPrimeBigint(b);
    return void 0;
  }

  // src/compute-engine/boxed-expression/rules.ts
  var CONDITIONS = {
    boolean: (x) => x.type.matches("boolean"),
    string: (x) => x.string !== null,
    number: (x) => x.isNumberLiteral,
    symbol: (x) => x.symbol !== null,
    expression: (x) => true,
    numeric: (x) => {
      const [c, term] = x.toNumericValue();
      return term.is(1);
    },
    integer: (x) => x.isInteger,
    rational: (x) => x.isRational,
    irrational: (x) => x.isRational === false,
    real: (x) => x.isReal,
    notreal: (x) => !x.isReal,
    // number with a non-zero imaginary part:
    complex: (x) => x.type.matches("complex"),
    // number with a zero real part and non-zero imaginary part:
    imaginary: (x) => x.type.matches("imaginary"),
    positive: (x) => x.isPositive,
    negative: (x) => x.isNegative,
    nonnegative: (x) => x.isNonNegative,
    nonpositive: (x) => x.isNonPositive,
    even: (x) => x.isEven,
    odd: (x) => x.isOdd,
    prime: (x) => isPrime2(x) === true,
    composite: (x) => isPrime2(x) === false,
    notzero: (x) => x.is(0) === false,
    notone: (x) => x.is(1) === false,
    finite: (x) => x.isFinite,
    infinite: (x) => x.isFinite === false,
    constant: (x) => x.symbolDefinition?.isConstant ?? false,
    variable: (x) => !(x.symbolDefinition?.isConstant ?? true),
    function: (x) => x.symbolDefinition?.isFunction ?? false,
    relation: (x) => isRelationalOperator(x.operator),
    equation: (x) => x.operator === "Equal",
    inequality: (x) => isInequality(x),
    collection: (x) => x.isCollection,
    list: (x) => x.operator === "List",
    set: (x) => x.operator === "Set",
    tuple: (x) => x.operator === "Tuple" || x.operator === "Single" || x.operator === "Pair" || x.operator === "Triple",
    single: (x) => x.operator === "Single",
    pair: (x) => x.operator === "Pair",
    triple: (x) => x.operator === "Triple",
    scalar: (x) => x.rank === 0,
    tensor: (x) => x.rank > 0,
    vector: (x) => x.rank === 1,
    matrix: (x) => x.rank === 2,
    unit: (x) => x.operator === "Unit",
    dimension: (x) => x.operator === "Dimension",
    angle: (x) => x.operator === "Angle",
    polynomial: (x) => x.unknowns.length === 1
  };
  function checkConditions(x, conditions) {
    for (const cond of conditions) if (CONDITIONS[cond](x) !== true) return false;
    return true;
  }
  function tokenizeLaTeX(input) {
    const regex = /\\[a-zA-Z]+|[{}]|[\d]+|[+\-*/^_=()><,.;]|[a-zA-Z]/g;
    const tokens = input.match(regex);
    if (!tokens) return [];
    return tokens.filter((x) => !/^[ \f\n\r\t\v\xA0\u2028\u2029]+$/.test(x));
  }
  function parseModifier(parser) {
    const next = parser.peek;
    let modifier = null;
    if (next === "\\mathrm") {
      parser.nextToken();
      modifier = parser.parseStringGroup();
    } else if (/^[a-z]$/.test(next)) {
      modifier = parser.nextToken();
      while (/^[a-z]$/.test(parser.peek)) modifier += parser.nextToken();
    } else {
      const shortcuts = {
        ">0": "positive",
        "\\gt0": "positive",
        "<0": "negative",
        "\\lt0": "negative",
        ">=0": "nonnegative",
        "\\geq0": "nonnegative",
        "<=0": "nonpositive",
        "\\leq0": "nonpositive",
        "!=0": "notzero",
        "\\neq0": "notzero",
        "\\neq1": "notone",
        "!=1": "notone",
        "\\in\\R": "real",
        "\\in\\mathbb{R}": "real",
        "\\in\\C": "complex",
        "\\in\\mathbb{C}": "complex",
        "\\in\\Q": "rational",
        "\\in\\mathbb{Q}": "rational",
        "\\in\\Z^+": "integer,positive",
        "\\in\\Z^-": "intger,negative",
        "\\in\\Z^*": "nonzero",
        "\\in\\R^+": "positive",
        "\\in\\R^-": "negative",
        "\\in\\R^*": "real,nonzero",
        "\\in\\Z": "integer",
        "\\in\\mathbb{Z}": "integer",
        "\\in\\N": "integer,nonnegative",
        "\\in\\mathbb{N}": "integer,nonnegative",
        "\\in\\N^*": "integer,positive",
        "\\in\\N_0": "integer,nonnegative",
        "\\in\\R\\backslash\\Q": "irrational"
      };
      for (const shortcut in shortcuts) {
        if (parser.matchAll(tokenizeLaTeX(shortcut))) {
          modifier = shortcuts[shortcut];
          break;
        }
      }
    }
    if (!modifier) return null;
    if (!Object.keys(CONDITIONS).includes(modifier))
      throw new Error(`Unexpected condition "${modifier}" in a rule`);
    return modifier;
  }
  function parserModifiers(parser) {
    const modifiers = [];
    do {
      const modifier = parseModifier(parser);
      if (!modifier) break;
      modifiers.push(modifier);
    } while (parser.match(","));
    return modifiers.join(",");
  }
  function parseModifierExpression(parser) {
    let conditions = null;
    if (parser.match(":")) conditions = parserModifiers(parser);
    else if (parser.matchAll(["_", "<{>"])) {
      conditions = parserModifiers(parser);
      if (!parser.match("<}>")) return null;
    }
    return conditions;
  }
  function parseRulePart(ce, rule, options) {
    if (rule === void 0 || typeof rule === "function") return void 0;
    if (typeof rule === "string") {
      let expr = ce.parse(rule, { canonical: options?.canonical ?? false });
      expr = expr.map(
        (x) => {
          if (x.symbol && x.symbol.length === 1) return ce.symbol("_" + x.symbol);
          return x;
        },
        { canonical: false }
      );
      return expr;
    }
    return ce.box(rule, { canonical: options?.canonical ?? false });
  }
  function parseRule(ce, rule, options) {
    const makeWildcardEntry = (x) => {
      return {
        kind: "symbol",
        latexTrigger: x,
        // domain: { kind: 'Any' },
        parse: (parser, until) => {
          if (!wildcards[x]) wildcards[x] = `_${x}`;
          const conditions = parseModifierExpression(parser);
          if (conditions !== null) {
            if (!wildcardConditions[x]) wildcardConditions[x] = conditions;
            else wildcardConditions[x] += "," + conditions;
          }
          return wildcards[x];
        }
      };
    };
    const previousDictionary = ce.latexDictionary;
    const wildcards = {};
    const wildcardConditions = {};
    ce.latexDictionary = [
      ...previousDictionary,
      {
        kind: "prefix",
        precedence: 100,
        latexTrigger: "...",
        parse: (parser, until) => {
          const id = parser.nextToken();
          if (!"abcfghjklmnopqrstuvwxyz".includes(id)) return null;
          let prefix = "__";
          if (parser.match("?")) prefix = "___";
          if (wildcards[id] && wildcards[id] !== `${prefix}${id}`)
            throw new Error(`Duplicate wildcard "${id}"`);
          if (!wildcards[id]) wildcards[id] = `${prefix}${id}`;
          const conditions = parseModifierExpression(parser);
          if (conditions === null) return null;
          if (!wildcardConditions[id]) wildcardConditions[id] = conditions;
          else wildcardConditions[id] += "," + conditions;
          return `${prefix}${id}`;
        }
      },
      ..."abcfghjklmnopqrstuvwxyz".split("").map(makeWildcardEntry),
      {
        kind: "infix",
        precedence: 100,
        latexTrigger: "->",
        parse: (parser, lhs, until) => {
          const rhs = parser.parseExpression({ ...until, minPrec: 20 });
          if (rhs === null) return null;
          let conditionPredicate = null;
          if (parser.match(";")) {
            let done = false;
            const start = parser.index;
            do {
              parser.skipSpace();
              const id = parser.nextToken();
              if (wildcards[id]) {
                const conditions2 = parseModifierExpression(parser);
                if (conditions2 === null || !conditions2) {
                  done = true;
                  parser.index = start;
                  break;
                }
                if (!wildcardConditions[id]) wildcardConditions[id] = conditions2;
                else wildcardConditions[id] += "," + conditions2;
              }
            } while (!done && !parser.atEnd);
            conditionPredicate = parser.parseExpression(until);
          }
          const conditions = [];
          for (const id in wildcardConditions) {
            const xs = wildcardConditions[id].split(",");
            if (xs.length === 0) continue;
            if (xs.length === 1) {
              conditions.push(["Condition", wildcards[id], xs[0]]);
            } else conditions.push(["Condition", wildcards[id], ["And", ...xs]]);
          }
          let conditionExpression = void 0;
          if (conditionPredicate && conditions.length > 0) {
            conditionExpression = ["And", conditionPredicate, ...conditions];
          } else if (conditionPredicate) conditionExpression = conditionPredicate;
          else if (conditions.length === 1) conditionExpression = conditions[0];
          else if (conditions.length > 1)
            conditionExpression = ["And", ...conditions];
          if (conditionExpression) return ["Rule", lhs, rhs, conditionExpression];
          return ["Rule", lhs, rhs];
        }
      }
    ];
    const expr = ce.parse(rule, { canonical: options?.canonical ?? false });
    ce.latexDictionary = previousDictionary;
    if (!expr.isValid || expr.operator !== "Rule")
      throw new Error(
        `Invalid rule "${rule}"
|   ${dewildcard(expr).toString()}
|   A rule should be of the form:
|   <match> -> <replace>; <condition>`
      );
    const [match2, replace2, condition] = expr.ops;
    if (!includesWildcards(replace2, match2))
      throw new Error(
        `Invalid rule "${rule}"
|   The replace expression contains wildcards not present in the match expression`
      );
    if (match2.isSame(replace2)) {
      throw new Error(
        `Invalid rule "${rule}"
|   The match and replace expressions are the same.
|   This may be because the rule is not necessary due to canonical simplification`
      );
    }
    let condFn = void 0;
    if (condition !== void 0) {
      if (!includesWildcards(condition, match2))
        throw new Error(
          `Invalid rule "${rule}"
|   The condition expression contains wildcards not present in the match expression`
        );
      condFn = (sub2) => condition.subs(sub2).evaluate()?.symbol === "True";
    }
    return boxRule(ce, { match: match2, replace: replace2, condition: condFn, id: rule }, options);
  }
  function boxRule(ce, rule, options) {
    if (rule === void 0 || rule === null)
      throw new Error("Expected a rule, not " + rule);
    if (isBoxedRule(rule)) return rule;
    if (typeof rule === "string") return parseRule(ce, rule, options);
    if (typeof rule === "function")
      return {
        _tag: "boxed-rule",
        match: void 0,
        replace: rule,
        condition: void 0,
        id: rule.toString().replace(/\n/g, " ")
      };
    let { match: match2, replace: replace2, condition, id } = rule;
    if (replace2 === void 0)
      throw new Error(
        `Invalid rule "${id ?? JSON.stringify(rule)}"
|   A rule must include at least a replace property`
      );
    let condFn;
    if (typeof condition === "string") {
      const latex = asLatexString(condition);
      if (latex) {
        const condPattern = ce.parse(latex, {
          canonical: options?.canonical ?? false
        });
        condFn = (x, _ce) => condPattern.subs(x).evaluate()?.symbol === "True";
      }
    } else {
      if (condition !== void 0 && typeof condition !== "function")
        throw new Error(
          `Invalid rule ${id ?? JSON.stringify(rule)}
|   condition is not a valid function`
        );
      condFn = condition;
    }
    if (typeof match2 === "function") {
      throw new Error(
        `Invalid rule ${id ?? JSON.stringify(rule)}
|   match is not a valid expression.
|   Use a replace function instead to validate and replace the expression`
      );
    }
    const matchExpr = parseRulePart(ce, match2, options);
    const replaceExpr = parseRulePart(ce, replace2, options);
    if (!id) {
      if (typeof match2 === "string") id = match2;
      else id = JSON.stringify(match2);
      if (replace2) {
        id += " -> ";
        if (typeof replace2 === "string") id += replace2;
        else if (typeof replace2 === "function")
          id += replace2?.toString().replace(/\n/g, " ");
        else id = JSON.stringify(replace2);
      }
      if (typeof condition === "string") id += `; ${condition}`;
      else if (typeof condition === "function")
        id += `; ${condition.toString().replace(/\n/g, " ")}`;
    }
    if (matchExpr && !matchExpr.isValid) {
      throw new Error(
        `Invalid rule ${id}
|   the match expression is not valid: ${matchExpr.toString()}`
      );
    }
    if (replaceExpr && !replaceExpr.isValid) {
      throw new Error(
        `Invalid rule ${id ?? JSON.stringify(rule)}
|   The replace expression is not valid: ${replaceExpr?.toString()}`
      );
    }
    if (!replaceExpr && typeof replace2 !== "function")
      throw new Error(
        `Invalid rule ${id ?? JSON.stringify(rule)}
|   The replace expression could not be parsed`
      );
    return {
      _tag: "boxed-rule",
      match: matchExpr,
      replace: replaceExpr ?? replace2,
      condition: condFn,
      useVariations: rule.useVariations,
      id
    };
  }
  function boxRules(ce, rs, options) {
    if (!rs) return { rules: [] };
    if (typeof rs === "object" && "rules" in rs) return rs;
    if (!Array.isArray(rs)) rs = [rs];
    const rules = [];
    for (const rule of rs) {
      try {
        rules.push(boxRule(ce, rule, options));
      } catch (e) {
        throw new Error(
          `
${e.message}
|   Skipping rule ${JSON.stringify(rule)}

`
        );
      }
    }
    return { rules };
  }
  function applyRule(rule, expr, substitution, options) {
    const canonical2 = options?.canonical ?? (expr.isCanonical || expr.isStructural);
    let operandsMatched = false;
    if (expr.ops && options?.recursive) {
      const newOps = expr.ops.map((op) => {
        const subExpr = applyRule(rule, op, {}, options);
        if (!subExpr) return op;
        operandsMatched = true;
        return subExpr.value;
      });
      if (operandsMatched)
        expr = expr.engine.function(expr.operator, newOps, { canonical: canonical2 });
    }
    let { match: match2, replace: replace2, condition, id } = rule;
    const because = id ?? "";
    if (canonical2 && match2) {
      const awc = getWildcards(match2);
      const originalMatch = match2;
      match2 = match2.canonical;
      const bwc = getWildcards(match2);
      if (!awc.every((x) => bwc.includes(x)))
        throw new Error(
          `
|   Invalid rule "${rule.id}"
|   The canonical form of ${dewildcard(originalMatch).toString()} is "${dewildcard(match2).toString()}" and it does not contain all the wildcards of the original match.
|   This could indicate that the match expression in canonical form is already simplified and this rule may not be necessary`
        );
    }
    const useVariations = rule.useVariations ?? options?.useVariations ?? false;
    const sub2 = match2 ? expr.match(match2, { substitution, ...options, useVariations }) : {};
    if (sub2 === null) return operandsMatched ? { value: expr, because } : null;
    if (typeof condition === "function") {
      const conditionSub = {
        ...Object.fromEntries(
          Object.entries(sub2).map(([k, v]) => [k.slice(1), v])
        ),
        ...sub2
      };
      try {
        if (!condition(conditionSub, expr.engine))
          return operandsMatched ? { value: expr, because } : null;
      } catch (e) {
        console.error(
          `
|   Rule "${rule.id}"
|   Error while checking condition
|    ${e.message}`
        );
        return null;
      }
    }
    const result = typeof replace2 === "function" ? replace2(expr, sub2) : replace2.subs(sub2, { canonical: canonical2 });
    if (!result) return null;
    if (isRuleStep(result))
      return canonical2 ? { ...result, value: result.value.canonical } : result;
    return { value: canonical2 ? result.canonical : result, because };
  }
  function replace(expr, rules, options) {
    if (!rules) throw new Error("replace(): Expected one or more rules");
    const iterationLimit = options?.iterationLimit ?? 1;
    let iterationCount = 0;
    const once = options?.once ?? false;
    let ruleSet;
    if (typeof rules === "object" && "rules" in rules) ruleSet = rules.rules;
    else {
      ruleSet = expr.engine.rules(
        Array.isArray(rules) ? rules : [rules]
      ).rules;
    }
    let done = false;
    const steps = [];
    while (!done && iterationCount < iterationLimit) {
      done = true;
      for (const rule of ruleSet) {
        try {
          const result = applyRule(rule, expr, {}, options);
          if (result !== null && result.value !== expr && !result.value.isSame(expr)) {
            if (once) return [result];
            if (steps.some((x) => x.value.isSame(result.value))) return steps;
            steps.push(result);
            done = false;
            expr = result.value;
          }
        } catch (e) {
          console.error(`
${expr.toString()}
${rule.id}
${e.message}`);
          return steps;
        }
      }
      iterationCount += 1;
    }
    return steps;
  }
  function matchAnyRules(expr, rules, sub2, options) {
    const results = [];
    for (const rule of rules.rules) {
      const r = applyRule(rule, expr, sub2, options);
      if (r !== null && !results.some((x) => x.isSame(r.value)))
        results.push(r.value);
    }
    return results;
  }
  function dewildcard(expr) {
    const symbol2 = expr.symbol;
    if (symbol2) {
      if (symbol2.startsWith("_")) return expr.engine.symbol(symbol2.slice(1));
    }
    if (expr.ops) {
      const ops = expr.ops.map((x) => dewildcard(x));
      return expr.engine.function(expr.operator, ops, { canonical: false });
    }
    return expr;
  }
  function getWildcards(expr) {
    const wildcards = [];
    if (expr.symbol && expr.symbol.startsWith("_")) wildcards.push(expr.symbol);
    if (expr.ops) expr.ops.forEach((x) => wildcards.push(...getWildcards(x)));
    return wildcards;
  }
  function includesWildcards(a, b) {
    const awc = getWildcards(a);
    const bwc = getWildcards(b);
    return awc.every((x) => bwc.includes(x));
  }
  function isRuleStep(x) {
    return x && typeof x === "object" && "because" in x && "value" in x;
  }
  function isBoxedRule(x) {
    return x && typeof x === "object" && x._tag === "boxed-rule";
  }

  // src/compute-engine/boxed-expression/solve.ts
  var UNIVARIATE_ROOTS = [
    // ax = 0
    {
      match: ["Multiply", "_x", "__a"],
      replace: 0,
      id: "ax",
      condition: ({ __a }) => !__a.has("_x")
    },
    // a/x + b = 0
    {
      match: ["Add", ["Divide", "_a", "_x"], "__b"],
      replace: Infinity,
      useVariations: true,
      // Handle a/x = 0
      condition: ({ _a, __b }) => !_a.has("_x") && !__b.has("_x")
    },
    // ax + b = 0
    {
      match: ["Add", ["Multiply", "_x", "__a"], "__b"],
      replace: ["Divide", ["Negate", "__b"], "__a"],
      useVariations: true,
      // Handle ax = 0
      condition: ({ __a, __b }) => !__a.has("_x") && !__b.has("_x")
    },
    // ax^n + b = 0
    {
      match: ["Add", ["Multiply", "_a", ["Power", "_x", "_n"]], "__b"],
      replace: [
        "Power",
        ["Divide", ["Negate", "__b"], "_a"],
        ["Divide", 1, "_n"]
      ],
      useVariations: true,
      condition: ({ _a, __b, _n }) => !_a.has("_x") && !__b.has("_x") && !_n.is(0)
    },
    {
      match: ["Add", ["Multiply", "_a", ["Power", "_x", "_n"]], "__b"],
      replace: [
        "Negate",
        ["Power", ["Divide", ["Negate", "__b"], "_a"], ["Divide", 1, "_n"]]
      ],
      useVariations: true,
      condition: ({ _a, __b, _n }) => !_a.has("_x") && !__b.has("_x") && !_n.is(0) && (_n.isEven ?? false)
    },
    //
    // Quadratic formula
    // ax^2 + bx + c = 0
    //
    {
      match: [
        "Add",
        ["Multiply", "__a", ["Power", "_x", 2]],
        ["Multiply", "__b", "_x"],
        "__c"
      ],
      replace: [
        "Divide",
        [
          "Add",
          ["Negate", "__b"],
          [
            "Sqrt",
            ["Subtract", ["Square", "__b"], ["Multiply", 4, "__a", "__c"]]
          ]
        ],
        ["Multiply", 2, "__a"]
      ],
      useVariations: true,
      condition: ({ __a, __b, __c }) => !__a.has("_x") && !__b.has("_x") && !__c.has("_x")
    },
    {
      match: [
        "Add",
        ["Multiply", "__a", ["Power", "_x", 2]],
        ["Multiply", "__b", "_x"],
        "__c"
      ],
      replace: [
        "Divide",
        [
          "Subtract",
          ["Negate", "__b"],
          [
            "Sqrt",
            ["Subtract", ["Square", "__b"], ["Multiply", 4, "__a", "__c"]]
          ]
        ],
        ["Multiply", 2, "__a"]
      ],
      useVariations: true,
      condition: ({ __a, __b, __c }) => !__a.has("_x") && !__b.has("_x") && !__c.has("_x")
    },
    // a * e^(bx) + c = 0
    {
      match: [
        "Add",
        ["Multiply", "__a", ["Exp", ["Multiply", "__b", "_x"]]],
        "__c"
      ],
      replace: ["Divide", ["Ln", ["Negate", ["Divide", "__c", "__a"]]], "__b"],
      useVariations: true,
      condition: ({ __a, __c }) => ((!__a.is(0) && __c.div(__a).isNegative) ?? false) && !__a.has("_x") && !__c.has("_x")
    },
    // a * e^(x) + c = 0
    {
      match: ["Add", ["Multiply", "__a", ["Exp", "_x"]], "__c"],
      replace: ["Ln", ["Negate", ["Divide", "__c", "__a"]]],
      useVariations: true,
      condition: ({ __a, __c }) => ((!__a.is(0) && __c.div(__a).isNegative) ?? false) && !__a.has("_x") && !__c.has("_x")
    },
    // e^(x) + c = 0
    {
      match: ["Add", ["Exp", "_x"], "__c"],
      replace: ["Ln", ["Negate", "__c"]],
      useVariations: true,
      condition: ({ __c }) => __c.isNegative ?? false
    },
    // e^(bx) + c = 0
    {
      match: ["Add", ["Exp", ["Multiply", "__b", "_x"]], "__c"],
      replace: ["Divide", ["Ln", ["Negate", "__c"]], "__b"],
      useVariations: true,
      condition: ({ __c }) => __c.isNegative ?? false
    },
    // a * log_b(x) + c = 0
    {
      match: ["Add", ["Multiply", "__a", ["Log", "_x", "__b"]], "__c"],
      replace: ["Power", "__b", ["Negate", ["Divide", "__c", "__a"]]],
      useVariations: true,
      condition: ({ __a, __b }) => (!__a.is(0) && __b.isPositive) ?? false
    },
    // a * log_b(x) = 0
    {
      match: ["Multiply", "__a", ["Log", "_x", "__b"]],
      replace: ["Power", "__b", ["Negate", ["Divide", "__c", "__a"]]],
      useVariations: true,
      condition: ({ __a, __b }) => (!__a.is(0) && __b.isPositive) ?? false
    },
    // |ax + b| + c = 0
    {
      match: ["Add", ["Abs", ["Add", ["Multiply", "__a", "_x"], "__b"]], "__c"],
      replace: ["Divide", ["Subtract", "__b", "__c"], "__a"]
    },
    {
      match: ["Add", ["Abs", ["Add", ["Multiply", "__a", "_x"], "__b"]], "__c"],
      replace: ["Divide", ["Negate", ["Add", "__b", "__c"], "__a"]]
    },
    // ax + c\sqrt{dx + f} + g = 0
    // plus
    {
      match: "ax + \\mathrm{__b} \\sqrt{cx + \\mathrm{__d}} + \\mathrm{__g}",
      replace: "\\frac{-(2 a g - \\mathrm{__b}^2 c) + \\sqrt{(2 a \\mathrm{__g} - \\mathrm{__b}^2 c)^2 - 4 a^2(g^2 - b^2 \\mathrm{__d})}}{2 a^2}",
      useVariations: true,
      condition: ({ a, __b, c, d, __g }) => !a.has("_x") && !__b.has("_x") && !c.has("_x") && !d.has("_x") && !__g.has("_x")
    },
    // minus
    {
      match: "ax + \\mathrm{__b} \\sqrt{cx + \\mathrm{__d}} + \\mathrm{__g}",
      replace: "\\frac{-(2 a g - \\mathrm{__b}^2 c) - \\sqrt{(2 a \\mathrm{__g} - \\mathrm{__b}^2 c)^2 - 4 a^2(g^2 - b^2 \\mathrm{__d})}}{2 a^2}",
      useVariations: true,
      condition: ({ a, __b, c, d, __g }) => !a.has("_x") && !__b.has("_x") && !c.has("_x") && !d.has("_x") && !__g.has("_x")
    }
  ];
  function findUnivariateRoots(expr, x) {
    const ce = expr.engine;
    if (expr.operator === "Equal")
      expr = expr.op1.expand().sub(expr.op2.expand()).simplify();
    else expr = expr.expand().simplify();
    const rules = ce.getRuleSet("solve-univariate");
    let exprs = [expr.subs({ [x]: "_x" }, { canonical: false })];
    let result = exprs.flatMap(
      (expr2) => matchAnyRules(
        expr2,
        rules,
        { _x: ce.symbol("_x") },
        { useVariations: true, canonical: true }
      )
    );
    if (result.length === 0) {
      exprs = exprs.flatMap((expr2) => harmonize(expr2));
      result = exprs.flatMap(
        (expr2) => matchAnyRules(
          expr2,
          rules,
          { _x: ce.symbol(x) },
          { useVariations: true, canonical: true }
        )
      );
    }
    if (result.length === 0) {
      exprs = exprs.flatMap((expr2) => expand2(expr2.canonical)).filter((x2) => x2 !== null);
      exprs = exprs.flatMap((expr2) => harmonize(expr2));
      result = exprs.flatMap(
        (expr2) => matchAnyRules(
          expr2,
          rules,
          { _x: ce.symbol(x) },
          { useVariations: true, canonical: true }
        )
      );
    }
    return validateRoots(
      expr,
      x,
      result.map((x2) => x2.evaluate().simplify())
    );
  }
  var HARMONIZATION_RULES = [
    // |ax + b| + c -> ax+b+c, -ax-b+c
    {
      match: ["Add", ["Abs", ["Add", ["Multiply", "__a", "_x"], "__b"]], "__c"],
      replace: ["Add", ["Multiply", "__a", "_x"], "__b", "__c"]
    },
    {
      match: ["Add", ["Abs", ["Add", ["Multiply", "__a", "_x"], "__b"]], "__c"],
      replace: [
        "Add",
        ["Negate", ["Multiply", "__a", "_x"]],
        ["Negate", "__b"],
        "__c"
      ]
    },
    // a(b^n) -> a
    {
      match: ["Multiply", "__a", ["Power", "_b", "_n"]],
      replace: "_b",
      condition: ({ __a, _b, _n }) => !__a.has("_x") && _b.has("_x") && !_n.is(0) && !_n.has("_x")
    },
    // a√b(x)  -> a^2 b(x)
    {
      match: ["Multiply", "__a", ["Sqrt", "_b"]],
      replace: ["Multiply", ["Square", "_a"], "__b"],
      condition: ({ _b }) => _b.has("_x")
    },
    // a(x)/b -> a(x)
    {
      match: ["Divide", "_a", "_b"],
      replace: "_a",
      // @todo: check _b after the substitution
      condition: ({ _a, _b }) => _a.has("_x") && !_b.is(0)
    },
    // ab(x) -> b(x)
    // The solution for a product are the solutions for each term,
    {
      match: ["Multiply", "__a", "_b"],
      replace: "_b",
      condition: ({ __a, _b }) => !__a.has("_x") && _b.has("_x")
    },
    // ln(a(x))+ln(b(x))+c -> ln(a(x)b(x)) + c
    {
      match: ["Add", ["Ln", "_a"], ["Ln", "_b"], "__c"],
      replace: ["Add", ["Ln", ["Multiply", "_a", "_b"]], "__c"]
    },
    // e^a * e^b -> e^(a+b)
    {
      match: ["Multiply", ["Exp", "__a"], ["Exp", "__b"], "__c"],
      replace: ["Multiply", ["Exp", ["Add", "_a", "_b"]], "__c"]
    },
    // ln(f(x)) -> f(x) - 1
    {
      match: ["Ln", "_a"],
      replace: ["Subtract", "_a", 1],
      // @todo: additional condition, f(x) > 0
      condition: ({ _a }) => _a.has("_x")
    },
    // sin(f(x)) -> f(x)
    {
      match: ["Sin", "_a"],
      replace: "_a",
      condition: ({ _a }) => _a.has("_x")
    },
    // cos(f(x)) -> f(x) - π/2
    {
      match: ["Cos", "_a"],
      replace: ["Subtract", "_a", ["Divide", "Pi", 2]],
      condition: ({ _a }) => _a.has("_x")
    },
    // tan(f(x)) -> f(x) - π/4
    {
      match: ["Tan", "_a"],
      replace: "_a",
      condition: ({ _a }) => _a.has("_x")
    },
    // sin(a) + cos(a) -> 1
    {
      match: ["Add", ["Sin", "_a"], ["Cos", "_a"]],
      replace: 1,
      condition: ({ _a }) => _a.has("_x")
    },
    // sin^2(a) - cos^2(a) -> sin(x) +/- √(2)/2
    {
      match: ["Subtract", ["Square", ["Sin", "_a"]], ["Square", ["Cos", "_a"]]],
      replace: ["PlusMinus", ["Sin", "_a"], ["Divide", ["Sqrt", 2], 2]],
      condition: ({ _a }) => _a.has("_x")
    }
  ];
  function harmonize(expr) {
    const ce = expr.engine;
    const rules = ce.getRuleSet("harmonization");
    return matchAnyRules(expr, rules, { _x: ce.symbol("_x") });
  }
  function validateRoots(expr, x, roots) {
    return roots.filter((root2) => {
      const value = expr.subs({ [x]: root2 }).N();
      if (value === null) return false;
      if (!value.isValid) return false;
      if (value.isNaN) return false;
      if (value.has(x)) return false;
      return value.isEqual(0);
    });
  }

  // src/compute-engine/assume.ts
  function assume(proposition) {
    if (proposition.operator === "Element") return assumeElement(proposition);
    if (proposition.operator === "Equal") return assumeEquality(proposition);
    if (isInequality(proposition)) return assumeInequality(proposition);
    throw new Error(
      "Unsupported assumption. Use `Element`, `Equal` or an inequality"
    );
  }
  function assumeEquality(proposition) {
    console.assert(proposition.operator === "Equal");
    const unknowns = proposition.unknowns;
    if (unknowns.length === 0) {
      const val = proposition.evaluate();
      if (val.symbol === "True") return "tautology";
      if (val.symbol === "False") return "contradiction";
      console.log(proposition.canonical.evaluate());
      return "not-a-predicate";
    }
    const ce = proposition.engine;
    const lhs = proposition.op1.symbol;
    if (lhs && !hasValue(ce, lhs) && !proposition.op2.has(lhs)) {
      const val = proposition.op2.evaluate();
      if (!val.isValid) return "not-a-predicate";
      const def = ce.lookupSymbol(lhs);
      if (!def) {
        ce.defineSymbol(lhs, { value: val });
        return "ok";
      }
      if (def.type && !val.type.matches(def.type)) {
        if (!def.inferredType) return "contradiction";
      }
      def.value = val;
      if (def.inferredType) def.type = val.type;
      return "ok";
    }
    if (unknowns.length === 1) {
      const lhs2 = unknowns[0];
      const sols = findUnivariateRoots(proposition, lhs2);
      if (sols.length === 0) {
        ce.assumptions.set(
          ce.function("Equal", [proposition.op1.sub(proposition.op2), 0]),
          true
        );
      }
      const val = sols.length === 1 ? sols[0] : ce.function("List", sols);
      const def = ce.lookupSymbol(lhs2);
      if (!def) {
        ce.defineSymbol(lhs2, { value: val });
        return "ok";
      }
      if (def.type && !sols.every((sol) => !sol.type || val.type.matches(sol.type)))
        return "contradiction";
      def.value = val;
      return "ok";
    }
    ce.assumptions.set(proposition, true);
    return "ok";
  }
  function assumeInequality(proposition) {
    const ce = proposition.engine;
    if (proposition.op1.symbol && !hasDef(ce, proposition.op1.symbol)) {
      if (proposition.op2.is(0)) {
        if (proposition.operator === "Less") {
          ce.defineSymbol(proposition.op1.symbol, {
            type: "real",
            flags: { sgn: "negative" }
          });
        } else if (proposition.operator === "LessEqual") {
          ce.defineSymbol(proposition.op1.symbol, {
            type: "real",
            flags: { sgn: "non-positive" }
          });
        } else if (proposition.operator === "Greater") {
          ce.defineSymbol(proposition.op1.symbol, {
            type: "real",
            flags: { sgn: "positive" }
          });
        } else if (proposition.operator === "GreaterEqual") {
          ce.defineSymbol(proposition.op1.symbol, {
            type: "real",
            flags: { sgn: "non-negative" }
          });
        }
      } else {
        ce.defineSymbol(proposition.op1.symbol, { type: "real" });
        ce.assumptions.set(proposition, true);
      }
      return "ok";
    }
    let op = "";
    let lhs;
    let rhs;
    if (proposition.operator === "Less") {
      lhs = proposition.op1;
      rhs = proposition.op2;
      op = "<";
    } else if (proposition.operator === "LessEqual") {
      lhs = proposition.op1;
      rhs = proposition.op2;
      op = "<=";
    } else if (proposition.operator === "Greater") {
      lhs = proposition.op2;
      rhs = proposition.op1;
      op = "<";
    } else if (proposition.operator === "GreaterEqual") {
      lhs = proposition.op2;
      rhs = proposition.op1;
      op = "<=";
    }
    if (!op) return "internal-error";
    const p = lhs.sub(rhs);
    const result = ce.box([op === "<" ? "Less" : "LessEqual", p, 0]).evaluate();
    if (result.symbol === "True") return "tautology";
    if (result.symbol === "False") return "contradiction";
    const unknowns = result.unknowns;
    if (unknowns.length === 0) return "not-a-predicate";
    if (unknowns.length === 1) {
      if (!ce.lookupSymbol(unknowns[0]))
        ce.defineSymbol(unknowns[0], { type: "real" });
    }
    console.assert(result.operator === "Less" || result.operator === "LessEqual");
    ce.assumptions.set(result, true);
    return "ok";
  }
  function assumeElement(proposition) {
    console.assert(proposition.operator === "Element");
    const ce = proposition.engine;
    const undefs = undefinedIdentifiers(proposition.op1);
    if (undefs.length === 1) {
      const dom = proposition.op2.evaluate();
      if (!dom.isValid) return "not-a-predicate";
      const type2 = domainToType(dom);
      if (type2 === "unknown")
        throw new Error(`Invalid domain "${dom.toString()}"`);
      ce.declare(undefs[0], type2);
      return "ok";
    }
    if (proposition.op1.symbol && hasDef(ce, proposition.op1.symbol)) {
      const domain = proposition.op2.evaluate();
      if (!domain.isValid) return "not-a-predicate";
      const type2 = domainToType(domain);
      if (!ce.context?.ids?.has(proposition.op1.symbol))
        ce.declare(proposition.op1.symbol, domainToType(domain));
      const def = ce.lookupSymbol(proposition.op1.symbol);
      if (def) {
        if (def.type && !isSubtype(type2, def.type.type)) return "contradiction";
        def.type = new BoxedType(type2);
        return "ok";
      }
      const fdef = ce.lookupFunction(proposition.op1.symbol);
      if (fdef) {
        if (!isSubtype(type2, functionResult(fdef.signature.type)))
          return "contradiction";
        return "ok";
      }
      return "not-a-predicate";
    }
    if (undefs.length > 0) {
      ce.assumptions.set(proposition, true);
      return "ok";
    }
    const val = proposition.evaluate();
    if (val.symbol === "True") return "tautology";
    if (val.symbol === "False") return "contradiction";
    return "not-a-predicate";
  }
  function hasDef(ce, s) {
    return (ce.lookupSymbol(s) ?? ce.lookupFunction(s)) !== void 0;
  }
  function undefinedIdentifiers(expr) {
    return expr.symbols.filter((x) => !hasDef(expr.engine, x));
  }
  function hasValue(ce, s) {
    if (ce.lookupFunction(s)) return false;
    return ce.lookupSymbol(s)?.value !== void 0;
  }

  // src/compute-engine/boxed-expression/serialize.ts
  function _escapeJsonString(s) {
    return s;
  }
  function serializeSubtract(ce, a, b, options, metadata) {
    if (a.numericValue !== null && a.isNegative) {
      const v = a.numericValue;
      if (typeof v === "number") {
        return serializeJsonFunction(
          ce,
          "Subtract",
          [b, ce.number(-v)],
          options,
          metadata
        );
      }
      if (a.type.matches("rational")) {
        return serializeJsonFunction(
          ce,
          "Subtract",
          [b, ce.number(v.neg())],
          options,
          metadata
        );
      }
    }
    if (a.operator === "Negate" && b.operator !== "Negate")
      return serializeJsonFunction(ce, "Subtract", [b, a.op1], options, metadata);
    return null;
  }
  function serializePrettyJsonFunction(ce, name, args, options, metadata) {
    const exclusions = options.exclude;
    if (name === "Add" && args.length === 2 && !exclusions.includes("Subtract")) {
      const sub2 = serializeSubtract(ce, args[0], args[1], options, metadata) ?? serializeSubtract(ce, args[1], args[0], options, metadata);
      if (sub2) return sub2;
    }
    if (name === "Divide" && args.length === 2 && exclusions.includes("Divide")) {
      return serializeJsonFunction(
        ce,
        "Multiply",
        [args[0], ce._fn("Power", [args[1], ce.NegativeOne])],
        options,
        metadata
      );
    }
    if (name === "Multiply" && !exclusions.includes("Negate")) {
      if (args[0].im === 0 && args[0].re === -1) {
        if (args.length === 2)
          return serializeJsonFunction(ce, "Negate", [args[1]], options);
        return serializeJsonFunction(
          ce,
          "Negate",
          [ce._fn("Multiply", [...args.slice(1)].sort(order))],
          options,
          metadata
        );
      }
    }
    if (name === "Multiply" && !exclusions.includes("Divide")) {
      const result = new Product(ce, args, {
        canonical: false
      }).asRationalExpression();
      if (result.operator === "Divide")
        return serializeJsonFunction(
          ce,
          result.operator,
          result.ops,
          options,
          metadata
        );
    }
    if (name === "Power") {
      if (!exclusions.includes("Exp") && args[0]?.symbol === "ExponentialE")
        return serializeJsonFunction(ce, "Exp", [args[1]], options, metadata);
      if (args[1]?.numericValue !== null) {
        const exp2 = asSmallInteger(args[1]);
        if (exp2 === 2 && !exclusions.includes("Square"))
          return serializeJsonFunction(
            ce,
            "Square",
            [args[0]],
            options,
            metadata
          );
        if (exp2 !== null && exp2 < 0 && !exclusions.includes("Divide")) {
          return serializeJsonFunction(
            ce,
            "Divide",
            [ce.One, exp2 === -1 ? args[0] : args[0].pow(-exp2)],
            options,
            metadata
          );
        }
        const r = args[1].re;
        if (!exclusions.includes("Sqrt") && r === 0.5)
          return serializeJsonFunction(ce, "Sqrt", [args[0]], options, metadata);
        if (!exclusions.includes("Sqrt") && r === -0.5)
          return serializeJsonFunction(
            ce,
            "Divide",
            [ce.One, ce._fn("Sqrt", [args[0]])],
            options,
            metadata
          );
        if (isRational(r)) {
          const n = machineNumerator(r);
          const d = machineDenominator(r);
          if (n === 1) {
            if (!exclusions.includes("Sqrt") && d === 2)
              return serializeJsonFunction(
                ce,
                "Sqrt",
                [args[0]],
                options,
                metadata
              );
            if (!exclusions.includes("Root"))
              return serializeJsonFunction(
                ce,
                "Root",
                [args[0], ce.number(r[1])],
                options,
                metadata
              );
          }
          if (n === -1) {
            if (!exclusions.includes("Sqrt") && d === 2)
              return serializeJsonFunction(
                ce,
                "Divide",
                [ce.One, ce._fn("Sqrt", [args[0]])],
                options,
                metadata
              );
            if (!exclusions.includes("Root"))
              return serializeJsonFunction(
                ce,
                "Divide",
                [ce.One, ce._fn("Root", [args[0], ce.number(r[1])])],
                options,
                metadata
              );
          }
        }
      }
    }
    if (name === "Add" && args.length === 2 && !exclusions.includes("Subtract")) {
      if (args[1]?.numericValue !== null) {
        const t1 = asSmallInteger(args[1]);
        if (t1 !== null && t1 < 0)
          return serializeJsonFunction(
            ce,
            "Subtract",
            [args[0], ce.number(-t1)],
            options,
            metadata
          );
      }
      if (args[1]?.operator === "Negate") {
        return serializeJsonFunction(
          ce,
          "Subtract",
          [args[0], args[1].op1],
          options,
          metadata
        );
      }
    }
    if (name === "Tuple") {
      if (args.length === 1 && !exclusions.includes("Single"))
        return serializeJsonFunction(ce, "Single", args, options, metadata);
      if (args.length === 2 && !exclusions.includes("Pair"))
        return serializeJsonFunction(ce, "Pair", args, options, metadata);
      if (args.length === 3 && !exclusions.includes("Triple"))
        return serializeJsonFunction(ce, "Triple", args, options, metadata);
    }
    return serializeJsonFunction(ce, name, args, options, metadata);
  }
  function serializeJsonFunction(ce, name, args, options, metadata) {
    const exclusions = options.exclude;
    if (name === "Negate" && args.length === 1) {
      const num0 = args[0]?.numericValue;
      if (num0 !== null) {
        if (typeof num0 === "number")
          return serializeJsonNumber(ce, -num0, options);
        if (num0 instanceof Decimal)
          return serializeJsonNumber(ce, num0.neg(), options);
        if (num0 instanceof Complex)
          return serializeJsonNumber(ce, num0.neg(), options);
        if (isRational(num0)) return serializeJsonNumber(ce, neg(num0), options);
      }
    }
    if (typeof name === "string" && exclusions.includes(name)) {
      if (name === "Rational" && args.length === 2)
        return serializeJsonFunction(ce, "Divide", args, options, metadata);
      if (name === "Complex" && args.length === 2)
        return serializeJsonFunction(
          ce,
          "Add",
          [
            args[0],
            ce._fn("Multiply", [args[1] ?? ce.symbol("Undefined"), ce.I])
          ],
          options,
          metadata
        );
      if (name === "Sqrt" && args.length === 1)
        return serializeJsonFunction(
          ce,
          "Power",
          [args[0], exclusions.includes("Half") ? ce.number([1, 2]) : ce.Half],
          options,
          metadata
        );
      if (name === "Root" && args.length === 2 && args[1]?.numericValue !== null) {
        const n = asSmallInteger(args[1]);
        if (n === 2) return serializeJsonFunction(ce, "Sqrt", [args[0]], options);
        if (n !== null) {
          if (n < 0)
            return serializeJsonFunction(
              ce,
              "Divide",
              [
                ce.One,
                ce._fn("Power", [
                  args[0] ?? ce.symbol("Undefined"),
                  ce.number([1, -n])
                ])
              ],
              options,
              metadata
            );
          return serializeJsonFunction(
            ce,
            "Power",
            [args[0], ce.number([1, -n])],
            options,
            metadata
          );
        }
      }
      if (name === "Square" && args.length === 1)
        return serializeJsonFunction(
          ce,
          "Power",
          [args[0], ce.number(2)],
          options,
          metadata
        );
      if (name === "Exp" && args.length === 1)
        return serializeJsonFunction(
          ce,
          "Power",
          [ce.E, args[0]],
          options,
          metadata
        );
      if (name === "Pair" || name == "Single" || name === "Triple")
        return serializeJsonFunction(ce, "Tuple", args, options, metadata);
      if (name === "Subtract" && args.length === 2)
        return serializeJsonFunction(
          ce,
          "Add",
          [args[0], ce._fn("Negate", [args[1] ?? ce.symbol("Undefined")])],
          options,
          metadata
        );
      if (name === "Subtract" && args.length === 1)
        return serializeJsonFunction(ce, "Negate", args, options, metadata);
    }
    const jsonHead = _escapeJsonString(name);
    const fn = [
      jsonHead,
      ...args.map((x) => x ? serializeJson(ce, x, options) : "Undefined")
    ];
    const md = { ...metadata ?? {} };
    if (options.metadata.includes("latex")) {
      md.latex = _escapeJsonString(
        md.latex ?? ce.box({ fn }).latex
      );
    } else md.latex = "";
    if (!options.metadata.includes("wikidata")) md.wikidata = "";
    if (!md.latex && !md.wikidata && options.shorthands.includes("function"))
      return fn;
    if (md.latex && md.wikidata)
      return { fn, latex: md.latex, wikidata: md.wikidata };
    if (md.latex) return { fn, latex: md.latex };
    if (md.wikidata) return { fn, wikidata: md.wikidata };
    return { fn };
  }
  function serializeJsonString(s, options) {
    s = _escapeJsonString(s);
    if (options.shorthands.includes("string")) return `'${s}'`;
    return { str: s };
  }
  function serializeJsonSymbol(ce, sym, options, metadata) {
    if (sym === "Half" && options.exclude.includes("Half")) {
      return serializeJsonNumber(ce, [1, 2], options, metadata);
    }
    metadata = { ...metadata };
    if (options.metadata.includes("latex")) {
      metadata.latex = metadata.latex ?? ce.box({ sym }).latex;
      if (metadata.latex !== void 0)
        metadata.latex = _escapeJsonString(metadata.latex);
    } else metadata.latex = void 0;
    if (options.metadata.includes("wikidata")) {
      if (metadata.wikidata === void 0) {
        const wikidata = ce.lookupSymbol(sym)?.wikidata;
        if (wikidata !== void 0)
          metadata.wikidata = _escapeJsonString(wikidata);
      }
    } else metadata.wikidata = void 0;
    sym = _escapeJsonString(sym);
    if (metadata.latex === void 0 && metadata.wikidata === void 0 && options.shorthands.includes("symbol"))
      return sym;
    if (metadata.latex !== void 0 && metadata.wikidata !== void 0)
      return { sym, latex: metadata.latex, wikidata: metadata.wikidata };
    if (metadata.latex !== void 0) return { sym, latex: metadata.latex };
    if (metadata.wikidata !== void 0)
      return { sym, wikidata: metadata.wikidata };
    return { sym };
  }
  function serializeRepeatingDecimals(s, options) {
    if (!options.repeatingDecimal) return s;
    let [_, wholepart, fractionalPart, exponent] = s.match(/^(.*)\.([0-9]+)([e|E][-+]?[0-9]+)?$/) ?? [];
    if (!fractionalPart) return s.toLowerCase();
    const lastDigit = fractionalPart[fractionalPart.length - 1];
    fractionalPart = fractionalPart.slice(0, -1);
    const MAX_REPEATING_PATTERN_LENGTH = 16;
    let prefix = "";
    for (let i = 0; i < fractionalPart.length - MAX_REPEATING_PATTERN_LENGTH; i++) {
      prefix = fractionalPart.substring(0, i);
      for (let j = 0; j <= MAX_REPEATING_PATTERN_LENGTH; j++) {
        const repetend = fractionalPart.substring(i, i + j + 1);
        const times = Math.floor(
          (fractionalPart.length - prefix.length) / repetend.length
        );
        if (times < 3) break;
        if ((prefix + repetend.repeat(times + 1)).startsWith(fractionalPart)) {
          if (repetend === "0") {
            if (lastDigit === "0")
              return wholepart + "." + prefix + (exponent ?? "");
            return s;
          }
          return wholepart + "." + prefix + "(" + repetend + ")" + (exponent ?? "");
        }
      }
    }
    fractionalPart += lastDigit;
    while (fractionalPart.endsWith("0"))
      fractionalPart = fractionalPart.slice(0, -1);
    if (typeof options.fractionalDigits === "number") {
      fractionalPart = fractionalPart.slice(0, options.fractionalDigits);
    }
    if (exponent)
      return `${wholepart}.${fractionalPart}${exponent.toLowerCase()}`;
    return `${wholepart}.${fractionalPart}`;
  }
  function serializeJsonNumber(ce, value, options, metadata) {
    metadata = { ...metadata };
    if (!options.metadata.includes("latex")) metadata.latex = void 0;
    const shorthandAllowed = metadata.latex === void 0 && metadata.wikidata === void 0 && !options.metadata.includes("latex") && options.shorthands.includes("number");
    const exclusions = options.exclude;
    if (value instanceof NumericValue) {
      if (value.isNaN) return serializeJsonSymbol(ce, "NaN", options, metadata);
      if (value.isPositiveInfinity)
        return serializeJsonSymbol(ce, "PositiveInfinity", options, metadata);
      if (value.isNegativeInfinity)
        return serializeJsonSymbol(ce, "NegativeInfinity", options, metadata);
      if (value.isComplexInfinity)
        return serializeJsonSymbol(ce, "ComplexInfinity", options, metadata);
      if (shorthandAllowed) {
        if (value.isZero) return 0;
        if (value.isOne) return 1;
        if (value.isNegativeOne) return -1;
      }
      if (value instanceof ExactNumericValue) {
        console.assert(value.im === 0);
        const rationalExpr = (r) => {
          if (isInteger(r))
            return serializeJsonNumber(ce, value.rational[0], options);
          return [
            "Rational",
            serializeJsonNumber(ce, value.rational[0], options),
            serializeJsonNumber(ce, value.rational[1], options)
          ];
        };
        if (value.radical === 1) return rationalExpr(value.rational);
        if (isOne(value.rational)) return ["Sqrt", value.radical];
        if (isNegativeOne(value.rational))
          return ["Negate", ["Sqrt", value.radical]];
        if (value.rational[0] == 1)
          return [
            "Divide",
            ["Sqrt", value.radical],
            serializeJsonNumber(ce, value.rational[1], options)
          ];
        if (value.rational[0] == -1)
          return [
            "Negate",
            [
              "Divide",
              ["Sqrt", value.radical],
              serializeJsonNumber(ce, value.rational[1], options)
            ]
          ];
        return [
          "Multiply",
          rationalExpr(value.rational),
          ["Sqrt", value.radical]
        ];
      }
      if (value.im === 0) {
        const re = value.bignumRe ?? value.re;
        return serializeJsonNumber(ce, re, options, metadata);
      }
      if (!Number.isFinite(value.im))
        return serializeJsonSymbol(ce, "ComplexInfinity", options, metadata);
      return serializeJsonFunction(
        ce,
        "Complex",
        [ce.number(value.bignumRe ?? value.re), ce.number(value.im)],
        options,
        {
          ...metadata,
          wikidata: "Q11567"
        }
      );
    }
    let num = "";
    if (value instanceof Decimal) {
      let result2;
      if (value.isNaN()) result2 = "NaN";
      else if (!value.isFinite())
        result2 = value.isPositive() ? "PositiveInfinity" : "NegativeInfinity";
      else {
        if (shorthandAllowed && isInMachineRange(value)) return value.toNumber();
        if (value.isInteger() && value.e < value.precision() + 4)
          num = value.toFixed(0);
        else {
          const precision = options.fractionalDigits;
          let s;
          if (precision === "max") s = value.toString();
          else if (precision === "auto") s = value.toPrecision(ce.precision);
          else s = value.toDecimalPlaces(precision).toString();
          num = serializeRepeatingDecimals(s, options);
          if (shorthandAllowed) {
            const val = value.toNumber();
            if (val.toString() === num) return val;
          }
        }
      }
      if (options.metadata.includes("latex"))
        metadata.latex = metadata.latex ?? ce.box(result2 ?? { num }).latex;
      if (result2) {
        if (metadata.latex !== void 0)
          return { sym: result2, latex: metadata.latex };
        if (shorthandAllowed) return result2;
        return { sym: result2 };
      }
      if (metadata.latex !== void 0) return { num, latex: metadata.latex };
      return shorthandAllowed ? num : { num };
    }
    if (value instanceof Complex) {
      if (value.isInfinite())
        return serializeJsonSymbol(ce, "ComplexInfinity", options, metadata);
      if (value.isNaN()) {
        num = "NaN";
        if (options.metadata.includes("latex"))
          metadata.latex = metadata.latex ?? ce.box({ num }).latex;
        return metadata.latex !== void 0 ? { num, latex: metadata.latex } : { num };
      }
      return serializeJsonFunction(
        ce,
        "Complex",
        [ce.number(value.re), ce.number(value.im)],
        options,
        {
          ...metadata,
          wikidata: "Q11567"
        }
      );
    }
    if (isRational(value)) {
      const allowRational = !exclusions.includes("Rational");
      if (shorthandAllowed && options.shorthands.includes("function") && isMachineRational(value)) {
        if (value[0] === 1 && value[1] === 2 && !exclusions.includes("Half"))
          return serializeJsonSymbol(ce, "Half", options, metadata);
        return [allowRational ? "Rational" : "Divide", value[0], value[1]];
      }
      return serializeJsonFunction(
        ce,
        allowRational ? "Rational" : "Divide",
        [ce.number(value[0]), ce.number(value[1])],
        options,
        { ...metadata }
      );
    }
    if (typeof value === "bigint") {
      if (value >= Number.MIN_SAFE_INTEGER && value <= Number.MAX_SAFE_INTEGER) {
        value = Number(value);
      } else {
        if (options.metadata.includes("latex"))
          metadata.latex = metadata.latex ?? ce.box({ num: value.toString() }).latex;
        if (metadata.latex !== void 0)
          return { num: value.toString(), latex: metadata.latex };
        return shorthandAllowed ? numberToExpression(value, options.fractionalDigits) : { num: numberToString(value, options.fractionalDigits) };
      }
    }
    let result;
    if (Number.isNaN(value)) result = "NaN";
    else if (!Number.isFinite(value))
      result = value > 0 ? "PositiveInfinity" : "NegativeInfinity";
    else num = serializeRepeatingDecimals(value.toString(), options);
    if (options.metadata.includes("latex"))
      metadata.latex = metadata.latex ?? ce.box({ num }).latex;
    if (result) {
      if (metadata.latex !== void 0)
        return { sym: result, latex: metadata.latex };
      return shorthandAllowed ? result : { sym: result };
    }
    if (metadata.latex !== void 0) return { num, latex: metadata.latex };
    if (shorthandAllowed && num === value.toString()) return value;
    return { num };
  }
  function serializeJson(ce, expr, options) {
    const wikidata = expr.scope ? expr.wikidata : void 0;
    if (expr.numericValue !== null)
      return serializeJsonNumber(ce, expr.numericValue, options, {
        latex: expr.verbatimLatex
      });
    if (expr.rank > 0) return expr.json;
    if (expr.string !== null) return serializeJsonString(expr.string, options);
    if (expr.symbol !== null) {
      return serializeJsonSymbol(ce, expr.symbol, options, {
        latex: expr.verbatimLatex,
        wikidata
      });
    }
    if (expr.ops) {
      if (expr.isValid && (expr.isCanonical || expr.isStructural) && options.prettify)
        return serializePrettyJsonFunction(
          ce,
          expr.operator,
          expr.structural.ops,
          options,
          {
            latex: expr.verbatimLatex,
            wikidata
          }
        );
      return serializeJsonFunction(
        ce,
        expr.operator,
        expr.structural.ops,
        options,
        {
          latex: expr.verbatimLatex,
          wikidata
        }
      );
    }
    return expr.json;
  }

  // src/compute-engine/numerics/monte-carlo.ts
  function monteCarloEstimate(f, a, b, n = 1e5) {
    let sum2 = 0;
    if (a === -Infinity && b === Infinity) {
      for (let i = 0; i < n; i++) {
        const u = Math.random();
        const x = Math.tan(Math.PI * (u - 0.5));
        const jacobian = Math.PI * (1 + x * x);
        sum2 += f(x) / jacobian;
      }
    } else if (a === -Infinity) {
      for (let i = 0; i < n; i++) {
        const u = Math.random();
        const x = b - Math.log(1 - u);
        const jacobian = 1 / (1 - u);
        sum2 += f(x) / jacobian;
      }
    } else if (b === Infinity) {
      for (let i = 0; i < n; i++) {
        const u = Math.random();
        const x = a + Math.log(u);
        const jacobian = 1 / u;
        sum2 += f(x) / jacobian;
      }
    } else {
      for (let i = 0; i < n; i++) sum2 += f(a + Math.random() * (b - a));
    }
    return sum2 / n * (b - a);
  }

  // src/compute-engine/numerics/statistics.ts
  function mean(values) {
    let sum2 = 0;
    let count = 0;
    for (const op of values) {
      sum2 += op;
      count++;
    }
    if (count === 0) return NaN;
    return sum2 / count;
  }
  function bigMean(bignum, values) {
    let sum2 = bignum(0);
    let count = 0;
    for (const op of values) {
      sum2 = sum2.add(op);
      count++;
    }
    if (count === 0) return bignum(NaN);
    return sum2.div(count);
  }
  function median(values) {
    const sorted = [...values].sort((a, b) => a - b);
    const mid = Math.floor(sorted.length / 2);
    if (sorted.length % 2 === 0) return (sorted[mid - 1] + sorted[mid]) / 2;
    return sorted[mid];
  }
  function bigMedian(values) {
    const sorted = [...values].sort((a, b) => a.cmp(b));
    const mid = Math.floor(sorted.length / 2);
    if (sorted.length % 2 === 0) return sorted[mid - 1].add(sorted[mid]).div(2);
    return sorted[mid];
  }
  function variance(values) {
    let sum2 = 0;
    let sum22 = 0;
    let count = 0;
    for (const op of values) {
      sum2 += op;
      sum22 += op * op;
      count++;
    }
    if (count === 0) return NaN;
    return (sum22 - sum2 * sum2 / count) / (count - 1);
  }
  function bigVariance(bignum, values) {
    let sum2 = bignum(0);
    let sum22 = bignum(0);
    let count = 0;
    for (const op of values) {
      sum2 = sum2.add(op);
      sum22 = sum22.add(op.mul(op));
      count++;
    }
    if (count === 0) return bignum(NaN);
    return sum22.sub(sum2.mul(sum2).div(count)).div(count - 1);
  }
  function populationVariance(values) {
    let sum2 = 0;
    let sum22 = 0;
    let count = 0;
    for (const op of values) {
      sum2 += op;
      sum22 += op * op;
      count++;
    }
    if (count === 0) return NaN;
    return (sum22 - sum2 * sum2 / count) / count;
  }
  function bigPopulationVariance(bignum, values) {
    let sum2 = bignum(0);
    let sum22 = bignum(0);
    let count = 0;
    for (const op of values) {
      sum2 = sum2.add(op);
      sum22 = sum22.add(op.mul(op));
      count++;
    }
    if (count === 0) return bignum(NaN);
    return sum22.sub(sum2.mul(sum2).div(count)).div(count);
  }
  function standardDeviation(values) {
    return Math.sqrt(variance(values));
  }
  function populationStandardDeviation(values) {
    return Math.sqrt(populationVariance(values));
  }
  function kurtosis(values) {
    let sum2 = 0;
    let sum22 = 0;
    let sum4 = 0;
    let count = 0;
    for (const op of values) {
      const v = op;
      if (!Number.isFinite(v)) return NaN;
      sum2 += v;
      sum22 += v * v;
      sum4 += v * v * v * v;
      count++;
    }
    if (count === 0) return NaN;
    const s2 = (sum22 - sum2 * sum2 / count) / (count - 1);
    return (sum4 - 4 * sum2 * sum22 / count + 6 * sum2 * sum2 * sum2 / count / count - 3 * sum2 * sum2 * sum2 * sum2 / count / count / count) / (s2 * s2);
  }
  function bigKurtosis(bignum, values) {
    let sum2 = bignum(0);
    let sum22 = bignum(0);
    let sum4 = bignum(0);
    let count = 0;
    for (const op of values) {
      const v = op;
      if (!v.isFinite()) return bignum(NaN);
      sum2 = sum2.add(v);
      sum22 = sum22.add(v.mul(v));
      sum4 = sum4.add(v.mul(v).mul(v).mul(v));
      count++;
    }
    if (count === 0) return bignum(NaN);
    const s2 = sum22.sub(sum2.mul(sum2).div(count)).div(count - 1);
    return sum4.sub(sum2.mul(sum22).mul(4).div(count)).add(sum2.mul(sum2).mul(sum2).mul(6).div(count).div(count)).sub(sum2.mul(sum2).mul(sum2).mul(sum2).div(count).div(count).div(count)).div(s2.mul(s2));
  }
  function skewness(values) {
    let sum2 = 0;
    let sum22 = 0;
    let sum3 = 0;
    let count = 0;
    for (const op of values) {
      const v = op;
      if (!Number.isFinite(v)) return NaN;
      sum2 += v;
      sum22 += v * v;
      sum3 += v * v * v;
      count++;
    }
    if (count === 0) return NaN;
    const s2 = (sum22 - sum2 * sum2 / count) / (count - 1);
    const s3 = (sum3 - sum22 * sum2 / count) / (count - 1);
    return s3 / Math.pow(s2, 3 / 2) * Math.sqrt(count * 1);
  }
  function bigSkewness(bignum, values) {
    let sum2 = bignum(0);
    let sum22 = bignum(0);
    let sum3 = bignum(0);
    let count = 0;
    for (const op of values) {
      const v = op;
      if (!v.isFinite()) return bignum(NaN);
      sum2 = sum2.add(v);
      sum22 = sum22.add(v.mul(v));
      sum3 = sum3.add(v.mul(v).mul(v));
      count++;
    }
    if (count === 0) return bignum(NaN);
    const s2 = sum22.sub(sum2.mul(sum2).div(count)).div(count - 1);
    const s3 = sum3.sub(sum22.mul(sum2).div(count)).div(count - 1);
    return s3.div(s2.pow(3 / 2)).mul(count).sqrt();
  }
  function mode(values) {
    const counts = {};
    for (const v of values) {
      counts[v] = (counts[v] ?? 0) + 1;
    }
    let max2 = 0;
    let mode2 = NaN;
    for (const v in counts) {
      const c = counts[v];
      if (c > max2) {
        max2 = c;
        mode2 = +v;
      }
    }
    return mode2;
  }
  function bigMode(bignum, values) {
    const counts = {};
    for (const v of values) {
      counts[v.toString()] = (counts[v.toString()] ?? 0) + 1;
    }
    let max2 = 0;
    let mode2 = bignum(NaN);
    for (const v in counts) {
      const c = counts[v];
      if (c > max2) {
        max2 = c;
        mode2 = bignum(v);
      }
    }
    return mode2;
  }
  function quartiles(values) {
    const sorted = [...values].sort((a, b) => a - b);
    const mid = Math.floor(sorted.length / 2);
    const q1 = median(sorted.slice(0, mid));
    const q2 = median(sorted);
    const q3 = median(sorted.slice(mid));
    return [q1, q2, q3];
  }
  function bigQuartiles(values) {
    const sorted = [...values].sort((a, b) => a.cmp(b));
    const mid = Math.floor(sorted.length / 2);
    const q1 = bigMedian(sorted.slice(0, mid));
    const q2 = bigMedian(sorted);
    const q3 = bigMedian(sorted.slice(mid));
    return [q1, q2, q3];
  }
  function interquartileRange(values) {
    const sorted = [...values].sort((a, b) => a - b);
    const mid = Math.floor(sorted.length / 2);
    const lower = sorted.slice(0, mid);
    const upper = sorted.slice(mid + 1);
    return median(upper) - median(lower);
  }
  function bigInterquartileRange(values) {
    const sorted = [...values].sort((a, b) => a.cmp(b));
    const mid = Math.floor(sorted.length / 2);
    const lower = sorted.slice(0, mid);
    const upper = sorted.slice(mid + 1);
    return bigMedian(upper).sub(bigMedian(lower));
  }

  // src/compute-engine/compile.ts
  var NATIVE_JS_OPERATORS = {
    Add: ["+", 11],
    Negate: ["-", 14],
    // Unary operator
    Subtract: ["-", 11],
    Multiply: ["*", 12],
    Divide: ["/", 13],
    Equal: ["===", 8],
    NotEqual: ["!==", 8],
    LessEqual: ["<=", 9],
    GreaterEqual: [">=", 9],
    Less: ["<", 9],
    Greater: [">", 9],
    And: ["&&", 4],
    Or: ["||", 3],
    Not: ["!", 14]
    // Unary operator
    // Xor: ['^', 6], // That's bitwise XOR, not logical XOR
    // Possible solution is to use `a ? !b : b` instead of `a ^ b`
  };
  var NATIVE_JS_FUNCTIONS = {
    Abs: "Math.abs",
    Add: (args, compile2) => {
      if (args.length === 1) return compile2(args[0]);
      return `(${args.map((x) => compile2(x)).join(" + ")})`;
    },
    Arccos: "Math.acos",
    Arccosh: "Math.acosh",
    Arccot: ([x], compile2) => {
      if (x === null) throw new Error("Arccot: no argument");
      return `Math.atan(1 / (${compile2(x)}))`;
    },
    Arccoth: ([x], compile2) => {
      if (x === null) throw new Error("Arccoth: no argument");
      return `Math.atanh(1 / (${compile2(x)}))`;
    },
    Arccsc: ([x], compile2) => {
      if (x === null) throw new Error("Arccsc: no argument");
      return `Math.asin(1 / (${compile2(x)}))`;
    },
    Arccsch: ([x], compile2) => {
      if (x === null) throw new Error("Arccsch: no argument");
      return `Math.asinh(1 / (${compile2(x)}))`;
    },
    Arcsec: ([x], compile2) => {
      if (x === null) throw new Error("Arcsec: no argument");
      return `Math.acos(1 / (${compile2(x)}))`;
    },
    Arcsech: ([x], compile2) => {
      if (x === null) throw new Error("Arcsech: no argument");
      return `Math.acosh(1 / (${compile2(x)}))`;
    },
    Arcsin: "Math.asin",
    Arcsinh: "Math.asinh",
    Arctan: "Math.atan",
    Arctanh: "Math.atanh",
    // Math.cbrt
    Ceiling: "Math.ceil",
    Chop: "_SYS.chop",
    Cos: "Math.cos",
    Cosh: "Math.cosh",
    Cot: ([x], compile2) => {
      if (x === null) throw new Error("Cot: no argument");
      return inlineExpression("Math.cos(${x}) / Math.sin(${x})", compile2(x));
    },
    Coth: ([x], compile2) => {
      if (x === null) throw new Error("Coth: no argument");
      return inlineExpression("(Math.cosh(${x}) / Math.sinh(${x}))", compile2(x));
    },
    Csc: ([x], compile2) => {
      if (x === null) throw new Error("Csc: no argument");
      return `1 / Math.sin(${compile2(x)})`;
    },
    Csch: ([x], compile2) => {
      if (x === null) throw new Error("Csch: no argument");
      return `1 / Math.sinh(${compile2(x)})`;
    },
    Exp: "Math.exp",
    Floor: "Math.floor",
    Gamma: "_SYS.gamma",
    GCD: "_SYS.gcd",
    // Math.hypot
    Integrate: (args, compile2, target) => compileIntegrate(args, compile2, target),
    LCM: "_SYS.lcm",
    Limit: (args, compile2) => `_SYS.limit(${compile2(args[0])}, ${compile2(args[1])})`,
    Ln: "Math.log",
    List: (args, compile2) => `[${args.map((x) => compile2(x)).join(", ")}]`,
    Log: (args, compile2) => {
      if (args.length === 1) return `Math.log10(${compile2(args[0])})`;
      return `(Math.log(${compile2(args[0])}) / Math.log(${compile2(args[1])}))`;
    },
    LogGamma: "_SYS.lngamma",
    Lb: "Math.log2",
    Max: "Math.max",
    Mean: (args, compile2) => {
      if (args.length === 0) return "NaN";
      if (args.length === 1) return `_SYS.mean(${compile2(args[0])})`;
      return `_SYS.mean([${args.map((x) => compile2(x)).join(", ")}])`;
    },
    Median: (args, compile2) => {
      if (args.length === 0) return "NaN";
      if (args.length === 1) return `_SYS.median(${compile2(args[0])})`;
      return `_SYS.median([${args.map((x) => compile2(x)).join(", ")}])`;
    },
    Variance: (args, compile2) => {
      if (args.length === 0) return "NaN";
      if (args.length === 1) return `_SYS.variance(${compile2(args[0])})`;
      return `_SYS.variance([${args.map((x) => compile2(x)).join(", ")}])`;
    },
    PopulationVariance: (args, compile2) => {
      if (args.length === 0) return "NaN";
      if (args.length === 1)
        return `_SYS.populationVariance(${compile2(args[0])})`;
      return `_SYS.populationVariance([${args.map((x) => compile2(x)).join(", ")}])`;
    },
    StandardDeviation: (args, compile2) => {
      if (args.length === 0) return "NaN";
      if (args.length === 1) return `_SYS.standardDeviation(${compile2(args[0])})`;
      return `_SYS.standardDeviation([${args.map((x) => compile2(x)).join(", ")}])`;
    },
    PopulationStandardDeviation: (args, compile2) => {
      if (args.length === 0) return "NaN";
      if (args.length === 1)
        return `_SYS.populationStandardDeviation(${compile2(args[0])})`;
      return `_SYS.populationStandardDeviation([${args.map((x) => compile2(x)).join(", ")}])`;
    },
    Kurtosis: (args, compile2) => {
      if (args.length === 0) return "NaN";
      if (args.length === 1) return `_SYS.kurtosis(${compile2(args[0])})`;
      return `_SYS.kurtosis([${args.map((x) => compile2(x)).join(", ")}])`;
    },
    Skewness: (args, compile2) => {
      if (args.length === 0) return "NaN";
      if (args.length === 1) return `_SYS.skewness(${compile2(args[0])})`;
      return `_SYS.skewness([${args.map((x) => compile2(x)).join(", ")}])`;
    },
    Mode: (args, compile2) => {
      if (args.length === 0) return "NaN";
      if (args.length === 1) return `_SYS.mode(${compile2(args[0])})`;
      return `_SYS.mode([${args.map((x) => compile2(x)).join(", ")}])`;
    },
    Quartiles: (args, compile2) => {
      if (args.length === 0) return "NaN";
      if (args.length === 1) return `_SYS.quartiles(${compile2(args[0])})`;
      return `_SYS.quartiles([${args.map((x) => compile2(x)).join(", ")}])`;
    },
    InterquartileRange: (args, compile2) => {
      if (args.length === 0) return "NaN";
      if (args.length === 1)
        return `_SYS.interquartileRange(${compile2(args[0])})`;
      return `_SYS.interquartileRange([${args.map((x) => compile2(x)).join(", ")}])`;
    },
    Min: "Math.min",
    Power: (args, compile2) => {
      const arg = args[0];
      if (arg === null) throw new Error("Power: no argument");
      const exp2 = args[1].re;
      if (exp2 === 0.5) return `Math.sqrt(${compile2(arg)})`;
      if (exp2 === 1 / 3) return `Math.cbrt(${compile2(arg)})`;
      if (exp2 === 1) return compile2(arg);
      if (exp2 === -1) return `(1 / (${compile2(arg)}))`;
      if (exp2 === -0.5) return `(1 / Math.sqrt(${compile2(arg)}))`;
      return `Math.pow(${compile2(arg)}, ${compile2(args[1])})`;
    },
    Range: (args, compile2) => {
      if (args.length === 0) return "[]";
      if (args.length === 1)
        return `Array.from({length: ${compile2(args[0])}}, (_, i) => i)`;
      let start = compile2(args[0]);
      let stop = compile2(args[1]);
      const step = args[2] ? compile2(args[2]) : "1";
      if (start === null) throw new Error("Range: no start");
      if (stop === null) {
        stop = start;
        start = "1";
      }
      if (step === "0") throw new Error("Range: step cannot be zero");
      if (parseFloat(step) === 1) {
        const fStop = parseFloat(stop);
        const fStart = parseFloat(start);
        if (fStop !== null && fStart !== null) {
          if (fStop - fStart < 50) {
            return `[${Array.from(
              { length: fStop - fStart + 1 },
              (_, i) => fStart + i
            ).join(", ")}]`;
          }
          return `Array.from({length: ${fStop - fStart + 1} 
        }, (_, i) => ${start} + i)`;
        }
        return `Array.from({length: ${stop} - ${start} + 1
      }, (_, i) => ${start} + i)`;
      }
      return `Array.from({length: Math.floor((${stop} - ${start}) / ${step}) + 1}, (_, i) => ${start} + i * ${step})`;
    },
    Root: ([arg, exp2], compile2) => {
      if (arg === null) throw new Error("Root: no argument");
      if (exp2 === null) return `Math.sqrt(${compile2(arg)})`;
      if (exp2?.re === 2) return `Math.sqrt(${compile2(arg)})`;
      if (exp2?.re === 3) return `Math.cbrt(${compile2(arg)})`;
      if (!isNaN(exp2?.re)) return `Math.pow(${compile2(arg)},  ${1 / exp2.re})`;
      return `Math.pow(${compile2(arg)}, 1 / (${compile2(exp2)}))`;
    },
    Random: "Math.random",
    Round: "Math.round",
    Square: (args, compile2) => {
      const arg = args[0];
      if (arg === null) throw new Error("Square: no argument");
      return `Math.pow(${compile2(arg)}, 2)`;
    },
    Sec: (args, compile2) => {
      const arg = args[0];
      if (arg === null) throw new Error("Sec: no argument");
      return `1 / Math.cos(${compile2(arg)})`;
    },
    Sech: (args, compile2) => {
      const arg = args[0];
      if (arg === null) throw new Error("Sech: no argument");
      return `1 / Math.cosh(${compile2(arg)})`;
    },
    Sgn: "Math.sign",
    Sin: "Math.sin",
    Sinh: "Math.sinh",
    Sqrt: "Math.sqrt",
    Tan: "Math.tan",
    Tanh: "Math.tanh"
    // Factorial: 'factorial',    // TODO: implement
    // Hallucinated by Copilot, but interesting ideas...
    // Gamma: 'Math.gamma',
    // Erf: 'Math.erf',
    // Erfc: 'Math.erfc',
    // Erfi: 'Math.erfi',
    // Zeta: 'Math.zeta',
    // PolyGamma: 'Math.polygamma',
    // HurwitzZeta: 'Math.hurwitzZeta', $$\zeta (s,a)=\sum _{n=0}^{\infty }{\frac {1}{(n+a)^{s}}}$$
    // DirichletEta: 'Math.dirichletEta',
    // Beta: 'Math.beta',
    // Binomial: 'Math.binomial',
    // Mod: 'Math.mod',
    // Quotient: 'Math.quotient',
    // Divisors: 'Math.divisors',
    // IsPrime: 'Math.isPrime',
    // PrimePi: 'Math.primePi',
    // Prime: 'Math.prime',
    // NextPrime: 'Math.nextPrime',
    // PreviousPrime: 'Math.prevPrime',
    // PrimePowerQ: 'Math.isPrimePower',
    // PrimePowerPi: 'Math.primePowerPi',
    // PrimePower: 'Math.primePower',
    // NextPrimePower: 'Math.nextPrimePower',
    // PreviousPrimePower: 'Math.prevPrimePower',
    // PrimeFactors: 'Math.primeFactors',
    // DivisorSigma: 'Math.divisorSigma',
    // DivisorCount: 'Math.divisorCount',
    // DivisorSum: 'Math.divisorSum',
    // MoebiusMu: 'Math.moebiusMu',
    // LiouvilleLambda: 'Math.liouvilleLambda',
    // CarmichaelLambda: 'Math.carmichaelLambda',
    // EulerPhi: 'Math.eulerPhi',
    // EulerPsi: 'Math.eulerPsi',
    // EulerGamma: 'Math.eulerGamma',
    // HarmonicNumber: 'Math.harmonicNumber',
    // BernoulliB: 'Math.bernoulliB',
    // StirlingS1: 'Math.stirlingS1',
    // StirlingS2: 'Math.stirlingS2',
    // BellB: 'Math.bellB',
    // BellNumber: 'Math.bellNumber',
    // LahS: 'Math.lahS',
    // LahL: 'Math.lahL',
  };
  var ComputeEngineFunction = class extends Function {
    constructor(body, preamble = "") {
      super("_SYS", "_", `${preamble};return ${body}`);
      this.sys = {
        chop,
        factorial,
        gamma: gamma2,
        gcd,
        integrate: (f, a, b) => monteCarloEstimate(f, a, b, 1e7),
        lcm,
        lngamma: gammaln2,
        limit,
        mean,
        median,
        variance,
        populationVariance,
        standardDeviation,
        populationStandardDeviation,
        kurtosis,
        skewness,
        mode,
        quartiles,
        interquartileRange
      };
      return new Proxy(this, {
        apply: (target, thisArg, argumentsList) => super.apply(thisArg, [this.sys, ...argumentsList]),
        get: (target, prop) => {
          if (prop === "toString") return () => body;
          return target[prop];
        }
      });
    }
  };
  function compileToTarget(expr, target) {
    const js = compile(expr, target);
    return new ComputeEngineFunction(
      js,
      target.preamble
    );
  }
  function compileToJavascript(expr, functions, vars, imports = [], preamble) {
    const unknowns = expr.unknowns;
    let preambleImports = imports.map((x) => {
      if (typeof x === "function") return x.toString();
      throw new Error(`Unsupported import \`${x}\``);
    }).join("\n");
    const namedFunctions = functions ? Object.fromEntries(
      Object.entries(functions).filter((k, v) => typeof v !== "string")
    ) : {};
    if (functions)
      for (const [k, v] of Object.entries(functions)) {
        if (typeof v === "function") {
          if (isTrulyNamed(v)) {
            preambleImports += `${v.toString()};
`;
            namedFunctions[k] = v.name;
          } else {
            preambleImports += `const ${k} = ${v.toString()};
`;
            namedFunctions[k] = k;
          }
        }
      }
    return compileToTarget(expr, {
      operators: (op) => NATIVE_JS_OPERATORS[op],
      functions: (id) => namedFunctions?.[id] ? namedFunctions[id] : NATIVE_JS_FUNCTIONS[id],
      var: (id) => {
        if (vars && id in vars) return JSON.stringify(vars[id]);
        const result = {
          Pi: "Math.PI",
          ExponentialE: "Math.E",
          NaN: "Number.NaN",
          ImaginaryUnit: "Number.NaN",
          Half: "0.5",
          MachineEpsilon: "Number.EPSILON",
          GoldenRatio: "((1 + Math.sqrt(5)) / 2)",
          CatalanConstant: "0.91596559417721901",
          EulerGamma: "0.57721566490153286"
        }[id];
        if (result !== void 0) return result;
        if (unknowns.includes(id)) return `_.${id}`;
        return void 0;
      },
      string: (str) => JSON.stringify(str),
      number: (n) => n.toString(),
      indent: 0,
      ws: (s) => s ?? "",
      preamble: (preamble ?? "") + preambleImports
    });
  }
  function compileExpr(engine, h, args, prec, target) {
    if (h === "Error") throw new Error("Error");
    if (h === "Sequence") {
      if (args.length === 0) return "";
      return `(${args.map((arg) => compile(arg, target, prec)).join(", ")})`;
    }
    if (h === "Sum" || h === "Product") return compileLoop(h, args, target);
    if (args.every((x) => !x.isCollection)) {
      const op = target.operators?.(h);
      if (isRelationalOperator(h) && args.length > 2 && op) {
        const result = [];
        for (let i = 0; i < args.length - 1; i++)
          result.push(
            compileExpr(engine, h, [args[i], args[i + 1]], op[1], target)
          );
        return `(${result.join(") && (")})`;
      }
      if (op !== void 0) {
        if (args === null) return "";
        let resultStr;
        if (args.length === 1) {
          resultStr = `${op[0]}${compile(args[0], target, op[1])}`;
        } else {
          resultStr = args.map((arg) => compile(arg, target, op[1])).join(` ${op[0]} `);
        }
        return op[1] < prec ? `(${resultStr})` : resultStr;
      }
    }
    if (h === "Function") {
      const params = args.slice(1).map((x) => x.symbol);
      return `((${params.join(", ")}) => ${compile(args[0].canonical, {
        ...target,
        var: (id) => params.includes(id) ? id : target.var(id)
      })})`;
    }
    if (h === "Declare") return `let ${args[0].symbol}`;
    if (h === "Assign") return `${args[0].symbol} = ${compile(args[1], target)}`;
    if (h === "Return") return `return ${compile(args[0], target)}`;
    if (h === "If") {
      if (args.length !== 3) throw new Error("If: wrong number of arguments");
      return `((${compile(args[0], target)}) ? (${compile(
        args[1],
        target
      )}) : (${compile(args[2], target)}))`;
    }
    if (h === "Block") {
      const locals = [];
      for (const arg of args) {
        if (arg.operator === "Declare") locals.push(arg.ops[0].symbol);
      }
      if (args.length === 1 && locals.length === 0)
        return compile(args[0], target);
      const result = args.map(
        (arg) => compile(arg, {
          ...target,
          var: (id) => {
            if (locals.includes(id)) return id;
            return target.var(id);
          }
        })
      );
      result[result.length - 1] = `return ${result[result.length - 1]}`;
      return `(() => {${target.ws("\n")}${result.join(
        `;${target.ws("\n")}`
      )}${target.ws("\n")}})()`;
    }
    const fn = target.functions?.(h);
    if (!fn) throw new Error(`Unknown function \`${h}\``);
    if (typeof fn === "function") {
      const def = engine.lookupFunction(h);
      if (def?.threadable && args.length === 1 && isFiniteIndexableCollection(args[0])) {
        const v = tempVar();
        return `(${compile(args[0], target)}).map((${v}) => ${fn(
          [args[0].engine.box(v)],
          (expr) => compile(expr, target),
          target
        )})`;
      }
      return fn(args, (expr) => compile(expr, target), target);
    }
    if (args === null) return `${fn}()`;
    return `${fn}(${args.map((x) => compile(x, target)).join(", ")})`;
  }
  function compile(expr, target, prec = 0) {
    if (expr === void 0) return "";
    if (!expr.isValid) {
      throw new Error(`Cannot compile invalid expression: "${expr.toString()}"`);
    }
    const s = expr.symbol;
    if (s !== null) return target.var?.(s) ?? s;
    if (expr.isNumberLiteral) {
      if (expr.im !== 0) throw new Error("Complex numbers are not supported");
      return target.number(expr.re);
    }
    const str = expr.string;
    if (str !== null) return target.string(s);
    return compileExpr(expr.engine, expr.operator, expr.ops, prec, target);
  }
  function compileLoop(h, args, target) {
    if (args === null) throw new Error("Sum/Product: no arguments");
    if (!args[0]) throw new Error("Sum/Product: no body");
    const { index, lower, upper, isFinite: isFinite2 } = normalizeIndexingSet(args[1]);
    const op = h === "Sum" ? "+" : "*";
    if (!index) {
      const indexVar = tempVar();
      const acc2 = tempVar();
      const col = compile(args[0], target);
      return `${col}.reduce((${acc2}, ${indexVar}) => ${acc2} ${op} ${indexVar}, ${op === "+" ? "0" : "1"})`;
    }
    const fn = compile(args[0], {
      ...target,
      var: (id) => {
        if (id === index) return index;
        return target.var(id);
      }
    });
    const acc = tempVar();
    return `(() => {
  let ${acc} = ${op === "+" ? "0" : "1"};
  let ${index} = ${lower};
  while (${index} <= ${upper}) {
    ${acc} ${op}= ${fn};
    ${index}++;
  }
  return ${acc};
})()`;
  }
  function inlineExpression(body, x) {
    const isSimple = /^[\p{L}_][\p{L}\p{N}_]*$/u.test(x) || /^[0-9]+$/.test(x);
    if (isSimple) {
      return new Function("x", `return \`${body}\`;`)(x);
    } else {
      const t = tempVar();
      return new Function(
        "x",
        `return \`(() => { const ${t} = \${x}; return ${body.replace(/\\\${x}/g, t)}; })()\`;`
      )(x);
    }
  }
  function tempVar() {
    return `_${Math.random().toString(36).substring(4)}`;
  }
  function compileIntegrate(args, _, target) {
    const { index, lower, upper } = normalizeIndexingSet(args[1]);
    const f = compile(args[0], {
      ...target,
      var: (id) => id === index ? id : target.var(id)
    });
    return `_SYS.integrate((${index}) => (${f}), ${lower}, ${upper})`;
  }
  function isTrulyNamed(func) {
    const source = func.toString();
    if (source.includes("=>")) return false;
    return source.startsWith("function ") && source.includes(func.name);
  }

  // src/compute-engine/latex-syntax/serialize-number.ts
  function formatFractionalPart(digits, wholeDigitsCount, options) {
    if (options.repeatingDecimal && options.repeatingDecimal !== "none") {
      const truncatedDigits = digits.slice(0, -1);
      for (let i = 0; i < digits.length - 16; i++) {
        const offset = truncatedDigits.substring(0, i);
        for (let j = 0; j < 17; j++) {
          const cycle = truncatedDigits.substring(i, i + j + 1);
          const times = Math.floor(
            (truncatedDigits.length - offset.length) / cycle.length
          );
          if (times <= 3) break;
          if ((offset + cycle.repeat(times + 1)).startsWith(truncatedDigits)) {
            if (cycle === "0") {
              return insertFractionalGroupSeparator(offset, options);
            }
            let pattern = {
              vinculum: "\\overline{#}",
              parentheses: "(#)",
              dots: "\\overset{\\cdots}{#1}#2\\overset{\\cdots}{#3}",
              arc: "\\wideparen{#}"
            }[options.repeatingDecimal] ?? "\\overline{#}";
            pattern = pattern.replace(/#1/g, cycle[0]).replace(/#2/g, cycle.slice(1)).replace(/#3/g, cycle.slice(-1)).replace(/#/, cycle);
            return insertFractionalGroupSeparator(offset, options) + pattern;
          }
        }
      }
    }
    let maxFractionalDigits = typeof options.fractionalDigits === "number" ? options.fractionalDigits : Infinity;
    if (maxFractionalDigits < 0)
      maxFractionalDigits = maxFractionalDigits - wholeDigitsCount;
    if (maxFractionalDigits < 0) maxFractionalDigits = 0;
    const extraDigits = digits.length > maxFractionalDigits;
    if (extraDigits) digits = digits.substring(0, maxFractionalDigits);
    digits = insertFractionalGroupSeparator(digits, options);
    if (extraDigits) digits += options.truncationMarker;
    return digits;
  }
  function formatExponent(exp2, options) {
    if (!exp2 || exp2 === "0") return "";
    if (options.beginExponentMarker) {
      return options.beginExponentMarker + exp2 + (options.endExponentMarker ?? "");
    }
    return `10^{${exp2}}`;
  }
  function serializeNumber(expr, options) {
    if (expr === null) return "";
    let num;
    if (typeof expr === "number" || typeof expr === "string") {
      num = expr;
    } else if (typeof expr === "object" && "num" in expr) {
      num = expr.num;
    } else return "";
    if (typeof num === "number") {
      if (num === Infinity) return options.positiveInfinity;
      else if (num === -Infinity) return options.negativeInfinity;
      else if (Number.isNaN(num)) return options.notANumber;
      let result2 = void 0;
      if (options.notation === "engineering")
        result2 = serializeScientificNotationNumber(
          num.toExponential(),
          options,
          3
        );
      else if (options.notation === "scientific")
        result2 = serializeScientificNotationNumber(num.toExponential(), options);
      return result2 ?? serializeAutoNotationNumber(num.toString(), options);
    }
    num = num.toLowerCase().replace(/[\u0009-\u000d\u0020\u00a0]/g, "");
    if (num === "infinity" || num === "+infinity")
      return options.positiveInfinity;
    else if (num === "-infinity") return options.negativeInfinity;
    else if (num === "nan") return options.notANumber;
    if (!/^[-+\.]?[0-9]/.test(num)) return "";
    num = num.replace(/[nd]$/, "");
    if (/\([0-9]+\)/.test(num)) {
      const [_, body, repeat2, trail] = num.match(/(.+)\(([0-9]+)\)(.*)$/) ?? [];
      num = body + repeat2.repeat(6) + trail;
    }
    let sign2 = "";
    if (num[0] === "-") {
      sign2 = "-";
      num = num.substring(1);
    } else if (num[0] === "+") {
      num = num.substring(1);
    }
    while (num[0] === "0") num = num.substring(1);
    if (num.length === 0) num = "0";
    else if (num[0] === ".") num = "0" + num;
    let result = void 0;
    if (options.notation === "engineering")
      result = serializeScientificNotationNumber(num, options, 3);
    else if (options.notation === "scientific")
      result = serializeScientificNotationNumber(num, options);
    return sign2 + (result ?? serializeAutoNotationNumber(num, options));
  }
  function serializeScientificNotationNumber(valString, options, expMultiple = 1) {
    let m = valString.match(/^(.*)[e|E]([-+]?[0-9]+)$/);
    if (!m) {
      let sign2 = "";
      if (valString[0] === "-") {
        sign2 = "-";
        valString = valString.substring(1);
      } else if (valString[0] === "+") {
        valString = valString.substring(1);
      }
      if (valString.indexOf(".") < 0) {
        if (valString.length === 1) {
          valString = sign2 + valString + "e+0";
        } else {
          valString = sign2 + valString[0] + "." + valString.slice(1) + "e+" + (valString.length - 1).toString();
        }
      } else {
        let [_, whole, fraction] = valString.match(/^(.*)\.(.*)$/);
        if (!fraction) fraction = "";
        while (whole.startsWith("0")) whole = whole.substring(1);
        if (!whole) {
          valString = sign2 + "0." + fraction + "e+0";
        } else {
          valString = sign2 + whole[0] + "." + whole.slice(1) + fraction + "e+" + (whole.length - 1).toString();
        }
      }
      m = valString.match(/^(.*)[e|E]([-+]?[0-9]+)$/);
    }
    console.assert(m);
    if (!m) return serializeAutoNotationNumber(valString, options);
    let exponent = parseInt(m[2]);
    let mantissa = m[1];
    if (Math.abs(exponent) % expMultiple !== 0) {
      const adjust = exponent > 0 ? exponent % expMultiple : -((expMultiple + exponent) % expMultiple);
      exponent = exponent >= 0 ? exponent - adjust : exponent + adjust;
      let [_, whole, fraction] = mantissa.match(/^(.*)\.(.*)$/) ?? [
        "",
        mantissa,
        ""
      ];
      mantissa = whole + (fraction + "00000000000000000").slice(0, Math.abs(adjust)) + "." + fraction.slice(Math.abs(adjust));
    }
    const avoid = options.avoidExponentsInRange;
    if (avoid && exponent >= avoid[0] && exponent <= avoid[1]) return void 0;
    let fractionalPart = "";
    let wholePart = mantissa;
    m = wholePart.match(/^(.*)\.(.*)$/);
    if (m) {
      wholePart = m[1];
      fractionalPart = m[2];
    }
    const expString = formatExponent(Number(exponent).toString(), options);
    fractionalPart = formatFractionalPart(
      fractionalPart,
      wholePart.length,
      options
    );
    wholePart = insertWholeGroupSeparator(wholePart, options);
    if (fractionalPart)
      fractionalPart = options.decimalSeparator + fractionalPart;
    if (!expString) return wholePart + fractionalPart;
    if (!fractionalPart) {
      if (wholePart === "1") return expString;
      if (wholePart === "-1") return "-" + expString;
    }
    return wholePart + fractionalPart + options.exponentProduct + expString;
  }
  function serializeAutoNotationNumber(valString, options) {
    let m = valString.match(/^(.*)[e|E]([-+]?[0-9]+)$/i);
    let exp2 = 0;
    if (m?.[1] && m[2]) {
      exp2 = parseInt(m[2]);
      valString = m[1];
    }
    let wholePart = m?.[1] ?? valString;
    let fractionalPart = "";
    m = valString.match(/^(.*)\.(.*)$/);
    if (m?.[1] && m[2]) {
      wholePart = m[1];
      fractionalPart = m[2];
    }
    if (exp2 !== 0 && fractionalPart) {
      wholePart += fractionalPart;
      exp2 -= fractionalPart.length;
      fractionalPart = "";
    }
    const avoid = options.avoidExponentsInRange;
    if (exp2 !== 0 && avoid) {
      if (exp2 >= avoid[0] && exp2 <= avoid[1]) {
        [wholePart, fractionalPart] = toDecimalNumber(
          wholePart,
          fractionalPart,
          exp2
        );
        exp2 = 0;
      }
    }
    const exponent = formatExponent(exp2.toString(), options);
    if (fractionalPart)
      fractionalPart = options.decimalSeparator + formatFractionalPart(fractionalPart, wholePart.length, options);
    wholePart = insertWholeGroupSeparator(wholePart, options);
    if (!exponent) return wholePart + fractionalPart;
    if (!fractionalPart) {
      if (wholePart === "1") return exponent;
      if (wholePart === "-1") return "-" + exponent;
    }
    return wholePart + fractionalPart + options.exponentProduct + exponent;
  }
  function insertSeparatorEveryNDigitsFromLeft(numberString, n, separator) {
    const regex = new RegExp(`(\\d{${n}})(?=\\d)`, "g");
    return numberString.replace(regex, `$1${separator}`);
  }
  function insertSeparatorEveryNDigitsFromRight(numberString, n, separator) {
    const regex = new RegExp(`(\\d{${n}})(?=\\d)`, "g");
    const reversedSeparator = separator.split("").reverse().join("");
    return numberString.split("").reverse().join("").replace(regex, `$1${reversedSeparator}`).split("").reverse().join("");
  }
  function insertIndianNumberingSystem(numberString, separator) {
    const reverseString = numberString.split("").reverse().join("");
    const reversedSeparator = separator.split("").reverse().join("");
    let formattedString = reverseString.replace(
      /(\d{3})(?=\d)/,
      `$1${reversedSeparator}`
    );
    formattedString = formattedString.replace(
      /(\d{2})(?=(\d{2})+,)/g,
      `$1${reversedSeparator}`
    );
    return formattedString.split("").reverse().join("");
  }
  function insertGroupSeparator(numberString, options, part) {
    let group = options.digitGroup;
    if (typeof group !== "string" && Array.isArray(group)) group = group[part];
    const separator = typeof options.digitGroupSeparator === "string" ? options.digitGroupSeparator : options.digitGroupSeparator[part];
    if (!separator) return numberString;
    if (group === "lakh") {
      if (part === 0) return insertIndianNumberingSystem(numberString, separator);
      return insertSeparatorEveryNDigitsFromLeft(numberString, 3, separator);
    }
    if (group === false || group <= 0) return numberString;
    if (part === 1)
      return insertSeparatorEveryNDigitsFromLeft(numberString, group, separator);
    return insertSeparatorEveryNDigitsFromRight(numberString, group, separator);
  }
  function insertFractionalGroupSeparator(numberString, options) {
    return insertGroupSeparator(numberString, options, 1);
  }
  function insertWholeGroupSeparator(numberString, options) {
    return insertGroupSeparator(numberString, options, 0);
  }
  function toDecimalNumber(wholePart, fractionalPart, exp2) {
    let combinedNumber = wholePart + fractionalPart;
    const wholeLength = wholePart.length;
    const newDecimalPosition = wholeLength + exp2;
    let newWholePart;
    let newFractionalPart;
    if (newDecimalPosition > 0) {
      if (newDecimalPosition >= combinedNumber.length) {
        combinedNumber = combinedNumber + "0".repeat(newDecimalPosition - combinedNumber.length);
        newWholePart = combinedNumber;
        newFractionalPart = "";
      } else {
        newWholePart = combinedNumber.slice(0, newDecimalPosition);
        newFractionalPart = combinedNumber.slice(newDecimalPosition);
      }
    } else {
      newWholePart = "0";
      newFractionalPart = "0".repeat(-newDecimalPosition) + combinedNumber;
    }
    return [newWholePart, newFractionalPart];
  }

  // src/compute-engine/latex-syntax/serializer.ts
  var ACCENT_MODIFIERS = {
    deg: (s) => `${s}\\degree`,
    prime: (s) => `${s}^{\\prime}`,
    dprime: (s) => `${s}^{\\doubleprime}`,
    ring: (s) => `\\mathring{${s}}`,
    hat: (s) => `\\hat{${s}}`,
    tilde: (s) => `\\tilde{${s}}`,
    vec: (s) => `\\vec{${s}}`,
    bar: (s) => `\\overline{${s}}`,
    underbar: (s) => `\\underline{${s}}`,
    dot: (s) => `\\dot{${s}}`,
    ddot: (s) => `\\ddot{${s}}`,
    tdot: (s) => `\\dddot{${s}}`,
    qdot: (s) => `\\ddddot{${s}}`,
    // Supplemental
    acute: (s) => `\\acute{${s}}`,
    grave: (s) => `\\grave{${s}}`,
    breve: (s) => `\\breve{${s}}`,
    check: (s) => `\\check{${s}}`
  };
  var STYLE_MODIFIERS = {
    upright: (s) => `\\mathrm{${s}}`,
    italic: (s) => `\\mathit{${s}}`,
    bold: (s) => `\\mathbf{${s}}`,
    script: (s) => `\\mathscr{${s}}`,
    fraktur: (s) => `\\mathfrak{${s}}`,
    // Note Unicode uses 'fraktur' for 'gothic'
    doublestruck: (s) => `\\mathbb{${s}}`,
    // Unicode uses 'double-struck' for 'blackboard'
    // Supplemental
    blackboard: (s) => `\\mathbb{${s}}`,
    calligraphic: (s) => `\\mathcal{${s}}`,
    gothic: (s) => `\\mathfrak{${s}}`,
    sansserif: (s) => `\\mathsf{${s}}`,
    monospace: (s) => `\\mathtt{${s}}`
  };
  var Serializer4 = class {
    constructor(dictionary, options) {
      this.level = -1;
      this.dictionary = dictionary;
      this.options = options;
    }
    /**
     * Serialize the expression, and if the expression is an operator
     * of precedence less than or equal to prec, wrap it in some parens.
     * @todo: don't wrap Abs, Floor, Ceil, Delimiter
     */
    wrap(expr, prec) {
      if (expr === null || expr === void 0) return "";
      if (prec === void 0) {
        return this.wrapString(
          this.serialize(expr),
          this.options.groupStyle(expr, this.level + 1)
        );
      }
      if (typeof expr === "number" || isNumberObject(expr)) {
        const val = machineValue(expr);
        if (val !== null && val < 0 && prec > ADDITION_PRECEDENCE)
          return this.wrap(expr);
        return this.serialize(expr);
      }
      const name = operator(expr);
      if (name && name !== "Delimiter" && name !== "Subscript") {
        const def = this.dictionary.ids.get(name);
        if (def && (def.kind === "symbol" || def.kind === "expression" || def.kind === "prefix" || def.kind === "infix" || def.kind === "postfix") && def.precedence < prec)
          return this.wrapString(
            this.serialize(expr),
            this.options.applyFunctionStyle(expr, this.level)
          );
      }
      return this.serialize(expr);
    }
    /**
     * If this is a "short" expression, wrap it.
     * Do not wrap identifiers, positive numbers or functions.
     *
     * This is called by the serializer for power and division (i.e. "(a+1)/b")
     *
     */
    wrapShort(expr) {
      if (expr === null || expr === void 0) return "";
      const exprStr = this.serialize(expr);
      if (symbol(expr) !== null) return exprStr;
      const isNum = isNumberExpression(expr);
      if (isNum && !/^(-|\.)/.test(exprStr)) return exprStr;
      const h = operator(expr);
      if (h === "Delimiter" && nops(expr) === 1) return exprStr;
      if (h !== "Add" && h !== "Negate" && h !== "Subtract" && h !== "PlusMinus" && h !== "Multiply")
        return exprStr;
      return this.wrapString(
        exprStr,
        this.options.groupStyle(expr, this.level + 1)
      );
    }
    wrapString(s, style, fence) {
      if (style === "none") return s;
      fence ?? (fence = "()");
      let openFence = fence?.[0] ?? ".";
      let closeFence = fence?.[1] ?? ".";
      if (openFence === '"') openFence = "``";
      else if (openFence === "|") openFence = "\\lvert";
      else openFence = DELIMITERS_SHORTHAND[openFence] ?? openFence;
      if (closeFence === '"') closeFence = "''";
      else if (closeFence === "|") closeFence = "\\rvert";
      else closeFence = DELIMITERS_SHORTHAND[closeFence] ?? closeFence;
      if (openFence === "." && closeFence === ".") return s;
      if ((openFence === "." || closeFence === ".") && style === "normal")
        style = "scaled";
      if (style === "scaled")
        return `\\left${openFence}${s}\\right${closeFence}}`;
      if (style === "big")
        return `${`\\Bigl${openFence}`}${s}${`\\Bigr${closeFence}`})`;
      return openFence + s + closeFence;
    }
    wrapArguments(expr) {
      return this.wrapString(
        operands(expr).map((x) => this.serialize(x)).join(", "),
        this.options.applyFunctionStyle(expr, this.level)
      );
    }
    serializeSymbol(expr, def) {
      console.assert(typeof expr === "string" || isSymbolObject(expr));
      if (def?.kind === "function") {
        return serializeIdentifier(symbol(expr) ?? "") ?? "";
      }
      return def?.serialize?.(this, expr) ?? serializeIdentifier(symbol(expr)) ?? "";
    }
    serializeFunction(expr, def) {
      if (def?.serialize) return def.serialize(this, expr);
      const h = operator(expr);
      return serializeIdentifier(h, "auto") + this.wrapArguments(expr);
    }
    serialize(expr) {
      if (expr === null || expr === void 0) return "";
      this.level += 1;
      try {
        const result = (() => {
          const numericValue = serializeNumber(expr, this.options);
          if (numericValue) return numericValue;
          const s = stringValue(expr);
          if (s !== null) return `\\text{${s}}`;
          const symbolName = symbol(expr);
          if (symbolName !== null) {
            return this.serializeSymbol(
              expr,
              this.dictionary.ids.get(symbolName)
            );
          }
          const fnName = operator(expr);
          if (fnName) {
            const def = this.dictionary.ids.get(fnName);
            return this.serializeFunction(expr, def);
          }
          throw Error(`Syntax error ${expr ? JSON.stringify(expr) : ""}`);
        })();
        this.level -= 1;
        return result ?? "";
      } catch (e) {
      }
      this.level -= 1;
      return "";
    }
    applyFunctionStyle(expr, level) {
      return this.options.applyFunctionStyle(expr, level);
    }
    groupStyle(expr, level) {
      return this.options.groupStyle(expr, level);
    }
    rootStyle(expr, level) {
      return this.options.rootStyle(expr, level);
    }
    fractionStyle(expr, level) {
      return this.options.fractionStyle(expr, level);
    }
    logicStyle(expr, level) {
      return this.options.logicStyle(expr, level);
    }
    powerStyle(expr, level) {
      return this.options.powerStyle(expr, level);
    }
    numericSetStyle(expr, level) {
      return this.options.numericSetStyle(expr, level);
    }
  };
  function specialName(s) {
    const prefix = s.match(/^([^_]+)/)?.[1] ?? "";
    let i = SYMBOLS.findIndex((x) => prefix === x[0]);
    if (i >= 0) return [SYMBOLS[i][1], s.substring(SYMBOLS[i][0].length)];
    const DIGITS = {
      zero: "0",
      one: "1",
      two: "2",
      three: "3",
      four: "4",
      five: "5",
      six: "6",
      seven: "7",
      eight: "8",
      nine: "9",
      ten: "10"
    };
    i = Object.keys(DIGITS).findIndex((x) => s.startsWith(x));
    if (i >= 0) {
      const key = Object.keys(DIGITS)[i];
      return [DIGITS[key], s.substring(key.length)];
    }
    const code = s.codePointAt(0);
    i = SYMBOLS.findIndex((x) => x[2] === code);
    if (i >= 0) return [SYMBOLS[i][1], s.substring(1)];
    const EXTRA_SYMBOLS = {
      plus: "+",
      minus: "-",
      pm: "\\pm",
      ast: "\\ast",
      dag: "\\dag",
      ddag: "\\ddag",
      hash: "\\#",
      bottom: "\\bot",
      top: "\\top",
      bullet: "\\bullet",
      circle: "\\circ",
      diamond: "\\diamond",
      times: "\\times",
      square: "\\square",
      star: "\\star"
    };
    i = Object.keys(EXTRA_SYMBOLS).findIndex((x) => prefix === x);
    if (i >= 0) {
      const key = Object.keys(EXTRA_SYMBOLS)[i];
      return [EXTRA_SYMBOLS[key], s.substring(key.length)];
    }
    return [prefix, s.substring(prefix.length)];
  }
  function parseModifiers(s) {
    let [body, rest] = specialName(s);
    const accent = [];
    while (rest.length > 0) {
      const m = rest.match(/^_([a-zA-Z]+)(.*)/);
      if (!m) break;
      if (!ACCENT_MODIFIERS[m[1]]) break;
      accent.push(m[1]);
      rest = m[2];
    }
    const styles = [];
    while (rest.length > 0) {
      const m = rest.match(/^_([a-zA-Z]+)(.*)/);
      if (!m) break;
      if (!STYLE_MODIFIERS[m[1]]) break;
      styles.push(m[1]);
      rest = m[2];
    }
    return [body, accent, styles, rest];
  }
  function parseIdentifierBody(s, topLevel = true, style = "auto") {
    let [body, accents, styles, rest] = parseModifiers(s);
    for (const accent of accents) {
      if (ACCENT_MODIFIERS[accent]) body = ACCENT_MODIFIERS[accent](body);
    }
    if (topLevel) {
      const sups = [];
      const subs2 = [];
      const m = body.match(/^([^\d].*?)(\d+)$/);
      if (m) {
        subs2.push(m[2]);
        body = m[1];
      }
      while (rest.length > 0) {
        if (rest.startsWith("__")) {
          const [sup, rest2] = parseIdentifierBody(
            rest.substring(2),
            false,
            "none"
          );
          sups.push(sup);
          rest = rest2;
        } else if (rest.startsWith("_")) {
          const [sub2, rest2] = parseIdentifierBody(
            rest.substring(1),
            false,
            "none"
          );
          subs2.push(sub2);
          rest = rest2;
        } else {
          break;
        }
      }
      if (sups.length > 0) body = supsub("^", body, sups.join(","));
      if (subs2.length > 0) body = supsub("_", body, subs2.join(","));
    }
    for (const style2 of styles) {
      if (STYLE_MODIFIERS[style2]) body = STYLE_MODIFIERS[style2](body);
    }
    if (styles.length === 0 && style !== "none") {
      switch (style) {
        case "auto":
          if (countTokens(body) > 1) body = `\\mathrm{${body}}`;
          break;
        case "operator":
          body = `\\operatorname{${body}}`;
          break;
        case "italic":
          body = `\\mathit{${body}}`;
          break;
        case "upright":
          body = `\\mathrm{${body}}`;
          break;
      }
    }
    return [body, rest];
  }
  function serializeIdentifier(s, style = "auto") {
    if (s === null) return null;
    if (EMOJIS.test(s)) return s;
    const m = s.match(/^(_+)(.*)/);
    if (m) {
      const [body2, rest2] = parseIdentifierBody(m[2], true, "none");
      return `\\operatorname{${"\\_".repeat(m[1].length) + body2 + rest2}}`;
    }
    const [body, rest] = parseIdentifierBody(s, true, style);
    if (rest.length > 0) return `\\operatorname{${s}}`;
    return body;
  }
  function serializeLatex(expr, dict, options) {
    const serializer = new Serializer4(dict, options);
    return serializer.serialize(expr);
  }

  // src/compute-engine/boxed-expression/ascii-math.ts
  var SYMBOLS2 = {
    PositiveInfinity: "+oo",
    NegativeInfinity: "-oo",
    ComplexInfinity: "~oo",
    NaN: "NaN",
    Pi: "pi",
    ExponentialE: "e",
    ImaginaryUnit: "i",
    // Greek letters are valid symbols (i.e. don't need to be quoted)
    alpha: "alpha",
    beta: "beta",
    gamma: "gamma",
    delta: "delta",
    epsilon: "epsilon",
    epsilonSymbol: "varepsilon",
    zeta: "zeta",
    eta: "eta",
    theta: "theta",
    thetaSymbol: "vartheta",
    iota: "iota",
    kappa: "kappa",
    lambda: "lambda",
    mu: "mu",
    nu: "nu",
    xi: "xi",
    omicron: "omicron",
    pi: "pi",
    rho: "rho",
    sigma: "sigma",
    tau: "tau",
    upsilon: "upsilon",
    phi: "phi",
    phiSymbol: "varphi",
    chi: "chi",
    psi: "psi",
    omega: "omega",
    Gamma: "Gamma",
    Delta: "Delta",
    Theta: "Theta",
    Lambda: "Lambda",
    Xi: "Xi",
    Sigma: "Sigma",
    Upsilon: "Upsilon",
    Phi: "Phi",
    Psi: "Psi",
    Omega: "Omega"
  };
  var OPERATORS = {
    Add: [
      (expr, serialize) => {
        return expr.ops?.reduce((acc, x) => {
          if (x.operator === "Negate") {
            const rhs = serialize(x.op1, 10);
            if (acc === "") return `-${rhs}`;
            if (rhs.startsWith("+")) return `${acc} - ${rhs.substring(1)}`;
            if (rhs.startsWith("-")) return `${acc} + ${rhs.substring(1)}`;
            return `${acc} - ${rhs}`;
          }
          return joinAdd(acc, serialize(x, 10));
        }, "") ?? "";
      },
      11
    ],
    Negate: [
      (expr, serialize) => {
        const base = serialize(expr.op1, 14);
        if (base === "Power") return `-(${base})`;
        return `-${base}`;
      },
      14
    ],
    Subtract: [
      (expr, serialize) => {
        return expr.ops?.reduce((acc, x) => {
          const rhs = serialize(x, 10);
          if (acc === "") return rhs;
          if (rhs.startsWith("-")) return `${acc} - (${rhs})`;
          return `${acc} - ${rhs}`;
        }, "") ?? "";
      },
      11
    ],
    Multiply: [
      (expr, serialize) => {
        if (!expr.ops) return "";
        if (expr.nops === 2) {
          const lhs = expr.op1.numericValue;
          if (lhs !== null) {
            if (typeof lhs !== "number" && lhs.im !== 0) {
              joinMul(
                serialize(expr.op2, 12),
                joinAdd(lhs.re.toString(), `${lhs.im}i`)
              );
            }
            const rhs = expr.op2;
            if (rhs.symbol || rhs.operator === "Power" || rhs.operator === "Square" || typeof FUNCTIONS[rhs.operator] === "string") {
              if (isRational(lhs) && lhs[0] === 1) {
                const den = lhs[1];
                return `${serialize(rhs, 12)}/${den}`;
              }
            }
            return joinMul(serialize(expr.op1, 12), serialize(expr.op2, 12));
          }
        }
        return expr.ops.reduce((acc, x) => joinMul(acc, serialize(x, 12)), "");
      },
      12
    ],
    Divide: ["/", 13],
    Power: [
      (expr, serialize) => {
        const exponent = serialize(expr.op2, 14);
        if (exponent === "1") return serialize(expr.op1);
        if (exponent === "(1/2)" || exponent === "1/2" || exponent === "0.5")
          return `sqrt(${serialize(expr.op1)})`;
        if (exponent === "-0.5") return `(1/sqrt(${serialize(expr.op1)}))`;
        let base = serialize(expr.op1, 14);
        if (base.startsWith("-")) base = `(${base})`;
        if (exponent.length === 1) return `${base}^${exponent}`;
        return `${base}^${wrap(exponent)}`;
      },
      15
    ],
    Equal: ["===", 8],
    NotEqual: ["!==", 8],
    LessEqual: ["<=", 9],
    GreaterEqual: [">=", 9],
    Less: ["<", 9],
    Greater: [">", 9],
    And: ["&&", 4],
    Or: ["||", 3],
    Not: ["!", 14]
    // Unary operator
  };
  var FUNCTIONS = {
    Abs: (expr, serialize) => `|${serialize(expr.op1)}|`,
    Sin: "sin",
    Cos: "cos",
    Tan: "tan",
    Sec: "sec",
    Csc: "csc",
    Arcsin: "arcsin",
    Arccos: "arccos",
    Arctan: "arctan",
    Sinh: "sinh",
    Cosh: "cosh",
    Tanh: "tanh",
    Sech: "sech",
    Csch: "csch",
    Coth: "coth",
    Ceil: "ceil",
    // also: (expr, serialize) => `|~${serialize(expr.op1)}~|`,
    Exp: "exp",
    Factorial: (expr, serialize) => `${serialize(expr.op1, 12)}!`,
    Floor: "floor",
    // also: (expr, serialize) => `|__${serialize(expr.op1)}__|`,
    Log: "log",
    Ln: "ln",
    Log10: "log10",
    Sqrt: "sqrt",
    Root: (expr, serialize) => {
      const x = expr.op1;
      const n = expr.op2;
      if (n.is(2)) return `sqrt${wrap(serialize(x))}`;
      return `root${wrap(serialize(n))}${wrap(serialize(x))}`;
    },
    Square: (expr, serialize) => `${serialize(expr.op1, 12)}^2`,
    Det: "det",
    Dim: "dim",
    Mod: "mod",
    GCD: "gcd",
    LCM: "lcm",
    Lub: "lub",
    Glb: "glb",
    Max: "max",
    Min: "min",
    Sum: (expr, serialize) => bigOp(expr, "sum", serialize),
    Product: (expr, serialize) => bigOp(expr, "prod", serialize),
    Integrate: (expr, serialize) => bigOp(expr, "int", serialize),
    // Note: use ops[0], not op1 because op1 is "Nothing" when empty, and
    // we need to correctly handle `["Delimiter"]`
    Delimiter: (expr, serialize) => delimiter(expr.ops[0], expr.ops[1]?.string, serialize),
    Sequence: (expr, serialize) => {
      if (expr.nops === 0) return "";
      return expr.ops.map((x) => serialize(x)).join(" ");
    },
    List: (expr, serialize) => `[${expr.ops?.map((x) => serialize(x)) ?? ""}]`,
    Single: (expr, serialize) => `(${expr.ops.map((x) => serialize(x)).join(", ")})`,
    Pair: (expr, serialize) => `(${expr.ops.map((x) => serialize(x)).join(", ")})`,
    Triple: (expr, serialize) => `(${expr.ops.map((x) => serialize(x)).join(", ")})`,
    Tuple: (expr, serialize) => `(${expr.ops.map((x) => serialize(x)).join(", ")})`,
    Function: (expr, serialize) => `(${expr.ops.slice(1).map((x) => serialize(x)).join(", ")}) |-> {${serialize(expr.op1)}}`,
    Domain: (expr) => JSON.stringify(expr.json),
    Error: (expr, serialize) => {
      if (expr.nops === 1) return `Error(${serialize(expr.op1)})`;
      if (expr.nops === 2) {
        if (expr.op1.string)
          return `Error("${expr.op1.string}", ${serialize(expr.op2)})`;
        return `Error(${serialize(expr.op1)}, ${serialize(expr.op2)})`;
      }
      return `Error(${expr.ops.map((x) => serialize(x)).join(", ")})`;
    },
    LatexString: (expr) => {
      return `"${expr.op1.string ?? ""}"`;
    }
  };
  function bigOp(expr, op, serialize) {
    const op2 = expr.op2;
    let index = op2?.op1;
    let start = op2?.op2;
    let end = op2?.op3;
    if (index.symbol === "Nothing") index = null;
    if (start.symbol === "Nothing") start = null;
    if (end.symbol === "Nothing") end = null;
    let result = op;
    if (index && start) result += `_(${serialize(index)}=${serialize(start)})`;
    if (end) result += `^${wrap(serialize(end))}`;
    return result + wrap(serialize(expr.op1));
  }
  function delimiter(expr, delimiter2, serialize) {
    if (!delimiter2) delimiter2 = "(,)";
    let separator = "";
    let open = "";
    let close = "";
    if (delimiter2.length === 1) separator = delimiter2;
    if (delimiter2.length === 2) {
      open = delimiter2[0];
      close = delimiter2[1];
    }
    if (delimiter2.length === 3) {
      open = delimiter2[0];
      separator = delimiter2[1];
      close = delimiter2[2];
    }
    if (!expr) return `${open}${close}`;
    let items = [expr];
    if (expr.operator === "Sequence") items = expr.ops;
    return `${open}${items.map((x) => serialize(x)).join(separator)}${close}`;
  }
  function wrap(s, precedence = 0, target = -1) {
    if (precedence > target && !/^\(.+\)$/.test(s)) return `(${s})`;
    return s;
  }
  function serializeSymbol(symbol2, options = {}) {
    if (options.symbols?.[symbol2]) return options.symbols[symbol2];
    if (SYMBOLS2[symbol2]) return SYMBOLS2[symbol2];
    return symbol2.length === 1 ? symbol2 : `"${symbol2}"`;
  }
  function toAsciiMath(expr, options = {}, precedence = 0) {
    if (expr.symbol) return serializeSymbol(expr.symbol, options);
    const serialize = (expr2, precedence2 = 0) => toAsciiMath(expr2, options, precedence2);
    if (expr.string) return expr.string;
    const num = expr.numericValue;
    if (num !== null) {
      if (expr.isNaN) return serializeSymbol("NaN", options);
      if (expr.isFinite === false) {
        if (expr.isNegative !== true && expr.isPositive !== true)
          return serializeSymbol("ComplexInfinity", options);
        return serializeSymbol(
          expr.isNegative ? "NegativeInfinity" : "PositiveInfinity",
          options
        );
      }
      return num.toString();
    }
    if (expr.operator) {
      const operators = options.operators ? { ...OPERATORS, ...options.operators } : OPERATORS;
      const [operator2, precedence_] = operators[expr.operator] ?? [];
      if (operator2) {
        let result = "";
        if (typeof operator2 === "function") {
          result = operator2(expr, serialize);
        } else {
          if (expr.nops === 1)
            return `${operator2}${serialize(expr.op1, precedence_ + 1)}`;
          result = expr.ops?.map((x) => serialize(x, precedence_ + 1)).join(` ${operator2} `) ?? "";
        }
        return wrap(result, precedence, precedence_);
      }
      const functions = options.functions ? { ...FUNCTIONS, ...options.functions } : FUNCTIONS;
      const func = functions[expr.operator];
      if (typeof func === "function") return func(expr, serialize);
      if (typeof func === "string")
        return `${func}(${expr.ops?.map((x) => serialize(x)).join(", ") ?? ""})`;
      return `${expr.operator}(${expr.ops?.map((x) => serialize(x)).join(", ") ?? ""})`;
    }
    return JSON.stringify(expr.json);
  }
  function joinMul(lhs, rhs) {
    if (!lhs) return rhs;
    if (!rhs) return lhs;
    if (rhs.startsWith("-")) rhs = `(${rhs})`;
    if (lhs === "-1") return `-${rhs}`;
    if (rhs === "-1") return `-${lhs}`;
    if (lhs.match(/^[-+]?\d+$/) && rhs.match(/^[a-zA-Z\(]/)) return lhs + rhs;
    return `${lhs} * ${rhs}`;
  }
  function joinAdd(lhs, rhs) {
    if (!lhs) return rhs;
    if (!rhs) return lhs;
    if (lhs === "0") return rhs;
    if (rhs === "0") return lhs;
    if (rhs.startsWith("-")) return `${lhs} - ${rhs.substring(1)}`;
    return `${lhs} + ${rhs}`;
  }

  // src/compute-engine/boxed-expression/abstract-boxed-expression.ts
  var _BoxedExpression = class {
    /** @deprecated */
    get head() {
      return this.operator;
    }
    constructor(ce, metadata) {
      this.engine = ce;
      if (metadata?.latex !== void 0) this.verbatimLatex = metadata.latex;
    }
    isSame(rhs) {
      return same(this, rhs);
    }
    isEqual(rhs) {
      return eq(this, rhs);
    }
    isLess(_rhs) {
      const c = cmp(this, _rhs);
      if (c === void 0) return void 0;
      return c === "<";
    }
    isLessEqual(_rhs) {
      const c = cmp(this, _rhs);
      if (c === void 0) return void 0;
      return c === "<=" || c === "<" || c === "=";
    }
    isGreater(_rhs) {
      const c = cmp(this, _rhs);
      if (c === void 0) return void 0;
      return c === ">";
    }
    isGreaterEqual(_rhs) {
      const c = cmp(this, _rhs);
      if (c === void 0) return void 0;
      return c === ">=" || c === ">" || c === "=";
    }
    /**
     *
     * `Object.valueOf()`: return a JavaScript primitive value for the expression
     *
     * Primitive values are: boolean, number, bigint, string, null, undefined
     *
     */
    valueOf() {
      if (this.symbol === "True") return true;
      if (this.symbol === "False") return false;
      if (this.symbol === "NaN") return NaN;
      if (this.symbol === "PositiveInfinity") return Infinity;
      if (this.symbol === "NegativeInfinity") return -Infinity;
      if (this.isInfinity) {
        if (this.isPositive) return Infinity;
        if (this.isNegative) return -Infinity;
        return NaN;
      }
      if (typeof this.string === "string") return this.string;
      if (typeof this.symbol === "string") return this.symbol;
      if (this.im === 0) return this.re;
      return this.toString();
    }
    toAsciiMath(options = {}) {
      return toAsciiMath(this, options);
    }
    /** Object.toString() */
    toString() {
      return toAsciiMath(this);
    }
    print() {
      const log3 = console["info"];
      log3?.(this.toString());
    }
    [Symbol.toPrimitive](hint) {
      if (hint === "number") {
        const v = this.valueOf();
        return typeof v === "number" ? v : null;
      }
      return this.toString();
    }
    /** Called by `JSON.stringify()` when serializing to json.
     *
     * Note: this is a standard method of JavaScript objects.
     *
     */
    toJSON() {
      return this.json;
    }
    toMathJson(options) {
      const defaultOptions = {
        exclude: [],
        shorthands: ["function", "symbol", "string", "number"],
        metadata: [],
        fractionalDigits: "max",
        repeatingDecimal: true,
        prettify: true
      };
      if (options) {
        if (typeof options.shorthands === "string" && options.shorthands === "all" || options.shorthands?.includes("all")) {
          defaultOptions.shorthands = ["function", "symbol", "string", "number"];
        }
        if (Array.isArray(options.shorthands))
          defaultOptions.shorthands = options.shorthands;
        if (typeof options.metadata === "string" && options.metadata === "all" || options.metadata?.includes("all")) {
          defaultOptions.metadata = ["latex", "wikidata"];
        }
        if (options.fractionalDigits === "auto")
          defaultOptions.fractionalDigits = -this.engine.precision;
        if (typeof options.fractionalDigits === "number")
          defaultOptions.fractionalDigits = options.fractionalDigits;
      }
      const opts = {
        ...defaultOptions,
        ...options,
        fractionalDigits: defaultOptions.fractionalDigits,
        shorthands: defaultOptions.shorthands,
        metadata: defaultOptions.metadata
      };
      return serializeJson(this.engine, this, opts);
    }
    toLatex(options) {
      const json = this.toMathJson();
      let effectiveOptions = {
        imaginaryUnit: "\\imaginaryI",
        positiveInfinity: "\\infty",
        negativeInfinity: "-\\infty",
        notANumber: "\\operatorname{NaN}",
        decimalSeparator: this.engine.decimalSeparator,
        digitGroupSeparator: "\\,",
        // for thousands, etc...
        exponentProduct: "\\cdot",
        beginExponentMarker: "10^{",
        // could be 'e'
        endExponentMarker: "}",
        digitGroup: 3,
        truncationMarker: "\\ldots",
        repeatingDecimal: "vinculum",
        fractionalDigits: "max",
        notation: "auto",
        avoidExponentsInRange: [-7, 20],
        prettify: true,
        invisibleMultiply: "",
        // '\\cdot',
        invisiblePlus: "",
        // '+',
        // invisibleApply: '',
        multiply: "\\times",
        missingSymbol: "\\blacksquare",
        // openGroup: '(',
        // closeGroup: ')',
        // divide: '\\frac{#1}{#2}',
        // subtract: '#1-#2',
        // add: '#1+#2',
        // negate: '-#1',
        // squareRoot: '\\sqrt{#1}',
        // nthRoot: '\\sqrt[#2]{#1}',
        applyFunctionStyle: getApplyFunctionStyle,
        groupStyle: getGroupStyle,
        rootStyle: getRootStyle,
        fractionStyle: getFractionStyle,
        logicStyle: getLogicStyle,
        powerStyle: getPowerStyle,
        numericSetStyle: getNumericSetStyle
      };
      if (options?.fractionalDigits === "auto")
        effectiveOptions.fractionalDigits = -this.engine.precision;
      else effectiveOptions.fractionalDigits = options?.fractionalDigits ?? "max";
      if (typeof effectiveOptions.fractionalDigits === "number" && effectiveOptions.fractionalDigits > this.engine.precision)
        effectiveOptions.fractionalDigits = this.engine.precision;
      effectiveOptions = {
        ...effectiveOptions,
        ...options ?? {},
        fractionalDigits: effectiveOptions.fractionalDigits
      };
      if (!effectiveOptions.prettify && this.verbatimLatex)
        return this.verbatimLatex;
      return serializeLatex(
        json,
        this.engine.indexedLatexDictionary,
        effectiveOptions
      );
    }
    toNumericValue() {
      return [this.engine._numericValue(1), this];
    }
    get scope() {
      return null;
    }
    is(rhs) {
      if (typeof rhs === "number" || typeof rhs === "bigint") return false;
      if (typeof rhs === "boolean") {
        if (this.symbol === "True" && rhs === true) return true;
        if (this.symbol === "False" && rhs === false) return true;
        return false;
      }
      if (rhs === null || rhs === void 0) return false;
      return same(this, this.engine.box(rhs));
    }
    get canonical() {
      return this;
    }
    get structural() {
      return this;
    }
    get isStructural() {
      return true;
    }
    get latex() {
      return this.toLatex();
    }
    set latex(val) {
      this.verbatimLatex = val;
    }
    get symbol() {
      return null;
    }
    get tensor() {
      return null;
    }
    get string() {
      return null;
    }
    getSubexpressions(operator2) {
      return getSubexpressions(this, operator2);
    }
    get subexpressions() {
      return this.getSubexpressions("");
    }
    get symbols() {
      const set = /* @__PURE__ */ new Set();
      getSymbols(this, set);
      return Array.from(set).sort();
    }
    get unknowns() {
      const set = /* @__PURE__ */ new Set();
      getUnknowns(this, set);
      return Array.from(set).sort();
    }
    get freeVariables() {
      const set = /* @__PURE__ */ new Set();
      getFreeVariables(this, set);
      return Array.from(set).sort();
    }
    get errors() {
      return this.getSubexpressions("Error");
    }
    // Only return non-null for functions
    get ops() {
      return null;
    }
    get nops() {
      return 0;
    }
    get op1() {
      return this.engine.Nothing;
    }
    get op2() {
      return this.engine.Nothing;
    }
    get op3() {
      return this.engine.Nothing;
    }
    get isValid() {
      return true;
    }
    get isPure() {
      return false;
    }
    /** Literals (number, string, boolean) are constants. Some symbols
     * may also be constants (e.g. Pi, E, True, False). Expressions of constant
     * symbols are also constants (if the function is pure).
     */
    get isConstant() {
      return true;
    }
    get isNaN() {
      return void 0;
    }
    get isInfinity() {
      return void 0;
    }
    // Not +- Infinity, not NaN
    get isFinite() {
      return void 0;
    }
    get isEven() {
      return void 0;
    }
    get isOdd() {
      return void 0;
    }
    get numericValue() {
      return null;
    }
    get isNumberLiteral() {
      return false;
    }
    get isFunctionExpression() {
      return false;
    }
    get re() {
      return NaN;
    }
    get im() {
      return NaN;
    }
    get bignumRe() {
      return void 0;
    }
    get bignumIm() {
      return void 0;
    }
    get numerator() {
      return this;
    }
    get denominator() {
      return this.engine.One;
    }
    get numeratorDenominator() {
      return [this, this.engine.One];
    }
    //
    // Algebraic operations
    //
    neg() {
      return this.engine.NaN;
    }
    inv() {
      return this.engine.NaN;
    }
    abs() {
      return this.engine.NaN;
    }
    add(rhs) {
      return this.engine.NaN;
    }
    sub(rhs) {
      return this.add(rhs.neg());
    }
    mul(rhs) {
      return this.engine.NaN;
    }
    div(rhs) {
      return this.engine.NaN;
    }
    pow(exp2) {
      return this.engine.NaN;
    }
    root(exp2) {
      return this.engine.NaN;
    }
    sqrt() {
      return this.engine.NaN;
    }
    ln(base) {
      return this.engine.NaN;
    }
    get sgn() {
      return void 0;
    }
    get shape() {
      return [];
    }
    get rank() {
      return 0;
    }
    subs(_sub, options) {
      return options?.canonical === true ? this.canonical : this;
    }
    map(fn, options) {
      if (!this.ops) return fn(this);
      const canonical2 = options?.canonical ?? this.isCanonical;
      const recursive = options?.recursive ?? true;
      const ops = this.ops.map((x) => recursive ? x.map(fn, options) : fn(x));
      return fn(this.engine.function(this.operator, ops, { canonical: canonical2 }));
    }
    solve(_vars) {
      return null;
    }
    replace(_rules) {
      return null;
    }
    has(_v) {
      return false;
    }
    // x > 0
    get isPositive() {
      return void 0;
    }
    // x >= 0
    get isNonNegative() {
      return void 0;
    }
    // x < 0
    get isNegative() {
      return void 0;
    }
    // x <= 0
    get isNonPositive() {
      return void 0;
    }
    //
    //
    //
    //
    //
    get description() {
      if (!this.baseDefinition) return void 0;
      if (!this.baseDefinition.description) return void 0;
      if (typeof this.baseDefinition.description === "string")
        return [this.baseDefinition.description];
      return this.baseDefinition.description;
    }
    get url() {
      return this.baseDefinition?.url ?? void 0;
    }
    get wikidata() {
      return this.baseDefinition?.wikidata ?? void 0;
    }
    // set wikidata(val: string | undefined) {}
    get complexity() {
      return void 0;
    }
    get baseDefinition() {
      return void 0;
    }
    get symbolDefinition() {
      return void 0;
    }
    get functionDefinition() {
      return void 0;
    }
    infer(_t) {
      return false;
    }
    bind() {
      return;
    }
    reset() {
      return;
    }
    get value() {
      return this.N().valueOf();
    }
    set value(_value) {
      throw new Error(`Can't change the value of \\(${this.latex}\\)`);
    }
    get type() {
      return BoxedType.unknown;
    }
    set type(_type) {
      throw new Error(`Can't change the type of \\(${this.latex}\\)`);
    }
    get isNumber() {
      return void 0;
    }
    get isInteger() {
      return void 0;
    }
    get isRational() {
      return void 0;
    }
    get isReal() {
      return void 0;
    }
    simplify(_options) {
      return this;
    }
    expand() {
      return expand2(this) ?? this;
    }
    evaluate(_options) {
      return this.simplify();
    }
    evaluateAsync(_options) {
      return Promise.resolve(this.evaluate());
    }
    N() {
      return this.evaluate({ numericApproximation: true });
    }
    compile(options) {
      if (options?.to && options.to !== "javascript")
        throw new Error("Unknown target");
      options ?? (options = {});
      const expr = this;
      return compileToJavascript(
        expr,
        options?.functions,
        options?.vars,
        options?.imports,
        options?.preamble
      );
    }
    get isCollection() {
      return false;
    }
    contains(_rhs) {
      return false;
    }
    subsetOf(_target, _strict) {
      return false;
    }
    get size() {
      return 0;
    }
    each(_start, _count) {
      return {
        next() {
          return { done: true, value: void 0 };
        }
      };
    }
    at(_index) {
      return void 0;
    }
    get(_key) {
      return void 0;
    }
    indexOf(_expr) {
      return -1;
    }
  };
  function getFreeVariables(expr, result) {
    if (expr.operator === "Block") {
    }
    if (expr.symbol) {
      const def = expr.engine.lookupSymbol(expr.symbol);
      if (def && def.value !== void 0) return;
      const fnDef = expr.engine.lookupFunction(expr.symbol);
      if (fnDef && fnDef.evaluate) return;
      result.add(expr.symbol);
      return;
    }
    if (expr.ops) for (const op of expr.ops) getFreeVariables(op, result);
  }
  function getSymbols(expr, result) {
    if (expr.symbol) {
      result.add(expr.symbol);
      return;
    }
    if (expr.ops) for (const op of expr.ops) getSymbols(op, result);
  }
  function getUnknowns(expr, result) {
    if (expr.symbol) {
      const s = expr.symbol;
      if (s === "Unknown" || s === "Undefined" || s === "Nothing") return;
      const def = expr.engine.lookupSymbol(s);
      if (def && def.value !== void 0) return;
      const fnDef = expr.engine.lookupFunction(s);
      if (fnDef && fnDef.evaluate) return;
      result.add(s);
      return;
    }
    if (expr.ops) for (const op of expr.ops) getUnknowns(op, result);
  }
  function getSubexpressions(expr, name) {
    const result = !name || expr.operator === name ? [expr] : [];
    if (expr.ops) {
      for (const op of expr.ops) result.push(...getSubexpressions(op, name));
    }
    return result;
  }

  // src/common/utils.ts
  function permutations(xs) {
    const result = [];
    const permute = (arr, m = []) => {
      if (arr.length === 0) {
        result.push(m);
      } else {
        for (let i = 0; i < arr.length; i++) {
          const curr = arr.slice();
          const next = curr.splice(i, 1);
          permute(curr.slice(), m.concat(next));
        }
      }
    };
    permute(xs);
    return result;
  }
  function hidePrivateProperties(obj) {
    for (const key in obj) {
      if (key.startsWith("_") && obj.hasOwnProperty(key)) {
        Object.defineProperty(obj, key, {
          enumerable: false,
          configurable: true,
          // Allows redefinition if necessary
          writable: true,
          // Allows modification
          value: obj[key]
        });
      }
    }
  }

  // src/compute-engine/boxed-expression/hold.ts
  function holdMap(expr, f) {
    if (!expr.ops) return [];
    let xs = expr.ops;
    const def = expr.functionDefinition;
    if (!def || xs.length === 0) return xs;
    const associativeHead = def?.associative ? def.name : "";
    xs = flattenOps(xs, associativeHead);
    if (def.lazy) return xs;
    const result = [];
    for (const x of xs) {
      const h = x.operator;
      if (h === "Hold") result.push(x);
      else {
        const op = h === "ReleaseHold" ? x.op1 : x;
        if (op) {
          const y = f(op);
          if (y !== null) result.push(y);
        }
      }
    }
    return flattenOps(result, associativeHead);
  }
  async function holdMapAsync(expr, f) {
    if (!expr.ops) return [];
    let xs = expr.ops;
    const def = expr.functionDefinition;
    if (!def || xs.length === 0) return xs;
    const associativeHead = def?.associative ? def.name : "";
    xs = flattenOps(xs, associativeHead);
    if (def.lazy) return xs;
    const result = [];
    for (const x of xs) {
      const h = x.operator;
      if (h === "Hold") result.push(x);
      else {
        const op = h === "ReleaseHold" ? x.op1 : x;
        if (op) {
          const y = await f(op);
          if (y !== null) result.push(y);
        }
      }
    }
    return flattenOps(result, associativeHead);
  }

  // src/compute-engine/boxed-expression/simplify.ts
  function simplify(expr, options, steps) {
    const hasSeen = (x) => steps && steps.some((y) => y.value.isSame(x));
    if (hasSeen(expr)) return steps;
    if (!steps) steps = [{ value: expr, because: "initial" }];
    if (!expr.isValid) return steps;
    if (!(expr.isCanonical || expr.isStructural)) {
      const canonical2 = expr.canonical;
      if (!(canonical2.isCanonical || canonical2.isStructural)) return steps;
      return simplify(canonical2, options, steps);
    }
    const ce = expr.engine;
    const rules = options?.rules ? ce.rules(options.rules, { canonical: true }) : ce.getRuleSet("standard-simplification");
    options = { ...options, rules };
    do {
      const newSteps = simplifyExpression(expr, rules, options, steps);
      if (newSteps.length <= steps.length) break;
      expr = newSteps.at(-1).value;
      steps = newSteps;
    } while (!steps.slice(0, -1).some((x) => x.value.isSame(expr)));
    return steps;
  }
  function isCheaper(oldExpr, newExpr, costFunction2) {
    if (newExpr === null || newExpr === void 0) return false;
    if (oldExpr === newExpr) return false;
    if (oldExpr.isSame(newExpr)) return false;
    const ce = oldExpr.engine;
    costFunction2 ?? (costFunction2 = (x) => ce.costFunction(x));
    if (costFunction2(newExpr) <= 1.2 * costFunction2(oldExpr)) {
      return true;
    }
    return false;
  }
  function simplifyOperands(expr, options) {
    if (!expr.ops) return expr;
    return expr.engine.function(
      expr.operator,
      holdMap(expr, (x) => simplify(x, options).at(-1).value)
    );
  }
  function simplifyExpression(expr, rules, options, steps) {
    if (expr.isNumberLiteral || expr.string) return steps;
    if (expr.symbol) {
      const result2 = replace(expr, rules, {
        recursive: false,
        canonical: true,
        useVariations: false
      });
      if (result2.length > 0) return [...steps, ...result2];
      return steps;
    }
    const alt = simplifyOperands(expr, options);
    if (!alt.isSame(expr)) {
      steps = [...steps, { value: alt, because: "simplified operands" }];
      expr = alt;
    }
    const result = simplifyNonCommutativeFunction(expr, rules, options, steps);
    if (result.length > steps.length) return result;
    return steps;
  }
  function simplifyNonCommutativeFunction(expr, rules, options, steps) {
    const result = replace(expr, rules, {
      recursive: false,
      canonical: true,
      useVariations: options.useVariations ?? false
    });
    if (result.length === 0) return steps;
    let last = result.at(-1).value;
    if (last.isSame(expr)) return steps;
    last = simplifyOperands(last);
    if (!isCheaper(expr, last, options?.costFunction)) return steps;
    result.at(-1).value = last;
    return [...steps, ...result];
  }

  // src/compute-engine/boxed-expression/boxed-patterns.ts
  function isWildcard(expr) {
    return expr.symbol?.startsWith("_") ?? (expr.operator === "Wildcard" || expr.operator === "WildcardSequence" || expr.operator === "WildcardOptionalSequence");
  }
  function wildcardName(expr) {
    if (expr.symbol?.startsWith("_")) return expr.symbol;
    if (expr.nops === 1) {
      const arg = expr.op1;
      if (expr.operator === "Wildcard") return `_${arg}`;
      if (expr.operator === "WildcardSequence") return `__${arg}`;
      if (expr.operator === "WildcardOptionalSequence") return `___${arg}`;
    }
    if (expr.operator === "Wildcard") return "_";
    if (expr.operator === "WildcardSequence") return "__";
    if (expr.operator === "WildcardOptionalSequence") return "___";
    return null;
  }

  // src/compute-engine/boxed-expression/match.ts
  function hasWildcards(expr) {
    if (typeof expr === "string") return expr.startsWith("_");
    if (isWildcard(expr)) return true;
    if (expr.ops)
      return hasWildcards(expr.operator) || expr.ops.some(hasWildcards);
    return false;
  }
  function captureWildcard(wildcard, expr, substitution) {
    console.assert(wildcard.startsWith("_"));
    if (wildcard === "_" || wildcard === "__" || wildcard === "___")
      return substitution;
    if (wildcard in substitution) {
      if (!expr.isSame(substitution[wildcard])) return null;
      return substitution;
    }
    if (hasWildcards(expr)) return null;
    return { ...substitution, [wildcard]: expr };
  }
  function matchOnce(expr, pattern, substitution, options) {
    if (isWildcard(pattern))
      return captureWildcard(wildcardName(pattern), expr, substitution);
    const acceptVariants = options.acceptVariants ?? true;
    options = { ...options, acceptVariants: true };
    if (pattern.numericValue !== null) {
      if (expr.numericValue === null) return null;
      if (pattern.isEqual(expr)) return substitution;
      if (!acceptVariants) return null;
      return matchVariations(expr, pattern, substitution, options);
    }
    const str = pattern.string;
    if (str !== null) return expr.string === str ? substitution : null;
    const symbol2 = pattern.symbol;
    if (symbol2 !== null) {
      if (symbol2 === expr.symbol) return substitution;
      if (!acceptVariants) return null;
      return matchVariations(expr, pattern, substitution, options);
    }
    if (pattern.ops) {
      const useVariations = options.useVariations ?? false;
      const ce = expr.engine;
      let result = null;
      const operator2 = pattern.operator;
      if (operator2.startsWith("_")) {
        result = captureWildcard(operator2, ce.box(expr.operator), substitution);
        if (result !== null)
          result = matchArguments(expr, pattern.ops, result, options);
      } else if (operator2 === expr.operator) {
        const def = ce.lookupFunction(operator2);
        result = def?.commutative ? matchPermutation(expr, pattern, substitution, options) : matchArguments(expr, pattern.ops, substitution, options);
      }
      if (result === null && useVariations) {
        if (!acceptVariants) return null;
        result = matchVariations(expr, pattern, substitution, options);
      }
      if (result !== null) substitution = result;
      if (options.recursive && expr.ops)
        result = matchRecursive(expr, pattern, substitution, {
          ...options,
          acceptVariants
        }) ?? result;
      return result;
    }
    return null;
  }
  function matchRecursive(expr, pattern, substitution, options) {
    console.assert(expr.ops !== null);
    let result = null;
    for (const op of expr.ops) {
      const r = matchOnce(op, pattern, substitution, options);
      if (r !== null) {
        result = r;
        substitution = r;
      }
    }
    return result;
  }
  function matchVariations(expr, pattern, substitution, options) {
    if (!options.useVariations) return null;
    const ce = expr.engine;
    const varOptions = { ...options, acceptVariants: false };
    const matchVariation = (op, ops) => matchOnce(
      ce.function(op, ops, { canonical: false }),
      pattern,
      substitution,
      varOptions
    );
    const operator2 = pattern.operator;
    if (operator2 === "Negate") {
      if (expr.is(0))
        return matchOnce(ce.Zero, pattern.op1, substitution, varOptions);
    }
    if (operator2 === "Add") {
      let result = matchVariation("Add", [0, expr]);
      if (result !== null) return result;
      if (expr.operator === "Subtract")
        result = matchVariation("Add", [expr.op1, ["Negate", expr.op2]]);
      if (result !== null) return result;
    }
    if (operator2 === "Subtract") {
      let result = matchVariation("Subtract", [expr, 0]);
      if (result !== null) return result;
      if (expr.operator === "Negate")
        result = matchVariation("Subtract", [0, expr.op1]);
      if (result !== null) return result;
    }
    if (operator2 === "Multiply") {
      let result = matchVariation("Multiply", [1, expr]);
      if (result !== null) return result;
      if (expr.operator === "Negate") {
        result = matchVariation("Multiply", [-1, expr.op1]);
        if (result !== null) return result;
      }
      if (expr.operator === "Divide") {
        result = matchVariation("Multiply", [
          expr.op1,
          ["Divide", 1, expr.op2]
        ]);
        if (result !== null) return result;
      }
    }
    if (operator2 === "Divide") {
      const result = matchVariation("Divide", [expr, 1]);
      if (result !== null) return result;
    }
    if (operator2 === "Square") {
      const result = matchVariation("Power", [expr, 2]);
      if (result !== null) return result;
    }
    if (operator2 === "Exp") {
      const result = matchVariation("Power", [ce.E, expr]);
      if (result !== null) return result;
    }
    if (operator2 === "Power") {
      if (pattern.op2.re === 2 && pattern.op2.im === 0) {
        const result = matchVariation("Square", [expr]);
        if (result !== null) return result;
      }
      if (pattern.op1.symbol === "ExponentialE") {
        const result = matchVariation("Exp", [expr]);
        if (result !== null) return result;
      }
      {
        const result = matchVariation("Power", [expr, 1]);
        if (result !== null) return result;
      }
    }
    return null;
  }
  function matchPermutation(expr, pattern, substitution, options) {
    console.assert(expr.operator === pattern.operator);
    const patterns = permutations(pattern.ops);
    for (const pat of patterns) {
      const result = matchArguments(expr, pat, substitution, options);
      if (result !== null) return result;
    }
    return null;
  }
  function matchArguments(expr, patterns, substitution, options) {
    if (patterns.length === 0) {
      if (expr.ops && expr.ops.length === 0) return substitution;
      return null;
    }
    const ce = patterns[0].engine;
    let result = { ...substitution };
    const ops = [...expr.ops];
    let i = 0;
    while (i < patterns.length) {
      const pat = patterns[i];
      const argName = wildcardName(pat);
      if (argName !== null) {
        if (argName.startsWith("__")) {
          let j = 0;
          if (patterns[i + 1] === void 0) {
            j = ops.length + 1;
          } else {
            let found = false;
            while (!found && j < ops.length) {
              found = matchOnce(ops[j], patterns[i + 1], result, options) !== null;
              j += 1;
            }
            if (!found && argName.startsWith("___")) return null;
          }
          if (!argName.startsWith("___") && j <= 1) return null;
          let value;
          if (j <= 1) {
            if (expr.operator === "Add") value = ce.Zero;
            else if (expr.operator === "Multiply") value = ce.One;
            else value = ce.Nothing;
          } else if (j === 2) {
            if (ops.length === 0) return null;
            value = ops.shift();
          } else {
            const def = ce.lookupFunction(expr.operator);
            const args = ops.splice(0, j - 1);
            if (def?.associative) {
              value = ce.function(expr.operator, args, { canonical: false });
            } else {
              value = ce.function("Sequence", args, { canonical: false });
            }
          }
          result = captureWildcard(argName, value, result);
        } else if (argName.startsWith("_")) {
          if (ops.length === 0) return null;
          result = captureWildcard(argName, ops.shift(), result);
        } else {
          result = matchOnce(ops.shift(), pat, result, options);
        }
      } else {
        const arg = ops.shift();
        if (!arg) return null;
        result = matchOnce(arg, pat, result, options);
      }
      if (result === null) return null;
      i += 1;
    }
    if (ops.length > 0) return null;
    return result;
  }
  function match(subject, pattern, options) {
    pattern = pattern.structural;
    const useVariations = options?.useVariations ?? false;
    const opts = {
      recursive: options?.recursive ?? false,
      useVariations,
      acceptVariants: useVariations
    };
    const substitution = options?.substitution ?? {};
    return matchOnce(subject.structural, pattern.structural, substitution, opts);
  }

  // src/compute-engine/boxed-expression/factor.ts
  function together(op) {
    const ce = op.engine;
    const h = op.operator;
    if (isRelationalOperator(h)) return ce.function(h, op.ops.map(together));
    if (h === "Divide") return op.ops[0].div(op.ops[1]);
    if (h === "Negate") return together(op.ops[0]).neg();
    if (h === "Add") {
      const [numer, denom] = op.ops.reduce(
        (acc, x) => {
          if (x.operator === "Divide") {
            acc[0].push(x.ops[0]);
            acc[1].push(x.ops[1]);
          } else acc[0].push(x);
          return acc;
        },
        [[], []]
      );
      return add3(...numer).div(add3(...denom));
    }
    return op;
  }
  function factor(expr) {
    const h = expr.operator;
    if (isRelationalOperator(h)) {
      let lhs = Product.from(expr.op1);
      let rhs = Product.from(expr.op2);
      const [coef, common] = commonTerms(lhs, rhs);
      let flip = coef.sgn() === -1;
      if (!coef.isOne) {
        lhs.div(coef);
        rhs.div(coef);
      }
      if (!common.is(1)) {
        if (common.isPositive) {
          lhs.div(common);
          rhs.div(common);
        } else if (common.isNegative) {
          lhs.div(common.neg());
          rhs.div(common.neg());
          flip = !flip;
        }
      }
      if (flip) [lhs, rhs] = [rhs, lhs];
      return expr.engine.function(h, [lhs.asExpression(), rhs.asExpression()]);
    }
    if (h === "Negate") return factor(expr.ops[0]).neg();
    if (h === "Add") {
      const ce = expr.engine;
      let common = void 0;
      const terms = [];
      for (const op of expr.ops) {
        const [coeff, term] = op.toNumericValue();
        common = common ? common.gcd(coeff) : coeff;
        if (!coeff.isZero) terms.push({ coeff, term });
      }
      if (!common || common.isOne) return expr;
      const newTerms = terms.map(
        ({ coeff, term }) => mul3(term, ce.box(coeff.div(common)))
      );
      return mul3(ce.number(common), add3(...newTerms));
    }
    return Product.from(together(expr)).asExpression();
  }

  // src/compute-engine/boxed-expression/sgn.ts
  function sgn(expr) {
    const ce = expr.engine;
    if (expr.operator === "Hold") return void 0;
    let s = void 0;
    if (expr.ops) {
      const def = expr.functionDefinition;
      if (def?.sgn) {
        const context = ce.swapScope(expr.scope);
        s = def.sgn(expr.ops, { engine: ce });
        ce.swapScope(context);
      }
      return s;
    }
    if (expr.symbol) return expr.symbolDefinition?.sgn;
    if (expr.isNumberLiteral) return expr.sgn;
    return "unsigned";
  }
  function positiveSign(s) {
    if (s === void 0) return void 0;
    if (s === "positive") return true;
    if ([
      "non-positive",
      "zero",
      "unsigned",
      "negative",
      "negative-infinity"
    ].includes(s))
      return false;
    return void 0;
  }
  function nonNegativeSign(s) {
    if (s === void 0) return void 0;
    if (s === "positive" || s === "positive-infinity" || s === "non-negative")
      return true;
    if (["negative", "negative-infinity", "zero", "unsigned"].includes(s))
      return false;
    return void 0;
  }
  function negativeSign(s) {
    if (s === void 0) return void 0;
    if (s === "negative" || s === "negative-infinity") return true;
    if ([
      "non-negative",
      "zero",
      "unsigned",
      "positive",
      "positive-infinity"
    ].includes(s))
      return false;
    return void 0;
  }
  function nonPositiveSign(s) {
    if (s === void 0) return void 0;
    if (s === "negative" || s === "negative-infinity" || s === "non-positive")
      return true;
    if (["positive", "zero", "unsigned"].includes(s)) return false;
    return void 0;
  }

  // src/compute-engine/boxed-expression/cache.ts
  function cachedValue(v, generation, fn) {
    if (v.generation === void 0 || v.generation === generation) {
      if (v.value === null) v.value = fn();
      return v.value;
    }
    v.generation = generation;
    v.value = fn();
    return v.value;
  }
  async function cachedValueAsync(v, generation, fn) {
    if (v.generation === void 0 || v.generation === generation) {
      if (v.value === null) v.value = await fn();
      return v.value;
    }
    v.generation = generation;
    v.value = await fn();
    return v.value;
  }

  // src/compute-engine/boxed-expression/boxed-function.ts
  var BoxedFunction = class extends _BoxedExpression {
    constructor(ce, name, ops, options) {
      super(ce, options?.metadata);
      // Cached properties of the expression
      this._value = {
        value: null,
        generation: -1
      };
      this._valueN = {
        value: null,
        generation: -1
      };
      this._sgn = {
        value: null,
        generation: -1
      };
      this._type = {
        value: null,
        generation: -1
      };
      this._name = name;
      this._ops = ops;
      this._isStructural = options?.structural ?? false;
      if (options?.canonical) this._canonical = this;
      if (options?.canonical || this._isStructural) this.bind();
      ce._register(this);
    }
    //
    // NON-CANONICAL OR CANONICAL OPERATIONS
    //
    // Those operations/properties can be applied to a canonical or
    // non-canonical expression
    //
    get hash() {
      if (this._hash !== void 0) return this._hash;
      let h = 0;
      for (const op of this._ops) h = h << 1 ^ op.hash | 0;
      h = h ^ hashCode(this._name) | 0;
      this._hash = h;
      return h;
    }
    // For function expressions, `infer()` infers the result type of the function
    infer(t) {
      const def = this.functionDefinition;
      if (!def) return false;
      if (!def.inferredSignature) return false;
      if (def.signature.is("function")) {
        def.signature = new BoxedType({ kind: "signature", result: t });
      } else if (isSignatureType(def.signature.type)) {
        def.signature = new BoxedType({
          kind: "signature",
          result: narrow(def.signature.type.result, t)
        });
      }
      this.engine.generation += 1;
      return true;
    }
    bind() {
      this._def = void 0;
      this._scope = this.engine.context;
      this._def = this.engine.lookupFunction(this._name);
      for (const op of this._ops) op.bind();
    }
    reset() {
    }
    get isCanonical() {
      return this._canonical === this;
    }
    set isCanonical(val) {
      this._canonical = val ? this : void 0;
    }
    get isPure() {
      if (this._isPure !== void 0) return this._isPure;
      if (!this.isCanonical) {
        this._isPure = false;
        return false;
      }
      let pure = this.functionDefinition?.pure ?? false;
      if (pure) pure = this._ops.every((x) => x.isPure);
      this._isPure = pure;
      return pure;
    }
    /** The value of the function is constant if the function is
     * pure, and all its arguments are constant.
     */
    get isConstant() {
      if (!this.isPure) return false;
      return this._ops.every((x) => x.isConstant);
    }
    get json() {
      return [this._name, ...this.structural.ops.map((x) => x.json)];
    }
    get scope() {
      return this._scope;
    }
    get operator() {
      return this._name;
    }
    get ops() {
      return this._ops;
    }
    get nops() {
      return this._ops.length;
    }
    get op1() {
      return this._ops[0] ?? this.engine.Nothing;
    }
    get op2() {
      return this._ops[1] ?? this.engine.Nothing;
    }
    get op3() {
      return this._ops[2] ?? this.engine.Nothing;
    }
    get isValid() {
      if (this._name === "Error") return false;
      return this._ops.every((x) => x?.isValid);
    }
    get canonical() {
      this._canonical ?? (this._canonical = this.isValid ? this.engine.function(this._name, this._ops) : this);
      return this._canonical;
    }
    get structural() {
      if (this.isStructural) return this;
      const def = this.functionDefinition;
      if (def?.associative || def?.commutative) {
        const xs = this.ops.map((x) => x.structural);
        let ys = [];
        if (!def.associative) ys = xs;
        else {
          for (const x of xs) {
            if (x.operator === this.operator) ys.push(...x.ops);
            else ys.push(x);
          }
        }
        return this.engine.function(
          this._name,
          this.isValid ? sortOperands(this._name, ys) : ys,
          {
            canonical: false,
            structural: true
          }
        );
      }
      return this.engine.function(
        this._name,
        this.ops.map((x) => x.structural),
        { canonical: false, structural: true }
      );
    }
    get isStructural() {
      return this._isStructural;
    }
    toNumericValue() {
      console.assert(this.isCanonical || this.isStructural);
      const ce = this.engine;
      if (this.operator === "Complex") {
        return [ce._numericValue({ re: this.op1.re, im: this.op2.re }), ce.One];
      }
      let expr = this;
      if (expr.operator === "Add") {
        expr = factor(this);
        if (expr.numericValue !== null) {
          if (typeof expr.numericValue === "number") {
            if (Number.isInteger(expr.numericValue))
              return [ce._numericValue(expr.numericValue), ce.One];
          } else if (expr.numericValue.isExact)
            return [expr.numericValue, ce.One];
        }
      }
      if (expr.operator === "Negate") {
        const [coef, rest] = expr.op1.toNumericValue();
        return [coef.neg(), rest];
      }
      if (expr.operator === "Multiply") {
        const rest = [];
        let coef = ce._numericValue(1);
        for (const arg of expr.ops) {
          const [c, r] = arg.toNumericValue();
          coef = coef.mul(c);
          if (!r.is(1)) rest.push(r);
        }
        if (rest.length === 0) return [coef, ce.One];
        if (rest.length === 1) return [coef, rest[0]];
        return [coef, canonicalMultiply(this.engine, rest)];
      }
      if (expr.operator === "Divide") {
        const [coef1, numer] = expr.op1.toNumericValue();
        const [coef2, denom] = expr.op2.toNumericValue();
        const coef = coef1.div(coef2);
        if (denom.is(1)) return [coef, numer];
        return [coef, ce.function("Divide", [numer, denom])];
      }
      if (expr.operator === "Power") {
        if (expr.op2.numericValue === null) return [ce._numericValue(1), this];
        let [coef, base] = expr.op1.toNumericValue();
        if (coef.isOne) return [coef, this];
        const exponent = asSmallInteger(expr.op2);
        if (exponent !== null)
          return [coef.pow(exponent), ce.function("Power", [base, expr.op2])];
        if (expr.op2.is(0.5)) return [coef.sqrt(), ce.function("Sqrt", [base])];
        return [ce._numericValue(1), this];
      }
      if (expr.operator === "Sqrt") {
        const [coef, rest] = expr.op1.toNumericValue();
        if (rest.is(1) || rest.is(0)) {
          if (coef.isOne || coef.isZero) return [coef, rest];
          return [coef.sqrt(), rest];
        }
        return [coef.sqrt(), ce.function("Sqrt", [rest])];
      }
      if (expr.operator === "Root") {
        const exp2 = expr.op2.re;
        if (isNaN(exp2) || expr.op2.im !== 0) return [ce._numericValue(1), this];
        const [coef, rest] = expr.op1.toNumericValue();
        if (exp2 === 2) return [coef.sqrt(), ce.function("Sqrt", [rest])];
        return [coef.root(exp2), ce.function("Root", [rest, expr.op2])];
      }
      if (expr.operator === "Abs") {
        const [coef, rest] = expr.op1.toNumericValue();
        return [coef.abs(), ce.function("Abs", [rest])];
      }
      console.assert(expr.operator !== "Complex");
      console.assert(expr.operator !== "Exp");
      if (expr.operator === "Log" || expr.operator === "Ln") {
        let base = expr.op2.re;
        if (isNaN(base) && expr.operator === "Log") base = 10;
        const [coef, rest] = expr.op1.toNumericValue();
        if (coef.isOne) return [coef, this];
        return ce.box(coef.ln(base)).add(ce.function(expr.operator, [rest, expr.op2])).toNumericValue();
      }
      return [ce._numericValue(1), expr];
    }
    // Note: the resulting expression is bound to the current scope, not
    // the scope of the original expression.
    subs(sub2, options) {
      const ops = this._ops.map((x) => x.subs(sub2, options));
      if (!ops.every((x) => x.isValid))
        return this.engine.function(this._name, ops, { canonical: false });
      return this.engine.function(this._name, ops, options);
    }
    replace(rules, options) {
      return replace(this, rules, options).at(-1)?.value ?? null;
    }
    match(pattern, options) {
      return match(this, pattern, options);
    }
    has(v) {
      if (typeof v === "string") {
        if (this._name === v) return true;
      } else if (v.includes(this._name)) return true;
      return this._ops.some((x) => x.has(v));
    }
    get sgn() {
      const gen = this.isPure && this._ops.every((x) => x.isConstant) ? void 0 : this.engine.generation;
      return cachedValue(this._sgn, gen, () => {
        if (!this.isValid || this.isNumber !== true) return void 0;
        return sgn(this);
      });
    }
    get isNaN() {
      return this.sgn === "nan";
    }
    get isInfinity() {
      const s = this.sgn;
      if (s === "positive-infinity" || s === "negative-infinity") return true;
      if (s === "complex-infinity") return true;
      return false;
    }
    // Not +- Infinity, not NaN
    get isFinite() {
      if (this.isNumber !== true) return false;
      if (this.isNaN || this.isInfinity) return false;
      if (this.isNaN === void 0 || this.isInfinity === void 0)
        return void 0;
      return true;
    }
    get isOne() {
      if (this.isNonPositive === true || this.isReal === false) return false;
      return void 0;
    }
    get isNegativeOne() {
      if (this.isNonNegative === true || this.isReal === false) return false;
      return void 0;
    }
    // x > 0
    get isPositive() {
      return positiveSign(this.sgn);
    }
    // x >= 0
    get isNonNegative() {
      return nonNegativeSign(this.sgn);
    }
    // x < 0
    get isNegative() {
      return negativeSign(this.sgn);
    }
    // x <= 0
    get isNonPositive() {
      return nonPositiveSign(this.sgn);
    }
    get numerator() {
      return this.numeratorDenominator[0];
    }
    get denominator() {
      return this.numeratorDenominator[1];
    }
    get numeratorDenominator() {
      if (!this.isCanonical) return this.canonical.numeratorDenominator;
      if (this.isNumber !== true)
        return [this.engine.Nothing, this.engine.Nothing];
      const operator2 = this.operator;
      if (operator2 === "Divide") return [this.op1, this.op2];
      if (operator2 === "Negate") {
        const [num, denom] = this.op1.numeratorDenominator;
        return [num.neg(), denom];
      }
      if (operator2 === "Power") {
        const [num, denom] = this.op1.numeratorDenominator;
        return [num.pow(this.op2), denom.pow(this.op2)];
      }
      if (operator2 === "Root") {
        const [num, denom] = this.op1.numeratorDenominator;
        return [num.root(this.op2), denom.root(this.op2)];
      }
      if (operator2 === "Sqrt") {
        const [num, denom] = this.op1.numeratorDenominator;
        return [num.sqrt(), denom.sqrt()];
      }
      if (operator2 === "Abs") {
        const [num, denom] = this.op1.numeratorDenominator;
        return [num.abs(), denom.abs()];
      }
      if (operator2 === "Multiply")
        return new Product(this.engine, this.ops).asNumeratorDenominator();
      if (operator2 === "Add") {
      }
      if (operator2 === "Log" || operator2 === "Ln") {
      }
      return [this, this.engine.One];
    }
    //
    //
    // ALGEBRAIC OPERATIONS
    //
    neg() {
      return negate(this.canonical);
    }
    inv() {
      if (!this.isCanonical) return this.canonical.inv();
      if (this.isOne) return this;
      if (this.isNegativeOne) return this;
      if (this.operator === "Sqrt") return this.op1.inv().sqrt();
      if (this.operator === "Divide") return this.op2.div(this.op1);
      if (this.operator === "Power") {
        const neg2 = this.op2.neg();
        if (neg2.operator !== "Negate") return this.op1.pow(neg2);
        return this.engine.function("Power", [this.op1, neg2]);
      }
      if (this.operator === "Root") {
        const neg2 = this.op2.neg();
        if (neg2.operator !== "Negate") return this.op1.root(neg2);
        return this.engine.function("Root", [this.op1, neg2]);
      }
      if (this.operator === "Exp") return this.engine.E.pow(this.op1.neg());
      if (this.operator === "Rational") return this.op2.div(this.op1);
      if (this.operator === "Negate") return this.op1.inv().neg();
      return this.engine._fn("Divide", [this.engine.One, this.canonical]);
    }
    abs() {
      if (!this.isCanonical) return this.canonical.abs();
      if (this.operator === "Abs" || this.operator === "Negate") return this;
      if (this.isNonNegative) return this;
      if (this.isNonPositive) return this.neg();
      return this.engine._fn("Abs", [this]);
    }
    add(rhs) {
      if (rhs === 0) return this;
      return add3(this.canonical, this.engine.box(rhs));
    }
    mul(rhs) {
      if (rhs === 0) return this.engine.Zero;
      if (rhs === 1) return this;
      if (rhs === -1) return this.neg();
      if (rhs instanceof NumericValue) {
        if (rhs.isZero) return this.engine.Zero;
        if (rhs.isOne) return this.canonical;
        if (rhs.isNegativeOne) return this.neg();
      }
      return mul3(this.canonical, this.engine.box(rhs));
    }
    div(rhs) {
      return div2(this, rhs);
    }
    pow(exp2) {
      return pow2(this, exp2, { numericApproximation: false });
    }
    root(exp2) {
      if (!this.isCanonical) return this.canonical.root(exp2);
      if (typeof exp2 !== "number") exp2 = exp2.canonical;
      const e = typeof exp2 === "number" ? exp2 : exp2.im === 0 ? exp2.re : void 0;
      if (e === 0) return this.engine.NaN;
      if (e === 1) return this;
      if (e === -1) return this.inv();
      if (e === 2) return this.engine.function("Sqrt", [this]);
      if (this.operator === "Power" && e !== void 0) {
        const [base, power] = this.ops;
        return base.pow(power.div(e));
      }
      if (this.operator === "Divide") {
        const [num, denom] = this.ops;
        return num.root(exp2).div(denom.root(exp2));
      }
      if (this.operator === "Negate") {
        if (e !== void 0) {
          if (e % 2 === 0) return this.op1.root(exp2);
          return this.op1.root(exp2).neg();
        }
      }
      if (this.operator === "Sqrt") {
        if (e !== void 0) return this.op1.root(e + 2);
        if (typeof exp2 !== "number") return this.op1.root(exp2.add(2));
      }
      if (this.operator === "Multiply") {
        const ops = this.ops.map((x) => x.root(exp2));
        return mul3(...ops);
      }
      if (this.operator === "Root") {
        const [base, root2] = this.ops;
        return base.root(root2.mul(exp2));
      }
      if (this.isNumberLiteral) {
        const v = this.numericValue;
        if (typeof v === "number") {
          if (v < 0) return this.engine.NaN;
          if (v === 0) return this.engine.Zero;
          if (v === 1) return this.engine.One;
          if (e !== void 0) {
            const r = this.engine.number(Math.pow(v, 1 / e));
            if (!r.isFinite || r.isInteger) return r;
          }
        } else {
          if (v.isOne) return this.engine.One;
          if (v.isZero) return this.engine.Zero;
          if (e !== void 0) {
            const r = v.root(e);
            if (r.isExact) return this.engine.number(r);
          }
        }
      }
      return this.engine._fn("Root", [this, this.engine.box(exp2)]);
    }
    sqrt() {
      return this.root(2);
    }
    ln(semiBase) {
      const base = semiBase ? this.engine.box(semiBase) : void 0;
      if (!this.isCanonical) return this.canonical.ln(base);
      if (this.is(0)) return this.engine.NegativeInfinity;
      if (this.operator === "Exp") return this.op1;
      if (base && this.isSame(base)) return this.engine.One;
      if (!base && this.isSame(this.engine.E)) return this.engine.One;
      if (this.operator === "Power") {
        const [b, exp2] = this.ops;
        if (b.isSame(this.engine.E)) return exp2;
        return exp2.mul(b.ln(base));
      }
      if (this.operator === "Root") {
        const [a, b] = this.ops;
        return b.div(a.ln(base));
      }
      if (this.operator === "Sqrt") return this.op1.ln(base).div(2);
      if (this.operator === "Divide")
        return this.op1.ln(base).sub(this.op2.ln(base));
      if (base && base.type.matches("finite_integer")) {
        if (base.re === 10) return this.engine._fn("Log", [this]);
        return this.engine._fn("Log", [this, base]);
      }
      return this.engine._fn("Ln", [this]);
    }
    //
    // CANONICAL OPERATIONS
    //
    // These operations apply only to canonical expressions
    //
    get complexity() {
      if (!this.isCanonical) return void 0;
      return this.functionDefinition?.complexity ?? DEFAULT_COMPLEXITY;
    }
    get baseDefinition() {
      return this._def;
    }
    get functionDefinition() {
      return this._def;
    }
    get isNumber() {
      const t = this.type.type;
      if (t === "unknown") return void 0;
      return isSubtype(t, "number");
    }
    get isInteger() {
      const t = this.type.type;
      if (t === "unknown") return void 0;
      return isSubtype(t, "integer");
    }
    get isRational() {
      const t = this.type.type;
      if (t === "unknown") return void 0;
      return isSubtype(t, "rational");
    }
    get isReal() {
      const t = this.type.type;
      if (t === "unknown") return void 0;
      return isSubtype(t, "real");
    }
    get isFunctionExpression() {
      return true;
    }
    /** The type of the value of the function */
    get type() {
      const gen = this.isPure && this._ops.every((x) => x.isConstant) ? void 0 : this.engine.generation;
      return cachedValue(this._type, gen, () => {
        const t = type(this);
        return t ? new BoxedType(t) : void 0;
      }) ?? BoxedType.unknown;
    }
    simplify(options) {
      return simplify(this, options).at(-1)?.value ?? this;
    }
    evaluate(options) {
      return cachedValue(
        options?.numericApproximation ? this._valueN : this._value,
        this.engine.generation,
        withDeadline(this.engine, this._computeValue(options))
      );
    }
    evaluateAsync(options) {
      return cachedValueAsync(
        options?.numericApproximation ? this._valueN : this._value,
        this.engine.generation,
        withDeadlineAsync(this.engine, this._computeValueAsync(options))
      );
    }
    N() {
      return this.evaluate({ numericApproximation: true });
    }
    solve(vars) {
      const varNames = normalizedUnknownsForSolve(vars ?? this.unknowns);
      if (varNames.length !== 1) return null;
      return findUnivariateRoots(this, varNames[0]);
    }
    get isCollection() {
      const def = this.functionDefinition;
      if (!def) return false;
      return def.collection?.contains !== void 0 || def.collection?.size !== void 0;
    }
    contains(rhs) {
      return this.functionDefinition?.collection?.contains?.(this, rhs) ?? false;
    }
    get size() {
      return this.functionDefinition?.collection?.size?.(this) ?? 0;
    }
    each(start, count) {
      const iter = this.functionDefinition?.collection?.iterator?.(
        this,
        start,
        count
      );
      if (!iter)
        return {
          next() {
            return { done: true, value: void 0 };
          }
        };
      return iter;
    }
    at(index) {
      return this.functionDefinition?.collection?.at?.(this, index);
    }
    get(index) {
      if (typeof index === "string")
        return this.functionDefinition?.collection?.at?.(this, index);
      if (!index.string) return void 0;
      return this.functionDefinition?.collection?.at?.(this, index.string);
    }
    indexOf(expr) {
      return this.functionDefinition?.collection?.indexOf?.(this, expr) ?? -1;
    }
    subsetOf(rhs, strict) {
      return this.functionDefinition?.collection?.subsetOf?.(this, rhs, strict) ?? false;
    }
    _computeValue(options) {
      return () => {
        if (!this.isValid) return this;
        const numericApproximation = options?.numericApproximation ?? false;
        if (numericApproximation) {
          const h = this.operator;
          if (h === "Integrate" || h === "Limit")
            return this.engine.box(["N", this], { canonical: true }).evaluate(options);
        }
        if (!this.isCanonical) {
          this.engine.pushScope();
          const canonical2 = this.canonical;
          this.engine.popScope();
          if (!canonical2.isCanonical || !canonical2.isValid) return this;
          return canonical2.evaluate(options);
        }
        const def = this.functionDefinition;
        if (def?.threadable && this.ops.some((x) => isFiniteIndexableCollection(x))) {
          const items = zip(this._ops);
          if (!items) return this.engine.Nothing;
          const results = [];
          while (true) {
            const { done, value } = items.next();
            if (done) break;
            results.push(this.engine._fn(this.operator, value).evaluate(options));
          }
          if (results.length === 0) return this.engine.Nothing;
          if (results.length === 1) return results[0];
          return this.engine._fn("List", results);
        }
        const tail = holdMap(this, (x) => x.evaluate(options));
        if (def) {
          const engine = this.engine;
          const context = engine.swapScope(this.scope);
          const evaluateFn = def.evaluate?.(tail, {
            numericApproximation,
            engine
          });
          engine.swapScope(context);
          return evaluateFn ?? this.engine.function(this._name, tail);
        }
        return this.engine.function(this._name, tail);
      };
    }
    _computeValueAsync(options) {
      return async () => {
        if (!this.isValid) return this;
        const numericApproximation = options?.numericApproximation ?? false;
        if (numericApproximation) {
          const h = this.operator;
          if (h === "Integrate" || h === "Limit")
            this.engine.box(["N", this], { canonical: true }).evaluateAsync(options);
        }
        if (!this.isCanonical) {
          this.engine.pushScope();
          const canonical2 = this.canonical;
          this.engine.popScope();
          if (!canonical2.isCanonical || !canonical2.isValid) return this;
          return canonical2.evaluateAsync(options);
        }
        const def = this.functionDefinition;
        if (def?.threadable && this.ops.some((x) => isFiniteIndexableCollection(x))) {
          const items = zip(this._ops);
          if (!items) return this.engine.Nothing;
          const results = [];
          while (true) {
            const { done, value } = items.next();
            if (done) break;
            results.push(
              this.engine._fn(this.operator, value).evaluateAsync(options)
            );
          }
          if (results.length === 0) return this.engine.Nothing;
          if (results.length === 1) return results[0];
          return Promise.all(results).then(
            (resolved) => this.engine._fn("List", resolved)
          );
        }
        const tail = await holdMapAsync(
          this,
          async (x) => await x.evaluateAsync(options)
        );
        if (def) {
          const engine = this.engine;
          const context = engine.swapScope(this.scope);
          const opts = { numericApproximation, engine, signal: options?.signal };
          const evaluateFn = def.evaluateAsync?.(tail, opts) ?? def.evaluate?.(tail, opts);
          engine.swapScope(context);
          return Promise.resolve(evaluateFn).then(
            (result) => result ?? this.engine.function(this._name, tail)
          );
        }
        return Promise.resolve(this.engine.function(this._name, tail));
      };
    }
  };
  function type(expr) {
    if (!expr.isValid) return "error";
    if (expr.operator === "Function") {
      const body = expr.ops[0];
      const bodyType = body.type;
      const args = expr.ops.slice(1);
      return parseType(`(${args.map((x) => "any").join(", ")}) -> ${bodyType}`);
    }
    const def = expr.functionDefinition;
    if (def) {
      const sig = def.signature instanceof BoxedType ? def.signature.type : typeof def.signature === "string" ? parseType(def.signature) : def.signature;
      let sigResult = functionResult(sig) ?? "unknown";
      if (typeof def.type === "function") {
        const calculatedType = def.type(expr.ops, { engine: expr.engine });
        if (calculatedType) {
          if (calculatedType instanceof BoxedType)
            sigResult = calculatedType.type;
          else sigResult = parseType(calculatedType) ?? sigResult;
        }
      }
      return sigResult;
    }
    return "function";
  }
  function withDeadline(engine, fn) {
    return () => {
      if (engine._deadline === void 0) {
        engine._deadline = Date.now() + engine.timeLimit;
        const result = fn();
        engine._deadline = void 0;
        return result;
      }
      return fn();
    };
  }
  function withDeadlineAsync(engine, fn) {
    return async () => {
      if (engine._deadline === void 0) {
        engine._deadline = Date.now() + engine.timeLimit;
        const result = await fn();
        engine._deadline = void 0;
        return result;
      }
      return fn();
    };
  }

  // src/compute-engine/boxed-expression/boxed-string.ts
  var BoxedString = class _BoxedString extends _BoxedExpression {
    constructor(ce, expr, metadata) {
      super(ce, metadata);
      this._string = expr.normalize();
      ce._register(this);
    }
    get json() {
      return `'${this._string}'`;
    }
    get hash() {
      return hashCode("String" + this._string);
    }
    get operator() {
      return "String";
    }
    get isPure() {
      return true;
    }
    get isCanonical() {
      return true;
    }
    set isCanonical(_va) {
      return;
    }
    get type() {
      return new BoxedType("string");
    }
    get complexity() {
      return 19;
    }
    get string() {
      return this._string;
    }
    match(pattern, _options) {
      if (!isBoxedExpression(pattern))
        pattern = this.engine.box(pattern, { canonical: false });
      if (isWildcard(pattern)) return { [wildcardName(pattern)]: this };
      if (!(pattern instanceof _BoxedString)) return null;
      if (this._string === pattern._string) return {};
      return null;
    }
    get isCollection() {
      return true;
    }
    contains(rhs) {
      if (!rhs.string) return false;
      return this._string.includes(rhs.string);
    }
    get size() {
      return this._string.length;
    }
    each(start, count) {
      const data = this.string;
      let index = start ?? 1;
      count = Math.min(count ?? data.length, data.length);
      if (count <= 0) return { next: () => ({ value: void 0, done: true }) };
      return {
        next: () => {
          if (count > 0) {
            count--;
            return { value: this.engine.string(data[index++ - 1]), done: false };
          } else {
            return { value: void 0, done: true };
          }
        }
      };
    }
    at(index) {
      return this.engine.string(this._string[index - 1]);
    }
    get(key) {
      return void 0;
    }
    indexOf(expr) {
      if (!expr.string) return -1;
      return this._string.indexOf(expr.string);
    }
  };

  // src/compute-engine/boxed-expression/boxed-tensor.ts
  var BoxedTensor = class _BoxedTensor extends _BoxedExpression {
    constructor(ce, input, options) {
      super(ce, options?.metadata);
      this.options = options;
      if (input instanceof AbstractTensor) {
        this._tensor = input;
      } else {
        const isCanonical = options?.canonical ?? true;
        this._operator = input.op ?? "List";
        this._ops = isCanonical ? canonical(ce, input.ops) : input.ops;
        this._expression = ce._fn(this._operator, this._ops, {
          canonical: isCanonical
        });
      }
      ce._register(this);
    }
    get structural() {
      this._expression ?? (this._expression = this._tensor.expression);
      return this._expression;
    }
    /** Create the tensor on demand */
    get tensor() {
      if (this._tensor === void 0) {
        console.assert(this._operator !== void 0);
        console.assert(this._ops !== void 0);
        const tensorData = expressionAsTensor(this._operator, this._ops);
        if (tensorData === void 0) {
          const t2 = expressionAsTensor(this._operator, this._ops);
          throw new Error("Invalid tensor");
        }
        this._tensor = makeTensor(this.engine, tensorData);
      }
      return this._tensor;
    }
    get baseDefinition() {
      return this.structural.baseDefinition;
    }
    get functionDefinition() {
      return this.structural.functionDefinition;
    }
    bind() {
      this.structural.bind();
    }
    reset() {
    }
    get hash() {
      const h = hashCode("BoxedTensor");
      return h;
    }
    get canonical() {
      if (this.isCanonical) return this;
      return new _BoxedTensor(
        this.engine,
        { op: this._operator, ops: this._ops },
        { canonical: true }
      );
    }
    get isCanonical() {
      if (this._tensor) return true;
      return this._expression.isCanonical;
    }
    set isCanonical(val) {
      if (!this._tensor) this.structural.isCanonical = val;
    }
    get isPure() {
      if (this._tensor) return true;
      return this.structural.isPure;
    }
    get isValid() {
      if (this._tensor) return true;
      return this.structural.isValid;
    }
    get complexity() {
      return 97;
    }
    get operator() {
      return this._tensor ? "List" : this._operator;
    }
    get nops() {
      if (this._tensor) return this._tensor.shape[0];
      return this.structural.nops;
    }
    get ops() {
      return this.structural.ops;
    }
    get op1() {
      if (this._tensor) {
        const data = this._tensor.data;
        if (data.length === 0) return this.engine.Nothing;
        return this.engine.box(data[0]);
      }
      return this.structural.op1;
    }
    get op2() {
      if (this._tensor) {
        const data = this._tensor.data;
        if (data.length < 2) return this.engine.Nothing;
        return this.engine.box(data[1]);
      }
      return this.structural.op2;
    }
    get op3() {
      if (this._tensor) {
        const data = this._tensor.data;
        if (data.length < 3) return this.engine.Nothing;
        return this.engine.box(data[2]);
      }
      return this.structural.op3;
    }
    //
    //
    // ALGEBRAIC OPERATIONS
    //
    neg() {
      return this.structural.neg();
    }
    inv() {
      return this.engine.One.div(this.structural);
    }
    abs() {
      return this.structural.abs();
    }
    add(rhs) {
      return this.structural.add(rhs);
    }
    sub(rhs) {
      return this.structural.sub(rhs);
    }
    mul(rhs) {
      return this.structural.mul(rhs);
    }
    div(rhs) {
      return this.structural.div(rhs);
    }
    pow(exp2) {
      return this.structural.pow(exp2);
    }
    root(exp2) {
      return this.structural.root(exp2);
    }
    sqrt() {
      return this.structural.sqrt();
    }
    get shape() {
      return this.tensor.shape;
    }
    get rank() {
      return this.tensor.rank;
    }
    get type() {
      return new BoxedType(this.isValid ? parseType("list<number>") : "error");
    }
    get json() {
      return this.structural.json;
    }
    /** Mathematical equality */
    isEqual(rhs) {
      if (this === rhs) return true;
      if (rhs instanceof _BoxedTensor) return this.tensor.equals(rhs.tensor);
      return this.structural.isEqual(rhs);
    }
    get isCollection() {
      return true;
    }
    contains(rhs) {
      const data = this.tensor.data;
      const target = this.tensor.field.cast(rhs, this.tensor.dtype);
      if (typeof target === "number") return data.includes(target);
      const items = data.map(
        (x) => this.tensor.field.cast(x, "expression") ?? rhs.engine.Nothing
      );
      for (const item of items) if (rhs.isSame(item)) return true;
      return false;
    }
    get size() {
      return this.tensor.shape.reduce((a, b) => a * b, 1);
    }
    each(start, count) {
      const data = this.tensor.data;
      let index = start ?? 1;
      count = Math.min(count ?? data.length, data.length);
      if (count <= 0) return { next: () => ({ value: void 0, done: true }) };
      return {
        next: () => {
          if (count > 0) {
            count--;
            return { value: this.engine.box(data[index++ - 1]), done: false };
          } else {
            return { value: void 0, done: true };
          }
        }
      };
    }
    at(_index) {
      return void 0;
    }
    indexOf(_expr) {
      return -1;
    }
    match(pattern, options) {
      if (!isBoxedExpression(pattern))
        pattern = this.engine.box(pattern, { canonical: false });
      if (isWildcard(pattern)) return { [wildcardName(pattern)]: this };
      return this.structural.match(pattern, options);
    }
    evaluate(options) {
      if (this._tensor) return this;
      return this.structural.evaluate(options);
    }
    simplify(options) {
      if (this._tensor) return this;
      return this.structural.simplify(options);
    }
    N() {
      if (this._tensor) return this;
      return this.structural.N();
    }
  };
  function isBoxedTensor(val) {
    return val instanceof BoxedTensor;
  }
  function expressionTensorInfo(operator2, rows) {
    let dtype = void 0;
    const shape = [];
    let valid = true;
    const visit = (t, axis = 0) => {
      if (t.length === 0) return;
      if (t.length > 1 && shape[axis] !== void 0)
        valid = valid && shape[axis] === t.length;
      else shape[axis] = Math.max(shape[axis] ?? 0, t.length);
      for (const item of t) {
        if (item.operator === operator2) visit(item.ops, axis + 1);
        else dtype = getSupertype(dtype, getExpressionDatatype(item));
        if (!valid) return;
      }
    };
    visit(rows);
    return valid ? { shape, dtype } : void 0;
  }
  function expressionAsTensor(operator2, rows) {
    const { shape, dtype } = expressionTensorInfo(operator2, rows) ?? {
      shape: [],
      dtype: void 0
    };
    if (dtype === void 0) return void 0;
    let isValid = true;
    const data = [];
    const f = makeTensorField(rows[0].engine, "expression");
    const cast = f.cast.bind(f);
    const visit = (t) => {
      for (const item of t) {
        if (item.operator === operator2) visit(item.ops);
        else {
          const v = cast(item, dtype);
          if (v === void 0) {
            isValid = false;
            return;
          }
          data.push(v);
        }
      }
    };
    visit(rows);
    if (!isValid) return void 0;
    return { shape, rank: shape.length, data, dtype };
  }

  // src/compute-engine/library/invisible-operator.ts
  function canonicalInvisibleOperator(ops, { engine: ce }) {
    if (ops.length === 0) return null;
    const lhs = ops[0];
    if (ops.length === 1) return lhs.canonical;
    if (ops.length === 2) {
      const lhsInteger = asInteger(lhs);
      if (!Number.isNaN(lhsInteger)) {
        const rhs2 = ops[1];
        if (rhs2.operator === "Divide" || rhs2.operator === "Rational") {
          const [n, d] = [rhs2.op1.canonical.re, rhs2.op2.canonical.re];
          if (n > 0 && n <= 1e3 && d > 1 && d <= 1e3 && Number.isInteger(n) && Number.isInteger(d)) {
            let frac = rhs2.canonical;
            if (lhsInteger < 0) frac = frac.neg();
            return ce._fn("Add", [lhs.canonical, frac]);
          }
        }
      }
      const rhs = ops[1];
      if (!Number.isNaN(lhsInteger)) {
        const canonicalRhs = rhs.canonical;
        if (canonicalRhs.re === 0 && canonicalRhs.im === 1)
          return ce.number(ce.complex(0, lhsInteger));
      }
      if (lhs.symbol && rhs.operator === "Delimiter") {
        if (rhs.nops === 0) {
          if (!ce.lookupFunction(lhs.symbol)) ce.declare(lhs.symbol, "function");
          return ce.box([lhs.symbol]);
        }
        let args = rhs.op1.operator === "Sequence" ? rhs.op1.ops : [rhs.op1];
        args = flatten(args);
        if (!ce.lookupSymbol(lhs.symbol)) {
          if (!ce.lookupFunction(lhs.symbol)) ce.declare(lhs.symbol, "function");
          return ce.function(lhs.symbol, args);
        }
      }
      if (lhs.symbol && rhs.operator === "Delimiter" && (rhs.op2.string === "[,]" || rhs.op2.string === "[;]")) {
        const args = rhs.op1.operator === "Sequence" ? rhs.op1.ops : [rhs.op1];
        return ce.function("At", [lhs, ...args]);
      }
    }
    ops = flattenInvisibleOperator(ops);
    ops = flatten(ops);
    if (ops.every(
      (x) => x.isValid && (x.type.isUnknown || x.type.matches("number") || isIndexableCollection(x) && !x.string)
    )) {
      return ce._fn("Multiply", ops);
    }
    return ce._fn("Tuple", ops);
  }
  function flattenInvisibleOperator(ops) {
    const ys = [];
    for (const x of ops) {
      if (x.operator === "InvisibleOperator")
        ys.push(...flattenInvisibleOperator(x.ops));
      else ys.push(x);
    }
    return ys;
  }
  function asInteger(expr) {
    if (expr.isNumberLiteral) {
      const n = expr.re;
      if (Number.isInteger(n)) return n;
    }
    if (expr.operator === "Negate") {
      const n = asInteger(expr.op1);
      if (!Number.isNaN(n)) return -n;
    }
    return Number.NaN;
  }

  // src/compute-engine/boxed-expression/canonical.ts
  function canonicalForm(expr, forms) {
    if (forms === false) return expr;
    if (forms === true) return expr.canonical;
    if (typeof forms === "string") forms = [forms];
    for (const form of forms) {
      switch (form) {
        // @todo: consider additional forms: "Symbol", "Tensor"
        case "InvisibleOperator":
          expr = invisibleOperatorForm(expr);
          break;
        case "Number":
          expr = numberForm(expr);
          break;
        case "Multiply":
          expr = multiplyForm(expr);
          break;
        case "Add":
          expr = addForm(expr);
          break;
        case "Power":
          expr = powerForm(expr);
          break;
        case "Divide":
          expr = divideForm(expr);
          break;
        case "Flatten":
          expr = flattenForm(expr);
          break;
        case "Order":
          expr = canonicalOrder(expr, { recursive: true });
          break;
        default:
          throw Error("Invalid canonical form");
      }
    }
    return expr;
  }
  function flattenForm(expr) {
    if (!expr.operator) return expr;
    if (!expr.ops || expr.nops === 0) return expr;
    if (expr.operator === "Delimiter") return flattenForm(expr.op1);
    const ce = expr.engine;
    let isAssociative = expr.operator === "Add" || expr.operator === "Multiply";
    if (!isAssociative) {
      const def = ce.lookupFunction(expr.operator);
      if (def?.associative) isAssociative = true;
    }
    if (isAssociative)
      return ce.function(
        expr.operator,
        flattenOps(expr.ops.map(flattenForm), expr.operator)
      );
    return expr;
  }
  function invisibleOperatorForm(expr) {
    if (!expr.ops) return expr;
    if (expr.operator === "InvisibleOperator") {
      return canonicalInvisibleOperator(expr.ops.map(invisibleOperatorForm), {
        engine: expr.engine
      }) ?? expr;
    }
    return expr.engine._fn(expr.operator, expr.ops.map(invisibleOperatorForm));
  }
  function numberForm(expr) {
    if (expr.isNumberLiteral) return expr.canonical;
    if (expr.ops) return expr.engine._fn(expr.operator, expr.ops.map(numberForm));
    return expr;
  }
  function multiplyForm(expr) {
    if (!expr.ops) return expr;
    const ops = expr.ops.map(multiplyForm);
    if (expr.operator === "Multiply")
      return canonicalMultiply(
        expr.engine,
        ops.map((x) => x.canonical)
      );
    if (expr.operator === "Negate")
      return canonicalMultiply(expr.engine, [ops[0], expr.engine.NegativeOne]);
    return expr;
  }
  function addForm(expr) {
    if (!expr.ops) return expr;
    const ops = expr.ops.map(addForm);
    if (expr.operator === "Add") return canonicalAdd(expr.engine, ops);
    if (expr.operator === "Subtract")
      return canonicalAdd(expr.engine, [ops[0], ops[1].neg()]);
    return expr.engine._fn(expr.operator, ops);
  }
  function powerForm(expr) {
    if (!expr.ops) return expr;
    if (expr.operator === "Power")
      return powerForm(expr.op1).pow(powerForm(expr.op2));
    if (!expr.ops) return expr;
    return expr.engine._fn(expr.operator, expr.ops.map(powerForm));
  }
  function divideForm(expr) {
    if (expr.operator === "Divide")
      return canonicalDivide(powerForm(expr.op1), powerForm(expr.op2));
    if (!expr.ops) return expr;
    return expr.engine._fn(expr.operator, expr.ops.map(divideForm));
  }

  // src/compute-engine/boxed-expression/box.ts
  function boxHold(ce, expr, options) {
    if (expr instanceof _BoxedExpression) return expr;
    expr = missingIfEmpty(expr);
    if (typeof expr === "string") return box(ce, expr, options);
    if (Array.isArray(expr)) {
      const [fnName, ...ops] = expr;
      return new BoxedFunction(
        ce,
        fnName,
        ops.map((x) => boxHold(ce, x, options))
      );
    }
    if (typeof expr === "object") {
      if ("fn" in expr) return boxHold(ce, expr.fn, options);
      if ("str" in expr) return new BoxedString(ce, expr.str);
      if ("sym" in expr) return box(ce, expr.sym, options);
      if ("num" in expr) return box(ce, expr.num, options);
    }
    return box(ce, expr, options);
  }
  function boxFunction(ce, name, ops, options) {
    options = options ? { ...options } : {};
    if (!("canonical" in options)) options.canonical = true;
    if (!isValidIdentifier(name)) {
      throw new Error(
        `Unexpected function name: "${name}" (not a valid identifier: ${validateIdentifier(name)})`
      );
    }
    const structural = options.structural ?? false;
    if (name === "Hold") {
      return new BoxedFunction(ce, "Hold", [boxHold(ce, ops[0], options)], {
        ...options,
        canonical: true,
        structural
      });
    }
    if (name === "Error" || name === "ErrorCode") {
      return ce._fn(
        name,
        ops.map((x) => ce.box(x, { canonical: false })),
        options.metadata
      );
    }
    if (name === "String") {
      if (ops.length === 0) return new BoxedString(ce, "", options.metadata);
      return new BoxedString(
        ce,
        ops.map((x) => asString(x) ?? "").join(""),
        options.metadata
      );
    }
    if (name === "Symbol" && ops.length > 0) {
      return ce.symbol(ops.map((x) => asString(x) ?? "").join(""), options);
    }
    if (name === "Number" && ops.length === 1) return box(ce, ops[0], options);
    const canonicalNumber2 = structural === false && (options.canonical === true || options.canonical === "Number" || Array.isArray(options.canonical) && options.canonical.includes("Number"));
    if (canonicalNumber2) {
      if ((name === "Divide" || name === "Rational") && ops.length === 2) {
        const n = toBigint(ops[0]);
        if (n !== null) {
          const d = toBigint(ops[1]);
          if (d !== null) return ce.number([n, d], options);
        }
        name = "Divide";
      }
      if (name === "Complex") {
        if (ops.length === 1) {
          const op1 = ops[0];
          if (op1 instanceof _BoxedExpression && op1.isNumberLiteral)
            return ce.number(ce.complex(0, op1.re), options);
          const im = machineValue(ops[0]);
          if (im !== null && im !== 0)
            return ce.number(ce.complex(0, im), options);
          return ce.box(op1).mul(ce.I);
        }
        if (ops.length === 2) {
          const re = ops[0] instanceof _BoxedExpression ? ops[0].re : machineValue(ops[0]);
          const im = ops[1] instanceof _BoxedExpression ? ops[1].re : machineValue(ops[1]);
          if (im !== null && re !== null && !isNaN(im) && !isNaN(re)) {
            if (im === 0 && re === 0) return ce.Zero;
            if (im !== 0) return ce.number(ce._numericValue({ re, im }), options);
            return box(ce, ops[0], options);
          }
          return box(ce, ops[0], options).add(box(ce, ops[1], options).mul(ce.I));
        }
        throw new Error("Expected one or two arguments with Complex expression");
      }
      if (name === "Negate" && ops.length === 1) {
        const op1 = ops[0];
        if (typeof op1 === "number") return ce.number(-op1, options);
        if (op1 instanceof Decimal) return ce.number(op1.neg(), options);
        const boxedop1 = ce.box(op1, options);
        const num = boxedop1.numericValue;
        if (num !== null)
          return ce.number(typeof num === "number" ? -num : num.neg(), options);
        ops = [boxedop1];
      }
    }
    if (options.canonical === true)
      return makeCanonicalFunction(ce, name, ops, options.metadata);
    return canonicalForm(
      new BoxedFunction(
        ce,
        name,
        ops.map(
          (x) => box(ce, x, {
            canonical: options.canonical,
            structural
          })
        ),
        {
          metadata: options.metadata,
          canonical: false,
          structural
        }
      ),
      options.canonical ?? false
    );
  }
  function box(ce, expr, options) {
    if (expr === null || expr === void 0) return ce.error("missing");
    if (expr instanceof NumericValue) return fromNumericValue(ce, expr);
    if (expr instanceof _BoxedExpression)
      return canonicalForm(expr, options?.canonical ?? true);
    options = options ? { ...options } : {};
    if (!("canonical" in options)) options.canonical = true;
    const canonical2 = options.canonical === true;
    const structural = options.structural ?? false;
    if (Array.isArray(expr)) {
      if (typeof expr[0] !== "string")
        throw new Error(
          `The first element of an array should be a string (the function name): ${JSON.stringify(expr)}`
        );
      return canonicalForm(
        boxFunction(ce, expr[0], expr.slice(1), {
          canonical: canonical2,
          structural
        }),
        options.canonical
      );
    }
    if (typeof expr === "number" || expr instanceof Decimal || expr instanceof Complex)
      return ce.number(expr);
    if (typeof expr === "string") {
      if (expr.startsWith("'") && expr.endsWith("'"))
        return new BoxedString(ce, expr.slice(1, -1));
      let s = expr;
      s = s.replace(/[\u0009-\u000d\u0020\u00a0]/g, "");
      if (/^[+-]?[0-9]/.test(s)) {
        const result = ce.number(expr);
        if (!result.isNaN) return result;
      }
      if (!isValidIdentifier(expr)) return ce.error("invalid-identifier", expr);
      return ce.symbol(expr, { canonical: canonical2 });
    }
    if (typeof expr === "object") {
      if ("fn" in expr) {
        const [fnName, ...ops] = expr.fn;
        return canonicalForm(
          boxFunction(ce, fnName, ops, { canonical: canonical2, structural }),
          options.canonical
        );
      }
      if ("str" in expr) return new BoxedString(ce, expr.str);
      if ("sym" in expr) return ce.symbol(expr.sym, { canonical: canonical2 });
      if ("num" in expr) return ce.number(expr, { canonical: canonical2 });
      throw new Error(`Unexpected MathJSON object: ${JSON.stringify(expr)}`);
    }
    return ce.symbol("Undefined");
  }
  function asString(expr) {
    if (typeof expr === "string") return expr;
    if (expr instanceof _BoxedExpression) {
      return expr.string ?? expr.symbol ?? expr.toString();
    }
    if (typeof expr === "object") {
      if ("str" in expr) return expr.str;
      if ("fn" in expr && expr.fn[0] === "String" && typeof expr.fn[1] === "string")
        return expr.fn[1];
    }
    if (Array.isArray(expr)) {
      if (expr[0] === "String" && typeof expr[1] === "string") return expr[1];
    }
    return null;
  }
  function makeCanonicalFunction(ce, name, ops, metadata) {
    const result = makeNumericFunction(ce, name, ops, metadata);
    if (result) return result;
    if (name === "List") {
      const boxedOps = ops.map((x) => ce.box(x));
      const { shape, dtype } = expressionTensorInfo("List", boxedOps) ?? {};
      if (dtype && shape)
        return new BoxedTensor(ce, { op: "List", ops: boxedOps });
      return ce._fn("List", boxedOps);
    }
    const def = ce.lookupFunction(name);
    if (!def) {
      return new BoxedFunction(ce, name, flatten(canonical(ce, ops)), {
        metadata,
        canonical: true
      });
    }
    if (def.lazy) {
      const xs2 = ops.map((x) => ce.box(x, { canonical: false }));
      if (def.canonical) {
        try {
          const result2 = def.canonical(xs2, { engine: ce });
          if (result2) return result2;
        } catch (e) {
          console.error(e.message);
        }
        return new BoxedFunction(ce, name, xs2, { metadata, canonical: false });
      }
      return ce._fn(
        name,
        validateArguments(ce, xs2, def.signature.type, def.lazy, def.threadable) ?? xs2,
        metadata
      );
    }
    const xs = ops.map((x) => ce.box(x));
    if (def.canonical) {
      try {
        const result2 = def.canonical(xs, { engine: ce });
        if (result2) return result2;
      } catch (e) {
        console.error(e.message);
      }
      return new BoxedFunction(ce, name, xs, { metadata, canonical: false });
    }
    const args = flatten(
      xs,
      def.associative ? name : void 0
    );
    const adjustedArgs = validateArguments(
      ce,
      args,
      def.signature.type,
      def.lazy,
      def.threadable
    );
    if (adjustedArgs) return ce._fn(name, adjustedArgs, metadata);
    if (args.length === 1 && args[0].operator === name) {
      if (def.involution) return args[0].op1;
      if (def.idempotent) return ce._fn(name, xs[0].ops, metadata);
    }
    return ce._fn(name, sortOperands(name, args), metadata);
  }
  function makeNumericFunction(ce, name, semiOps, metadata) {
    let ops = [];
    if (name === "Add" || name === "Multiply")
      ops = checkNumericArgs(ce, semiCanonical(ce, semiOps), { flatten: name });
    else if (name === "Negate" || name === "Square" || name === "Sqrt" || name === "Exp")
      ops = checkNumericArgs(ce, semiCanonical(ce, semiOps), 1);
    else if (name === "Ln" || name === "Log") {
      ops = checkNumericArgs(ce, semiCanonical(ce, semiOps));
      if (ops.length === 0) ops = [ce.error("missing")];
    } else if (name === "Power" || name === "Root")
      ops = checkNumericArgs(ce, semiCanonical(ce, semiOps), 2);
    else if (name === "Divide") {
      ops = checkNumericArgs(ce, semiCanonical(ce, semiOps));
      if (ops.length === 0) ops = [ce.error("missing"), ce.error("missing")];
      if (ops.length === 1) ops = [ops[0], ce.error("missing")];
    } else return null;
    if (!ops.every((x) => x.isValid)) return ce._fn(name, ops, metadata);
    if (name === "Add") return canonicalAdd(ce, ops);
    if (name === "Negate") return canonicalNegate(ops[0]);
    if (name === "Multiply") return canonicalMultiply(ce, ops);
    if (name === "Divide") {
      if (ops.length === 2)
        return canonicalDivide(...ops);
      return ops.slice(1).reduce((a, b) => canonicalDivide(a, b), ops[0]);
    }
    if (name === "Exp") return canonicalPower(ce.E, ops[0]);
    if (name === "Square") return canonicalPower(ops[0], ce.number(2));
    if (name === "Power") return canonicalPower(ops[0], ops[1]);
    if (name === "Root") return canonicalRoot(ops[0], ops[1]);
    if (name === "Sqrt") return canonicalRoot(ops[0], 2);
    if (name === "Ln" || name === "Log") {
      if (ops.length > 0) {
        if (ops[0].is(1)) return ce.Zero;
        if (ops.length === 1) return ce._fn(name, ops, metadata);
      }
      return ce._fn("Log", ops, metadata);
    }
    return null;
  }
  function fromNumericValue(ce, value) {
    if (value.isZero) return ce.Zero;
    if (value.isOne) return ce.One;
    if (value.isNegativeOne) return ce.NegativeOne;
    if (value.isNaN) return ce.NaN;
    if (value.isNegativeInfinity) return ce.NegativeInfinity;
    if (value.isPositiveInfinity) return ce.PositiveInfinity;
    value = value.asExact ?? value;
    if (!value.isExact) {
      const im = value.im;
      if (im === 0) return ce.number(value.bignumRe ?? value.re);
      if (value.re === 0) return ce.number(ce.complex(0, im));
      if (value.bignumRe !== void 0 && !isInMachineRange(value.bignumRe)) {
        return canonicalAdd(ce, [
          ce.number(value.bignumRe),
          ce.number(ce.complex(0, im))
        ]);
      }
      return ce.number(ce.complex(value.re, value.im));
    }
    const terms = [];
    const exactValue = value;
    if (exactValue.sign !== 0) {
      if (exactValue.radical === 1) {
        terms.push(ce.number(exactValue.rational));
      } else {
        const rational = exactValue.rational;
        const radical = ce.function("Sqrt", [ce.number(exactValue.radical)]);
        if (isOne(rational)) terms.push(radical);
        else {
          const [n, d] = rational;
          if (d === 1) {
            if (n === 1) terms.push(radical);
            else terms.push(ce.function("Multiply", [ce.number(n), radical]));
          } else {
            if (n === 1)
              terms.push(ce.function("Divide", [radical, ce.number(d)]));
            else
              terms.push(
                ce.function("Divide", [
                  ce.function("Multiply", [ce.number(n), radical]),
                  ce.number(d)
                ])
              );
          }
        }
      }
    }
    let result;
    if (value.im === 0) {
      if (terms.length === 0) return ce.Zero;
      result = terms.length === 1 ? terms[0] : canonicalMultiply(ce, terms);
      return result;
    }
    if (terms.length === 0) return ce.number(ce.complex(0, value.im));
    result = terms.length === 1 ? terms[0] : canonicalMultiply(ce, terms);
    return canonicalAdd(ce, [result, ce.number(ce.complex(0, value.im))]);
  }
  function toBigint(x) {
    if (typeof x === "bigint") return x;
    if (typeof x === "number" && Number.isInteger(x)) return BigInt(x);
    if (x instanceof _BoxedExpression) return asBigint(x);
    if (x instanceof Decimal || typeof x === "string") return bigint(x);
    if (x instanceof Complex) {
      if (x.im === 0) return bigint(x.re);
      return null;
    }
    return bigintValue(x);
  }

  // src/compute-engine/symbolic/derivative.ts
  var DERIVATIVES_TABLE = {
    Sin: ["Cos", "_"],
    Cos: ["Negate", ["Sin", "_"]],
    Tan: ["Power", ["Sec", "_"], 2],
    Sec: ["Multiply", ["Tan", "_"], ["Sec", "_"]],
    Csc: ["Multiply", ["Negate", ["Cot", "_"]], ["Csc", "_"]],
    Cot: ["Negate", ["Power", ["Csc", "_"], 2]],
    Arcsin: ["Power", ["Subtract", 1, ["Power", "_", 2]], ["Negate", "Half"]],
    Arccos: [
      "Negate",
      ["Power", ["Subtract", 1, ["Power", "_", 2]], ["Negate", "Half"]]
    ],
    Arctan: ["Power", ["Add", 1, ["Power", "_", 2]], -1],
    Arcsec: [
      "Multiply",
      ["Power", ["Subtract", 1, ["Power", "_", 2]], ["Negate", "Half"]],
      ["Negate", ["Power", "_", 2]]
    ],
    Arccsc: [
      "Multiply",
      ["Power", ["Subtract", 1, ["Power", "_", 2]], ["Negate", "Half"]],
      ["Negate", ["Power", "_", 2]]
    ],
    Arccot: ["Negate", ["Power", ["Add", 1, ["Power", "_", 2]], -1]],
    Sinh: ["Cosh", "_"],
    Cosh: ["Sinh", "_"],
    Tanh: ["Power", ["Sech", "_"], 2],
    Sech: ["Multiply", ["Tanh", "_"], "Sech"],
    Csch: ["Multiply", ["Coth", "_"], "Csch"],
    Coth: ["Negate", ["Power", ["Csch", "_"], 2]],
    Arcsinh: ["Power", ["Add", ["Power", "_", 2], 1], ["Negate", "Half"]],
    Arccosh: ["Power", ["Subtract", ["Power", "_", 2], 1], ["Negate", "Half"]],
    Arctanh: ["Power", ["Subtract", 1, ["Power", "_", 2]], -1],
    Arcsech: [
      "Negate",
      [
        "Power",
        ["Multiply", "2", "Subtract", ["Power", "_", 2]],
        ["Negate", "Half"]
      ]
    ],
    Arccsch: [
      "Negate",
      ["Power", ["Multiply", "2", "Add", ["Power", "_", 2]], ["Negate", "Half"]]
    ],
    Arccoth: ["Negate", ["Power", ["Subtract", 1, ["Power", "_", 2]], -1]],
    // Exp: ['Exp', '_'],   // Gets canonicalized to Power
    Ln: ["Divide", 1, "_"],
    Log: ["Power", ["Multiply", "_", ["Ln", "10"]], -1],
    Sqrt: ["Multiply", ["Power", "_", ["Negate", "Half"]], "Half"],
    Abs: [
      "Which",
      ["Equal", "_", 0],
      NaN,
      ["Less", "_", 0],
      -1,
      ["Greater", "_", 0],
      1,
      "True",
      ["D", ["Abs", "_"], "_"]
    ],
    // https://proofwiki.org/wiki/Derivative_of_Error_Function
    Erf: [
      "Multiply",
      ["Divide", "2", ["Sqrt", "Pi"]],
      ["Exp", ["Negate", ["Square", "_"]]]
    ],
    // https://proofwiki.org/wiki/Derivative_of_Gamma_Function
    // https://en.wikipedia.org/wiki/Gamma_function
    Gamma: ["Multiply", ["Gamma", "_"], ["Digamma", "_"]],
    Digamma: [
      "Add",
      ["Multiply", ["Digamma", "_"], ["Gamma", "_"]],
      ["Multiply", ["Power", "_", -1], ["Gamma", "_"]]
    ],
    Zeta: ["Multiply", ["Multiply", -1, ["Zeta", "_"]], ["Digamma", "_"]],
    PolyGamma: [
      "Add",
      ["Multiply", ["PolyGamma", "_"], ["Gamma", "_"]],
      ["Multiply", ["Power", "_", -1], ["Gamma", "_"]]
    ],
    Beta: [
      "Multiply",
      [
        "Add",
        ["Multiply", ["Beta", "_"], ["Digamma", "_"]],
        ["Multiply", ["Power", "_", -1], ["Beta", "_"]]
      ],
      ["Beta", "_"]
    ],
    Erfc: [
      "Multiply",
      ["Negate", ["Erfc", "_"]],
      ["Exp", ["Negate", ["Power", "_", 2]]],
      ["Power", "_", -1]
    ],
    LambertW: [
      "Multiply",
      ["Power", "_", -1],
      [
        "Multiply",
        ["Add", "_", ["LambertW", "_"]],
        ["Add", ["LambertW", "_"], 1]
      ]
    ],
    AiryAi: ["Multiply", ["AiryAi", "_"], ["AiryBi", "_"]],
    AiryBi: ["Multiply", ["AiryAi", "_"], ["AiryBi", "_"]],
    BesselJ: ["Multiply", ["BesselJ", "_"], ["BesselY", "_"]],
    BesselY: ["Multiply", ["BesselJ", "_"], ["BesselY", "_"]],
    BesselI: ["Multiply", ["BesselI", "_"], ["BesselK", "_"]],
    BesselK: ["Multiply", ["BesselI", "_"], ["BesselK", "_"]],
    FresnelS: ["Multiply", ["FresnelS", "_"], ["FresnelC", "_"]],
    FresnelC: ["Multiply", ["FresnelS", "_"], ["FresnelC", "_"]],
    Erfi: ["Multiply", ["Erfi", "_"], ["Erf", "_"]]
  };
  function derivative(fn, order2) {
    if (order2 === 0) return fn;
    const ce = fn.engine;
    let v = "_";
    if (fn.symbol && fn.functionDefinition) {
      fn = apply3(ce.symbol(fn.symbol), [ce.symbol("_")]);
    }
    if (fn.operator === "Function") {
      v = fn.ops[1].symbol ?? "_";
      fn = fn.ops[0];
    }
    let result = fn;
    while (order2-- > 0 && result) result = differentiate(result, v);
    return result;
  }
  function differentiate(expr, v) {
    const ce = expr.engine;
    if (expr.string) return void 0;
    if (expr.isNumberLiteral) return expr.engine.Zero;
    if (expr.symbol === v) return expr.engine.One;
    if (expr.symbol) return expr.engine.Zero;
    if (!expr.operator) return void 0;
    if (expr.operator === "Negate") {
      const gPrime2 = differentiate(expr.op1, v);
      if (gPrime2) return gPrime2.neg();
      return ce._fn("D", [expr.op1, ce.symbol(v)]).neg();
    }
    if (expr.operator === "Add") {
      const terms = expr.ops.map((op) => differentiate(op, v));
      if (terms.some((term) => term === void 0)) return void 0;
      return add3(...terms).evaluate();
    }
    if (expr.operator === "Multiply") {
      const terms = expr.ops.map((op, i) => {
        const otherTerms = expr.ops.slice();
        otherTerms.splice(i, 1);
        const otherProduct = mul3(...otherTerms);
        const gPrime2 = differentiate(op, v) ?? ce._fn("D", [op, ce.symbol(v)]);
        return gPrime2.mul(otherProduct);
      });
      if (terms.some((term) => term === void 0)) return void 0;
      return add3(...terms).evaluate();
    }
    if (expr.operator === "Power") {
      const [base, exponent] = expr.ops;
      if (base.symbol === v) {
        return exponent.mul(base.pow(exponent.add(ce.NegativeOne))).evaluate();
      }
      const f = base;
      const g2 = exponent;
      const fPrime = differentiate(f, v) ?? ce._fn("D", [f, ce.symbol(v)]);
      const gPrime2 = differentiate(g2, v) ?? ce._fn("D", [g2, ce.symbol(v)]);
      const term1 = gPrime2.mul(f.ln());
      const term3 = g2.mul(fPrime).div(f);
      return expr.mul(term1.add(term3)).evaluate();
    }
    if (expr.operator === "Divide") {
      const [numerator, denominator] = expr.ops;
      const gPrime2 = differentiate(numerator, v) ?? ce._fn("D", [numerator, ce.symbol(v)]);
      const hPrime = differentiate(denominator, v) ?? ce._fn("D", [denominator, ce.symbol(v)]);
      return gPrime2.mul(denominator).sub(hPrime.mul(numerator)).div(denominator.pow(2)).evaluate();
    }
    const h = DERIVATIVES_TABLE[expr.operator];
    if (!h) {
      if (expr.nops > 1) return void 0;
      const fPrime = ce._fn("Derivative", [ce.symbol(expr.operator), ce.One]);
      if (!fPrime.isValid) return void 0;
      const g2 = expr.ops[0];
      const gPrime2 = differentiate(g2, v) ?? ce._fn("D", [g2, ce.symbol(v)]);
      if (!gPrime2.isValid) return void 0;
      return ce._fn("Apply", [fPrime, g2]).mul(gPrime2);
    }
    if (expr.nops > 1) return ce._fn("D", [expr, ce.symbol(v)]);
    const g = expr.ops[0];
    const gPrime = differentiate(g, v) ?? ce._fn("D", [g, ce.symbol(v)]);
    return apply3(ce.box(h), [g]).mul(gPrime);
  }

  // src/compute-engine/library/calculus.ts
  var CALCULUS_LIBRARY = [
    {
      /* @todo
          ## Definite Integral
      `\int f dx` -> ["Integrate", "f", "x"]
      
      `\int\int f dxdy` -> ["Integrate", "f", "x", "y"]
      
      Note: `["Integrate", ["Integrate", "f" , "x"], "y"]` is equivalent to
      `["Integrate", "f" , "x", "y"]`
      
      
      `\int_{a}^{b} f dx` -> ["Integrate", f, [x, a, b]]
      `\int_{c}^{d} \int_{a}^{b} f dxdy` -> ["Integrate", "f", ["Triple", "x", "a",
      "b"], ["Triple", "y", "c", "d"]]
      
      `\int_{a}^{b}\frac{dx}{f}` -> ["Integrate", ["Power", "f", -1], ["Triple", "x",
      "a", "b"]]
      
      `\int_{a}^{b}dx f` -> ["Integrate", "f", ["Triple", "x", "a", "b"]]
      
      If `[a, b]` are numeric, numeric methods are used to approximate the integral.
      
      ## Domain Integral
      
      `\int_{x\in D}` -> ["Integrate", f, ["In", x, D]]
      
      ### Contour Integral
      
      `\oint f dx` -> `["ContourIntegral", "f", "x"]`
      
      `\varointclockwise f dx` -> `["ClockwiseContourIntegral", "f", "x"]`
      
      `\ointctrclockwise f dx` -> `["CounterclockwiseContourIntegral", "f", "x"]`
      
      `\oiint f ds` -> `["DoubleCountourIntegral", "f", "s"]` : integral over closed
      surfaces
      
      `\oiiint` f dv -> `["TripleCountourIntegral", "f", "v"]` : integral over closed
      volumes
      
      `\intclockwise`
      
      `\intctrclockwise`
      
      `\iint`
      
      `\iiint`
      */
      // @todo: review the following
      // - https://index.scala-lang.org/cascala/galileo
      // - https://symbolics.juliasymbolics.org/stable/
      // - https://github.com/symengine/SymEngine.jl
      //
      // Functions
      //
      //
      // **Derivative**
      //
      // Returns a function that represents the derivative of the
      // given function.
      //
      // In contrast to the `D` function, the `Derivative` function
      // returns a function that represents the derivative of the given
      // function, rather than the result of evaluating the derivative
      // at a given point.
      // `['Derivative', f]` < = > `["D", ["Apply", f, "x"], "x"]`
      //
      //
      // ["Derivative", "Sin"]
      //    -> "Cos"
      //
      // ["Derivative", ["Function", ["Square", "x"], "x"], 2]
      //    -> "2"
      //
      // The argument "2" of the `Derivative` function indicates the order
      // of the derivative.
      //
      //
      // @todo: consider Fractional Calculus, i.e. Louiville-Riemann derivative
      // https://en.wikipedia.org/wiki/Fractional_calculus
      // with values of the order that can be either fractional or negative
      //
      Derivative: {
        threadable: false,
        lazy: true,
        signature: "(any, order:number?) -> function",
        canonical: (ops, { engine }) => {
          return engine._fn("Derivative", [ops[0].canonical, ...ops.slice(1)]);
        },
        evaluate: (ops) => {
          const op = ops[0].evaluate();
          const degree = Math.floor(ops[1]?.N().re);
          return derivative(op, isNaN(degree) ? 1 : degree);
        }
      },
      //
      // **D: Partial derivative**
      //
      // Returns the partial derivative of a function with respect to a
      // variable.
      //
      // ["D", "Sin", "x"]
      //    -> ["Cos", "x"]
      //
      // This is equivalent to `["Apply", ["Derivative", "Sin"], "x"]`
      D: {
        threadable: false,
        lazy: true,
        signature: "(expression, variable:symbol, variables:...symbol) -> expression",
        canonical: (ops, { engine }) => {
          const ce = engine;
          let f = ops[0];
          if (!f) return null;
          ce.pushScope();
          const params = ops.slice(1);
          f.bind();
          f = f.canonical;
          const result = ce._fn("D", [f, ...params]);
          ce.popScope();
          return result;
        },
        evaluate: (ops, { engine }) => {
          const ce = engine;
          let f = ops[0].canonical;
          const context = ce.swapScope(f.scope);
          f = f.evaluate();
          const params = ops.slice(1);
          if (params.length === 0) f = void 0;
          for (const param of params) {
            if (!param.symbol) {
              f = void 0;
              break;
            }
            f = differentiate(f, param.symbol);
            if (f === void 0) break;
          }
          ce.swapScope(context);
          f = f?.canonical;
          return f?.operator === "D" ? f : f?.evaluate();
        }
      },
      // Evaluate a numerical approximation of a derivative at point x
      ND: {
        threadable: false,
        lazy: true,
        signature: "(function, at:number) -> number",
        evaluate: ([body, x], { engine }) => {
          const xValue = x?.canonical.N().re;
          if (isNaN(xValue)) return void 0;
          const f = applicableN1(engine.box(body));
          return engine.number(centeredDiff8thOrder(f, xValue));
        }
      },
      Integrate: {
        wikidata: "Q80091",
        threadable: false,
        lazy: true,
        signature: "(expression, range:(tuple|symbol|nothing)) -> number",
        canonical: (ops, { engine }) => {
          const ce = engine;
          let range2 = ops[1];
          let index = null;
          let lower = null;
          let upper = null;
          if (range2 && range2.operator !== "Tuple" && range2.operator !== "Triple" && range2.operator !== "Pair" && range2.operator !== "Single") {
            index = range2;
          } else if (range2) {
            index = range2.ops?.[0] ?? null;
            lower = range2.ops?.[1]?.canonical ?? null;
            upper = range2.ops?.[2]?.canonical ?? null;
          }
          if (index && index.operator === "Hold") index = index.op1;
          if (index && index.operator === "ReleaseHold")
            index = index.op1.evaluate();
          index ?? (index = ce.Nothing);
          if (!index.symbol) index = ce.typeError("symbol", index.type, index);
          if (lower && lower.symbol !== "Nothing") {
            if (!lower.type.isUnknown) lower = checkType(ce, lower, "number");
          }
          if (upper && upper.symbol !== "Nothing") {
            if (!upper.type.isUnknown) upper = checkType(ce, upper, "number");
          }
          if (lower && upper) range2 = ce.tuple(index, lower, upper);
          else if (upper) range2 = ce.tuple(index, ce.NegativeInfinity, upper);
          else if (lower) range2 = ce.tuple(index, lower);
          else range2 = index;
          let body = ops[0] ?? ce.error("missing");
          body = body.canonical;
          if (body.operator === "Delimiter" && body.op1.operator === "Sequence")
            body = body.op1.op1;
          return ce._fn("Integrate", [body, range2]);
        }
      },
      NIntegrate: {
        threadable: false,
        lazy: true,
        signature: "(expression, lower:number, upper:number) -> number",
        evaluate: (ops, { engine }) => {
          const precision = engine.precision;
          engine.precision = "machine";
          const wasStrict = engine.strict;
          engine.strict = false;
          const [a, b] = ops.slice(1).map((op) => op.value);
          let result = void 0;
          if (typeof a === "number" && typeof b === "number") {
            const f = applicableN1(ops[0]);
            result = engine.number(monteCarloEstimate(f, a, b));
          }
          engine.precision = precision;
          engine.strict = wasStrict;
          return result;
        }
      }
    },
    {
      // Limits
      Limit: {
        description: "Limit of a function",
        complexity: 5e3,
        threadable: false,
        lazy: true,
        signature: "(expression, point:number, direction:number?) -> number",
        evaluate: (ops, { engine: ce }) => {
          const [f, x, dir] = ops;
          const target = x.N().re;
          if (!isFinite(target)) return void 0;
          const fn = applicable(f);
          return ce.number(
            limit(
              (x2) => {
                const y = fn([ce.number(x2)])?.value;
                return typeof y === "number" ? y : Number.NaN;
              },
              target,
              dir ? dir.re : 1
            )
          );
        }
      },
      NLimit: {
        description: "Numerical approximation of the limit of a function",
        complexity: 5e3,
        threadable: false,
        lazy: true,
        signature: "(expression, point:number, direction:number?) -> number",
        evaluate: ([f, x, dir], { engine }) => {
          const target = x.N().re;
          if (Number.isNaN(target)) return void 0;
          const fn = applicable(f);
          return engine.number(
            limit(
              (x2) => {
                const y = fn([engine.number(x2)])?.value;
                return typeof y === "number" ? y : Number.NaN;
              },
              target,
              dir ? dir.re : 1
            )
          );
        }
      }
    }
  ];

  // src/compute-engine/library/control-structures.ts
  var CONTROL_STRUCTURES_LIBRARY = [
    {
      Block: {
        lazy: true,
        signature: "(any) -> any",
        canonical: canonicalBlock,
        evaluate: evaluateBlock
      },
      // A condition expression tests for one or more conditions of an expression
      // ['Condition', value, "positive"]
      Condition: {
        lazy: true,
        signature: "(value, symbol) -> boolean",
        evaluate: ([value, conds], { engine }) => {
          let conditions = [];
          if (conds.symbol) {
            conditions = [conds.symbol];
          } else if (conds.operator === "And") {
            conditions = conds.ops.map((op) => op.symbol ?? "");
          }
          if (checkConditions(value, conditions)) return engine.True;
          return engine.False;
        }
      },
      If: {
        lazy: true,
        signature: "(expression, expression, expression) -> any",
        type: ([cond, ifTrue, ifFalse]) => widen(ifTrue.type.type, ifFalse.type.type),
        evaluate: ([cond, ifTrue, ifFalse], { engine }) => {
          cond = cond.evaluate();
          if (cond && cond.symbol === "True")
            return ifTrue?.evaluate() ?? engine.Nothing;
          return ifFalse?.evaluate() ?? engine.Nothing;
        }
      },
      Loop: {
        lazy: true,
        signature: "(body:expression, collection:expression) -> any",
        type: ([body]) => body.type,
        evaluate: ([body, collection], { engine: ce }) => run(runLoop(body, collection, ce), ce._timeRemaining),
        evaluateAsync: async ([body, collection], { engine: ce, signal }) => runAsync(runLoop(body, collection, ce), ce._timeRemaining, signal)
      },
      Which: {
        lazy: true,
        signature: "(...expression) -> unknown",
        type: (args) => {
          if (args.length % 2 !== 0) return "nothing";
          return widen(
            ...args.filter((_, i) => i % 2 === 1).map((x) => x.type.type)
          );
        },
        canonical: (args, options) => {
          if (args.length % 2 !== 0) return options.engine.Nothing;
          return options.engine._fn(
            "Which",
            args.map((x) => x.canonical)
          );
        },
        evaluate: (ops, options) => evaluateWhich(ops, options)
      },
      FixedPoint: { lazy: true, signature: "any -> any" }
    }
  ];
  function evaluateWhich(args, options) {
    let i = 0;
    while (i < args.length - 1) {
      if (args[i].evaluate().symbol === "True") {
        if (!args[i + 1]) return options.engine.symbol("Undefined");
        return args[i + 1].evaluate(options);
      }
      i += 2;
    }
    return options.engine.symbol("Undefined");
  }
  function evaluateBlock(ops, { engine: ce }) {
    if (ops.length === 0) return ce.Nothing;
    ce.resetContext();
    let result = void 0;
    for (const op of ops) {
      const h = op.operator;
      if (h === "Return") {
        result = op.op1.evaluate();
        break;
      }
      if (h === "Break" || h === "Continue") {
        result = ce.box([h, op.op1.evaluate()]);
        break;
      }
      result = op.evaluate();
    }
    return result ?? ce.Nothing;
  }
  function canonicalBlock(ops, options) {
    const { engine: ce } = options;
    if (ops.length === 0) return null;
    ce.pushScope();
    const declarations = [];
    const body = [];
    for (const op of ops) {
      if (op.operator === "Declare") declarations.push(op);
      else body.push(invalidateDeclare(op));
    }
    const result = ce._fn("Block", [...declarations, ...body]);
    ce.popScope();
    return result;
  }
  function invalidateDeclare(expr) {
    if (expr.operator === "Declare") expr.engine.error("unexpected-declare");
    if (expr.ops)
      return expr.engine._fn(expr.operator, expr.ops.map(invalidateDeclare));
    return expr;
  }
  function* runLoop(body, collection, ce) {
    body ?? (body = ce.Nothing);
    if (body.symbol === "Nothing") return body;
    if (collection?.isCollection) {
      let result = void 0;
      const fn = applicable(body);
      let i2 = 0;
      for (const x of each(collection)) {
        result = fn([x]) ?? ce.Nothing;
        if (result.operator === "Break") return result.op1;
        if (result.operator === "Return") return result;
        i2 += 1;
        if (i2 % 1e3 === 0) yield result;
        if (i2 > ce.iterationLimit)
          throw new CancellationError({ cause: "iteration-limit-exceeded" });
      }
      return result;
    }
    let i = 0;
    while (true) {
      const result = body.evaluate();
      if (result.operator === "Break") return result.op1;
      if (result.operator === "Return") return result;
      i += 1;
      if (i % 1e3 === 0) yield result;
      if (i > ce.iterationLimit)
        throw new CancellationError({ cause: "iteration-limit-exceeded" });
    }
  }

  // src/compute-engine/library/complex.ts
  var COMPLEX_LIBRARY = [
    {
      Real: {
        // @todo: could be extended to return an expression, i.e. ["Real", ["Add", "x", ["Complex", 0, 5]]] -> "x". Not for any operator, but at least for Add, Multiply, Negate, etc.
        threadable: true,
        complexity: 1200,
        signature: "number -> real",
        sgn: ([op]) => {
          const re = op.re;
          if (isNaN(re)) return void 0;
          if (re === 0) return "zero";
          return re > 0 ? "positive" : "negative";
        },
        evaluate: (ops, { engine: ce }) => {
          const op = ops[0].numericValue;
          if (op === null) return void 0;
          if (typeof op === "number") return ops[0];
          return ce.number(op.bignumRe ?? op.re);
        }
      },
      Imaginary: {
        threadable: true,
        complexity: 1200,
        signature: "number -> real",
        sgn: ([op]) => {
          const im = op.im;
          if (isNaN(im)) return void 0;
          if (im === 0) return "zero";
          return im > 0 ? "positive" : "negative";
        },
        evaluate: (ops, { engine: ce }) => {
          const op = ops[0].numericValue;
          if (op === null) return void 0;
          if (typeof op === "number") return ce.Zero;
          return ce.number(op.im);
        }
      },
      Argument: {
        threadable: true,
        complexity: 1200,
        signature: "number -> real",
        evaluate: (ops, { engine: ce }) => {
          const op = ops[0].numericValue;
          if (op === null) return void 0;
          if (typeof op === "number") return op >= 0 ? ce.Zero : ce.Pi;
          if (op.im === 0) return op.re >= 0 ? ce.Zero : ce.Pi;
          return ce.function("ArcTan2", [op.im, op.re]).evaluate();
        }
      },
      // For Abs (magnitude) see src/compute-engine/library/processAbs
      AbsArg: {
        threadable: true,
        complexity: 1200,
        signature: "number -> tuple<real, real>",
        evaluate: (ops, { engine: ce }) => {
          if (ops[0].numericValue === null) return void 0;
          return ce.tuple(
            ce.function("Abs", ops).evaluate(),
            ce.function("Argument", ops).evaluate()
          );
        }
      },
      Conjugate: {
        threadable: true,
        complexity: 1200,
        signature: "number -> number",
        type: ([z]) => z.type,
        sgn: ([z]) => z.sgn,
        evaluate: (ops, { engine: ce }) => {
          const op = ops[0].numericValue;
          if (op === null) return void 0;
          if (typeof op === "number" || op.im === 0) return ops[0];
          return ce.number(ce.complex(op.re, -op.im));
        }
      },
      ComplexRoots: {
        threadable: true,
        complexity: 1200,
        signature: "(number, number) -> list<number>",
        evaluate: (ops, { engine: ce }) => {
          const re = ops[0].re;
          if (isNaN(re)) return void 0;
          const n = ops[1].re;
          if (!Number.isInteger(n) || n <= 0) return void 0;
          const roots = [];
          const im = ops[0].im ?? 0;
          const arg = Math.atan2(im, re);
          const mod2 = Math.sqrt(re * re + im * im);
          for (let k = 0; k < n; k++) {
            const theta = (arg + 2 * Math.PI * k) / n;
            const r = Math.pow(mod2, 1 / n);
            roots.push([r * Math.cos(theta), r * Math.sin(theta)]);
          }
          return ce.function(
            "List",
            roots.map(
              (r) => ce.number(r[1] !== 0 ? ce.complex(r[0], r[1]) : r[0])
            )
          );
        }
      }
    }
  ];

  // src/compute-engine/library/random-expression.ts
  function oneOf(xs) {
    return xs[Math.floor(Math.random() * xs.length)];
  }
  function randomExpressionWithHead(operator2, level) {
    if (operator2 === "Add" || operator2 === "Multiply") {
      const ops = [];
      let count = 1 + Math.floor(Math.random() * 12);
      while (count > 0) {
        ops.push(randomExpression(level + 1));
        count -= 1;
      }
      return [operator2, ...ops];
    }
    if (operator2 === "Divide" || operator2 === "Power") {
      return [operator2, randomExpression(level + 1), randomExpression(level + 1)];
    }
    if (operator2 === "Root") {
      return [operator2, randomExpression(level + 1), randomExpression(10)];
    }
    if (operator2 === "trig") return randomTrig();
    return [operator2, randomExpression(level + 1)];
  }
  function randomTrig() {
    return [
      oneOf(["Cos", "Sin", "Tan", "Sinh", "Arccos", "Arcsinh"]),
      oneOf([
        "Pi",
        "-1",
        "0",
        "1",
        ["Divide", "Pi", -5],
        ["Multiply", -2, ["Divide", "Pi", 11]],
        ["Multiply", "Half", "Pi"],
        ["Multiply", 5, "Pi"],
        ["Multiply", 12, "Pi"],
        ["Divide", "Pi", 5],
        ["Divide", "Pi", 9],
        ["Multiply", 5, ["Divide", "Pi", 9]],
        ["Multiply", 2, ["Divide", "Pi", 11]],
        ["Multiply", 2, ["Divide", "Pi", 3]]
      ])
    ];
  }
  function randomExpression(level) {
    level ?? (level = 1);
    if (level === 1) {
      const h = oneOf([
        [
          "Sqrt",
          [
            "Multiply",
            6,
            [
              "Sum",
              ["Divide", 1, ["Power", "n", 2]],
              ["Triple", ["Hold", "n"], 1, "PositiveInfinity"]
            ]
          ]
        ],
        "Add",
        "Add",
        "Add",
        "Add",
        "Add",
        "Multiply",
        "Multiply",
        "Multiply",
        "Multiply",
        "Divide",
        "Divide",
        "Divide",
        "Root",
        "Sqrt",
        "Subtract",
        "Negate",
        "trig"
      ]);
      if (typeof h === "string") return randomExpressionWithHead(h, 1);
      return h;
    }
    if (level === 2) {
      const r = Math.random();
      if (r > 0.75) return randomExpression(1);
      if (r > 0.5) return randomExpression(3);
      const h = oneOf([
        "Multiply",
        "Multiply",
        "Add",
        "Power",
        "trig",
        "Ln",
        "Exp"
      ]);
      return randomExpressionWithHead(h, 2);
    }
    return oneOf([
      -12345e-9,
      -2,
      -2,
      -2,
      -3,
      -5,
      -6,
      -12,
      -1654e-60,
      0,
      0,
      12345e-8,
      1654e-60,
      1,
      2,
      2,
      2,
      2,
      3,
      3,
      5,
      5,
      6,
      6,
      1234.5678,
      5678.1234,
      10,
      15,
      18,
      30,
      60,
      1234e54,
      "123456789.12345678912345e200",
      "987654321.12345678912345",
      ["Rational", -6, 10],
      ["Rational", -12, 15],
      ["Rational", -15, 12],
      ["Rational", 3, 5],
      ["Rational", 12, 15],
      ["Rational", 15, 12],
      "ExponentialE",
      // 'ImaginaryUnit',
      ["Sqrt", 3],
      ["Sqrt", 5],
      ["Sqrt", 15],
      ["Sqrt", 25],
      ["Complex", -1.1, 1.1],
      ["Complex", 4, 5],
      "x",
      "x",
      "x",
      "x",
      ["Add", "x", 1],
      ["Divide", "x", 3],
      ["Square", "x"],
      ["Power", "x", 3],
      ["Power", "x", 4],
      ["Subtract", "x", 1],
      ["Add", "x", 1],
      // 'a',
      // 'b',
      "Pi"
    ]);
  }

  // src/compute-engine/library/core.ts
  var CORE_LIBRARY = [
    {
      // The sole member of the unit type, `nothing`
      Nothing: { type: "nothing" }
    },
    //
    // Inert functions
    //
    {
      /**
       * ### THEORY OF OPERATIONS: SEQUENCES
       *
       * There are three similar functions used to represent sequences of
       * expressions:
       *
       * - `InvisibleOperator` represent a sequence of expressions
       *  that are syntactically juxtaposed without any separator or
       *  operators combining them.
       *
       *  For example, `2x` is represented as `["InvisibleOperator", 2, "x"]`.
       *  `InvisibleOperator` gets transformed into `Multiply` (or some other
       *  semantic operation) during canonicalization.
       *
       * - `Sequence` is used to represent a sequence of expressions
       *   at a semantic level. It is a collection, but it is handled
       *   specially when canonicalizing expressions, for example it
       *   is automatically flattened and hoisted to the top level of the
       *   argument list.
       *
       *   For example:
       *
       *     `["Add", "a", ["Sequence", "b", "c"]]`
       *
       *   is canonicalized to
       *
       *     `["Add", "a", "b", "c"]`.
       *
       *   The empty `Sequence` expression (i.e. `["Sequence"]`) is ignored
       *   but it can be used to represent an "empty" expression. It is a
       *   synonym for `Nothing`.
       *
       * - `Delimiter` is used to represent a group of expressions
       *   with an open and close delimiter and a separator.
       *
       *   They capture the input syntax, and can get transformed into other
       *   expressions during boxing and canonicalization.
       *
       *   The first argument is a function expression, such as `List`
       *   or `Sequence`. The arguments of that expression are represented
       *   with a separator between them and delimiters around the whole
       *   group.
       *
       *   If the first argument is a `Sequence` with a single element,
       *   the `Sequence` can be omitted.
       *
       *   The second argument specify the separator and delimiters. If not
       *   specified, the default is the string `"(,)"`
       *
       * Examples:
       * - `f(x)` ->
       *    `["InvisibleOperator",
       *        "f",
       *        ["Delimiter", "x"]
       *     ]`
       *
       * - `1, 2; 3, 4` ->
       *    `["Delimiter",
       *      ["Sequence",
       *        ["Delimiter", ["Sequence", 1, 2], "','"],
       *        ["Delimiter", ["Sequence", 3, 4], "','"],
       *      ],
       *     "';'"
       *    ]`
       *
       * - `2x` -> `["InvisibleOperator", 2, "x"]`
       *
       * - `2+` -> `["InvisibleOperator", 2,
       *              ["Error", "'unexpected-operator'", "+"]]`
       *
       *
       *
       *
       */
      InvisibleOperator: {
        complexity: 9e3,
        lazy: true,
        signature: "...any -> any",
        // Note: since the canonical form will be a different operator,
        // no need to calculate the result type
        canonical: (x, { engine }) => {
          const y = canonicalInvisibleOperator(x, { engine });
          if (!y) return engine.Nothing;
          if (y.operator === "Multiply") return canonicalMultiply(engine, y.ops);
          return y;
        }
      },
      /** See above for a theory of operations */
      Sequence: {
        lazy: true,
        signature: "...any -> any",
        type: (args) => {
          if (args.length === 0) return "nothing";
          if (args.length === 1) return args[0].type;
          return "any";
        },
        canonical: (args, { engine: ce }) => {
          const xs = flatten(args);
          if (xs.length === 0) return ce.Nothing;
          if (xs.length === 1) return xs[0];
          return ce._fn("Sequence", xs);
        }
      },
      /** See above for a theory of operations */
      Delimiter: {
        // Use to represent groups of expressions.
        // Named after https://en.wikipedia.org/wiki/Delimiter
        complexity: 9e3,
        lazy: true,
        signature: "(any, string?) -> any",
        type: (args) => {
          if (args.length === 0) return "nothing";
          return args[0].type;
        },
        canonical: (args, { engine: ce }) => {
          if (args.length === 0) return ce._fn("Tuple", []);
          if (args.length > 2)
            return ce._fn("Delimiter", checkArity(ce, args, 2));
          let body = args[0];
          if (body.operator === "Sequence")
            return ce._fn("Tuple", canonical(ce, body.ops));
          body = body.canonical;
          const delim = args[1]?.string;
          if (!delim || delim.startsWith("(") && delim.endsWith(")"))
            return body;
          if ((delim?.length ?? 0) > 3) {
            return ce._fn("Delimiter", [
              body,
              ce.error("invalid-delimiter", args[1].toString())
            ]);
          }
          return ce._fn("Delimiter", [args[0], checkType(ce, args[1], "string")]);
        },
        evaluate: (ops, options) => {
          const ce = options.engine;
          if (ops.length === 0) return ce.Nothing;
          const op1 = ops[0];
          if (op1.operator === "Sequence" || op1.operator === "Delimiter")
            ops = flattenSequence(ops[0].ops);
          if (ops.length === 1) return ops[0].evaluate(options);
          return ce._fn(
            "Tuple",
            ops.map((x) => x.evaluate(options))
          );
        }
      },
      Error: {
        /**
         * - The first argument is either a string or an `["ErrorCode"]`
         * expression indicating the nature of the error.
         * - The second argument, if present, indicates the context/location
         * of the error. If the error occur while parsing a LaTeX string,
         * for example, the argument will be a `Latex` expression.
         */
        lazy: true,
        complexity: 500,
        signature: "((string|expression), expression?) -> nothing",
        // To make a canonical expression, don't canonicalize the args
        canonical: (args, { engine: ce }) => ce._fn("Error", args)
      },
      ErrorCode: {
        complexity: 500,
        lazy: true,
        signature: "(string, ...any) -> error",
        canonical: (args, { engine: ce }) => {
          const code = checkType(ce, args[0], "string").string;
          if (code === "incompatible-type") {
            return ce._fn("ErrorCode", [ce.string(code), args[1], args[2]]);
          }
          return ce._fn("ErrorCode", args);
        }
      },
      Unevaluated: {
        description: "Prevent an expression from being evaluated",
        // Unlike Hold, the argument is canonicalized
        lazy: false,
        signature: "any -> any",
        type: ([x]) => x.type,
        evaluate: ([x]) => x
      },
      Hold: {
        description: "Hold an expression, preventing it from being canonicalized or evaluated until `ReleaseHold` is applied to it",
        lazy: true,
        signature: "any -> unknown",
        type: ([x]) => {
          if (x.symbol) return "symbol";
          if (x.string) return "string";
          if (x.isNumberLiteral) return x.type;
          if (x.ops) return functionResult(x.type.type) ?? "unknown";
          return "unknown";
        },
        // When comparing hold expressions, consider them equal if their
        // arguments are structurally equal.
        eq: (a, b) => {
          if (b.operator === "Hold") b = b.ops[0];
          return a.ops[0].isSame(b);
        },
        // By definition, the argument of the canonical expression of
        // `Hold` are not canonicalized.
        canonical: (args, { engine }) => args.length !== 1 ? null : engine.hold(args[0]),
        evaluate: ([x], { engine }) => engine.hold(x)
      },
      ReleaseHold: {
        description: "Release an expression held by `Hold`",
        lazy: true,
        signature: "any -> any",
        type: ([x]) => x.type,
        evaluate: ([x], options) => {
          if (x.operator === "Hold") return x.ops[0].evaluate(options);
          return x.evaluate(options);
        }
      },
      HorizontalSpacing: {
        signature: "number -> nothing",
        canonical: (args, { engine: ce }) => {
          if (args.length === 2) return args[0].canonical;
          return ce.Nothing;
        }
      },
      Style: {
        complexity: 9e3,
        signature: "(expression, map) -> expression",
        lazy: true,
        type: ([x]) => x.type,
        canonical: ([x, style], { engine: ce }) => {
          x = x.canonical;
          style = canonicalDictionary(ce, style);
          if (style.nops === 0) return x;
          return ce._fn("Style", [x, style]);
        },
        evaluate: ([x, _style], options) => x.evaluate(options)
      }
    },
    {
      //
      // Structural operations that can be applied to non-canonical expressions
      //
      About: {
        description: "Return information about an expression",
        lazy: true,
        signature: "any -> string",
        evaluate: ([x], { engine: ce }) => {
          const s = [x.toString()];
          s.push("");
          if (x.string) s.push("string");
          else if (x.symbol) {
            if (x.symbolDefinition) {
              const def = x.symbolDefinition;
              if (def.isConstant) s.push("constant");
              if (def.isFunction) s.push("function");
              if (typeof def.description === "string") s.push(def.description);
              else if (Array.isArray(def.description))
                s.push(def.description.join("\n"));
              if (def.wikidata) s.push(`WikiData: ${def.wikidata}`);
              if (def.url) s.push(`Read More: ${def.url}`);
            } else {
              s.push("symbol");
              s.push(`value: ${x.evaluate().toString()}`);
            }
          } else if (x.isNumberLiteral) s.push(x.type.toString());
          else if (x.ops) {
            s.push(x.type.toString());
            s.push(x.isCanonical ? "canonical" : "non-canonical");
          } else s.push("Unknown expression's type");
          return ce.string(s.join("\n"));
        }
      },
      Head: {
        description: "Return the head of an expression, the name of the operator",
        lazy: true,
        signature: "any -> symbol",
        canonical: (args, { engine: ce }) => {
          if (args.length !== 1) return null;
          const op1 = args[0];
          if (op1.operator) return ce.box(op1.operator);
          return ce._fn("Head", canonical(ce, args));
        },
        evaluate: (ops, { engine: ce }) => ce.symbol(ops[0]?.operator ?? "Undefined")
      },
      Tail: {
        description: "Return the tail of an expression, the operands of the expression",
        lazy: true,
        signature: "any -> collection",
        canonical: (args, { engine: ce }) => {
          if (args.length !== 1) return null;
          const op1 = args[0];
          if (op1.ops) return ce._fn("Sequence", op1.ops);
          return ce._fn("Tail", canonical(ce, args));
        },
        // **IMPORTANT** Tail should work on non-canonical expressions
        evaluate: ([x], { engine: ce }) => x?.ops ? ce._fn("Sequence", x.ops) : ce.Nothing
      },
      Identity: {
        description: "Return the argument unchanged",
        signature: "any -> any",
        type: ([x]) => x.type,
        evaluate: ([x]) => x
      }
    },
    {
      Apply: {
        description: "Apply a function to a list of arguments",
        signature: "(name:symbol, arguments:...expression) -> any",
        type: ([fn]) => functionResult(fn.type.type) ?? "any",
        canonical: (args, { engine: ce }) => {
          if (args[0].symbol) return ce.function(args[0].symbol, args.slice(1));
          return ce._fn("Apply", args);
        },
        evaluate: (ops) => apply3(ops[0], ops.slice(1))
      },
      Assign: {
        description: "Assign a value to a symbol",
        lazy: true,
        pure: false,
        signature: "(symbol, any) -> any",
        type: ([_symbol, value]) => value.type,
        canonical: (args, { engine: ce }) => {
          if (args.length !== 2) return null;
          const op1 = args[0];
          if (!op1.symbol) return null;
          const op2 = args[1];
          return ce._fn("Assign", [op1.canonical, op2.canonical]);
        },
        evaluate: ([op1, op2], { engine: ce }) => {
          const val = op2.evaluate();
          ce.assign(op1.symbol, val);
          return val;
        }
      },
      Assume: {
        description: "Assume a type for a symbol",
        lazy: true,
        pure: false,
        signature: "any -> symbol",
        evaluate: (ops, { engine: ce }) => ce.symbol(ce.assume(ops[0]))
      },
      Declare: {
        lazy: true,
        pure: false,
        signature: "symbol -> any",
        type: ([_symbol, value]) => value.type,
        canonical: (args, { engine: ce }) => {
          if (args.length !== 2) return null;
          const op1 = args[0];
          const op2 = args[1];
          if (!op1.symbol) return null;
          if (op2.symbol) return ce._fn("Declare", args);
          return ce._fn("Declare", [op1, ce._fn("Hold", [op2])]);
        },
        evaluate: (ops, { engine: ce }) => {
          const op1 = ops[0];
          const op2 = ops[1];
          if (!op1.symbol) return ce.Nothing;
          const val = op2.evaluate();
          if (!val.string) return void 0;
          const type2 = parseType(val.string);
          if (!isValidType(type2)) return void 0;
          ce.declare(op1.symbol, type2);
          return val;
        }
      },
      /** Return the type of an expression */
      Type: {
        lazy: true,
        signature: "any -> string",
        evaluate: ([x], { engine: ce }) => ce.string(x.type.toString() ?? "unknown")
      },
      Evaluate: {
        lazy: true,
        signature: "any -> any",
        type: ([x]) => x.type,
        canonical: (ops, { engine: ce }) => ce._fn("Evaluate", checkArity(ce, ops, 1)),
        evaluate: ([x], options) => x.evaluate(options)
      },
      Function: {
        complexity: 9876,
        lazy: true,
        signature: "function",
        type: ([body, ...args]) => `(${args.map((x) => x.type)}) -> ${body.type.type}`,
        canonical: (args, { engine: ce }) => {
          if (args.length === 0) return ce.Nothing;
          const canonicalFn = canonicalFunctionExpression(args[0], args.slice(1));
          if (!canonicalFn) return null;
          const body = canonicalFn[0].canonical;
          const params = canonicalFn.slice(1).map((x) => ce.symbol(x));
          if (params.length === 0) return body;
          return ce._fn("Function", [body, ...params]);
        },
        evaluate: (_args) => {
          return void 0;
        }
      },
      Simplify: {
        lazy: true,
        signature: "any -> expression",
        canonical: (ops, { engine: ce }) => ce._fn("Simplify", checkArity(ce, ops, 1)),
        evaluate: ([x]) => x.simplify() ?? void 0
      },
      CanonicalForm: {
        description: [
          "Return the canonical form of an expression",
          "Can be used to sort arguments of an expression.",
          'Sorting arguments of commutative functions is a weak form of canonicalization that can be useful in some cases, for example to accept "x+1" and "1+x" while rejecting "x+1" and "2x-x+1"'
        ],
        complexity: 8200,
        lazy: true,
        signature: "(any, ...symbol) -> any",
        // Do not canonicalize the arguments, we want to preserve
        // the original form before modifying it
        canonical: (ops) => {
          if (ops.length === 1) return ops[0].canonical;
          const forms = ops.slice(1).map((x) => x.symbol ?? x.string).filter((x) => x !== void 0 && x !== null);
          return canonicalForm(ops[0], forms);
        }
      },
      N: {
        description: "Numerically evaluate an expression",
        lazy: true,
        signature: "any -> any",
        type: ([x]) => x.type,
        canonical: (ops, { engine: ce }) => {
          if (ops.length !== 1) return ce._fn("N", checkArity(ce, ops, 1));
          const h = ops[0].operator;
          if (h === "N") return ops[0].canonical;
          if (h === "Integrate") {
            const { index, lower, upper } = normalizeIndexingSet(ops[0].op2);
            if (!index || lower === void 0 || upper === void 0) return null;
            const fn = ops[0].op1;
            return ce._fn("NIntegrate", [
              ce.function("Function", [fn, index]),
              ce.number(lower),
              ce.number(upper)
            ]);
          }
          if (h === "Limit") return ce._fn("NLimit", ops[0].ops);
          return ce._fn("N", ops);
        },
        evaluate: ([x]) => x.N()
      },
      Random: {
        description: [
          "Random(): Return a random number between 0 and 1",
          "Random(n): Return a random integer between 0 and n-1",
          "Random(m, n): Return a random integer between m and n-1"
        ],
        pure: false,
        signature: "(lower:integer?, upper:integer?) -> finite_number",
        type: ([lower, upper]) => {
          if (lower === void 0 && upper === void 0) return "finite_number";
          return "finite_integer";
        },
        sgn: () => "non-negative",
        evaluate: (ops, { engine: ce }) => {
          if (ops.length === 0) return ce.number(Math.random());
          const [lowerOp, upperOp] = ops;
          let lower;
          let upper;
          if (upperOp === void 0) {
            lower = 0;
            upper = Math.floor(lowerOp.re - 1);
            if (isNaN(upper)) upper = 0;
          } else {
            lower = Math.floor(lowerOp.re);
            upper = Math.floor(upperOp.re);
            if (isNaN(lower)) lower = 0;
            if (isNaN(upper)) upper = 0;
          }
          return ce.number(lower + Math.floor(Math.random() * (upper - lower)));
        }
      },
      // @todo: need review
      Signature: {
        lazy: true,
        signature: "symbol -> string | nothing",
        evaluate: ([x], { engine: ce }) => {
          if (!x.functionDefinition) return ce.Nothing;
          return ce.string(x.functionDefinition.signature.toString());
        }
      },
      Subscript: {
        /**
         * The `Subscript` function can take several forms:
         *
         * If `op1` is a string, the string is interpreted as a number in
         * base `op2` (2 to 36).
         *
         * If `op1` is an indexable collection, `x`:
         * - `x_*` -> `At(x, *)`
         *
         * Otherwise:
         * - `x_0` -> Symbol "x_0"
         * - `x_n` -> Symbol "x_n"
         * - `x_{\text{max}}` -> Symbol `x_max`
         * - `x_{(n+1)}` -> `At(x, n+1)`
         * - `x_{n+1}` ->  `Subscript(x, n+1)`
         */
        // The last (subscript) argument can include a delimiter that
        // needs to be interpreted. Without the hold, it would get
        // removed during canonicalization.
        lazy: true,
        signature: "(collection|string, any) -> any",
        type: ([op1, op2]) => {
          if (op1.string && asSmallInteger(op2) !== null) return "integer";
          if (op1.isCollection && isIndexableCollection(op1))
            return collectionElementType(op1.type.type) ?? "any";
          if (op1.symbol) return "symbol";
          return "expression";
        },
        canonical: ([op1, op2], { engine: ce }) => {
          op1 = op1.canonical;
          if (op1.string) {
            const base = asSmallInteger(op2.canonical);
            if (base !== null && base > 1 && base <= 36) {
              const [value, rest] = fromDigits(op1.string, base);
              if (rest) {
                return ce.error(["unexpected-digit", rest[0]], op1.toString());
              }
              return ce.number(value);
            }
            return ce._fn("Baseform", [
              op1,
              ce.error(["invalid-base", op2.toString()])
            ]);
          }
          if (op1.isCollection && isIndexableCollection(op1))
            return ce._fn("At", [op1, op2.canonical]);
          if (op1.symbol) {
            const sub2 = op2.string ?? op2.symbol ?? asSmallInteger(op2)?.toString();
            if (sub2) return ce.symbol(op1.symbol + "_" + sub2);
          }
          if (op2.operator === "Sequence")
            ce._fn("Subscript", [op1, ce._fn("List", op2.ops)]);
          return ce._fn("Subscript", [op1, op2]);
        }
      },
      Symbol: {
        complexity: 500,
        description: "Construct a new symbol with a name formed by concatenating the arguments",
        threadable: true,
        lazy: true,
        signature: "...any -> any",
        type: (args) => {
          if (args.length === 0) return "nothing";
          return "symbol";
        },
        canonical: (ops, { engine: ce }) => {
          if (ops.length === 0) return ce.Nothing;
          const arg = ops.map(
            (x) => x.symbol ?? x.string ?? asSmallInteger(x)?.toString() ?? ""
          ).join("");
          if (arg.length > 0) return ce.symbol(arg);
          return ce.Nothing;
        }
        // Note: a `["Symbol"]` expression is never evaluated, it gets
        // transformed into something else (a symbol) during canonicalization
      },
      Timing: {
        description: "`Timing(expr)` evaluates `expr` and return a `Pair` of the number of second elapsed for the evaluation, and the value of the evaluation",
        signature: "(value, repeat: integer?) -> tuple<result:value, time:number>",
        evaluate: (ops, { engine: ce }) => {
          if (ops[1].symbol === "Nothing") {
            const start = globalThis.performance.now();
            const result2 = ops[0].evaluate();
            const timing = 1e3 * (globalThis.performance.now() - start);
            return ce.tuple(ce.number(timing), result2);
          }
          let n = Math.max(3, Math.round(asSmallInteger(ops[1]) ?? 3));
          let timings = [];
          let result;
          while (n > 0) {
            const start = globalThis.performance.now();
            result = ops[0].evaluate();
            timings.push(1e3 * (globalThis.performance.now() - start));
            n -= 1;
          }
          const max2 = Math.max(...timings);
          const min2 = Math.min(...timings);
          timings = timings.filter((x) => x > min2 && x < max2);
          const sum2 = timings.reduce((acc, v) => acc + v, 0);
          if (sum2 === 0) return ce.tuple(ce.number(max2), result);
          return ce.tuple(ce.number(sum2 / timings.length), result);
        }
      }
    },
    //
    // Wildcards
    //
    {
      Wildcard: {
        signature: "symbol -> symbol",
        canonical: (args, { engine: ce }) => {
          if (args.length !== 1) return ce.symbol("_");
          return ce.symbol("_" + args[0].symbol);
        }
      },
      WildcardSequence: {
        signature: "symbol -> symbol",
        canonical: (args, { engine: ce }) => {
          if (args.length !== 1) return ce.symbol("__");
          return ce.symbol("__" + args[0].symbol);
        }
      },
      WildcardOptionalSequence: {
        signature: "symbol -> symbol",
        canonical: (args, { engine: ce }) => {
          if (args.length !== 1) return ce.symbol("___");
          return ce.symbol("___" + args[0].symbol);
        }
      }
    },
    //
    // LaTeX-related
    //
    {
      LatexString: {
        description: "Value preserving type conversion/tag indicating the string is a LaTeX string",
        signature: "string -> string",
        evaluate: ([s]) => s
      },
      Latex: {
        description: "Serialize an expression to LaTeX",
        signature: "...any -> string",
        evaluate: (ops, { engine: ce }) => ce.box(["LatexString", ce.string(joinLatex(ops.map((x) => x.latex)))])
      },
      Parse: {
        description: "Parse a LaTeX string and evaluate to a corresponding expression",
        signature: "string -> any",
        evaluate: ([s], { engine: ce }) => ce.parse(s.string) ?? ce.Nothing
      }
    },
    {
      RandomExpression: {
        signature: "() -> expression",
        evaluate: (_ops, { engine }) => engine.box(randomExpression())
      }
    }
  ];

  // src/compute-engine/library/linear-algebra.ts
  var LINEAR_ALGEBRA_LIBRARY = [
    {
      Matrix: {
        complexity: 9e3,
        lazy: true,
        signature: "(matrix, string?, string?) -> matrix",
        type: ([matrix]) => matrix.type,
        canonical: canonicalMatrix,
        evaluate: (ops, options) => ops[0].evaluate(options)
      },
      // Vector is a specialized collection to represent a column vector.
      // ["Vector", a, b, c] is a shorthand for ["List", ["List", a], ["List", b], ["List", c]]
      Vector: {
        complexity: 9e3,
        lazy: true,
        signature: "...number -> vector",
        type: (elements) => parseType(`vector<${elements.length}>`),
        canonical: (ops, { engine: ce }) => {
          return ce._fn("Matrix", [
            ce.function(
              "List",
              ops.map((op) => ce.function("List", [op]))
            )
          ]);
        }
      }
    },
    {
      // Corresponds to monadic Shape `⍴` in APL
      Shape: {
        complexity: 8200,
        signature: "(value) -> tuple",
        evaluate: (ops, { engine: ce }) => {
          const op1 = ops[0];
          if (isBoxedTensor(op1)) return ce.tuple(...op1.tensor.shape);
          return ce.tuple();
        }
      },
      Rank: {
        description: "The length of the shape of the expression. Note this is not the matrix rank (the number of linearly independent rows or columns in the matrix)",
        complexity: 8200,
        signature: "(value) -> number",
        sgn: () => "positive",
        evaluate: (ops, { engine: ce }) => {
          const op1 = ops[0];
          if (isBoxedTensor(op1)) return ce.number(op1.tensor.rank);
          return ce.Zero;
        }
      },
      // Corresponds to ArrayReshape in Mathematica
      // and dyadic Shape `⍴` in APL
      Reshape: {
        complexity: 8200,
        signature: "(list<number>, tuple) -> value",
        type: ([value, shape]) => {
          if (!value.type.matches("list")) return "nothing";
          const col = value.type.type;
          if (!isSubtype(col.elements, "number")) return "nothing";
          return parseType(
            `list<number^${shape.ops.map((x) => x.toString()).join("x")}>`
          );
        },
        evaluate: (ops, { engine: ce }) => {
          let op1 = ops[0];
          const shape = ops[1].ops?.map((op) => op.value) ?? [];
          if (!isBoxedTensor(op1) && isFiniteIndexableCollection(op1))
            op1 = ce.function("List", [...each(op1)]);
          if (isBoxedTensor(op1)) {
            if (shape.join("x") === op1.tensor.shape.join("x")) return op1;
            return op1.tensor.reshape(...shape).expression;
          }
          return void 0;
        }
      },
      // Corresponds to Ravel `,` in APL
      // Also Enlist `∊``⍋` in APL
      Flatten: {
        complexity: 8200,
        signature: "(value) -> list",
        evaluate: (ops, { engine: ce }) => {
          const op1 = ops[0];
          if (isBoxedTensor(op1))
            return ce.box([
              "List",
              ...op1.tensor.flatten().map((x) => ce.box(x))
            ]);
          if (isFiniteIndexableCollection(op1))
            return ce.function("List", [...each(op1)]);
          return void 0;
        }
      },
      // Similar to Zip, but has a single argument, a matrix
      // Ex: Transpose([[a, b, c], [1, 2, 3]]) = [[a, 1], [b, 2], [c, 3]]
      Transpose: {
        complexity: 8200,
        signature: "(matrix|vector, axis1: integer?, axis2: integer?) -> matrix",
        evaluate: (ops, { engine: ce }) => {
          let op1 = ops[0];
          let axis1 = 1;
          let axis2 = 2;
          if (ops.length === 3) {
            axis1 = ops[1].value;
            axis2 = ops[2].value;
            console.assert(axis1 > 0 && axis2 > 0);
          }
          if (axis1 === axis2) return void 0;
          if (!isBoxedTensor(op1) && isFiniteIndexableCollection(op1))
            op1 = ce.function("List", [...each(op1)]);
          if (isBoxedTensor(op1)) {
            if (axis1 === 1 && axis2 === 2)
              return op1.tensor.transpose()?.expression;
            else return op1.tensor.transpose(axis1, axis2)?.expression;
          }
          return void 0;
        }
      },
      ConjugateTranspose: {
        complexity: 8200,
        signature: "(tensor, axis1: integer?, axis2: integer?) -> matrix",
        evaluate: (ops) => {
          const op1 = ops[0];
          let axis1 = 1;
          let axis2 = 2;
          if (ops.length === 3) {
            axis1 = ops[1].value;
            axis2 = ops[2].value;
            console.assert(axis1 > 0 && axis2 > 0);
          }
          if (axis1 === axis2) return void 0;
          if (isBoxedTensor(op1))
            return op1.tensor.conjugateTranspose(axis1, axis2)?.expression;
          return void 0;
        }
      },
      Determinant: {
        complexity: 8200,
        signature: "(matrix) -> number",
        evaluate: (ops) => {
          const op1 = ops[0];
          if (isBoxedTensor(op1)) return op1.tensor.determinant();
          return void 0;
        }
      },
      Inverse: {
        complexity: 8200,
        signature: "(matrix) -> matrix",
        type: ([matrix]) => matrix.type,
        evaluate: ([matrix]) => {
          if (isBoxedTensor(matrix)) return matrix.tensor.inverse()?.expression;
          return void 0;
        }
      },
      PseudoInverse: {
        complexity: 8200,
        signature: "(matrix) -> matrix",
        evaluate: ([matrix]) => {
          if (isBoxedTensor(matrix))
            return matrix.tensor.pseudoInverse()?.expression;
          return void 0;
        }
      },
      // Adjoint: {
      //   complexity: 8200,
      //   signature: {
      //     domain: ['FunctionOf', 'Values', 'Values'],
      //     evaluate: (ops) => {
      //       const op1 = ops[0];
      //       if (isBoxedTensor(op1)) return op1.adjoint()?.adjugateMatrix();
      //       return undefined;
      //     },
      //   },
      // },
      AdjugateMatrix: {
        complexity: 8200,
        signature: "(matrix) -> matrix",
        evaluate: (ops) => {
          const op1 = ops[0];
          if (isBoxedTensor(op1)) return op1.tensor.adjugateMatrix()?.expression;
          return void 0;
        }
      },
      // Minor: {
      //   complexity: 8200,
      //   signature: {
      //     domain: ['FunctionOf', 'Values', 'Values', 'Values'],
      //     evaluate: (ops) => {
      //       const op1 = ops[0];
      //       // if (isBoxedTensor(op1)) return op1.minor();
      //       return undefined;
      //     },
      //   },
      // },
      Trace: {
        complexity: 8200,
        signature: "(matrix) -> number",
        evaluate: (ops) => {
          const op1 = ops[0];
          if (isBoxedTensor(op1)) return op1.tensor.trace();
          return void 0;
        }
      }
    }
  ];
  function canonicalMatrix(ops, { engine: ce }) {
    const operator2 = "Matrix";
    if (ops.length === 0) return ce._fn(operator2, []);
    const body = ops[0].operator === "Vector" ? ops[0].canonical.ops[0] : ops[0].canonical;
    const delims = ops[1]?.canonical;
    const columns = ops[2]?.canonical;
    if (ops.length > 3) return ce._fn(operator2, checkArity(ce, ops, 3));
    if (columns) return ce._fn(operator2, [body, delims, columns]);
    if (delims) return ce._fn(operator2, [body, delims]);
    return ce._fn(operator2, [body]);
  }

  // src/compute-engine/library/logic.ts
  var LOGIC_LIBRARY = {
    True: { wikidata: "Q16751793", type: "boolean", constant: true },
    False: { wikidata: "Q5432619", type: "boolean", constant: true },
    // @todo: specify a `canonical` function that converts boolean
    // expressions into CNF (Conjunctive Normal Form)
    // https://en.wikipedia.org/wiki/Conjunctive_normal_form
    // using rules (with a rule set that's kinda the inverse of the
    // logic rules for simplify)
    // See also: https://en.wikipedia.org/wiki/Prenex_normal_form
    And: {
      wikidata: "Q191081",
      threadable: true,
      associative: true,
      commutative: true,
      idempotent: true,
      complexity: 1e4,
      signature: "(boolean, ...boolean) -> boolean",
      evaluate: evaluateAnd
    },
    Or: {
      wikidata: "Q1651704",
      threadable: true,
      associative: true,
      commutative: true,
      idempotent: true,
      complexity: 1e4,
      signature: "(boolean, ...boolean) -> boolean",
      evaluate: evaluateOr
    },
    Not: {
      wikidata: "Q190558",
      threadable: true,
      involution: true,
      complexity: 10100,
      // @todo: this may not be needed, since we also have rules.
      signature: "boolean -> boolean",
      evaluate: evaluateNot
    },
    Equivalent: {
      wikidata: "Q220433",
      threadable: true,
      complexity: 10200,
      signature: "(boolean, boolean) -> boolean",
      canonical: (args, { engine: ce }) => {
        const lhs = args[0].symbol;
        const rhs = args[1].symbol;
        if (lhs === "True" && rhs === "True" || lhs === "False" && rhs === "False")
          return ce.True;
        if (lhs === "True" && rhs === "False" || lhs === "False" && rhs === "True")
          return ce.False;
        return ce._fn("Equivalent", args);
      },
      evaluate: evaluateEquivalent
    },
    Implies: {
      wikidata: "Q7881229",
      threadable: true,
      complexity: 10200,
      signature: "(boolean, boolean) -> boolean",
      evaluate: evaluateImplies
    },
    Exists: { signature: "function", lazy: true },
    NotExists: { signature: "function", lazy: true },
    ExistsUnique: { signature: "function", lazy: true },
    ForAll: { signature: "function", lazy: true },
    NotForAll: { signature: "function", lazy: true },
    KroneckerDelta: {
      description: "Return 1 if the arguments are equal, 0 otherwise",
      signature: "(value, ...value) -> integer",
      evaluate: (args, { engine: ce }) => {
        if (args.length === 1)
          return args[0].symbol === "True" ? ce.One : ce.Zero;
        if (args.length === 2) return args[0].isEqual(args[1]) ? ce.One : ce.Zero;
        for (let i = 1; i < args.length; i++) {
          if (!args[i].isEqual(args[0])) return ce.Zero;
        }
        return ce.One;
      }
    },
    // Iverson bracket
    Boole: {
      description: "Return 1 if the argument is true, 0 otherwise. Also known as the Iverson bracket",
      signature: "boolean -> integer",
      evaluate: (args, { engine: ce }) => args[0].symbol === "True" ? ce.One : ce.Zero
    }
  };
  function evaluateAnd(args, { engine: ce }) {
    if (args.length === 0) return ce.True;
    const ops = [];
    for (const arg of args) {
      if (arg.symbol === "False") return ce.False;
      if (arg.symbol !== "True") {
        let duplicate = false;
        for (const x of ops) {
          if (x.isSame(arg)) {
            duplicate = true;
          } else if (arg.operator === "Not" && arg.op1.isSame(x) || x.operator === "Not" && x.op1.isSame(arg)) {
            return ce.False;
          }
        }
        if (!duplicate) ops.push(arg);
      }
    }
    if (ops.length === 0) return ce.True;
    if (ops.length === 1) return ops[0];
    return ce._fn("And", ops);
  }
  function evaluateOr(args, { engine: ce }) {
    if (args.length === 0) return ce.True;
    const ops = [];
    for (const arg of args) {
      if (arg.symbol === "True") return ce.True;
      if (arg.symbol !== "False") {
        let duplicate = false;
        for (const x of ops) {
          if (x.isSame(arg)) {
            duplicate = true;
          } else if (arg.operator === "Not" && arg.op1.isSame(x) || x.operator === "Not" && x.op1.isSame(arg)) {
            return ce.True;
          }
        }
        if (!duplicate) ops.push(arg);
      }
    }
    if (ops.length === 0) return ce.False;
    if (ops.length === 1) return ops[0];
    return ce._fn("Or", ops);
  }
  function evaluateNot(args, { engine: ce }) {
    const op1 = args[0]?.symbol;
    if (op1 === "True") return ce.False;
    if (op1 === "False") return ce.True;
    return void 0;
  }
  function evaluateEquivalent(args, { engine: ce }) {
    const lhs = args[0].symbol;
    const rhs = args[1].symbol;
    if (lhs === "True" && rhs === "True" || lhs === "False" && rhs === "False")
      return ce.True;
    if (lhs === "True" && rhs === "False" || lhs === "False" && rhs === "True")
      return ce.False;
    return void 0;
  }
  function evaluateImplies(args, { engine: ce }) {
    const lhs = args[0].symbol;
    const rhs = args[1].symbol;
    if (lhs === "True" && rhs === "True" || lhs === "False" && rhs === "False" || lhs === "False" && rhs === "True")
      return ce.True;
    if (lhs === "True" && rhs === "False") return ce.False;
    return void 0;
  }
  function simplifyLogicFunction(x) {
    const value = {
      And: evaluateAnd,
      Or: evaluateOr,
      Not: evaluateNot,
      Equivalent: evaluateEquivalent,
      Implies: evaluateImplies
    }[x.operator]?.(x.engine, x.ops);
    if (!value) return void 0;
    return { value, because: "logic" };
  }

  // src/compute-engine/symbolic/distribute.ts
  function distribute2(lhs, rhs, g, f) {
    const ce = lhs.engine;
    if (lhs.operator === g)
      return ce.box([f, ...lhs.ops.map((x) => distribute2(x, rhs, g, f))]);
    if (rhs.operator === g)
      return ce.box([f, ...rhs.ops.map((x) => distribute2(lhs, x, g, f))]);
    return ce.box([f, lhs, rhs]);
  }
  function distribute(expr, g = "Add", f = "Multiply") {
    if (expr.operator !== f) return expr;
    const ops = expr.ops;
    if (!ops || ops.length < 2) return expr;
    return expr.engine.box([
      g,
      ops.slice(1).reduce((acc, v) => distribute2(acc, v, g, f), ops[0])
    ]);
  }

  // src/compute-engine/library/polynomials.ts
  var POLYNOMIALS_LIBRARY = [
    {
      Expand: {
        description: "Expand out products and positive integer powers",
        lazy: true,
        signature: "(value)-> value",
        evaluate: ([x]) => expand2(x.canonical) ?? x
      },
      ExpandAll: {
        description: "Recursively expand out products and positive integer powers",
        lazy: true,
        signature: "(value)-> value",
        evaluate: ([x]) => expandAll(x) ?? x
      },
      Factor: {
        // @todo: extend to factor over the integers: return a ['Multiply', ['Power', a, b], ...]
        description: "Factors an algebraic expression into a product of irreducible factors",
        lazy: true,
        signature: "(value)-> value",
        evaluate: ([x]) => factor(x.canonical)
      },
      Together: {
        description: "Combine rational expressions into a single fraction",
        lazy: true,
        signature: "(value)-> value",
        evaluate: ([x]) => together(x)
      },
      Distribute: {
        description: "Distribute multiplication over addition",
        lazy: true,
        signature: "(value)-> value",
        evaluate: ([x]) => !x ? x : distribute(x)
      }
    }
  ];

  // src/compute-engine/library/relational-operator.ts
  var RELOP_LIBRARY = {
    Congruent: {
      description: "Indicate that two expressions are congruent modulo a number",
      complexity: 11e3,
      signature: "(number, number, modulo: integer) -> boolean",
      evaluate: (ops, { engine: ce }) => {
        if (ops.length < 3) return void 0;
        const [lhs, rhs, modulo] = ops;
        const nLhs = lhs.value;
        const nRhs = rhs.value;
        const nModulo = modulo.value;
        if (typeof nLhs !== "number") return void 0;
        if (typeof nRhs !== "number") return void 0;
        if (typeof nModulo !== "number") return void 0;
        return nLhs % nModulo === nRhs % nModulo ? ce.True : ce.False;
      }
    },
    IsSame: {
      description: "Compare two expressions for structural equality",
      lazy: true,
      signature: "(any, any) -> boolean",
      // Since we want to work on non-canonical expressions,
      // do nothing to canonicalize the arguments (the lazy flag will prevent
      // canonicalization of the arguments)
      evaluate: (ops, { engine: ce }) => {
        if (ops.length !== 2) return void 0;
        const [lhs, rhs] = ops;
        return lhs.isSame(rhs) ? ce.True : ce.False;
      }
    },
    Equal: {
      complexity: 11e3,
      signature: "(any, any) -> boolean",
      lazy: true,
      canonical: (args, { engine: ce }) => canonicalRelational(ce, "Equal", args),
      // Comparing two equalities...
      eq: (a, b) => {
        if (a.operator !== b.operator) return false;
        return a.op1.sub(a.op2).N().isEqual(b.op1.sub(b.op2).N());
      },
      evaluate: (ops, { engine: ce }) => {
        if (ops.length < 2) return ce.True;
        let lhs = void 0;
        for (const arg of ops) {
          if (!lhs) lhs = arg;
          else {
            const test = eq(lhs, arg);
            if (test !== true) return ce.False;
          }
        }
        return ce.True;
      }
    },
    NotEqual: {
      wikidata: "Q28113351",
      complexity: 11e3,
      signature: "(any, any) -> boolean",
      canonical: (args, { engine: ce }) => canonicalRelational(ce, "NotEqual", args),
      // Comparing two equalities...
      eq: (a, b) => {
        if (a.operator !== b.operator) return false;
        if (a.op1.isEqual(b.op1) && a.op2.isEqual(b.op2) || a.op1.isEqual(b.op2) && a.op2.isEqual(b.op1))
          return true;
        return false;
      },
      evaluate: (ops, { engine: ce }) => {
        if (ops.length < 2) return ce.False;
        let lhs = void 0;
        for (const arg of ops) {
          if (!lhs) lhs = arg;
          else {
            const test = lhs.isEqual(arg);
            if (test === true) return ce.False;
          }
        }
        return ce.True;
      }
    },
    Less: {
      complexity: 11e3,
      signature: "(any, any, ...any) -> boolean",
      canonical: (ops, { engine: ce }) => canonicalRelational(ce, "Less", ops),
      eq: (a, b) => inequalityEq(a, b, "Greater"),
      evaluate: (ops, { engine: ce }) => {
        if (ops.length === 2) {
          const [lhs2, rhs] = ops;
          const cmp2 = lhs2.isLess(rhs);
          if (cmp2 === void 0) return void 0;
          return cmp2 ? ce.True : ce.False;
        }
        if (ops.length < 2) return ce.True;
        let lhs = void 0;
        for (const arg of ops) {
          if (!lhs) lhs = arg;
          else {
            const cmp2 = arg.isLess(lhs);
            if (cmp2 === void 0) return void 0;
            if (cmp2 === false) return ce.False;
            lhs = arg;
          }
        }
        return ce.True;
      }
    },
    NotLess: {
      complexity: 11e3,
      signature: "(any, any, ...any) -> boolean",
      canonical: (ops, { engine: ce }) => ce._fn("Not", [canonicalRelational(ce, "Less", ops)])
    },
    Greater: {
      complexity: 11e3,
      signature: "(any, any, ...any) -> boolean",
      canonical: (ops, { engine: ce }) => canonicalRelational(ce, "Less", [...ops].reverse())
    },
    NotGreater: {
      complexity: 11e3,
      signature: "(any, any, ...any) -> boolean",
      canonical: (args, { engine: ce }) => ce._fn("Not", [ce._fn("Greater", args)])
    },
    LessEqual: {
      complexity: 11e3,
      signature: "(any, any, ...any) -> boolean",
      canonical: (ops, { engine: ce }) => canonicalRelational(ce, "LessEqual", ops),
      eq: (a, b) => inequalityEq(a, b, "LessGreater"),
      evaluate: (ops, { engine: ce }) => {
        if (ops.length === 2) {
          const [lhs2, rhs] = ops;
          const cmp2 = lhs2.isLessEqual(rhs);
          if (cmp2 === void 0) return void 0;
          return cmp2 ? ce.True : ce.False;
        }
        if (ops.length < 2) return ce.True;
        let lhs = void 0;
        for (const arg of ops) {
          if (!lhs) lhs = arg;
          else {
            const cmp2 = arg.isLessEqual(lhs);
            if (cmp2 === void 0) return void 0;
            if (cmp2 === false) return ce.False;
            lhs = arg;
          }
        }
        return ce.True;
      }
    },
    NotLessNotEqual: {
      complexity: 11e3,
      signature: "(any, any, ...any) -> boolean",
      canonical: (ops, { engine: ce }) => ce._fn("Not", [canonicalRelational(ce, "LessEqual", ops)])
    },
    GreaterEqual: {
      complexity: 11e3,
      signature: "(any, any, ...any) -> boolean",
      canonical: (args, { engine: ce }) => canonicalRelational(ce, "LessEqual", [...args].reverse())
    },
    NotGreaterNotEqual: {
      complexity: 11e3,
      signature: "(any, any, ...any) -> boolean",
      canonical: (args, { engine: ce }) => ce._fn("Not", [canonicalRelational(ce, "GreaterEqual", args)])
    },
    TildeFullEqual: {
      description: "Indicate isomorphism, congruence and homotopic equivalence",
      signature: "(any, any, ...any) -> boolean",
      canonical: (args, { engine: ce }) => canonicalRelational(ce, "TildeFullEqual", args)
      // @todo evaluate: (ce, ...args: BoxedExpression[]) => SemiBoxedExpression {}
    },
    NotTildeFullEqual: {
      complexity: 11100,
      signature: "(any, any, ...any) -> boolean",
      canonical: (args, { engine: ce }) => ce._fn("Not", [canonicalRelational(ce, "TildeFullEqual", args)])
    },
    TildeEqual: {
      description: "Approximately or asymptotically equal",
      complexity: 11e3,
      signature: "(any, any, ...any) -> boolean",
      canonical: (args, { engine: ce }) => canonicalRelational(ce, "TildeEqual", args)
      // @todo evaluate: (ce, ...args: BoxedExpression[]) => SemiBoxedExpression {}
    },
    NotTildeEqual: {
      complexity: 11100,
      signature: "(any, any, ...any) -> boolean",
      canonical: (args, { engine: ce }) => ce._fn("Not", [canonicalRelational(ce, "TildeEqual", args)])
    },
    Approx: {
      complexity: 11100,
      signature: "(any, any, ...any) -> boolean",
      canonical: (args, { engine: ce }) => canonicalRelational(ce, "Approx", args)
      // @todo evaluate: (ce, ...args: BoxedExpression[]) => SemiBoxedExpression {}
    },
    NotApprox: {
      complexity: 11100,
      signature: "(any, any, ...any) -> boolean",
      canonical: (args, { engine: ce }) => ce._fn("Not", [canonicalRelational(ce, "Approx", args)])
    },
    ApproxEqual: {
      complexity: 11100,
      signature: "(any, any, ...any) -> boolean",
      canonical: (args, { engine: ce }) => canonicalRelational(ce, "ApproxEqual", args)
      // @todo evaluate: (ce, ...args: BoxedExpression[]) => SemiBoxedExpression {}
    },
    NotApproxEqual: {
      complexity: 11100,
      canonical: (args, { engine: ce }) => ce._fn("Not", [canonicalRelational(ce, "ApproxEqual", args)])
    },
    ApproxNotEqual: {
      complexity: 11100,
      signature: "(any, any, ...any) -> boolean",
      canonical: (args, { engine: ce }) => canonicalRelational(ce, "ApproxNotEqual", args)
      // @todo evaluate: (ce, ...args: BoxedExpression[]) => SemiBoxedExpression {}
    },
    NotApproxNotEqual: {
      complexity: 11100,
      signature: "(any, any, ...any) -> boolean",
      canonical: (args, { engine: ce }) => ce._fn("Not", [canonicalRelational(ce, "ApproxNotEqual", args)])
    },
    Precedes: {
      complexity: 11100,
      signature: "(any, any, ...any) -> boolean",
      canonical: (args, { engine: ce }) => canonicalRelational(ce, "Precedes", args)
      // @todo evaluate: (ce, ...args: BoxedExpression[]) => SemiBoxedExpression {}
    },
    NotPrecedes: {
      complexity: 11100,
      signature: "(any, any, ...any) -> boolean",
      canonical: (args, { engine: ce }) => ce._fn("Not", [canonicalRelational(ce, "Precedes", args)])
    },
    Succeeds: {
      signature: "(any, any, ...any) -> boolean",
      canonical: (args, { engine: ce }) => canonicalRelational(ce, "Succeeds", args)
      // @todo evaluate: (ce, ...args: BoxedExpression[]) => SemiBoxedExpression {}
    },
    NotSucceeds: {
      complexity: 11100,
      signature: "(any, any, ...any) -> boolean",
      canonical: (args, { engine: ce }) => ce._fn("Not", [canonicalRelational(ce, "Succeeds", args)])
    }
  };
  function canonicalRelational(ce, operator2, ops) {
    ops = flatten(ops, operator2);
    const nestedRelational = [];
    const newOps = [];
    for (const op of ops) {
      if (isRelationalOperator(op)) {
        nestedRelational.push(op);
        newOps.push(op.ops[op.ops.length - 1]);
      } else newOps.push(op);
    }
    if (nestedRelational.length === 0) return ce._fn(operator2, newOps);
    return ce._fn("And", [ce._fn(operator2, newOps), ...nestedRelational]);
  }
  function inequalityEq(a, b, oppositeOperator) {
    if (a.operator === b.operator) {
      if (a.nops !== b.nops) return false;
      return a.ops.every((op, i) => op.isEqual(b.ops[i]));
    }
    if (b.operator === oppositeOperator) {
      if (a.nops !== b.nops) return false;
      return a.ops.every((op, i) => op.isEqual(b.ops[b.nops - 1 - i]));
    }
    return false;
  }

  // src/compute-engine/library/sets.ts
  var SETS_LIBRARY = {
    //
    // Constants
    //
    EmptySet: {
      type: "set",
      constant: true,
      wikidata: "Q226183",
      eq: (b) => b.type.matches("set") && b.size === 0,
      collection: {
        size: () => 0,
        contains: () => false,
        subsetOf: () => true,
        eltsgn: () => void 0,
        elttype: () => "never"
      }
    },
    Numbers: {
      type: "set<number>",
      constant: true,
      collection: {
        size: () => Infinity,
        contains: (_, x) => x.type.matches("number"),
        subsetOf: (_, rhs, strict) => {
          if (rhs.operator === "Range" || rhs.operator === "Linspace")
            return true;
          return rhs.type.matches("set<number>") && (!strict || rhs.symbol !== "Numbers");
        },
        eltsgn: () => "unsigned",
        elttype: () => "number"
      }
    },
    ComplexNumbers: {
      type: "set<finite_complex>",
      constant: true,
      collection: {
        size: () => Infinity,
        contains: (_, x) => x.type.matches("finite_complex"),
        subsetOf: (_, rhs, strict) => {
          if (rhs.operator === "Range" || rhs.operator === "Linspace")
            return true;
          return rhs.type.matches("set<complex>") && (!strict || rhs.symbol !== "ComplexNumbers");
        },
        eltsgn: () => "unsigned",
        elttype: () => "finite_complex"
      }
    },
    ExtendedComplexNumbers: {
      type: "set<complex>",
      constant: true,
      collection: {
        size: () => Infinity,
        contains: (_, x) => x.type.matches("complex"),
        subsetOf: (_, rhs, strict) => {
          if (rhs.operator === "Range" || rhs.operator === "Linspace")
            return true;
          return rhs.type.matches("set<complex>") && (!strict || rhs.symbol !== "ComplexNumbers");
        },
        eltsgn: () => "unsigned",
        elttype: () => "complex"
      }
    },
    ImaginaryNumbers: {
      type: "set<imaginary>",
      constant: true,
      collection: {
        size: () => Infinity,
        contains: (_, x) => x.type.matches("imaginary"),
        subsetOf: (_, rhs, strict) => rhs.type.matches("set<imaginary>") && (!strict || rhs.symbol !== "ImaginaryNumbers"),
        eltsgn: () => "unsigned",
        elttype: () => "imaginary"
      }
    },
    RealNumbers: {
      type: "set<finite_real>",
      constant: true,
      collection: {
        contains: (_, x) => x.type.matches("finite_real"),
        size: () => Infinity,
        subsetOf: (_, rhs, strict) => rhs.type.matches("set<real>") && (!strict || rhs.symbol !== "RealNumbers"),
        eltsgn: () => void 0,
        elttype: () => "finite_real"
      }
    },
    ExtendedRealNumbers: {
      type: "set<real>",
      constant: true,
      collection: {
        contains: (_, x) => x.type.matches("real"),
        size: () => Infinity,
        subsetOf: (_, rhs, strict) => rhs.type.matches("set<real>") && (!strict || rhs.symbol !== "ExtendedRealNumbers"),
        eltsgn: () => void 0,
        elttype: () => "real"
      }
    },
    Integers: {
      type: "set<finite_integer>",
      constant: true,
      collection: {
        contains: (_, x) => x.type.matches("finite_integer"),
        size: () => Infinity,
        subsetOf: (_, rhs, strict) => {
          if (rhs.operator === "Range") return true;
          return rhs.type.matches("set<finite_integer>") && (!strict || rhs.symbol !== "Integers");
        },
        eltsgn: () => void 0,
        elttype: () => "finite_integer"
      }
    },
    ExtendedIntegers: {
      type: "set<integer>",
      constant: true,
      collection: {
        contains: (_, x) => x.type.matches("integer"),
        size: () => Infinity,
        subsetOf: (_, rhs, strict) => {
          if (rhs.operator === "Range") return true;
          return rhs.type.matches("set<integer>") && (!strict || rhs.symbol !== "ExtendedIntegers");
        },
        eltsgn: () => void 0,
        elttype: () => "integer"
      }
    },
    RationalNumbers: {
      type: "set<finite_rational>",
      constant: true,
      collection: {
        size: () => Infinity,
        contains: (_, x) => x.type.matches("finite_rational"),
        subsetOf: (_, rhs, strict) => rhs.type.matches("set<rational>") && (!strict || rhs.symbol !== "RationalNumbers"),
        eltsgn: () => void 0,
        elttype: () => "finite_rational"
      }
    },
    ExtendedRationalNumbers: {
      type: "set<rational>",
      constant: true,
      collection: {
        contains: (_, x) => x.type.matches("rational"),
        size: () => Infinity,
        subsetOf: (_, rhs, strict) => rhs.type.matches("set<rational>") && (!strict || rhs.symbol !== "ExtendedRationalNumbers"),
        eltsgn: () => void 0,
        elttype: () => "rational"
      }
    },
    // < 0
    NegativeNumbers: {
      type: "set<real>",
      constant: true,
      collection: {
        size: () => Infinity,
        contains: (_, x) => x.type.matches("real") && x.isNegative === true,
        subsetOf: (_, rhs, strict) => {
          if (rhs.operator === "Range" || rhs.operator === "Linspace") {
            const low = rhs.ops[0].re;
            const high = rhs.ops[1].re;
            return low < 0 && high < 0;
          }
          return rhs.type.matches("set<real>") && rhs.symbolDefinition?.collection?.eltsgn?.(rhs) === "negative" && (!strict || rhs.symbol !== "NegativeNumbers");
        },
        eltsgn: () => "negative",
        elttype: () => "real"
      }
    },
    // <= 0
    NonPositiveNumbers: {
      type: "set<real>",
      constant: true,
      collection: {
        contains: (_, x) => x.type.matches("real") && x.isNonPositive === true,
        size: () => Infinity,
        subsetOf: (_, rhs, strict) => {
          if (rhs.operator === "Range" || rhs.operator === "Linspace") {
            const low = rhs.ops[0].re;
            const high = rhs.ops[1].re;
            return low >= 0 && high >= 0;
          }
          return rhs.type.matches("set<real>") && rhs.symbolDefinition?.collection?.eltsgn?.(rhs) === "non-positive" && (!strict || rhs.symbol !== "NonPositiveNumbers");
        },
        eltsgn: () => "non-positive",
        elttype: () => "real"
      }
    },
    // >= 0
    NonNegativeNumbers: {
      type: "set<real>",
      constant: true,
      collection: {
        contains: (_, x) => x.type.matches("real") && x.isNonNegative === true,
        size: () => Infinity,
        subsetOf: (_, rhs, strict) => {
          if (rhs.operator === "Range" || rhs.operator === "Linspace") {
            const low = rhs.ops[0].re;
            const high = rhs.ops[1].re;
            return low <= 0 && high <= 0;
          }
          return rhs.type.matches("set<real>") && rhs.symbolDefinition?.collection?.eltsgn?.(rhs) === "non-negative" && (!strict || rhs.symbol !== "NonNegativeNumbers");
        },
        eltsgn: () => "non-negative",
        elttype: () => "real"
      }
    },
    // > 0
    PositiveNumbers: {
      type: "set<real>",
      constant: true,
      collection: {
        contains: (_, x) => x.type.matches("real") && x.isPositive === true,
        size: () => Infinity,
        subsetOf: (_, rhs, strict) => {
          if (rhs.operator === "Range" || rhs.operator === "Linspace") {
            const low = rhs.ops[0].re;
            const high = rhs.ops[1].re;
            return low > 0 && high > 0;
          }
          return rhs.type.matches("set<real>") && rhs.symbolDefinition?.collection?.eltsgn?.(rhs) === "positive" && (!strict || rhs.symbol !== "PositiveNumbers");
        },
        eltsgn: () => "positive",
        elttype: () => "real"
      }
    },
    // <= -1
    NegativeIntegers: {
      type: "set<integer>",
      constant: true,
      collection: {
        contains: (_, x) => x.type.matches("integer") && x.isNegative === true,
        size: () => Infinity,
        subsetOf: (_, rhs, strict) => {
          if (rhs.operator === "Range") {
            const low = rhs.ops[0].re;
            const high = rhs.ops[1].re;
            return low < 0 && high < 0;
          }
          return rhs.type.matches("set<integer>") && rhs.symbolDefinition?.collection?.eltsgn?.(rhs) === "negative" && (!strict || rhs.symbol !== "NegativeIntegers");
        },
        eltsgn: () => "negative",
        elttype: () => "integer"
      }
    },
    // <= 0
    NonPositiveIntegers: {
      type: "set<integer>",
      constant: true,
      collection: {
        contains: (_, x) => x.type.matches("integer") && x.isNonPositive === true,
        size: () => Infinity,
        subsetOf: (_, rhs, strict) => {
          if (rhs.operator === "Range") {
            const low = rhs.ops[0].re;
            const high = rhs.ops[1].re;
            return low <= 0 && high <= 0;
          }
          return rhs.type.matches("set<integer>") && rhs.symbolDefinition?.collection?.eltsgn?.(rhs) === "non-positive" && (!strict || rhs.symbol !== "NonPositiveIntegers");
        },
        eltsgn: () => "non-positive",
        elttype: () => "integer"
      }
    },
    // >= 0
    NonNegativeIntegers: {
      type: "set<integer>",
      constant: true,
      collection: {
        contains: (_, x) => x.type.matches("integer") && x.isNonNegative === true,
        size: () => Infinity,
        subsetOf: (_, rhs, strict) => {
          if (rhs.operator === "Range") {
            const low = rhs.ops[0].re;
            const high = rhs.ops[1].re;
            return low > 0 && high > 0;
          }
          return rhs.type.matches("set<integer>") && rhs.symbolDefinition?.collection?.eltsgn?.(rhs) === "non-negative" && (!strict || rhs.symbol !== "NonNegativeIntegers");
        },
        eltsgn: () => "non-negative",
        elttype: () => "integer"
      }
    },
    // >= 1
    PositiveIntegers: {
      type: "set<integer>",
      constant: true,
      collection: {
        contains: (_, x) => x.type.matches("integer") && x.isPositive === true,
        size: () => Infinity,
        subsetOf: (_, rhs, strict) => {
          if (rhs.operator === "Range") {
            const low = rhs.ops[0].re;
            const high = rhs.ops[1].re;
            return low > 0 && high > 0;
          }
          return rhs.type.matches("set<integer>") && rhs.symbolDefinition?.collection?.eltsgn?.(rhs) === "positive" && (!strict || rhs.symbol !== "PositiveIntegers");
        },
        eltsgn: () => "positive",
        elttype: () => "integer"
      }
    },
    //
    // Predicates
    //
    Element: {
      complexity: 11200,
      signature: "(value, collection|string) -> boolean",
      evaluate: ([value, collection], { engine: ce }) => {
        const result = collection.contains(value);
        if (result === true) return ce.True;
        if (result === false) return ce.False;
        return void 0;
      }
    },
    NotElement: {
      complexity: 11200,
      signature: "(value, collection|string) -> boolean",
      evaluate: ([value, collection], { engine: ce }) => {
        const result = collection.contains(value);
        if (result === true) return ce.False;
        if (result === false) return ce.True;
        return void 0;
      }
    },
    Subset: {
      complexity: 11200,
      signature: "(lhs:collection, rhs: collection) -> boolean",
      evaluate: ([lhs, rhs], { engine: ce }) => {
        const result = subset(lhs, rhs);
        if (result === true) return ce.True;
        if (result === false) return ce.False;
        return void 0;
      }
    },
    SubsetEqual: {
      complexity: 11200,
      signature: "(lhs:collection, rhs: collection) -> boolean",
      evaluate: ([lhs, rhs], { engine: ce }) => {
        const result = subset(lhs, rhs, false);
        if (result === true) return ce.True;
        if (result === false) return ce.False;
        return void 0;
      }
    },
    NotSubset: {
      complexity: 11200,
      signature: "(lhs:collection, rhs: collection) -> boolean",
      evaluate: ([lhs, rhs], { engine: ce }) => {
        const result = subset(lhs, rhs);
        if (result === true) return ce.False;
        if (result === false) return ce.True;
        return void 0;
      }
    },
    Superset: {
      complexity: 11200,
      signature: "(lhs:collection, rhs: collection) -> boolean",
      evaluate: ([lhs, rhs], { engine: ce }) => {
        const result = subset(rhs, lhs);
        if (result === true) return ce.True;
        if (result === false) return ce.False;
        return void 0;
      }
    },
    SupersetEqual: {
      complexity: 11200,
      signature: "(lhs:collection, rhs: collection) -> boolean",
      evaluate: ([lhs, rhs], { engine: ce }) => {
        const result = subset(rhs, lhs, true);
        if (result === true) return ce.True;
        if (result === false) return ce.False;
        return void 0;
      }
    },
    NotSuperset: {
      complexity: 11200,
      signature: "(lhs:collection, rhs: collection) -> boolean",
      evaluate: ([lhs, rhs], { engine: ce }) => {
        const result = subset(rhs, lhs);
        if (result === true) return ce.False;
        if (result === false) return ce.True;
        return void 0;
      }
    },
    NotSupersetEqual: {
      complexity: 11200,
      signature: "(lhs:collection, rhs: collection) -> boolean",
      evaluate: ([lhs, rhs], { engine: ce }) => {
        const result = subset(rhs, lhs, true);
        if (result === true) return ce.False;
        if (result === false) return ce.True;
        return void 0;
      }
    },
    // NotSubsetNotEqual: {
    //   complexity: 11200,
    //   signature: {
    //     domain: 'Predicates',
    //     canonical: (args, { engine: ce }) =>
    //       ce._fn('Not', [ce.function('SubsetEqual', args)]),
    //   },
    // },
    //
    // Functions
    //
    CartesianProduct: {
      // Aka the product set, the set direct product or cross product
      // Notation: \times
      wikidata: "Q173740",
      signature: "(set, ...set) -> set"
      // evaluate: cartesianProduct, // @todo
    },
    Complement: {
      // Return the elements of the first argument that are not in any of
      // the subsequent sets
      wikidata: "Q242767",
      signature: "(set, ...set) -> set"
      //     evaluate: (ops, { engine: ce }) => { // @todo
    },
    Intersection: {
      // notation: \cap
      wikidata: "Q185837",
      signature: "(set, ...set) -> set",
      canonical: (args, { engine: ce }) => {
        if (args.length === 0) return ce.symbol("EmptySet");
        if (args.length === 1) return ce.symbol("EmptySet");
        args = validateArguments(
          ce,
          flatten(args, "Intersection"),
          parseType("(set, ...set) -> set")
        ) ?? args;
        return ce._fn("Intersection", args);
      },
      evaluate: intersection
    },
    Union: {
      // Works on set, but can also work on lists
      wikidata: "Q185359",
      signature: "(collection, ...collection) -> set",
      canonical: (args, { engine: ce }) => {
        if (args.length === 0) return ce.symbol("EmptySet");
        args = validateArguments(
          ce,
          flatten(args, "Union"),
          parseType("(collection, ...collection) -> set")
        ) ?? args;
        return ce._fn("Union", args);
      },
      evaluate: union,
      // These handlers will get called if we have a lazy collection,
      // that is a union of collections with more than MAX_SIZE_EAGER_COLLECTION
      // elements. Otherwise, when we evaluated the union, we got a set literal.
      collection: {
        contains: (col, x) => col.ops.some((op) => op.contains(x)),
        size: (col) => {
          if (col.ops.some((op) => op.size === Infinity)) return Infinity;
          const seen = [];
          let count = 0;
          for (const op of col.ops) {
            for (const elem of each(op)) {
              if (seen.every((e) => !e.contains(elem))) count += 1;
            }
            seen.push(op);
          }
          return count;
        },
        iterator: (col) => {
          const seen = [];
          let current = 0;
          let iter = iterator(col.ops[current]);
          if (!iter) return { next: () => ({ value: void 0, done: true }) };
          return {
            next: () => {
              let found = false;
              let iterResult;
              do {
                iterResult = iter.next();
                if (iterResult.done) {
                  seen.push(col.ops[current]);
                  current += 1;
                  if (current === col.ops.length)
                    return { value: void 0, done: true };
                  iter = iterator(col.ops[current]);
                  if (!iter) return { value: void 0, done: true };
                }
                found = seen.every((e) => !e.contains(iterResult.value));
              } while (!found);
              return { value: iterResult.value, done: false };
            }
          };
        }
      }
    },
    SetMinus: {
      wikidata: "Q18192442",
      signature: "(set, ...value) -> set",
      evaluate: setMinus,
      collection: {
        contains: (expr, x) => {
          const [col, ...values] = expr.ops;
          return (col.contains(x) ?? false) && !values.some((val) => val.isSame(x));
        },
        iterator: (expr) => {
          const [col, ...values] = expr.ops;
          const iter = iterator(col);
          if (!iter) return { next: () => ({ value: void 0, done: true }) };
          return {
            next() {
              let result = iter.next();
              while (!result.done && values.some((val) => val.isSame(result.value)))
                result = iter.next();
              return result;
            }
          };
        }
      }
    },
    SymmetricDifference: {
      // symmetric difference = disjunctive union  (circled minus)
      /* = Union(Complement(a, b), Complement(b, a) */
      /* Corresponds to XOR in boolean logic */
      wikidata: "Q1147242",
      signature: "(set, set) -> set"
    }
  };
  function subset(lhs, rhs, strict = true) {
    if (!lhs.isCollection || !rhs.isCollection) return false;
    if (lhs.symbolDefinition?.collection?.subsetOf?.(lhs, rhs, strict))
      return true;
    return false;
  }
  function union(ops, { engine: ce }) {
    const xs = ops.map((op) => op.isCollection ? op : ce.function("Set", [op]));
    const totalSize = xs.reduce((acc, op) => acc + (op.size ?? 0), 0);
    if (totalSize > MAX_SIZE_EAGER_COLLECTION) return ce._fn("Union", xs);
    const elements = [];
    for (const op of xs) {
      for (const elem of each(op))
        if (elements.every((e) => !e.isSame(elem))) elements.push(elem);
    }
    if (elements.length === 0) return ce.symbol("EmptySet");
    return ce._fn("Set", elements);
  }
  function intersection(ops, { engine: ce }) {
    let elements = [...ops[0].ops ?? []];
    for (const op of ops.slice(1)) {
      if (isFiniteIndexableCollection(op)) {
        elements = elements.filter(
          (element) => [...each(op)].some((op2) => element.isSame(op2))
        );
      } else {
        elements = elements.filter((element) => element.isSame(op));
      }
    }
    if (elements.length === 0) return ce.symbol("EmptySet");
    return ce._fn("Set", elements);
  }
  function setMinus(_ops, { engine: ce }) {
    return ce.symbol("EmptySet");
  }

  // src/compute-engine/library/statistics.ts
  var STATISTICS_LIBRARY = [
    {
      Choose: {
        complexity: 1200,
        signature: "(n:number, m:number) -> number",
        evaluate: (ops, { engine: ce }) => {
          const n = ops[0].re;
          const k = ops[1].re;
          if (!Number.isFinite(n) || !Number.isFinite(k)) return void 0;
          if (n < 0 || k < 0 || k > n) return ce.NaN;
          return ce.number(choose(n, k));
        }
      }
    },
    {
      // https://towardsdatascience.com/on-average-youre-using-the-wrong-average-geometric-harmonic-means-in-data-analysis-2a703e21ea0?gi=d56d047586c6
      // https://towardsdatascience.com/on-average-youre-using-the-wrong-average-part-ii-b32fcb41527e
      Mean: {
        complexity: 1200,
        threadable: false,
        signature: "((collection|number)...) -> number",
        evaluate: (ops, { engine }) => engine.number(
          bignumPreferred(engine) ? bigMean(engine.bignum.bind(engine), flattenBigScalars(ops)) : mean(flattenScalars(ops))
        )
      },
      Median: {
        complexity: 1200,
        threadable: false,
        signature: "((collection|number)...) -> number",
        evaluate: (ops, { engine }) => engine.number(
          bignumPreferred(engine) ? bigMedian(flattenBigScalars(ops)) : median(flattenScalars(ops))
        )
      },
      Variance: {
        complexity: 1200,
        threadable: false,
        signature: "((collection|number)...) -> number",
        evaluate: (ops, { engine }) => engine.number(
          bignumPreferred(engine) ? bigVariance(engine.bignum.bind(engine), flattenBigScalars(ops)) : variance(flattenScalars(ops))
        )
      },
      PopulationVariance: {
        complexity: 1200,
        threadable: false,
        signature: "((collection|number)...) -> number",
        evaluate: (ops, { engine }) => engine.number(
          bignumPreferred(engine) ? bigPopulationVariance(
            engine.bignum.bind(engine),
            flattenBigScalars(ops)
          ) : populationVariance(flattenScalars(ops))
        )
      },
      StandardDeviation: {
        complexity: 1200,
        threadable: false,
        description: "Sample Standard Deviation of a collection of numbers.",
        signature: "((collection|number)...) -> number",
        evaluate: (ops, { engine }) => engine.number(
          bignumPreferred(engine) ? bigVariance(
            engine.bignum.bind(engine),
            flattenBigScalars(ops)
          ).sqrt() : Math.sqrt(variance(flattenScalars(ops)))
        )
      },
      PopulationStandardDeviation: {
        complexity: 1200,
        threadable: false,
        description: "Population Standard Deviation of a collection of numbers.",
        signature: "((collection|number)...) -> number",
        evaluate: (ops, { engine }) => engine.number(
          bignumPreferred(engine) ? bigPopulationVariance(
            engine.bignum.bind(engine),
            flattenBigScalars(ops)
          ).sqrt() : Math.sqrt(populationVariance(flattenScalars(ops)))
        )
      },
      Kurtosis: {
        complexity: 1200,
        threadable: false,
        signature: "((collection|number)...) -> number",
        evaluate: (ops, { engine }) => engine.number(
          bignumPreferred(engine) ? bigKurtosis(engine.bignum.bind(engine), flattenBigScalars(ops)) : kurtosis(flattenScalars(ops))
        )
      },
      Skewness: {
        complexity: 1200,
        threadable: false,
        signature: "((collection|number)...) -> number",
        evaluate: (ops, { engine }) => engine.number(
          bignumPreferred(engine) ? bigSkewness(engine.bignum.bind(engine), flattenBigScalars(ops)) : skewness(flattenScalars(ops))
        )
      },
      Mode: {
        complexity: 1200,
        threadable: false,
        signature: "((collection|number)...) -> number",
        evaluate: (ops, { engine }) => engine.number(
          bignumPreferred(engine) ? bigMode(engine.bignum.bind(engine), flattenBigScalars(ops)) : mode(flattenScalars(ops))
        )
      },
      Quartiles: {
        complexity: 1200,
        threadable: false,
        signature: "((collection|number)...) -> tuple<mid:number, lower:number, upper:number>",
        evaluate: (ops, { engine }) => {
          const [mid, lower, upper] = (bignumPreferred(engine) ? bigQuartiles(flattenBigScalars(ops)) : quartiles(flattenScalars(ops))).map((v) => engine.number(v));
          return engine.tuple(mid, lower, upper);
        }
      },
      InterquartileRange: {
        complexity: 1200,
        threadable: false,
        signature: "((collection|number)...) -> number",
        evaluate: (ops, { engine }) => engine.number(
          bignumPreferred(engine) ? bigInterquartileRange(flattenBigScalars(ops)) : interquartileRange(flattenScalars(ops))
        )
      },
      Erf: {
        complexity: 7500,
        signature: "number -> number",
        evaluate: (ops, { engine: ce }) => {
          const x = ops[0].re;
          if (!Number.isFinite(x)) return void 0;
          return ce.number(erf(x));
        }
      },
      Erfc: {
        complexity: 7500,
        signature: "number -> number",
        evaluate: (ops, { engine: ce }) => {
          const x = ops[0].re;
          if (!Number.isFinite(x)) return void 0;
          return ce.number(1 - erf(x));
        }
      },
      ErfInv: {
        complexity: 7500,
        signature: "number -> number",
        evaluate: (ops, { engine: ce }) => {
          const x = ops[0].re;
          if (!Number.isFinite(x)) return void 0;
          return ce.number(erfInv(x));
        }
      }
    }
  ];
  function* flattenArguments(args) {
    if (args.length === 1 && isFiniteCollection(args[0])) yield* each(args[0]);
    else {
      for (const arg of args) {
        if (isFiniteCollection(arg)) {
          yield* each(arg);
        } else {
          yield arg;
        }
      }
    }
  }
  function* flattenScalars(args) {
    for (const op of flattenArguments(args)) yield op.re;
  }
  function* flattenBigScalars(args) {
    for (const op of flattenArguments(args))
      yield op.bignumRe ?? op.engine.bignum(op.re);
  }

  // src/compute-engine/boxed-expression/trigonometry.ts
  var TRIG_IDENTITIES = {
    Sin: [
      [1, "Sin"],
      [1, "Cos"],
      [-1, "Sin"],
      [-1, "Cos"]
    ],
    Cos: [
      [1, "Cos"],
      [-1, "Sin"],
      [-1, "Cos"],
      [1, "Sin"]
    ],
    Sec: [
      [1, "Sec"],
      [-1, "Csc"],
      [-1, "Sec"],
      [1, "Csc"]
    ],
    Csc: [
      [1, "Csc"],
      [1, "Sec"],
      [-1, "Csc"],
      [-1, "Sec"]
    ],
    Tan: [
      [1, "Tan"],
      [-1, "Cot"],
      [1, "Tan"],
      [-1, "Cot"]
    ],
    Cot: [
      [1, "Cot"],
      [-1, "Tan"],
      [1, "Cot"],
      [-1, "Tan"]
    ]
  };
  var S2 = ["Sqrt", 2];
  var S3 = ["Sqrt", 3];
  var S5 = ["Sqrt", 5];
  var S6 = ["Sqrt", 6];
  var CONSTRUCTIBLE_VALUES = [
    [
      [0, 1],
      {
        Sin: 0,
        Cos: 1,
        Tan: 0,
        Cot: "ComplexInfinity",
        Sec: 1,
        Csc: "ComplexInfinity"
      }
    ],
    [
      [1, 12],
      {
        Sin: ["Divide", ["Subtract", S6, S2], 4],
        Cos: ["Divide", ["Add", S6, S2], 4],
        Tan: ["Subtract", 2, S3],
        Cot: ["Add", 2, S3],
        Sec: ["Subtract", S6, S2],
        Csc: ["Add", S6, S2]
      }
    ],
    [
      [1, 10],
      {
        Sin: ["Divide", ["Subtract", S5, 1], 4],
        Cos: ["Divide", ["Sqrt", ["Add", 10, ["Multiply", 2, S5]]], 4],
        Tan: ["Divide", ["Sqrt", ["Subtract", 25, ["Multiply", 10, S5]]], 5],
        Cot: ["Sqrt", ["Add", 5, ["Multiply", 2, S5]]],
        Sec: ["Divide", ["Sqrt", ["Subtract", 50, ["Multiply", 10, S5]]], 5],
        Csc: ["Add", 1, S5]
      }
    ],
    [
      [1, 8],
      {
        Sin: "$\\frac{\\sqrt{2-\\sqrt2}}{2}$",
        Cos: "$\\frac{\\sqrt {2+{\\sqrt {2}}}}{2}$",
        Tan: "$\\sqrt{2} - 1$",
        Cot: "$\\sqrt{2} + 1$",
        Sec: "$\\sqrt{ 4 - 2\\sqrt{2}}$",
        Csc: "$\\sqrt{ 4 + 2\\sqrt{2}}$"
      }
    ],
    [
      [1, 6],
      {
        Sin: "$\\frac{1}{2}$",
        Cos: "$\\frac{\\sqrt{3}}{2}$",
        Tan: "$\\frac{\\sqrt{3}}{3}$",
        Cot: "$\\sqrt{3}$",
        Sec: "$\\frac{2\\sqrt{3}}{3}$",
        Csc: 2
      }
    ],
    [
      [1, 5],
      {
        Sin: "$\\frac{\\sqrt{10- 2\\sqrt{5}}} {4}$",
        Cos: "$\\frac{1+ \\sqrt{5}} {4}$",
        Tan: "$\\sqrt{5-2\\sqrt5}$",
        Cot: "$\\frac{\\sqrt{25+10\\sqrt5}} {5}$",
        Sec: "$\\sqrt{5} - 1$",
        Csc: "$\\frac{\\sqrt{50+10\\sqrt{5}}} {5}$"
      }
    ],
    [
      [1, 4],
      {
        Sin: ["Divide", S2, 2],
        Cos: ["Divide", S2, 2],
        Tan: 1,
        Cot: 1,
        Sec: S2,
        Csc: S2
      }
    ],
    [
      [3, 10],
      {
        Sin: "$\\frac{1+ \\sqrt5} {4}$",
        Cos: "$\\frac{\\sqrt{10- 2\\sqrt5}} {4}$",
        Tan: "$\\frac{\\sqrt{25+10\\sqrt5}} {5}$",
        Cot: "$\\sqrt{5-2\\sqrt5}$",
        Sec: "$\\frac{\\sqrt{50+10\\sqrt5}} {5}$",
        Csc: "$\\sqrt5-1$"
      }
    ],
    [
      [1, 3],
      {
        Sin: ["Divide", S3, 2],
        // '$\\frac{\\sqrt{3}}{2}$'
        Cos: "Half",
        // '$\\frac{1}{2}$'
        Tan: S3,
        // '$\\sqrt{3}$'
        Cot: ["Divide", S3, 3],
        // '$\\frac{\\sqrt{3}}{3}$'
        Sec: 2,
        Csc: ["Divide", ["Multiply", 2, S3], 3]
        // '$\\frac{2\\sqrt{3}}{3}$'
      }
    ],
    [
      [3, 8],
      {
        Sin: "$\\frac{ \\sqrt{2 + \\sqrt{2}} } {2}$",
        Cos: "$\\frac{ \\sqrt{2 - \\sqrt{2}} } {2}$",
        Tan: "$\\sqrt{2} + 1$",
        Cot: "$\\sqrt{2} - 1$",
        Sec: "$\\sqrt{ 4 + 2 \\sqrt{2} }$",
        Csc: "$\\sqrt{ 4 - 2 \\sqrt{2} }$"
      }
    ],
    [
      [2, 5],
      {
        Sin: "$\\frac{\\sqrt{10+ 2\\sqrt{5}}} {4}$",
        Cos: "$\\frac{\\sqrt{5}-1} {4}$",
        Tan: "$\\sqrt{5+2\\sqrt{5}}$",
        Cot: "$\\frac{\\sqrt{25-10\\sqrt{5}}} {5}$",
        Sec: "$1 + \\sqrt{5}$",
        Csc: "$\\frac{\\sqrt{50-10\\sqrt{5}}} {5}$"
      }
    ],
    [
      [5, 12],
      {
        Sin: "$\\frac{\\sqrt{6} + \\sqrt{2}} {4}$",
        Cos: "$\\frac{ \\sqrt{6} - \\sqrt{2}} {4}$",
        Tan: "$2+\\sqrt{3}$",
        Cot: "$2-\\sqrt{3}$",
        Sec: "$\\sqrt{6}+\\sqrt{2}$",
        Csc: "$\\sqrt{6} - \\sqrt{2}$"
      }
    ],
    [
      [1, 2],
      {
        Sin: 1,
        Cos: 0,
        Tan: "ComplexInfinity",
        Cot: 0,
        Sec: "ComplexInfinity",
        Csc: 1
      }
    ]
  ];
  function applyAngle(angle, fn, bigFn, complexFn) {
    const theta = canonicalAngle(angle)?.N();
    if (theta === void 0) return void 0;
    return apply(theta, fn, bigFn, complexFn);
  }
  function radiansToAngle(x) {
    if (!x) return x;
    const ce = x.engine;
    const angularUnit = ce.angularUnit;
    if (angularUnit === "rad") return x;
    const theta = x.N().re;
    if (Number.isNaN(theta)) return x;
    if (angularUnit === "deg") return ce.number(theta * (180 / Math.PI));
    if (angularUnit === "grad") return ce.number(theta * (200 / Math.PI));
    if (angularUnit === "turn") return ce.number(theta / (2 * Math.PI));
    return x;
  }
  function evalTrig(name, op) {
    if (!op) return void 0;
    const ce = op.engine;
    switch (name) {
      case "Arccos":
        return radiansToAngle(
          apply(
            op,
            Math.acos,
            (x) => x.acos(),
            (x) => x.acos()
          )
        );
      case "Arccot":
        return radiansToAngle(
          apply(
            op,
            (x) => Math.atan2(1, x),
            (x) => Decimal.atan2(ce._BIGNUM_ONE, x),
            (x) => x.inverse().atan()
          )
        );
      case "Arccsc":
        return radiansToAngle(
          apply(
            op,
            (x) => Math.asin(1 / x),
            (x) => ce._BIGNUM_ONE.div(x).asin(),
            (x) => x.inverse().asin()
          )
        );
      case "Arccosh":
        return radiansToAngle(
          apply(
            op,
            Math.acosh,
            (x) => x.acosh(),
            (x) => x.acosh()
          )
        );
      case "Arccoth":
        return radiansToAngle(
          apply(
            op,
            (x) => Math.log((1 + x) / (x - 1)) / 2,
            (x) => ce._BIGNUM_ONE.add(x).div(x.sub(ce._BIGNUM_ONE)).log().div(2),
            (x) => ce.complex(1).add(x).div(x.sub(1)).log().div(2)
          )
        );
      case "Arccsch":
        return radiansToAngle(
          apply(
            op,
            (x) => Math.log(1 / x + Math.sqrt(1 / (x * x) + 1)),
            (x) => ce._BIGNUM_ONE.div(x.mul(x)).add(ce._BIGNUM_ONE).sqrt().add(ce._BIGNUM_ONE.div(x)).log(),
            (x) => x.mul(x).inverse().add(1).sqrt().add(x.inverse()).log()
          )
        );
      case "Arcsec":
        return radiansToAngle(
          apply(
            op,
            (x) => Math.acos(1 / x),
            (x) => ce._BIGNUM_ONE.div(x).acos(),
            (x) => x.inverse().acos()
          )
        );
      case "Arcsin":
        return radiansToAngle(
          apply(
            op,
            Math.asin,
            (x) => x.asin(),
            (x) => x.asin()
          )
        );
      case "Arcsech":
        return radiansToAngle(
          apply(
            op,
            (x) => Math.log((1 + Math.sqrt(1 - x * x)) / x),
            (x) => ce._BIGNUM_ONE.sub(x.mul(x).add(ce._BIGNUM_ONE).div(x)).log(),
            (x) => ce.complex(1).sub(x.mul(x)).add(1).div(x).log()
          )
        );
      case "Arcsinh":
        return radiansToAngle(
          apply(
            op,
            Math.asinh,
            (x) => x.asinh(),
            (x) => x.asinh()
          )
        );
      case "Arctan":
        return radiansToAngle(
          apply(
            op,
            Math.atan,
            (x) => x.atan(),
            (x) => x.atan()
          )
        );
      case "Arctanh":
        return radiansToAngle(
          apply(
            op,
            Math.atanh,
            (x) => x.atanh(),
            (x) => x.atanh()
          )
        );
      case "Cos":
        return applyAngle(
          op,
          Math.cos,
          (x) => ce.chop(x.cos()),
          (x) => x.cos()
        );
      case "Cosh":
        return applyAngle(
          op,
          Math.cosh,
          (x) => x.cosh(),
          (x) => x.cosh()
        );
      case "Cot":
        return applyAngle(
          op,
          (x) => 1 / Math.tan(x),
          (x) => ce._BIGNUM_ONE.div(x.tan()),
          (x) => x.tan().inverse()
        );
      case "Coth":
        return applyAngle(
          op,
          (x) => 1 / Math.tanh(x),
          (x) => ce._BIGNUM_ONE.div(x.tanh()),
          (x) => x.tanh().inverse()
        );
      case "Csc":
        return applyAngle(
          op,
          (x) => 1 / Math.sin(x),
          (x) => ce._BIGNUM_ONE.div(x.sin()),
          (x) => x.sin().inverse()
        );
      case "Csch":
        return applyAngle(
          op,
          (x) => 1 / Math.sinh(x),
          (x) => ce._BIGNUM_ONE.div(x.sinh()),
          (x) => x.sinh().inverse()
        );
      case "Sec":
        return applyAngle(
          op,
          (x) => 1 / Math.cos(x),
          (x) => ce._BIGNUM_ONE.div(x.cos()),
          (x) => x.cos().inverse()
        );
      case "Sech":
        return applyAngle(
          op,
          (x) => 1 / Math.cosh(x),
          (x) => ce._BIGNUM_ONE.div(x.cosh()),
          (x) => x.cosh().inverse()
        );
      case "Sin":
        return applyAngle(
          op,
          Math.sin,
          (x) => ce.chop(x.sin()),
          (x) => x.sin()
        );
      case "Sinh":
        return applyAngle(
          op,
          Math.sinh,
          (x) => x.sinh(),
          (x) => x.sinh()
        );
      case "Tan": {
        const result = applyAngle(
          op,
          (x) => {
            const y = Math.tan(x);
            if (y > 1e6 || y < -1e6) return ce.ComplexInfinity;
            return y;
          },
          (x) => {
            const y = x.tan();
            if (y.greaterThan(1e6) || y.lessThan(-1e6)) return ce.ComplexInfinity;
            return y;
          },
          (x) => x.tan()
        );
        return result;
      }
      case "Tanh":
        return applyAngle(
          op,
          Math.tanh,
          (x) => x.tanh(),
          (x) => x.tanh()
        );
    }
    return void 0;
  }
  function isInverseTrigFunc(name) {
    if (name.startsWith("Ar") && inverseTrigFuncName(name)) return true;
    return false;
  }
  function inverseTrigFuncName(name) {
    return {
      Sin: "Arcsin",
      Cos: "Arccos",
      Tan: "Arctan",
      Sec: "Arcsec",
      Csc: " Arccsc",
      Sinh: "Arcsinh",
      Cosh: "Arccosh",
      Tanh: "Arctanh",
      Sech: "Arcsech",
      Csch: "Arccsch",
      Arccosh: "Cosh",
      Arccos: "Cos",
      Arccsc: "Csc",
      Arccsch: "Csch",
      // '??': 'Cot',
      // '??': 'Coth',
      Arcsec: "Sec",
      Arcsin: "Sin",
      Arcsinh: "Sinh",
      Arctan: "Tan",
      Arctanh: "Tanh"
    }[name];
  }
  function processInverseFunction(ce, xs) {
    if (xs.length !== 1 || !xs[0].isValid) return void 0;
    const expr = xs[0];
    const name = expr.symbol;
    if (typeof name !== "string") return void 0;
    if (name === "InverseFunction") return expr.op1;
    const newHead = inverseTrigFuncName(name);
    return newHead ? ce.symbol(newHead) : void 0;
  }
  function trigFuncParity(name) {
    return name !== "Cos" && name !== "Sec" ? -1 : 1;
  }
  function constructibleValuesInverse(ce, operator2, x, specialValues) {
    if (!x) return void 0;
    let x_N = x.N().re;
    if (Number.isNaN(x_N)) return void 0;
    const inv_operator = inverseTrigFuncName(operator2);
    const specialInverseValues = ce.cache(
      "constructible-inverse-trigonometric-values-" + operator2,
      () => {
        const cache = [];
        for (const [[n, d], value] of specialValues) {
          const r = value[inv_operator];
          if (r === void 0) continue;
          const rn = r.N().re;
          if (Number.isNaN(rn)) continue;
          cache.push([
            [r, rn],
            [n, d]
          ]);
        }
        return cache;
      },
      (cache) => {
        for (const [[match_arg, match_arg_N], [n, d]] of cache) {
          match_arg.reset();
        }
        return cache;
      }
    );
    let quadrant3 = 0;
    if (x_N < 0) {
      quadrant3 = trigFuncParity(inv_operator) == -1 ? -1 : 1;
      x_N = -x_N;
      x = x.neg();
    }
    for (const [[match_arg, match_arg_N], [n, d]] of specialInverseValues) {
      if (ce.chop(x_N - match_arg_N) === 0) {
        let theta = ce.Pi.mul(n).div(d);
        if (quadrant3 == -1) theta = theta.neg();
        else if (quadrant3 == 1) theta = ce.Pi.sub(theta);
        return theta.evaluate();
      }
    }
    return void 0;
  }
  function trigSign(operator2, x) {
    const [q, pos] = quadrant2(x);
    if (q === void 0) return void 0;
    if (pos !== void 0) {
      if ((operator2 === "Sin" || operator2 === "Tan") && (pos === 0 || pos === 2))
        return "zero";
      if ((operator2 === "Cos" || operator2 === "Cot") && (pos === 1 || pos === 3))
        return "zero";
    }
    return {
      Sin: ["positive", "positive", "negative", "negative"],
      Cos: ["positive", "negative", "negative", "positive"],
      Sec: ["positive", "negative", "negative", "positive"],
      Csc: ["positive", "positive", "negative", "negative"],
      Tan: ["positive", "negative", "positive", "negative"],
      Cot: ["positive", "negative", "positive", "negative"]
    }[operator2]?.[q];
  }
  function isConstructible(x) {
    return ["Sin", "Cos", "Tan", "Csc", "Sec", "Cot"].includes(
      typeof x === "string" ? x : x.operator
    );
  }
  function constructibleValues(operator2, x) {
    if (!x || !isConstructible(operator2)) return void 0;
    const ce = x.engine;
    x = x.N();
    if (x.im !== 0) return void 0;
    let theta = x.re;
    if (Number.isNaN(theta)) return void 0;
    const specialValues = ce.cache(
      "constructible-trigonometric-values",
      () => {
        return CONSTRUCTIBLE_VALUES.map(([val, results]) => [
          val,
          Object.fromEntries(
            Object.entries(results).map(([op, r]) => [
              op,
              (ce.parse(asLatexString(r)) ?? ce.box(r)).simplify()
            ])
          )
        ]);
      },
      (cache) => {
        for (const [_k, v] of cache) {
          for (const v2 of Object.values(v)) v2.reset();
        }
        return cache;
      }
    );
    if (isInverseTrigFunc(operator2))
      return constructibleValuesInverse(ce, operator2, x, specialValues);
    const angularUnit = ce.angularUnit;
    if (angularUnit !== "rad") {
      if (angularUnit === "deg") theta *= Math.PI / 180;
      if (angularUnit === "grad") theta *= Math.PI / 200;
      if (angularUnit === "turn") theta *= 2 * Math.PI;
    }
    const identitySign = trigFuncParity(operator2) == -1 ? Math.sign(theta) : 1;
    theta = Math.abs(theta % (2 * Math.PI));
    const quadrant3 = Math.floor(theta * 2 / Math.PI);
    theta = theta % (Math.PI / 2);
    let sign2;
    [sign2, operator2] = TRIG_IDENTITIES[operator2]?.[quadrant3] ?? [1, operator2];
    for (const [[n, d], value] of specialValues) {
      const r = value[operator2];
      if (r && Math.abs(theta - Math.PI * n / d) <= 1e-12) {
        if (r.symbol === "ComplexInfinity") return r;
        return identitySign * sign2 < 0 ? r.neg() : r;
      }
    }
    return void 0;
  }
  function quadrant2(theta) {
    if (!theta.isValid || !theta.isNumberLiteral) return [void 0, void 0];
    if (theta.im !== 0) return [void 0, void 0];
    const t = theta.re;
    if (isNaN(t)) return [void 0, void 0];
    const normalizedTheta = (t % (2 * Math.PI) + 2 * Math.PI) % (2 * Math.PI);
    if (Math.abs(normalizedTheta) < 1e-12) return [1, 0];
    if (Math.abs(normalizedTheta - Math.PI / 2) < 1e-12) return [2, 1];
    if (Math.abs(normalizedTheta - Math.PI) < 1e-12) return [3, 2];
    if (Math.abs(normalizedTheta - 3 * Math.PI / 2) < 1e-12) return [4, 3];
    return [Math.floor(normalizedTheta / (Math.PI / 2)) + 1, void 0];
  }

  // src/compute-engine/library/trigonometry.ts
  var TRIGONOMETRY_LIBRARY = [
    {
      //
      // Constants
      //
      Pi: {
        type: "finite_real",
        constant: true,
        holdUntil: "N",
        wikidata: "Q167",
        value: (engine) => engine.number(bignumPreferred(engine) ? engine._BIGNUM_PI : Math.PI)
      }
    },
    {
      Degrees: {
        /* = Pi / 180 */
        signature: "real -> real",
        canonical: (ops, { engine }) => {
          const ce = engine;
          if (ce.angularUnit === "deg") return ops[0];
          if (ops.length !== 1) return ce._fn("Degrees", ops);
          const arg = ops[0];
          if (arg.numericValue === null || !arg.isValid)
            return ce._fn("Degrees", ops);
          let fArg = arg.re;
          if (Number.isNaN(fArg)) return arg.mul(ce.Pi).div(180);
          fArg = fArg % 360;
          if (fArg < 0) fArg += 360;
          if (Number.isInteger(fArg)) {
            const fRadians = reducedRational([fArg, 180]);
            if (fRadians[0] === 0) return ce.Zero;
            if (fRadians[0] === 1 && fRadians[1] === 1) return ce.Pi;
            if (fRadians[0] === 1) return ce.Pi.div(fRadians[1]);
            return ce.number(fRadians).mul(ce.Pi);
          }
          return ce.number(fArg).div(180).mul(ce.Pi);
        },
        evaluate: (ops, options) => {
          if (options.engine.angularUnit === "deg") return ops[0];
          return ops[0].mul(options.engine.Pi.div(180)).evaluate(options);
        }
      },
      // Hypot: sqrt(x*x + y*y)
      Hypot: {
        threadable: true,
        signature: "(real, real) -> real",
        sgn: () => "non-negative",
        evaluate: ([x, y], { engine }) => engine.box(["Sqrt", ["Add", ["Square", x], ["Square", y]]])
      },
      // The definition of other trig functions may rely on Sin, so it is defined
      // first in this preliminary section
      Sin: trigFunction("Sin", 5e3)
    },
    {
      //
      // Basic trigonometric function
      // (may be used in the definition of other functions below)
      //
      Arctan: {
        wikidata: "Q2257242",
        complexity: 5200,
        threadable: true,
        signature: "number -> finite_real",
        sgn: ([x]) => trigSign("Arctan", x),
        evaluate: ([x], { numericApproximation }) => numericApproximation ? evalTrig("Arctan", x) : constructibleValues("Arctan", x) ?? evalTrig("Arctan", x)
      },
      Arctan2: {
        wikidata: "Q776598",
        complexity: 5200,
        threadable: true,
        signature: "(y:number, x: number) -> real",
        evaluate: ([y, x], { engine: ce, numericApproximation }) => {
          if (numericApproximation)
            return apply2(y, x, Math.atan2, (a, b) => Decimal.atan2(a, b));
          if (y.isFinite === false && x.isFinite === false) return ce.NaN;
          if (y.is(0) && x.is(0)) return ce.Zero;
          if (x.isFinite === false) return x.isPositive ? ce.Zero : ce.Pi;
          if (y.isFinite === false)
            return y.isPositive ? ce.Pi.div(2) : ce.Pi.div(-2);
          if (y.is(0)) return x.isPositive ? ce.Zero : ce.Pi;
          return ce.function("Arctan", [y.div(x)]).evaluate();
        }
      },
      Cos: trigFunction("Cos", 5050),
      Tan: trigFunction("Tan", 5100)
      /* converts (x, y) -> (radius, angle) */
      // ToPolarCoordinates: {
      //   domain: 'Functions',
      //   outputDomain: ['TupleOf', 'RealNumbers', 'RealNumbers'],
      // }
    },
    //
    // Functions defined using arithmetic functions or basic
    // trigonometric functions above
    //
    {
      //Note: we use Arccosh, not Arcosh, as the name of the function
      Arccosh: trigFunction("Arccosh", 6200),
      Arcsin: trigFunction("Arcsin", 5500),
      //Note: we use Arcsinh, not Arsinh, as the name of the function
      Arcsinh: trigFunction("Arcsinh", 6100),
      Arctanh: trigFunction("Arctanh", 6300),
      Cosh: trigFunction("Cosh", 6050),
      Cot: trigFunction("Cot", 5600),
      Csc: trigFunction("Csc", 5600, "Cosecant"),
      Sec: trigFunction("Sec", 5600, "Secant, inverse of cosine"),
      Sinh: trigFunction("Sinh", 6e3),
      /** = sin(z/2)^2 = (1 - cos z) / 2*/
      Haversine: {
        wikidata: "Q2528380",
        threadable: true,
        signature: "real -> number",
        evaluate: ([z], { engine }) => engine.box(["Divide", ["Subtract", 1, ["Cos", z]], 2])
      },
      /** = 2 * Arcsin(Sqrt(z)) */
      InverseHaversine: {
        //  Range ['Interval', [['Negate', 'Pi'], 'Pi'],
        threadable: true,
        signature: "real -> real",
        evaluate: ([x], { engine }) => engine.box(["Multiply", 2, ["Arcsin", ["Sqrt", x]]])
      }
    },
    {
      Csch: trigFunction("Csch", 6200, "Hyperbolic cosecant"),
      Sech: trigFunction("Sech", 6200, "Hyperbolic secant"),
      Tanh: trigFunction("Tanh", 6200, "Hyperbolic tangent")
    },
    {
      Arccos: trigFunction("Arccos", 5550),
      Arccot: trigFunction("Arccot", 5650),
      Arccoth: trigFunction("Arccoth", 6350),
      Arccsch: trigFunction("Arccsch", 6250),
      Arcsec: trigFunction("Arcsec", 5650),
      Arcsech: trigFunction("Arcsech", 6250),
      Arccsc: trigFunction("Arccsc", 5650),
      Coth: trigFunction("Coth", 6300),
      /* converts (radius, angle) -> (x, y) */
      // FromPolarCoordinates: {
      //   domain: 'Function',
      //   outputDomain: ['TupleOf', 'RealNumbers', 'RealNumbers'],
      // },
      InverseFunction: {
        lazy: true,
        signature: "function -> function",
        canonical: (ops, { engine }) => {
          ops = checkArity(engine, ops, 1);
          return processInverseFunction(engine, ops) ?? engine._fn("InverseFunction", ops);
        },
        evaluate: (ops, { engine: ce }) => processInverseFunction(ce, ops)
      }
    }
  ];
  function trigFunction(operator2, complexity, description) {
    return {
      complexity,
      description,
      threadable: true,
      signature: "number -> number",
      sgn: ([x]) => trigSign(operator2, x),
      evaluate: ([x], { numericApproximation }) => {
        if (numericApproximation) return evalTrig(operator2, x);
        const a = constructibleValues(operator2, x);
        return a ?? evalTrig(operator2, x);
      }
    };
  }

  // src/compute-engine/boxed-expression/boxed-symbol-definition.ts
  var _BoxedSymbolDefinition = class {
    constructor(ce, name, def) {
      // If true, the value cannot be changed
      this.constant = false;
      // If 'never', the symbol is replaced by its value during canonicalization.
      // If 'evaluate', the symbol is replaced byt its value during evaluation.
      // If 'N', the symbol is replaced during a numeric evaluation.
      this.holdUntil = "evaluate";
      if (!ce.context) throw Error("No context available");
      this.name = name;
      this._engine = ce;
      this.scope = ce.context;
      this.update(def);
    }
    get isFunction() {
      return this.type.matches("function");
    }
    get isConstant() {
      return this.constant;
    }
    /** The symbol was previously inferred, but now it has a declaration. Update the def accordingly (we can't replace defs, as other expressions may be referencing them) */
    update(def) {
      if (def.wikidata) this.wikidata = def.wikidata;
      if (def.description) this.description = def.description;
      if (def.url) this.url = def.url;
      if (def.flags) this._flags = normalizeFlags(def.flags);
      if (def.holdUntil) this.holdUntil = def.holdUntil;
      if (this.constant && def.constant === false) {
        throw new Error(
          `The constant "${this.name}" cannot be changed to a variable`
        );
      }
      if (def.constant) {
        this.constant = def.constant;
        this._defValue = def.value;
      }
      this._value = dynamicValue(this._engine, def.value);
      if (def.type) {
        const type2 = parseType(def?.type);
        if (!isValidType(type2)) throw new Error(`Invalid type: "${def.type}"`);
        this._type = new BoxedType(type2);
        this.inferredType = def.inferred ?? false;
      }
      if (this._value) {
        if (!this._type || this._type.isUnknown) {
          this._type = this._value.type;
          this.inferredType = true;
        } else {
          if (!this._value.type.matches(this._type)) {
            throw new Error(
              [
                `Symbol "${this.name}"`,
                `The value "${this._value.toString()}" of type "${this._value.type}" is not compatible with the type "${this._type}"`
              ].join("\n|   ")
            );
          }
        }
      }
      if (def.eq) this.eq = def.eq;
      if (def.neq) this.neq = def.neq;
      if (def.cmp) this.cmp = def.cmp;
      if (def.collection)
        this.collection = defaultCollectionHandlers(def.collection);
    }
    reset() {
      if (this.constant) this._value = null;
    }
    get value() {
      if (this._value === null)
        this._value = dynamicValue(this._engine, this._defValue);
      return this._value;
    }
    set value(val) {
      if (this.constant)
        throw new Error(
          `The value of the constant "${this.name}" cannot be changed`
        );
      console.assert(this._defValue === void 0);
      if (val !== void 0) {
        const newVal = this._engine.box(val);
        if (this.inferredType) {
          this._value = newVal;
          this._type = this._type ? new BoxedType(widen(this._type.type, newVal.type.type)) : newVal.type;
        } else if (!this._type || this.type.isUnknown || !newVal.type || newVal.type.matches(this._type))
          this._value = newVal;
        else this._value = void 0;
      } else this._value = void 0;
    }
    get type() {
      return this._type ?? this._value?.type ?? BoxedType.unknown;
    }
    set type(type2) {
      if (this.constant)
        throw new Error(
          `The type of the constant "${this.name}" cannot be changed`
        );
      if (!this.inferredType && !this.type.isUnknown)
        throw Error(
          `The type of "${this.name}" cannot be changed because it has already been declared`
        );
      if (type2 instanceof BoxedType) type2 = type2.type;
      if (type2 === "unknown") {
        this._defValue = void 0;
        this._value = void 0;
        this._flags = void 0;
        this._type = BoxedType.unknown;
        return;
      }
      if (this._type?.isUnknown) {
        this._type = new BoxedType(type2);
        return;
      }
      if (this._value?.type && !this._value.type.matches(type2))
        throw Error(
          `The type of "${this.name}" cannot be changed to "${type2}" because its value has a type of "${this._value.type}"`
        );
      this._type = new BoxedType(type2);
    }
    //
    // Flags
    //
    get sgn() {
      return this.value?.sgn ?? this._flags?.sgn;
    }
    set sgn(val) {
      this.updateFlags({ sgn: val });
    }
    get even() {
      return this.value?.isEven ?? this._flags?.even;
    }
    set even(val) {
      this.updateFlags({ even: val });
    }
    get odd() {
      return this.value?.isOdd ?? this._flags?.odd;
    }
    set odd(val) {
      this.updateFlags({ odd: val });
    }
    updateFlags(flags) {
      if (this.constant)
        throw Error(
          `The flags of "${this.name}" cannot be changed because it is a constant`
        );
      this._flags = normalizeFlags({ ...this._flags ?? {}, ...flags });
    }
  };
  function dynamicValue(ce, value) {
    if (value === void 0) return void 0;
    if (isLatexString(value)) return ce.parse(value) ?? ce.symbol("Undefined");
    if (typeof value === "function") return ce.box(value(ce) ?? "Undefined");
    if (value instanceof _BoxedExpression) return value;
    return ce.box(value);
  }

  // src/compute-engine/boxed-expression/boxed-function-definition.ts
  var FUNCTION_DEF_KEYS = /* @__PURE__ */ new Set([
    // Base
    "description",
    "wikidata",
    "url",
    // Function Flags
    "lazy",
    "threadable",
    "associative",
    "commutative",
    "commutativeOrder",
    "idempotent",
    "involution",
    "pure",
    "signature",
    "type",
    "sgn",
    "even",
    "complexity",
    "canonical",
    "evaluate",
    "evaluateAsync",
    "evalDimension",
    "compile",
    "eq",
    "neq",
    "cmp",
    // Collection Handlers
    "collection"
  ]);
  var _BoxedFunctionDefinition = class {
    constructor(ce, name, def) {
      this.threadable = false;
      this.associative = false;
      this.commutative = false;
      this.idempotent = false;
      this.involution = false;
      this.pure = true;
      this.complexity = DEFAULT_COMPLEXITY;
      this.lazy = false;
      this.inferredSignature = true;
      if (!ce.context) throw Error("No context available");
      this.name = name;
      this.engine = ce;
      this.scope = ce.context;
      if (def.signature) {
        this.inferredSignature = false;
        this.signature = new BoxedType(def.signature);
      } else this.signature = new BoxedType("...any -> any");
      this.update(def);
    }
    infer(sig) {
      const newSig = new BoxedType(sig);
      if (!newSig.matches(this.signature))
        throw new Error(
          `Function Definition "${this.name}": inferred signature "${newSig}" does not match current signature "${this.signature}"`
        );
      if (this.inferredSignature) this.signature = newSig;
    }
    update(def) {
      if (this.engine.strict) {
        for (const key in def) {
          if (!FUNCTION_DEF_KEYS.has(key))
            throw new Error(
              `Function Definition "${this.name}": unexpected key "${key}"`
            );
        }
      }
      this.lazy = def.lazy ?? this.lazy;
      const idempotent = def.idempotent ?? this.idempotent;
      const involution = def.involution ?? this.involution;
      if (idempotent && involution)
        throw new Error(
          `Function Definition "${this.name}": the 'idempotent' and 'involution' flags are mutually exclusive`
        );
      this.idempotent = idempotent;
      this.involution = involution;
      this.description = def.description ?? this.description;
      this.wikidata = def.wikidata ?? this.wikidata;
      this.threadable = def.threadable ?? this.threadable;
      this.associative = def.associative ?? this.associative;
      this.commutative = def.commutative ?? this.commutative;
      this.commutativeOrder = def.commutativeOrder ?? this.commutativeOrder;
      if (this.commutativeOrder && !this.commutative)
        throw new Error(
          `Function Definition "${this.name}": the 'commutativeOrder' handler requires the 'commutative' flag`
        );
      if (def.canonical && (def.associative || def.commutative || def.idempotent || def.involution))
        throw new Error(
          `Function Definition "${this.name}": the 'canonical' handler is incompatible with the 'associative', 'commutative', 'idempotent', and 'involution' flags`
        );
      this.pure = def.pure ?? this.pure;
      this.complexity = def.complexity ?? this.complexity;
      if (def.signature) {
        const oldSig = def.signature;
        const newSig = new BoxedType(parseType(def.signature));
        if (oldSig && !newSig.matches(oldSig))
          throw new Error(
            `Function Definition "${this.name}": signature "${newSig}" does not match "${oldSig}"`
          );
        this.inferredSignature = false;
        this.signature = newSig;
      }
      let evaluate = void 0;
      if (def.evaluate && typeof def.evaluate !== "function") {
        const boxedFn = this.engine.box(def.evaluate, { canonical: false });
        if (!boxedFn.isValid)
          throw Error(`Invalid function ${boxedFn.toString()}`);
        const fn = applicable(boxedFn);
        evaluate = (xs) => fn(xs);
        Object.defineProperty(evaluate, "toString", {
          value: () => boxedFn.toString()
        });
      } else evaluate = def.evaluate ?? this.evaluate;
      this.type = def.type ?? this.type;
      this.evaluate = evaluate;
      this.evaluateAsync = def.evaluateAsync ?? this.evaluateAsync;
      this.canonical = def.canonical ?? this.canonical;
      this.evalDimension = def.evalDimension ?? this.evalDimension;
      this.sgn = def.sgn ?? this.sgn;
      this.even = def.even ?? this.even;
      this.compile = def.compile ?? this.compile;
      this.eq = def.eq ?? this.eq;
      this.neq = def.neq ?? this.neq;
      this.collection = def.collection ?? this.collection;
    }
    reset() {
      return;
    }
  };
  function makeFunctionDefinition(engine, name, def) {
    if (def instanceof _BoxedFunctionDefinition) return def;
    return new _BoxedFunctionDefinition(engine, name, def);
  }

  // src/compute-engine/library/library.ts
  function getStandardLibrary(categories) {
    if (categories === "all") {
      return getStandardLibrary([
        "core",
        "control-structures",
        // If, Block, Loop
        "logic",
        "collections",
        // Dictionary, List, Sets
        "relop",
        "numeric",
        "arithmetic",
        "trigonometry",
        "algebra",
        "calculus",
        // D, Integerate
        "polynomials",
        "combinatorics",
        "linear-algebra",
        "statistics",
        "dimensions",
        "units",
        "physics",
        "other"
      ]);
    } else if (typeof categories === "string") categories = [categories];
    const result = [];
    for (const category of categories) {
      const dict = LIBRARIES[category];
      if (!dict) throw Error(`Unknown library category ${category}`);
      if (Array.isArray(dict)) result.push(...dict);
      else result.push(dict);
    }
    return Object.freeze(result);
  }
  var LIBRARIES = {
    "algebra": [],
    // 'algebra': [
    //   // polynomial([0, 2, 0, 4]:list, x:symbol) -> 2x + 4x^3
    //   // polynomial(2x + 4x^3, x) -> {0, 2, 0, 4}
    //   // rational(2x + 4x^3, {3, 1}, x) -> (2x + 4x^3)/(3+x)
    //   // https://reference.wolfram.com/language/tutorial/AlgebraicCalculations.html
    //   // simplify-trig (macsyma)
    //   //  - trigReduce, trigExpand, trigFactor, trigToExp (mathematica)
    //   // Mathematica:
    //   // - distribute -> (a+b)(c+d) -> ac+ ad+ bc+ bd (doesn't have to be multiply,
    //   // f(a+b, c+d) -> f(a, c) + f(a, d) + f(b, c) + f(b, d)
    //   // -- distribute(expr, over=add, with=multiply)
    //   // https://reference.wolfram.com/language/ref/Distribute.html
    //   // - expand, expand-all
    //   // - factor
    //   // - simplify
    // ],
    "arithmetic": [...ARITHMETIC_LIBRARY, ...COMPLEX_LIBRARY],
    "calculus": CALCULUS_LIBRARY,
    "collections": [SETS_LIBRARY, COLLECTIONS_LIBRARY],
    "combinatorics": [],
    // @todo fibonacci, binomial, etc...
    "control-structures": CONTROL_STRUCTURES_LIBRARY,
    "core": CORE_LIBRARY,
    "dimensions": [],
    // @todo // volume, speed, area
    "domains": [],
    // 'domains': getDomainsDictionary(),
    "linear-algebra": LINEAR_ALGEBRA_LIBRARY,
    "logic": LOGIC_LIBRARY,
    "numeric": [],
    // @todo   // 'numeric': [
    "other": [],
    "relop": RELOP_LIBRARY,
    "polynomials": POLYNOMIALS_LIBRARY,
    "physics": {
      Mu0: {
        description: "Vaccum permeability",
        constant: true,
        wikidata: "Q1515261",
        type: "real",
        value: 125663706212e-17
        // unit: ['Divide', 'N', ['Square', 'A']],
      }
    },
    "statistics": STATISTICS_LIBRARY,
    "trigonometry": TRIGONOMETRY_LIBRARY,
    "units": []
    // @todo see also "dimensions"
  };
  function validateDefinitionName(name) {
    name = name.normalize();
    if (isValidIdentifier(name)) return name;
    throw new Error(
      `Invalid definition name "${name}": ${validateIdentifier(name)}`
    );
  }
  function setIdentifierDefinitions(engine, table) {
    var _a;
    if (!engine.context) throw Error("No context available");
    (_a = engine.context).ids ?? (_a.ids = /* @__PURE__ */ new Map());
    const idTable = engine.context.ids;
    if (!engine.strict) {
    }
    for (let [name, entry] of Object.entries(table)) {
      try {
        name = validateDefinitionName(name);
        if (isFunctionDefinition(entry)) {
          try {
            const def = makeFunctionDefinition(engine, name, entry);
            if (idTable.has(name))
              throw new Error(
                `Duplicate function definition:
${JSON.stringify(
                  idTable.get(name)
                )}
${JSON.stringify(entry)}`
              );
            idTable.set(name, def);
          } catch (e) {
            console.error(
              [
                `
Error in function definition`,
                "",
                JSON.stringify(entry),
                "",
                e.message
              ].join("\n|   ") + "\n"
            );
          }
        } else if (isSymbolDefinition(entry)) {
          try {
            const def = new _BoxedSymbolDefinition(engine, name, entry);
            if (engine.strict && entry.wikidata) {
              for (const [_, d] of idTable) {
                if (d.wikidata === entry.wikidata)
                  throw new Error(
                    `Duplicate entries with wikidata "${entry.wikidata}": "${name}" and "${d.name}"`
                  );
              }
            }
            if (idTable.has(name))
              throw new Error(`The symbol is already defined`);
            idTable.set(name, def);
          } catch (e) {
            console.error(
              [
                `
Error in symbol definition of "${name}"`,
                "",
                JSON.stringify(entry),
                "",
                e.message
              ].join("\n|   ")
            );
          }
        } else {
          const def = new _BoxedSymbolDefinition(engine, name, {
            value: engine.box(entry)
          });
          console.assert(def);
          idTable.set(name, def);
        }
      } catch (e) {
        console.error(
          [
            `
Error in definition of "${name}"`,
            "",
            JSON.stringify(entry),
            "",
            e.message
          ].join("\n|   ") + "\n"
        );
      }
    }
  }

  // src/compute-engine/cost-function.ts
  function numericCostFunction(n) {
    if (typeof n === "number") {
      if (n === 0) return 1;
      if (Number.isInteger(n))
        return Math.floor(Math.log2(Math.abs(n)) / Math.log2(10)) + (n > 0 ? 1 : 2);
      return 2;
    }
    if (n.isZero) return 1;
    if (n.im !== 0)
      return numericCostFunction(n.re) + numericCostFunction(n.im) + 1;
    return numericCostFunction(n.re);
  }
  function costFunction(expr) {
    if (expr.symbol) return 1;
    if (expr.isNumberLiteral) return numericCostFunction(expr.numericValue);
    const name = expr.operator;
    let nameCost = 2;
    if (["Add"].includes(name)) nameCost = 3;
    else if (["Subtract", "Negate"].includes(name)) nameCost = 4;
    else if (["Square", "Sqrt"].includes(name)) nameCost = 5;
    else if (["Power", "Root"].includes(name))
      return costFunction(expr.ops[1]);
    else if (["Multiply"].includes(name)) nameCost = 7;
    else if (["Divide"].includes(name)) nameCost = 8;
    else if (["Ln", "Exp", "Log", "Lb"].includes(name)) nameCost = 9;
    else if (["Cos", "Sin", "Tan"].includes(name)) nameCost = 10;
    else nameCost = 11;
    return nameCost + (expr.ops?.reduce((acc, x) => acc + costFunction(x), 0) ?? 0);
  }
  var DEFAULT_COST_FUNCTION = costFunction;

  // src/compute-engine/boxed-expression/expression-map.ts
  var ExpressionMap = class _ExpressionMap {
    constructor(source) {
      if (!source) {
        this._items = /* @__PURE__ */ new Map();
      } else if (source instanceof _ExpressionMap) {
        this._items = new Map(source._items);
      } else {
        this._items = new Map(
          source
        );
      }
    }
    has(expr) {
      for (const x of this._items.keys()) if (x.isSame(expr)) return true;
      return false;
    }
    get(expr) {
      for (const [x, v] of this._items) if (x.isSame(expr)) return v;
      return void 0;
    }
    clear() {
      this._items.clear();
    }
    set(expr, value) {
      for (const x of this._items.keys()) {
        if (x.isSame(expr)) {
          this._items.set(x, value);
          return;
        }
      }
      this._items.set(expr, value);
    }
    delete(expr) {
      this._items.delete(expr);
    }
    [Symbol.iterator]() {
      return this._items.entries();
    }
    entries() {
      return this._items.entries();
    }
  };

  // src/compute-engine/boxed-expression/boxed-number.ts
  var BoxedNumber = class extends _BoxedExpression {
    /**
     * By the time the constructor is called, the `value` should have been
     * screened for cases where it's a well-known value (0, NaN, +Infinity,
     * etc...) or non-normal (complex number with im = 0, rational with
     * denom = 1, etc...).
     *
     * This is done in `ce.number()`. In general, use `ce.number()` rather
     * than calling this constructor directly.
     *
     * We may store as a machine number if a Decimal is passed that is in machine
     * range
     */
    constructor(ce, value, options) {
      super(ce, options?.metadata);
      if (value instanceof NumericValue || typeof value === "number")
        this._value = value;
      else this._value = ce._numericValue(value);
    }
    get hash() {
      this._hash ?? (this._hash = hashCode(this._value.toString()));
      console.info("hash BoxedNumber ", this._hash);
      return this._hash;
    }
    get json() {
      const value = this._value;
      if (typeof value === "number") {
        if (Number.isNaN(value)) return "NaN";
        if (!Number.isFinite(value))
          return value > 0 ? "PositiveInfinity" : "NegativeInfinity";
        return value;
      }
      return value.toJSON();
    }
    get operator() {
      return "Number";
    }
    get isPure() {
      return true;
    }
    get isCanonical() {
      return true;
    }
    set isCanonical(val) {
    }
    get complexity() {
      return 1;
    }
    get numericValue() {
      return this._value;
    }
    get isNumberLiteral() {
      return true;
    }
    get re() {
      if (typeof this._value === "number") return this._value;
      return this._value.re;
    }
    get im() {
      if (typeof this._value === "number") return 0;
      return this._value.im;
    }
    get bignumRe() {
      if (typeof this._value === "number") return void 0;
      return this._value.bignumRe;
    }
    get bignumIm() {
      return void 0;
    }
    neg() {
      const n = this._value;
      if (n === 0) return this;
      if (typeof n === "number") return this.engine.number(-n);
      return this.engine.number(n.neg());
    }
    inv() {
      if (this.value === 1 || this.value === -1) return this;
      if (typeof this._value === "number") {
        if (!Number.isInteger(this._value))
          return this.engine.number(1 / this._value);
        return this.engine.number(
          this.engine._numericValue({ rational: [1, this._value] })
        );
      }
      return this.engine.number(this._value.inv());
    }
    abs() {
      if (this.isPositive) return this;
      if (typeof this._value === "number")
        return this.engine.number(-this._value);
      return this.engine.number(this._value.abs());
    }
    add(rhs) {
      const ce = this.engine;
      if (this.is(0)) return ce.box(rhs);
      if (typeof rhs === "number") {
        if (rhs === 0) return this;
        if (typeof this._value === "number") return ce.number(this._value + rhs);
        return ce.number(this._value.add(rhs));
      }
      if (rhs.numericValue !== null) {
        if (typeof this._value === "number") {
          if (typeof rhs.numericValue === "number")
            return ce.number(this._value + rhs.numericValue);
          return ce.number(rhs.numericValue.add(this._value));
        }
        return ce.number(this._value.add(rhs.numericValue));
      }
      return add3(this.canonical, rhs.canonical);
    }
    mul(rhs) {
      if (this.is(1)) return this.engine.box(rhs);
      if (this.is(-1)) return this.engine.box(rhs).neg();
      const ce = this.engine;
      if (typeof rhs === "number") {
        if (rhs === 1) return this;
        if (rhs === 0 || this.is(0)) return this.engine.Zero;
        if (rhs === -1) return this.neg();
        return ce.number(
          typeof this._value === "number" ? this._value * rhs : this._value.mul(rhs)
        );
      }
      if (typeof this._value === "number" && typeof rhs === "number")
        return ce.number(this._value * rhs);
      if (rhs instanceof NumericValue) {
        if (this.is(1)) return ce.number(rhs);
        if (this.is(-1)) return ce.number(rhs.neg());
        return ce.number(rhs.mul(this._value));
      }
      if (rhs.numericValue !== null)
        return ce.number(ce._numericValue(this._value).mul(rhs.numericValue));
      return mul3(this, rhs);
    }
    div(rhs) {
      return div2(this, rhs);
    }
    pow(exp2) {
      return pow2(this, exp2, { numericApproximation: false });
    }
    root(exp2) {
      if (!this.isCanonical) return this.canonical.root(exp2);
      if (typeof exp2 === "number") {
        if (exp2 === 0) return this.engine.NaN;
        if (exp2 === 1) return this;
        if (exp2 === -1) return this.inv();
        if (exp2 === 2) return this.sqrt();
        if (this.isNegative) {
          if (exp2 % 2 === 1) return this.neg().root(exp2).neg();
          if (exp2 % 2 === 0) return this.neg().root(exp2);
        }
      } else {
        exp2 = exp2.canonical;
        if (exp2.is(0)) return this.engine.NaN;
        if (exp2.is(1)) return this;
        if (exp2.is(-1)) return this.inv();
        if (exp2.is(2)) return this.sqrt();
        if (this.isNegative) {
          if (exp2.isOdd) return this.neg().root(exp2).neg();
          if (exp2.isEven) return this.neg().root(exp2);
        }
      }
      const n = typeof exp2 === "number" ? exp2 : exp2.re;
      if (Number.isInteger(n)) {
        if (typeof this._value === "number") {
          const r = this._value ** (1 / n);
          if (Number.isInteger(r)) return this.engine.number(r);
        } else {
          const r = this._value.root(n);
          if (isSubtype(r.type, "integer")) return this.engine.number(r);
        }
      }
      return this.engine._fn("Root", [this, this.engine.box(exp2)]);
    }
    sqrt() {
      if (typeof this._value === "number") {
        if (this._value === 0 || this._value === 1) return this;
        if (this._value === -1) return this.engine.I;
        if (this._value > 0 && Number.isInteger(this._value) && this._value < SMALL_INTEGER)
          return this.engine.number(
            this.engine._numericValue({ radical: this._value })
          );
        return this.engine.number(this.engine._numericValue(this._value).sqrt());
      }
      if (this.is(0) || this.is(1)) return this;
      return this.engine.number(this._value.sqrt());
    }
    ln(semiBase) {
      const base = semiBase ? this.engine.box(semiBase) : void 0;
      if (!this.isCanonical) return this.canonical.ln(base);
      if (this.is(0)) return this.engine.NegativeInfinity;
      if (base && this.isSame(base)) return this.engine.One;
      if ((!base || base.symbol === "ExponentialE") && this.symbol === "ExponentialE")
        return this.engine.One;
      const f = this.re;
      if (Number.isInteger(f) && f > 0) {
        const ce = this.engine;
        let [factor2, root2] = canonicalInteger(f, 3);
        if (factor2 !== 1)
          return ce.number(factor2).ln(base).mul(3).add(ce.number(root2).ln(base));
        [factor2, root2] = canonicalInteger(f, 2);
        if (factor2 !== 1)
          return ce.number(factor2).ln(base).mul(2).add(ce.number(root2).ln(base));
      }
      if (base && base.isInteger) {
        if (typeof this._value === "number")
          return this.engine.number(Math.log(this._value) / Math.log(base.re));
        return this.engine.number(this._value.ln(base.re));
      }
      if (base === void 0) {
        if (typeof this._value === "number")
          return this.engine.number(Math.log(this._value));
        return this.engine.number(this._value.ln());
      }
      return this.engine._fn("Ln", [this]);
    }
    get type() {
      if (typeof this._value === "number") {
        if (Number.isNaN(this._value)) return new BoxedType("number");
        if (!Number.isFinite(this._value))
          return new BoxedType("non_finite_number");
        return new BoxedType(
          Number.isInteger(this._value) ? "finite_integer" : "finite_real"
        );
      }
      return new BoxedType(this._value.type);
    }
    get sgn() {
      if (this._value === 0) return "zero";
      let s;
      if (typeof this._value === "number") {
        if (Number.isNaN(this._value)) return "unsigned";
        s = Math.sign(this._value);
      } else s = this._value.sgn();
      if (s === void 0) return "unsigned";
      if (Number.isNaN(s)) return "unsigned";
      if (s === 0) return "zero";
      if (s > 0) return "positive";
      return "negative";
    }
    get numerator() {
      if (typeof this._value === "number") return this;
      return this.engine.number(this._value.numerator);
    }
    get denominator() {
      if (typeof this._value === "number") return this.engine.One;
      return this.engine.number(this._value.denominator);
    }
    get numeratorDenominator() {
      if (typeof this._value === "number") return [this, this.engine.One];
      const ce = this.engine;
      return [
        ce.number(this._value.numerator),
        ce.number(this._value.denominator)
      ];
    }
    subs(sub2, options) {
      if (this.isStructural) return this;
      return this.structural.subs(sub2, options);
    }
    replace(rules, options) {
      return replace(this.structural, rules, options).at(-1)?.value ?? null;
    }
    match(pattern, options) {
      return match(this.structural, pattern, options);
    }
    /** x > 0, same as `isGreater(0)` */
    get isPositive() {
      if (typeof this._value === "number")
        return !Number.isNaN(this._value) && this._value > 0;
      return positiveSign(this.sgn);
    }
    /** x >= 0, same as `isGreaterEqual(0)` */
    get isNonNegative() {
      if (typeof this._value === "number")
        return !Number.isNaN(this._value) && this._value >= 0;
      return nonNegativeSign(this.sgn);
    }
    /** x < 0, same as `isLess(0)` */
    get isNegative() {
      if (typeof this._value === "number")
        return !Number.isNaN(this._value) && this._value < 0;
      return negativeSign(this.sgn);
    }
    /** x <= 0, same as `isLessEqual(0)` */
    get isNonPositive() {
      if (typeof this._value === "number")
        return !Number.isNaN(this._value) && this._value <= 0;
      return nonPositiveSign(this.sgn);
    }
    get isOdd() {
      if (this.is(1) || this.is(-1)) return true;
      if (this.is(0)) return false;
      if (!this.isFinite || !this.isInteger) return void 0;
      if (typeof this._value === "number") return this._value % 2 !== 0;
      const [n, d] = [this._value.numerator, this._value.denominator];
      if (d.isOne) {
        const re = n.re;
        return re % 2 !== 0;
      }
      return n.re % 2 !== 0 && d.re % 2 === 0;
    }
    get isEven() {
      const odd = this.isOdd;
      return odd !== void 0 ? !odd : void 0;
    }
    get isInfinity() {
      if (typeof this._value === "number")
        return !Number.isFinite(this._value) && !Number.isNaN(this._value);
      if (!Number.isFinite(this._value.im)) return true;
      return this._value.isPositiveInfinity || this._value.isNegativeInfinity;
    }
    get isNaN() {
      if (typeof this._value === "number") return Number.isNaN(this._value);
      return this._value.isNaN;
    }
    get isFinite() {
      return this.isInfinity === false && this.isNaN === false;
    }
    get isNumber() {
      return true;
    }
    get isInteger() {
      if (typeof this._value === "number") return Number.isInteger(this._value);
      return isSubtype(this._value.type, "integer");
    }
    get isRational() {
      if (typeof this._value === "number") return Number.isInteger(this._value);
      return isSubtype(this._value.type, "rational");
    }
    get isReal() {
      if (typeof this._value === "number") return true;
      return isSubtype(this._value.type, "real");
    }
    is(rhs) {
      if (typeof rhs === "number") {
        if (typeof this._value === "number") return this._value === rhs;
        return this._value.eq(rhs);
      }
      return false;
    }
    get canonical() {
      return this;
    }
    get isStructural() {
      if (typeof this._value === "number") return true;
      if (this.type.matches("rational")) return true;
      if (this._value instanceof ExactNumericValue) return false;
      return true;
    }
    get structural() {
      if (this.isStructural) return this;
      return this.engine.box(this.json, { canonical: false, structural: true });
    }
    toNumericValue() {
      const v = this._value;
      if (typeof v === "number")
        return [this.engine._numericValue(v), this.engine.One];
      return [v, this.engine.One];
    }
    simplify(options) {
      const results = simplify(this.canonical.structural, options);
      return results.at(-1).value ?? this;
    }
    evaluate(options) {
      if (options?.numericApproximation) return this.N();
      return this;
    }
    N() {
      const v = this._value;
      if (typeof v === "number") return this;
      const n = v.N();
      if (v === n) return this;
      return this.engine.number(n);
    }
  };
  function canonicalNumber(ce, value) {
    if (value === void 0 || value === null) return NaN;
    if (value instanceof NumericValue) return value;
    if (typeof value === "number") {
      if (Number.isInteger(value) && value >= -SMALL_INTEGER && value <= SMALL_INTEGER)
        return value;
      if (!Number.isFinite(value)) return value;
      return ce._numericValue(value);
    }
    if (value instanceof Decimal) {
      const n = value.toNumber();
      if (value.isInteger() && Math.abs(n) <= SMALL_INTEGER) return n;
      if (value.isNaN()) return NaN;
      if (!value.isFinite()) return n > 0 ? Infinity : -Infinity;
      return ce._numericValue(value);
    }
    if (typeof value === "bigint") {
      if (value >= -SMALL_INTEGER && value <= SMALL_INTEGER) return Number(value);
      return ce._numericValue(value);
    }
    if (value instanceof Complex) {
      if (value.im === 0) return canonicalNumber(ce, value.re);
      if (value.isNaN()) return NaN;
      if (!value.isFinite() && value.im === 0)
        return value.re > 0 ? Infinity : -Infinity;
      return ce._numericValue({ re: value.re, im: value.im });
    }
    if (typeof value === "object" && "num" in value) {
      if (typeof value.num === "number") return canonicalNumber(ce, value.num);
      if (typeof value.num !== "string")
        throw new Error("MathJSON `num` property should be a string of digits");
      return canonicalNumberString(ce, value.num);
    }
    if (typeof value === "string") return canonicalNumberString(ce, value);
    if (value[1] == 0) return NaN;
    if (typeof value[1] === "number" && !Number.isFinite(value[1])) {
      if (!Number.isFinite(value[0])) return NaN;
      return 0;
    }
    if (typeof value[0] === "number" && !Number.isFinite(value[0])) {
      const sign2 = value[0] > 0 ? 1 : -1;
      if (value[0] > 0) return sign2 > 0 ? Infinity : -Infinity;
      if (value[0] < 0) return sign2 > 0 ? -Infinity : Infinity;
      return NaN;
    }
    return ce._numericValue(value);
  }
  function canonicalNumberString(ce, s) {
    s = s.toLowerCase();
    if (/[0-9][nd]$/.test(s)) s = s.slice(0, -1);
    s = s.replace(/[\u0009-\u000d\u0020\u00a0]/g, "");
    if (s === "nan") return NaN;
    if (s === "infinity" || s === "+infinity") return Number.POSITIVE_INFINITY;
    if (s === "-infinity") return Number.NEGATIVE_INFINITY;
    if (s === "0") return 0;
    if (s === "1") return 1;
    if (s === "-1") return -1;
    if (/\([0-9]+\)/.test(s)) {
      const [_, body, repeat2, trail] = s.match(/(.+)\(([0-9]+)\)(.+)?$/) ?? [];
      s = body + repeat2.repeat(Math.ceil(ce.precision / repeat2.length)) + (trail ?? "");
    }
    const n = bigint(s);
    if (n !== null) {
      if (n >= -SMALL_INTEGER && n <= SMALL_INTEGER) return Number(n);
      return ce._numericValue(n);
    }
    return ce._numericValue(ce.bignum(s));
  }

  // src/compute-engine/boxed-expression/boxed-symbol.ts
  var BoxedSymbol = class _BoxedSymbol extends _BoxedExpression {
    constructor(ce, name, options) {
      super(ce, options?.metadata);
      this._isStructural = false;
      console.assert(
        isValidIdentifier(name),
        `Invalid symbol "${name}": ${validateIdentifier(name)}`
      );
      this._id = name;
      this._def = options?.def ?? void 0;
      if (options?.structural) this._isStructural = true;
      if ((options?.canonical ?? true) !== true) this._scope = null;
      else if (this._def) this._scope = ce.context;
      else this.bind();
    }
    get json() {
      return this._id;
    }
    get hash() {
      if (this._hash === void 0) this._hash = hashCode(this._id);
      return this._hash;
    }
    get isPure() {
      return true;
    }
    get isStructural() {
      return this._isStructural;
    }
    get structural() {
      if (this.isStructural) return this;
      return new _BoxedSymbol(this.engine, this._id, {
        structural: true,
        def: this._def ?? void 0
      });
    }
    get scope() {
      return this._scope;
    }
    get isConstant() {
      const def = this._def ?? this.engine.lookupSymbol(this._id, this.wikidata);
      return !(def instanceof _BoxedSymbolDefinition) || def.constant;
    }
    _lookupDef() {
      const ce = this.engine;
      return ce.lookupSymbol(this._id) ?? ce.lookupFunction(this._id);
    }
    /** This method returns the definition associated with the value of this symbol, or associated with the symbol if it has no value. This is the definition to use with most operations on the symbol. Indeed, "x[2]" is accessing the second element of **the value** of "x".*/
    _getDef() {
      let def = this.symbolDefinition;
      if (!def) return void 0;
      const val = "value" in def ? def.value : void 0;
      if (val && val !== this) def = val.baseDefinition ?? def;
      return def;
    }
    /**
     * Associate a definition with this symbol
     */
    bind() {
      this._scope = this.engine.context;
      const def = this._lookupDef();
      if (def) {
        this._def = def;
        return;
      }
      this._def = this.engine.defineSymbol(this._id, {
        type: "unknown",
        inferred: true
      });
      this._id = this._def?.name ?? this._id;
    }
    reset() {
      this._def?.reset();
    }
    get isCanonical() {
      return this._scope !== null;
    }
    set isCanonical(val) {
      this._scope = val ? this.engine.context : null;
      this._def = void 0;
    }
    is(rhs) {
      if (typeof rhs === "number")
        return this.symbolDefinition?.value?.is(rhs) ?? false;
      return false;
    }
    get canonical() {
      if (this._scope) return this;
      return this.engine.box(this._id);
    }
    toNumericValue() {
      console.assert(this.isCanonical);
      const ce = this.engine;
      if (this.symbol === "ImaginaryUnit")
        return [ce._numericValue({ re: 0, im: 1 }), ce.One];
      if (this.symbol === "PositiveInfinity" || this.isInfinity && this.isPositive)
        return [ce._numericValue(Infinity), ce.One];
      if (this.symbol === "NegativeInfinity" || this.isInfinity && this.isNegative)
        return [ce._numericValue(-Infinity), ce.One];
      if (this.symbol === "NaN") return [ce._numericValue(NaN), ce.One];
      return [ce._numericValue(1), this];
    }
    neg() {
      return negate(this);
    }
    inv() {
      return this.engine._fn("Divide", [this.engine.One, this]);
    }
    abs() {
      if (this.isNonNegative) return this;
      if (this.isNonPositive) return this.neg();
      return this.engine._fn("Abs", [this]);
    }
    add(rhs) {
      if (rhs === 0) return this;
      return add3(this.canonical, this.engine.box(rhs));
    }
    mul(rhs) {
      if (rhs === 1) return this;
      if (rhs === -1) return this.neg();
      if (rhs === 0) return this.engine.Zero;
      if (rhs instanceof NumericValue) {
        if (rhs.isOne) return this;
        if (rhs.isNegativeOne) return this.neg();
        if (rhs.isZero) return this.engine.Zero;
      }
      return mul3(this.canonical, this.engine.box(rhs));
    }
    div(rhs) {
      return div2(this, rhs);
    }
    pow(exp2) {
      return pow2(this, exp2, { numericApproximation: false });
    }
    root(n) {
      if (!this.isCanonical) return this.canonical.root(n);
      if (typeof n !== "number") n = n.canonical;
      const e = typeof n === "number" ? n : n.im === 0 ? n.re : void 0;
      const ce = this.engine;
      if (this.symbol === "ComplexInfinity") return ce.NaN;
      if (e === 0) return ce.NaN;
      if (e === 1) return this;
      if (e === 2) return this.sqrt();
      if (e === -1) return this.inv();
      return ce._fn("Root", [this, ce.box(n)]);
    }
    sqrt() {
      const ce = this.engine;
      if (this.symbol === "ComplexInfinity") return ce.NaN;
      if (this.is(0)) return this;
      if (this.is(1)) return this.engine.One;
      if (this.is(-1)) return ce.I;
      return ce._fn("Sqrt", [this]);
    }
    ln(semiBase) {
      const base = semiBase ? this.engine.box(semiBase) : void 0;
      if (!this.isCanonical) return this.canonical.ln(base);
      if (this.is(0)) return this.engine.NegativeInfinity;
      if ((!base || base.symbol === "ExponentialE") && this.symbol === "ExponentialE")
        return this.engine.One;
      if (base) {
        if (base.re === 10) return this.engine._fn("Log", [this]);
        return this.engine._fn("Log", [this, base]);
      }
      return this.engine._fn("Ln", [this]);
    }
    solve(vars) {
      const varNames = normalizedUnknownsForSolve(vars);
      if (varNames.length !== 1) return null;
      if (varNames.includes(this.symbol)) return [this.engine.Zero];
      return null;
    }
    get complexity() {
      return 7;
    }
    get operator() {
      return "Symbol";
    }
    get symbol() {
      return this._id;
    }
    //  A base definition is the base class of both symbol and function definition
    get baseDefinition() {
      if (this._def === void 0) this.bind();
      return this._def ?? void 0;
    }
    get symbolDefinition() {
      if (this._def === void 0) this.bind();
      return this._def instanceof _BoxedSymbolDefinition ? this._def : void 0;
    }
    get functionDefinition() {
      if (this._def === void 0) this.bind();
      return this._def instanceof _BoxedFunctionDefinition ? this._def : void 0;
    }
    /**
     * Subsequent inferences will narrow the domain of the symbol.
     * f: integer -> real, g: real -> real
     * g(x) => x: real
     * f(x) => x: integer narrowed from integer to real
     */
    infer(t) {
      const def = this._lookupDef();
      if (!def) {
        const scope = this.engine.swapScope(this._scope ?? this.engine.context);
        this._def = this.engine.defineSymbol(this._id, {
          type: t,
          inferred: true
        });
        this.engine.swapScope(scope);
        return true;
      }
      if (def instanceof _BoxedSymbolDefinition && (def.inferredType || def.type.isUnknown)) {
        def.type = widen(def.type.type, t);
        return true;
      }
      return false;
    }
    get value() {
      return this.symbolDefinition?.value?.value;
    }
    set value(value) {
      const ce = this.engine;
      ce.forget(this._id);
      let v;
      if (typeof value === "boolean") value = value ? ce.True : ce.False;
      if (typeof value === "string") value = ce.string(value);
      if (typeof value === "object") {
        if ("re" in value && "im" in value)
          value = ce.complex(value.re ?? 0, value.im);
        else if ("num" in value && "denom" in value)
          value = ce.number([value.num, value.denom]);
        else if (Array.isArray(value))
          value = ce._fn(
            "List",
            value.map((x) => ce.box(x))
          );
        else throw new Error(`Invalid value for symbol ${this._id}: ${value}`);
      }
      if (value !== void 0) {
        const boxedValue = ce.box(value);
        v = boxedValue.evaluate();
      }
      if (v?.type.matches("function")) {
        console.assert(!this.engine.lookupSymbol(this._id));
        this._def = ce.defineFunction(this._id, {
          signature: v.type.toString(),
          evaluate: v
          // Evaluate as a lambda
        });
        return;
      }
      const def = this.engine.lookupSymbol(this._id);
      if (def && def instanceof _BoxedSymbolDefinition) {
        def.value = v;
      } else {
        this._def = ce.defineSymbol(this._id, {
          value: v,
          type: v?.type.toString()
        });
      }
    }
    // The type of the value of the symbol.
    // If the symbol is not bound to a definition, the type is 'any'
    get type() {
      const def = this._def;
      if (!def) return BoxedType.unknown;
      if (def instanceof _BoxedSymbolDefinition) return def.type;
      if (def instanceof _BoxedFunctionDefinition) return def.signature;
      return BoxedType.unknown;
    }
    set type(t) {
      if (!this._def) return;
      if (t instanceof BoxedType) t = t.type;
      if (this._id[0] === "_")
        throw new Error(
      