import { katex } from "./katex-CMHIKqKD.js";

//#region node_modules/katex/dist/contrib/auto-render.mjs
var findEndOfMath = function findEndOfMath$1(delimiter, text, startIndex) {
	var index = startIndex;
	var braceLevel = 0;
	var delimLength = delimiter.length;
	while (index < text.length) {
		var character = text[index];
		if (braceLevel <= 0 && text.slice(index, index + delimLength) === delimiter) return index;
		else if (character === "\\") index++;
		else if (character === "{") braceLevel++;
		else if (character === "}") braceLevel--;
		index++;
	}
	return -1;
};
var escapeRegex = function escapeRegex$1(string) {
	return string.replace(/[-/\\^$*+?.()|[\]{}]/g, "\\$&");
};
var amsRegex = /^\\begin{/;
var splitAtDelimiters = function splitAtDelimiters$1(text, delimiters) {
	var index;
	var data = [];
	var regexLeft = /* @__PURE__ */ new RegExp("(" + delimiters.map((x) => escapeRegex(x.left)).join("|") + ")");
	while (true) {
		index = text.search(regexLeft);
		if (index === -1) break;
		if (index > 0) {
			data.push({
				type: "text",
				data: text.slice(0, index)
			});
			text = text.slice(index);
		}
		var i = delimiters.findIndex((delim) => text.startsWith(delim.left));
		index = findEndOfMath(delimiters[i].right, text, delimiters[i].left.length);
		if (index === -1) break;
		var rawData = text.slice(0, index + delimiters[i].right.length);
		var math = amsRegex.test(rawData) ? rawData : text.slice(delimiters[i].left.length, index);
		data.push({
			type: "math",
			data: math,
			rawData,
			display: delimiters[i].display
		});
		text = text.slice(index + delimiters[i].right.length);
	}
	if (text !== "") data.push({
		type: "text",
		data: text
	});
	return data;
};
var renderMathInText = function renderMathInText$1(text, optionsCopy) {
	var data = splitAtDelimiters(text, optionsCopy.delimiters);
	if (data.length === 1 && data[0].type === "text") return null;
	var fragment = document.createDocumentFragment();
	for (var i = 0; i < data.length; i++) if (data[i].type === "text") fragment.appendChild(document.createTextNode(data[i].data));
	else {
		var span = document.createElement("span");
		var math = data[i].data;
		optionsCopy.displayMode = data[i].display;
		try {
			if (optionsCopy.preProcess) math = optionsCopy.preProcess(math);
			katex.render(math, span, optionsCopy);
		} catch (e) {
			if (!(e instanceof katex.ParseError)) throw e;
			optionsCopy.errorCallback("KaTeX auto-render: Failed to parse `" + data[i].data + "` with ", e);
			fragment.appendChild(document.createTextNode(data[i].rawData));
			continue;
		}
		fragment.appendChild(span);
	}
	return fragment;
};
var renderElem = function renderElem$1(elem, optionsCopy) {
	for (var i = 0; i < elem.childNodes.length; i++) {
		var childNode = elem.childNodes[i];
		if (childNode.nodeType === 3) {
			var textContentConcat = childNode.textContent;
			var sibling = childNode.nextSibling;
			var nSiblings = 0;
			while (sibling && sibling.nodeType === Node.TEXT_NODE) {
				textContentConcat += sibling.textContent;
				sibling = sibling.nextSibling;
				nSiblings++;
			}
			var frag = renderMathInText(textContentConcat, optionsCopy);
			if (frag) {
				for (var j = 0; j < nSiblings; j++) childNode.nextSibling.remove();
				i += frag.childNodes.length - 1;
				elem.replaceChild(frag, childNode);
			} else i += nSiblings;
		} else if (childNode.nodeType === 1) (function() {
			var className = " " + childNode.className + " ";
			if (optionsCopy.ignoredTags.indexOf(childNode.nodeName.toLowerCase()) === -1 && optionsCopy.ignoredClasses.every((x) => className.indexOf(" " + x + " ") === -1)) renderElem$1(childNode, optionsCopy);
		})();
	}
};
var renderMathInElement = function renderMathInElement$1(elem, options) {
	if (!elem) throw new Error("No element provided to render");
	var optionsCopy = {};
	for (var option in options) if (options.hasOwnProperty(option)) optionsCopy[option] = options[option];
	optionsCopy.delimiters = optionsCopy.delimiters || [
		{
			left: "$$",
			right: "$$",
			display: true
		},
		{
			left: "\\(",
			right: "\\)",
			display: false
		},
		{
			left: "\\begin{equation}",
			right: "\\end{equation}",
			display: true
		},
		{
			left: "\\begin{align}",
			right: "\\end{align}",
			display: true
		},
		{
			left: "\\begin{alignat}",
			right: "\\end{alignat}",
			display: true
		},
		{
			left: "\\begin{gather}",
			right: "\\end{gather}",
			display: true
		},
		{
			left: "\\begin{CD}",
			right: "\\end{CD}",
			display: true
		},
		{
			left: "\\[",
			right: "\\]",
			display: true
		}
	];
	optionsCopy.ignoredTags = optionsCopy.ignoredTags || [
		"script",
		"noscript",
		"style",
		"textarea",
		"pre",
		"code",
		"option"
	];
	optionsCopy.ignoredClasses = optionsCopy.ignoredClasses || [];
	optionsCopy.errorCallback = optionsCopy.errorCallback || console.error;
	optionsCopy.macros = optionsCopy.macros || {};
	renderElem(elem, optionsCopy);
};

//#endregion
export { renderMathInElement as default };
//# sourceMappingURL=katex_contrib_auto-render.js.map