<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <!-- Favicon lokal memakai laravel.svg -->
  <link rel="icon" type="image/svg+xml" href="/laravel.svg" />
  <link rel="alternate icon" type="image/x-icon" href="/favicon.ico" />
  <title>BC-SQDF API • Laravel + React</title>
  <style>
    :root { color-scheme: light dark; }
    body { margin: 0; font-family: ui-sans-serif, system-ui, -apple-system, Segoe UI, Roboto, Helvetica, Arial, "Apple Color Emoji", "Segoe UI Emoji"; display: grid; min-height: 100vh; place-items: center; background: #0b1021; color: #e6edf3; }
    .card { max-width: 760px; width: 92%; background: #0f172a; border: 1px solid #1e293b; border-radius: 16px; padding: 24px; box-shadow: 0 10px 30px rgba(0,0,0,0.25); }
    .title { display: flex; align-items: center; gap: 12px; font-size: 22px; font-weight: 700; letter-spacing: .2px; }
    .grid { display: grid; grid-template-columns: 1fr 1fr; gap: 16px; margin-top: 18px; }
    .panel { border: 1px dashed #334155; border-radius: 12px; padding: 16px; background: #0b1329; }
    .panel h2 { margin: 0 0 10px; font-size: 18px; }
    .desc { margin-top: 16px; font-size: 14px; color: #cbd5e1; }
    .panel .desc { text-align: center; }
    img.logo { display: block; width: 160px; height: 160px; object-fit: contain; margin: 8px auto; }
    .footer { margin-top: 18px; font-size: 12px; color: #94a3b8; }
    .badge { display:inline-block; padding: 2px 8px; border-radius: 999px; border:1px solid #334155; font-size: 12px; color:#94a3b8; }
  </style>
</head>
<body>
  <div class="card">
    <div class="title">
      <span>BC-SQDF API</span>
      <span class="badge">Laravel + React</span>
    </div>
    <div class="desc">Server backend aktif dan siap menerima request dari SPA frontend. Halaman ini memakai aset lokal dari folder <code>public</code> (tanpa mengambil dari internet).</div>

    <div class="grid">
      <div class="panel">
        <h2>Laravel</h2>
        <!-- Menggunakan laravel.svg dari folder public -->
        <img class="logo" src="/laravel.svg" alt="Laravel Logo" />
        <div class="desc">Framework PHP untuk API dan fitur backend.</div>
      </div>
      <div class="panel">
        <h2>React</h2>
        <!-- Menggunakan react.svg yang ada di backend/public -->
        <img class="logo" src="/react.svg" alt="React Logo" />
        <div class="desc">SPA frontend berjalan di Vite dev server.</div>
      </div>
    </div>

    <div class="footer">Root: <code>/</code> • API: <code>/api/*</code> • Frontend dev: <code>http://localhost:5173/</code></div>
  </div>
</body>
</html>
