<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class GrantAllPermissionsToSuperAdmin extends Seeder
{
    public function run(): void
    {
        // Ensure role exists
        $role = Role::firstOrCreate([
            'name' => 'super_admin',
            'guard_name' => 'web',
        ]);

        // Grant all permissions to super_admin role
        $permissions = Permission::all();
        if ($permissions->isNotEmpty()) {
            $role->syncPermissions($permissions);
        }

        // Ensure Super Admin user has the role
        $user = User::where('email', 'superadmin@gmail.com')->first();
        if ($user) {
            $user->assignRole($role);
        }
    }
}