<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('exam_participants', function (Blueprint $table) {
            if (!Schema::hasColumn('exam_participants', 'exam_password')) {
                $table->string('exam_password', 20)->nullable()->after('password');
            }
        });
    }

    public function down(): void
    {
        Schema::table('exam_participants', function (Blueprint $table) {
            if (Schema::hasColumn('exam_participants', 'exam_password')) {
                $table->dropColumn('exam_password');
            }
        });
    }
};