<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('exam_sessions', function (Blueprint $table) {
            if (!Schema::hasColumn('exam_sessions', 'approved_at')) {
                $table->timestamp('approved_at')->nullable()->after('finished_at');
            }
            if (!Schema::hasColumn('exam_sessions', 'approved_by_user_id')) {
                $table->unsignedBigInteger('approved_by_user_id')->nullable()->after('approved_at');
            }
        });
    }

    public function down(): void
    {
        Schema::table('exam_sessions', function (Blueprint $table) {
            if (Schema::hasColumn('exam_sessions', 'approved_by_user_id')) {
                $table->dropColumn('approved_by_user_id');
            }
            if (Schema::hasColumn('exam_sessions', 'approved_at')) {
                $table->dropColumn('approved_at');
            }
        });
    }
};