<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration {
    public function up(): void
    {
        // Ubah foreign key questions.subject_id dari SET NULL menjadi CASCADE ON DELETE
        $driver = Schema::getConnection()->getDriverName();
        if ($driver === 'sqlite') {
            // Pada SQLite, altering FK kompleks; sebagai fallback, hapus via Eloquent saat Subject dihapus (sudah ditangani di controller bulk)
            return;
        }

        try {
            Schema::table('questions', function (Blueprint $table) {
                // Drop FK lama jika ada
                try { $table->dropForeign(['subject_id']); } catch (\Throwable $e) {}
            });

            Schema::table('questions', function (Blueprint $table) {
                // Tambahkan FK baru dengan cascade delete
                $table->foreign('subject_id')
                    ->references('id')->on('subjects')
                    ->cascadeOnDelete();
            });
        } catch (\Throwable $e) {
            // Beberapa DB membutuhkan nama constraint eksplisit; coba nama default Laravel
            if ($driver === 'mysql') {
                try {
                    DB::statement('ALTER TABLE `questions` DROP FOREIGN KEY `questions_subject_id_foreign`');
                } catch (\Throwable $e2) { /* ignore */ }
                try {
                    DB::statement('ALTER TABLE `questions` ADD CONSTRAINT `questions_subject_id_foreign` FOREIGN KEY (`subject_id`) REFERENCES `subjects`(`id`) ON DELETE CASCADE');
                } catch (\Throwable $e3) { /* ignore */ }
            }
        }
    }

    public function down(): void
    {
        // Kembalikan ke ON DELETE SET NULL jika di-rollback
        $driver = Schema::getConnection()->getDriverName();
        if ($driver === 'sqlite') { return; }

        try {
            Schema::table('questions', function (Blueprint $table) {
                try { $table->dropForeign(['subject_id']); } catch (\Throwable $e) {}
            });

            Schema::table('questions', function (Blueprint $table) {
                $table->foreign('subject_id')
                    ->references('id')->on('subjects')
                    ->nullOnDelete();
            });
        } catch (\Throwable $e) {
            if ($driver === 'mysql') {
                try {
                    DB::statement('ALTER TABLE `questions` DROP FOREIGN KEY `questions_subject_id_foreign`');
                } catch (\Throwable $e2) { /* ignore */ }
                try {
                    DB::statement('ALTER TABLE `questions` ADD CONSTRAINT `questions_subject_id_foreign` FOREIGN KEY (`subject_id`) REFERENCES `subjects`(`id`) ON DELETE SET NULL');
                } catch (\Throwable $e3) { /* ignore */ }
            }
        }
    }
};