<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('exams', function (Blueprint $table) {
            // Tambahkan kolom cohort ujian: sekolah & grade
            $table->unsignedBigInteger('id_school')->nullable()->after('id_subject');
            $table->unsignedBigInteger('id_grade')->nullable()->after('id_school');

            $table->foreign('id_school')->references('id')->on('schools')->onDelete('cascade');
            $table->foreign('id_grade')->references('id')->on('grades')->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::table('exams', function (Blueprint $table) {
            // Hapus foreign key terlebih dahulu
            $table->dropForeign(['id_school']);
            $table->dropForeign(['id_grade']);
            // Lalu hapus kolom
            $table->dropColumn('id_school');
            $table->dropColumn('id_grade');
        });
    }
};