<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('exam_results', function (Blueprint $table) {
            if (!Schema::hasColumn('exam_results', 'correct_orders_essays')) {
                $table->json('correct_orders_essays')->nullable()->after('essay_details');
            }
            if (!Schema::hasColumn('exam_results', 'wrong_orders_essay')) {
                $table->json('wrong_orders_essay')->nullable()->after('correct_orders_essays');
            }
        });
    }

    public function down(): void
    {
        Schema::table('exam_results', function (Blueprint $table) {
            if (Schema::hasColumn('exam_results', 'wrong_orders_essay')) {
                $table->dropColumn('wrong_orders_essay');
            }
            if (Schema::hasColumn('exam_results', 'correct_orders_essays')) {
                $table->dropColumn('correct_orders_essays');
            }
        });
    }
};