<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('scores', function (Blueprint $table) {
            $table->id();
            $table->string('nisn')->nullable();
            $table->string('nama')->nullable();
            // id_pelajaran mereferensi subjects.id (nullable sesuai permintaan)
            $table->foreignId('id_pelajaran')->nullable()->constrained('subjects');
            $table->string('name_pelajaran')->nullable();
            $table->decimal('sts_ganjil', 5, 2)->nullable();
            $table->decimal('sas', 5, 2)->nullable();
            $table->decimal('sts_genap', 5, 2)->nullable();
            $table->decimal('sat', 5, 2)->nullable();
            $table->decimal('us', 5, 2)->nullable();
            $table->decimal('harian', 5, 2)->nullable();
            $table->decimal('keterampilan', 5, 2)->nullable();
            $table->text('keterangan')->nullable();
            $table->string('teacher')->nullable();
            $table->string('tahun', 20)->nullable(); // varchar dan nullable
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('scores');
    }
};