<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('exam_results', function (Blueprint $table) {
            $table->unsignedInteger('essay_correct_count')->default(0)->after('wrong_count');
            $table->unsignedInteger('essay_wrong_count')->default(0)->after('essay_correct_count');
            $table->json('essay_details')->nullable()->after('answers');
        });
    }

    public function down(): void
    {
        Schema::table('exam_results', function (Blueprint $table) {
            $table->dropColumn(['essay_correct_count', 'essay_wrong_count', 'essay_details']);
        });
    }
};