<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('schools', function (Blueprint $table) {
            if (!Schema::hasColumn('schools', 'kode')) {
                $table->string('kode', 100)->nullable()->after('nama');
            }
            if (!Schema::hasColumn('schools', 'kota')) {
                $table->string('kota', 100)->nullable()->after('alamat');
            }
            if (!Schema::hasColumn('schools', 'provinsi')) {
                $table->string('provinsi', 100)->nullable()->after('kota');
            }
            if (!Schema::hasColumn('schools', 'no')) {
                $table->string('no', 100)->nullable()->after('provinsi');
            }
            if (!Schema::hasColumn('schools', 'status')) {
                $table->string('status', 20)->default('Aktif')->after('no');
            }
            if (!Schema::hasColumn('schools', 'note')) {
                $table->text('note')->nullable()->after('status');
            }
        });
    }

    public function down(): void
    {
        Schema::table('schools', function (Blueprint $table) {
            if (Schema::hasColumn('schools', 'note')) { $table->dropColumn('note'); }
            if (Schema::hasColumn('schools', 'status')) { $table->dropColumn('status'); }
            if (Schema::hasColumn('schools', 'no')) { $table->dropColumn('no'); }
            if (Schema::hasColumn('schools', 'provinsi')) { $table->dropColumn('provinsi'); }
            if (Schema::hasColumn('schools', 'kota')) { $table->dropColumn('kota'); }
            if (Schema::hasColumn('schools', 'kode')) { $table->dropColumn('kode'); }
        });
    }
};