<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('exam_participants', function (Blueprint $table) {
            // Token unik untuk login ujian (1 token = 1 device)
            $table->string('login_token', 64)->nullable()->unique()->after('password');
            // Hash fingerprint perangkat yang terikat dengan token ini
            $table->string('bound_device_hash', 255)->nullable()->after('login_token');
            $table->timestamp('device_bound_at')->nullable()->after('bound_device_hash');
        });
    }

    public function down(): void
    {
        Schema::table('exam_participants', function (Blueprint $table) {
            $table->dropColumn(['login_token', 'bound_device_hash', 'device_bound_at']);
        });
    }
};