<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('exams', function (Blueprint $table) {
            if (!Schema::hasColumn('exams', 'code')) {
                $table->string('code', 6)->unique()->after('id_subject');
            }
            if (!Schema::hasColumn('exams', 'duration_minutes')) {
                $table->unsignedInteger('duration_minutes')->after('code');
            }
            if (!Schema::hasColumn('exams', 'scheduled_at')) {
                $table->dateTime('scheduled_at')->after('duration_minutes');
            }
        });
    }

    public function down(): void
    {
        Schema::table('exams', function (Blueprint $table) {
            if (Schema::hasColumn('exams', 'scheduled_at')) {
                $table->dropColumn('scheduled_at');
            }
            if (Schema::hasColumn('exams', 'duration_minutes')) {
                $table->dropColumn('duration_minutes');
            }
            if (Schema::hasColumn('exams', 'code')) {
                $table->dropUnique(['code']);
                $table->dropColumn('code');
            }
        });
    }
};