<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('classes', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('id_school');
            $table->unsignedBigInteger('id_grade');
            $table->timestamps();

            $table->foreign('id_school')
                ->references('id')->on('schools')
                ->onDelete('cascade');

            $table->foreign('id_grade')
                ->references('id')->on('grades')
                ->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('classes');
    }
};