<?php

return [
    // Terapkan CORS pada route API
    'paths' => ['api/*', 'sanctum/csrf-cookie'],

    // Izinkan semua metode HTTP
    'allowed_methods' => ['*'],

    // Izinkan origin dev server frontend & domain produksi
    'allowed_origins' => [
        // Production domain
        'https://learning.sqdf.sch.id',
        'http://learning.sqdf.sch.id',
    ],

    // Pola origin untuk development (menerima semua port localhost/127.0.0.1)
    'allowed_origins_patterns' => [
        '/^http:\/\/localhost:\\d+$/',
        '/^http:\/\/127\\.0\\.0\\.1:\\d+$/',
    ],

    // Izinkan semua header
    'allowed_headers' => ['*'],

    // Header yang diekspos ke browser
    'exposed_headers' => ['Authorization', 'X-Requested-With'],

    // Durasi preflight
    'max_age' => 0,

    // Dukung kredensial (cookie/session)
    'supports_credentials' => true,
];