<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Subject extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'code',
        'description',
        'id_school',
        'id_grade',
        'created_by',
    ];

    public function questions()
    {
        return $this->hasMany(Question::class, 'subject_id');
    }

    public function owner()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    protected static function booted()
    {
        // Pastikan saat Subject dihapus, semua Question dengan subject_id ini ikut terhapus.
        // Ini melengkapi constraint DB (ON DELETE CASCADE) dan menjadi fallback bila DB tidak mendukung.
        static::deleting(function (Subject $subject) {
            try {
                $subject->questions()->delete();
            } catch (\Throwable $e) {
                // Abaikan agar proses penghapusan subject tetap lanjut meski terjadi error
            }
        });
    }
}