<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Score extends Model
{
    use HasFactory;

    protected $fillable = [
        'nisn',
        'nama',
        'id_pelajaran',
        'name_pelajaran',
        'sts_ganjil',
        'sas',
        'sts_genap',
        'sat',
        'us',
        'harian',
        'keterampilan',
        'keterangan',
        'teacher',
        'tahun',
    ];

    public function subject()
    {
        return $this->belongsTo(Subject::class, 'id_pelajaran');
    }
}