<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SchoolClass extends Model
{
    use HasFactory;

    protected $table = 'classes';

    protected $fillable = ['id_school', 'id_grade', 'name'];

    public function school()
    {
        return $this->belongsTo(School::class, 'id_school');
    }

    public function grade()
    {
        return $this->belongsTo(Grade::class, 'id_grade');
    }

    public function participants()
    {
        return $this->hasMany(ExamParticipant::class, 'id_kelas');
    }
}