<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Question extends Model
{
    use HasFactory;

    protected $fillable = [
        'text', 'option_a', 'option_b', 'option_c', 'option_d', 'option_e', 'key_answer', 'image_path', 'created_by', 'subject_id'
    ];

    // Tambahkan atribut terhitung untuk membantu UI membedakan jenis soal
    protected $appends = ['status'];

    public function subject()
    {
        return $this->belongsTo(Subject::class);
    }

    // Mengembalikan 'Essay' jika opsi B-D kosong atau '-', atau key_answer bukan A-E
    public function getStatusAttribute(): string
    {
        $isBlankOrDash = function ($v): bool {
            $v = trim((string) $v);
            return $v === '' || $v === '-';
        };

        $b = $this->option_b;
        $c = $this->option_c;
        $d = $this->option_d;

        if ($isBlankOrDash($b) && $isBlankOrDash($c) && $isBlankOrDash($d)) {
            return 'Essay';
        }

        $key = strtoupper(trim((string) $this->key_answer));
        if (!in_array($key, ['A', 'B', 'C', 'D', 'E'], true)) {
            return 'Essay';
        }

        return 'Pilihan';
    }
}