<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Laravel\Sanctum\HasApiTokens;

class ExamParticipant extends Authenticatable
{
    use HasApiTokens, HasFactory;

    protected $fillable = [
        'nisn', 'nama', 'id_kelas', 'name_class', 'jurusan',
        'password', 'exam_password', 'last_activity',
        // Field login token & binding perangkat
        'login_token', 'bound_device_hash', 'device_bound_at',
    ];

    protected $hidden = ['password', 'exam_password', 'remember_token', 'login_token', 'bound_device_hash'];

    protected $casts = [
        'last_activity' => 'datetime',
        'device_bound_at' => 'datetime',
    ];

    public function kelas()
    {
        return $this->belongsTo(SchoolClass::class, 'id_kelas');
    }
}